/* 
 * Receive Widget
 * Copyright (C) 2006 Vojtech Bubnik <bubnikv@seznam.cz>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#pragma once

#include <windows.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

extern const TBYTE WIN32CLASS_RXVIEW[];

typedef struct _RxView		RxView;

typedef enum {
	RXVIEW_CHUNK_TEXT,
	RXVIEW_CHUNK_TAPE,
	RXVIEW_CHUNK_IMAGE,
} RxViewChunkType;

typedef struct {
	/// Type of the chunk (text, tape, image)
	RxViewChunkType	nType;
	/// Start of the chunk data
	int				iData;
	/// First row of this chunk. Depends on type of chunk, view width.
	int				iRow;
	/// Start of the formating data.
	int				iFormat;
} RxViewChunk;

struct _RxView
{
	HWND			hWnd;
//	HBITMAP		hBitmap;
//	HDC			hBitmapDC;
//	UCHAR*		pBitmapBits;

	RxViewChunk	   *pChunks;
	int				iChunkFirst;
	int				nChunksLen;
	/// Size of pChunks. Its length is power of 2.
	int				nChunksSize;
	BOOL			bLastChunkClosed;

	UCHAR		   *pData;
	/// Allocated 
	int				nDataLen;
	/// Size of pData. Its length is power of 2.
	int				nDataSize;
	int				nDataMax;

	UCHAR		   *pFormat;
	int				nFormatLen;
	/// Size of pFormat. Its length is power of 2.
	int				nFormatSize;

	HFONT			hFont;
	/// Height of the font including space between rows
	int				nFontHeight;
	int				nFontAscent;
	/// Number of pixel rows of the whole word wrapped buffer.
	int				nRows;
	/// First visible pixel row.
	int				iRowFirst;
	/// Width and height of the screen
	int				nRowsScreen;
	int				nColumnsScreen;
	/// First pixel column displayed. Shall be 0 for wrapped text or paper tape.
	/// Makes sense only for pictures.
	int				iColumnFirst;

	/// Parameters to display the FELDHELL tapes
	int				nTapeRows;
	BOOL			bTapeTwoTimes;
	BOOL			bTapeDoubleWidth;
	BOOL			bTapeDrawSeparator;
	int				nTapeWrapDuplicatedColumns;

	HBITMAP			hTapeBitmap;
	UCHAR		   *pTapeBitmapBits;
	int				nTapeRowInc;

	/// Indicate to scroll by every new line.
	BOOL			bIsAtEnd;
};

extern ATOM		rxview_register_class(HINSTANCE hInstance);
extern RxView*	rxview_new();
extern void		rxview_free(RxView *wf);

BOOL			rxview_init(RxView *wf);
BOOL			rxview_create(RxView *wf, DWORD dwStyle,
	int x, int y, int nWidth, int nHeight, HWND hWndParent, HANDLE hInstance);
void			rxview_destroy(RxView *wf);

void			rxview_add_text(RxView *pThis, int type, TCHAR *data, int len);
void			rxview_add_tape(RxView *pThis, int type, UCHAR *data, int len);

#ifdef __cplusplus
}
#endif /* __cplusplus */
