/*
 *    qsodata.h  --  QSO data area functions
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef	_QSODATA_H
#define	_QSODATA_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "trx.h"
// #include <time.h>

typedef struct _QsoInfo		QsoInfo;

struct _QsoInfo
{
	TCHAR	   *strCall;
	TCHAR	   *strName;
	TCHAR	   *strQth;
	TCHAR	   *strLoc;
	TCHAR	   *strBand;
	TCHAR	   *strTXRst;
	TCHAR	   *strRXRst;
	TCHAR	   *strNotes;
//	time_t		starttime;
};

#define QSOINFO_ARRAY ((TCHAR**)info)
#define QSOINFO_LEN   8

extern QsoInfo*		qsodata_new();
extern void			qsodata_free(QsoInfo *info);

extern void			qsodata_init(QsoInfo *info);
extern void			qsodata_destroy(QsoInfo *info);

extern void			qsodata_clear(QsoInfo *info);
extern BOOL			qsodata_edit(QsoInfo *info);
extern BOOL			qsodata_send2mobilelog2(QsoInfo *info);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _QSODATA_H */
