/*
 *    qsodata.c  --  QSO data area functions
 *
 *    Copyright (C) 2001, 2002, 2003, 2004
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <windows.h>
#include <tchar.h>

#include <string.h>
#include <stdio.h>
#include <ctype.h>

#ifdef WIN32_PLATFORM_PSPC
#include "Aygshell.h"
#endif /* WIN32_PLATFORM_PSPC */

#include "qsodata.h"
#include "dlggen.h"
#include "../resource.h"
#include "../misc/winsupport.h"
#include "main.h"

#define QSOINFO_ARRAY ((TCHAR**)info)
#define QSOINFO_LEN   8

TCHAR *g_aQsoInfoLabels[] = {
	_T("Call"),
	_T("Name"),
	_T("QTH"),
	_T("Loc"),
	_T("Band"),
	_T("TX RST"),
	_T("RX RST"),
	_T("Notes")
};

static QsoInfo *s_pQsoEdited = 0;

extern HINSTANCE	g_hInst;
extern HWND			s_hWndMain;


QsoInfo* qsodata_new()
{
	QsoInfo *info = (QsoInfo*)malloc(sizeof(QsoInfo));
	if (info == 0)
		return 0;
	qsodata_init(info);
	return info;
}

void qsodata_free(QsoInfo *info)
{
	qsodata_destroy(info);
	free(info);
}

void qsodata_init(QsoInfo *info)
{
	memset(info, 0, sizeof(QsoInfo));
	qsodata_clear(info);
}

void qsodata_destroy(QsoInfo *info)
{
	int i;
	for (i = 0; i < QSOINFO_LEN; ++ i)
		free(QSOINFO_ARRAY[i]);
	memset(info, 0, sizeof(QsoInfo));
}

void qsodata_clear(QsoInfo *info)
{
	int i;
	for (i = 0; i < QSOINFO_LEN; ++ i) {
		free(QSOINFO_ARRAY[i]);
		QSOINFO_ARRAY[i] = _tcsdup(_T(""));
	}
//	info->starttime = 0;
}

#define ID_LABEL	101
#define ID_ENTRY	201

INT_PTR CALLBACK qsoinfo_dlgproc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int res = dlggen_dlgproc(hwnd, uMsg, wParam, lParam);
	if (res >= 0)
		return res;

	if (uMsg == WM_COMMAND &&
        (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL || LOWORD(wParam) == ID_MOBILELOG2)) {
		QsoInfo *info = s_pQsoEdited;
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == ID_MOBILELOG2) {
			int i;
			for (i = 0; i < QSOINFO_LEN; ++ i) {
				HWND hWnd  = GetDlgItem(hwnd, ID_ENTRY + i);
				int  nLen  = GetWindowTextLength(hWnd);
				QSOINFO_ARRAY[i] = (TCHAR*)realloc(
					QSOINFO_ARRAY[i], (nLen + 1) * sizeof(TCHAR));
				GetWindowText(hWnd, QSOINFO_ARRAY[i], nLen + 1);
			}
		}
		if (LOWORD(wParam) == ID_MOBILELOG2) {
			if (qsodata_send2mobilelog2(info)) {
				qsodata_clear(info);
				EndDialog(hwnd, TRUE);
			}
		} else
			EndDialog(hwnd, LOWORD(wParam) == IDOK);
		return 0;
	}

    return FALSE;
}

BOOL qsodata_edit(QsoInfo *info)
{
	DlgTemplate tmpl;
	int         i;

	s_pQsoEdited = info;

	dlggen_create(&tmpl, _T("QSO"), DLGGEN_WINDOW_STYLE,
		CW_USEDEFAULT, CW_USEDEFAULT, 110, 120, _T("Tahoma"), 9);
	tmpl.nEntries	    = QSOINFO_LEN;
	tmpl.nEntryFirstID  = ID_ENTRY;
	tmpl.nMenuID		= IDR_MENUBAR_QSO;
	for (i = 0; i < QSOINFO_LEN; ++ i) {
		dlggen_add_static(&tmpl, g_aQsoInfoLabels[i],
			WS_CHILD | WS_VISIBLE | SS_RIGHT, 0, 2, 2 + i * 12, 30, 10, ID_LABEL + i);
		dlggen_add_edit_box(&tmpl, QSOINFO_ARRAY[i], DLGGEN_ENTRY_STYLE, DLGGEN_ENTRY_STYLE_EX,
			34, 2 + i * 12, 101, 10, ID_ENTRY + i);
	}

	dlggen_add_okcancel(&tmpl);
	return dlggen_dialog_box(&tmpl, g_hInst, s_hWndMain, qsoinfo_dlgproc) == IDOK;
}

BOOL qsodata_send2mobilelog2(QsoInfo *info)
{
	HKEY	hKey;
	DWORD	dwType   = REG_SZ;
	DWORD	dwSize   = MAX_PATH;
	TCHAR	szMobile2Path[MAX_PATH];
	TCHAR	szMobile2Exe[MAX_PATH];
	TCHAR	szLogPath[MAX_PATH];
	BOOL	bRes     = FALSE;
	HANDLE  hFile    = 0;
	TCHAR  *pMode	 = trx_mode_names[s_aChannels[s_iChannelActive]->mode];
	int     iLine;
	TCHAR  *aLines[] = { 
		info->strCall, 
		info->strName,
		info->strQth,
		info->strTXRst,
		info->strRXRst,
		pMode,
		info->strNotes
	};

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("SOFTWARE\\Apps\\N0HR MobileLog2"),
			0, KEY_READ, &hKey) != ERROR_SUCCESS)
		return FALSE;

	bRes     = RegQueryValueEx(hKey, _T("InstallDir"), 0, &dwType, (LPBYTE)szMobile2Path, &dwSize) == ERROR_SUCCESS;
	dwSize   = MAX_PATH;
	bRes    |= RegQueryValueEx(hKey, _T("ProgramName"), 0, &dwType, (LPBYTE)szMobile2Exe, &dwSize) == ERROR_SUCCESS;
	RegCloseKey(hKey);

	if (! bRes)
		return FALSE;

	_tcscpy(szLogPath, szMobile2Path);
	_tcscat(szLogPath, _T("\\pocketdigi_log.txt"));

	hFile = CreateFile(szLogPath, GENERIC_WRITE, FILE_SHARE_READ, 0,
		CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
	if (hFile == 0)
		return FALSE;

	for (iLine = 0; iLine < 7; ++ iLine) {
		int    nLength  = _tcslen(aLines[iLine]);
		char  *pText    = (char*)_tcsdup(aLines[iLine]);
		char   aCRLF[3] = "\r\n";
		DWORD  nWritten;
#ifdef _UNICODE
		int i;
		for (i = 1; i < nLength; ++ i)
   			pText[i] = pText[i << 1];
#endif
		WriteFile(hFile, (void*)pText, nLength, &nWritten, 0);
		WriteFile(hFile, (void*)aCRLF, 2, &nWritten, 0);
		free(pText);
	}
	CloseHandle(hFile);

    {
		SHELLEXECUTEINFO lpExecInfo;
		memset(&lpExecInfo, 0, sizeof(SHELLEXECUTEINFO));
		lpExecInfo.cbSize		= sizeof(SHELLEXECUTEINFO);
		lpExecInfo.lpFile		= szMobile2Exe;
		lpExecInfo.lpDirectory	= szMobile2Path;
		lpExecInfo.nShow		= SW_SHOWNORMAL;
		lpExecInfo.fMask		= SEE_MASK_NOCLOSEPROCESS;
		ShellExecuteEx(&lpExecInfo);
	}

	return TRUE;
}
