// #include "../StdAfx.h"

#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include <tchar.h>
#include <commctrl.h>

#include "main.h"
#include "waterfall.h"
#include "dlggen.h"
#include "../misc/int_fft.h"
#include "ColorTable.h"
#include "trx.h"
#include "macro.h"
#include "cat.h"
#include "trxctrl.h"
#include "stninfo.h"
#include "devinfo.h"
#include "qsodata.h"
#include "../rtty/rtty.h"
#include "sndmodem.h"
#include "waterfall.h"
#include "sliderpopup.h"
#include "../resource.h"

#ifdef _WIN32_WCE
#include "../stdafx-ce.h"
#else
#include <Mmsystem.h>
#endif /* _WIN32_WCE */

#include "Version.h"

#define MAX_LOADSTRING 100

#define MENU_HEIGHT 26

#ifdef _WIN32_WCE
#ifdef WIN32_PLATFORM_PSPC
#include <AYGShell.h>
#endif /* WIN32_PLATFORM_PSPC */
#include <Notify.h>
#endif /* _WIN32_WCE */

#ifndef _WIN32_WCE
#include "dbgwaterfall.h"
#endif /* _WIN32_WCE */


// Global Variables:
extern "C" {
HINSTANCE			g_hInst			 = 0;	// The current instance
HWND				s_hWndMain		 = 0;	// Main window
HWND				s_hWndCommandBar = 0;	// The command bar handle
HWND				s_hWndToolbar	 = 0;
TCHAR			   *g_strSoftwareVersion = _T("PocketDigi ") VERSION _T(" by OK1IAK, derived from gMFSK by OH2BNS");
UINT				s_iTXMode		 = 0;
BOOL				s_bEnableMenuUpdate = TRUE;
};

TCHAR				szTitle[]       = _T("PocketDigi"); // The title bar text
TCHAR				szWindowClass[] = _T("POCKETDIGI"); // The window class name

// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass	(HINSTANCE hInstance, LPTSTR szWindowClass);
BOOL				InitInstance	(HINSTANCE, int);
LRESULT CALLBACK	WndProc			(HWND, UINT, WPARAM, LPARAM);

extern "C" {
SndModem			s_SndModem;
Waterfall			s_Waterfall;
}
SliderPopup			s_SliderPopup;

#ifndef _WIN32_WCE
extern "C" {
DbgWaterfall		s_DbgWaterfall;
}
#endif /* _WIN32_WCE */

Trx*				s_aChannels[CHANNELS_MAX];
int					s_iChannelActive	  = -1;
HMENU				s_hMenuTools		  = 0;
HMENU				s_hMenuWaterfall	  = 0;
HMENU				s_hMenuWaterfallZoom  = 0;
HMENU				s_hMenuWaterfallSpeed = 0;
HMENU				s_hMenuChannels		  = 0;
HMENU				s_hMenuMacros		  = 0;
HMENU				s_hMenuCAT			  = 0;

#define WM_USER_WAKEUP	(WM_USER + 1)

static void DoLayout()
{
	RECT rectWnd, rectWaterfall, rect;
	int  i;
	int  iBottom;

	if (s_hWndMain == 0 || s_Waterfall.hWnd == 0 || s_iChannelActive == -1)
		return;

	GetClientRect(s_hWndMain, &rectWnd);
	GetClientRect(s_Waterfall.hWnd, &rectWaterfall);

#ifdef _WIN32_WCE
  #ifndef WIN32_PLATFORM_PSPC
	rectWaterfall.top = CommandBar_Height(s_hWndCommandBar);
  #endif /* WIN32_PLATFORM_PSPC */
#endif /* _WIN32_WCE */

	rectWaterfall.bottom = rectWaterfall.top + (rectWnd.bottom - rectWaterfall.top) / 3;
	MoveWindow(s_Waterfall.hWnd, rectWaterfall.left, rectWaterfall.top,
		rectWnd.right - rectWnd.left, rectWaterfall.bottom - rectWaterfall.top, TRUE);

	// Rest of the screen after waterfall resize
	rect.left	= rectWnd.left;
	rect.right	= rectWnd.right;
	rect.top	= rectWaterfall.bottom;

	iBottom     = rectWnd.bottom - 80;
	for (i = 0; i < CHANNELS_MAX; ++ i)
		if (i != s_iChannelActive && s_aChannels[i] != 0) {
			rect.bottom	= rectWnd.bottom;
			if (! trx_layout(s_aChannels[i], LAYOUT_SINGLELINE, &rect) ||
				rect.bottom > iBottom) {
				ShowWindow(s_aChannels[i]->hWnd, SW_HIDE);
				break;
			}
			MoveWindow(s_aChannels[i]->hWnd, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, FALSE);
			ShowWindow(s_aChannels[i]->hWnd, SW_SHOW);
			InvalidateRect(s_aChannels[i]->hWnd, 0, false);
			rect.top = rect.bottom;
		}
	for (; i < CHANNELS_MAX; ++ i)
		if (i != s_iChannelActive && s_aChannels[i] != 0)
			ShowWindow(s_aChannels[i]->hWnd, SW_HIDE);

	rect.bottom	= rectWnd.bottom;
#ifdef _WIN32_WCE
  #ifdef WIN32_PLATFORM_PSPC
	{
		SIPINFO sipinfo;
		sipinfo.cbSize = sizeof(sipinfo);
		SHSipInfo(SPI_GETSIPINFO, 0, &sipinfo, 0);
		trx_layout(s_aChannels[s_iChannelActive], sipinfo.fdwFlags ? LAYOUT_TRX : LAYOUT_RCV, &rect);
	}
  #else /* WIN32_PLATFORM_PSPC */
	trx_layout(s_aChannels[s_iChannelActive], LAYOUT_TRX, &rect);
  #endif /* WIN32_PLATFORM_PSPC */
#else /* _WIN32_WCE */
	trx_layout(s_aChannels[s_iChannelActive], LAYOUT_TRX, &rect);
#endif /* _WIN32_WCE */
	MoveWindow(s_aChannels[s_iChannelActive]->hWnd, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, TRUE);
	ShowWindow(s_aChannels[s_iChannelActive]->hWnd, SW_SHOW);
	InvalidateRect(s_aChannels[s_iChannelActive]->hWnd, 0, true);
}

void StoreExePathToRegistry(const TCHAR *path)
{
	HKEY   hKey          = 0;
	DWORD  dwDisposition = 0;
	DWORD  dwType	     = REG_SZ;
	DWORD  dwSize        = 0;
	TCHAR *pathCopy		 = _tcsdup(path);
	int	   nLen			 = _tcslen(path);
	int	   i				= 0;

	for (i = nLen - 1; i > 0; -- i)
		if (pathCopy[i] == '\\')
			break;

	if (i == 0)
		goto end; // path separator was not found
	
	if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\OK1IAK\\PocketDigi"), 0, 0,
		REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &hKey, &dwDisposition) != ERROR_SUCCESS)
		goto end;

	pathCopy[i] = 0;
	RegSetValueEx(hKey, _T("InstallPath"), 0, REG_SZ,
		(LPBYTE)pathCopy, (i + 1) * sizeof(TCHAR));
	RegSetValueEx(hKey, _T("ProgramName"), 0, REG_SZ,
		(LPBYTE)(pathCopy + i + 1), (nLen - i) * sizeof(TCHAR));

	RegCloseKey(hKey);

end:
	free(pathCopy);
}

#ifdef _WIN32_WCE
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
#else /* _WIN32_WCE */
int WINAPI SimWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
#endif /* _WIN32_WCE */
{
	TCHAR exepath[MAX_PATH];

	GetModuleFileName(0, exepath, MAX_PATH);

	s_hWndMain = FindWindow(szWindowClass, szTitle);
	if (s_hWndMain !=0) {
#ifdef _WIN32_WCE
		if (_tcscmp(lpCmdLine, APP_RUN_AFTER_WAKEUP) == 0) {
			SendMessage(s_hWndMain, WM_USER_WAKEUP, 0, 0);
			return 0;
		}
#endif /* _WIN32_WCE */
		SetForegroundWindow((HWND)((ULONG)s_hWndMain|1)); // the |1 will activate any owned windows
		if (lpCmdLine != 0 && _tcslen(lpCmdLine) != 0) {
			COPYDATASTRUCT cs; 
			cs.dwData = 0; 
			cs.cbData = 2 + 2 * _tcslen(lpCmdLine); 
			cs.lpData = lpCmdLine;
			SendMessage(s_hWndMain, WM_COPYDATA, NULL, (LPARAM)&cs);
		}
		else 
			SendMessage(s_hWndMain, WM_APP, 0, 0);
		return 0;
	}

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
		return FALSE;
  
#ifdef _WIN32_WCE
/*
	{//FIXME Idle measurement 
		typedef DWORD (_stdcall *GetIdleTimeProc) (void);
		// get the pointer to the function
		GetIdleTimeProc GetIdleTime = (GetIdleTimeProc) GetProcAddress(LoadLibrary(_T("coredll.dll")), _T("GetIdleTime"));
		DWORD dwStartTick, dwIdleSt, dwStopTick, dwIdleEd;
		double PercentIdle;

		dwStartTick = GetTickCount();
		dwIdleSt = GetIdleTime();
		Sleep(2000);
		dwStopTick = GetTickCount();
		dwIdleEd = GetIdleTime();
		PercentIdle = ((100 * (dwIdleEd - dwIdleSt)) / (dwStopTick - dwStartTick));
		printf("Percent Idle: %f\r\n", PercentIdle);
	}
*/

	{ // Main message loop:
		MSG msg;
		CeRunAppAtEvent(exepath, NOTIFICATION_EVENT_WAKEUP);
		StoreExePathToRegistry(exepath);
		while (GetMessage(&msg, NULL, 0, 0)) {
			if (! sliderpopup_pretranslate_message(&s_SliderPopup, &msg) &&
				! main_pretranslate_message(&msg)) {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		CeRunAppAtEvent(exepath, NOTIFICATION_EVENT_NONE);
		return msg.wParam;
	}
#else
	StoreExePathToRegistry(exepath);
	return 0;
#endif /* _WIN32_WCE */
}

//
//  FUNCTION: MyRegisterClass()
ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
  WNDCLASS	wc;
  
  wc.style			= CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc	= (WNDPROC)WndProc;
  wc.cbClsExtra		= 0;
  wc.cbWndExtra		= 0;
  wc.hInstance		= hInstance;
  wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDR_MAINFRAME));
  wc.hCursor		= 0;
  wc.hbrBackground	= (HBRUSH) GetStockObject(WHITE_BRUSH);
  wc.lpszMenuName	= 0;
  wc.lpszClassName	= szWindowClass;
  
  return RegisterClass(&wc);
}

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd;
	int		nStyle = 0;

	g_hInst = hInstance;		// Store instance handle in our global variable

	// Initialize classes
	MyRegisterClass(hInstance, szWindowClass);
	waterfall_register_class(hInstance);
	sliderpopup_register_class(g_hInst);
	trx_register_classes(g_hInst);
#ifdef USE_RXVIEW
	rxview_register_class(g_hInst);
#endif /* USE_RXVIEW */

	memset(s_aChannels, 0, sizeof(Trx*) * CHANNELS_MAX);

	nStyle = WS_VISIBLE;
#ifdef _WIN32_WCE
  #ifndef WIN32_PLATFORM_PSPC
//	nStyle |= WS_OVERLAPPED;
  #endif /* WIN32_PLATFORM_PSPC */
#else /* _WIN32_WCE */
	nStyle |= WS_OVERLAPPEDWINDOW;
	s_hMenuChannels			= CreatePopupMenu();
	s_hMenuMacros			= CreatePopupMenu();
	s_hMenuCAT				= CreatePopupMenu();

//	dbgwaterfall_register_class(hInstance);
//	dbgwaterfall_init(&s_DbgWaterfall);	
#endif /* _WIN32_WCE */

	hWnd = CreateWindow(szWindowClass, szTitle, nStyle,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);
	s_hWndMain = hWnd;

	sndmodem_init(&s_SndModem, s_hWndMain, s_aChannels, CHANNELS_MAX, &s_Waterfall);
	trxctrl_init(&g_TrxCtrl);
	fix_fft_initialize();
	waterfall_init(&s_Waterfall);
	macro_load();
	stninfo_load();
	waterfall_create(&s_Waterfall, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE, 0, 0, 240, 100, hWnd, hInstance);
	sliderpopup_init(&s_SliderPopup);

#ifndef _WIN32_WCE
//	dbgwaterfall_create(&s_DbgWaterfall, WS_CAPTION | WS_POPUPWINDOW  | WS_CLIPSIBLINGS | WS_VISIBLE, 
//		0, 0, 2200, 300, 0, hInstance);
#endif /* _WIN32_WCE */

	if (! hWnd)
		return FALSE;

    DoLayout();
	sndmodem_start_recording(&s_SndModem);
	SetFocus(s_aChannels[s_iChannelActive]->hWndSend);
	return TRUE;
}

#ifdef _WIN32_WCE
void trx_set_scope(int *data, int len, BOOL autoscale)
{
/*
	HDC hDC = ::GetDC(s_hWndMain);
	RECT rect;
	rect.left   = 0;
	rect.top    = 151;
	rect.right  = 16;
	rect.bottom = 180;
	::ScrollWindowEx(s_hWndMain, 16, 0, &rect, 0, 0, 0, 0);
	for (UINT i = 0; i < 16; ++ i)
		::SetPixel(hDC, i, 180 - (data[i] >> 9), RGB(0, 0, 0));
	::ReleaseDC(s_hWndMain, hDC);
	*/
//FIXME
//	Miniscope *m = MINISCOPE(lookup_widget(appwindow, "miniscope"));
//	miniscope_set_data(m, data, len, autoscale);
}
#endif /* _WIN32_WCE */

extern "C" void UpdateMenuChannels()
{
	int   i;
	HMENU hMenuModes = 0;
	Trx  *pChannel   = (s_iChannelActive == -1) ? 0 : s_aChannels[s_iChannelActive];
	TCHAR buf[256];
	int   nEnabledOnRX = (s_iTXMode == 0) ? MF_ENABLED : MF_GRAYED;
	int   nChannels	 = 0;

	if (s_hMenuChannels == 0)
		return;

	// Remove all items

	for (i = 0; i < 30; ++ i)
		if (! DeleteMenu(s_hMenuChannels, 0, MF_BYPOSITION))
			break;

	for (i = 0; i < CHANNELS_MAX; ++ i)
		if (s_aChannels[i] != 0) {
			TCHAR strChannel[10];
			_tcscpy(strChannel, _T("Channel 0"));
			strChannel[8] += i;
			AppendMenu(s_hMenuChannels, nEnabledOnRX | MF_STRING, ID_CHANNEL0 + i, strChannel);
			++ nChannels;
		}

	CheckMenuRadioItem(s_hMenuChannels, ID_CHANNEL0, ID_CHANNEL0 + CHANNELS_MAX - 1,
		ID_CHANNEL0 + s_iChannelActive, MF_BYCOMMAND);

	hMenuModes = CreatePopupMenu();
	AppendMenu(hMenuModes, nEnabledOnRX | MF_STRING, ID_MODE_BPSK31,	_T("BPSK31"));
	AppendMenu(hMenuModes, nEnabledOnRX | MF_STRING, ID_MODE_QPSK31,	_T("QPSK31"));
	AppendMenu(hMenuModes, nEnabledOnRX | MF_STRING, ID_MODE_BPSK63,	_T("BPSK63"));
	AppendMenu(hMenuModes, nEnabledOnRX | MF_STRING, ID_MODE_RTTY,		_T("RTTY")); 
	AppendMenu(hMenuModes, nEnabledOnRX | MF_STRING, ID_MODE_CW,		_T("CW"));
	AppendMenu(hMenuModes, nEnabledOnRX | MF_STRING, ID_MODE_MFSK16,	_T("MFSK16"));
	AppendMenu(hMenuModes, nEnabledOnRX | MF_STRING, ID_MODE_THROB,		_T("THROB"));
	AppendMenu(hMenuModes, nEnabledOnRX | MF_STRING, ID_MODE_THROBX,	_T("THROBX"));
	AppendMenu(hMenuModes, nEnabledOnRX | MF_STRING, ID_MODE_FELDHELL,	_T("FELDHELL"));
	AppendMenu(hMenuModes, nEnabledOnRX | MF_STRING, ID_MODE_OLIVIA,	_T("OLIVIA"));
	AppendMenu(hMenuModes, nEnabledOnRX | MF_STRING, ID_MODE_CONTESTIA,	_T("CONTESTIA"));
	AppendMenu(hMenuModes, nEnabledOnRX | MF_STRING, ID_MODE_RTTYM,		_T("RTTYM"));
	AppendMenu(hMenuModes, MF_GRAYED  | MF_STRING, ID_MODE_AX25,		_T("AX25"));
//	AppendMenu(hMenuModes, nEnabledOnRX | MF_STRING, ID_MODE_MFSK8,		_T("MFSK8"));

	CheckMenuRadioItem(hMenuModes, ID_MODE_BPSK31, ID_MODE_AX25,
		ID_MODE_BPSK31 + pChannel->mode, MF_BYCOMMAND);

	AppendMenu(s_hMenuChannels, MF_ENABLED   | MF_SEPARATOR, 0, 0);
	AppendMenu(s_hMenuChannels, ((s_iTXMode == 0 && nChannels < CHANNELS_MAX) ? MF_ENABLED : MF_GRAYED) | MF_STRING, 
		ID_CHANNEL_NEW,			 _T("New Channel"));
	AppendMenu(s_hMenuChannels, ((s_iTXMode == 0 && nChannels > 1) ? MF_ENABLED : MF_GRAYED) | MF_STRING, 
		ID_CHANNEL_CLOSE,		 _T("Close Channel"));
	AppendMenu(s_hMenuChannels, ((nChannels > 1) ? MF_ENABLED : MF_GRAYED) | MF_STRING, 
		ID_CHANNEL_CLOSE_OTHERS, _T("Close Others"));
	AppendMenu(s_hMenuChannels, MF_ENABLED   | MF_SEPARATOR, 0, 0);
	if (pChannel->pQso->strCall != 0 && _tcsicmp(pChannel->pQso->strCall, _T("")))
		_stprintf(buf, _T("QSO:\t%s"), pChannel->pQso->strCall);
	else
		_stprintf(buf, _T("QSO:\tNone"));
	AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_CHANNEL_QSOEDIT, buf);

	AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_LOGGING, _T("Logging"));
	if (pChannel->log.hFile)
		CheckMenuItem(s_hMenuChannels, ID_LOGGING, MF_BYCOMMAND | MF_CHECKED);

	_stprintf(buf, _T("Mode:\t%s"), trx_mode_names[pChannel->mode]);
	AppendMenu(s_hMenuChannels, nEnabledOnRX | MF_STRING | MF_POPUP,  (UINT_PTR)hMenuModes, buf);

	if (pChannel->mode == MODE_THROB || pChannel->mode == MODE_THROBX) {
		HMENU hMenuSubmodes = CreatePopupMenu();
		for (i = ID_SUBMODE_TPS1; i < ID_SUBMODE_TPS4; ++ i)
			AppendMenu(hMenuSubmodes, nEnabledOnRX | MF_STRING, i, submode_throb_names[i - ID_SUBMODE_TPS1]);
		if (pChannel->mode == MODE_THROB)
			AppendMenu(hMenuSubmodes, nEnabledOnRX | MF_STRING, i, submode_throb_names[i - ID_SUBMODE_TPS1]);
		CheckMenuRadioItem(hMenuSubmodes, ID_SUBMODE_TPS1, ID_SUBMODE_TPS4,
			pChannel->submode, MF_BYCOMMAND);
		_stprintf(buf, _T("Submode:\t%s"), submode_throb_names[pChannel->submode - ID_SUBMODE_TPS1]);
		AppendMenu(s_hMenuChannels, nEnabledOnRX | MF_STRING | MF_POPUP,  (UINT_PTR)hMenuSubmodes, buf);
	} else if (pChannel->mode == MODE_OLIVIA || pChannel->mode == MODE_CONTESTIA || pChannel->mode == MODE_RTTYM) {
		HMENU hMenuSubmodes = CreatePopupMenu();
		for (i = ID_SUBMODE_4_250; i <= ID_SUBMODE_32_1K; ++ i)
			AppendMenu(hMenuSubmodes, nEnabledOnRX | MF_STRING, i, submode_olivia_names[i - ID_SUBMODE_4_250]);
		CheckMenuRadioItem(hMenuSubmodes, ID_SUBMODE_4_250, ID_SUBMODE_32_1K,
			pChannel->submode, MF_BYCOMMAND);
		_stprintf(buf, _T("Submode:\t%s"), submode_olivia_names[pChannel->submode - ID_SUBMODE_4_250]);
		AppendMenu(s_hMenuChannels, nEnabledOnRX | MF_STRING | MF_POPUP,  (UINT_PTR)hMenuSubmodes, buf);
	} else if (pChannel->mode == MODE_RTTY) {
		HMENU hMenuSubmodes = CreatePopupMenu();
		for (i = ID_SUBMODE_RTTY_HAM_45_170; i <= ID_SUBMODE_RTTY_DWD_50_450; ++ i)
			AppendMenu(hMenuSubmodes, nEnabledOnRX | MF_STRING, i, submode_rtty_names[i - ID_SUBMODE_RTTY_HAM_45_170]);
		CheckMenuRadioItem(hMenuSubmodes, ID_SUBMODE_RTTY_HAM_45_170, ID_SUBMODE_RTTY_DWD_50_450,
			pChannel->submode, MF_BYCOMMAND);
		_stprintf(buf, _T("Submode:\t%s"), submode_rtty_names[pChannel->submode - ID_SUBMODE_RTTY_HAM_45_170]);
		AppendMenu(s_hMenuChannels, nEnabledOnRX | MF_STRING | MF_POPUP,  (UINT_PTR)hMenuSubmodes, buf);
	}

	if (pChannel->mode == MODE_BPSK31 ||
		pChannel->mode == MODE_QPSK31 ||
		pChannel->mode == MODE_PSK63  ||
		pChannel->mode == MODE_MFSK16 ||
		pChannel->mode == MODE_THROB ||
		pChannel->mode == MODE_THROBX) {
		AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_AFC, _T("AFC"));
		if (pChannel->afcon)
			CheckMenuItem(s_hMenuChannels, ID_AFC, MF_BYCOMMAND | MF_CHECKED);
	} 

	if (pChannel->mode == MODE_BPSK31 ||
		pChannel->mode == MODE_QPSK31 ||
		pChannel->mode == MODE_PSK63  ||
		pChannel->mode == MODE_MFSK16 ||
		pChannel->mode == MODE_OLIVIA || pChannel->mode == MODE_CONTESTIA || pChannel->mode == MODE_RTTYM) {
		if (pChannel->squelchon)
			_stprintf(buf, _T("SQL:\t%3d%%"), pChannel->iSquelchThreshold);
		else
			_stprintf(buf, _T("SQL:\tOff"));
		AppendMenu(s_hMenuChannels, nEnabledOnRX | MF_STRING, ID_SQLTHR, buf);
		if (pChannel->squelchon)
			CheckMenuItem(s_hMenuChannels, ID_SQLTHR, MF_BYCOMMAND | MF_CHECKED);
	}

	if (pChannel->mode == MODE_BPSK31 ||
		pChannel->mode == MODE_QPSK31 ||
		pChannel->mode == MODE_PSK63) {
		HMENU hMenuSync = CreatePopupMenu();
		AppendMenu(hMenuSync, MF_ENABLED | MF_STRING, ID_SYNCSPEED2,  _T("Slow (DX)"));
		AppendMenu(hMenuSync, MF_ENABLED | MF_STRING, ID_SYNCSPEED1,  _T("Normal"));
		AppendMenu(hMenuSync, MF_ENABLED | MF_STRING, ID_SYNCSPEED0,  _T("Fast (Contest)"));
		_stprintf(buf, _T("Sync:\t%s"), (pChannel->nSyncSpeed == 0) ? _T("Fast") : ((pChannel->nSyncSpeed == 1) ? _T("Normal") : _T("Slow")));
		AppendMenu(s_hMenuChannels, nEnabledOnRX | MF_STRING | MF_POPUP,  (UINT_PTR)hMenuSync, buf);
		CheckMenuRadioItem(hMenuSync, ID_SYNCSPEED0, ID_SYNCSPEED2, ID_SYNCSPEED0 + pChannel->nSyncSpeed, MF_BYCOMMAND);
	}

	AppendMenu(s_hMenuChannels, nEnabledOnRX | MF_STRING, ID_TXLOCK, _T("TX Lock"));
	if (pChannel->bTxLock)
		CheckMenuItem(s_hMenuChannels, ID_TXLOCK, MF_BYCOMMAND | MF_CHECKED);

	if (pChannel->mode == MODE_RTTY || pChannel->mode == MODE_QPSK31 || 
		pChannel->mode == MODE_MFSK16 || pChannel->mode == MODE_MFSK8 ||
		pChannel->mode == MODE_THROB || pChannel->mode == MODE_THROBX ||
		pChannel->mode == MODE_OLIVIA || pChannel->mode == MODE_CONTESTIA || pChannel->mode == MODE_RTTYM) {
		AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_REVERSE, _T("Reverse"));
		if (pChannel->reverse)
			CheckMenuItem(s_hMenuChannels, ID_REVERSE, MF_BYCOMMAND | MF_CHECKED);
	} else if (pChannel->mode == MODE_CW) {
		HMENU hMenuBW    = CreatePopupMenu();
		HMENU hMenuTaps  = CreatePopupMenu();
		HMENU hMenuSpeed = CreatePopupMenu();
		int   iValue	 = 0;
		AppendMenu(hMenuBW, nEnabledOnRX | MF_STRING, ID_CWFILTWIDTH_10,  _T(" 10 Hz"));
		AppendMenu(hMenuBW, nEnabledOnRX | MF_STRING, ID_CWFILTWIDTH_20,  _T(" 20 Hz"));
		AppendMenu(hMenuBW, nEnabledOnRX | MF_STRING, ID_CWFILTWIDTH_30,	_T(" 30 Hz"));
		AppendMenu(hMenuBW, nEnabledOnRX | MF_STRING, ID_CWFILTWIDTH_70,	_T(" 70 Hz"));
		AppendMenu(hMenuBW, nEnabledOnRX | MF_STRING, ID_CWFILTWIDTH_150,	_T("150 Hz"));
		AppendMenu(hMenuBW, nEnabledOnRX | MF_STRING, ID_CWFILTWIDTH_300,	_T("300 Hz"));
		CheckMenuRadioItem(hMenuBW, ID_CWFILTWIDTH_10, ID_CWFILTWIDTH_300,  ID_CWFILTWIDTH_10 + pChannel->cw_bandwidth, MF_BYCOMMAND);
		switch (pChannel->cw_bandwidth) {
			case 0: iValue = 10; break;
			case 1: iValue = 20; break;
			case 2: iValue = 30; break;
			case 3: iValue = 70; break;
			case 4: iValue = 150; break;
			case 5: iValue = 300; break;
		}
		_stprintf(buf, _T("Filter BW:\t%d Hz"), iValue);
		AppendMenu(s_hMenuChannels, nEnabledOnRX | MF_STRING | MF_POPUP,  (UINT_PTR)hMenuBW, buf);

		AppendMenu(hMenuSpeed, nEnabledOnRX | MF_STRING, ID_CWWPMRX_1,  _T(" 1 WPM"));
		AppendMenu(hMenuSpeed, nEnabledOnRX | MF_STRING, ID_CWWPMRX_2,  _T(" 2 WPM"));
		AppendMenu(hMenuSpeed, nEnabledOnRX | MF_STRING, ID_CWWPMRX_5,  _T(" 5 WPM"));
		AppendMenu(hMenuSpeed, nEnabledOnRX | MF_STRING, ID_CWWPMRX_10, _T("10 WPM"));
		AppendMenu(hMenuSpeed, nEnabledOnRX | MF_STRING, ID_CWWPMRX_20, _T("20 WPM"));
		AppendMenu(hMenuSpeed, nEnabledOnRX | MF_STRING, ID_CWWPMRX_40, _T("40 WPM"));
		AppendMenu(hMenuSpeed, nEnabledOnRX | MF_STRING, ID_CWWPMRX_60, _T("60 WPM"));
		CheckMenuRadioItem(hMenuSpeed, ID_CWWPMRX_1, ID_CWWPMRX_60, ID_CWWPMRX_1 + pChannel->cw_rxspeed, MF_BYCOMMAND);
		switch (pChannel->cw_rxspeed) {
			case 0: iValue = 1; break;
			case 1: iValue = 2; break;
			case 2: iValue = 5; break;
			case 3: iValue = 10; break;
			case 4: iValue = 20; break;
			case 5: iValue = 40; break;
			case 6: iValue = 60; break;
		}
		_stprintf(buf, _T("Max RX spd:\t%d WPM"), iValue);
		AppendMenu(s_hMenuChannels, nEnabledOnRX | MF_STRING | MF_POPUP,  (UINT_PTR)hMenuSpeed, buf);

		_stprintf(buf, _T("TX speed:\t%d WPM"), pChannel->cw_txspeed);
		AppendMenu(s_hMenuChannels, MF_ENABLED | MF_STRING, ID_CWWPMTX, buf);
	}
}

extern "C" void cw_set_bandwidth(Trx *trx);
extern "C" void cw_set_txspeed(Trx *trx);

static void SwitchMode(Trx *trx, trx_mode_t nModeNew)
{
	if (trx_is_sending(trx) || trx->mode == nModeNew)
		return;
	trx->mode		= nModeNew;
	trx->submode	= 0;
	trx_initmodem(trx);
	UpdateMenuChannels();
	waterfall_draw_ruler(&s_Waterfall, 0);
}

static void SwitchSubmode(Trx *trx, int nSubmodeNew)
{
	if (trx_is_sending(trx) || trx->submode == nSubmodeNew)
		return;
	trx->submode	= nSubmodeNew;
	trx_initmodem(trx);
	UpdateMenuChannels();
	waterfall_draw_ruler(&s_Waterfall, 0);
}

LRESULT OnCommand(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	int wmId    = LOWORD(wParam);
	int wmEvent = HIWORD(wParam);

	// First kill the AutoCQ
	if (wmId != ID_SENDBUF) {
		sndmodem_kill_autocq(&s_SndModem);
		SetFocus(s_aChannels[s_iChannelActive]->hWndSend);
	}

	Trx *trx	  = s_aChannels[s_iChannelActive];
	BOOL bSending = trx_is_sending(trx);

	if (wmId >= ID_CHANNEL0 && wmId <= ID_CHANNEL9) {
		if (trx_is_sending(trx))
			return 0;
		int iChannel = wmId - ID_CHANNEL0;
		s_iChannelActive = iChannel;
		UpdateMenuChannels();
		waterfall_draw_ruler(&s_Waterfall, 0);
		DoLayout();
		return 0;
	}

	if (wmId >= ID_CHANNEL_CLOSE0 && wmId <= ID_CHANNEL_CLOSE9) {
		int iChannel = wmId - ID_CHANNEL_CLOSE0;
		if (iChannel == s_iChannelActive)
			return 0;
		trx_free(s_aChannels[iChannel]);
		s_aChannels[iChannel] = 0;
		UpdateMenuChannels();
		waterfall_draw_ruler(&s_Waterfall, 0);
		DoLayout();
		return 0;
	}

	// Parse the menu selections:
	switch (wmId) {
	case ID_FFTSIZE_0:
	case ID_FFTSIZE_1:
	case ID_FFTSIZE_2:
	case ID_FFTSIZE_4:
	{
		waterfall_set_magnification(&s_Waterfall, (wf_mag_t)(WATERFALL_MAG_0 + wmId - ID_FFTSIZE_0), TRUE);
		waterfall_update_menu(&s_Waterfall, s_hMenuWaterfall);
		break;
	}

	case ID_WATERFALL_SPEED_HALF:
	case ID_WATERFALL_SPEED_NORMAL:
	case ID_WATERFALL_SPEED_DOUBLE:
	case ID_WATERFALL_SPEED_TRIPLE:
	{
		int id = wmId - ID_WATERFALL_SPEED_HALF;
		s_Waterfall.config.speed = (wf_speed_t)(WATERFALL_SPEED_HALF + id);
		waterfall_update_menu(&s_Waterfall, s_hMenuWaterfall);
		break;
	}

	case ID_WATERFALL_AVC:
		s_Waterfall.config.bAVC = ! s_Waterfall.config.bAVC;
		waterfall_update_menu(&s_Waterfall, s_hMenuWaterfall);
		break;
	case ID_TOOLS_EXIT:
	{
		PostMessage(hWnd, WM_CLOSE, 0, 0);
		break;
	}
	case ID_TRXCTRL_SETUP:
	{
		if (trx_is_sending(trx))
			return 0;
		trxctrl_edit();
		cat_update_menu(s_hMenuCAT);
		break;
	}
	case ID_TOOLS_ABOUT:
	{
		MessageBox(s_hWndMain,
			_T("PocketDigi - HF digital teletype for PocketPC\r\n")
			_T("http://pocketdigi.sourceforge.net\r\n")
			_T("Author: OK1IAK <bubnikv@seznam.cz>\r\n")
			_T("Based on GMFSK, Tomi Manninen, OH2BNS <oh2bns@sral.fi>\r\n")
			_T("Version ") VERSION,
			_T("PocketDigi - About"), MB_OK);
		break;
	}
	case ID_SHOWDEVINFO:
		devinfo_show();
		break;
	case ID_CHANNEL_NEW:
	{
		int i;
		if (bSending)
			return 0;
		for (i = 0; i < CHANNELS_MAX; ++ i)
			if (s_aChannels[i] == 0)
				break;
		if (i < CHANNELS_MAX) {
			Trx *trxOld = trx;
			Trx *trxNew = trx_new();
			s_aChannels[i] = trxNew;
			trxNew->reverse = trxOld->reverse;
			trxNew->mode = trxOld->mode;
			trx_initmodem(trxNew);
			trx_create(trxNew, s_hWndMain, g_hInst, &s_SndModem);
			trxNew->nChannelID = i;
			s_iChannelActive = i;
			SetFocus(s_aChannels[s_iChannelActive]->hWndSend);
			UpdateMenuChannels();
			waterfall_draw_ruler(&s_Waterfall, 0);
			DoLayout();
		}
		break;
	}
	case ID_CHANNEL_CLOSE:
	{
		int i;
		if (bSending)
			return 0;
		for (i = 0; i < CHANNELS_MAX; ++ i)
			if (i != s_iChannelActive && s_aChannels[i] != 0)
				break;
		if (i < CHANNELS_MAX) {
			trx_free(trx);
			s_aChannels[s_iChannelActive] = 0;
			s_iChannelActive = i;
			UpdateMenuChannels();
			waterfall_draw_ruler(&s_Waterfall, 0);
			DoLayout();
		}
		break;
	}
	case ID_CHANNEL_CLOSE_OTHERS:
	{
		int i;
		for (i = 0; i < CHANNELS_MAX; ++ i)
			if (i != s_iChannelActive && s_aChannels[i] != 0) {
				trx_free(s_aChannels[i]);
				s_aChannels[i] = 0;
			}
		UpdateMenuChannels();
		waterfall_draw_ruler(&s_Waterfall, 0);
		DoLayout();
		break;
	}
	case ID_STARTTX:
	case ID_SENDBUF:
	case ID_TUNESTART:
	{
		if (trx_is_sending(trx))
			return 0;
		sndmodem_stop_recording(&s_SndModem, TRUE);
		trx->state = (wmId == ID_TUNESTART) ? TRX_STATE_TUNE : TRX_STATE_TX;
		trx->pModem->nOutBufLen = 0;
		trxctrl_ptt(&g_TrxCtrl, true); // PTT on
		sndmodem_start_playing(&s_SndModem, FALSE);
		if (wmId == ID_TUNESTART) {
			if (g_TrxCtrl.nType == TRXCTRL_ATS3_BELL202 || g_TrxCtrl.nType == TRXCTRL_ATS3_MANCHESTER)
				trxctrl_ats3_start_bpsk(&g_TrxCtrl, trx->pModem, trx->nTxFrequency);
		} else
			trx->txinit(trx);
		trx_txloop(trx);
		break;
	}
	case ID_STOPTX:
	{
		if (! bSending || trx->stopflag)
			return 0;
		trx->stopflag = TRUE;
		UpdateMainMenuBar(2);
		break;
	}
	case ID_KILLTX:
	{
		if (! bSending)
			return 0;
		trxctrl_ptt(&g_TrxCtrl, false); // PTT off
		trx->stopflag = TRUE;
		trx->state    = TRX_STATE_FLUSH;
		if (g_TrxCtrl.nType == TRXCTRL_ATS3_BELL202 || g_TrxCtrl.nType == TRXCTRL_ATS3_MANCHESTER)
			trxctrl_ats3_endtx(&g_TrxCtrl, trx->pModem);
		else {
			// kill the active sound buffers
			sndmodem_stop_playing(&s_SndModem);
			sndmodem_start_recording(&s_SndModem);
		}
		break;
	}
	case ID_SND_REPLAY:
	{
		if (bSending)
			return 0;
		sndmodem_replay(&s_SndModem);
		break;
	}
	case ID_MODE_BPSK31:
	case ID_MODE_QPSK31:
	case ID_MODE_BPSK63:
	case ID_MODE_RTTY:
	case ID_MODE_MFSK16:
	case ID_MODE_MFSK8:
	case ID_MODE_THROB:
	case ID_MODE_THROBX:
	case ID_MODE_FELDHELL:
	case ID_MODE_OLIVIA:
	case ID_MODE_CONTESTIA:
	case ID_MODE_RTTYM:
	case ID_MODE_AX25:
	case ID_MODE_CW:		
		SwitchMode(trx, (trx_mode_t)(wmId - ID_MODE_BPSK31));
		break;

	case ID_SUBMODE_TPS1:
	case ID_SUBMODE_TPS2:
	case ID_SUBMODE_TPS4:
	case ID_SUBMODE_4_250:
	case ID_SUBMODE_4_500:
	case ID_SUBMODE_16_500:
	case ID_SUBMODE_16_1K:
	case ID_SUBMODE_8_250:
	case ID_SUBMODE_8_500:
	case ID_SUBMODE_32_1K:
	case ID_SUBMODE_RTTY_HAM_45_170:
	case ID_SUBMODE_RTTY_HAM_45_200:
	case ID_SUBMODE_RTTY_DWD_50_85:
	case ID_SUBMODE_RTTY_DWD_50_450:
		SwitchSubmode(trx, wmId);
		break;

	case ID_REVERSE:
	{
		trx->reverse = ! trx->reverse;
		UpdateMenuChannels();
		break;
	}
	case ID_TXLOCK:
	{
		if (trx->bTxLock) {
			trx->bTxLock = false;
			trx->nTxFrequency = trx->nRxFrequency;
		} else
			trx->bTxLock = true;
		UpdateMenuChannels();
		break;
	}
	case ID_AFC:
	{
		trx->afcon = ! trx->afcon;
//		trx_initmodem(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_SQL:
	{
		trx->squelchon = ! trx->squelchon;
//		trx_initmodem(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_SYNCSPEED0:
	case ID_SYNCSPEED1:
	case ID_SYNCSPEED2:
		trx->nSyncSpeed = wmId - ID_SYNCSPEED0;
		UpdateMenuChannels();
		break;
	case ID_CWFILTWIDTH_10:
	case ID_CWFILTWIDTH_20:
	case ID_CWFILTWIDTH_30:
	case ID_CWFILTWIDTH_70:
	case ID_CWFILTWIDTH_150:
	case ID_CWFILTWIDTH_300:
	{
		trx->cw_bandwidth = wmId - ID_CWFILTWIDTH_10;
		cw_set_bandwidth(trx);
		UpdateMenuChannels();
		waterfall_draw_ruler(&s_Waterfall, 0);
		break;
	}
	case ID_CWFILTTAPS_64:
	case ID_CWFILTTAPS_96:
	case ID_CWFILTTAPS_128:
	case ID_CWFILTTAPS_256:
	{
		trx->cw_firtaps = wmId - ID_CWFILTTAPS_64;
		cw_set_bandwidth(trx);
		UpdateMenuChannels();
		break;
	}

	case ID_CWWPMRX_1:
	case ID_CWWPMRX_2:
	case ID_CWWPMRX_5:
	case ID_CWWPMRX_10:
	case ID_CWWPMRX_20:
	case ID_CWWPMRX_40:
	case ID_CWWPMRX_60:
	{
		trx->cw_rxspeed = wmId - ID_CWWPMRX_1;
		cw_set_bandwidth(trx);
		UpdateMenuChannels();
		break;
	}
	case ID_CWWPMTX:
	{
		sliderpopup_create(&s_SliderPopup, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE,
			100, 15, 80, 180, _T("TX Speed"), _T("%3d WPM"), FALSE, ID_CWWPMTXRES, s_hWndMain, g_hInst);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMIN, FALSE,	8);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMAX, FALSE,	60);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETLINESIZE, 0,		1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETPAGESIZE, 0,		5);
		sliderpopup_set_value(&s_SliderPopup, trx->cw_txspeed);
		s_SliderPopup.bUpdateOnDragging = true;
		break;
	}
	case ID_CWWPMTXRES:
	{
		trx->cw_txspeed = s_SliderPopup.iValue;
		cw_set_txspeed(trx);
		UpdateMenuChannels();
		break;
	}

	case ID_SQLTHR:
	{
		if (trx_is_sending(trx))
			return 0;
		sliderpopup_create(&s_SliderPopup, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE,
			100, 15, 80, 220, _T("Squelch"), _T("%3d%%"), TRUE, ID_SQLTHRRES, s_hWndMain, g_hInst);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMIN, FALSE,	0);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMAX, FALSE,	100);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETLINESIZE, 0,		1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETPAGESIZE, 0,		10);
		sliderpopup_set_switch(&s_SliderPopup, trx->squelchon);
		sliderpopup_set_value(&s_SliderPopup, trx->iSquelchThreshold);
		break;
	}
	case ID_SQLTHRRES:
	{
		trx->squelchon         = s_SliderPopup.bSwitchValue;
		trx->iSquelchThreshold = s_SliderPopup.iValue;
		UpdateMenuChannels();
		break;
	}

	case ID_TXVOLUME:
	{
		int vol = (int)(0.5 + (double)s_SndModem.iVolume * 100.0 / 65535.0);
		sliderpopup_create(&s_SliderPopup, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE,
			100, 15, 80, 180, _T("TX Volume"), _T("%3d %%"), FALSE, ID_TXVOLUMERES, s_hWndMain, g_hInst);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMIN, FALSE,	1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMAX, FALSE,	100);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETLINESIZE, 0,		1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETPAGESIZE, 0,		5);
		sliderpopup_set_value(&s_SliderPopup, vol);
		s_SliderPopup.bUpdateOnDragging = true;
		break;
	}
	case ID_TXVOLUMERES:
	{
		int vol = (int)(0.5 + (double)s_SliderPopup.iValue * 65535.0 / 100.0);
		s_SndModem.iVolume = vol;
		break;
	}
	case ID_TXBUFFERS:
	{
		sliderpopup_create(&s_SliderPopup, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE,
			100, 15, 80, 180, _T("TX Buffers"), _T("%2d"), FALSE, ID_TXBUFFERSRES, s_hWndMain, g_hInst);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMIN, FALSE,	2);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMAX, FALSE,	10);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETLINESIZE, 0,		1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETPAGESIZE, 0,		5);
		sliderpopup_set_value(&s_SliderPopup, s_SndModem.nBufOutPrefetch);
		break;
	}
	case ID_TXBUFFERSRES:
	{
		s_SndModem.nBufOutPrefetch = s_SliderPopup.iValue;
		break;
	}
	case ID_RXHISTORYLEN:
	{
		sliderpopup_create(&s_SliderPopup, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE,
			100, 15, 80, 180, _T("History length"), _T("%2d sec"), TRUE, ID_RXHISTORYRES, s_hWndMain, g_hInst);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMIN, FALSE,	5);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMAX, FALSE,	60);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETLINESIZE, 0,		1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETPAGESIZE, 0,		10);
		sliderpopup_set_switch(&s_SliderPopup, s_SndModem.bHistoryEnabled);
		sliderpopup_set_value(&s_SliderPopup, s_SndModem.nHistorySeconds);
		break;
	}
	case ID_RXHISTORYRES:
	{
		sndmodem_set_replay(&s_SndModem, s_SliderPopup.bSwitchValue, s_SliderPopup.iValue);
		break;
	}
	case ID_WFTHRESHOLD:
		sliderpopup_create(&s_SliderPopup, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE,
			100, 15, 80, 180, _T("Threshold dB"), _T("%3d db"), FALSE, ID_WFTHRESHOLDRES, s_hWndMain, g_hInst);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMIN, FALSE,	0);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMAX, FALSE,	80);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETLINESIZE, 0,		1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETPAGESIZE, 0,		5);
		sliderpopup_set_value(&s_SliderPopup, s_Waterfall.config.iDecibelsThreshold);
		s_SliderPopup.bUpdateOnDragging = true;
		break;
	case ID_WFTHRESHOLDRES:
		s_Waterfall.config.iDecibelsThreshold = s_SliderPopup.iValue;
		break;

	case ID_WFRANGE:
		sliderpopup_create(&s_SliderPopup, WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE,
			100, 15, 80, 180, _T("Range dB"), _T("%3d db"), FALSE, ID_WFRANGERES, s_hWndMain, g_hInst);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMIN, FALSE,	0);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETRANGEMAX, FALSE,	80);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETLINESIZE, 0,		1);
		SendMessage(s_SliderPopup.hWndSlider, TBM_SETPAGESIZE, 0,		5);
		sliderpopup_set_value(&s_SliderPopup, s_Waterfall.config.iDecibelsRange);
		s_SliderPopup.bUpdateOnDragging = true;
		break;
	case ID_WFRANGERES:
		s_Waterfall.config.iDecibelsRange = s_SliderPopup.iValue;
		break;

	case ID_MACRO_EXECUTE1:
	case ID_MACRO_EXECUTE2:
	case ID_MACRO_EXECUTE3:
	case ID_MACRO_EXECUTE4:
	case ID_MACRO_EXECUTE5:
	case ID_MACRO_EXECUTE6:
	case ID_MACRO_EXECUTE7:
	case ID_MACRO_EXECUTE8:
	case ID_MACRO_EXECUTE9:
	case ID_MACRO_EXECUTE10:
	case ID_MACRO_EXECUTE11:
	case ID_MACRO_EXECUTE12:
		macro_send(trx, wmId - ID_MACRO_EXECUTE1);
		break;

	case ID_MACRO_SENDFILE:
		macro_chooseandsendfile(trx);
		break;

	case ID_MACRO_EDIT1:
	case ID_MACRO_EDIT2:
	case ID_MACRO_EDIT3:
	case ID_MACRO_EDIT4:
	case ID_MACRO_EDIT5:
	case ID_MACRO_EDIT6:
	case ID_MACRO_EDIT7:
	case ID_MACRO_EDIT8:
	case ID_MACRO_EDIT9:
	case ID_MACRO_EDIT10:
	case ID_MACRO_EDIT11:
	case ID_MACRO_EDIT12:
		macro_edit(wmId - ID_MACRO_EDIT1);
		macro_update_menu(s_hMenuMacros);
		break;

	case ID_FREQ_DLG:
		if (trx_is_sending(trx))
			return 0;
		cat_freqdlg();
		cat_update_menu(s_hMenuCAT);
		break;

	case ID_MACRO_DEFAULTS:
		macro_load_defaults();
		macro_update_menu(s_hMenuMacros);
		break;

	case ID_STNINFO_EDIT:
		stninfo_edit();
		break;

	case ID_CHANNEL_QSOEDIT:
		qsodata_edit(trx->pQso);
		UpdateMenuChannels();
		break;

	case ID_LOGGING:
	{
		log_to_file_activate(&trx->log, trx->log.hFile == 0, s_iChannelActive);
		UpdateMenuChannels();
		break;
	}

	default:
		return DefWindowProc(hWnd, WM_COMMAND, wParam, lParam);
	}
	return 0;
}

/*
#if defined( FOR_PocketPC )
// ::GetSystemMetrics( SM_CYMENU ) returns 23, which is too small
// SM_CYMENUSIZE is not defined for Windows CE 3.0 and newer
// 26 from Shell sample for eVT; also from p. 776 of Boling 2nd Edition, and
//  16 Aug 2000 contribution from Gary Peluso to thread called "Full Size PocketPC Dialogs"
//  in microsoft.public.windowsce.app.development
// 15 Aug 03 contribution from Tim Wilson to thread called "menu height?"
//  in microsoft.public.pocketpc.developer suggested using SystemInformation, but
//  BZ found that SystemInformation is part of .NET
const g_kiMenuHeight = 26;
#elif defined( FOR_Smartphone)
// 24 seems to be the right value (BZ guestimate) 25 Mar 04 (4.0.0.59)
const g_kiMenuHeight = 24;
#endif

// 13 Feb 05 (7.7.0.21)
// use ToolBar
// See 20-24 Feb 04 called "SHCreateMenuBar() without a resource file" in
//  microsoft.public.pocketpc.developer. In particular, see 20 Feb 04
//  contribution from Almond Stowger for ideas adapated here. Also, a
//  19 Feb 04 contribution from Eddy Escardo says:
//      SHCreateMenuBar does not currently support programatically
//      generated HMENUs, as the SHCMBF_HMENU flag just means that
//      nToolBarId will represent the ID of a menu in a compiled
//      resource module, not an actual HMENU that you can pass to
//      the SHCreateMenuBar call (as you've probably figured out by now).
// 13 Feb 05
// Adapted from 19 April 2001 contribution by Alex Blekhman to thread
//  called "Toolbar help please" in comp.os.ms-windows.programmer.win32
    DWORD dwStyle = CCS_NODIVIDER | CCS_NOPARENTALIGN | CCS_NORESIZE |
        TBSTYLE_FLAT | TBSTYLE_LIST | WS_CHILD | WS_VISIBLE;
	ASSERT( m_nID != 0 );   // Should be set by initInternal
    VERIFY(PFInitCCCommandBar());
    m_hWnd = CreateWindowEx(
            0,                  // DWORD dwExStyle
            TOOLBARCLASSNAME,   // LPCTSTR lpClassName
            NULL,               // LPCTSTR lpWindowName
            dwStyle,            // DWORD dwStyle
            ClsPFDialogBox::Gap(),
            0,
        // BZ added WS_BORDER to styles (to make edges visible), then experimented
        //  with x and width. Multiplier needed on right for symmetry depended on
        //  whether CS_NORESIZE was included in styles
        //      5 with CS_NORESIZE
        //      7 without CS_NORESIZE
        //  TODO: Why?
	::GetSystemMetrics( SM_CXSCREEN ) - (ClsPFDialogBox::Gap() * 5),
        g_kiMenuHeight,
        m_hWndParent,
        reinterpret_cast<HMENU>(m_nID),  //
		HMENU hMenu
        m_hInstance,        // HINSTANCE hInstance
		NULL);              // LPVOID lpParam
    ASSERT( IsWindow() );
    ASSERT( pMenu != NULL );

    m_sClassName = TOOLBARCLASSNAME;    // keep Validate happy
    IGNORE_RETURN( PFWSendMessage( TB_BUTTONSTRUCTSIZE, sizeof(TBBUTTON ), 0 ) );
    m_bIsToolBar = TRUE;
    VERIFY( BuildFromStruct( pMenu ) );
*/

#ifdef _WIN32_WCE
static TBBUTTON tbButtonsRX[] = {
    {1,	ID_STARTTX, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
    {0, 0,          TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0,  0}
};
static TBBUTTON tbButtonsTX[] = {
    {0,	ID_STOPTX,  TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
    {0, 0,          TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0,  0}
};
static TBBUTTON tbButtonsTXend[] = {
    {2,	ID_KILLTX,  TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
    {0, 0,          TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0,  0}
};
#endif /* _WIN32_WCE */

static void CreateMainMenuBar(HWND hWnd, TBBUTTON *aButtons, int nButtons)
{
	HMENU hMenuSetup     = 0;
	int   nEnabledOnRX = (s_iTXMode == 0) ? MF_ENABLED : MF_GRAYED;

#ifdef _WIN32_WCE
#ifdef WIN32_PLATFORM_PSPC
	SHMENUBARINFO mbi;
#endif /* WIN32_PLATFORM_PSPC */
#endif /* _WIN32_WCE */

#ifdef _WIN32_WCE
#ifdef WIN32_PLATFORM_PSPC
	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize     = sizeof(SHMENUBARINFO);
	mbi.hwndParent = hWnd;
	mbi.hInstRes   = g_hInst;
	mbi.nToolBarId = IDR_MENUBAR2; // IDM_MAIN_MENU;	
    if (!SHCreateMenuBar(&mbi)) {
		MessageBox(hWnd, L"SHCreateMenuBar Failed - type 1", L"Error", MB_OK);
    } else {
		s_hWndCommandBar = mbi.hwndMB;
		s_hMenuTools	 = SHGetSubMenu(s_hWndCommandBar, IDM_MAIN_MENUITEM2);
		s_hMenuChannels  = SHGetSubMenu(s_hWndCommandBar, IDM_MAIN_MENUITEM3);
		s_hMenuMacros    = SHGetSubMenu(s_hWndCommandBar, IDM_MAIN_MENUITEM4);
		s_hMenuCAT       = SHGetSubMenu(s_hWndCommandBar, IDM_MAIN_MENUITEM5);
		if (s_hMenuTools == 0)
			MessageBox(hWnd, L"Menu Tools handler not acquired - type1", L"Error", MB_OK);
		if (s_hMenuChannels == 0)
			MessageBox(hWnd, L"Menu Channels handler not acquired - type1", L"Error", MB_OK);
		if (s_hMenuMacros == 0)
			MessageBox(hWnd, L"Menu Macros handler not acquired - type1", L"Error", MB_OK);
		if (s_hMenuCAT == 0)
			MessageBox(hWnd, L"CAT Macros handler not acquired - type1", L"Error", MB_OK);
	}

    if (s_hWndCommandBar == 0 || s_hMenuTools == 0 || s_hMenuChannels == 0 || s_hMenuMacros == 0 || s_hMenuCAT == 0) {
		// try another run
		memset(&mbi, 0, sizeof(SHMENUBARINFO));
		mbi.cbSize     = sizeof(SHMENUBARINFO);
		mbi.hwndParent = hWnd;
		mbi.hInstRes   = g_hInst;
		mbi.nToolBarId = IDR_MENUBAR2; // IDM_MAIN_MENU;	
		mbi.dwFlags	   = SHCMBF_HMENU;
		if (!SHCreateMenuBar(&mbi)) {
			MessageBox(hWnd, L"SHCreateMenuBar Failed - type 2", L"Error", MB_OK);
		} else {
			s_hWndCommandBar = mbi.hwndMB;
			HMENU hMenu		 = SHGetMenu(s_hWndCommandBar);
			s_hMenuTools	 = GetSubMenu(hMenu, 1);
			s_hMenuChannels  = GetSubMenu(hMenu, 2);
			s_hMenuMacros    = GetSubMenu(hMenu, 3);
			s_hMenuCAT       = GetSubMenu(hMenu, 4);
			if (s_hMenuTools == 0)
				MessageBox(hWnd, L"Menu Tools handler not acquired - type2", L"Error", MB_OK);
			if (s_hMenuChannels == 0)
				MessageBox(hWnd, L"Menu Channels handler not acquired - type2", L"Error", MB_OK);
			if (s_hMenuMacros == 0)
				MessageBox(hWnd, L"Menu Macros handler not acquired - type2", L"Error", MB_OK);
			if (s_hMenuCAT == 0)
				MessageBox(hWnd, L"CAT Macros handler not acquired - type2", L"Error", MB_OK);
		}
	}
#endif /* WIN32_PLATFORM_PSPC */

	if (s_hWndCommandBar == 0 || s_hMenuTools == 0 || s_hMenuChannels == 0 || s_hMenuMacros == 0 || s_hMenuCAT == 0) {
		HMENU hMenu		 = 0;
		s_hWndCommandBar = CommandBar_Create(g_hInst, hWnd, 101010);
		if (s_hWndCommandBar == 0) {
			MessageBox(hWnd, L"CommandBar_Create Failed - type 3", L"Error", MB_OK);
		} else {
#ifdef WIN32_PLATFORM_PSPC
			memset(&mbi, 0, sizeof(SHMENUBARINFO));
			mbi.cbSize     = sizeof(SHMENUBARINFO);
			mbi.hwndParent = hWnd;
			mbi.hInstRes   = g_hInst;
			mbi.dwFlags	   = SHCMBF_EMPTYBAR;
			if (! SHCreateMenuBar(&mbi))
				MessageBox(hWnd, L"SHCMBF_EMPTYBAR Failed - type 3", L"Error", MB_OK);
#endif /* WIN32_PLATFORM_PSPC */
			CommandBar_InsertMenubar(s_hWndCommandBar, g_hInst, IDR_MENUBAR2 /* IDM_MAIN_MENU */, 0);
#ifndef WIN32_PLATFORM_PSPC
			CommandBar_AddAdornments(s_hWndCommandBar, 0, 0);
#endif /* WIN32_PLATFORM_PSPC */
			hMenu			 = CommandBar_GetMenu(s_hWndCommandBar, 0);
			s_hMenuTools	 = GetSubMenu(hMenu, 0);
			s_hMenuChannels  = GetSubMenu(hMenu, 1);
			s_hMenuMacros    = GetSubMenu(hMenu, 2);
			s_hMenuCAT       = GetSubMenu(hMenu, 3);
			if (s_hMenuTools == 0)
				MessageBox(hWnd, L"Menu Tools handler not acquired - type3", L"Error", MB_OK);
			if (s_hMenuChannels == 0)
				MessageBox(hWnd, L"Menu Channels handler not acquired - type3", L"Error", MB_OK);
			if (s_hMenuMacros == 0)
				MessageBox(hWnd, L"Menu Macros handler not acquired - type3", L"Error", MB_OK);
			if (s_hMenuCAT == 0)
				MessageBox(hWnd, L"Menu CAT handler not acquired - type3", L"Error", MB_OK);
		}
	}

	if (s_hWndCommandBar == 0 || s_hMenuTools == 0 || s_hMenuChannels == 0 || s_hMenuMacros == 0 || s_hMenuCAT == 0)
		MessageBox(hWnd, L"Menu creation failed", L"Error", MB_OK);

	DeleteMenu(s_hMenuTools,  0, MF_BYPOSITION);
	DeleteMenu(s_hMenuMacros, 0, MF_BYPOSITION);
	DeleteMenu(s_hMenuCAT,    0, MF_BYPOSITION);

/*
	SendMessage(s_hWndCommandBar, TB_DELETEBUTTON, 0, 0);

    HMENU s_hMenuTools = SHGetSubMenu(s_hWndCommandBar, IDM_MAIN_MENUITEM2);

	TBBUTTON tbButton;
	memset(&tbButton, 0, sizeof(TBBUTTON));
	tbButton.iBitmap   = I_IMAGENONE;
	tbButton.idCommand = 0x6969;
	tbButton.fsState   = TBSTATE_ENABLED;
	tbButton.fsStyle   = TBSTYLE_DROPDOWN | TBSTYLE_AUTOSIZE | 0x80;
	tbButton.dwData    = (DWORD)s_hMenuWaterfallZoom;
	tbButton.iString   = (int)_T("FFT");
	CommandBar_InsertButton(s_hWndCommandBar, 0, &tbButton);
	tbButton.idCommand = 0x6970;
	tbButton.dwData    = (DWORD)s_hMenuTools;
	tbButton.iString   = (int)_T("Tools");
	CommandBar_InsertButton(s_hWndCommandBar, 1, &tbButton);
	tbButton.idCommand = 0x6971;
	tbButton.dwData    = (DWORD)s_hMenuChannels;
	tbButton.iString   = (int)_T("Channels");
	CommandBar_InsertButton(s_hWndCommandBar, 2, &tbButton);
*/
#else /*  _WIN32_WCE */
	{ 
		HMENU hMenu	= CreateMenu();
		s_hMenuTools = CreatePopupMenu();
		AppendMenu(hMenu, MF_POPUP | MF_ENABLED, (UINT_PTR)s_hMenuTools,	_T("Tools"));
		AppendMenu(hMenu, MF_POPUP | MF_ENABLED, (UINT_PTR)s_hMenuChannels,	_T("Channels"));
		AppendMenu(hMenu, MF_POPUP | MF_ENABLED, (UINT_PTR)s_hMenuMacros,	_T("Macros"));
		AppendMenu(hMenu, MF_POPUP | MF_ENABLED, (UINT_PTR)s_hMenuCAT,  	_T("CAT"));
		SetMenu(hWnd, hMenu);
	}
#endif /* _WIN32_WCE */

	s_hMenuWaterfallZoom = CreatePopupMenu();
	AppendMenu(s_hMenuWaterfallZoom, nEnabledOnRX | MF_STRING, ID_FFTSIZE_0,  _T("Normal"));
	AppendMenu(s_hMenuWaterfallZoom, nEnabledOnRX | MF_STRING, ID_FFTSIZE_1,  _T("x2"));
	AppendMenu(s_hMenuWaterfallZoom, nEnabledOnRX | MF_STRING, ID_FFTSIZE_2,  _T("x4"));
//	AppendMenu(s_hMenuWaterfallZoom, nEnabledOnRX | MF_STRING, ID_FFTSIZE_4,  _T("x8"));

	s_hMenuWaterfallSpeed = CreatePopupMenu();
	AppendMenu(s_hMenuWaterfallSpeed, nEnabledOnRX | MF_STRING, ID_WATERFALL_SPEED_HALF,   _T("Half"));
	AppendMenu(s_hMenuWaterfallSpeed, nEnabledOnRX | MF_STRING, ID_WATERFALL_SPEED_NORMAL, _T("Normal"));
	AppendMenu(s_hMenuWaterfallSpeed, nEnabledOnRX | MF_STRING, ID_WATERFALL_SPEED_DOUBLE, _T("x2"));
	AppendMenu(s_hMenuWaterfallSpeed, nEnabledOnRX | MF_STRING, ID_WATERFALL_SPEED_TRIPLE, _T("x3"));

	s_hMenuWaterfall = CreatePopupMenu();
	AppendMenu(s_hMenuWaterfall, MF_POPUP | nEnabledOnRX, (UINT_PTR)s_hMenuWaterfallZoom,	_T("Zoom"));
	AppendMenu(s_hMenuWaterfall, MF_POPUP | nEnabledOnRX, (UINT_PTR)s_hMenuWaterfallSpeed,  _T("Speed"));
	AppendMenu(s_hMenuWaterfall, nEnabledOnRX | MF_STRING, ID_WFTHRESHOLD,	 _T("Threshold dB"));
	AppendMenu(s_hMenuWaterfall, nEnabledOnRX | MF_STRING, ID_WFRANGE,		 _T("Range dB"));
	AppendMenu(s_hMenuWaterfall, nEnabledOnRX | MF_STRING, ID_WATERFALL_AVC, _T("AVC"));

	hMenuSetup = CreatePopupMenu();
	AppendMenu(hMenuSetup, nEnabledOnRX | MF_STRING, ID_STNINFO_EDIT, _T("Station Info"));
	AppendMenu(hMenuSetup, nEnabledOnRX | MF_STRING, ID_TRXCTRL_SETUP,_T("TRX Control"));
	AppendMenu(hMenuSetup, nEnabledOnRX | MF_STRING, ID_TXBUFFERS,	  _T("TX Buffers"));
	AppendMenu(hMenuSetup, nEnabledOnRX | MF_STRING, ID_RXHISTORYLEN, _T("Sound History"));

	AppendMenu(s_hMenuTools, nEnabledOnRX | MF_STRING, ID_STARTTX,	_T("Send"));
	AppendMenu(s_hMenuTools, ((s_iTXMode == 1) ? MF_ENABLED : MF_GRAYED) | MF_STRING, ID_STOPTX, _T("TX stop"));
	AppendMenu(s_hMenuTools, ((s_iTXMode != 0) ? MF_ENABLED : MF_GRAYED) | MF_STRING, ID_KILLTX, _T("TX kill"));
	AppendMenu(s_hMenuTools, nEnabledOnRX | MF_STRING, ID_TUNESTART,	_T("Tune"));
	AppendMenu(s_hMenuTools, nEnabledOnRX | MF_STRING, ID_SND_REPLAY,	_T("Replay"));
	AppendMenu(s_hMenuTools, MF_ENABLED   | MF_SEPARATOR, 0, 0);
	AppendMenu(s_hMenuTools, MF_POPUP     | nEnabledOnRX, (UINT_PTR)hMenuSetup,       _T("Setup"));
	AppendMenu(s_hMenuTools, MF_POPUP     | nEnabledOnRX, (UINT_PTR)s_hMenuWaterfall, _T("Waterfall"));
	AppendMenu(s_hMenuTools, MF_ENABLED   | MF_STRING, ID_TXVOLUME,		_T("TX Volume"));
	AppendMenu(s_hMenuTools, MF_ENABLED   | MF_SEPARATOR, 0, 0);	
	AppendMenu(s_hMenuTools, nEnabledOnRX | MF_STRING, ID_TOOLS_ABOUT, _T("About"));
	AppendMenu(s_hMenuTools, nEnabledOnRX | MF_STRING, ID_SHOWDEVINFO, _T("Device Info"));
	AppendMenu(s_hMenuTools, nEnabledOnRX | MF_STRING, ID_TOOLS_EXIT,  _T("Exit"));

#ifdef _WIN32_WCE
	CommandBar_AddBitmap(s_hWndCommandBar, g_hInst, IDB_MENUBAR, 3, 24, 24);
    CommandBar_AddButtons(s_hWndCommandBar, nButtons, aButtons);
#endif /* _WIN32_WCE */
}

extern "C" void UpdateMainMenuBar(int nState)
{
#ifdef _WIN32_WCE
	TBBUTTON *aButtons;
	if (nState == 0)
		aButtons = tbButtonsRX;
	else if(nState == 1)
		aButtons = tbButtonsTX;
	else
		aButtons = tbButtonsTXend;
#endif /* _WIN32_WCE */
	if (! s_bEnableMenuUpdate)
		return;
 	s_iTXMode = nState;
#ifdef _WIN32_WCE
    CommandBar_Destroy(s_hWndCommandBar);
	CreateMainMenuBar(s_hWndMain, aButtons, 1);
#else /* _WIN32_WCE */
	DestroyWindow(s_hWndCommandBar);
	CreateMainMenuBar(s_hWndMain, 0, 0);
#endif /* _WIN32_WCE */
	macro_update_menu(s_hMenuMacros);
	cat_update_menu(s_hMenuCAT);
	waterfall_update_menu(&s_Waterfall, s_hMenuWaterfall);
#ifndef _WIN32_WCE
	{
		TBBUTTON btn;
		memset(&btn, 0, sizeof(btn));
		if (nState == 0) {
			btn.iBitmap   = 1;
			btn.idCommand = ID_STARTTX;
		} else if (nState == 1) {
			btn.iBitmap   = 0;
			btn.idCommand = ID_STOPTX;
		} else {
			btn.iBitmap   = 2;
			btn.idCommand = ID_KILLTX;
		}
		btn.fsState   = TBSTATE_ENABLED; 
		btn.fsStyle   = TBSTYLE_BUTTON;
		SendMessage(s_hWndToolbar, TB_DELETEBUTTON, 0, 0);
		SendMessage(s_hWndToolbar, TB_ADDBUTTONS, 1, (LPARAM)&btn);
	}
#endif /* _WIN32_WCE */
	UpdateMenuChannels();
}

LRESULT	OnMainWindowCreate(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	// When the main window is created using CW_USEDEFAULT the height of the menubar (if one
	// is created is not taken into account). So we resize the window after creating it.
	RECT	rect, rectWnd;

    // Start by initializing the common control libraries
	// Menu needs it to work correctly.
	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC  = ICC_BAR_CLASSES | ICC_UPDOWN_CLASS;
    InitCommonControlsEx(&icc);

#ifdef _WIN32_WCE
	CreateMainMenuBar(hWnd, tbButtonsRX, 1);
  #ifdef WIN32_PLATFORM_PSPC
	GetWindowRect(hWnd, &rect);
	rect.bottom -= MENU_HEIGHT;
	//FIXME hide title
//	rect.top     = 0;
	MoveWindow(hWnd, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, FALSE);
  #endif /* WIN32_PLATFORM_PSPC */
#else /* _WIN32_WCE */
	CreateMainMenuBar(hWnd, 0, 0);
	GetWindowRect(s_hWndMain, &rectWnd);
	GetClientRect(s_hWndMain, &rect);
	MoveWindow(s_hWndMain, rectWnd.left, rectWnd.top,
		240 + rectWnd.right - rectWnd.left - rect.right,
		320 - MENU_HEIGHT + rectWnd.bottom - rectWnd.top - rect.bottom, FALSE);
	GetWindowRect(s_hWndMain, &rect);
#endif /* _WIN32_WCE */

  	s_aChannels[0] = trx_new();
	trx_create(s_aChannels[0], hWnd, g_hInst, &s_SndModem);
	s_aChannels[0]->nChannelID = 0;
	s_iChannelActive = 0;

#ifndef _WIN32_WCE
	{
		TBBUTTON btn;
		memset(&btn, 0, sizeof(btn));
		btn.iBitmap   = 0; 
		btn.idCommand = ID_STARTTX; 
		btn.fsState   = TBSTATE_ENABLED; 
		btn.fsStyle   = TBSTYLE_BUTTON;
		s_hWndToolbar = CreateToolbarEx(hWnd, WS_CHILD | WS_VISIBLE /* | TBSTYLE_FLAT */, ID_MAIN_TOOLBAR, 3, g_hInst, IDB_TOOLBAR, 
			(LPCTBBUTTON)&btn, 1, 0, 0, 16, 16, sizeof(TBBUTTON));
	}
#endif /* _WIN32_WCE */

	return 0;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
#ifdef _WIN32_WCE
#ifdef WIN32_PLATFORM_PSPC
	static SHACTIVATEINFO sai;
#endif /* WIN32_PLATFORM_PSPC */
#else /* _WIN32_WCE */
	MSG msg;
	msg.hwnd = hWnd;
	msg.message = message;
	msg.wParam = wParam;
	msg.lParam = lParam;
	::sliderpopup_pretranslate_message(&s_SliderPopup, &msg);
#endif /* _WIN32_WCE */

	Trx *trx	  = (s_iChannelActive == -1) ? 0 : s_aChannels[s_iChannelActive];
	BOOL bSending = (s_iChannelActive == -1) ? false : trx_is_sending(trx);

	switch (message) 
	{
	case WM_COMMAND:
		return OnCommand(hWnd, wParam, lParam);
	case WM_CREATE:
#ifdef _WIN32_WCE
#ifdef WIN32_PLATFORM_PSPC
		memset(&sai, 0, sizeof(SHACTIVATEINFO));
#endif /* WIN32_PLATFORM_PSPC */
#endif /* _WIN32_WCE */
		return OnMainWindowCreate(hWnd, message, wParam, lParam);
	case WM_USER_WAKEUP:
		if (bSending) {
			trx->stopflag = TRUE;
			trx->state    = TRX_STATE_FLUSH;
			sndmodem_stop_playing(&s_SndModem);
		} else
			sndmodem_stop_recording(&s_SndModem, FALSE);
		sndmodem_start_recording(&s_SndModem);
		break;
	case WM_ACTIVATE:
//   		if (s_iChannelActive == -1) // exiting
//			break;
#ifdef _WIN32_WCE
#ifdef WIN32_PLATFORM_PSPC
		if (SPI_SETSIPINFO == wParam){
//			memset(&sai, 0, sizeof(SHACTIVATEINFO));
			SHHandleWMActivate(hWnd, wParam, lParam, &sai, 0);
		}
#endif /* WIN32_PLATFORM_PSPC */
		//FIXME fullscreen
//		SHFullScreen(hWnd, SHFS_HIDETASKBAR);
#endif /* _WIN32_WCE */
		break;
	case WM_CLOSE:
		int i;
		if (trx_is_sending(trx))
			return 0;
		macro_store();
		stninfo_store();
		waterfall_store(&s_Waterfall);
		trxctrl_store(&g_TrxCtrl);
		sndmodem_store(&s_SndModem);
		sndmodem_destroy(&s_SndModem);
		trxctrl_destroy(&g_TrxCtrl);
#ifdef _WIN32_WCE
		CommandBar_Destroy(s_hWndCommandBar);
#endif /* _WIN32_WCE */
		DestroyWindow(s_hWndMain);
		break;
	case WM_DESTROY:
		for (i = 0; i < CHANNELS_MAX; ++ i) {
			if (s_aChannels[i] == 0)
				continue;
			trx_free(s_aChannels[i]);
			s_aChannels[i] = 0;
		}
		waterfall_destroy(&s_Waterfall);
		s_iChannelActive = -1;
        PostQuitMessage(0);
        break;
	case WM_SIZE:
		  DoLayout();
		  break;
	case WM_ERASEBKGND:
		// ignore background erasing
		return TRUE;
	case WM_SETTINGCHANGE:
#ifdef _WIN32_WCE
#ifdef WIN32_PLATFORM_PSPC
		if (wParam == SPI_SETSIPINFO) {
//			memset(&sai, 0, sizeof(SHACTIVATEINFO));
			SHHandleWMSettingChange(hWnd, -1, 0, &sai);
		}
#endif /* WIN32_PLATFORM_PSPC */
#endif /* _WIN32_WCE */
		break;
	case WM_TIMER:
	{
		// the only timer that is sent around is the AutoCQ start
		int iMacro = s_SndModem.nAutoCQMacro;
		sndmodem_kill_autocq(&s_SndModem);
		if (iMacro != -1)
			macro_send(trx, iMacro);
		break;
	}
	case MM_WIM_OPEN:
		UpdateMainMenuBar(0);
		s_bEnableMenuUpdate = TRUE;
		break;
	case MM_WIM_DATA:
		sndmodem_wim_data(&s_SndModem);
		break;
	case MM_WIM_CLOSE:
		sndmodem_wim_close(&s_SndModem);
		break;
	case MM_WOM_OPEN:
		UpdateMainMenuBar(1);
		break;
	case MM_WOM_DONE:
		sndmodem_wom_done(&s_SndModem);
		break;
	case MM_WOM_CLOSE:
		sndmodem_wom_close(&s_SndModem);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
  }
  return 0;
}

extern "C" BOOL main_pretranslate_message(MSG *msg)
{
	if (msg->message == WM_KEYDOWN) {
		sndmodem_kill_autocq(&s_SndModem);
		if (msg->wParam == VK_ESCAPE) {
			OnCommand(s_hWndMain, ID_KILLTX, 0);
			return TRUE;
		}
	}
	return FALSE;
}
