#ifndef __DLGGEN_H__
#define __DLGGEN_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <windows.h>

#ifdef WIN32_PLATFORM_PSPC
#include "Aygshell.h"
#endif /* WIN32_PLATFORM_PSPC */

#define DLG_MARGIN 3

typedef struct _DlgTemplate		DlgTemplate;

struct _DlgTemplate 
{ 
	DLGTEMPLATE	   *pTemplate;
	int				nLength;
	int				nSize;
	int				nMenuID;
	HWND			hWnd;
#ifdef WIN32_PLATFORM_PSPC
	SHACTIVATEINFO  sai;
#endif /* WIN32_PLATFORM_PSPC */
	int				nEntryFirstID;
	int				nEntries;
};

extern DlgTemplate*	dlggen_new();
extern void			dlggen_free(DlgTemplate *tmpl);

extern void			dlggen_create(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, int x, int y, int w, int h,
    LPCTSTR font /* = 0 */, LONG fontSize /* = 8 */);
extern HWND			dlggen_create_dialog(DlgTemplate *tmpl,
	HINSTANCE hInstance, HWND hWndParent, DLGPROC lpDialogFunc);
extern int			dlggen_dialog_box(DlgTemplate *tmpl,
	HINSTANCE hInstance, HWND hWndParent, DLGPROC lpDialogFunc);
extern void			dlggen_destroy(DlgTemplate *tmpl);

extern void			dlggen_add_component(DlgTemplate *tmpl, 
    LPCTSTR type, LPCTSTR caption, DWORD style, DWORD exStyle,
    int x, int y, int w, int h, WORD id);
extern void			dlggen_add_button(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id);
extern void			dlggen_add_edit_box(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id);
extern void			dlggen_add_static(DlgTemplate *tmpl, 
    LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id);
extern void			dlggen_add_listbox(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id);
extern void			dlggen_add_scrollbar(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id);
extern void			dlggen_add_combobox(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id);

extern void			dlggen_add_okcancel(DlgTemplate *tmpl);
#ifdef _WIN32_WCE
	#ifdef WIN32_PLATFORM_PSPC
		#define DLGGEN_WINDOW_STYLE		(WS_POPUP | WS_BORDER)
		#define DLGGEN_ENTRY_STYLE		(WS_CHILD | WS_VISIBLE | WS_TABSTOP | ES_AUTOHSCROLL | ES_AUTOVSCROLL)
		#define DLGGEN_ENTRY_STYLE_EX	(0)
		#define DLGGEN_EDITBOX_STYLE	(WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_VSCROLL | ES_AUTOHSCROLL | ES_AUTOVSCROLL | ES_MULTILINE | ES_WANTRETURN)
		#define DLGGEN_EDITBOX_STYLE_EX	(WS_EX_STATICEDGE)
	#else /* WIN32_PLATFORM_PSPC */
//		#define DLGGEN_WINDOW_STYLE (WS_CAPTION | WS_SYSMENU | DS_CENTER | DS_MODALFRAME)
		#define DLGGEN_WINDOW_STYLE		(DS_MODALFRAME | WS_POPUP | WS_VISIBLE | WS_CAPTION | WS_SYSMENU)
		#define DLGGEN_ENTRY_STYLE		(WS_CHILD | WS_VISIBLE | WS_TABSTOP | ES_AUTOHSCROLL | ES_AUTOVSCROLL)
		#define DLGGEN_ENTRY_STYLE_EX	(0)
		#define DLGGEN_EDITBOX_STYLE	(WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_VSCROLL | ES_AUTOHSCROLL | ES_AUTOVSCROLL | ES_MULTILINE | ES_WANTRETURN)
		#define DLGGEN_EDITBOX_STYLE_EX	(WS_EX_STATICEDGE)
	#endif /* WIN32_PLATFORM_PSPC */
#else /* _WIN32_WCE */
		#define DLGGEN_WINDOW_STYLE		(WS_OVERLAPPEDWINDOW | DS_CENTER | DS_MODALFRAME)
		#define DLGGEN_ENTRY_STYLE		(WS_CHILD | WS_VISIBLE | WS_TABSTOP | ES_AUTOHSCROLL | ES_AUTOVSCROLL)
		#define DLGGEN_ENTRY_STYLE_EX	(WS_EX_STATICEDGE)
		#define DLGGEN_EDITBOX_STYLE	(WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_VSCROLL | ES_AUTOHSCROLL | ES_AUTOVSCROLL | ES_MULTILINE | ES_WANTRETURN)
		#define DLGGEN_EDITBOX_STYLE_EX	(WS_EX_STATICEDGE)
#endif /* _WIN32_WCE */

extern int			dlggen_dlgproc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __DLGGEN_H__ */
