#include <windows.h>
#include <tchar.h>

#include "dlggen.h"

extern HINSTANCE	g_hInst;

static void EnsureSpace(DlgTemplate *tmpl, int length)
{
	void *newBuffer = 0;
	if (length + tmpl->nLength <= tmpl->nSize)
		return;
	tmpl->nSize += length * 2;
	tmpl->pTemplate = realloc(tmpl->pTemplate, tmpl->nSize);
}

static void AppendData(DlgTemplate *tmpl, void* data, int dataLength)
{
	EnsureSpace(tmpl, dataLength);
	memcpy((char*)tmpl->pTemplate + tmpl->nLength, data, dataLength);
    tmpl->nLength += dataLength;
}

static void AlignData(DlgTemplate *tmpl, int size)
{
	int paddingSize = tmpl->nLength % size;
    if (paddingSize != 0) {
		EnsureSpace(tmpl, paddingSize);
        tmpl->nLength += paddingSize;
    }
}

static void AppendString(DlgTemplate *tmpl, LPCTSTR string)
{
#ifndef _UNICODE
	WCHAR* wideString = 0;
    int length = MultiByteToWideChar(CP_ACP, 0, string, -1, NULL, 0);
    wideString = (WCHAR*)malloc(length * sizeof(WCHAR));
    MultiByteToWideChar(CP_ACP, 0, string, -1, wideString, length);
    AppendData(tmpl, wideString, length * sizeof(WCHAR));
    free(wideString);
#else
	int length = (int)wcslen(string) + 1;
    AppendData(tmpl, (void*)string, length * sizeof(WCHAR));
#endif
}

static void AddStandardComponent(DlgTemplate *tmpl, 
	WORD type, LPCTSTR caption, DWORD style,
    DWORD exStyle, int x, int y, int w, int h, WORD id)
{
	DLGITEMTEMPLATE item;
    WORD preType = 0xFFFF;

    // DWORD algin the beginning of the component data
    AlignData(tmpl, sizeof(DWORD));

    item.style			 = style;
    item.x				 = x;
    item.y				 = y;
    item.cx				 = w;
    item.cy				 = h;
    item.id				 = id;
    item.dwExtendedStyle = exStyle;

    AppendData(tmpl, &item, sizeof(DLGITEMTEMPLATE));
    AppendData(tmpl, &preType, sizeof(WORD));
    AppendData(tmpl, &type, sizeof(WORD));
    AppendString(tmpl, caption);

	++ tmpl->pTemplate->cdit;
}

DlgTemplate* dlggen_new()
{
	DlgTemplate *tmpl = (DlgTemplate*)malloc(sizeof(DlgTemplate));
	if (tmpl == 0)
		return 0;
	memset(tmpl, 0, sizeof(DlgTemplate));
	return tmpl;
}

void dlggen_free(DlgTemplate *tmpl)
{
	if (tmpl == 0)
		return;
	dlggen_destroy(tmpl);
	free(tmpl);
}

extern void	dlggen_create(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, int x, int y, int w, int h,
    LPCTSTR font /* = 0 */, LONG fontSize /* = 8 */)
{
	memset(tmpl, 0, sizeof(DlgTemplate));
	tmpl->nLength	= sizeof(DLGTEMPLATE);
	tmpl->nSize		= tmpl->nLength;
	tmpl->pTemplate = (DLGTEMPLATE*)malloc(tmpl->nSize);
	tmpl->pTemplate->style			 = style | DS_SETFONT;
	tmpl->pTemplate->x				 = x;
	tmpl->pTemplate->y				 = y;
	tmpl->pTemplate->cx				 = w;
	tmpl->pTemplate->cy				 = h;
	tmpl->pTemplate->cdit			 = 0;
	tmpl->pTemplate->dwExtendedStyle = 0;

	//the dialog box doesn't have a menu or a special class
    AppendData(tmpl, _T("\0"), 2);
    AppendData(tmpl, _T("\0"), 2);

    //add the dialog's caption to the template
    AppendString(tmpl, caption);

    AppendData(tmpl, &fontSize, sizeof(WORD));
    AppendString(tmpl, font);
}

HWND dlggen_create_dialog(DlgTemplate *tmpl,
	HINSTANCE hInstance, HWND hWndParent, DLGPROC lpDialogFunc)
{
	if (tmpl == 0)
		return 0;
	tmpl->hWnd = CreateDialogIndirect(hInstance, tmpl->pTemplate, hWndParent, lpDialogFunc);
	if (tmpl->hWnd != 0)
		SetWindowLong(tmpl->hWnd, GWL_USERDATA, (long)tmpl);
	return tmpl->hWnd;
}

int dlggen_dialog_box(DlgTemplate *tmpl,
	HINSTANCE hInstance, HWND hWndParent, DLGPROC lpDialogFunc)
{
	return DialogBoxIndirectParam (hInstance, tmpl->pTemplate, hWndParent, lpDialogFunc, (LPARAM)tmpl);
}

extern void	dlggen_destroy(DlgTemplate *tmpl)
{
	if (tmpl == 0)
		return;
	free(tmpl->pTemplate);
	memset(tmpl, 0, sizeof(DlgTemplate));
}

void dlggen_add_component(DlgTemplate *tmpl, 
	LPCTSTR type, LPCTSTR caption, DWORD style, DWORD exStyle,
    int x, int y, int w, int h, WORD id)
{
	DLGITEMTEMPLATE item;
    WORD creationDataLength = 0;

    item.style			 = style;
    item.x				 = x;
    item.y				 = y;
    item.cx				 = w;
    item.cy				 = h;
    item.id				 = id;
    item.dwExtendedStyle = exStyle;

    AppendData(tmpl, &item, sizeof(DLGITEMTEMPLATE));
    AppendString(tmpl, type);
    AppendString(tmpl, caption);
    AppendData(tmpl, &creationDataLength, sizeof(WORD));

	++ tmpl->pTemplate->cdit;
}

void dlggen_add_button(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id)
{
	WORD creationDataLength = 0;
    AddStandardComponent(tmpl, 0x0080, caption, style, exStyle, x, y, w, h, id);
    AppendData(tmpl, &creationDataLength, sizeof(WORD));
}

void dlggen_add_edit_box(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id)
{
    WORD creationDataLength = 0;
    AddStandardComponent(tmpl, 0x0081, caption, style, exStyle, x, y, w, h, id);
    AppendData(tmpl, &creationDataLength, sizeof(WORD));
}

void dlggen_add_static(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id)
{
    WORD creationDataLength = 0;
	AddStandardComponent(tmpl, 0x0082, caption, style, exStyle, x, y, w, h, id);
	AppendData(tmpl, &creationDataLength, sizeof(WORD));
}

void dlggen_add_listbox(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id)
{
	WORD creationDataLength = 0;
    AddStandardComponent(tmpl, 0x0083, caption, style, exStyle, x, y, w, h, id);
    AppendData(tmpl, &creationDataLength, sizeof(WORD));
}

void dlggen_add_scrollbar(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id)
{
    WORD creationDataLength = 0;
    AddStandardComponent(tmpl, 0x0084, caption, style, exStyle, x, y, w, h, id);
    AppendData(tmpl, &creationDataLength, sizeof(WORD));
}

void dlggen_add_combobox(DlgTemplate *tmpl, 
	LPCTSTR caption, DWORD style, DWORD exStyle, int x, int y,
    int w, int h, WORD id)
{
    WORD creationDataLength = 0;
    AddStandardComponent(tmpl, 0x0085, caption, style, exStyle, x, y, w, h, id);
    AppendData(tmpl, &creationDataLength, sizeof(WORD));
}

void dlggen_add_okcancel(DlgTemplate *tmpl)
{
#ifndef WIN32_PLATFORM_PSPC
	dlggen_add_button(tmpl, _T("OK"),		WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0,  2, 140, 38, 15, IDOK);
	dlggen_add_button(tmpl, _T("Cancel"),	WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0, 50, 140, 38, 15, IDCANCEL);
#endif /* WIN32_PLATFORM_PSPC */
}

int dlggen_dlgproc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	DlgTemplate *tmpl = (DlgTemplate*)GetWindowLong(hWnd, GWL_USERDATA);
	if (tmpl == 0 && uMsg != WM_INITDIALOG)
		return -1;

    switch(uMsg)
    {

    case WM_INITDIALOG:
	{
		SetWindowLong(hWnd, GWL_USERDATA, lParam);
		tmpl = (DlgTemplate*)lParam;
		tmpl->hWnd = hWnd;
#ifdef _WIN32_WCE
#ifdef WIN32_PLATFORM_PSPC
		memset(&tmpl->sai, 0, sizeof(tmpl->sai));
        {
            SHINITDLGINFO shidi;
            shidi.dwMask	= SHIDIM_FLAGS;
            shidi.dwFlags	= SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
            shidi.hDlg		= hWnd;
            SHInitDialog(&shidi);
        }
		{
			SHMENUBARINFO mbi;
			memset(&mbi, 0, sizeof(SHMENUBARINFO));
			mbi.cbSize		= sizeof(SHMENUBARINFO);
			mbi.hwndParent	= hWnd;
			mbi.hInstRes	= g_hInst;
			if (tmpl->nMenuID == 0)
				mbi.dwFlags	= SHCMBF_EMPTYBAR;
			else
				mbi.nToolBarId = tmpl->nMenuID;
			SHCreateMenuBar(&mbi);
		}
#else /* WIN32_PLATFORM_PSPC */
		{
			HDC hDC = GetDC(0);
			SetWindowPos(hWnd, HWND_TOPMOST, GetDeviceCaps(hDC, HORZSIZE) / 2 - 120, GetDeviceCaps(hDC, VERTSIZE) / 2 - 120, 240, 240, SWP_NOMOVE | SWP_SHOWWINDOW);
			ReleaseDC(0, hDC);
		}
#endif /* WIN32_PLATFORM_PSPC */
#else /* _WIN32_WCE */
		SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 240, 240, SWP_NOMOVE | SWP_SHOWWINDOW);
#endif /* _WIN32_WCE */
        return TRUE;
	}
	case WM_ACTIVATE:

#ifdef WIN32_PLATFORM_PSPC
		if (wParam == SPI_SETSIPINFO) {
			memset(&tmpl->sai, 0, sizeof(SHACTIVATEINFO));
			SHHandleWMActivate(hWnd, wParam, lParam, &tmpl->sai, 0);
		}
#endif /* WIN32_PLATFORM_PSPC */
		return 0;

	case WM_SETTINGCHANGE:
#ifdef WIN32_PLATFORM_PSPC
		if (wParam == SPI_SETSIPINFO) {
			memset(&tmpl->sai, 0, sizeof(SHACTIVATEINFO));
			SHHandleWMSettingChange(hWnd, -1, 0, &tmpl->sai);
		}
#endif /* WIN32_PLATFORM_PSPC */
		return 0;

	case WM_SIZE:
	{
		RECT rectWnd, rectValue;
		int  i;
		GetClientRect(hWnd, &rectWnd);
		for (i = 0; i < tmpl->nEntries; ++ i) {
			HWND hWndValue = GetDlgItem(hWnd, tmpl->nEntryFirstID + i);
			GetWindowRect(hWndValue, &rectValue);
			ScreenToClient(hWnd, (LPPOINT)(&rectValue.left));
			ScreenToClient(hWnd, (LPPOINT)(&rectValue.right));
			MoveWindow(hWndValue, rectValue.left, rectValue.top,
				rectWnd.right - rectWnd.left - rectValue.left - 2, 
				rectValue.bottom - rectValue.top, TRUE);
		}
#ifndef WIN32_PLATFORM_PSPC
		{
			HWND hWndOK		= GetDlgItem(hWnd, IDOK);
			HWND hWndCancel = GetDlgItem(hWnd, IDCANCEL);
			RECT rectButton;
			GetWindowRect(hWndOK, &rectButton);
			ScreenToClient(hWnd, (LPPOINT)(&rectButton.left));
			ScreenToClient(hWnd, (LPPOINT)(&rectButton.right));
			MoveWindow(hWndCancel, 
				rectWnd.right - DLG_MARGIN - (rectButton.right - rectButton.left), 
				rectWnd.bottom - DLG_MARGIN - (rectButton.bottom - rectButton.top),
				rectButton.right - rectButton.left, 
				rectButton.bottom - rectButton.top, TRUE);
			MoveWindow(hWndOK, 
				rectWnd.right - 3 * DLG_MARGIN - 2 * (rectButton.right - rectButton.left),
				rectWnd.bottom - DLG_MARGIN - (rectButton.bottom - rectButton.top),
				rectButton.right - rectButton.left, 
				rectButton.bottom - rectButton.top, TRUE);
		}
#endif /* WIN32_PLATFORM_PSPC */
		return 0;
	}

	case WM_PAINT:
#ifdef WIN32_PLATFORM_PSPC
	if (tmpl->nEntries > 0) {
		PAINTSTRUCT paint;
		RECT		rect, rectClient;
		POINT		line[2];
		HGDIOBJ		hOldPen;
		HPEN		hNewPen;
		int			i;
		BeginPaint(hWnd, &paint);
		GetWindowRect(hWnd, &rect);
		GetClientRect(hWnd, &rectClient);
		hNewPen = CreatePen(PS_SOLID, 0, RGB(127, 127, 127));
		hOldPen = SelectObject(paint.hdc, hNewPen);
		for (i = 0; i < tmpl->nEntries; ++ i) {
			HWND hControl  = GetDlgItem(hWnd, tmpl->nEntryFirstID + i);
			RECT rectControl;
			GetWindowRect(hControl, &rectControl);
			ScreenToClient(hWnd, (LPPOINT)&rectControl.left);
			ScreenToClient(hWnd, (LPPOINT)&rectControl.right);
			line[0].x = rectControl.left;
			line[1].x = rectControl.right;
			line[0].y = rectControl.bottom;
			line[1].y = line[0].y;
			Polyline(paint.hdc, line, 2);
		}
		SelectObject(paint.hdc, hOldPen);
		DeleteObject(hNewPen);
		EndPaint(hWnd, &paint);
	}
#endif WIN32_PLATFORM_PSPC
		return 0;

    default:
        break;
	}

    return -1;
}
