#include <windows.h>
#include <commdlg.h>
#include <tchar.h>

#include <string.h>
#include <stdio.h>
#include <ctype.h>

#ifdef _WIN32_WCE
#ifdef WIN32_PLATFORM_PSPC
#include <Aygshell.h>
#endif /* WIN32_PLATFORM_PSPC */
#endif /* _WIN32_WCE */

#include "cat.h"
#include "dlggen.h"
#include "sndmodem.h"
#include "trxctrl.h"
#include "../resource.h"

extern HINSTANCE	g_hInst;
extern HWND			s_hWndMain;
extern SndModem		s_SndModem;

#define ID_LABEL	101
#define ID_NAME		102
#define ID_VALUE	103

typedef struct _Preset Preset;

struct _Preset {
	TCHAR *name;
	TCHAR *freq;
};

static Preset s_aPresets[NUMPRESETS];

#define ID_FREQ							10
#define ID_NUM1							11
#define ID_NUM2							12
#define ID_NUM3							13
#define ID_NUM4							14
#define ID_NUM5							15
#define ID_NUM6							16
#define ID_NUM7							17
#define ID_NUM8							18
#define ID_NUM9							19
#define ID_NUM0							20
#define ID_NUM_DOT						21
#define ID_NUM_BACK						22
#define ID_NUM_CLEAR					23
#define ID_NUM_SEND						24

INT_PTR CALLBACK catfreq_dlgproc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int res;
	
	if (uMsg == WM_INITDIALOG) {
/*
		HWND hWndName  = GetDlgItem(hwnd, ID_NAME);
		HWND hWndValue = GetDlgItem(hwnd, ID_VALUE);
		if (s_aMacros[s_iMacroEdited].name != 0)
			SetWindowText(hWndName, s_aMacros[s_iMacroEdited].name);
		if (s_aMacros[s_iMacroEdited].text != 0)
			SetWindowText(hWndValue, s_aMacros[s_iMacroEdited].text);
*/
	}

    switch(uMsg)
    {

	case WM_INITDIALOG:
		SendMessage(GetDlgItem(hwnd, ID_FREQ), EM_SETLIMITTEXT, 12, 0);
		break;
	case WM_SIZE:
	{
		RECT rectWnd, rectButtons, rectFreq;
		int  nButtonWidth, nButtonHeight;
		int  nSeparator = 5;
		int  nX, nY;
		GetClientRect(hwnd, &rectWnd);
		GetWindowRect(GetDlgItem(hwnd, ID_FREQ), &rectFreq);
		MoveWindow(GetDlgItem(hwnd, ID_FREQ), nSeparator, nSeparator, 
			rectWnd.right - rectWnd.left - 2 * nSeparator, rectFreq.bottom - rectFreq.top, TRUE);		
		rectButtons.left   = 0;
		rectButtons.right  = rectWnd.right - rectWnd.left;
		rectButtons.top    = nSeparator + rectFreq.bottom - rectFreq.top;
		rectButtons.bottom = rectWnd.bottom - rectWnd.top;
		nButtonWidth  = (rectButtons.right - rectButtons.left - 4 * nSeparator) / 3;
		nButtonHeight = (rectButtons.bottom - rectButtons.top - 6 * nSeparator) / 5;
		nX = rectButtons.left + nSeparator;
		nY = rectButtons.top + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM1), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX += nButtonWidth + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM2), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX += nButtonWidth + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM3), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX = rectButtons.left + nSeparator;
		nY += nButtonHeight + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM4), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX += nButtonWidth + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM5), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX += nButtonWidth + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM6), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX = rectButtons.left + nSeparator;
		nY += nButtonHeight + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM7), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX += nButtonWidth + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM8), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX += nButtonWidth + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM9), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX = rectButtons.left + nSeparator;
		nY += nButtonHeight + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM_BACK), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX += nButtonWidth + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM0), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX += nButtonWidth + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM_DOT), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX = rectButtons.left + nSeparator;
		nY += nButtonHeight + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM_SEND), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX += nButtonWidth + nSeparator;
		MoveWindow(GetDlgItem(hwnd, ID_NUM_CLEAR), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		nX += nButtonWidth + nSeparator;
		MoveWindow(GetDlgItem(hwnd, IDCANCEL), nX, nY, nButtonWidth, nButtonHeight, TRUE);
		return 0;
	}

	case WM_COMMAND:
		if (LOWORD(wParam) == ID_NUM_SEND) {
			HWND  hEdit = GetDlgItem(hwnd, ID_FREQ);
			TCHAR cur[20];
			UCHAR data[4] = { 0x00, 0x00, 0x00, 0x00 };
			TCHAR *pDot = 0;
			UCHAR *ptr  = data;
			int    i;
			int    nLength   = 0;
			int    nDecimals = 0;
			SendMessage(hEdit, WM_GETTEXT, 20, (LPARAM)cur);
			nLength = _tcslen(cur);
			pDot	= _tcschr(cur, '.');
			if (pDot != 0) {
				nDecimals = _tcslen(pDot) - 1;
				memcpy(pDot, pDot + 1, nDecimals);
				-- nLength;
			}
			while (nDecimals < 3) {
				cur[nLength ++] = '0';
				++ nDecimals;
			}
			cur[nLength] = 0;
			for (i = nLength - 1; i >= 0; -- i, ++ ptr) {
				*ptr = cur[i] - '0';
				if (-- i >= 0)
					*ptr |= (cur[i] - '0') << 4;
			}
			data[0] = 0;
			trxctrl_ats3_command(&g_TrxCtrl, &s_SndModem, 2 /* command setfreq */, data, 4);
		} else if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) {
            EndDialog(hwnd, LOWORD(wParam) == IDOK);
            return 0;
		} else if (LOWORD(wParam) >= ID_NUM1 && LOWORD(wParam) <= ID_NUM_DOT) {
			HWND  hEdit = GetDlgItem(hwnd, ID_FREQ);
			TCHAR buf[2] = { 0, 0 };
			TCHAR cur[20];
			TCHAR *pDot = 0;
			SendMessage(hEdit, WM_GETTEXT, 20, (LPARAM)cur);
			pDot = _tcschr(cur, '.');
			if (LOWORD(wParam) == ID_NUM_DOT) {
				buf[0] = (pDot != 0) ? 0 : '.';
			} else {
				BOOL bAdd = (pDot == 0) ? (_tcslen(cur) < 5) : (_tcslen(pDot) < 4);
				if (cur[0] == 0 && LOWORD(wParam) == ID_NUM0)
					bAdd = FALSE;
				if (bAdd)
					buf[0] = (LOWORD(wParam) == ID_NUM0) ? '0' : LOWORD(wParam) - ID_NUM1 + '1';
			}
			SendMessage(hEdit, EM_SETSEL, SendMessage(hEdit, WM_GETTEXTLENGTH, 0, 0), -1);
			SendMessage(hEdit, EM_REPLACESEL, (WPARAM)FALSE /* can undo */, (LPARAM)buf);
		} else if (LOWORD(wParam) == ID_NUM_BACK || LOWORD(wParam) == ID_NUM_CLEAR) {
			HWND  hEdit = GetDlgItem(hwnd, ID_FREQ);
			TCHAR buf[2] = { 0, 0 };
			SendMessage(hEdit, EM_SETSEL, 
				(LOWORD(wParam) == ID_NUM_BACK) ? (SendMessage(hEdit, WM_GETTEXTLENGTH, 0, 0) -1) : 0, -1);
			SendMessage(hEdit, EM_REPLACESEL, (WPARAM)FALSE /* can undo */, (LPARAM)buf);
		}
        break;

    default:
        break;
	}

	res = dlggen_dlgproc(hwnd, uMsg, wParam, lParam);
	if (res >= 0)
		return res;

    return FALSE;
}

BOOL cat_freqdlg()
{
	DlgTemplate tmpl;
	dlggen_create(&tmpl, _T("Transceiver Control"), DLGGEN_WINDOW_STYLE,
		CW_USEDEFAULT, CW_USEDEFAULT, 137, 170, _T("Tahoma"), 12);
/*
	dlggen_add_static(&tmpl, _T("Name"),
		WS_CHILD | WS_VISIBLE, 0, 2, 2, 30, 10, ID_LABEL);
	dlggen_add_edit_box(&tmpl, _T(""), DLGGEN_ENTRY_STYLE, DLGGEN_ENTRY_STYLE_EX,
		34, 2, 101, 10, ID_NAME);
	dlggen_add_static(&tmpl, _T("Macro text"),
		WS_CHILD | WS_VISIBLE, 0, 2, 17, 134, 12, ID_LABEL);
	dlggen_add_edit_box(&tmpl, _T(""), DLGGEN_EDITBOX_STYLE, DLGGEN_EDITBOX_STYLE_EX,
		2, 30, 133, 100, ID_VALUE);
*/
	dlggen_add_edit_box(&tmpl, _T(""), DLGGEN_ENTRY_STYLE | ES_NUMBER | ES_RIGHT, DLGGEN_ENTRY_STYLE_EX,
		34, 2, 101, 10, ID_FREQ);

	dlggen_add_button(&tmpl, _T("1"),  WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0,  0,  0, 20, 20, ID_NUM1);
	dlggen_add_button(&tmpl, _T("2"),  WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0, 25,  0, 20, 20, ID_NUM2);
	dlggen_add_button(&tmpl, _T("3"),  WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0, 50,  0, 20, 20, ID_NUM3);
	dlggen_add_button(&tmpl, _T("4"),  WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0,  0, 25, 20, 20, ID_NUM4);
	dlggen_add_button(&tmpl, _T("5"),  WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0, 25, 25, 20, 20, ID_NUM5);
	dlggen_add_button(&tmpl, _T("6"),  WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0, 50, 25, 20, 20, ID_NUM6);
	dlggen_add_button(&tmpl, _T("7"),  WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0,  0, 50, 20, 20, ID_NUM7);
	dlggen_add_button(&tmpl, _T("8"),  WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0, 25, 50, 20, 20, ID_NUM8);
	dlggen_add_button(&tmpl, _T("9"),  WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0, 50, 50, 20, 20, ID_NUM9);
	dlggen_add_button(&tmpl, _T("<-"), WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0,  0, 75, 20, 20, ID_NUM_BACK);
	dlggen_add_button(&tmpl, _T("0"),  WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0, 25, 75, 20, 20, ID_NUM0);
	dlggen_add_button(&tmpl, _T("."),  WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0, 50, 75, 20, 20, ID_NUM_DOT);

	dlggen_add_button(&tmpl, _T("Set"),   WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0, 25, 100, 20, 20, ID_NUM_SEND);
	dlggen_add_button(&tmpl, _T("Clr"),   WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0, 25, 100, 20, 20, ID_NUM_CLEAR);
	dlggen_add_button(&tmpl, _T("Close"), WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0, 50, 100, 20, 20, IDCANCEL);

	return dlggen_dialog_box(&tmpl, g_hInst, s_hWndMain, catfreq_dlgproc) == IDOK;
}

extern UINT	s_iTXMode;

void cat_update_menu(HMENU hMenu)
{
	int i;
	int nEnabledOnRX = (s_iTXMode == 0) ? MF_ENABLED : MF_GRAYED;

	// Remove all items
	for (i = 0; i < NUMPRESETS + 5; ++ i)
		if (! DeleteMenu(hMenu, 0, MF_BYPOSITION))
			break;

	if (g_TrxCtrl.nType != TRXCTRL_ATS3_BELL202 && g_TrxCtrl.nType != TRXCTRL_ATS3_MANCHESTER) {
		AppendMenu(hMenu, MF_GRAYED | MF_STRING, 0, _T("TRX not supported"));
		return;
	}

/*
	for (i = 0; i < NUMPRESETS; ++ i) {
		TCHAR buf[256];
		if (s_aPresets[i].name == 0 && s_aPresets[i].freq == 0)
			continue;
		_stprintf(buf, _T("%d: %s"), i + 1, (s_aPresets[i].name == 0) ? _T("No name") : s_aPresets[i].name);
		AppendMenu(hMenu, MF_ENABLED | MF_STRING, ID_FREQ_PRESET1 + i, buf);
	}

	AppendMenu(hMenu, MF_ENABLED | MF_SEPARATOR, 0, 0);
*/
	AppendMenu(hMenu, nEnabledOnRX | MF_STRING, ID_FREQ_DLG, _T("Frequency ..."));
//	AppendMenu(hMenu, MF_ENABLED | MF_STRING, ID_CAT_SETDEFAULTS, _T("Load defaults"));
}

/*
void cat_load()
{
	HKEY  hKeyMacros = 0;
	int   i;

	memset(s_aMacros, 0, sizeof(s_aMacros));

	if (RegOpenKeyEx(HKEY_CURRENT_USER, _T("Software\\OK1IAK\\PocketDigi\\Macros"), 0, 
		KEY_ENUMERATE_SUB_KEYS | KEY_QUERY_VALUE | KEY_READ, &hKeyMacros) != ERROR_SUCCESS) {
		macro_load_defaults();
		return;
	}

	for (i = 0; i < NUMMACROS; ++ i) {
		TCHAR strKey[4];
		HKEY hKeyThis	 = 0;
		DWORD dwType	 = REG_SZ;
		DWORD dwSizeName = 0;
		DWORD dwSizeText = 0;
		_stprintf(strKey, _T("%d"), i + 1);
		if (RegOpenKeyEx(hKeyMacros, strKey, 0, 
			KEY_ENUMERATE_SUB_KEYS | KEY_QUERY_VALUE | KEY_READ, &hKeyThis) != ERROR_SUCCESS)
			continue;
		if (RegQueryValueEx(hKeyThis, _T("Name"), 0, &dwType, 0, &dwSizeName) == ERROR_SUCCESS) {
			s_aMacros[i].name = malloc(dwSizeName);
			RegQueryValueEx(hKeyThis, _T("Name"), 0, &dwType, (LPBYTE)s_aMacros[i].name, &dwSizeName);
		}
		if (RegQueryValueEx(hKeyThis, _T("Text"), 0, &dwType, 0, &dwSizeText) == ERROR_SUCCESS) {
			s_aMacros[i].text = malloc(dwSizeText);
			RegQueryValueEx(hKeyThis, _T("Text"), 0, &dwType, (LPBYTE)s_aMacros[i].text, &dwSizeText);
		}
		RegCloseKey(hKeyThis);
	}

	RegCloseKey(hKeyMacros);
}

void cat_load_defaults()
{
	int i;
	for (i = 0; i < NUMMACROS; ++ i) {
		free(s_aMacros[i].name);
		free(s_aMacros[i].text);
	}
	memset(s_aMacros, 0, sizeof(s_aMacros));

	if (_tcscmp(MACRODEF1NAME, _T("")) != 0) {
		s_aMacros[0].name = _tcsdup(MACRODEF1NAME);
		s_aMacros[0].text = _tcsdup(MACRODEF1TEXT);
	}
	if (_tcscmp(MACRODEF2NAME, _T("")) != 0) {
		s_aMacros[1].name = _tcsdup(MACRODEF2NAME);
		s_aMacros[1].text = _tcsdup(MACRODEF2TEXT);
	}
	if (_tcscmp(MACRODEF3NAME, _T("")) != 0) {
		s_aMacros[2].name = _tcsdup(MACRODEF3NAME);
		s_aMacros[2].text = _tcsdup(MACRODEF3TEXT);
	}
	if (_tcscmp(MACRODEF4NAME, _T("")) != 0) {
		s_aMacros[3].name = _tcsdup(MACRODEF4NAME);
		s_aMacros[3].text = _tcsdup(MACRODEF4TEXT);
	}
	if (_tcscmp(MACRODEF5NAME, _T("")) != 0) {
		s_aMacros[4].name = _tcsdup(MACRODEF5NAME);
		s_aMacros[4].text = _tcsdup(MACRODEF5TEXT);
	}
	if (_tcscmp(MACRODEF6NAME, _T("")) != 0) {
		s_aMacros[5].name = _tcsdup(MACRODEF6NAME);
		s_aMacros[5].text = _tcsdup(MACRODEF6TEXT);
	}
	if (_tcscmp(MACRODEF7NAME, _T("")) != 0) {
		s_aMacros[6].name = _tcsdup(MACRODEF7NAME);
		s_aMacros[6].text = _tcsdup(MACRODEF7TEXT);
	}
	if (_tcscmp(MACRODEF8NAME, _T("")) != 0) {
		s_aMacros[7].name = _tcsdup(MACRODEF8NAME);
		s_aMacros[7].text = _tcsdup(MACRODEF8TEXT);
	}
	if (_tcscmp(MACRODEF9NAME, _T("")) != 0) {
		s_aMacros[8].name = _tcsdup(MACRODEF9NAME);
		s_aMacros[8].text = _tcsdup(MACRODEF9TEXT);
	}
	if (_tcscmp(MACRODEF10NAME, _T("")) != 0) {
		s_aMacros[9].name = _tcsdup(MACRODEF10NAME);
		s_aMacros[9].text = _tcsdup(MACRODEF10TEXT);
	}
	if (_tcscmp(MACRODEF11NAME, _T("")) != 0) {
		s_aMacros[10].name = _tcsdup(MACRODEF11NAME);
		s_aMacros[10].text = _tcsdup(MACRODEF11TEXT);
	}
	if (_tcscmp(MACRODEF12NAME, _T("")) != 0) {
		s_aMacros[11].name = _tcsdup(MACRODEF12NAME);
		s_aMacros[11].text = _tcsdup(MACRODEF12TEXT);
	}
}

void cat_store()
{
	HKEY  hKeyMacros    = 0;
	DWORD dwDisposition = 0;
	int   i;

	if (RegCreateKeyEx(HKEY_CURRENT_USER, _T("Software\\OK1IAK\\PocketDigi\\Presets"), 0, 0,
		REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &hKeyMacros, &dwDisposition) != ERROR_SUCCESS)
		return;

	for (i = 0; i < NUMPRESETS; ++ i) {
		TCHAR strKey[4];
		HKEY hKeyThis	 = 0;
		DWORD dwType	 = REG_SZ;
		DWORD dwSizeName = 0;
		DWORD dwSizeText = 0;
		if (s_aPresets[i].name == 0 && s_aPresets[i].freq == 0)
			continue;
		_stprintf(strKey, _T("%d"), i + 1);
		if (RegCreateKeyEx(hKeyMacros, strKey, 0, 0, 0, KEY_SET_VALUE, 0, &hKeyThis, &dwDisposition) != ERROR_SUCCESS)
			continue;
		if (s_aMacros[i].name != 0) 
			RegSetValueEx(hKeyThis, _T("Name"), 0, REG_SZ, 
				(LPBYTE)s_aMacros[i].name, (_tcslen(s_aMacros[i].name) + 1) * sizeof(TCHAR));
		if (s_aMacros[i].text != 0)
			RegSetValueEx(hKeyThis, _T("Text"), 0, REG_SZ, 
				(LPBYTE)s_aMacros[i].text, (_tcslen(s_aMacros[i].text) + 1) * sizeof(TCHAR));
	}
}
*/