#ifndef __ColorTable_h
#define __ColorTable_h

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void CreateColorGradient(
	double dHue0, double dHue1, double dSat0, double dSat1, double dLight0, double dLight1,
	COLORREF *pColorsOut, int nColorsOut);

/// power gradient optimized for 16bit displays like of iPaq 3630
/// nColorsOut must be exactly 91
void CreatePowerColorGradient16bit(COLORREF *pColorsOut, int nColorsOut);

/// power gradient for color rich devices with at least 24 bit displays
/// nColorsOut must be exactly 6 * 255 + 1
void CreatePowerColorGradient24bit(COLORREF *pColorsOut, int nColorsOut);

/// power gradient for color rich devices with at least 24 bit displays
void CreatePowerColorGradient(COLORREF *pColorsOut, int nColorsOut);

void CreatePowerColorGradientSimple(int nBits, COLORREF *pColorsOut, int nColorsOut);

COLORREF HSVtoRGB(double dHue, double dSat, double dVal);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __ColorTable_h */