/*
 *    feldtx.c  --  FELDHELL transmitter
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "feld.h"
#include "../main/trx.h"
#include "../main/sndmodem.h"
#include "../misc/filter.h"
#include "../misc/misc.h"
#include "../misc/mixer.h"

#ifdef _WIN32_WCE
	#define _ASSERT(x) 
#else
	#include <crtdbg.h>
#endif /* _WIN32_WCE */

static void get_font_data(struct feld *s, TCHAR c)
{
	HDC		hDC			= GetWindowDC(0);
	HDC     hBmpDC		= CreateCompatibleDC(hDC);
	HGDIOBJ	hPrevFont	= SelectObject(hBmpDC, s->hTxFont);
	HGDIOBJ hPrevBitmap = SelectObject(hBmpDC, s->hTxBitmap);
	RECT    rect;
	SIZE    size;
	int		iPos		= 0;
	int		i, j;

	rect.left   = 0;
	rect.right  = s->nTxMaxCharWidth;
	rect.top    = 0;
	rect.bottom = TxColumnLen;
	ExtTextOut(hBmpDC, 0, 0, ETO_OPAQUE, &rect, &c, 1, 0);

	GetTextExtentPoint32(hBmpDC, &c, 1, &size);

	SelectObject(hBmpDC, hPrevBitmap);
	SelectObject(hBmpDC, hPrevFont);
	DeleteDC(hBmpDC);
	DeleteDC(hDC);

	for (i = 0; i < size.cx; ++ i) {
		UCHAR *bits = s->pTxBitmapBits + 3 * i;
		for (j = 0; j < TxColumnLen; ++ j) {
			s->pTxData[iPos ++] = 255 - *bits;
			bits += s->nTxFontRowInc;
		}
	}

	_ASSERT(iPos == size.cx * TxColumnLen);
	s->nTxDataPos = 0;
	s->nTxDataLen = iPos;
}

int feld_txprocess(Trx *trx)
{
	struct feld *s			 = (struct feld*)trx->modem;
	unsigned	 iPhaseDelta = trx_freq2phase(trx->nTxFrequency);
	int  		 c;
	int			 nOutLen	 = 0;
	int			*ptr;

	// fill the pTxData buffer with a new character
	if (s->nTxDataLen == 0) {
		if (s->preamble -- > 0) {
			c = '.';
		} else {
			c = trx_get_tx_char(trx);
			// if TX buffer empty
			if (c == -1) {
				// stop if requested to...
				if (trx->stopflag) {
					if (s->postamble -- > 0)
						c = '.';
					else 
						c = ' ';
				} else				
					c = '.'; // idle character
			} else {
				trx_put_echo_char(trx, c);
				if (c == '\r' || c == '\n')
					c = ' ';
			}
		}
	//	if (trx->hell_upper)
	//		c = _totupper(c);
		/* rx echo */
	//	feld_rxprocess(trx, trx->pOutBuf, outlen);
		get_font_data(s, c);
	}

	ptr = s->pTxData + s->nTxDataPos;

	/* upsample, filter and modulate */
	for (;;) {
		int x;
		filter_I_run(s->txfilter, *ptr, &x);
		x >>= 15;
		trx->pModem->pOutBuf[nOutLen ++] = (mixer_osc_16(s->phaseacc) * x) >> 8;
		s->phaseacc	  += iPhaseDelta;
		s->symcounter += UpSampleInc;
		if ((s->symcounter & 0xff000000) == 0)
			continue;
		s->symcounter &= 0xffffff;
		++ ptr;
		if (-- s->nTxDataLen == 0 || nOutLen >= (trx->pModem->nBufSize >> 2))
			break;
	}

	/* write to soundcard */
	sndmodem_write(trx->pModem, trx->pModem->pOutBuf, nOutLen);
	s->nTxDataPos = ptr - s->pTxData;
	return 0;
}
