/*
 *    feldrx.c  --  FELDHELL receiver
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>

#ifdef _WIN32_WCE
#define _ASSERT(x) 
#else
	#include <crtdbg.h>
#endif /* _WIN32_WCE */

#include "feld.h"
#include "../misc/fixedpoint.h"
#include "../misc/filter.h"
#include "../misc/mixer.h"

#undef  MAX
#define MAX(a,b)			(((a)>(b))?(a):(b))
#undef  CLAMP
#define CLAMP(x,low,high)	(((x)>(high))?(high):(((x)<(low))?(low):(x)))

static void feld_rx(Trx *trx, cmplx z)
{
	struct feld *s = (struct feld*)trx->modem;
	double x;

	s->symcounter += DownSampleInc;
	if ((s->symcounter & 0xff000000) == 0)
		return;
	s->symcounter &= 0xffffff;

	x = ihypot(z.re, z.im);

	if (x > s->agc)
		s->agc = x;
	else
		s->agc *= (1 - 0.02 / RxColumnLen);

	x = 255 * CLAMP(1.0 - x / s->agc, 0.0, 1.0);
//FIXME
//	trx_put_rx_data((int) x);

//	trx->metric = s->agc / 10.0;
}

int feld_rxprocess(Trx *trx, short *buf, int len)
{
	struct feld *s = (struct feld*)trx->modem;
	cmplx		 z;

/*
	if (trx->bandwidth != trx->hell_bandwidth) {
		float lp = trx->hell_bandwidth / 2.0 / SampleRate;
		fftfilt_set_freqs(s->fftfilt, 0, lp);
		trx->bandwidth = trx->hell_bandwidth;
	}
*/
	while (len-- > 0) {
		/* Mix with the internal NCO */
		mixer_mix(*(buf ++), s->phaseacc, &z);
		s->phaseacc += trx_freq2phase(trx->nRxFrequency);
		z.re >>= 15;
		z.im >>= 15;
		filter_run(s->rxfilter, z, &z);
		z.re >>= 15;
		z.im >>= 15;
		feld_rx(trx, z);
	}

	return 0;
}
