/*
 *    feld.h  --  FELDHELL modem
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#pragma once

#include "../misc/cmplx.h"
#include "../main/trx.h"

#define	SampleRate	8000
#define	ColumnRate	17.5
#define BandWidth	245.0

#define	RxColumnLen	30
#define	TxColumnLen	14

#define	DownSampleInc	1101005 // (RxColumnLen*ColumnRate/SampleRate) << 24
#define	UpSampleInc		513802  // (TxColumnLen*ColumnRate/SampleRate) << 24

struct feld {
	/*
	 * RX related stuff
	 */
	unsigned int	phaseacc;
	int				symcounter;

	struct filter *rxfilter;
	struct filter *txfilter;

	double agc;

	/*
	 * TX related stuff
	 */
	int				preamble;
	int				postamble;

	HFONT			hTxFont;
	HBITMAP			hTxBitmap;
	UCHAR		   *pTxBitmapBits;
	int		       *pTxData;
	int				nTxDataPos;
	int				nTxDataLen;
	int		  	    nTxMaxCharWidth;
	int				nTxFontRowInc;
};

/* in feld.c */
extern void feld_init(Trx *trx);

/* in feldrx.c */
extern int feld_rxprocess(Trx *trx, short *buf, int len);

/* in feldtx.c */
extern int feld_txprocess(Trx *trx);

extern void feld_settxfont(Trx *trx, LPCTSTR strFont);

