/*
 *    feld.c  --  FELDHELL modem
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>

#include "feld.h"
#include "../misc/fixedpoint.h"
#include "../misc/filter.h"
#include "../misc/mixer.h"

static void feld_txinit(Trx *trx)
{
	struct feld  *s = (struct feld*)trx->modem;
	s->symcounter	= 0;
	s->preamble		= 3;
	s->postamble	= 3;
}

static void feld_rxinit(Trx *trx)
{
	struct feld  *s = (struct feld*)trx->modem;
	s->symcounter	= 0;
	s->agc			= 0;
}

static void feld_free(struct feld *s)
{
	if (s == 0)
		return;
	filter_free(s->rxfilter);
	filter_free(s->txfilter);
	DeleteObject(s->hTxFont);
	DeleteObject(s->hTxBitmap);
	free(s->pTxData);
	free(s);
}

static void feld_destructor(Trx *trx)
{
	struct feld *s = (struct feld*)trx->modem;
	feld_free(s);
    trx->modem		= 0;
    trx->txinit		= 0;
    trx->rxinit		= 0;
    trx->txprocess	= 0;
    trx->rxprocess	= 0;
    trx->destructor = 0;
}

void feld_init(Trx *trx)
{
//	GdkColor color;
//	GdkColormap *cmap;
//	GdkVisual *visual;
	struct feld *s;
	double lp;
//	PangoFontDescription *fontdesc;

	s = calloc(sizeof(struct feld), 1);

	lp = BandWidth / 2.0 / SampleRate;

	if ((s->txfilter = filter_init_lowpass(65, 1, lp)) == 0) {
		feld_free(s);
		return;
	}

//	lp = trx->hell_bandwidth / 2.0 / SampleRate;
	lp = 160.0 / 2.0 / SampleRate;

	if ((s->rxfilter = filter_init_lowpass(65, 1, lp)) == 0) {
		feld_free(s);
		return;
	}

	trx->modem		= s;

	trx->txinit		= feld_txinit;
	trx->rxinit		= feld_rxinit;
	trx->txprocess	= feld_txprocess;
	trx->rxprocess	= feld_rxprocess;
	trx->destructor = feld_destructor;
//	trx->samplerate = SampleRate;
//	trx->bandwidth	= trx->hell_bandwidth;

	feld_settxfont(trx, _T("FeldReal"));
}

void feld_settxfont(Trx *trx, LPCTSTR strFont)
{
	struct feld    *s		= (struct feld*)trx->modem;
	HDC				hDC		= GetWindowDC(0);
	HGDIOBJ			hPrevFont;
	LOGFONT			logfont;
	BITMAPINFO		bmi;
	TEXTMETRIC		tm;

	DeleteObject(s->hTxFont);
	DeleteObject(s->hTxBitmap);
	free(s->pTxData);

	memset(&logfont, 0, sizeof(LOGFONT));
	logfont.lfHeight  = -11;
	logfont.lfWeight  = FW_NORMAL;
	logfont.lfCharSet = ANSI_CHARSET;
	_tcscpy(logfont.lfFaceName, strFont);
	s->hTxFont = CreateFontIndirect(&logfont);

	hPrevFont = SelectObject(hDC, s->hTxFont);
	GetTextMetrics(hDC, &tm);
	s->nTxMaxCharWidth = tm.tmMaxCharWidth;
	SelectObject(hDC, hPrevFont);

	s->nTxFontRowInc = ((s->nTxMaxCharWidth * 24 + 31) & ~31) >> 3;

	memset(&bmi, 0, sizeof(BITMAPINFO));
	bmi.bmiHeader.biSize		= sizeof(bmi.bmiHeader);
	bmi.bmiHeader.biWidth		= s->nTxMaxCharWidth;
	bmi.bmiHeader.biHeight		= TxColumnLen;
	bmi.bmiHeader.biPlanes		= 1;
	bmi.bmiHeader.biBitCount	= 24;
	bmi.bmiHeader.biSizeImage   = s->nTxFontRowInc * TxColumnLen;
	bmi.bmiHeader.biCompression = BI_RGB;
	bmi.bmiHeader.biXPelsPerMeter = 3780;
	bmi.bmiHeader.biYPelsPerMeter = 3780;

	s->hTxBitmap = CreateDIBSection(hDC, &bmi, DIB_RGB_COLORS, (void**)&s->pTxBitmapBits, NULL, 0);
	memset(s->pTxBitmapBits, 0, bmi.bmiHeader.biSizeImage);
	ReleaseDC(0, hDC);

	s->pTxData = (int*)malloc(sizeof(int) * s->nTxMaxCharWidth * TxColumnLen);
}
