/*
 *    ax25rx.c  --  morse code modem
 *
 *    Copyright (C) 2007 Vojtech Bubnik OK1IAK <bubnikv@seznam.cz>
 *   
 *    This modem borrowed heavily from other gmfsk modems and
 *    from rtty project by Jesus Arias EB1DIX
 *
 *    This file is part of PocketDigi.
 *
 *    PocketDigi is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    PocketDigi is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with PocketDigi; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <string.h>

#include "../main/trx.h"
#include "ax25.h"
#include "../misc/filter.h"
#include "../misc/mixer.h"
#include "../misc/fixedpoint.h"
#include "../misc/crc32.h"

#if 0

unsigned short bit_phase=0;	/* bit phase */

float demodulator()
{
	float sample,xs,xm,y,ym;
    static float ymax=0.0,ymin=0.0;
	sample=get_audio_sample();

	xs=biq_bp(biq_bp(sample,bp0_c,bp0_b),bp0_c,bp0_b1);
    //xs=biq_bp(sample,bp0_c,bp0_b);
	xm=biq_bp(biq_bp(sample,bp1_c,bp1_b),bp1_c,bp1_b1);
    //xm=biq_bp(sample,bp1_c,bp1_b);
	xs*=xs;		/* xs RMS */
	xm*=xm;		/* xm RMS */
	return biq_lp(biq_lp(xm-xs, lp1_c, lp1_b), lp2_c, lp2_b);
}

int get_bit_raw()
{
	/* This function implements a digital PLL for data recovery */
        
	static float x0;
	BOOL	bFirst = TRUE;
	int		iPhase = 0;
	int		i;
    float x,ii=0.0;

    if (bit_phase > 0x8000)
		bit_phase -= 0x10000;
	for (iPhase = 0; bit_phase < 0x10000; bit_phase += fskdp->phs) {
		x = demodulator();
        ii += x;
		if ((x*x0 < 0.0)) {	/* Data Change */
			if (bFirst) {
				if (bit_phase > 0x8000)
					iPhase = 2048; /* Early */
				else 
					iPhase = -2048; /* Late */
                bFirst = FALSE;
			}
		}
		x0 = x;
	}
    bit_phase = (bit_phase + iPhase) & 0xffff;
    return (ii > 0) ? 0x80 : 0;
}

int get_bit()
{
	static int oldbit=0;
	int f,i;
	
	f=i=get_bit_raw();
        //printf("%d\n",i);
	f^=oldbit; f^=0x80;	/* Recuperamos NRZ */
	oldbit=i;
	return f;
}

int hdlc(char *buf, int len)
{
	static unsigned char stream=0;
	static int fl=0;
	int i,d,n,c1;

	/* Esperamos un flag (0x7E) */
flag:
	if (!fl) {
		do {
			if (fskdp->mode!=HDLC) return 0;
			stream>>=1;
			stream|=get_bit();
		} while (stream!=0x7E);
	}

	fl=1;

flag0:
	for(n=i=c1=0;;) {
		if (fskdp->mode!=HDLC) return 0;
		stream>>=1;
		stream|=get_bit();
		if (stream&0x80) c1++; else c1=0;
		if (c1==5) {				/* 5 unos seguidos */
			c1=0;
			if (get_bit()==0x80) {		/* 6 unos seguidos */
				if (get_bit()==0){	/* Lleg el flag   */
					if (n) break; else goto flag0;
				}
				else goto flag;	/* Error: volver a empezar */
			}
		}
		i++;	/* Contador de bits "cocinados" */
		if (i==8) {
			i=0;
			*buf++=stream;
			n++;	/* Contador de bytes */
                        if (n>=len) return n;
		}
	}
	return n;
}

void dump_addr(unsigned char *buf)
{
	int i=0;
	while (!(*buf&1)) {
		if (i!=6) 
			putchar(*buf>>1); 
		else {
			putchar('-'); 
			putchar('>');
		}
		++ i;
		++ buf;
	}
	putchar('\n');
}

void hdump(unsigned char *buf, int n)
{
	int fh = 0;
	int i,j;
	int dir = 0;

	do{
		j=n; if (j>16) j=16;
		printf("%8x ",dir);
		for (i=0;i<16;i++) {
			if (i<j) printf(" %02x",buf[i]); else printf("   ");
			if (i==7) putchar(' ');
		}
		printf("  ");
		for (i=0;i<j;i++) putchar(isprint(buf[i]&0x7f) ? buf[i]:'.');
		putchar('\n');
		dir+=j;
		buf+=j;
		n-=j;
	}while (n);
	fflush(stdout);
}

/*
static int bbfilt(struct ax25 *s, int in)
{
	int i, out;
	s->bbfilter[s->filterptr] = in;
	s->filterptr = (s->filterptr + 1) % s->symbollen;
	out = s->bbfilter[0];
	for (i = 1; i < s->symbollen; ++ i)
		out += s->bbfilter[i];
	return out / s->symbollen;
}
*/

int ax25_rxprocess(Trx *trx, short *buf, int len)
{
	struct ax25  *s = (struct ax25*)trx->modem;
	cmplx         z;
	int           i;

	while (len -- > 0) {
		/* Mix with the internal NCO */
		mixer_mix(*(buf ++), s->phaseacc, &z);
		s->phaseacc += trx_freq2phase(trx->nRxFrequency);
		z.re >>= 15;
		z.im >>= 15;

		/* Filter and downsample by 16 or 8 */
		if (filter_run(s->rxfilter, z, &z)) {
			int  sum = 0;
			int  idx;
			UINT ampl;
			int  level  = 0;
			int  ftemp  = 0;
			int  ampsum = 0;

			z.re >>= 16;
			z.im >>= 16;

			// save amplitude value for the sync scope
			ampl  = (UINT)(z.re * z.re) + (UINT)(z.im * z.im);
			level = isqrt(ampl);
			s->pipe[s->pipeptr] = level;

//			trx_set_scope(s->pipe, PipeLen, TRUE);

			/* Now the sync correction routine... */
			idx = s->bitclk >> 20;
//			idx = (int) s->bitclk;
			s->syncbuf[idx] = level;

			for (i = 0; i < 16; ++ i) {
				ftemp  += aSyncCoeffs[i] * s->syncbuf[i];
				ampsum += s->syncbuf[i];
			}
			ftemp = (ampsum != 0) ? (ftemp / ampsum) : 0;
			for (i = 0; i < 8; i++)
				sum += s->syncbuf[i];
			for (i = 8; i < 16; i++)
				sum -= s->syncbuf[i];
			sum = (ampsum != 0) ? ((sum << 12) / ampsum) : 0;
//			s->bitclk += ftemp << 5; // or 6
//			s->bitclk += ftemp << 4;
//			s->bitclk -= sum << (24 - 12 - 5);
// Works well for noisy signals
//			s->bitclk -= sum << (24 - 12 - 7);
			s->bitclk -= sum << (24 - 12 - 6);
/*
			{
				char bufout[256];
				sprintf(bufout, "syncdif: %ld\n", syncdif);
				OutputDebugString(bufout);
			}
*/

//FIXME test the sound card RX clock correction
			s->bitclk += 0x100000;
//			s->bitclk += 0x1028F5; // + 1%
//			s->bitclk += 0x0FD772; // - 1%
			if (s->bitclk & 0xFF000000) {
				// here we are at the center of the bit
				s->bitclk &= 0xFFFFFF;
				rx_symbol(trx, z);
				update_syncscope(trx);
			}

			s->pipeptr = (s->pipeptr + 1) % PipeLen;
		}
	}

	return 0;
}

#endif /* 0 */

int ax25_rxprocess(Trx *trx, short *buf, int len)
{
	return 0;
}