/*
 *    ax25.h  --  morse code modem
 *
 *    Copyright (C) 2007 Vojtech Bubnik OK1IAK <bubnikv@seznam.cz>
 *   
 *    This modem borrowed heavily from other gmfsk modems and
 *    from rtty project by Jesus Arias EB1DIX
 *
 *    This file is part of PocketDigi.
 *
 *    PocketDigi is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    PocketDigi is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with PocketDigi; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#pragma once

#include "../misc/cmplx.h"
#include "../main/trx.h"

#define	SampleRate			8000
#define WINDOWEXPAND		1.5
#define RXFILTOVERBITS		3
#define RXFILTOVER			(1<<(RXFILTOVERBITS))
#define RXFILTLEN			16
#define RXFILTFIDX(x)		(((x)>>(16-(RXFILTOVERBITS)))&(RXFILTOVER-1))
#define RXFILTFSAMP(x)		((x)>>16)

struct ax25 {
	///	length of one symbol in sound samples
	int				 symbollen;
	/// used by NCO for rx/tx tones
	unsigned int	 phaseacc;

	struct filter	*rxfilter;

	/// baud rate
	UINT			 bps;
	/// lower tone
	UINT			 f0;
	/// upper tone
	UINT			 f1;
    
    UINT			 rxbits;
	UINT			 rxphase;
    UINT			 rxphinc;
	int				 dcdcnt;
	UINT			 dcdtim;

	UINT			 div, divcnt;
	UINT			 pllinc, pll, pllthresh, pllcorr;
	UINT			 shreg, lastbit;
    int				 dcd_sum0, dcd_sum1, dcd_sum2;
	UINT			 dcd_time;
	UINT			 raws, rawb;
	UCHAR			 dcd;

	int				 f0r[RXFILTOVER][RXFILTLEN];
	int				 f0i[RXFILTOVER][RXFILTLEN];
	int				 f1r[RXFILTOVER][RXFILTLEN];
	int				 f1i[RXFILTOVER][RXFILTLEN];
};

/* in ax25.c */
extern void ax25_init(Trx *trx);
extern void ax25_sync_parameters(struct ax25 *c);

/* in ax25rx.c */
extern int ax25_rxprocess(Trx *trx, short *buf, int len);

/* in ax25tx.c */
extern int ax25_txprocess(Trx *trx);

extern void ax25_set_bandwidth(Trx *trx);

extern void ax25_set_txspeed(Trx *trx);
