#include <avr/io.h>
#include <avr/interrupt.h>
//
// tx_tst01.c
// by
// M. Ossmann
// 22. march 2007

// Program contiously sends a READ command to ISO15693 RFID
// then waits the time where RFID answers,
// the sends command again.
// The program does not contain receiver part !

// ATmega8 operated at 13.56 MHz
// fuses: external clock enabled

// Hardware connections

#define TRIGpin 5 // PD.5 (pin11) // trigger out for tests: high while TX
#define INTpin  4 // PD.4 (pin6)  // interrupt active: high while interrupt-service
#define MODpin  3 // PD.3 (pin5)  // TX modulation

// 13.56 MHz clock  ; divide by 128 yields: 9.439528.. us  means 105.9375 kHz
                            // variables used by interrupt routine
volatile uint8_t SHIFTcnt ; // how many bits to shift, goes from HOLDcnt downto 1
volatile uint8_t HOLDcnt ;  // Bits in TXhold
volatile uint8_t TXshift ;  // pattern shift register
volatile uint8_t TXhold ;   // pattern hold register
volatile uint8_t TXhfull ;  // 1 means is full

// ouput bit-pattern in TXshift in MSB first fashion
// reload TXshift by value in TXhold
// number of bits to output is in HOLDcnt resp SHIFTcnt

ISR(TIMER1_OVF_vect) {
   PORTD |= _BV(INTpin) ;                                 // signalize start of interrupt
   if (TXshift & 0x80) {  PORTD |=   _BV(MODpin) ; }      // output actual bit of pattern
                else   {  PORTD &= ~ _BV(MODpin) ; }
   TXshift = TXshift << 1 ;                               // shift to next position
   if ( 0==--SHIFTcnt) 
      { TXshift=TXhold ; TXhfull=0 ; SHIFTcnt=HOLDcnt ; } // reload shift register
   PORTD &= ~ _BV(INTpin) ;                               // signalize end of interrupt
}

 

//----------------------------------------------------------------------------------------

// CRC compuation directly copied from ISO15693 document

uint16_t CRCreg ;

void CRCinit(){ CRCreg=0xffff ;}
 
#define POLY 0x8408

void CRCadd(uint8_t b) {
	uint8_t k ;
	CRCreg ^= b ;
	for (k=0 ; k<8 ; k++ ) {
		if (CRCreg&1) { CRCreg=(CRCreg>>1) ^ POLY ; }
		else  	      { CRCreg=(CRCreg>>1)  ; }
		}
}


//------------------------------------------------------------------------------------


uint8_t BYTEbuffer[30] ;
uint8_t BYTEcount ;


void TXb(uint8_t b) {     // routine to transmit one byte serially
  while ( TXhfull ) { } ; // wait until TXhold is empty
  TXhold=b ;              // load with new byte
  TXhfull=1 ;             // and signal TXhold is full
  }


void TX(){                                     // transmit complete BYEbuffer
uint8_t k,j,theBYTE ;                          // some variables
   HOLDcnt=8 ;                                 // setup write mode
   for (k=0 ; k<30 ; k++ ) { TXb(0x00) ; }     // switch TX off: card reset
   for (k=0 ; k<30 ; k++ ) { TXb(0xFF) ; }     // TX on, charge card 
   PORTD |= _BV(TRIGpin) ;                     // trigger impulse for scope
   TXb(0b01111011) ;                           // transmit SOF
   for (k=0 ; k<BYTEcount ; k++ ){             // and emit buffer
      theBYTE=BYTEbuffer[k] ;                  // actual byte 
	  for (j=0 ; j<4 ; j++ ){                  // is four pairs	
	     switch ( theBYTE & 3 ) {              // select pair   
		    case 0: TXb( 0b10111111) ; break ; // one of four code
		    case 1: TXb( 0b11101111) ; break ; 
		    case 2: TXb( 0b11111011) ; break ; 
		    case 3: TXb( 0b11111110) ; break ; 
            }                                  // end of switch
         theBYTE=theBYTE>>2 ;                  // select next pair
		 }                                     // end of for j
      }                                        // end of for k
   TXb(0b11011111) ;                           // transmt EOF
   PORTD &= ~ _BV(TRIGpin) ;                   // trigger at end of send
   for (k=0 ; k<150 ; k++ ) { TXb(0xFF) ;  }   // wait and receive
   }


//------------------------------------------------------------------------------------

void putBYTE(uint8_t b){         // fill in one BYTE into buffer and update CRC
	BYTEbuffer[BYTEcount++]=b ;  // fill in 
	CRCadd(b) ;                  //  and update CRC
	} 

void TXreset(){                  // BYTEbuffer initialisation
	CRCinit() ;                  // CRC computation reset
	BYTEcount=0 ;                // Buffer is empty
}

void TXclose() {                 // close buffer
uint16_t finalCRCreg ;           // save store
    finalCRCreg= CRCreg^0xffff ; // complement CRC
	putBYTE(finalCRCreg) ;       // and append LSB first
	putBYTE(finalCRCreg >> 8) ;  // than MSB
	}

//---------------------------------------------------------------------------------------------------------

void readBLK(int n){ // a simple command
	TXreset() ;      // reset buffer
	putBYTE(0x00) ;  // flags
	putBYTE(0x20) ;  // read page
	putBYTE(n) ;     // number
	TXclose() ;      // append CRC to buffer
	TX() ;           // and transmit buffer
}


//----------------------------------------------------------------------------------------

int main(){
  DDRD  =0b11111110 ;  // RXD is input, other pins are output
  PORTD =0b11111111 ;  // RXD has pull-up, other pins are HIGH
                       // TIMER setup
  TCCR1A=0b00000011 ;  // fast PWM mode 15H with TOP=OCR1A
  TCCR1B=0b00011001	;  // clock=XTAL, no prescaler
  OCR1A=127 ;          // period 128
  TIMSK=0b00000100 ;   // Interupt enable for Timer1-Overflow
  sei() ;              // start all interrupts
  while(1)
    { readBLK(0) ; } ; // simple command for test purposes
}
