//POVRay-Datei erstellt mit 3d41.ulp v###VERSIONDUMMY###
//C:/Programme/Eagle/projects/povraytest/MoDsMega.brd
//27.11.2006 19:58:38 

#version 3.5;

//Set to on if the file should be used as .inc
#local use_file_as_inc = off;
#if(use_file_as_inc=off)


//changes the apperance of resistors (1 Blob / 0 real)
#declare global_res_shape = 1;
//randomize color of resistors 1=random 0=same color
#declare global_res_colselect = 0;
//Number of the color for the resistors
//0=Green, 1="normal color" 2=Blue 3=Brown
#declare global_res_col = 1;
//Set to on if you want to render the PCB upside-down
#declare pcb_upsidedown = off;
//Set to x or z to rotate around the corresponding axis (referring to pcb_upsidedown)
#declare pcb_rotdir = x;
//Set the length off short pins over the PCB
#declare pin_length = 2.5;
#declare global_diode_bend_radius = 1;
#declare global_res_bend_radius = 1;
#declare global_solder = on;

#declare global_show_screws = on;
#declare global_show_washers = on;
#declare global_show_nuts = on;

//Animation
#declare global_anim = off;
#local global_anim_showcampath = no;

#declare global_fast_mode = off;

#declare col_preset = 2;
#declare pin_short = on;

#declare environment = on;

#local cam_x = 0;
#local cam_y = 344;
#local cam_z = -184;
#local cam_a = 20;
#local cam_look_x = 0;
#local cam_look_y = -8;
#local cam_look_z = 0;

#local pcb_rotate_x = 0;
#local pcb_rotate_y = 0;
#local pcb_rotate_z = 0;

#local pcb_board = on;
#local pcb_parts = on;
#if(global_fast_mode=off)
	#local pcb_polygons = on;
	#local pcb_silkscreen = on;
	#local pcb_wires = on;
	#local pcb_pads_smds = on;
#else
	#local pcb_polygons = off;
	#local pcb_silkscreen = off;
	#local pcb_wires = off;
	#local pcb_pads_smds = off;
#end

#local lgt1_pos_x = 38;
#local lgt1_pos_y = 56;
#local lgt1_pos_z = 42;
#local lgt1_intense = 0.814286;
#local lgt2_pos_x = -38;
#local lgt2_pos_y = 56;
#local lgt2_pos_z = 42;
#local lgt2_intense = 0.814286;
#local lgt3_pos_x = 38;
#local lgt3_pos_y = 56;
#local lgt3_pos_z = -28;
#local lgt3_intense = 0.814286;
#local lgt4_pos_x = -38;
#local lgt4_pos_y = 56;
#local lgt4_pos_z = -28;
#local lgt4_intense = 0.814286;

//Do not change these values
#declare pcb_height = 1.500000;
#declare pcb_cuheight = 0.035000;
#declare pcb_x_size = 100.000000;
#declare pcb_y_size = 80.000000;
#declare pcb_layer1_used = 1;
#declare pcb_layer16_used = 1;
#declare inc_testmode = off;
#declare global_seed=seed(360);
#declare global_pcb_layer_dis = array[16]
{
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	1.535000,
}
#declare global_pcb_real_hole = 2.000000;

#include "tools.inc"
#include "user.inc"

global_settings{charset utf8}

#if(environment=on)
sky_sphere {pigment {Navy}
pigment {bozo turbulence 0.65 octaves 7 omega 0.7 lambda 2
color_map {
[0.0 0.1 color rgb <0.85, 0.85, 0.85> color rgb <0.75, 0.75, 0.75>]
[0.1 0.5 color rgb <0.75, 0.75, 0.75> color rgbt <1, 1, 1, 1>]
[0.5 1.0 color rgbt <1, 1, 1, 1> color rgbt <1, 1, 1, 1>]}
scale <0.1, 0.5, 0.1>} rotate -90*x}
plane{y, -10.0-max(pcb_x_size,pcb_y_size)*abs(max(sin((pcb_rotate_x/180)*pi),sin((pcb_rotate_z/180)*pi)))
texture{T_Chrome_2D
normal{waves 0.1 frequency 3000.0 scale 3000.0}} translate<0,0,0>}
#end

//Animationsdaten
#if(global_anim=on)
#declare global_anim_showcampath = no;
#end

#declare global_anim_npoints_cam_flight=6;
#local global_anim_points_cam_flight=array[global_anim_npoints_cam_flight]
{	<2.540000,100.000000,2.698800>
	<34.131300,8.000000,18.573800>
	<68.897500,8.000000,36.512500>
	<71.755000,15.000000,58.578800>
	<35.630000,10.000000,60.541200>
	<15.711200,3.000000,56.857400>
};

#declare global_anim_npoints_cam_view=4;
#local global_anim_points_cam_view=array[global_anim_npoints_cam_view]
{	<11.906300,0.000000,25.241300>
	<65.500000,0.000000,40.800000>
	<26.987500,0.000000,43.338800>
	<5.715000,-10.000000,29.845000>
};

#if((global_anim=on)|(global_anim_showcampath=yes))
#local global_anim_spline_cam_flight = 
spline{
	natural_spline	#local i=0;
	#local cnt=0;
	#local inc=1/(global_anim_npoints_cam_flight-1);

	#while(i<1.0000001)
		i,	global_anim_points_cam_flight[cnt]+<-49.530000,0,-39.370000>

		#local i = i+inc;
		#local cnt = cnt+1;
	#end
}
#local global_anim_spline_cam_view = 
spline{
	natural_spline	#local i=0;
	#local cnt=0;
	#local inc=1/(global_anim_npoints_cam_view-1);

	#while(i<1.0000001)
		i,	global_anim_points_cam_view[cnt]+<-49.530000,0,-39.370000>

		#local i = i+inc;
		#local cnt = cnt+1;
	#end
}
#end

#if((global_anim_showcampath=yes)&(global_anim=off))
#local ctr = 0;
#while (ctr < 1)
	sphere {
		global_anim_spline_cam_flight(ctr),0.4
		pigment { rgb <1-ctr,0,0> }
	}
#local ctr = ctr + 0.001;
#end
#local ctr = 0;
#while (ctr < global_anim_npoints_cam_flight)
	sphere {
	global_anim_points_cam_flight[ctr]+<-49.530000,0,-39.370000>,0.5
	pigment { Blue }
	}
#local ctr = ctr + 1;
#end
#local ctr = 0;
#while (ctr < 1)
	sphere {
		global_anim_spline_cam_view(ctr),0.4
		pigment { rgb <1-ctr,1,1-ctr> }
	}
#local ctr = ctr + 0.001;
#end
#local ctr = 0;
#while (ctr < global_anim_npoints_cam_view)
	sphere {
	global_anim_points_cam_view[ctr]+<-49.530000,0,-39.370000>,0.5
	pigment { Red }
	}
#local ctr = ctr + 1;
#end
#end
#if(global_anim=on)
camera
{
	location global_anim_spline_cam_flight(clock)
	#if(global_anim_npoints_cam_view>2)
		look_at global_anim_spline_cam_view(clock)
	#else
		look_at global_anim_spline_cam_flight(clock+0.01)-<0,-0.01,0>
	#end
	angle 45
}
light_source
{
	global_anim_spline_cam_flight(clock)
	color rgb <1,1,1>
	spotlight point_at 
	#if(global_anim_npoints_cam_view>2)
		global_anim_spline_cam_view(clock)
	#else
		global_anim_spline_cam_flight(clock+0.01)-<0,-0.01,0>
	#end
	radius 35 falloff  40
}
#else
camera
{
	location <cam_x,cam_y,cam_z>
	look_at <cam_look_x,cam_look_y,cam_look_z>
	angle cam_a
	//versetzt die Kamera, sodass <0,0,0> ber dem Eagle-Nullpunkt ist
	//translate<-50.000000,0,-40.000000>
}
#end

background{col_bgr}


//Axis uncomment to activate
//object{TOOLS_AXIS_XYZ(100,100,100 //texture{ pigment{rgb<1,0,0>} finish{diffuse 0.8 phong 1}}, //texture{ pigment{rgb<1,1,1>} finish{diffuse 0.8 phong 1}})}

light_source{<lgt1_pos_x,lgt1_pos_y,lgt1_pos_z> White*lgt1_intense}
light_source{<lgt2_pos_x,lgt2_pos_y,lgt2_pos_z> White*lgt2_intense}
light_source{<lgt3_pos_x,lgt3_pos_y,lgt3_pos_z> White*lgt3_intense}
light_source{<lgt4_pos_x,lgt4_pos_y,lgt4_pos_z> White*lgt4_intense}
#end


#macro MODSMEGA(mac_x_ver,mac_y_ver,mac_z_ver,mac_x_rot,mac_y_rot,mac_z_rot)
union{
#if(pcb_board = on)
difference{
union{
//Platine
prism{-1.500000,0.000000,8
<-0.470000,-0.630000><99.530000,-0.630000>
<99.530000,-0.630000><99.530000,79.370000>
<99.530000,79.370000><-0.470000,79.370000>
<-0.470000,79.370000><-0.470000,-0.630000>
texture{col_brd}}
}//End union(Platine)
//Bohrungen(real)/Bauteile
//Bohrungen(real)/Platine
cylinder{<2.540000,1,76.200000><2.540000,-5,76.200000>1.500000 texture{col_hls}}
cylinder{<2.540000,1,2.540000><2.540000,-5,2.540000>1.500000 texture{col_hls}}
cylinder{<96.520000,1,2.540000><96.520000,-5,2.540000>1.500000 texture{col_hls}}
cylinder{<96.520000,1,76.200000><96.520000,-5,76.200000>1.500000 texture{col_hls}}
//Bohrungen(real)/Durchkontaktierungen
cylinder{<8.890000,0.095000,57.450000><8.890000,-1.595000,57.450000>1.250000 texture{col_hls}}
cylinder{<8.890000,0.095000,69.850000><8.890000,-1.595000,69.850000>1.250000 texture{col_hls}}
}//End difference(reale Bohrungen/Durchbrche)
#end
#if(pcb_parts=on)//Bauteile
union{
#ifndef(pack_C1) #declare global_pack_C1=yes; object {CAP_DIS_ELKO_2MM5_6MM3("100",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<54.610000,0.000000,76.200000>}#end		//Elko 2,5mm Pitch, 6mm Durchmesser, 11,2mm Hoehe C1 100 E2,5-6
#ifndef(pack_C2) #declare global_pack_C2=yes; object {CAP_DIS_ELKO_2MM5_6MM3("100",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<46.990000,0.000000,76.200000>}#end		//Elko 2,5mm Pitch, 6mm Durchmesser, 11,2mm Hoehe C2 100 E2,5-6
#ifndef(pack_C3) #declare global_pack_C3=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<63.500000,0.000000,66.040000>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C3 100n C0805
#ifndef(pack_C4) #declare global_pack_C4=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<80.010000,0.000000,63.500000>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C4 100n C0805
#ifndef(pack_C5) #declare global_pack_C5=yes; object {CAP_DIS_ELKO_2MM_5MM("10",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<21.590000,0.000000,49.530000>}#end		//Elko 2mm Pitch, 5mm Durchmesser, 11mm Hoehe C5 10 E2-5
#ifndef(pack_C6) #declare global_pack_C6=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<82.550000,0.000000,46.037500>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C6 100n C0805
#ifndef(pack_C7) #declare global_pack_C7=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<82.550000,0.000000,41.910000>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C7 100n C0805
#ifndef(pack_C8) #declare global_pack_C8=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<91.122500,0.000000,48.260000>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C8 100n C0805
#ifndef(pack_C9) #declare global_pack_C9=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<86.995000,0.000000,35.560000>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C9 100n C0805
#ifndef(pack_C10) #declare global_pack_C10=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,180> translate<29.210000,-1.500000,43.180000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C10 27p C0805
#ifndef(pack_C11) #declare global_pack_C11=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,180> translate<29.210000,-1.500000,33.020000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C11 27p C0805
#ifndef(pack_C12) #declare global_pack_C12=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<16.510000,-1.500000,46.990000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C12 27p C0805
#ifndef(pack_C13) #declare global_pack_C13=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<6.191300,-1.500000,46.990000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C13 27p C0805
#ifndef(pack_C14) #declare global_pack_C14=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<59.690000,-1.500000,76.200000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C14 33p C0805
#ifndef(pack_C15) #declare global_pack_C15=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<69.850000,-1.500000,77.470000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C15 10p C0805
#ifndef(pack_C16) #declare global_pack_C16=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,180> translate<15.240000,-1.500000,15.240000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C16 100n C0805
#ifndef(pack_C17) #declare global_pack_C17=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<29.210000,-1.500000,19.050000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C17 100n C0805
#ifndef(pack_C18) #declare global_pack_C18=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<44.450000,-1.500000,19.050000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C18 100n C0805
#ifndef(pack_C19) #declare global_pack_C19=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<68.580000,0.000000,15.240000>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C19 100n C0805
#ifndef(pack_C20) #declare global_pack_C20=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<83.820000,-1.500000,19.050000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C20 100n C0805
#ifndef(pack_C21) #declare global_pack_C21=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<45.720000,-1.500000,37.782600>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C21 100n C0805
#ifndef(pack_C22) #declare global_pack_C22=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<95.885000,0.000000,48.895000>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C22 100n C0805
#ifndef(pack_C23) #declare global_pack_C23=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,180> translate<50.800000,-1.500000,39.052500>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C23 100n C0805
#ifndef(pack_C24) #declare global_pack_C24=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<70.485000,0.000000,34.925000>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C24 100n C0805
#ifndef(pack_C25) #declare global_pack_C25=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<53.975000,0.000000,35.560000>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C25 100n C0805
#ifndef(pack_C26) #declare global_pack_C26=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,180> translate<76.200000,-1.500000,71.120000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C26 100n C0805
#ifndef(pack_C27) #declare global_pack_C27=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,180> translate<76.200000,-1.500000,63.500000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C27 100n C0805
#ifndef(pack_C28) #declare global_pack_C28=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,180> translate<50.800000,-1.500000,43.497500>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C28 10n C0805
#ifndef(pack_C29) #declare global_pack_C29=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<14.605000,0.000000,38.100000>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C29 10n C0805
#ifndef(pack_C30) #declare global_pack_C30=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<45.720000,-1.500000,35.401300>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C30 10n C0805
#ifndef(pack_C31) #declare global_pack_C31=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,180> translate<1.270000,-1.500000,46.990000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C31 100n C0805
#ifndef(pack_C32) #declare global_pack_C32=yes; object {CAP_DIS_ELKO_2MM5_5MM("1",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<2.540000,0.000000,52.070000>}#end		//Elko 2,5mm Pitch, 5mm Durchmesser, 11,2mm Hoehe C32 1 E2,5-5
#ifndef(pack_C33) #declare global_pack_C33=yes; object {CAP_DIS_TT_2MM5_5MM("10",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<92.868800,0.000000,70.326300>}#end		//Tantal-Ko 2,5mm Pitch, 5mm Durchmesser C33 10 TT2D5
#ifndef(pack_C34) #declare global_pack_C34=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<80.010000,0.000000,68.580000>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C34 100n C0805
#ifndef(pack_C35) #declare global_pack_C35=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<12.065000,0.000000,38.100000>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C35 100n C0805
#ifndef(pack_C36) #declare global_pack_C36=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<36.353800,0.000000,72.548800>translate<0,0.035000,0> }#end		//SMD Kondensator 0805 C36 100n C0805
#ifndef(pack_C37) #declare global_pack_C37=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<95.250000,-1.500000,69.850000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C37 100n C0805
#ifndef(pack_C38) #declare global_pack_C38=yes; object {CAP_SMD_CHIP_0805(DarkWood)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<95.250000,-1.500000,62.230000>translate<0,-0.035000,0> }#end		//SMD Kondensator 0805 C38 100n C0805
#ifndef(pack_C39) #declare global_pack_C39=yes; object {CAP_DIS_TT_2MM5_5MM("10",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<83.820000,0.000000,31.115000>}#end		//Tantal-Ko 2,5mm Pitch, 5mm Durchmesser C39 10 TT2D5
#ifndef(pack_D1) #declare global_pack_D1=yes; object {DIODE_SMD_SOD80("4148",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<87.630000,-1.500000,66.040000>translate<0,-0.035000,0> }#end		//Diode im SOD80-Gehaeuse D1 4148 SOD80
#ifndef(pack_D2) #declare global_pack_D2=yes; object {DIODE_SMD_SOD80("4148",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<87.630000,-1.500000,62.865000>translate<0,-0.035000,0> }#end		//Diode im SOD80-Gehaeuse D2 4148 SOD80
#ifndef(pack_D3) #declare global_pack_D3=yes; object {DIODE_SMD_SOD80("1A",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<86.360000,-1.500000,69.850000>translate<0,-0.035000,0> }#end		//Diode im SOD80-Gehaeuse D3 1A SOD80C
#ifndef(pack_IC1) #declare global_pack_IC1=yes; object {QFP_TQFP_64_080MM("MEGA103","ATMEL",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<41.910000,0.000000,39.370000>translate<0,0.035000,0> }#end		//TQFP-64 IC1 MEGA103 TQFP64
#ifndef(pack_IC2) #declare global_pack_IC2=yes; object {IC_SMD_SO32_400("512k SRAM","ST",)translate<0.508,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<60.960000,-1.500000,16.510000>translate<0,-0.035000,0> }#end		//SMD IC SO32 400mil IC2 512k SRAM SOJ32/4
#ifndef(pack_IC3) #declare global_pack_IC3=yes; object {IC_SMD_SO20W("74HC573D","PHILIPS",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<79.375000,0.000000,16.510000>translate<0,0.035000,0> }#end		//SMD IC SO20-Wide Package IC3 74HC573D SO20W
#ifndef(pack_IC4) #declare global_pack_IC4=yes; object {IC_SMD_SO8("TL7705A","ST",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<87.630000,0.000000,64.770000>translate<0,0.035000,0> }#end		//SMD IC SO8 Package IC4 TL7705A SO08
#ifndef(pack_IC5) #declare global_pack_IC5=yes; object {IC_SMD_SO28W("VS1001","",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<64.770000,-1.500000,67.310000>translate<0,-0.035000,0> }#end		//SMD IC SO28-Wide Package IC5 VS1001 SOIC28
#ifndef(pack_IC6) #declare global_pack_IC6=yes; object {IC_SMD_SO20W("74LS245DW","PHILIPS",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<44.450000,-1.500000,67.310000>translate<0,-0.035000,0> }#end		//SMD IC SO20-Wide Package IC6 74LS245DW SO20W
#ifndef(pack_IC7) #declare global_pack_IC7=yes; object {IC_SMD_SO20W("74HC573D","PHILIPS",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<40.640000,0.000000,16.510000>translate<0,0.035000,0> }#end		//SMD IC SO20-Wide Package IC7 74HC573D SO20W
#ifndef(pack_IC8) #declare global_pack_IC8=yes; object {IC_SMD_SO20W("74HC245DW","PHILIPS",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<10.160000,0.000000,16.510000>translate<0,0.035000,0> }#end		//SMD IC SO20-Wide Package IC8 74HC245DW SO20W
#ifndef(pack_IC9) #declare global_pack_IC9=yes; object {IC_SMD_SO16("MAX232A","",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<88.900000,0.000000,41.910000>translate<0,0.035000,0> }#end		//SMD IC SO16 Package IC9 MAX232A SO16
#ifndef(pack_IC10) #declare global_pack_IC10=yes; object {IC_SMD_SO28W("PDIUSB12","PHILIPS",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<10.160000,-1.500000,38.100000>translate<0,-0.035000,0> }#end		//SMD IC SO28-Wide Package IC10 PDIUSB12 SOIC28
#ifndef(pack_IC11) #declare global_pack_IC11=yes; object {TR_TO92_G("LE33CZ",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<96.520000,0.000000,66.040000>}#end		//TO92 gewinckelt stehend IC11 LE33CZ TO92
#ifndef(pack_IC12) #declare global_pack_IC12=yes; object {IC_SMD_SO20W("74HC245DW","PHILIPS",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<25.400000,0.000000,16.510000>translate<0,0.035000,0> }#end		//SMD IC SO20-Wide Package IC12 74HC245DW SO20W
#ifndef(pack_IC13) #declare global_pack_IC13=yes; object {IC_SMD_SO20W("74HC245DW","PHILIPS",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<62.230000,0.000000,39.687500>translate<0,0.035000,0> }#end		//SMD IC SO20-Wide Package IC13 74HC245DW SO20W
#ifndef(pack_IC15) #declare global_pack_IC15=yes; object {IC_SMD_PLCC44("EPM7032-J44",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,180> translate<62.230000,-1.500000,39.370000>translate<0,-0.035000,0> }#end		//SMD-PLCC 44Pin IC15 EPM7032-J44 PLCC44
#ifndef(pack_JP1) #declare global_pack_JP1=yes; object {PH_1X2()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<76.517500,0.000000,75.565100>}#end		//Stiftleiste 2,54mm Raster 2Pin 1Reihe (pinhead.lib) JP1  1X02
#ifndef(pack_Q1) #declare global_pack_Q1=yes; object {SPC_XTAL_5MM("6,000",3,)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<29.210000,0.000000,38.100000>}#end		//Quarz 4,9MM Q1 6,000 HC49/S
#ifndef(pack_Q2) #declare global_pack_Q2=yes; object {SPC_XTAL_CLOCK_025MM("32,786k",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<29.210000,0.000000,46.990000>}#end		//Uhrenquarz mit 2,5MM Pitch Q2 32,786k TC26V
#ifndef(pack_Q3) #declare global_pack_Q3=yes; object {SPC_XTAL_5MM("6,000",3,)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<11.271300,0.000000,47.148700>}#end		//Quarz 4,9MM Q3 6,000 HC49/S
#ifndef(pack_Q4) #declare global_pack_Q4=yes; object {SPC_XTAL_5MM("24,576",12,)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<64.770000,0.000000,76.200000>}#end		//Quarz 4,9MM Q4 24,576 HC49/S
#ifndef(pack_R1) #declare global_pack_R1=yes; object {RES_SMD_CHIP_0805("103",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<80.010000,0.000000,66.040000>translate<0,0.035000,0> }#end		//SMD Widerstand 0805 R1 10k M0805
#ifndef(pack_R2) #declare global_pack_R2=yes; object {RES_SMD_CHIP_0805("103",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<63.500000,0.000000,68.580000>translate<0,0.035000,0> }#end		//SMD Widerstand 0805 R2 10k M0805
#ifndef(pack_R3) #declare global_pack_R3=yes; object {RES_SMD_CHIP_0805("470",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<21.590000,-1.500000,52.070000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R3 47 M0805
#ifndef(pack_R4) #declare global_pack_R4=yes; object {RES_SMD_CHIP_0805("103",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,180> translate<2.540000,-1.500000,29.210000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R4 10k M0805
#ifndef(pack_R5) #declare global_pack_R5=yes; object {RES_SMD_CHIP_0805("471",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,180> translate<5.080000,-1.500000,52.070000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R5 470 M0805
#ifndef(pack_R6) #declare global_pack_R6=yes; object {RES_SMD_CHIP_0805("105",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<7.620000,-1.500000,66.040000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R6 1M M0805
#ifndef(pack_R7) #declare global_pack_R7=yes; object {RES_SMD_CHIP_0805("105",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<7.620000,-1.500000,60.960000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R7 1M M0805
#ifndef(pack_R8) #declare global_pack_R8=yes; object {RES_SMD_CHIP_0805("152",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<7.620000,-1.500000,63.500000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R8 1,5k M0805
#ifndef(pack_R9) #declare global_pack_R9=yes; object {RES_DIS_0207_025MMV(texture{pigment{DarkBrown}finish{phong 0.2}},texture{pigment{Gray45}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<10.795000,0.000000,52.705000>}#end		//Diskreter Widerstand 0,25W stehend 100mil R9 18/1% 0207/2V
#ifndef(pack_R10) #declare global_pack_R10=yes; object {RES_DIS_0207_025MMV(texture{pigment{DarkBrown}finish{phong 0.2}},texture{pigment{Gray45}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<13.970000,0.000000,52.705000>}#end		//Diskreter Widerstand 0,25W stehend 100mil R10 18/1% 0207/2V
#ifndef(pack_R11) #declare global_pack_R11=yes; object {RES_SMD_CHIP_0805("0R0",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<20.320000,-1.500000,17.780000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R11  M0805
#ifndef(pack_R12) #declare global_pack_R12=yes; object {RES_SMD_CHIP_0805("244",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<63.500000,0.000000,71.120000>translate<0,0.035000,0> }#end		//SMD Widerstand 0805 R12 240k M0805
#ifndef(pack_R13) #declare global_pack_R13=yes; object {RES_SMD_CHIP_0805("105",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<69.850000,-1.500000,74.930000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R13 1M M0805
#ifndef(pack_R14) #declare global_pack_R14=yes; object {RES_SMD_CHIP_0805("100",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<73.660000,-1.500000,2.540000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R14 10 M0805
#ifndef(pack_R15) #declare global_pack_R15=yes; object {RES_SMD_CHIP_0805("332",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<83.820000,-1.500000,2.540000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R15 3,3k M0805
#ifndef(pack_R16) #declare global_pack_R16=yes; object {RES_SMD_CHIP_0805("471",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<17.780000,0.000000,38.100000>translate<0,0.035000,0> }#end		//SMD Widerstand 0805 R16 470 R0805
#ifndef(pack_R17) #declare global_pack_R17=yes; object {RES_SMD_CHIP_0805("103",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<27.940000,0.000000,73.660000>translate<0,0.035000,0> }#end		//SMD Widerstand 0805 R17 10k M0805
#ifndef(pack_R18) #declare global_pack_R18=yes; object {RES_SMD_CHIP_0805("472",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<95.250000,0.000000,35.560000>translate<0,0.035000,0> }#end		//SMD Widerstand 0805 R18 4,7k M0805
#ifndef(pack_R19) #declare global_pack_R19=yes; object {RES_SMD_TRIM_3202()translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<78.740000,0.000000,3.810000>translate<0,0.035000,0> }#end		//smd trimpot R19 10k SMD1/6
#ifndef(pack_R20) #declare global_pack_R20=yes; object {RES_SMD_CHIP_0805("472",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<90.487500,0.000000,3.810000>translate<0,0.035000,0> }#end		//SMD Widerstand 0805 R20 4.7k R0805
#ifndef(pack_R21) #declare global_pack_R21=yes; object {RES_SMD_CHIP_0805("103",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<2.540000,-1.500000,17.780000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R21 10k M0805
#ifndef(pack_R22) #declare global_pack_R22=yes; object {RES_SMD_CHIP_0805("103",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<6.667500,-1.500000,17.780000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R22 10k M0805
#ifndef(pack_R23) #declare global_pack_R23=yes; object {RES_SMD_CHIP_0805("103",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<10.795000,-1.500000,17.780000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R23 10k M0805
#ifndef(pack_R24) #declare global_pack_R24=yes; object {RES_SMD_CHIP_0805("103",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<10.795000,-1.500000,14.605000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R24 10k M0805
#ifndef(pack_R25) #declare global_pack_R25=yes; object {RES_SMD_CHIP_0805("103",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<2.540000,-1.500000,14.605000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R25 10k M0805
#ifndef(pack_R26) #declare global_pack_R26=yes; object {RES_SMD_CHIP_0805("103",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<7.620000,-1.500000,5.080000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R26 10k M0805
#ifndef(pack_R27) #declare global_pack_R27=yes; object {RES_SMD_CHIP_0805("103",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,180> translate<7.620000,-1.500000,2.540000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R27 10k M0805
#ifndef(pack_R28) #declare global_pack_R28=yes; object {RES_SMD_CHIP_0805("103",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<6.667500,-1.500000,14.605000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R28 10k M0805
#ifndef(pack_R29) #declare global_pack_R29=yes; object {RES_SMD_CHIP_0805("0R0",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<24.606200,-1.500000,17.780000>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R29  M0805
#ifndef(pack_R30) #declare global_pack_R30=yes; object {RES_SMD_CHIP_0805("0R0",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<77.470000,-1.500000,49.688800>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R30  M0805
#ifndef(pack_R31) #declare global_pack_R31=yes; object {RES_SMD_CHIP_0805("0R0",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<82.867400,-1.500000,49.688800>translate<0,-0.035000,0> }#end		//SMD Widerstand 0805 R31  M0805
#ifndef(pack_R32) #declare global_pack_R32=yes; object {RES_SMD_CHIP_0805("102",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<16.986200,0.000000,68.738800>translate<0,0.035000,0> }#end		//SMD Widerstand 0805 R32 1k R0805
//Bauteile ohne Makro (z.B. SMD-Ltjumper)				SMD-Loetjumper SJ1 
//Bauteile ohne Makro (z.B. SMD-Ltjumper)				SMD-Loetjumper SJ2 
//Bauteile ohne Makro (z.B. SMD-Ltjumper)				SMD-Loetjumper SJ3 
//Bauteile ohne Makro (z.B. SMD-Ltjumper)				SMD-Loetjumper SJ4 
//Bauteile ohne Makro (z.B. SMD-Ltjumper)				SMD-Loetjumper SJ5 
//Bauteile ohne Makro (z.B. SMD-Ltjumper)				SMD-Loetjumper SJ6 
//Bauteile ohne Makro (z.B. SMD-Ltjumper)				SMD-Loetjumper SJ7 
//Bauteile ohne Makro (z.B. SMD-Ltjumper)				SMD-Loetjumper SJ8 
//Bauteile ohne Makro (z.B. SMD-Ltjumper)				SMD-Loetjumper SJ9 
#ifndef(pack_SV1) #declare global_pack_SV1=yes; object {CON_DIS_WS16G()translate<0,0,0> rotate<0,180.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<20.320000,0.000000,3.810000>}#end		//Wannenstecker 16Pin SV1 Tastatur ML16
#ifndef(pack_SV2) #declare global_pack_SV2=yes; object {CON_DIS_WS20G()translate<0,0,0> rotate<0,180.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<52.070000,0.000000,3.810000>}#end		//Wannenstecker 20Pin SV2 Display ML20
#ifndef(pack_SV3) #declare global_pack_SV3=yes; object {PH_1X3()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<20.320000,0.000000,55.880000>}#end		//Stiftleiste 2,54mm Raster 3Pin 1Reihe (con-lstb.lib) SV3 IR MA03-1
#ifndef(pack_SV4) #declare global_pack_SV4=yes; object {PH_2X5()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<77.470000,0.000000,41.910000>}#end		//Stiftleiste 2,54mm Raster 5Pin 2Reihen (con-lstb.lib) SV4  MA05-2
#ifndef(pack_SV5) #declare global_pack_SV5=yes; object {PH_1X3()translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<39.370000,0.000000,76.200000>}#end		//Stiftleiste 2,54mm Raster 3Pin 1Reihe (con-lstb.lib) SV5 Audio MA03-1
#ifndef(pack_SV6) #declare global_pack_SV6=yes; object {PH_1X3()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<96.520000,0.000000,43.180000>}#end		//Stiftleiste 2,54mm Raster 3Pin 1Reihe (con-lstb.lib) SV6 RS232 MA03-1
#ifndef(pack_SV7) #declare global_pack_SV7=yes; object {BL_2X10()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<92.710000,0.000000,20.320000>}#end		//Buchsenleiste 10Pin 2Reihen (con-lsta.lib) SV7 HEB FE10-2
#ifndef(pack_SV8) #declare global_pack_SV8=yes; object {PH_2X5()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<22.860000,0.000000,39.370000>}#end		//Stiftleiste 2,54mm Raster 5Pin 2Reihen (con-lstb.lib) SV8 AVRisp MA05-2
#ifndef(pack_SV10) #declare global_pack_SV10=yes; object {PH_2X5()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<31.750000,0.000000,55.880000>}#end		//Stiftleiste 2,54mm Raster 5Pin 2Reihen (con-lstb.lib) SV10 Analog MA05-2
#ifndef(pack_SV11) #declare global_pack_SV11=yes; object {CON_DIS_WS40G()translate<0,0,0> rotate<0,180.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<69.850000,0.000000,55.880000>}#end		//Wannenstecker 40Pin SV11 IDE ML40
#ifndef(pack_SV12) #declare global_pack_SV12=yes; object {BL_2X7()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<27.940000,0.000000,67.310000>}#end		//Buchsenleiste 7Pin 2Reihen (con-lsta.lib) SV12 MAS FE07-2
#ifndef(pack_T1) #declare global_pack_T1=yes; object {IC_SMD_SOT23("BC847","",)translate<0,-0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,180> translate<78.740000,-1.500000,3.810000>translate<0,-0.035000,0> }#end		//SOT23 T1 BC847 SOT23
#ifndef(pack_V1) #declare global_pack_V1=yes; object {DIODE_SMD_LED_CHIP_0805(Red,0.700000,0.000000,)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<7.620000,0.000000,52.070000>translate<0,0.035000,0> }#end		//SMD-LED im 0805 V1  LED0805
#ifndef(pack_V2) #declare global_pack_V2=yes; object {DIODE_SMD_LED_CHIP_0805(Green,0.700000,0.000000,)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<17.780000,0.000000,35.560000>translate<0,0.035000,0> }#end		//SMD-LED im 0805 V2  LED0805
#ifndef(pack_V3) #declare global_pack_V3=yes; object {DIODE_SMD_LED_CHIP_0805(Yellow,0.700000,0.000000,)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<16.986200,0.000000,64.928800>translate<0,0.035000,0> }#end		//SMD-LED im 0805 V3  LED0805
#ifndef(pack_X1) #declare global_pack_X1=yes; object {CON_USB_B_001()translate<-10.28,0,-6.02> rotate<0,-90.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<8.890000,0.000000,69.850000>}#end		//(usb.lib aus MoDsMega) X1  USBCONB
#ifndef(pack_X2) #declare global_pack_X2=yes; object {ARK_5MM_2()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<85.090000,0.000000,74.930000>}#end		//Anreihklemmen 2Pin (con-ptr500.lib) X2 +Ub AK500/2
}//End union
#end
#if(pcb_pads_smds=on)
//Ltaugen&SMD/Bauteile
#ifndef(global_pack_C1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<55.880000,0,76.200000> texture{col_thl}}
#ifndef(global_pack_C1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<53.340000,0,76.200000> texture{col_thl}}
#ifndef(global_pack_C2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<48.260000,0,76.200000> texture{col_thl}}
#ifndef(global_pack_C2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<45.720000,0,76.200000> texture{col_thl}}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<62.650000,0.000000,66.040000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<64.350000,0.000000,66.040000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<80.860000,0.000000,63.500000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<79.160000,0.000000,63.500000>}
#ifndef(global_pack_C5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.270000,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<20.574000,0,49.530000> texture{col_thl}}
#ifndef(global_pack_C5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.270000,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<22.606000,0,49.530000> texture{col_thl}}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<82.550000,0.000000,45.187500>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<82.550000,0.000000,46.887500>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<82.550000,0.000000,41.060000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<82.550000,0.000000,42.760000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<91.972500,0.000000,48.260000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<90.272500,0.000000,48.260000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<86.145000,0.000000,35.560000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<87.845000,0.000000,35.560000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<29.210000,-1.537000,42.330000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<29.210000,-1.537000,44.030000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<29.210000,-1.537000,33.870000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<29.210000,-1.537000,32.170000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<17.360000,-1.537000,46.990000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<15.660000,-1.537000,46.990000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<5.341300,-1.537000,46.990000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<7.041300,-1.537000,46.990000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<60.540000,-1.537000,76.200000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<58.840000,-1.537000,76.200000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<69.000000,-1.537000,77.470000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<70.700000,-1.537000,77.470000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<15.240000,-1.537000,14.390000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<15.240000,-1.537000,16.090000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<28.360000,-1.537000,19.050000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<30.060000,-1.537000,19.050000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<43.600000,-1.537000,19.050000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<45.300000,-1.537000,19.050000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<68.580000,0.000000,16.090000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<68.580000,0.000000,14.390000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<82.970000,-1.537000,19.050000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<84.670000,-1.537000,19.050000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<44.870000,-1.537000,37.782600>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<46.570000,-1.537000,37.782600>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<95.035000,0.000000,48.895000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<96.735000,0.000000,48.895000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<50.800000,-1.537000,38.202500>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<50.800000,-1.537000,39.902500>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<71.335000,0.000000,34.925000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<69.635000,0.000000,34.925000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<53.975000,0.000000,36.410000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<53.975000,0.000000,34.710000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<76.200000,-1.537000,71.970000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<76.200000,-1.537000,70.270000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<76.200000,-1.537000,62.650000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<76.200000,-1.537000,64.350000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<50.800000,-1.537000,44.347500>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<50.800000,-1.537000,42.647500>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<14.605000,0.000000,37.250000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<14.605000,0.000000,38.950000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<46.570000,-1.537000,35.401300>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<44.870000,-1.537000,35.401300>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<1.270000,-1.537000,46.140000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<1.270000,-1.537000,47.840000>}
#ifndef(global_pack_C32) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,1+global_tmp,0) rotate<0,-270.000000,0>translate<2.540000,0,53.340000> texture{col_thl}}
#ifndef(global_pack_C32) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<2.540000,0,50.800000> texture{col_thl}}
#ifndef(global_pack_C33) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,1+global_tmp,0) rotate<0,-270.000000,0>translate<92.868800,0,69.056300> texture{col_thl}}
#ifndef(global_pack_C33) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<92.868800,0,71.596300> texture{col_thl}}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<80.860000,0.000000,68.580000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<79.160000,0.000000,68.580000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<12.065000,0.000000,38.950000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<12.065000,0.000000,37.250000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<37.203800,0.000000,72.548800>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<35.503800,0.000000,72.548800>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<94.400000,-1.537000,69.850000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<96.100000,-1.537000,69.850000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<94.400000,-1.537000,62.230000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<96.100000,-1.537000,62.230000>}
#ifndef(global_pack_C39) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<82.550000,0,31.115000> texture{col_thl}}
#ifndef(global_pack_C39) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<85.090000,0,31.115000> texture{col_thl}}
object{TOOLS_PCB_SMD(1.400000,1.800000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<85.930000,-1.537000,66.040000>}
object{TOOLS_PCB_SMD(1.400000,1.800000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<89.330000,-1.537000,66.040000>}
object{TOOLS_PCB_SMD(1.400000,1.800000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<89.330000,-1.537000,62.865000>}
object{TOOLS_PCB_SMD(1.400000,1.800000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<85.930000,-1.537000,62.865000>}
object{TOOLS_PCB_SMD(1.400000,1.800000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<84.660000,-1.537000,69.850000>}
object{TOOLS_PCB_SMD(1.400000,1.800000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<88.060000,-1.537000,69.850000>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<47.815500,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<47.028100,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<46.240700,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<45.453300,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<44.665900,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<43.878500,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<43.091100,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<42.303700,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<41.516300,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<40.728900,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<39.941500,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<39.154100,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<38.366700,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<37.579300,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<36.791900,0.000000,47.129700>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<36.004500,0.000000,47.129700>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,45.275500>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,44.488100>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,43.700700>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,42.913300>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,42.125900>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,41.338500>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,40.551100>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,39.763700>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,38.976300>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,38.188900>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,37.401500>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,36.614100>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,35.826700>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,35.039300>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,34.251900>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<34.150300,0.000000,33.464500>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<36.004500,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<36.791900,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<37.579300,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<38.366700,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<39.154100,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<39.941500,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<40.728900,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<41.516300,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<42.303700,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<43.091100,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<43.878500,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<44.665900,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<45.453300,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<46.240700,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<47.028100,0.000000,31.610300>}
object{TOOLS_PCB_SMD(1.193800,0.558800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<47.815500,0.000000,31.610300>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,33.464500>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,34.251900>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,35.039300>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,35.826700>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,36.614100>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,37.401500>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,38.188900>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,38.976300>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,39.763700>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,40.551100>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,41.338500>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,42.125900>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,42.913300>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,43.700700>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,44.488100>}
object{TOOLS_PCB_SMD(0.558800,1.193800,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<49.669700,0.000000,45.275500>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<69.850000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<68.580000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<67.310000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<66.040000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<64.770000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<63.500000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<62.230000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<60.960000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<59.690000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<58.420000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<57.150000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<55.880000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<54.610000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<53.340000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<52.070000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<50.800000,-1.537000,11.607800>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<50.800000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<52.070000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<53.340000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<54.610000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<55.880000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<57.150000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<58.420000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<59.690000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<60.960000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<62.230000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<63.500000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<64.770000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<66.040000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<67.310000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<68.580000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.635000,1.905000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<69.850000,-1.537000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<85.090000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<83.820000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<82.550000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<81.280000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<80.010000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<78.740000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<77.470000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<76.200000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<74.930000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<73.660000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<73.660000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<74.930000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<76.200000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<77.470000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<78.740000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<80.010000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<81.280000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<82.550000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<83.820000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<85.090000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<84.556600,0.000000,66.675000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<84.556600,0.000000,65.405000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<84.556600,0.000000,64.135000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<84.556600,0.000000,62.865000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<90.703400,0.000000,62.865000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<90.703400,0.000000,64.135000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<90.703400,0.000000,65.405000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<90.703400,0.000000,66.675000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<56.515000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<57.785000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<59.055000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<60.325000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<61.595000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<62.865000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<64.135000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<65.405000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<66.675000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<67.945000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<69.215000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<70.485000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<71.755000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<73.025000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<73.025000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<71.755000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<70.485000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<69.215000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<67.945000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<66.675000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<65.405000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<64.135000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<62.865000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<61.595000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<60.325000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<59.055000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<57.785000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<56.515000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<50.165000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<48.895000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<47.625000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<46.355000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<45.085000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<43.815000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<42.545000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<41.275000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<40.005000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<38.735000,-1.537000,62.280800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<38.735000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<40.005000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<41.275000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<42.545000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<43.815000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<45.085000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<46.355000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<47.625000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<48.895000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<50.165000,-1.537000,72.339200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<46.355000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<45.085000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<43.815000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<42.545000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<41.275000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<40.005000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<38.735000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<37.465000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<36.195000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<34.925000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<34.925000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<36.195000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<37.465000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<38.735000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<40.005000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<41.275000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<42.545000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<43.815000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<45.085000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<46.355000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<15.875000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<14.605000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<13.335000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<12.065000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<10.795000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<9.525000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<8.255000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<6.985000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<5.715000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<4.445000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<4.445000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<5.715000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<6.985000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<8.255000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<9.525000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<10.795000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<12.065000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<13.335000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<14.605000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<15.875000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<85.826600,0.000000,46.355000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<85.826600,0.000000,45.085000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<85.826600,0.000000,43.815000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<85.826600,0.000000,42.545000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<85.826600,0.000000,41.275000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<85.826600,0.000000,40.005000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<85.826600,0.000000,38.735000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<85.826600,0.000000,37.465000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<91.973400,0.000000,37.465000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<91.973400,0.000000,38.735000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<91.973400,0.000000,40.005000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<91.973400,0.000000,41.275000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<91.973400,0.000000,42.545000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<91.973400,0.000000,43.815000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<91.973400,0.000000,45.085000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<91.973400,0.000000,46.355000>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<18.415000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<17.145000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<15.875000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<14.605000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<13.335000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<12.065000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<10.795000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<9.525000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<8.255000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<6.985000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<5.715000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<4.445000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<3.175000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<1.905000,-1.537000,33.070800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<1.905000,-1.537000,43.129200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<3.175000,-1.537000,43.129200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<4.445000,-1.537000,43.129200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<5.715000,-1.537000,43.129200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<6.985000,-1.537000,43.129200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<8.255000,-1.537000,43.129200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<9.525000,-1.537000,43.129200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<10.795000,-1.537000,43.129200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<12.065000,-1.537000,43.129200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<13.335000,-1.537000,43.129200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<14.605000,-1.537000,43.129200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<15.875000,-1.537000,43.129200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<17.145000,-1.537000,43.129200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<18.415000,-1.537000,43.129200>}
#ifndef(global_pack_IC11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<96.520000,0,64.770000> texture{col_thl}}
#ifndef(global_pack_IC11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<94.615000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_IC11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<96.520000,0,67.310000> texture{col_thl}}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<31.115000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<29.845000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<28.575000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<27.305000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<26.035000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<24.765000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<23.495000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<22.225000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<20.955000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<19.685000,0.000000,21.539200>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<19.685000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<20.955000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<22.225000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<23.495000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<24.765000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<26.035000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<27.305000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<28.575000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<29.845000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<31.115000,0.000000,11.480800>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<67.945000,0.000000,44.716700>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<66.675000,0.000000,44.716700>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<65.405000,0.000000,44.716700>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<64.135000,0.000000,44.716700>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<62.865000,0.000000,44.716700>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<61.595000,0.000000,44.716700>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<60.325000,0.000000,44.716700>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<59.055000,0.000000,44.716700>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<57.785000,0.000000,44.716700>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<56.515000,0.000000,44.716700>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<56.515000,0.000000,34.658300>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<57.785000,0.000000,34.658300>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<59.055000,0.000000,34.658300>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<60.325000,0.000000,34.658300>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<61.595000,0.000000,34.658300>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<62.865000,0.000000,34.658300>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<64.135000,0.000000,34.658300>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<65.405000,0.000000,34.658300>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<66.675000,0.000000,34.658300>}
object{TOOLS_PCB_SMD(0.660400,2.032000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<67.945000,0.000000,34.658300>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<70.330000,-1.537000,39.370000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<70.330000,-1.537000,38.100000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<70.330000,-1.537000,36.830000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<70.330000,-1.537000,35.560000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<70.330000,-1.537000,34.290000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<70.330000,-1.537000,33.020000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<68.580000,-1.537000,31.270000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<67.310000,-1.537000,31.270000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<66.040000,-1.537000,31.270000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<64.770000,-1.537000,31.270000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<63.500000,-1.537000,31.270000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<62.230000,-1.537000,31.270000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<60.960000,-1.537000,31.270000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<59.690000,-1.537000,31.270000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<58.420000,-1.537000,31.270000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<57.150000,-1.537000,31.270000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<55.880000,-1.537000,31.270000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<54.130000,-1.537000,33.020000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<54.130000,-1.537000,34.290000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<54.130000,-1.537000,35.560000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<54.130000,-1.537000,36.830000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<54.130000,-1.537000,38.100000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<54.130000,-1.537000,39.370000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<54.130000,-1.537000,40.640000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<54.130000,-1.537000,41.910000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<54.130000,-1.537000,43.180000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<54.130000,-1.537000,44.450000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<54.130000,-1.537000,45.720000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<55.880000,-1.537000,47.470000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<57.150000,-1.537000,47.470000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<58.420000,-1.537000,47.470000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<59.690000,-1.537000,47.470000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<60.960000,-1.537000,47.470000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<62.230000,-1.537000,47.470000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<63.500000,-1.537000,47.470000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<64.770000,-1.537000,47.470000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<66.040000,-1.537000,47.470000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<67.310000,-1.537000,47.470000>}
object{TOOLS_PCB_SMD(2.200000,0.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<68.580000,-1.537000,47.470000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<70.330000,-1.537000,45.720000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<70.330000,-1.537000,44.450000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<70.330000,-1.537000,43.180000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<70.330000,-1.537000,41.910000>}
object{TOOLS_PCB_SMD(0.600000,2.200000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<70.330000,-1.537000,40.640000>}
#ifndef(global_pack_JP1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<76.517500,0,76.835100> texture{col_thl}}
#ifndef(global_pack_JP1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<76.517500,0,74.295100> texture{col_thl}}
object{TOOLS_PCB_SMD(1.400000,2.400000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<88.830000,-1.537000,59.531200>}
object{TOOLS_PCB_SMD(1.400000,2.400000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<86.430000,-1.537000,59.531200>}
#ifndef(global_pack_Q1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,1+global_tmp,0) rotate<0,-90.000000,0>translate<29.210000,0,35.687000> texture{col_thl}}
#ifndef(global_pack_Q1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,1+global_tmp,0) rotate<0,-90.000000,0>translate<29.210000,0,40.513000> texture{col_thl}}
#ifndef(global_pack_Q2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,1+global_tmp,0) rotate<0,-90.000000,0>translate<29.210000,0,45.720000> texture{col_thl}}
#ifndef(global_pack_Q2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,1+global_tmp,0) rotate<0,-90.000000,0>translate<29.210000,0,48.260000> texture{col_thl}}
#ifndef(global_pack_Q3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<13.684300,0,47.148700> texture{col_thl}}
#ifndef(global_pack_Q3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<8.858300,0,47.148700> texture{col_thl}}
#ifndef(global_pack_Q4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,1+global_tmp,0) rotate<0,-0.000000,0>translate<62.357000,0,76.200000> texture{col_thl}}
#ifndef(global_pack_Q4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,1+global_tmp,0) rotate<0,-0.000000,0>translate<67.183000,0,76.200000> texture{col_thl}}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<80.960000,0.000000,66.040000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<79.060000,0.000000,66.040000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<64.450000,0.000000,68.580000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<62.550000,0.000000,68.580000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<22.540000,-1.537000,52.070000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<20.640000,-1.537000,52.070000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<2.540000,-1.537000,30.160000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<2.540000,-1.537000,28.260000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<5.080000,-1.537000,51.120000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<5.080000,-1.537000,53.020000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<6.670000,-1.537000,66.040000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<8.570000,-1.537000,66.040000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<6.670000,-1.537000,60.960000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<8.570000,-1.537000,60.960000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<6.670000,-1.537000,63.500000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<8.570000,-1.537000,63.500000>}
#ifndef(global_pack_R9) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<10.795000,0,51.435000> texture{col_thl}}
#ifndef(global_pack_R9) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<10.795000,0,53.975000> texture{col_thl}}
#ifndef(global_pack_R10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<13.970000,0,51.435000> texture{col_thl}}
#ifndef(global_pack_R10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.219200,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<13.970000,0,53.975000> texture{col_thl}}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<19.370000,-1.537000,17.780000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<21.270000,-1.537000,17.780000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<62.550000,0.000000,71.120000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<64.450000,0.000000,71.120000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<70.800000,-1.537000,74.930000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<68.900000,-1.537000,74.930000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<74.610000,-1.537000,2.540000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<72.710000,-1.537000,2.540000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<84.770000,-1.537000,2.540000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<82.870000,-1.537000,2.540000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<18.630000,0.000000,38.100000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<16.930000,0.000000,38.100000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<26.990000,0.000000,73.660000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<28.890000,0.000000,73.660000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<95.250000,0.000000,36.510000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<95.250000,0.000000,34.610000>}
object{TOOLS_PCB_SMD(1.000000,0.900000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<77.345000,0.000000,1.290000>}
object{TOOLS_PCB_SMD(1.000000,0.900000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<80.260000,0.000000,1.290000>}
object{TOOLS_PCB_SMD(2.600000,1.300000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<78.740000,0.000000,5.850000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<90.487500,0.000000,2.960000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<90.487500,0.000000,4.660000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<3.490000,-1.537000,17.780000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<1.590000,-1.537000,17.780000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<7.617500,-1.537000,17.780000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<5.717500,-1.537000,17.780000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<11.745000,-1.537000,17.780000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<9.845000,-1.537000,17.780000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<9.845000,-1.537000,14.605000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<11.745000,-1.537000,14.605000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<1.590000,-1.537000,14.605000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<3.490000,-1.537000,14.605000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<6.670000,-1.537000,5.080000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<8.570000,-1.537000,5.080000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<6.670000,-1.537000,2.540000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<8.570000,-1.537000,2.540000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<7.617500,-1.537000,14.605000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<5.717500,-1.537000,14.605000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<25.556200,-1.537000,17.780000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<23.656200,-1.537000,17.780000>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<78.420000,-1.537000,49.688800>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<76.520000,-1.537000,49.688800>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<83.817400,-1.537000,49.688800>}
object{TOOLS_PCB_SMD(1.300000,1.600000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<81.917400,-1.537000,49.688800>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<16.986200,0.000000,69.588800>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<16.986200,0.000000,67.888800>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<31.496000,-1.537000,8.890000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<33.020000,-1.537000,8.890000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<34.544000,-1.537000,8.890000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<72.390000,0.000000,66.548000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<72.390000,0.000000,68.072000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<58.420000,0.000000,66.548000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<58.420000,0.000000,68.072000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<55.880000,0.000000,66.548000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<55.880000,0.000000,68.072000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<23.622000,0.000000,30.480000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<22.098000,0.000000,30.480000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<67.310000,0.000000,68.072000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<67.310000,0.000000,66.548000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<69.850000,0.000000,68.072000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<69.850000,0.000000,66.548000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<24.892000,0.000000,60.960000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<23.368000,0.000000,60.960000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<26.670000,0.000000,50.292000>}
object{TOOLS_PCB_SMD(1.168400,1.600200,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<26.670000,0.000000,48.768000>}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<29.210000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<29.210000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<26.670000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<26.670000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<24.130000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<24.130000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<21.590000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<21.590000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<19.050000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<19.050000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<16.510000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<16.510000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<13.970000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<13.970000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<11.430000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<11.430000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<63.500000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<63.500000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<60.960000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<60.960000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<58.420000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<58.420000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<55.880000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<55.880000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<53.340000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<53.340000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<50.800000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<50.800000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<48.260000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<48.260000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<45.720000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<45.720000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<43.180000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<43.180000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<40.640000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_SV2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<40.640000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_SV3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<22.860000,0,55.880000> texture{col_thl}}
#ifndef(global_pack_SV3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<20.320000,0,55.880000> texture{col_thl}}
#ifndef(global_pack_SV3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<17.780000,0,55.880000> texture{col_thl}}
#ifndef(global_pack_SV4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<76.200000,0,46.990000> texture{col_thl}}
#ifndef(global_pack_SV4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<78.740000,0,46.990000> texture{col_thl}}
#ifndef(global_pack_SV4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<76.200000,0,44.450000> texture{col_thl}}
#ifndef(global_pack_SV4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<78.740000,0,44.450000> texture{col_thl}}
#ifndef(global_pack_SV4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<76.200000,0,41.910000> texture{col_thl}}
#ifndef(global_pack_SV4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<78.740000,0,41.910000> texture{col_thl}}
#ifndef(global_pack_SV4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<76.200000,0,39.370000> texture{col_thl}}
#ifndef(global_pack_SV4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<78.740000,0,39.370000> texture{col_thl}}
#ifndef(global_pack_SV4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<76.200000,0,36.830000> texture{col_thl}}
#ifndef(global_pack_SV4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<78.740000,0,36.830000> texture{col_thl}}
#ifndef(global_pack_SV5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<36.830000,0,76.200000> texture{col_thl}}
#ifndef(global_pack_SV5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<39.370000,0,76.200000> texture{col_thl}}
#ifndef(global_pack_SV5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<41.910000,0,76.200000> texture{col_thl}}
#ifndef(global_pack_SV6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<96.520000,0,45.720000> texture{col_thl}}
#ifndef(global_pack_SV6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<96.520000,0,43.180000> texture{col_thl}}
#ifndef(global_pack_SV6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<96.520000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<91.440000,0,8.890000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<93.980000,0,8.890000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<91.440000,0,11.430000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<93.980000,0,11.430000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<91.440000,0,13.970000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<93.980000,0,13.970000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<91.440000,0,16.510000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<93.980000,0,16.510000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<91.440000,0,19.050000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<93.980000,0,19.050000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<91.440000,0,21.590000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<93.980000,0,21.590000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<91.440000,0,24.130000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<93.980000,0,24.130000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<91.440000,0,26.670000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<93.980000,0,26.670000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<91.440000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<93.980000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<91.440000,0,31.750000> texture{col_thl}}
#ifndef(global_pack_SV7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<93.980000,0,31.750000> texture{col_thl}}
#ifndef(global_pack_SV8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<24.130000,0,34.290000> texture{col_thl}}
#ifndef(global_pack_SV8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<21.590000,0,34.290000> texture{col_thl}}
#ifndef(global_pack_SV8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<24.130000,0,36.830000> texture{col_thl}}
#ifndef(global_pack_SV8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<21.590000,0,36.830000> texture{col_thl}}
#ifndef(global_pack_SV8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<24.130000,0,39.370000> texture{col_thl}}
#ifndef(global_pack_SV8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<21.590000,0,39.370000> texture{col_thl}}
#ifndef(global_pack_SV8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<24.130000,0,41.910000> texture{col_thl}}
#ifndef(global_pack_SV8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<21.590000,0,41.910000> texture{col_thl}}
#ifndef(global_pack_SV8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<24.130000,0,44.450000> texture{col_thl}}
#ifndef(global_pack_SV8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<21.590000,0,44.450000> texture{col_thl}}
#ifndef(global_pack_SV10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<36.830000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<36.830000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<34.290000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<34.290000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<31.750000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<31.750000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<29.210000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<29.210000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<26.670000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<26.670000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<45.720000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<45.720000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<48.260000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<48.260000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<50.800000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<50.800000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<53.340000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<53.340000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<55.880000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<55.880000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<58.420000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<58.420000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<60.960000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<60.960000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<63.500000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<63.500000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<66.040000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<66.040000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<68.580000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<68.580000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<71.120000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<71.120000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<73.660000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<73.660000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<76.200000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<76.200000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<78.740000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<78.740000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<81.280000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<81.280000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<83.820000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<83.820000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<86.360000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<86.360000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<88.900000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<88.900000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<91.440000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<91.440000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<93.980000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_SV11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<93.980000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<35.560000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<35.560000,0,68.580000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<33.020000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<33.020000,0,68.580000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<30.480000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<30.480000,0,68.580000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<27.940000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<27.940000,0,68.580000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<25.400000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<25.400000,0,68.580000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<22.860000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<22.860000,0,68.580000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<20.320000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_SV12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.371600,0.914400,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<20.320000,0,68.580000> texture{col_thl}}
object{TOOLS_PCB_SMD(1.000000,1.400000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<79.690000,-1.537000,2.710000>}
object{TOOLS_PCB_SMD(1.000000,1.400000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<77.790000,-1.537000,2.710000>}
object{TOOLS_PCB_SMD(1.000000,1.400000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<78.740000,-1.537000,4.910000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<7.620000,0.000000,52.920000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-270.000000,0> texture{col_pds} translate<7.620000,0.000000,51.220000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<16.930000,0.000000,35.560000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-0.000000,0> texture{col_pds} translate<18.630000,0.000000,35.560000>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<16.986200,0.000000,64.078800>}
object{TOOLS_PCB_SMD(1.300000,1.500000,0.037000,0) rotate<0,-90.000000,0> texture{col_pds} translate<16.986200,0.000000,65.778800>}
#ifndef(global_pack_X1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<13.590000,0,62.550000> texture{col_thl}}
#ifndef(global_pack_X1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<13.590000,0,65.050000> texture{col_thl}}
#ifndef(global_pack_X1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<11.590000,0,65.050000> texture{col_thl}}
#ifndef(global_pack_X1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.524000,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<11.590000,0,62.550000> texture{col_thl}}
#ifndef(global_pack_X1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(3.516000,2.500000,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<8.890000,0,69.850000> texture{col_thl}}
#ifndef(global_pack_X1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(3.516000,2.500000,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<8.890000,0,57.450000> texture{col_thl}}
#ifndef(global_pack_X2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.981200,1.320800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<87.604600,0,74.930000> texture{col_thl}}
#ifndef(global_pack_X2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.981200,1.320800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<82.575400,0,74.930000> texture{col_thl}}
//Ltaugen/Durchkontaktierungen
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<73.025000,0,43.180000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<72.548800,0,45.085000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<83.820000,0,16.510000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<87.312600,0,33.337500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<87.947500,0,16.986300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<4.286300,0,39.846300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<32.543800,0,1.905000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<82.550000,0,16.033800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<86.518800,0,33.972500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<87.471300,0,16.033700> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<81.280000,0,15.557500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<88.106200,0,33.972500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<80.010000,0,15.081300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<89.693800,0,33.972500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<78.898700,0,14.605000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<88.900000,0,33.337500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<77.311200,0,14.128800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<76.358800,0,13.652500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<74.771300,0,13.176300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<58.737500,0,15.398800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<59.848800,0,16.033800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<62.230000,0,17.303800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<63.500000,0,17.303800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<64.770000,0,17.303800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<66.992500,0,17.938800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<68.580000,0,19.685000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<47.783700,0,34.924900> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<57.150000,0,13.493800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<58.420000,0,13.493800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<59.690000,0,13.493800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<55.880000,0,13.493800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<43.815000,0,29.686300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<73.818800,0,28.416300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<75.882500,0,35.401300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<74.771300,0,37.147500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<43.180000,0,57.626300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<46.990000,0,74.136300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<60.325000,0,73.977500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<56.991300,0,29.527500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<57.150000,0,20.002500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<54.133800,0,28.416300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<54.133800,0,31.908800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<10.477500,0,60.960000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<14.605000,0,23.177500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<29.686300,0,23.177500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<45.243800,0,23.177500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<18.415000,0,31.432500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<83.661300,0,23.177500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<48.260000,0,23.018800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<64.452500,0,23.495000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<50.958700,0,35.083800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<13.335000,0,23.177500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<28.575000,0,23.812500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<43.656300,0,23.653700> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<50.006300,0,23.812500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<17.145000,0,31.432500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<82.550000,0,23.812500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<51.276300,0,19.843800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<52.070000,0,23.812500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<63.023800,0,23.971300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<51.593700,0,34.290000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<12.065000,0,23.177500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<27.305000,0,24.447500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<42.703800,0,24.447500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<49.053800,0,24.288800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<15.875000,0,31.432500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<81.438800,0,24.447500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<53.340000,0,20.002500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<53.975100,0,24.130000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<62.071300,0,24.447500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<59.848800,0,36.671300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<59.848800,0,40.640000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<59.848800,0,43.021300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<10.795000,0,23.177500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<26.035000,0,25.082500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<41.116300,0,24.923800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<47.783800,0,25.082500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<14.605000,0,31.432500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<79.851200,0,25.082500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<54.451300,0,20.002500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<55.245000,0,24.606300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<62.865000,0,29.686300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<61.118800,0,24.923800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<9.525000,0,23.177500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<24.765000,0,25.717500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<40.163800,0,25.400000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<46.831300,0,25.558800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<12.065000,0,31.432500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<78.898800,0,25.717500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<56.038800,0,20.002500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<56.832500,0,25.399900> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<61.595000,0,29.686300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<60.166300,0,25.400000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<8.255000,0,23.177500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<23.495000,0,26.352500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<39.211200,0,25.876300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<46.037500,0,26.193700> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<10.795000,0,31.432500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<77.311200,0,26.352500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<56.038800,0,26.035000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<53.498800,0,19.050000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<60.166300,0,33.020000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<59.213800,0,25.876300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<77.787500,0,30.956300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<25.082500,0,19.367500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<22.225000,0,26.987500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<36.988800,0,26.352500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<45.084900,0,26.670100> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<76.200000,0,26.987500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<9.525000,0,31.432500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<6.985000,0,23.177500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<53.181300,0,27.146300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<52.070000,0,19.050000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<57.784900,0,26.511300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<58.737500,0,33.020000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<20.955000,0,27.463800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<35.560100,0,26.828700> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<44.132600,0,27.146300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<74.930000,0,27.622500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<8.255000,0,31.432500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<5.715000,0,23.177500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<51.435000,0,27.622500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<50.323800,0,19.050000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<55.086200,0,27.622500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<56.515000,0,33.020000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<57.467500,0,42.703800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<47.783800,0,50.323800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<39.528800,0,53.181300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<40.640000,0,59.690000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<28.575000,0,16.668800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<45.085000,0,13.176300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<27.305000,0,16.192500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<43.815000,0,13.176300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<26.035000,0,15.716300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<42.545000,0,13.176300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<24.765000,0,15.240000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<41.275000,0,13.176300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<23.495000,0,14.763800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<40.005000,0,13.176300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<22.225000,0,14.287500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<38.735000,0,13.176300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<20.955000,0,13.811300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<37.465000,0,13.176300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<19.685000,0,13.176300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<36.195000,0,13.176300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<47.942500,0,52.705000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<41.751300,0,63.976300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<39.846300,0,64.770000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<51.276300,0,49.371200> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<80.327500,0,30.638800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<83.820000,0,8.255000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<96.520000,0,15.240000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<86.995000,0,28.416300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<86.995000,0,22.066300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<75.723800,0,29.210000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<72.231300,0,32.385100> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<86.995000,0,29.527500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<87.947500,0,13.176300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<76.200000,0,33.496200> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<72.231300,0,33.496300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<93.980000,0,45.085000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<79.216300,0,70.961300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<67.945000,0,70.643800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<67.310000,0,33.020000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<72.231300,0,42.068800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<68.580000,0,65.246300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<56.197500,0,37.465000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<61.277500,0,67.310000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<57.785000,0,60.483800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<88.423800,0,3.651300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<86.042500,0,19.843800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<52.228800,0,44.291200> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<36.830000,0,62.230000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<37.782500,0,65.087500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<72.707500,0,21.590000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<39.528800,0,68.421300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<52.228700,0,40.322500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<75.565000,0,4.127500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<35.877500,0,71.120000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<73.025000,0,7.461300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<73.025000,0,4.762500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<47.783800,0,37.147500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<21.590000,0,60.642500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<48.736300,0,11.588800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<6.032500,0,48.577500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<27.781300,0,41.910000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<6.508800,0,35.242500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<34.925100,0,19.050000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<13.176300,0,35.242500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<18.097500,0,21.431300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<15.398800,0,17.938800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<31.115000,0,7.461300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<30.162500,0,3.810000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<69.850000,0,63.817500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<69.215100,0,60.007500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<64.770100,0,60.483800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<64.770000,0,57.943800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<50.800000,0,46.513800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<20.161300,0,61.436400> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<66.675000,0,37.465100> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<54.451200,0,50.165000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<57.943800,0,49.688800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<59.848800,0,49.530100> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<61.436300,0,49.530000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<63.658800,0,49.530000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<65.246300,0,49.371300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<66.833800,0,49.530000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<68.897500,0,49.212500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<43.338800,0,54.610000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<39.687600,0,42.227500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<25.717500,0,42.545000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<25.717500,0,45.561300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<23.018700,0,47.148800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<51.435000,0,48.418800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<78.898800,0,29.845000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<74.930000,0,6.985000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<69.691300,0,1.270000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<44.767500,0,3.810000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<35.560100,0,7.302500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<83.978800,0,29.368800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<87.153800,0,11.906300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<88.900000,0,10.160000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<59.690100,0,7.778800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<37.306300,0,5.556300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<76.993800,0,34.290000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<72.231300,0,36.353800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<74.612500,0,40.640000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<80.168800,0,40.005000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<83.978800,0,37.623800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<83.978800,0,32.861300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<86.360000,0,30.638800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<86.836300,0,13.493800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<89.535000,0,11.430000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<63.658800,0,6.826300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<43.815000,0,56.832500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<43.179900,0,64.770000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<43.180000,0,67.151100> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<48.260100,0,59.372500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<48.260000,0,70.485000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<59.531300,0,70.485000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<72.072500,0,73.977500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<59.055000,0,74.136300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<48.260000,0,68.580000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<43.021400,0,40.005000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<46.513800,0,60.007500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<67.468800,0,74.771300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<63.658800,0,77.311300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<54.610000,0,73.342500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<45.243800,0,70.485000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<91.122500,0,60.642500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<20.796300,0,63.182500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<9.525000,0,45.085000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<6.667500,0,54.610000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<32.226300,0,74.136300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<13.970000,0,45.243800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<39.211300,0,70.485000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<42.386300,0,70.485000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<48.418800,0,65.563800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<54.451300,0,66.833800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<57.308800,0,65.246300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<58.420000,0,70.326300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<42.386300,0,60.642500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<74.295000,0,62.230000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<64.135000,0,63.976300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<16.192500,0,45.085000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<5.238800,0,63.500000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<4.921200,0,30.480000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<7.620000,0,30.480000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<20.002500,0,30.480000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<55.880000,0,70.167500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<32.702500,0,11.430000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<73.025000,0,70.643800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<52.387500,0,36.830000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<49.688800,0,22.225000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<47.466300,0,20.955000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<47.466200,0,18.891300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<47.466200,0,13.176300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<30.003800,0,64.293800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<30.162500,0,60.960000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<36.830000,0,52.705000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<41.671900,0,48.498100> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<17.938800,0,71.596300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<48.339400,0,44.767600> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<48.418800,0,42.545000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<48.259900,0,41.513100> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<47.704400,0,40.719300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<46.990100,0,40.084400> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<46.037500,0,42.703800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<45.561300,0,41.751300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<44.926300,0,40.322500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<37.782400,0,28.098700> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<59.690000,0,27.940000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<59.690000,0,19.843800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<70.485000,0,8.413800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<71.596300,0,27.146300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<71.913800,0,29.845000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<58.261300,0,9.207500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<30.003800,0,7.143700> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<67.310000,0,29.368800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<58.896300,0,8.413800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<17.938800,0,9.842500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<68.580000,0,29.368800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<18.097500,0,12.382500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<8.255000,0,45.085000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<92.392600,0,62.865000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<97.155000,0,11.271300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<30.638800,0,42.862500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<33.178800,0,46.355000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<44.926300,0,59.848700> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<82.232500,0,66.040000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<78.740000,0,61.753800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<68.580000,0,58.737500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<46.672500,0,64.611300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<44.291200,0,64.611300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<80.962500,0,72.072500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<82.232600,0,69.532600> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<44.132500,0,70.326300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<54.768800,0,69.373800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<59.690000,0,65.563900> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<58.420000,0,63.817500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<50.482600,0,48.577400> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<85.566300,0,52.546300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<93.186300,0,49.530000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<93.662500,0,34.607500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<28.098800,0,36.671300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<43.338900,0,42.068800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<47.148700,0,58.578800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<39.846300,0,43.656300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<68.421300,0,41.910000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<69.691300,0,53.498800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<50.006300,0,51.593800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<46.355000,0,70.485000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<70.485000,0,70.485000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<46.355000,0,67.627500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<34.290000,0,60.960000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<38.576300,0,53.975000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<45.720000,0,48.577500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<33.020000,0,60.960000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<37.782500,0,53.340000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<44.608800,0,48.418800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<49.688800,0,49.212500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<85.407500,0,53.498800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<93.980000,0,50.482500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<93.980000,0,47.307500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<25.082700,0,40.481200> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<42.862600,0,43.021300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<13.335000,0,17.303800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<12.223800,0,9.366300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<10.795000,0,9.366300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<9.525000,0,9.366300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<8.255000,0,9.366300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<6.985000,0,9.366300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<2.381300,0,37.306300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<10.001300,0,37.306300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<41.910100,0,40.957500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<3.175000,0,36.353800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<8.413800,0,36.353800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<30.480000,0,30.321300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<86.201300,0,11.271300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<90.170000,0,68.262500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<83.185000,0,17.621300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<68.580000,0,18.097500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<72.548800,0,19.367500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<68.580000,0,37.782500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<61.436300,0,43.021300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<61.436300,0,40.481300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<61.436300,0,37.623800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<64.928800,0,36.353800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<52.228800,0,42.703800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<57.626400,0,37.782500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<56.038800,0,39.370000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<52.228800,0,39.211300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<51.117500,0,73.501300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<43.656300,0,36.036300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<43.656300,0,37.782500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<40.957500,0,38.417500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<34.448700,0,30.956300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<37.941300,0,70.802500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<37.306200,0,40.481300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<46.355000,0,13.176200> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<32.861300,0,72.231300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<38.576300,0,42.545000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<26.828800,0,72.231300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<36.988800,0,45.878800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<32.543800,0,48.736300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<26.193700,0,60.960000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<35.718800,0,18.097500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<24.765000,0,48.736300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<19.367500,0,40.798800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<13.335000,0,41.433800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<26.828800,0,18.573800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<18.256300,0,39.687500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<30.321300,0,9.048800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<16.827500,0,14.128800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<2.540000,0,26.670000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<27.146300,0,60.007500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<45.402500,0,53.340100> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<44.291300,0,50.800000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<49.212500,0,46.117100> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<48.736300,0,47.625000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<67.945000,0,63.976300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<62.865000,0,64.135000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<66.675000,0,70.326300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<60.801200,0,68.580000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<56.515000,0,60.483800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<54.292500,0,62.706300> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<36.036300,0,28.892600> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<66.833700,0,27.622500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<66.040000,0,19.843800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<70.485000,0,9.525000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<70.485000,0,27.622500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<70.961300,0,30.003800> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<68.103800,0,40.640000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<57.785000,0,10.160000> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<35.718800,0,9.842500> texture{col_thl}}
object{TOOLS_PCB_VIA(0.700000,0.300000,1,16,2,0) translate<66.198800,0,29.368800> texture{col_thl}}
#end
#if(pcb_wires=on)
union{
//Signale
difference{union{
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.748800,-1.535000,57.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.890000,-1.535000,57.450000>}
box{<0,0,-0.203200><0.141200,0.035000,0.203200> rotate<0,0.000000,0> translate<8.748800,-1.535000,57.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.670000,-1.535000,59.528800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.748800,-1.535000,57.450000>}
box{<0,0,-0.203200><2.939867,0.035000,0.203200> rotate<0,44.997030,0> translate<6.670000,-1.535000,59.528800> }
}cylinder{<8.890000,1,57.450000><8.890000,-2.500000,57.450000>1.250000 texture{col_thl}}}
difference{union{
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.670000,-1.535000,67.630000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.890000,-1.535000,69.850000>}
box{<0,0,-0.203200><3.139554,0.035000,0.203200> rotate<0,-44.997030,0> translate<6.670000,-1.535000,67.630000> }
}cylinder{<8.890000,1,69.850000><8.890000,-2.500000,69.850000>1.250000 texture{col_thl}}}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<0.793800,0.000000,9.525000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<0.793800,0.000000,38.417500>}
box{<0,0,-0.100000><28.892500,0.035000,0.100000> rotate<0,90.000000,0> translate<0.793800,0.000000,38.417500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<0.952500,-1.535000,52.705000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<0.952500,-1.535000,48.260000>}
box{<0,0,-0.203200><4.445000,0.035000,0.203200> rotate<0,-90.000000,0> translate<0.952500,-1.535000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.111300,-1.535000,46.196300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.167600,-1.535000,46.140000>}
box{<0,0,-0.203200><0.079620,0.035000,0.203200> rotate<0,44.997030,0> translate<1.111300,-1.535000,46.196300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.167600,-1.535000,46.140000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.270000,-1.535000,46.140000>}
box{<0,0,-0.203200><0.102400,0.035000,0.203200> rotate<0,0.000000,0> translate<1.167600,-1.535000,46.140000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.270000,-1.535000,47.942500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.270000,-1.535000,47.840000>}
box{<0,0,-0.203200><0.102500,0.035000,0.203200> rotate<0,-90.000000,0> translate<1.270000,-1.535000,47.840000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<0.952500,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.270000,-1.535000,47.942500>}
box{<0,0,-0.203200><0.449013,0.035000,0.203200> rotate<0,44.997030,0> translate<0.952500,-1.535000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.428800,0.000000,27.781200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.428800,0.000000,27.781300>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,90.000000,0> translate<1.428800,0.000000,27.781300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.428800,0.000000,27.781300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.428800,0.000000,36.671300>}
box{<0,0,-0.203200><8.890000,0.035000,0.203200> rotate<0,90.000000,0> translate<1.428800,0.000000,36.671300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.428800,0.000000,36.671300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.428800,0.000000,37.782500>}
box{<0,0,-0.203200><1.111200,0.035000,0.203200> rotate<0,90.000000,0> translate<1.428800,0.000000,37.782500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.428800,0.000000,36.671300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.428800,0.000000,37.782600>}
box{<0,0,-0.203200><1.111300,0.035000,0.203200> rotate<0,90.000000,0> translate<1.428800,0.000000,37.782600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.587500,-1.535000,8.731300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.587500,-1.535000,14.605000>}
box{<0,0,-0.100100><5.873700,0.035000,0.100100> rotate<0,90.000000,0> translate<1.587500,-1.535000,14.605000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.587500,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.587500,-1.535000,14.607500>}
box{<0,0,-0.100100><3.172500,0.035000,0.100100> rotate<0,-90.000000,0> translate<1.587500,-1.535000,14.607500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.587500,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.587500,-1.535000,17.859400>}
box{<0,0,-0.100100><1.190600,0.035000,0.100100> rotate<0,-90.000000,0> translate<1.587500,-1.535000,17.859400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.587500,-1.535000,8.731300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.587500,-1.535000,19.050000>}
box{<0,0,-0.100100><10.318700,0.035000,0.100100> rotate<0,90.000000,0> translate<1.587500,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<0.952500,-1.535000,52.705000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.587500,-1.535000,53.340000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,-44.997030,0> translate<0.952500,-1.535000,52.705000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.587500,-1.535000,14.607500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.590000,-1.535000,14.605000>}
box{<0,0,-0.100100><0.003536,0.035000,0.100100> rotate<0,44.997030,0> translate<1.587500,-1.535000,14.607500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.587500,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.590000,-1.535000,17.780000>}
box{<0,0,-0.100100><0.002500,0.035000,0.100100> rotate<0,0.000000,0> translate<1.587500,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.590000,-1.535000,17.856900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.590000,-1.535000,17.780000>}
box{<0,0,-0.100100><0.076900,0.035000,0.100100> rotate<0,-90.000000,0> translate<1.590000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.587500,-1.535000,17.859400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.590000,-1.535000,17.856900>}
box{<0,0,-0.100100><0.003536,0.035000,0.100100> rotate<0,44.997030,0> translate<1.587500,-1.535000,17.859400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.587500,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.905000,-1.535000,19.367500>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<1.587500,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.905000,-1.535000,30.638800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.905000,-1.535000,33.070800>}
box{<0,0,-0.100100><2.432000,0.035000,0.100100> rotate<0,90.000000,0> translate<1.905000,-1.535000,33.070800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.905000,-1.535000,33.070800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.905000,-1.535000,36.830000>}
box{<0,0,-0.100100><3.759200,0.035000,0.100100> rotate<0,90.000000,0> translate<1.905000,-1.535000,36.830000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.905000,-1.535000,38.735100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.905000,-1.535000,43.129200>}
box{<0,0,-0.100100><4.394100,0.035000,0.100100> rotate<0,90.000000,0> translate<1.905000,-1.535000,43.129200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.111300,-1.535000,46.196300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.063800,-1.535000,46.196300>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,0.000000,0> translate<1.111300,-1.535000,46.196300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<0.793800,0.000000,38.417500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<2.222600,0.000000,39.846300>}
box{<0,0,-0.100000><2.020628,0.035000,0.100000> rotate<0,-44.997030,0> translate<0.793800,0.000000,38.417500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.905000,-1.535000,36.830000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<2.381300,-1.535000,37.306300>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,-44.997030,0> translate<1.905000,-1.535000,36.830000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.428800,0.000000,27.781200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,0.000000,26.670000>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,44.997030,0> translate<1.428800,0.000000,27.781200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,-1.535000,21.748800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,-1.535000,26.670000>}
box{<0,0,-0.203200><4.921200,0.035000,0.203200> rotate<0,90.000000,0> translate<2.540000,-1.535000,26.670000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.428800,0.000000,27.781300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,0.000000,26.670100>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,44.997030,0> translate<1.428800,0.000000,27.781300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.746300,0.000000,27.463800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,0.000000,26.670100>}
box{<0,0,-0.203200><1.122461,0.035000,0.203200> rotate<0,44.997030,0> translate<1.746300,0.000000,27.463800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,0.000000,26.670100>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,90.000000,0> translate<2.540000,0.000000,26.670100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,-1.535000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,-1.535000,28.260000>}
box{<0,0,-0.203200><1.590000,0.035000,0.203200> rotate<0,90.000000,0> translate<2.540000,-1.535000,28.260000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.905000,-1.535000,30.638800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<2.540000,-1.535000,30.003800>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<1.905000,-1.535000,30.638800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<2.540000,-1.535000,30.160000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<2.540000,-1.535000,30.003800>}
box{<0,0,-0.100100><0.156200,0.035000,0.100100> rotate<0,-90.000000,0> translate<2.540000,-1.535000,30.003800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.428800,0.000000,37.782600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,0.000000,38.893800>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,-44.997030,0> translate<1.428800,0.000000,37.782600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.063800,-1.535000,46.196300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,-1.535000,46.672500>}
box{<0,0,-0.203200><0.673448,0.035000,0.203200> rotate<0,-44.997030,0> translate<2.063800,-1.535000,46.196300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,-1.535000,46.672500>}
box{<0,0,-0.203200><4.127500,0.035000,0.203200> rotate<0,-90.000000,0> translate<2.540000,-1.535000,46.672500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.587500,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,-1.535000,53.340000>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,0.000000,0> translate<1.587500,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,0.000000,60.801200>}
box{<0,0,-0.203200><7.461200,0.035000,0.203200> rotate<0,90.000000,0> translate<2.540000,0.000000,60.801200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<1.428800,0.000000,37.782500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540100,0.000000,38.893800>}
box{<0,0,-0.203200><1.571616,0.035000,0.203200> rotate<0,-44.997030,0> translate<1.428800,0.000000,37.782500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.175000,-1.535000,31.908800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.175000,-1.535000,33.070800>}
box{<0,0,-0.100100><1.162000,0.035000,0.100100> rotate<0,90.000000,0> translate<3.175000,-1.535000,33.070800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.175000,-1.535000,39.846300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.175000,-1.535000,43.129200>}
box{<0,0,-0.100100><3.282900,0.035000,0.100100> rotate<0,90.000000,0> translate<3.175000,-1.535000,43.129200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.490000,-1.535000,10.321300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.490000,-1.535000,14.605000>}
box{<0,0,-0.100100><4.283700,0.035000,0.100100> rotate<0,90.000000,0> translate<3.490000,-1.535000,14.605000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.490000,-1.535000,16.830100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.490000,-1.535000,17.780000>}
box{<0,0,-0.100100><0.949900,0.035000,0.100100> rotate<0,90.000000,0> translate<3.490000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.492500,-1.535000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.492500,-1.535000,50.006200>}
box{<0,0,-0.100100><4.762400,0.035000,0.100100> rotate<0,90.000000,0> translate<3.492500,-1.535000,50.006200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.492500,-1.535000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.810000,-1.535000,44.926300>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<3.492500,-1.535000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.810000,-1.535000,41.592600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.810000,-1.535000,44.926300>}
box{<0,0,-0.100100><3.333700,0.035000,0.100100> rotate<0,90.000000,0> translate<3.810000,-1.535000,44.926300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.492500,-1.535000,50.006200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.968800,-1.535000,50.482500>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,-44.997030,0> translate<3.492500,-1.535000,50.006200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<2.540000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.968800,-1.535000,51.911200>}
box{<0,0,-0.100100><2.020628,0.035000,0.100100> rotate<0,44.997030,0> translate<2.540000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.968800,-1.535000,50.482500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.968800,-1.535000,51.911200>}
box{<0,0,-0.100100><1.428700,0.035000,0.100100> rotate<0,90.000000,0> translate<3.968800,-1.535000,51.911200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.127500,-1.535000,45.878800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.127500,-1.535000,48.895000>}
box{<0,0,-0.203200><3.016200,0.035000,0.203200> rotate<0,90.000000,0> translate<4.127500,-1.535000,48.895000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.127500,-1.535000,61.436300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.127500,-1.535000,65.246200>}
box{<0,0,-0.203200><3.809900,0.035000,0.203200> rotate<0,90.000000,0> translate<4.127500,-1.535000,65.246200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<2.222600,0.000000,39.846300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<4.286300,0.000000,39.846300>}
box{<0,0,-0.100000><2.063700,0.035000,0.100000> rotate<0,0.000000,0> translate<2.222600,0.000000,39.846300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.490000,-1.535000,10.321300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.445000,-1.535000,9.366200>}
box{<0,0,-0.100100><1.350645,0.035000,0.100100> rotate<0,45.000030,0> translate<3.490000,-1.535000,10.321300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<4.445000,0.000000,7.143800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<4.445000,0.000000,11.480800>}
box{<0,0,-0.100000><4.337000,0.035000,0.100000> rotate<0,90.000000,0> translate<4.445000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.445000,0.000000,19.843800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.445000,0.000000,21.539200>}
box{<0,0,-0.203200><1.695400,0.035000,0.203200> rotate<0,90.000000,0> translate<4.445000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.175000,-1.535000,36.353800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.445000,-1.535000,35.083800>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<3.175000,-1.535000,36.353800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.445000,-1.535000,33.070800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.445000,-1.535000,35.083800>}
box{<0,0,-0.100100><2.013000,0.035000,0.100100> rotate<0,90.000000,0> translate<4.445000,-1.535000,35.083800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.810000,-1.535000,41.592600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.445100,-1.535000,40.957500>}
box{<0,0,-0.100100><0.898167,0.035000,0.100100> rotate<0,44.997030,0> translate<3.810000,-1.535000,41.592600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.490000,-1.535000,16.830100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.603800,-1.535000,15.716300>}
box{<0,0,-0.100100><1.575151,0.035000,0.100100> rotate<0,44.997030,0> translate<3.490000,-1.535000,16.830100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.603800,-1.535000,11.112400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.603800,-1.535000,15.716300>}
box{<0,0,-0.100100><4.603900,0.035000,0.100100> rotate<0,90.000000,0> translate<4.603800,-1.535000,15.716300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.175000,-1.535000,31.908800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.603800,-1.535000,30.480000>}
box{<0,0,-0.100100><2.020628,0.035000,0.100100> rotate<0,44.997030,0> translate<3.175000,-1.535000,31.908800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.127500,-1.535000,61.436300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.603800,-1.535000,60.960000>}
box{<0,0,-0.203200><0.673590,0.035000,0.203200> rotate<0,44.997030,0> translate<4.127500,-1.535000,61.436300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,0.000000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.762500,0.000000,48.577500>}
box{<0,0,-0.203200><3.143090,0.035000,0.203200> rotate<0,44.997030,0> translate<2.540000,0.000000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.603800,-1.535000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.921200,-1.535000,30.480000>}
box{<0,0,-0.100100><0.317400,0.035000,0.100100> rotate<0,0.000000,0> translate<4.603800,-1.535000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,-1.535000,21.748800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.921300,-1.535000,19.367500>}
box{<0,0,-0.203200><3.367667,0.035000,0.203200> rotate<0,44.997030,0> translate<2.540000,-1.535000,21.748800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.445000,0.000000,19.843800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.921300,0.000000,19.367500>}
box{<0,0,-0.203200><0.673590,0.035000,0.203200> rotate<0,44.997030,0> translate<4.445000,0.000000,19.843800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.127500,-1.535000,65.246200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.921300,-1.535000,66.040000>}
box{<0,0,-0.203200><1.122603,0.035000,0.203200> rotate<0,-44.997030,0> translate<4.127500,-1.535000,65.246200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.445100,-1.535000,40.957500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.080000,-1.535000,40.957500>}
box{<0,0,-0.100100><0.634900,0.035000,0.100100> rotate<0,0.000000,0> translate<4.445100,-1.535000,40.957500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.127500,-1.535000,48.895000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.080000,-1.535000,49.847500>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,-44.997030,0> translate<4.127500,-1.535000,48.895000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.080000,-1.535000,49.847500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.080000,-1.535000,51.120000>}
box{<0,0,-0.203200><1.272500,0.035000,0.203200> rotate<0,90.000000,0> translate<5.080000,-1.535000,51.120000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.080000,-1.535000,53.020000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.080000,-1.535000,53.022500>}
box{<0,0,-0.100100><0.002500,0.035000,0.100100> rotate<0,90.000000,0> translate<5.080000,-1.535000,53.022500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.587500,-1.535000,8.731300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.238800,-1.535000,5.080000>}
box{<0,0,-0.100100><5.163718,0.035000,0.100100> rotate<0,44.997030,0> translate<1.587500,-1.535000,8.731300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,0.000000,60.801200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.238800,0.000000,63.500000>}
box{<0,0,-0.203200><3.816680,0.035000,0.203200> rotate<0,-44.997030,0> translate<2.540000,0.000000,60.801200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.341300,-1.535000,47.886300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.341300,-1.535000,46.990000>}
box{<0,0,-0.203200><0.896300,0.035000,0.203200> rotate<0,-90.000000,0> translate<5.341300,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.603800,-1.535000,11.112400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.635600,-1.535000,10.080600>}
box{<0,0,-0.100100><1.459186,0.035000,0.100100> rotate<0,44.997030,0> translate<4.603800,-1.535000,11.112400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<5.715000,0.000000,9.048800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<5.715000,0.000000,11.480800>}
box{<0,0,-0.100000><2.432000,0.035000,0.100000> rotate<0,90.000000,0> translate<5.715000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,19.208800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,17.700600>}
box{<0,0,-0.100100><1.508200,0.035000,0.100100> rotate<0,-90.000000,0> translate<5.715000,-1.535000,17.700600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,19.208800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,17.782500>}
box{<0,0,-0.100100><1.426300,0.035000,0.100100> rotate<0,-90.000000,0> translate<5.715000,-1.535000,17.782500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,19.208800>}
box{<0,0,-0.100100><0.158700,0.035000,0.100100> rotate<0,-90.000000,0> translate<5.715000,-1.535000,19.208800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.905000,-1.535000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,19.367500>}
box{<0,0,-0.100100><3.810000,0.035000,0.100100> rotate<0,0.000000,0> translate<1.905000,-1.535000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.921300,-1.535000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.715000,-1.535000,19.367500>}
box{<0,0,-0.203200><0.793700,0.035000,0.203200> rotate<0,0.000000,0> translate<4.921300,-1.535000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<5.715000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<5.715000,0.000000,23.177500>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<5.715000,0.000000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<5.715000,0.000000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<5.715000,0.000000,26.828800>}
box{<0,0,-0.100000><3.651300,0.035000,0.100000> rotate<0,90.000000,0> translate<5.715000,0.000000,26.828800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<5.715000,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<5.715000,-1.535000,26.828800>}
box{<0,0,-0.100000><3.651300,0.035000,0.100000> rotate<0,90.000000,0> translate<5.715000,-1.535000,26.828800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,29.051300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,33.070800>}
box{<0,0,-0.100100><4.019500,0.035000,0.100100> rotate<0,90.000000,0> translate<5.715000,-1.535000,33.070800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.080000,-1.535000,40.957500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,40.322500>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<5.080000,-1.535000,40.957500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.127500,-1.535000,45.878800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.715000,-1.535000,44.291300>}
box{<0,0,-0.203200><2.245064,0.035000,0.203200> rotate<0,44.997030,0> translate<4.127500,-1.535000,45.878800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.715000,-1.535000,43.129200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.715000,-1.535000,44.291300>}
box{<0,0,-0.203200><1.162100,0.035000,0.203200> rotate<0,90.000000,0> translate<5.715000,-1.535000,44.291300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.717500,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.717500,-1.535000,14.605000>}
box{<0,0,-0.100100><3.175000,0.035000,0.100100> rotate<0,-90.000000,0> translate<5.717500,-1.535000,14.605000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,17.700600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.717500,-1.535000,17.703100>}
box{<0,0,-0.100100><0.003536,0.035000,0.100100> rotate<0,-44.997030,0> translate<5.715000,-1.535000,17.700600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.717500,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.717500,-1.535000,17.703100>}
box{<0,0,-0.100100><0.076900,0.035000,0.100100> rotate<0,-90.000000,0> translate<5.717500,-1.535000,17.703100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,17.782500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.717500,-1.535000,17.780000>}
box{<0,0,-0.100100><0.003536,0.035000,0.100100> rotate<0,44.997030,0> translate<5.715000,-1.535000,17.782500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.717500,-1.535000,19.365000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.717500,-1.535000,17.780000>}
box{<0,0,-0.100100><1.585000,0.035000,0.100100> rotate<0,-90.000000,0> translate<5.717500,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.717500,-1.535000,19.365000>}
box{<0,0,-0.100100><0.003536,0.035000,0.100100> rotate<0,44.997030,0> translate<5.715000,-1.535000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.717500,-1.535000,14.605000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.794400,-1.535000,14.681900>}
box{<0,0,-0.100100><0.108753,0.035000,0.100100> rotate<0,-44.997030,0> translate<5.717500,-1.535000,14.605000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.794400,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.794400,-1.535000,14.681900>}
box{<0,0,-0.100100><3.098100,0.035000,0.100100> rotate<0,-90.000000,0> translate<5.794400,-1.535000,14.681900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.717500,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.794400,-1.535000,17.780000>}
box{<0,0,-0.100100><0.076900,0.035000,0.100100> rotate<0,0.000000,0> translate<5.717500,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,19.208800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.873700,-1.535000,19.367500>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,-44.997030,0> translate<5.715000,-1.535000,19.208800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.762500,0.000000,48.577500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.032500,0.000000,48.577500>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,0.000000,0> translate<4.762500,0.000000,48.577500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.341300,-1.535000,47.886300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.032500,-1.535000,48.577500>}
box{<0,0,-0.203200><0.977504,0.035000,0.203200> rotate<0,-44.997030,0> translate<5.341300,-1.535000,47.886300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<1.905000,-1.535000,38.735100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.191300,-1.535000,34.448800>}
box{<0,0,-0.100100><6.061744,0.035000,0.100100> rotate<0,44.997030,0> translate<1.905000,-1.535000,38.735100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.191300,-1.535000,34.448700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.191300,-1.535000,34.448800>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<6.191300,-1.535000,34.448800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.191300,-1.535000,34.448700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.350000,-1.535000,34.290000>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.997030,0> translate<6.191300,-1.535000,34.448700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.350000,-1.535000,29.210100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.350000,-1.535000,34.290000>}
box{<0,0,-0.100100><5.079900,0.035000,0.100100> rotate<0,90.000000,0> translate<6.350000,-1.535000,34.290000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.445000,-1.535000,9.366200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.429400,-1.535000,9.366200>}
box{<0,0,-0.100100><1.984400,0.035000,0.100100> rotate<0,0.000000,0> translate<4.445000,-1.535000,9.366200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<5.715000,0.000000,26.828800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.508700,0.000000,27.622500>}
box{<0,0,-0.100000><1.122461,0.035000,0.100000> rotate<0,-44.997030,0> translate<5.715000,0.000000,26.828800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<5.715000,-1.535000,26.828800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.508700,-1.535000,27.622500>}
box{<0,0,-0.100000><1.122461,0.035000,0.100000> rotate<0,-44.997030,0> translate<5.715000,-1.535000,26.828800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<4.445000,0.000000,7.143800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.508800,0.000000,5.080000>}
box{<0,0,-0.100000><2.918654,0.035000,0.100000> rotate<0,44.997030,0> translate<4.445000,0.000000,7.143800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.508700,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.667500,-1.535000,27.622500>}
box{<0,0,-0.100100><0.158800,0.035000,0.100100> rotate<0,0.000000,0> translate<6.508700,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.080000,-1.535000,53.022500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.667500,-1.535000,54.610000>}
box{<0,0,-0.100100><2.245064,0.035000,0.100100> rotate<0,-44.997030,0> translate<5.080000,-1.535000,53.022500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,29.051300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.667600,-1.535000,28.098800>}
box{<0,0,-0.100100><1.347109,0.035000,0.100100> rotate<0,44.994023,0> translate<5.715000,-1.535000,29.051300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.667500,-1.535000,2.540000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.670000,-1.535000,2.540000>}
box{<0,0,-0.100100><0.002500,0.035000,0.100100> rotate<0,0.000000,0> translate<6.667500,-1.535000,2.540000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.667500,-1.535000,2.540000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.670000,-1.535000,2.542500>}
box{<0,0,-0.100100><0.003536,0.035000,0.100100> rotate<0,-44.997030,0> translate<6.667500,-1.535000,2.540000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.238800,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.670000,-1.535000,5.080000>}
box{<0,0,-0.100100><1.431200,0.035000,0.100100> rotate<0,0.000000,0> translate<5.238800,-1.535000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.670000,-1.535000,2.542500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.670000,-1.535000,5.080000>}
box{<0,0,-0.100100><2.537500,0.035000,0.100100> rotate<0,90.000000,0> translate<6.670000,-1.535000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.670000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.670000,-1.535000,59.528800>}
box{<0,0,-0.203200><1.431200,0.035000,0.203200> rotate<0,-90.000000,0> translate<6.670000,-1.535000,59.528800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.603800,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.670000,-1.535000,60.960000>}
box{<0,0,-0.203200><2.066200,0.035000,0.203200> rotate<0,0.000000,0> translate<4.603800,-1.535000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.670000,-1.535000,61.756200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.670000,-1.535000,60.960000>}
box{<0,0,-0.203200><0.796200,0.035000,0.203200> rotate<0,-90.000000,0> translate<6.670000,-1.535000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.238800,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.670000,-1.535000,63.500000>}
box{<0,0,-0.203200><1.431200,0.035000,0.203200> rotate<0,0.000000,0> translate<5.238800,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.921300,-1.535000,66.040000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.670000,-1.535000,66.040000>}
box{<0,0,-0.203200><1.748700,0.035000,0.203200> rotate<0,0.000000,0> translate<4.921300,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.670000,-1.535000,66.040000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.670000,-1.535000,67.630000>}
box{<0,0,-0.203200><1.590000,0.035000,0.203200> rotate<0,90.000000,0> translate<6.670000,-1.535000,67.630000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.826300,-1.535000,29.527500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.826300,-1.535000,30.956300>}
box{<0,0,-0.100100><1.428800,0.035000,0.100100> rotate<0,90.000000,0> translate<6.826300,-1.535000,30.956300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.670000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.826300,-1.535000,63.500000>}
box{<0,0,-0.203200><0.156300,0.035000,0.203200> rotate<0,0.000000,0> translate<6.670000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.715000,-1.535000,43.129200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.877100,-1.535000,43.129200>}
box{<0,0,-0.203200><1.162100,0.035000,0.203200> rotate<0,0.000000,0> translate<5.715000,-1.535000,43.129200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.715000,-1.535000,43.129200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.934200,-1.535000,43.129200>}
box{<0,0,-0.203200><1.219200,0.035000,0.203200> rotate<0,0.000000,0> translate<5.715000,-1.535000,43.129200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,0.000000,9.366300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,0.000000,8.890000>}
box{<0,0,-0.100000><0.476300,0.035000,0.100000> rotate<0,-90.000000,0> translate<6.985000,0.000000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.429400,-1.535000,9.366200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.985000,-1.535000,9.366300>}
box{<0,0,-0.100100><0.555600,0.035000,0.100100> rotate<0,-0.010312,0> translate<6.429400,-1.535000,9.366200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.985000,0.000000,9.366300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.985000,0.000000,9.842500>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,90.000000,0> translate<6.985000,0.000000,9.842500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.985000,0.000000,9.366300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.985000,0.000000,10.080600>}
box{<0,0,-0.100100><0.714300,0.035000,0.100100> rotate<0,90.000000,0> translate<6.985000,0.000000,10.080600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,0.000000,9.842500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,0.000000,10.080600>}
box{<0,0,-0.100000><0.238100,0.035000,0.100000> rotate<0,90.000000,0> translate<6.985000,0.000000,10.080600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,0.000000,10.080600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,0.000000,11.480800>}
box{<0,0,-0.100000><1.400200,0.035000,0.100000> rotate<0,90.000000,0> translate<6.985000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,0.000000,23.177500>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<6.985000,0.000000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.985000,-1.535000,26.035000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.985000,-1.535000,26.034900>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,-90.000000,0> translate<6.985000,-1.535000,26.034900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,-1.535000,26.035000>}
box{<0,0,-0.100000><2.857500,0.035000,0.100000> rotate<0,90.000000,0> translate<6.985000,-1.535000,26.035000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,-1.535000,26.035000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,-1.535000,26.193700>}
box{<0,0,-0.100000><0.158700,0.035000,0.100000> rotate<0,90.000000,0> translate<6.985000,-1.535000,26.193700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,0.000000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,0.000000,26.193800>}
box{<0,0,-0.100000><3.016300,0.035000,0.100000> rotate<0,90.000000,0> translate<6.985000,0.000000,26.193800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.985000,-1.535000,26.035000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.985000,-1.535000,26.193800>}
box{<0,0,-0.100100><0.158800,0.035000,0.100100> rotate<0,90.000000,0> translate<6.985000,-1.535000,26.193800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.350000,-1.535000,29.210100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.985000,-1.535000,28.575000>}
box{<0,0,-0.100100><0.898096,0.035000,0.100100> rotate<0,45.001541,0> translate<6.350000,-1.535000,29.210100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.985000,-1.535000,34.766300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.985000,-1.535000,33.070800>}
box{<0,0,-0.203200><1.695500,0.035000,0.203200> rotate<0,-90.000000,0> translate<6.985000,-1.535000,33.070800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.508800,-1.535000,35.242500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.985000,-1.535000,34.766300>}
box{<0,0,-0.203200><0.673448,0.035000,0.203200> rotate<0,44.997030,0> translate<6.508800,-1.535000,35.242500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.877100,-1.535000,43.129200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.985000,-1.535000,43.021300>}
box{<0,0,-0.203200><0.152594,0.035000,0.203200> rotate<0,44.997030,0> translate<6.877100,-1.535000,43.129200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.985000,-1.535000,41.751300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.985000,-1.535000,43.021300>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,90.000000,0> translate<6.985000,-1.535000,43.021300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.985000,-1.535000,43.021300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.985000,-1.535000,43.129200>}
box{<0,0,-0.203200><0.107900,0.035000,0.203200> rotate<0,90.000000,0> translate<6.985000,-1.535000,43.129200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.934200,-1.535000,43.129200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.985000,-1.535000,43.180000>}
box{<0,0,-0.203200><0.071842,0.035000,0.203200> rotate<0,-44.997030,0> translate<6.934200,-1.535000,43.129200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.985000,-1.535000,43.129200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.985000,-1.535000,43.180000>}
box{<0,0,-0.203200><0.050800,0.035000,0.203200> rotate<0,90.000000,0> translate<6.985000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.670000,-1.535000,61.756200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<7.143800,-1.535000,62.230000>}
box{<0,0,-0.203200><0.670054,0.035000,0.203200> rotate<0,-44.997030,0> translate<6.670000,-1.535000,61.756200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.826300,-1.535000,29.527500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.302500,-1.535000,29.051300>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,44.997030,0> translate<6.826300,-1.535000,29.527500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.985000,-1.535000,41.751300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<7.302500,-1.535000,41.433800>}
box{<0,0,-0.203200><0.449013,0.035000,0.203200> rotate<0,44.997030,0> translate<6.985000,-1.535000,41.751300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.635600,-1.535000,10.080600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.540700,-1.535000,10.080600>}
box{<0,0,-0.100100><1.905100,0.035000,0.100100> rotate<0,0.000000,0> translate<5.635600,-1.535000,10.080600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.617500,-1.535000,11.273800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.617500,-1.535000,14.605000>}
box{<0,0,-0.100100><3.331200,0.035000,0.100100> rotate<0,90.000000,0> translate<7.617500,-1.535000,14.605000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.617500,-1.535000,16.830000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.617500,-1.535000,17.780000>}
box{<0,0,-0.100100><0.950000,0.035000,0.100100> rotate<0,90.000000,0> translate<7.617500,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.508700,0.000000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<7.620000,0.000000,27.622500>}
box{<0,0,-0.100000><1.111300,0.035000,0.100000> rotate<0,0.000000,0> translate<6.508700,0.000000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<4.921200,0.000000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620000,0.000000,30.480000>}
box{<0,0,-0.100100><2.698800,0.035000,0.100100> rotate<0,0.000000,0> translate<4.921200,0.000000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.826300,-1.535000,30.956300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620000,-1.535000,31.750000>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,-44.997030,0> translate<6.826300,-1.535000,30.956300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.175000,-1.535000,39.846300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620000,-1.535000,35.401300>}
box{<0,0,-0.100100><6.286179,0.035000,0.100100> rotate<0,44.997030,0> translate<3.175000,-1.535000,39.846300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620000,-1.535000,31.750000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620000,-1.535000,35.401300>}
box{<0,0,-0.100100><3.651300,0.035000,0.100100> rotate<0,90.000000,0> translate<7.620000,-1.535000,35.401300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620000,0.000000,53.657500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620000,0.000000,52.920000>}
box{<0,0,-0.100100><0.737500,0.035000,0.100100> rotate<0,-90.000000,0> translate<7.620000,0.000000,52.920000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.667500,0.000000,54.610000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620000,0.000000,53.657500>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,44.997030,0> translate<6.667500,0.000000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.667600,-1.535000,28.098800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620100,-1.535000,28.098800>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,0.000000,0> translate<6.667600,-1.535000,28.098800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620000,-1.535000,28.098800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620100,-1.535000,28.098800>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,0.000000,0> translate<7.620000,-1.535000,28.098800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,0.000000,26.193800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<7.778700,0.000000,26.987500>}
box{<0,0,-0.100000><1.122461,0.035000,0.100000> rotate<0,-44.997030,0> translate<6.985000,0.000000,26.193800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.540700,-1.535000,10.080600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.778800,-1.535000,9.842500>}
box{<0,0,-0.100100><0.336724,0.035000,0.100100> rotate<0,44.997030,0> translate<7.540700,-1.535000,10.080600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,-1.535000,26.193700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<7.778800,-1.535000,26.987500>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,-44.997030,0> translate<6.985000,-1.535000,26.193700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.985000,-1.535000,26.193800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.778800,-1.535000,26.987500>}
box{<0,0,-0.100100><1.122532,0.035000,0.100100> rotate<0,-44.993421,0> translate<6.985000,-1.535000,26.193800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<5.715000,0.000000,9.048800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,0.000000,6.508800>}
box{<0,0,-0.100000><3.592102,0.035000,0.100000> rotate<0,44.997030,0> translate<5.715000,0.000000,9.048800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,0.000000,9.366300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,0.000000,8.255100>}
box{<0,0,-0.100000><1.111200,0.035000,0.100000> rotate<0,-90.000000,0> translate<8.255000,0.000000,8.255100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.778800,-1.535000,9.842500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.255000,-1.535000,9.366300>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,44.997030,0> translate<7.778800,-1.535000,9.842500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.255000,0.000000,9.366300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.255000,0.000000,10.080600>}
box{<0,0,-0.100100><0.714300,0.035000,0.100100> rotate<0,90.000000,0> translate<8.255000,0.000000,10.080600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,0.000000,10.080600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,0.000000,11.480800>}
box{<0,0,-0.100000><1.400200,0.035000,0.100000> rotate<0,90.000000,0> translate<8.255000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,0.000000,23.177500>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<8.255000,0.000000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,0.000000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,0.000000,25.400000>}
box{<0,0,-0.100000><2.222500,0.035000,0.100000> rotate<0,90.000000,0> translate<8.255000,0.000000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,-1.535000,25.400000>}
box{<0,0,-0.100000><2.222500,0.035000,0.100000> rotate<0,90.000000,0> translate<8.255000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,-1.535000,31.432500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,-1.535000,33.070800>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<8.255000,-1.535000,33.070800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.255000,-1.535000,43.129200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.255000,-1.535000,45.085000>}
box{<0,0,-0.100100><1.955800,0.035000,0.100100> rotate<0,90.000000,0> translate<8.255000,-1.535000,45.085000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<7.620000,0.000000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.413800,0.000000,28.416300>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,-44.997030,0> translate<7.620000,0.000000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,0.000000,31.432500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.413800,0.000000,31.273800>}
box{<0,0,-0.100000><0.224506,0.035000,0.100000> rotate<0,44.978985,0> translate<8.255000,0.000000,31.432500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.413800,0.000000,28.416300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.413800,0.000000,31.273800>}
box{<0,0,-0.100000><2.857500,0.035000,0.100000> rotate<0,90.000000,0> translate<8.413800,0.000000,31.273800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<3.175000,0.000000,36.353800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.413800,0.000000,36.353800>}
box{<0,0,-0.100100><5.238800,0.035000,0.100100> rotate<0,0.000000,0> translate<3.175000,0.000000,36.353800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.413800,-1.535000,36.353800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.413800,-1.535000,37.147500>}
box{<0,0,-0.100100><0.793700,0.035000,0.100100> rotate<0,90.000000,0> translate<8.413800,-1.535000,37.147500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.413800,-1.535000,37.147500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.413900,-1.535000,37.465000>}
box{<0,0,-0.100100><0.317500,0.035000,0.100100> rotate<0,-89.976016,0> translate<8.413800,-1.535000,37.147500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.570000,-1.535000,1.748800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.570000,-1.535000,2.540000>}
box{<0,0,-0.100100><0.791200,0.035000,0.100100> rotate<0,90.000000,0> translate<8.570000,-1.535000,2.540000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.570000,-1.535000,65.878800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.570000,-1.535000,63.500000>}
box{<0,0,-0.203200><2.378800,0.035000,0.203200> rotate<0,-90.000000,0> translate<8.570000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.570000,-1.535000,66.040000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.570000,-1.535000,65.883800>}
box{<0,0,-0.203200><0.156200,0.035000,0.203200> rotate<0,-90.000000,0> translate<8.570000,-1.535000,65.883800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620000,-1.535000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.572500,-1.535000,29.527500>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,44.997030,0> translate<7.620000,-1.535000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.570000,-1.535000,65.878800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.572500,-1.535000,65.881300>}
box{<0,0,-0.203200><0.003536,0.035000,0.203200> rotate<0,-44.997030,0> translate<8.570000,-1.535000,65.878800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.570000,-1.535000,65.883800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.572500,-1.535000,65.881300>}
box{<0,0,-0.203200><0.003536,0.035000,0.203200> rotate<0,44.997030,0> translate<8.570000,-1.535000,65.883800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.570000,-1.535000,66.040000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.572500,-1.535000,66.040000>}
box{<0,0,-0.203200><0.002500,0.035000,0.203200> rotate<0,0.000000,0> translate<8.570000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<7.041300,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.731200,-1.535000,46.990000>}
box{<0,0,-0.203200><1.689900,0.035000,0.203200> rotate<0,0.000000,0> translate<7.041300,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.617500,-1.535000,16.830000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.731300,-1.535000,15.716200>}
box{<0,0,-0.100100><1.575151,0.035000,0.100100> rotate<0,44.997030,0> translate<7.617500,-1.535000,16.830000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.731300,-1.535000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.731300,-1.535000,15.716200>}
box{<0,0,-0.100100><4.286200,0.035000,0.100100> rotate<0,90.000000,0> translate<8.731300,-1.535000,15.716200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.731200,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.889900,-1.535000,47.148700>}
box{<0,0,-0.203200><0.224436,0.035000,0.203200> rotate<0,-44.997030,0> translate<8.731200,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.858300,-1.535000,47.148700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.889900,-1.535000,47.148700>}
box{<0,0,-0.203200><0.031600,0.035000,0.203200> rotate<0,0.000000,0> translate<8.858300,-1.535000,47.148700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.985000,0.000000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.890000,0.000000,6.985000>}
box{<0,0,-0.100000><2.694077,0.035000,0.100000> rotate<0,44.997030,0> translate<6.985000,0.000000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.617500,-1.535000,11.273800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.890000,-1.535000,10.001300>}
box{<0,0,-0.100100><1.799587,0.035000,0.100100> rotate<0,44.997030,0> translate<7.617500,-1.535000,11.273800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<7.778700,0.000000,26.987500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.890000,0.000000,26.987500>}
box{<0,0,-0.100000><1.111300,0.035000,0.100000> rotate<0,0.000000,0> translate<7.778700,0.000000,26.987500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.890000,0.000000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.890000,0.000000,43.497500>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,-90.000000,0> translate<8.890000,0.000000,43.497500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.255000,0.000000,45.085000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.890000,0.000000,44.450000>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<8.255000,0.000000,45.085000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.889900,-1.535000,47.148700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.890000,-1.535000,47.148800>}
box{<0,0,-0.203200><0.000141,0.035000,0.203200> rotate<0,-44.997030,0> translate<8.889900,-1.535000,47.148700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,0.000000,8.255100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.048800,0.000000,7.461300>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,44.997030,0> translate<8.255000,0.000000,8.255100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.413900,-1.535000,37.465000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.048800,-1.535000,38.100000>}
box{<0,0,-0.100100><0.897955,0.035000,0.100100> rotate<0,-45.001542,0> translate<8.413900,-1.535000,37.465000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,0.000000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207400,0.000000,26.352400>}
box{<0,0,-0.100000><1.346897,0.035000,0.100000> rotate<0,-44.997030,0> translate<8.255000,0.000000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,-1.535000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207400,-1.535000,26.352400>}
box{<0,0,-0.100000><1.346897,0.035000,0.100000> rotate<0,-44.997030,0> translate<8.255000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207400,-1.535000,26.352400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207400,-1.535000,26.352500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,90.000000,0> translate<9.207400,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<0.793800,0.000000,9.525000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207500,0.000000,1.111300>}
box{<0,0,-0.100000><11.898769,0.035000,0.100000> rotate<0,44.997030,0> translate<0.793800,0.000000,9.525000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.570000,-1.535000,1.748800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.207500,-1.535000,1.111300>}
box{<0,0,-0.100100><0.901561,0.035000,0.100100> rotate<0,44.997030,0> translate<8.570000,-1.535000,1.748800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207400,0.000000,26.352400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207500,0.000000,26.352400>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<9.207400,0.000000,26.352400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207500,0.000000,26.352400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207500,0.000000,26.352500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,90.000000,0> translate<9.207500,0.000000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207400,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207500,-1.535000,26.352600>}
box{<0,0,-0.100000><0.000141,0.035000,0.100000> rotate<0,-44.997030,0> translate<9.207400,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,0.000000,9.366300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,0.000000,8.413800>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,-90.000000,0> translate<9.525000,0.000000,8.413800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.890000,-1.535000,10.001300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.525000,-1.535000,9.366300>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<8.890000,-1.535000,10.001300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.525000,0.000000,9.366300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.525000,0.000000,10.001300>}
box{<0,0,-0.100100><0.635000,0.035000,0.100100> rotate<0,90.000000,0> translate<9.525000,0.000000,10.001300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,0.000000,10.001300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,0.000000,11.480800>}
box{<0,0,-0.100000><1.479500,0.035000,0.100000> rotate<0,90.000000,0> translate<9.525000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,0.000000,23.177500>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<9.525000,0.000000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,0.000000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,0.000000,24.923800>}
box{<0,0,-0.100000><1.746300,0.035000,0.100000> rotate<0,90.000000,0> translate<9.525000,0.000000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,-1.535000,24.923800>}
box{<0,0,-0.100000><1.746300,0.035000,0.100000> rotate<0,90.000000,0> translate<9.525000,-1.535000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.890000,0.000000,26.987500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,0.000000,27.622500>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,-44.997030,0> translate<8.890000,0.000000,26.987500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,0.000000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,0.000000,31.432500>}
box{<0,0,-0.100000><3.810000,0.035000,0.100000> rotate<0,90.000000,0> translate<9.525000,0.000000,31.432500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,-1.535000,31.432500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,-1.535000,33.070800>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<9.525000,-1.535000,33.070800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.525000,-1.535000,43.129200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.525000,-1.535000,45.085000>}
box{<0,0,-0.100100><1.955800,0.035000,0.100100> rotate<0,90.000000,0> translate<9.525000,-1.535000,45.085000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.858300,-1.535000,47.148700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.525100,-1.535000,47.148700>}
box{<0,0,-0.203200><0.666800,0.035000,0.203200> rotate<0,0.000000,0> translate<8.858300,-1.535000,47.148700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.572500,-1.535000,66.040000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.562500,-1.535000,65.050000>}
box{<0,0,-0.203200><1.400071,0.035000,0.203200> rotate<0,44.997030,0> translate<8.572500,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207500,-1.535000,26.352600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.683700,-1.535000,26.352500>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,0.012031,0> translate<9.207500,-1.535000,26.352600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207500,0.000000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.683700,0.000000,26.352600>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,-0.012031,0> translate<9.207500,0.000000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.683800,0.000000,61.753700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.683800,0.000000,63.023800>}
box{<0,0,-0.203200><1.270100,0.035000,0.203200> rotate<0,90.000000,0> translate<9.683800,0.000000,63.023800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.715000,-1.535000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.763100,-1.535000,19.367500>}
box{<0,0,-0.203200><4.048100,0.035000,0.203200> rotate<0,0.000000,0> translate<5.715000,-1.535000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.873700,-1.535000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.763100,-1.535000,19.367500>}
box{<0,0,-0.100100><3.889400,0.035000,0.100100> rotate<0,0.000000,0> translate<5.873700,-1.535000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.683700,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.842500,-1.535000,26.352500>}
box{<0,0,-0.100000><0.158800,0.035000,0.100000> rotate<0,0.000000,0> translate<9.683700,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.683700,0.000000,26.352600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.842500,0.000000,26.352500>}
box{<0,0,-0.100000><0.158800,0.035000,0.100000> rotate<0,0.036078,0> translate<9.683700,0.000000,26.352600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.890000,0.000000,43.497500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.842500,0.000000,42.545000>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,44.997030,0> translate<8.890000,0.000000,43.497500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.525100,-1.535000,47.148700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.842500,-1.535000,46.831300>}
box{<0,0,-0.203200><0.448871,0.035000,0.203200> rotate<0,44.997030,0> translate<9.525100,-1.535000,47.148700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.683800,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.842500,-1.535000,46.831300>}
box{<0,0,-0.203200><0.224436,0.035000,0.203200> rotate<0,44.997030,0> translate<9.683800,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.842500,-1.535000,14.605000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.845000,-1.535000,14.605000>}
box{<0,0,-0.100100><0.002500,0.035000,0.100100> rotate<0,0.000000,0> translate<9.842500,-1.535000,14.605000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.842500,-1.535000,14.605000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.845000,-1.535000,14.607500>}
box{<0,0,-0.100100><0.003536,0.035000,0.100100> rotate<0,-44.997030,0> translate<9.842500,-1.535000,14.605000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.845000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.845000,-1.535000,14.607500>}
box{<0,0,-0.100100><3.172500,0.035000,0.100100> rotate<0,-90.000000,0> translate<9.845000,-1.535000,14.607500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.845000,-1.535000,19.285600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.845000,-1.535000,17.780000>}
box{<0,0,-0.100100><1.505600,0.035000,0.100100> rotate<0,-90.000000,0> translate<9.845000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.763100,-1.535000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.845000,-1.535000,19.285600>}
box{<0,0,-0.100100><0.115824,0.035000,0.100100> rotate<0,44.997030,0> translate<9.763100,-1.535000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,0.000000,8.413800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.001300,0.000000,7.937500>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,44.997030,0> translate<9.525000,0.000000,8.413800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<2.381300,0.000000,37.306300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<10.001300,0.000000,37.306300>}
box{<0,0,-0.100100><7.620000,0.035000,0.100100> rotate<0,0.000000,0> translate<2.381300,0.000000,37.306300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.525000,0.000000,45.085000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<10.001300,0.000000,45.561300>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,-44.997030,0> translate<9.525000,0.000000,45.085000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620000,0.000000,51.220000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<10.001300,0.000000,48.838700>}
box{<0,0,-0.100100><3.367667,0.035000,0.100100> rotate<0,44.997030,0> translate<7.620000,0.000000,51.220000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<10.001300,0.000000,45.561300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<10.001300,0.000000,48.838700>}
box{<0,0,-0.100100><3.277400,0.035000,0.100100> rotate<0,90.000000,0> translate<10.001300,0.000000,48.838700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.731300,-1.535000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<10.160000,-1.535000,10.001300>}
box{<0,0,-0.100100><2.020487,0.035000,0.100100> rotate<0,44.997030,0> translate<8.731300,-1.535000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,-1.535000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.318600,-1.535000,25.717400>}
box{<0,0,-0.100000><1.122320,0.035000,0.100000> rotate<0,-44.997030,0> translate<9.525000,-1.535000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.525000,0.000000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.318700,0.000000,25.717500>}
box{<0,0,-0.100000><1.122461,0.035000,0.100000> rotate<0,-44.997030,0> translate<9.525000,0.000000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.318600,-1.535000,25.717400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.318800,-1.535000,25.717400>}
box{<0,0,-0.100000><0.000200,0.035000,0.100000> rotate<0,0.000000,0> translate<10.318600,-1.535000,25.717400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.318800,-1.535000,25.717400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.477500,-1.535000,25.717500>}
box{<0,0,-0.100000><0.158700,0.035000,0.100000> rotate<0,-0.036101,0> translate<10.318800,-1.535000,25.717400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.842500,0.000000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.477500,0.000000,26.352500>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,0.000000,0> translate<9.842500,0.000000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.570000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.477500,-1.535000,60.960000>}
box{<0,0,-0.203200><1.907500,0.035000,0.203200> rotate<0,0.000000,0> translate<8.570000,-1.535000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.683800,0.000000,61.753700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.477500,0.000000,60.960000>}
box{<0,0,-0.203200><1.122461,0.035000,0.203200> rotate<0,44.997030,0> translate<9.683800,0.000000,61.753700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.683800,0.000000,63.023800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.477500,0.000000,63.817500>}
box{<0,0,-0.203200><1.122461,0.035000,0.203200> rotate<0,-44.997030,0> translate<9.683800,0.000000,63.023800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,0.000000,9.366300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,0.000000,8.890100>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,-90.000000,0> translate<10.795000,0.000000,8.890100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<10.160000,-1.535000,10.001300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<10.795000,-1.535000,9.366300>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<10.160000,-1.535000,10.001300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<10.795000,0.000000,9.366300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<10.795000,0.000000,9.842500>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,90.000000,0> translate<10.795000,0.000000,9.842500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,0.000000,9.842500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,0.000000,11.480800>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<10.795000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,0.000000,23.177500>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<10.795000,0.000000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,0.000000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,0.000000,24.130000>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,90.000000,0> translate<10.795000,0.000000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,-1.535000,24.130000>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,90.000000,0> translate<10.795000,-1.535000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.477500,0.000000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,0.000000,26.670000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<10.477500,0.000000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,0.000000,31.432500>}
box{<0,0,-0.100000><4.762500,0.035000,0.100000> rotate<0,90.000000,0> translate<10.795000,0.000000,31.432500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,-1.535000,31.432500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,-1.535000,33.070800>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<10.795000,-1.535000,33.070800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.842500,-1.535000,46.831300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.795000,-1.535000,45.878800>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,44.997030,0> translate<9.842500,-1.535000,46.831300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.795000,-1.535000,43.129200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.795000,-1.535000,45.878800>}
box{<0,0,-0.203200><2.749600,0.035000,0.203200> rotate<0,90.000000,0> translate<10.795000,-1.535000,45.878800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.795000,0.000000,46.672500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.795000,0.000000,51.435000>}
box{<0,0,-0.203200><4.762500,0.035000,0.203200> rotate<0,90.000000,0> translate<10.795000,0.000000,51.435000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.048800,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<10.953800,-1.535000,38.100000>}
box{<0,0,-0.100100><1.905000,0.035000,0.100100> rotate<0,0.000000,0> translate<9.048800,-1.535000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.477500,-1.535000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.112500,-1.535000,25.717600>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,-0.009022,0> translate<10.477500,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,0.000000,8.890100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.271300,0.000000,8.413800>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,44.997030,0> translate<10.795000,0.000000,8.890100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.112500,-1.535000,25.717600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.271300,-1.535000,25.717500>}
box{<0,0,-0.100000><0.158800,0.035000,0.100000> rotate<0,0.036078,0> translate<11.112500,-1.535000,25.717600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<10.953800,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<11.271300,-1.535000,37.782500>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<10.953800,-1.535000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<7.143800,-1.535000,62.230000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.271300,-1.535000,62.230000>}
box{<0,0,-0.203200><4.127500,0.035000,0.203200> rotate<0,0.000000,0> translate<7.143800,-1.535000,62.230000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.430000,-1.535000,2.540000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.430000,-1.535000,2.698800>}
box{<0,0,-0.203200><0.158800,0.035000,0.203200> rotate<0,90.000000,0> translate<11.430000,-1.535000,2.698800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.508800,0.000000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<11.430000,0.000000,5.080000>}
box{<0,0,-0.100100><4.921200,0.035000,0.100100> rotate<0,0.000000,0> translate<6.508800,0.000000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.570000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<11.430000,-1.535000,5.080000>}
box{<0,0,-0.100100><2.860000,0.035000,0.100100> rotate<0,0.000000,0> translate<8.570000,-1.535000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.271300,-1.535000,62.230000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.590000,-1.535000,62.548700>}
box{<0,0,-0.203200><0.450710,0.035000,0.203200> rotate<0,-44.997030,0> translate<11.271300,-1.535000,62.230000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.590000,-1.535000,62.550000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.590000,-1.535000,62.548700>}
box{<0,0,-0.203200><0.001300,0.035000,0.203200> rotate<0,-90.000000,0> translate<11.590000,-1.535000,62.548700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.590000,-1.535000,61.117600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.590000,-1.535000,62.550000>}
box{<0,0,-0.203200><1.432400,0.035000,0.203200> rotate<0,90.000000,0> translate<11.590000,-1.535000,62.550000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.562500,-1.535000,65.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.590000,-1.535000,65.050000>}
box{<0,0,-0.203200><2.027500,0.035000,0.203200> rotate<0,0.000000,0> translate<9.562500,-1.535000,65.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.590000,0.000000,65.086300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.590000,0.000000,65.050000>}
box{<0,0,-0.203200><0.036300,0.035000,0.203200> rotate<0,-90.000000,0> translate<11.590000,0.000000,65.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.588800,0.000000,65.087500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.590000,0.000000,65.086300>}
box{<0,0,-0.203200><0.001697,0.035000,0.203200> rotate<0,44.997030,0> translate<11.588800,0.000000,65.087500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<11.745000,-1.535000,9.845100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<11.745000,-1.535000,14.605000>}
box{<0,0,-0.100100><4.759900,0.035000,0.100100> rotate<0,90.000000,0> translate<11.745000,-1.535000,14.605000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,0.000000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.747400,0.000000,25.082400>}
box{<0,0,-0.100000><1.346897,0.035000,0.100000> rotate<0,-44.997030,0> translate<10.795000,0.000000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.747400,0.000000,25.082400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.747400,0.000000,25.082500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,90.000000,0> translate<11.747400,0.000000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.255000,0.000000,6.508800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.747500,0.000000,6.508800>}
box{<0,0,-0.100000><3.492500,0.035000,0.100000> rotate<0,0.000000,0> translate<8.255000,0.000000,6.508800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.318700,0.000000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.747500,0.000000,25.717500>}
box{<0,0,-0.100000><1.428800,0.035000,0.100000> rotate<0,0.000000,0> translate<10.318700,0.000000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.795000,0.000000,53.975000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.747500,0.000000,53.975000>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,0.000000,0> translate<10.795000,0.000000,53.975000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.795000,-1.535000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.747600,-1.535000,25.082500>}
box{<0,0,-0.100000><1.347109,0.035000,0.100000> rotate<0,-44.994023,0> translate<10.795000,-1.535000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.747500,-1.535000,25.082600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.747600,-1.535000,25.082500>}
box{<0,0,-0.100000><0.000141,0.035000,0.100000> rotate<0,44.997030,0> translate<11.747500,-1.535000,25.082600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.477500,0.000000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.747600,0.000000,60.960000>}
box{<0,0,-0.203200><1.270100,0.035000,0.203200> rotate<0,0.000000,0> translate<10.477500,0.000000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,0.000000,9.842500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,0.000000,9.525000>}
box{<0,0,-0.100000><0.317500,0.035000,0.100000> rotate<0,-90.000000,0> translate<12.065000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.065000,0.000000,9.525100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.065000,0.000000,9.842500>}
box{<0,0,-0.100100><0.317400,0.035000,0.100100> rotate<0,90.000000,0> translate<12.065000,0.000000,9.842500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.065000,0.000000,9.842500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.065000,0.000000,11.430000>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,90.000000,0> translate<12.065000,0.000000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.065000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.065000,0.000000,11.480800>}
box{<0,0,-0.100100><0.050800,0.035000,0.100100> rotate<0,90.000000,0> translate<12.065000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.064900,-1.535000,23.336200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,-1.535000,23.177500>}
box{<0,0,-0.100000><0.158700,0.035000,0.100000> rotate<0,89.957960,0> translate<12.064900,-1.535000,23.336200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,0.000000,23.177500>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<12.065000,0.000000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,0.000000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,0.000000,23.653800>}
box{<0,0,-0.100000><0.476300,0.035000,0.100000> rotate<0,90.000000,0> translate<12.065000,0.000000,23.653800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.747500,0.000000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,0.000000,26.035000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<11.747500,0.000000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,0.000000,26.035000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,0.000000,31.432500>}
box{<0,0,-0.100000><5.397500,0.035000,0.100000> rotate<0,90.000000,0> translate<12.065000,0.000000,31.432500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,-1.535000,31.432500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,-1.535000,33.070800>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<12.065000,-1.535000,33.070800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.065000,0.000000,35.242500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.065000,0.000000,37.147500>}
box{<0,0,-0.203200><1.905000,0.035000,0.203200> rotate<0,90.000000,0> translate<12.065000,0.000000,37.147500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.065000,0.000000,37.147500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.065000,0.000000,37.250000>}
box{<0,0,-0.203200><0.102500,0.035000,0.203200> rotate<0,90.000000,0> translate<12.065000,0.000000,37.250000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.065000,-1.535000,43.129200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.065000,-1.535000,46.196200>}
box{<0,0,-0.203200><3.067000,0.035000,0.203200> rotate<0,90.000000,0> translate<12.065000,-1.535000,46.196200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.064900,-1.535000,23.336200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065100,-1.535000,23.336300>}
box{<0,0,-0.100000><0.000224,0.035000,0.100000> rotate<0,-26.563298,0> translate<12.064900,-1.535000,23.336200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,-1.535000,23.653800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065100,-1.535000,23.336300>}
box{<0,0,-0.100000><0.317500,0.035000,0.100000> rotate<0,89.976016,0> translate<12.065000,-1.535000,23.653800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.065000,0.000000,37.147500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.167500,0.000000,37.147500>}
box{<0,0,-0.203200><0.102500,0.035000,0.203200> rotate<0,0.000000,0> translate<12.065000,0.000000,37.147500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.747500,-1.535000,25.082600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.223700,-1.535000,25.082600>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,0.000000,0> translate<11.747500,-1.535000,25.082600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.795000,0.000000,46.672500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.223700,0.000000,45.243800>}
box{<0,0,-0.203200><2.020487,0.035000,0.203200> rotate<0,44.997030,0> translate<10.795000,0.000000,46.672500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<11.745000,-1.535000,9.845100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.223800,-1.535000,9.366300>}
box{<0,0,-0.100100><0.677125,0.035000,0.100100> rotate<0,44.997030,0> translate<11.745000,-1.535000,9.845100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.065000,0.000000,9.525100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.223800,0.000000,9.366300>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<12.065000,0.000000,9.525100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.508800,0.000000,35.242500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.223800,0.000000,35.242500>}
box{<0,0,-0.203200><5.715000,0.035000,0.203200> rotate<0,0.000000,0> translate<6.508800,0.000000,35.242500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.065000,0.000000,35.242500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.223800,0.000000,35.242500>}
box{<0,0,-0.203200><0.158800,0.035000,0.203200> rotate<0,0.000000,0> translate<12.065000,0.000000,35.242500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540100,0.000000,38.893800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.326300,0.000000,38.893800>}
box{<0,0,-0.203200><9.786200,0.035000,0.203200> rotate<0,0.000000,0> translate<2.540100,0.000000,38.893800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.223700,-1.535000,25.082600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.382500,-1.535000,25.082500>}
box{<0,0,-0.100000><0.158800,0.035000,0.100000> rotate<0,0.036078,0> translate<12.223700,-1.535000,25.082600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,0.000000,38.893800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382500,0.000000,38.893800>}
box{<0,0,-0.203200><9.842500,0.035000,0.203200> rotate<0,0.000000,0> translate<2.540000,0.000000,38.893800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.065000,0.000000,38.950000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382500,0.000000,38.950000>}
box{<0,0,-0.203200><0.317500,0.035000,0.203200> rotate<0,0.000000,0> translate<12.065000,0.000000,38.950000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382500,0.000000,40.005000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382500,0.000000,38.950000>}
box{<0,0,-0.203200><1.055000,0.035000,0.203200> rotate<0,-90.000000,0> translate<12.382500,0.000000,38.950000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382500,0.000000,38.893800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382500,0.000000,40.005000>}
box{<0,0,-0.203200><1.111200,0.035000,0.203200> rotate<0,90.000000,0> translate<12.382500,0.000000,40.005000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.477500,0.000000,63.817500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382500,0.000000,63.817500>}
box{<0,0,-0.203200><1.905000,0.035000,0.203200> rotate<0,0.000000,0> translate<10.477500,0.000000,63.817500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382500,0.000000,40.481300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382600,0.000000,39.687500>}
box{<0,0,-0.203200><0.793800,0.035000,0.203200> rotate<0,89.986843,0> translate<12.382500,0.000000,40.481300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382500,0.000000,38.950000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.438800,0.000000,38.950000>}
box{<0,0,-0.203200><0.056300,0.035000,0.203200> rotate<0,0.000000,0> translate<12.382500,0.000000,38.950000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382600,0.000000,39.687500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.438800,0.000000,38.950000>}
box{<0,0,-0.203200><0.739638,0.035000,0.203200> rotate<0,85.636637,0> translate<12.382600,0.000000,39.687500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.167500,0.000000,37.147500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.485000,0.000000,37.203800>}
box{<0,0,-0.100100><0.322453,0.035000,0.100100> rotate<0,-10.054665,0> translate<12.167500,0.000000,37.147500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.430000,-1.535000,2.698800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.541200,-1.535000,3.810000>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,-44.997030,0> translate<11.430000,-1.535000,2.698800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.207500,-1.535000,1.111300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.541300,-1.535000,1.111300>}
box{<0,0,-0.100100><3.333800,0.035000,0.100100> rotate<0,0.000000,0> translate<9.207500,-1.535000,1.111300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.430000,-1.535000,2.698800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.700000,-1.535000,3.968800>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<11.430000,-1.535000,2.698800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.747500,0.000000,6.508800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.700000,0.000000,5.556300>}
box{<0,0,-0.100000><1.347038,0.035000,0.100000> rotate<0,44.997030,0> translate<11.747500,0.000000,6.508800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.700000,0.000000,3.968800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.700000,0.000000,5.556300>}
box{<0,0,-0.100000><1.587500,0.035000,0.100000> rotate<0,90.000000,0> translate<12.700000,0.000000,5.556300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.700000,-1.535000,3.968800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.700000,-1.535000,5.715000>}
box{<0,0,-0.203200><1.746200,0.035000,0.203200> rotate<0,90.000000,0> translate<12.700000,-1.535000,5.715000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,0.000000,9.525000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.700000,0.000000,8.890000>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<12.065000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.065000,0.000000,37.250000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.700000,0.000000,37.306300>}
box{<0,0,-0.100100><0.637491,0.035000,0.100100> rotate<0,-5.066342,0> translate<12.065000,0.000000,37.250000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.485000,0.000000,37.203800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.700000,0.000000,37.306300>}
box{<0,0,-0.100100><0.238183,0.035000,0.100100> rotate<0,-25.487518,0> translate<12.485000,0.000000,37.203800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.541300,0.000000,37.465000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.700000,0.000000,37.306300>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.997030,0> translate<12.541300,0.000000,37.465000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,0.000000,23.653800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.858600,0.000000,24.447500>}
box{<0,0,-0.100000><1.122391,0.035000,0.100000> rotate<0,-45.000640,0> translate<12.065000,0.000000,23.653800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.065000,-1.535000,23.653800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.858700,-1.535000,24.447500>}
box{<0,0,-0.100000><1.122461,0.035000,0.100000> rotate<0,-44.997030,0> translate<12.065000,-1.535000,23.653800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<11.745000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.858800,-1.535000,17.780000>}
box{<0,0,-0.100100><1.113800,0.035000,0.100100> rotate<0,0.000000,0> translate<11.745000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.065000,-1.535000,46.196200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.858800,-1.535000,46.990000>}
box{<0,0,-0.203200><1.122603,0.035000,0.203200> rotate<0,-44.997030,0> translate<12.065000,-1.535000,46.196200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<8.890000,0.000000,6.985000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.017500,0.000000,6.985000>}
box{<0,0,-0.100000><4.127500,0.035000,0.100000> rotate<0,0.000000,0> translate<8.890000,0.000000,6.985000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.223800,0.000000,35.242500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.176300,0.000000,35.242500>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,0.000000,0> translate<12.223800,0.000000,35.242500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.747500,0.000000,53.975000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.176300,0.000000,55.403800>}
box{<0,0,-0.203200><2.020628,0.035000,0.203200> rotate<0,-44.997030,0> translate<11.747500,0.000000,53.975000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.747600,0.000000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.176300,0.000000,59.531300>}
box{<0,0,-0.203200><2.020487,0.035000,0.203200> rotate<0,44.997030,0> translate<11.747600,0.000000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.176300,0.000000,55.403800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.176300,0.000000,59.531300>}
box{<0,0,-0.203200><4.127500,0.035000,0.203200> rotate<0,90.000000,0> translate<13.176300,0.000000,59.531300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.700000,-1.535000,5.715000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335000,-1.535000,6.350000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,-44.997030,0> translate<12.700000,-1.535000,5.715000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.335000,0.000000,9.842600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.335000,0.000000,11.480800>}
box{<0,0,-0.100000><1.638200,0.035000,0.100000> rotate<0,90.000000,0> translate<13.335000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335000,-1.535000,6.350000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335000,-1.535000,15.557500>}
box{<0,0,-0.203200><9.207500,0.035000,0.203200> rotate<0,90.000000,0> translate<13.335000,-1.535000,15.557500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.858800,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<13.335000,-1.535000,17.303800>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,44.997030,0> translate<12.858800,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<13.335000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<13.335000,0.000000,17.303800>}
box{<0,0,-0.100100><5.823000,0.035000,0.100100> rotate<0,90.000000,0> translate<13.335000,0.000000,17.303800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.334900,0.000000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.335000,0.000000,23.177500>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,89.985038,0> translate<13.334900,0.000000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.335000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.335000,0.000000,23.177500>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<13.335000,0.000000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.335000,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.335000,-1.535000,23.812500>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,90.000000,0> translate<13.335000,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335000,-1.535000,33.070800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335000,-1.535000,33.020000>}
box{<0,0,-0.203200><0.050800,0.035000,0.203200> rotate<0,-90.000000,0> translate<13.335000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335000,-1.535000,35.083800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335000,-1.535000,33.070800>}
box{<0,0,-0.203200><2.013000,0.035000,0.203200> rotate<0,-90.000000,0> translate<13.335000,-1.535000,33.070800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.176300,-1.535000,35.242500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335000,-1.535000,35.083800>}
box{<0,0,-0.203200><0.224436,0.035000,0.203200> rotate<0,44.997030,0> translate<13.176300,-1.535000,35.242500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<7.302500,-1.535000,41.433800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335000,-1.535000,41.433800>}
box{<0,0,-0.203200><6.032500,0.035000,0.203200> rotate<0,0.000000,0> translate<7.302500,-1.535000,41.433800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382500,0.000000,40.481300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335000,0.000000,41.433800>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,-44.997030,0> translate<12.382500,0.000000,40.481300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335000,-1.535000,41.433800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335000,-1.535000,43.129200>}
box{<0,0,-0.203200><1.695400,0.035000,0.203200> rotate<0,90.000000,0> translate<13.335000,-1.535000,43.129200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.588800,0.000000,65.087500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335100,0.000000,66.833800>}
box{<0,0,-0.203200><2.469641,0.035000,0.203200> rotate<0,-44.997030,0> translate<11.588800,0.000000,65.087500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.334900,0.000000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.493700,0.000000,23.971300>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.997030,0> translate<13.334900,0.000000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.335000,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.493800,-1.535000,23.971300>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.997030,0> translate<13.335000,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382500,0.000000,63.817500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.615000,0.000000,65.050000>}
box{<0,0,-0.203200><1.743018,0.035000,0.203200> rotate<0,-44.997030,0> translate<12.382500,0.000000,63.817500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.590000,0.000000,65.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.615000,0.000000,65.050000>}
box{<0,0,-0.203200><0.025000,0.035000,0.203200> rotate<0,0.000000,0> translate<13.590000,0.000000,65.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.858800,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.652500,-1.535000,46.990000>}
box{<0,0,-0.203200><0.793700,0.035000,0.203200> rotate<0,0.000000,0> translate<12.858800,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.615000,0.000000,65.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.652500,0.000000,65.087500>}
box{<0,0,-0.203200><0.053033,0.035000,0.203200> rotate<0,-44.997030,0> translate<13.615000,0.000000,65.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.652500,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.684300,-1.535000,47.021800>}
box{<0,0,-0.203200><0.044972,0.035000,0.203200> rotate<0,-44.997030,0> translate<13.652500,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.684300,-1.535000,47.021800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.684300,-1.535000,47.148700>}
box{<0,0,-0.203200><0.126900,0.035000,0.203200> rotate<0,90.000000,0> translate<13.684300,-1.535000,47.148700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.048800,0.000000,7.461300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.811300,0.000000,7.461300>}
box{<0,0,-0.100000><4.762500,0.035000,0.100000> rotate<0,0.000000,0> translate<9.048800,0.000000,7.461300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.335000,0.000000,9.842600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.811300,0.000000,9.366300>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,44.997030,0> translate<13.335000,0.000000,9.842600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335100,0.000000,66.833800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.811300,0.000000,66.833800>}
box{<0,0,-0.203200><0.476200,0.035000,0.203200> rotate<0,0.000000,0> translate<13.335100,0.000000,66.833800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.335000,-1.535000,15.557500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.867500,-1.535000,16.090000>}
box{<0,0,-0.203200><0.753069,0.035000,0.203200> rotate<0,-44.997030,0> translate<13.335000,-1.535000,15.557500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<12.541300,-1.535000,1.111300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<13.970000,-1.535000,2.540000>}
box{<0,0,-0.100100><2.020487,0.035000,0.100100> rotate<0,-44.997030,0> translate<12.541300,-1.535000,1.111300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.700000,0.000000,3.968800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.970000,0.000000,2.698800>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<12.700000,0.000000,3.968800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.970000,0.000000,2.540000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.970000,0.000000,2.698800>}
box{<0,0,-0.100000><0.158800,0.035000,0.100000> rotate<0,90.000000,0> translate<13.970000,0.000000,2.698800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.970000,0.000000,6.032500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.970000,0.000000,5.080000>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,-90.000000,0> translate<13.970000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.017500,0.000000,6.985000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.970000,0.000000,6.032500>}
box{<0,0,-0.100000><1.347038,0.035000,0.100000> rotate<0,44.997030,0> translate<13.017500,0.000000,6.985000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.223700,0.000000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.970000,0.000000,45.243800>}
box{<0,0,-0.203200><1.746300,0.035000,0.203200> rotate<0,0.000000,0> translate<12.223700,0.000000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.970000,0.000000,53.975000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.970000,0.000000,60.642500>}
box{<0,0,-0.203200><6.667500,0.035000,0.203200> rotate<0,90.000000,0> translate<13.970000,0.000000,60.642500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.747400,0.000000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.287500,0.000000,25.082500>}
box{<0,0,-0.100000><2.540100,0.035000,0.100000> rotate<0,0.000000,0> translate<11.747400,0.000000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<10.001300,0.000000,7.937500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.446300,0.000000,7.937500>}
box{<0,0,-0.100000><4.445000,0.035000,0.100000> rotate<0,0.000000,0> translate<10.001300,0.000000,7.937500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<14.605000,0.000000,10.318800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<14.605000,0.000000,11.480800>}
box{<0,0,-0.100100><1.162000,0.035000,0.100100> rotate<0,90.000000,0> translate<14.605000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.605000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.605000,0.000000,23.177500>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<14.605000,0.000000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.287500,0.000000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.605000,0.000000,25.400000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<14.287500,0.000000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.605000,0.000000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.605000,0.000000,31.432500>}
box{<0,0,-0.100000><6.032500,0.035000,0.100000> rotate<0,90.000000,0> translate<14.605000,0.000000,31.432500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.605000,-1.535000,31.432500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.605000,-1.535000,33.070800>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<14.605000,-1.535000,33.070800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.065000,0.000000,37.250000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.605000,0.000000,37.250000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<12.065000,0.000000,37.250000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.605000,0.000000,40.005000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.605000,0.000000,38.950000>}
box{<0,0,-0.203200><1.055000,0.035000,0.203200> rotate<0,-90.000000,0> translate<14.605000,0.000000,38.950000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382500,0.000000,40.005000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.605000,0.000000,40.005000>}
box{<0,0,-0.203200><2.222500,0.035000,0.203200> rotate<0,0.000000,0> translate<12.382500,0.000000,40.005000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.970000,-1.535000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.605000,-1.535000,44.608800>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<13.970000,-1.535000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.605000,-1.535000,43.129200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.605000,-1.535000,44.608800>}
box{<0,0,-0.203200><1.479600,0.035000,0.203200> rotate<0,90.000000,0> translate<14.605000,-1.535000,44.608800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<11.590000,-1.535000,61.117600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.763800,-1.535000,57.943800>}
box{<0,0,-0.203200><4.488431,0.035000,0.203200> rotate<0,44.997030,0> translate<11.590000,-1.535000,61.117600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.493700,0.000000,23.971300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.922500,0.000000,23.971300>}
box{<0,0,-0.100000><1.428800,0.035000,0.100000> rotate<0,0.000000,0> translate<13.493700,0.000000,23.971300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.493800,-1.535000,23.971300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.922500,-1.535000,23.971300>}
box{<0,0,-0.100000><1.428700,0.035000,0.100000> rotate<0,0.000000,0> translate<13.493800,-1.535000,23.971300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.970000,0.000000,60.642500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.922500,0.000000,61.595000>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,-44.997030,0> translate<13.970000,0.000000,60.642500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.811300,0.000000,66.833800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.922500,0.000000,65.722600>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,44.997030,0> translate<13.811300,0.000000,66.833800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.922500,0.000000,61.595000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.922500,0.000000,65.722600>}
box{<0,0,-0.203200><4.127600,0.035000,0.203200> rotate<0,90.000000,0> translate<14.922500,0.000000,65.722600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.081300,0.000000,6.191300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.081300,0.000000,4.127500>}
box{<0,0,-0.100000><2.063800,0.035000,0.100000> rotate<0,-90.000000,0> translate<15.081300,0.000000,4.127500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.811300,0.000000,7.461300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.081300,0.000000,6.191300>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<13.811300,0.000000,7.461300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<14.605000,0.000000,10.318800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<15.081300,0.000000,9.842500>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,44.997030,0> translate<14.605000,0.000000,10.318800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.922500,0.000000,23.971300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.081300,0.000000,23.812500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<14.922500,0.000000,23.971300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.922500,-1.535000,23.971300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.081300,-1.535000,23.812500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<14.922500,-1.535000,23.971300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.240000,-1.535000,16.090000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.240000,-1.535000,16.033800>}
box{<0,0,-0.203200><0.056200,0.035000,0.203200> rotate<0,-90.000000,0> translate<15.240000,-1.535000,16.033800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.867500,-1.535000,16.090000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.240000,-1.535000,16.090000>}
box{<0,0,-0.203200><1.372500,0.035000,0.203200> rotate<0,0.000000,0> translate<13.867500,-1.535000,16.090000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<4.921300,0.000000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398700,0.000000,19.367500>}
box{<0,0,-0.203200><10.477400,0.035000,0.203200> rotate<0,0.000000,0> translate<4.921300,0.000000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.240000,-1.535000,16.033800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398800,-1.535000,16.192600>}
box{<0,0,-0.203200><0.224577,0.035000,0.203200> rotate<0,-44.997030,0> translate<15.240000,-1.535000,16.033800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398800,-1.535000,16.192600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398800,-1.535000,17.938800>}
box{<0,0,-0.203200><1.746200,0.035000,0.203200> rotate<0,90.000000,0> translate<15.398800,-1.535000,17.938800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398800,0.000000,17.938800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398800,0.000000,19.367500>}
box{<0,0,-0.203200><1.428700,0.035000,0.203200> rotate<0,90.000000,0> translate<15.398800,0.000000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.858600,0.000000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.398800,0.000000,24.447500>}
box{<0,0,-0.100000><2.540200,0.035000,0.100000> rotate<0,0.000000,0> translate<12.858600,0.000000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.176300,0.000000,35.242500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398800,0.000000,33.020000>}
box{<0,0,-0.203200><3.143090,0.035000,0.203200> rotate<0,44.997030,0> translate<13.176300,0.000000,35.242500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.970000,0.000000,51.435000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398800,0.000000,50.006200>}
box{<0,0,-0.203200><2.020628,0.035000,0.203200> rotate<0,44.997030,0> translate<13.970000,0.000000,51.435000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398800,0.000000,45.878700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398800,0.000000,50.006200>}
box{<0,0,-0.203200><4.127500,0.035000,0.203200> rotate<0,90.000000,0> translate<15.398800,0.000000,50.006200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.271300,0.000000,8.413800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.557500,0.000000,8.413800>}
box{<0,0,-0.100000><4.286200,0.035000,0.100000> rotate<0,0.000000,0> translate<11.271300,0.000000,8.413800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.660000,-1.535000,47.092500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.660000,-1.535000,46.990000>}
box{<0,0,-0.203200><0.102500,0.035000,0.203200> rotate<0,-90.000000,0> translate<15.660000,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.684300,-1.535000,47.148700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.716200,-1.535000,47.148700>}
box{<0,0,-0.203200><2.031900,0.035000,0.203200> rotate<0,0.000000,0> translate<13.684300,-1.535000,47.148700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.660000,-1.535000,47.092500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.716200,-1.535000,47.148700>}
box{<0,0,-0.203200><0.079479,0.035000,0.203200> rotate<0,-44.997030,0> translate<15.660000,-1.535000,47.092500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.660000,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.716300,-1.535000,46.990000>}
box{<0,0,-0.203200><0.056300,0.035000,0.203200> rotate<0,0.000000,0> translate<15.660000,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.716200,-1.535000,47.148700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.716300,-1.535000,47.148800>}
box{<0,0,-0.203200><0.000141,0.035000,0.203200> rotate<0,-44.997030,0> translate<15.716200,-1.535000,47.148700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,11.430000>}
box{<0,0,-0.203200><0.050800,0.035000,0.203200> rotate<0,-90.000000,0> translate<15.875000,0.000000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,13.493800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,11.480800>}
box{<0,0,-0.203200><2.013000,0.035000,0.203200> rotate<0,-90.000000,0> translate<15.875000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398800,0.000000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,19.843700>}
box{<0,0,-0.203200><0.673448,0.035000,0.203200> rotate<0,-44.997030,0> translate<15.398800,0.000000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398700,0.000000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,19.843800>}
box{<0,0,-0.203200><0.673590,0.035000,0.203200> rotate<0,-44.997030,0> translate<15.398700,0.000000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,21.431300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,19.843800>}
box{<0,0,-0.203200><1.587500,0.035000,0.203200> rotate<0,-90.000000,0> translate<15.875000,0.000000,19.843800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,19.843700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,21.431300>}
box{<0,0,-0.203200><1.587600,0.035000,0.203200> rotate<0,90.000000,0> translate<15.875000,0.000000,21.431300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,21.431300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,21.539200>}
box{<0,0,-0.203200><0.107900,0.035000,0.203200> rotate<0,90.000000,0> translate<15.875000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.398800,0.000000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.875000,0.000000,24.923700>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,-44.997030,0> translate<15.398800,0.000000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.875000,0.000000,24.923700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.875000,0.000000,31.432500>}
box{<0,0,-0.100000><6.508800,0.035000,0.100000> rotate<0,90.000000,0> translate<15.875000,0.000000,31.432500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.875000,-1.535000,31.432500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.875000,-1.535000,33.070800>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<15.875000,-1.535000,33.070800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,-1.535000,43.129200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,-1.535000,44.767500>}
box{<0,0,-0.203200><1.638300,0.035000,0.203200> rotate<0,90.000000,0> translate<15.875000,-1.535000,44.767500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.842500,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.033800,-1.535000,26.352600>}
box{<0,0,-0.100000><6.191300,0.035000,0.100000> rotate<0,-0.000925,0> translate<9.842500,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.700000,0.000000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.192500,0.000000,8.890000>}
box{<0,0,-0.100000><3.492500,0.035000,0.100000> rotate<0,0.000000,0> translate<12.700000,0.000000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<9.763100,-1.535000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.192500,-1.535000,19.367500>}
box{<0,0,-0.203200><6.429400,0.035000,0.203200> rotate<0,0.000000,0> translate<9.763100,-1.535000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398800,0.000000,45.878700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.192500,0.000000,45.085000>}
box{<0,0,-0.203200><1.122461,0.035000,0.203200> rotate<0,44.997030,0> translate<15.398800,0.000000,45.878700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,-1.535000,44.767500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.192500,-1.535000,45.085000>}
box{<0,0,-0.203200><0.449013,0.035000,0.203200> rotate<0,-44.997030,0> translate<15.875000,-1.535000,44.767500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.033800,-1.535000,26.352600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.351300,-1.535000,26.352500>}
box{<0,0,-0.100000><0.317500,0.035000,0.100000> rotate<0,0.018045,0> translate<16.033800,-1.535000,26.352600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.510000,0.000000,2.698800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.510000,0.000000,2.540000>}
box{<0,0,-0.100000><0.158800,0.035000,0.100000> rotate<0,-90.000000,0> translate<16.510000,0.000000,2.540000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.081300,0.000000,4.127500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.510000,0.000000,2.698800>}
box{<0,0,-0.100000><2.020487,0.035000,0.100000> rotate<0,44.997030,0> translate<15.081300,0.000000,4.127500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.510000,0.000000,5.873800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.510000,0.000000,5.080000>}
box{<0,0,-0.100000><0.793800,0.035000,0.100000> rotate<0,-90.000000,0> translate<16.510000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.446300,0.000000,7.937500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.510000,0.000000,5.873800>}
box{<0,0,-0.100000><2.918513,0.035000,0.100000> rotate<0,44.997030,0> translate<14.446300,0.000000,7.937500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,13.493800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.510000,0.000000,14.128800>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,-44.997030,0> translate<15.875000,0.000000,13.493800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<6.667500,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.510000,-1.535000,27.622500>}
box{<0,0,-0.100000><9.842500,0.035000,0.100000> rotate<0,0.000000,0> translate<6.667500,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.510000,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.510100,-1.535000,27.622500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<16.510000,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<9.842500,0.000000,42.545000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.510100,0.000000,42.545000>}
box{<0,0,-0.100100><6.667600,0.035000,0.100100> rotate<0,0.000000,0> translate<9.842500,0.000000,42.545000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.240000,-1.535000,14.390000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.566300,-1.535000,14.390000>}
box{<0,0,-0.203200><1.326300,0.035000,0.203200> rotate<0,0.000000,0> translate<15.240000,-1.535000,14.390000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<5.715000,-1.535000,40.322500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.668800,-1.535000,40.322500>}
box{<0,0,-0.100100><10.953800,0.035000,0.100100> rotate<0,0.000000,0> translate<5.715000,-1.535000,40.322500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.827500,-1.535000,14.128800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.827500,-1.535000,11.906300>}
box{<0,0,-0.203200><2.222500,0.035000,0.203200> rotate<0,-90.000000,0> translate<16.827500,-1.535000,11.906300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.510000,0.000000,14.128800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.827500,0.000000,14.128800>}
box{<0,0,-0.203200><0.317500,0.035000,0.203200> rotate<0,0.000000,0> translate<16.510000,0.000000,14.128800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.566300,-1.535000,14.390000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.827500,-1.535000,14.128800>}
box{<0,0,-0.203200><0.369393,0.035000,0.203200> rotate<0,44.997030,0> translate<16.566300,-1.535000,14.390000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.827500,-1.535000,18.732500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.827500,-1.535000,14.128800>}
box{<0,0,-0.203200><4.603700,0.035000,0.203200> rotate<0,-90.000000,0> translate<16.827500,-1.535000,14.128800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.192500,-1.535000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.827500,-1.535000,18.732500>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<16.192500,-1.535000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.081300,0.000000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.827500,0.000000,23.812500>}
box{<0,0,-0.100000><1.746200,0.035000,0.100000> rotate<0,0.000000,0> translate<15.081300,0.000000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<6.032500,-1.535000,48.577500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.827500,-1.535000,48.577500>}
box{<0,0,-0.203200><10.795000,0.035000,0.203200> rotate<0,0.000000,0> translate<6.032500,-1.535000,48.577500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.930000,0.000000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.930000,0.000000,38.043700>}
box{<0,0,-0.100100><2.483700,0.035000,0.100100> rotate<0,90.000000,0> translate<16.930000,0.000000,38.043700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<13.811300,0.000000,9.366300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.986200,0.000000,9.366300>}
box{<0,0,-0.100000><3.174900,0.035000,0.100000> rotate<0,0.000000,0> translate<13.811300,0.000000,9.366300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986200,0.000000,69.588800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986200,0.000000,70.643700>}
box{<0,0,-0.100100><1.054900,0.035000,0.100100> rotate<0,90.000000,0> translate<16.986200,0.000000,70.643700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.930000,0.000000,38.043700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986300,0.000000,38.100000>}
box{<0,0,-0.100100><0.079620,0.035000,0.100100> rotate<0,-44.997030,0> translate<16.930000,0.000000,38.043700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.930000,0.000000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986300,0.000000,38.100000>}
box{<0,0,-0.100100><0.056300,0.035000,0.100100> rotate<0,0.000000,0> translate<16.930000,0.000000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<4.286300,-1.535000,39.846300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.986300,-1.535000,39.846300>}
box{<0,0,-0.100000><12.700000,0.035000,0.100000> rotate<0,0.000000,0> translate<4.286300,-1.535000,39.846300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986300,0.000000,65.778700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986300,0.000000,65.722500>}
box{<0,0,-0.100100><0.056200,0.035000,0.100100> rotate<0,-90.000000,0> translate<16.986300,0.000000,65.722500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986200,0.000000,65.778800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986300,0.000000,65.778700>}
box{<0,0,-0.100100><0.000141,0.035000,0.100100> rotate<0,44.997030,0> translate<16.986200,0.000000,65.778800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986200,0.000000,67.888800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986300,0.000000,67.888700>}
box{<0,0,-0.100100><0.000141,0.035000,0.100100> rotate<0,44.997030,0> translate<16.986200,0.000000,67.888800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986300,0.000000,65.778700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986300,0.000000,67.888700>}
box{<0,0,-0.100100><2.110000,0.035000,0.100100> rotate<0,90.000000,0> translate<16.986300,0.000000,67.888700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.827500,0.000000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<17.145000,0.000000,24.130000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<16.827500,0.000000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<17.145000,0.000000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<17.145000,0.000000,31.432500>}
box{<0,0,-0.100000><7.302500,0.035000,0.100000> rotate<0,90.000000,0> translate<17.145000,0.000000,31.432500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<17.145000,-1.535000,31.432500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<17.145000,-1.535000,33.070800>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<17.145000,-1.535000,33.070800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.668800,-1.535000,40.322500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<17.145000,-1.535000,40.798700>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,-44.997030,0> translate<16.668800,-1.535000,40.322500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<17.145000,-1.535000,40.798700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<17.145000,-1.535000,43.129200>}
box{<0,0,-0.100100><2.330500,0.035000,0.100100> rotate<0,90.000000,0> translate<17.145000,-1.535000,43.129200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.382500,0.000000,40.005000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.303800,0.000000,40.005000>}
box{<0,0,-0.203200><4.921300,0.035000,0.203200> rotate<0,0.000000,0> translate<12.382500,0.000000,40.005000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.605000,0.000000,40.005000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.303800,0.000000,40.005000>}
box{<0,0,-0.203200><2.698800,0.035000,0.203200> rotate<0,0.000000,0> translate<14.605000,0.000000,40.005000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.360000,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.360000,-1.535000,47.046300>}
box{<0,0,-0.203200><0.056300,0.035000,0.203200> rotate<0,90.000000,0> translate<17.360000,-1.535000,47.046300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.360000,-1.535000,47.046300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.462500,-1.535000,47.148800>}
box{<0,0,-0.203200><0.144957,0.035000,0.203200> rotate<0,-44.997030,0> translate<17.360000,-1.535000,47.046300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.827500,-1.535000,48.577500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.462500,-1.535000,47.942500>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<16.827500,-1.535000,48.577500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.462500,-1.535000,47.148800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.462500,-1.535000,47.942500>}
box{<0,0,-0.203200><0.793700,0.035000,0.203200> rotate<0,90.000000,0> translate<17.462500,-1.535000,47.942500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<17.780000,0.000000,6.191300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<17.780000,0.000000,3.810000>}
box{<0,0,-0.100000><2.381300,0.035000,0.100000> rotate<0,-90.000000,0> translate<17.780000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.557500,0.000000,8.413800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<17.780000,0.000000,6.191300>}
box{<0,0,-0.100000><3.143090,0.035000,0.100000> rotate<0,44.997030,0> translate<15.557500,0.000000,8.413800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.827500,-1.535000,11.906300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.780000,-1.535000,10.953800>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,44.997030,0> translate<16.827500,-1.535000,11.906300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<16.827500,-1.535000,18.732500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.780000,-1.535000,19.685000>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,-44.997030,0> translate<16.827500,-1.535000,18.732500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<17.780000,0.000000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<17.780000,0.000000,55.880000>}
box{<0,0,-0.100100><7.143700,0.035000,0.100100> rotate<0,90.000000,0> translate<17.780000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<15.081300,0.000000,9.842500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<17.938800,0.000000,9.842500>}
box{<0,0,-0.100100><2.857500,0.035000,0.100100> rotate<0,0.000000,0> translate<15.081300,0.000000,9.842500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.303800,0.000000,40.005000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.938800,0.000000,39.370000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<17.303800,0.000000,40.005000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986200,0.000000,70.643700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<17.938800,0.000000,71.596300>}
box{<0,0,-0.100100><1.347180,0.035000,0.100100> rotate<0,-44.997030,0> translate<16.986200,0.000000,70.643700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<17.938800,0.000000,9.842500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<18.097500,0.000000,10.001200>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,-44.997030,0> translate<17.938800,0.000000,9.842500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<18.097500,0.000000,10.001200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<18.097500,0.000000,12.382500>}
box{<0,0,-0.100100><2.381300,0.035000,0.100100> rotate<0,90.000000,0> translate<18.097500,0.000000,12.382500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<18.097500,-1.535000,12.382500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<18.097500,-1.535000,16.510000>}
box{<0,0,-0.100100><4.127500,0.035000,0.100100> rotate<0,90.000000,0> translate<18.097500,-1.535000,16.510000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.605000,0.000000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<18.097500,0.000000,23.177500>}
box{<0,0,-0.100000><3.492500,0.035000,0.100000> rotate<0,0.000000,0> translate<14.605000,0.000000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<10.001300,-1.535000,37.306300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<18.097500,-1.535000,37.306300>}
box{<0,0,-0.100100><8.096200,0.035000,0.100100> rotate<0,0.000000,0> translate<10.001300,-1.535000,37.306300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<11.271300,-1.535000,37.782500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<18.256300,-1.535000,37.782500>}
box{<0,0,-0.100100><6.985000,0.035000,0.100100> rotate<0,0.000000,0> translate<11.271300,-1.535000,37.782500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.938800,0.000000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.256300,0.000000,39.687500>}
box{<0,0,-0.203200><0.449013,0.035000,0.203200> rotate<0,-44.997030,0> translate<17.938800,0.000000,39.370000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.256300,-1.535000,39.687500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.256300,-1.535000,39.687600>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,90.000000,0> translate<18.256300,-1.535000,39.687600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.986200,0.000000,64.078800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<18.358800,0.000000,64.078800>}
box{<0,0,-0.100100><1.372600,0.035000,0.100100> rotate<0,0.000000,0> translate<16.986200,0.000000,64.078800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<18.097500,0.000000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<18.415000,0.000000,23.495000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<18.097500,0.000000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<18.415000,0.000000,23.495000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<18.415000,0.000000,31.432500>}
box{<0,0,-0.100000><7.937500,0.035000,0.100000> rotate<0,90.000000,0> translate<18.415000,0.000000,31.432500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<18.415000,-1.535000,31.432500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<18.415000,-1.535000,33.070800>}
box{<0,0,-0.100000><1.638300,0.035000,0.100000> rotate<0,90.000000,0> translate<18.415000,-1.535000,33.070800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.986300,-1.535000,39.846300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<18.415000,-1.535000,41.275000>}
box{<0,0,-0.100000><2.020487,0.035000,0.100000> rotate<0,-44.997030,0> translate<16.986300,-1.535000,39.846300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<18.415000,-1.535000,41.275000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<18.415000,-1.535000,43.129200>}
box{<0,0,-0.100000><1.854200,0.035000,0.100000> rotate<0,90.000000,0> translate<18.415000,-1.535000,43.129200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.398800,0.000000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.415100,0.000000,33.020000>}
box{<0,0,-0.203200><3.016300,0.035000,0.203200> rotate<0,0.000000,0> translate<15.398800,0.000000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.097500,-1.535000,21.431300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.573800,-1.535000,20.955000>}
box{<0,0,-0.203200><0.673590,0.035000,0.203200> rotate<0,44.997030,0> translate<18.097500,-1.535000,21.431300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.573800,0.000000,38.735000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.573800,0.000000,38.258800>}
box{<0,0,-0.203200><0.476200,0.035000,0.203200> rotate<0,-90.000000,0> translate<18.573800,0.000000,38.258800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.938800,0.000000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.573800,0.000000,38.735000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<17.938800,0.000000,39.370000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.630000,0.000000,38.202600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.630000,0.000000,38.100000>}
box{<0,0,-0.203200><0.102600,0.035000,0.203200> rotate<0,-90.000000,0> translate<18.630000,0.000000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.573800,0.000000,38.258800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.630000,0.000000,38.202600>}
box{<0,0,-0.203200><0.079479,0.035000,0.203200> rotate<0,44.997030,0> translate<18.573800,0.000000,38.258800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<17.780000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<19.050000,0.000000,2.540000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<17.780000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<19.050000,0.000000,6.032500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<19.050000,0.000000,5.080000>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,-90.000000,0> translate<19.050000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.192500,0.000000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<19.050000,0.000000,6.032500>}
box{<0,0,-0.100000><4.041115,0.035000,0.100000> rotate<0,44.997030,0> translate<16.192500,0.000000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.050000,0.000000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.050000,0.000000,30.797500>}
box{<0,0,-0.203200><6.985000,0.035000,0.203200> rotate<0,90.000000,0> translate<19.050000,0.000000,30.797500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<8.572500,-1.535000,29.527500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<19.050100,-1.535000,29.527500>}
box{<0,0,-0.100100><10.477600,0.035000,0.100100> rotate<0,0.000000,0> translate<8.572500,-1.535000,29.527500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<18.097500,-1.535000,16.510000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<19.367500,-1.535000,17.780000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,-44.997030,0> translate<18.097500,-1.535000,16.510000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.256300,-1.535000,39.687500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.367500,-1.535000,40.798700>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,-44.997030,0> translate<18.256300,-1.535000,39.687500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.256300,-1.535000,39.687600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.367500,-1.535000,40.798800>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,-44.997030,0> translate<18.256300,-1.535000,39.687600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.367500,-1.535000,40.798700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.367500,-1.535000,40.798800>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,90.000000,0> translate<19.367500,-1.535000,40.798800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.367500,0.000000,40.798800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.367500,0.000000,42.227500>}
box{<0,0,-0.203200><1.428700,0.035000,0.203200> rotate<0,90.000000,0> translate<19.367500,0.000000,42.227500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<17.780000,0.000000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<19.367500,0.000000,47.148800>}
box{<0,0,-0.100100><2.245064,0.035000,0.100100> rotate<0,44.997030,0> translate<17.780000,0.000000,48.736300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<17.938800,-1.535000,71.596300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<19.367500,-1.535000,73.025000>}
box{<0,0,-0.100100><2.020487,0.035000,0.100100> rotate<0,-44.997030,0> translate<17.938800,-1.535000,71.596300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<19.367500,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<19.370000,-1.535000,17.780000>}
box{<0,0,-0.100100><0.002500,0.035000,0.100100> rotate<0,0.000000,0> translate<19.367500,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.097500,0.000000,21.431300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.526300,0.000000,21.431300>}
box{<0,0,-0.203200><1.428800,0.035000,0.203200> rotate<0,0.000000,0> translate<18.097500,0.000000,21.431300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<15.875000,0.000000,21.431300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.577100,0.000000,21.431300>}
box{<0,0,-0.203200><3.702100,0.035000,0.203200> rotate<0,0.000000,0> translate<15.875000,0.000000,21.431300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.526300,0.000000,21.431300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.634200,0.000000,21.539200>}
box{<0,0,-0.203200><0.152594,0.035000,0.203200> rotate<0,-44.997030,0> translate<19.526300,0.000000,21.431300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<19.684900,-1.535000,13.176300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<19.685000,-1.535000,13.176300>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<19.684900,-1.535000,13.176300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<19.685000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<19.685000,0.000000,13.176300>}
box{<0,0,-0.100000><1.695500,0.035000,0.100000> rotate<0,90.000000,0> translate<19.685000,0.000000,13.176300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.577100,0.000000,21.431300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,0.000000,21.539200>}
box{<0,0,-0.203200><0.152594,0.035000,0.203200> rotate<0,-44.997030,0> translate<19.577100,0.000000,21.431300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.634200,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,0.000000,21.539200>}
box{<0,0,-0.203200><0.050800,0.035000,0.203200> rotate<0,0.000000,0> translate<19.634200,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.050000,0.000000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,0.000000,23.177500>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<19.050000,0.000000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,0.000000,23.177500>}
box{<0,0,-0.203200><1.638300,0.035000,0.203200> rotate<0,90.000000,0> translate<19.685000,0.000000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<19.685000,-1.535000,35.718800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<19.685000,-1.535000,31.908800>}
box{<0,0,-0.100100><3.810000,0.035000,0.100100> rotate<0,-90.000000,0> translate<19.685000,-1.535000,31.908800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<18.097500,-1.535000,37.306300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<19.685000,-1.535000,35.718800>}
box{<0,0,-0.100100><2.245064,0.035000,0.100100> rotate<0,44.997030,0> translate<18.097500,-1.535000,37.306300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.360000,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,-1.535000,46.990000>}
box{<0,0,-0.203200><2.325000,0.035000,0.203200> rotate<0,0.000000,0> translate<17.360000,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,-1.535000,43.815000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,-1.535000,46.990000>}
box{<0,0,-0.203200><3.175000,0.035000,0.203200> rotate<0,90.000000,0> translate<19.685000,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,0.000000,62.071300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,0.000000,63.817500>}
box{<0,0,-0.203200><1.746200,0.035000,0.203200> rotate<0,90.000000,0> translate<19.685000,0.000000,63.817500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<19.684900,-1.535000,13.176300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<19.843700,-1.535000,13.017500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<19.684900,-1.535000,13.176300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.415100,0.000000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.843700,0.000000,31.591300>}
box{<0,0,-0.203200><2.020416,0.035000,0.203200> rotate<0,44.999035,0> translate<18.415100,0.000000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.351300,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<19.843800,-1.535000,26.352500>}
box{<0,0,-0.100000><3.492500,0.035000,0.100000> rotate<0,0.000000,0> translate<16.351300,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.050000,0.000000,30.797500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.843800,0.000000,31.591300>}
box{<0,0,-0.203200><1.122603,0.035000,0.203200> rotate<0,-44.997030,0> translate<19.050000,0.000000,30.797500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.843700,0.000000,31.591300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.843800,0.000000,31.591300>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,0.000000,0> translate<19.843700,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<19.843800,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.002500,-1.535000,26.193800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<19.843800,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.778800,-1.535000,26.987500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.002500,-1.535000,26.987500>}
box{<0,0,-0.100100><12.223700,0.035000,0.100100> rotate<0,0.000000,0> translate<7.778800,-1.535000,26.987500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<19.050100,-1.535000,29.527500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.002500,-1.535000,30.480000>}
box{<0,0,-0.100100><1.346968,0.035000,0.100100> rotate<0,-45.000038,0> translate<19.050100,-1.535000,29.527500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.302500,-1.535000,29.051300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.161300,-1.535000,29.051300>}
box{<0,0,-0.100100><12.858800,0.035000,0.100100> rotate<0,0.000000,0> translate<7.302500,-1.535000,29.051300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.161300,-1.535000,35.877500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.161300,-1.535000,32.067500>}
box{<0,0,-0.100100><3.810000,0.035000,0.100100> rotate<0,-90.000000,0> translate<20.161300,-1.535000,32.067500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<18.256300,-1.535000,37.782500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.161300,-1.535000,35.877500>}
box{<0,0,-0.100100><2.694077,0.035000,0.100100> rotate<0,44.997030,0> translate<18.256300,-1.535000,37.782500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.161300,-1.535000,60.325000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.161300,-1.535000,61.436400>}
box{<0,0,-0.203200><1.111400,0.035000,0.203200> rotate<0,90.000000,0> translate<20.161300,-1.535000,61.436400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,0.000000,63.817500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.161300,0.000000,64.293800>}
box{<0,0,-0.203200><0.673590,0.035000,0.203200> rotate<0,-44.997030,0> translate<19.685000,0.000000,63.817500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<13.590000,-1.535000,62.550000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.163800,-1.535000,62.550000>}
box{<0,0,-0.203200><6.573800,0.035000,0.203200> rotate<0,0.000000,0> translate<13.590000,-1.535000,62.550000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,0.000000,62.071300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.319900,0.000000,61.436400>}
box{<0,0,-0.203200><0.897884,0.035000,0.203200> rotate<0,44.997030,0> translate<19.685000,0.000000,62.071300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.161300,0.000000,61.436400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.319900,0.000000,61.436400>}
box{<0,0,-0.203200><0.158600,0.035000,0.203200> rotate<0,0.000000,0> translate<20.161300,0.000000,61.436400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.320000,0.000000,6.032500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.320000,0.000000,3.810000>}
box{<0,0,-0.100000><2.222500,0.035000,0.100000> rotate<0,-90.000000,0> translate<20.320000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.986200,0.000000,9.366300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.320000,0.000000,6.032500>}
box{<0,0,-0.100000><4.714705,0.035000,0.100000> rotate<0,44.997030,0> translate<16.986200,0.000000,9.366300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.002500,-1.535000,26.987500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.320000,-1.535000,26.670000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<20.002500,-1.535000,26.987500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<6.985000,-1.535000,28.575000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.320000,-1.535000,28.575000>}
box{<0,0,-0.100100><13.335000,0.035000,0.100100> rotate<0,0.000000,0> translate<6.985000,-1.535000,28.575000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.161300,-1.535000,29.051300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.320000,-1.535000,29.210000>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,-44.997030,0> translate<20.161300,-1.535000,29.051300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.320000,-1.535000,52.390000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.320000,-1.535000,55.880000>}
box{<0,0,-0.203200><3.490000,0.035000,0.203200> rotate<0,90.000000,0> translate<20.320000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.319900,0.000000,61.436400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.320000,0.000000,61.436300>}
box{<0,0,-0.203200><0.000141,0.035000,0.203200> rotate<0,44.997030,0> translate<20.319900,0.000000,61.436400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<18.358800,0.000000,64.078800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.320000,0.000000,66.040000>}
box{<0,0,-0.100100><2.773556,0.035000,0.100100> rotate<0,-44.997030,0> translate<18.358800,0.000000,64.078800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.320000,-1.535000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.320000,-1.535000,66.040000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,-90.000000,0> translate<20.320000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.320000,-1.535000,70.326200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.320000,-1.535000,68.580000>}
box{<0,0,-0.203200><1.746200,0.035000,0.203200> rotate<0,-90.000000,0> translate<20.320000,-1.535000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.780000,-1.535000,19.685000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.478800,-1.535000,19.685000>}
box{<0,0,-0.203200><2.698800,0.035000,0.203200> rotate<0,0.000000,0> translate<17.780000,-1.535000,19.685000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<7.620100,-1.535000,28.098800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.478800,-1.535000,28.098800>}
box{<0,0,-0.100100><12.858700,0.035000,0.100100> rotate<0,0.000000,0> translate<7.620100,-1.535000,28.098800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.320000,-1.535000,28.575000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.478800,-1.535000,28.733800>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,-44.997030,0> translate<20.320000,-1.535000,28.575000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.478800,-1.535000,28.098800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.637500,-1.535000,28.257500>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,-44.997030,0> translate<20.478800,-1.535000,28.098800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.574000,-1.535000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.637500,-1.535000,49.593500>}
box{<0,0,-0.203200><0.089803,0.035000,0.203200> rotate<0,-44.997030,0> translate<20.574000,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.637500,-1.535000,49.593500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.637500,-1.535000,52.070000>}
box{<0,0,-0.203200><2.476500,0.035000,0.203200> rotate<0,90.000000,0> translate<20.637500,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.320000,-1.535000,52.390000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.640000,-1.535000,52.070000>}
box{<0,0,-0.203200><0.452548,0.035000,0.203200> rotate<0,44.997030,0> translate<20.320000,-1.535000,52.390000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.637500,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.640000,-1.535000,52.070000>}
box{<0,0,-0.203200><0.002500,0.035000,0.203200> rotate<0,0.000000,0> translate<20.637500,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<16.510000,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.796300,-1.535000,27.622500>}
box{<0,0,-0.100000><4.286300,0.035000,0.100000> rotate<0,0.000000,0> translate<16.510000,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.163800,-1.535000,62.550000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.796300,-1.535000,63.182500>}
box{<0,0,-0.203200><0.894490,0.035000,0.203200> rotate<0,-44.997030,0> translate<20.163800,-1.535000,62.550000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.955000,0.000000,5.715000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.955000,0.000000,11.480800>}
box{<0,0,-0.100000><5.765800,0.035000,0.100000> rotate<0,90.000000,0> translate<20.955000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.955000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.955000,0.000000,13.811300>}
box{<0,0,-0.100000><2.330500,0.035000,0.100000> rotate<0,90.000000,0> translate<20.955000,0.000000,13.811300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.955000,0.000000,27.463800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.955000,0.000000,21.539200>}
box{<0,0,-0.100000><5.924600,0.035000,0.100000> rotate<0,-90.000000,0> translate<20.955000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.796300,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.955000,-1.535000,27.463800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<20.796300,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<16.510100,0.000000,42.545000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.955100,0.000000,38.100000>}
box{<0,0,-0.100100><6.286179,0.035000,0.100100> rotate<0,44.997030,0> translate<16.510100,0.000000,42.545000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.955000,-1.535000,27.463800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.113800,-1.535000,27.622500>}
box{<0,0,-0.100000><0.224506,0.035000,0.100000> rotate<0,-44.978985,0> translate<20.955000,-1.535000,27.463800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.161300,0.000000,64.293800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.113800,0.000000,64.293800>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,0.000000,0> translate<20.161300,0.000000,64.293800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.270000,-1.535000,18.893800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.270000,-1.535000,17.780000>}
box{<0,0,-0.203200><1.113800,0.035000,0.203200> rotate<0,-90.000000,0> translate<21.270000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.478800,-1.535000,19.685000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.270000,-1.535000,18.893800>}
box{<0,0,-0.203200><1.118926,0.035000,0.203200> rotate<0,44.997030,0> translate<20.478800,-1.535000,19.685000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.955000,-1.535000,13.811300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.272500,-1.535000,13.493800>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<20.955000,-1.535000,13.811300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.320000,-1.535000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.431300,-1.535000,26.670000>}
box{<0,0,-0.100000><1.111300,0.035000,0.100000> rotate<0,0.000000,0> translate<20.320000,-1.535000,26.670000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.320000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.590000,0.000000,2.540000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<20.320000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.955000,0.000000,5.715000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.590000,0.000000,5.080000>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<20.955000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,34.290000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,32.861300>}
box{<0,0,-0.203200><1.428700,0.035000,0.203200> rotate<0,-90.000000,0> translate<21.590000,-1.535000,32.861300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.843700,0.000000,31.591300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,0.000000,33.337500>}
box{<0,0,-0.203200><2.469570,0.035000,0.203200> rotate<0,-44.995390,0> translate<19.843700,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,0.000000,33.337500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,0.000000,34.290000>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,90.000000,0> translate<21.590000,0.000000,34.290000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,34.290000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,36.830000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<21.590000,-1.535000,36.830000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,36.830000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,39.370000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<21.590000,-1.535000,39.370000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,-1.535000,43.815000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,41.910000>}
box{<0,0,-0.203200><2.694077,0.035000,0.203200> rotate<0,44.997030,0> translate<19.685000,-1.535000,43.815000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,41.910000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<21.590000,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,42.386200>}
box{<0,0,-0.203200><0.476200,0.035000,0.203200> rotate<0,90.000000,0> translate<21.590000,-1.535000,42.386200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.367500,0.000000,42.227500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,0.000000,44.450000>}
box{<0,0,-0.203200><3.143090,0.035000,0.203200> rotate<0,-44.997030,0> translate<19.367500,0.000000,42.227500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.685000,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,46.990000>}
box{<0,0,-0.203200><1.905000,0.035000,0.203200> rotate<0,0.000000,0> translate<19.685000,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.161300,-1.535000,60.325000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,58.896300>}
box{<0,0,-0.203200><2.020487,0.035000,0.203200> rotate<0,44.997030,0> translate<20.161300,-1.535000,60.325000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,0.000000,59.213700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,0.000000,60.642500>}
box{<0,0,-0.203200><1.428800,0.035000,0.203200> rotate<0,90.000000,0> translate<21.590000,0.000000,60.642500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.113800,0.000000,64.293800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,0.000000,64.770000>}
box{<0,0,-0.203200><0.673448,0.035000,0.203200> rotate<0,-44.997030,0> translate<21.113800,0.000000,64.293800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,60.642500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,66.675000>}
box{<0,0,-0.203200><6.032500,0.035000,0.203200> rotate<0,90.000000,0> translate<21.590000,-1.535000,66.675000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,66.675000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,66.675100>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,90.000000,0> translate<21.590000,-1.535000,66.675100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,0.000000,64.770000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,0.000000,67.310000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<21.590000,0.000000,67.310000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.431300,-1.535000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.748700,-1.535000,26.987500>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,-45.006054,0> translate<21.431300,-1.535000,26.670000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.113800,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.748700,-1.535000,27.622500>}
box{<0,0,-0.100000><0.634900,0.035000,0.100000> rotate<0,0.000000,0> translate<21.113800,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.748700,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.907500,-1.535000,27.781300>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.997030,0> translate<21.748700,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<19.685000,-1.535000,31.908800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<21.907500,-1.535000,29.686300>}
box{<0,0,-0.100100><3.143090,0.035000,0.100100> rotate<0,44.997030,0> translate<19.685000,-1.535000,31.908800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.161300,-1.535000,32.067500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.066300,-1.535000,30.162500>}
box{<0,0,-0.100100><2.694077,0.035000,0.100100> rotate<0,44.997030,0> translate<20.161300,-1.535000,32.067500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<14.763800,-1.535000,57.943800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.066300,-1.535000,57.943800>}
box{<0,0,-0.203200><7.302500,0.035000,0.203200> rotate<0,0.000000,0> translate<14.763800,-1.535000,57.943800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.002500,0.000000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.098000,0.000000,30.480000>}
box{<0,0,-0.100100><2.095500,0.035000,0.100100> rotate<0,0.000000,0> translate<20.002500,0.000000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.225000,0.000000,8.096300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.225000,0.000000,11.480800>}
box{<0,0,-0.100000><3.384500,0.035000,0.100000> rotate<0,90.000000,0> translate<22.225000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.224900,-1.535000,14.287500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.225000,-1.535000,14.287500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<22.224900,-1.535000,14.287500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.225000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.225000,0.000000,14.287500>}
box{<0,0,-0.100000><2.806700,0.035000,0.100000> rotate<0,90.000000,0> translate<22.225000,0.000000,14.287500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.225000,0.000000,26.987500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.225000,0.000000,21.539200>}
box{<0,0,-0.100000><5.448300,0.035000,0.100000> rotate<0,-90.000000,0> translate<22.225000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.748700,-1.535000,26.987500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.225000,-1.535000,26.987500>}
box{<0,0,-0.100000><0.476300,0.035000,0.100000> rotate<0,0.000000,0> translate<21.748700,-1.535000,26.987500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,66.675000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.225000,-1.535000,67.310000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,-44.997030,0> translate<21.590000,-1.535000,66.675000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,66.675100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.225000,-1.535000,67.310000>}
box{<0,0,-0.203200><0.897955,0.035000,0.203200> rotate<0,-44.992519,0> translate<21.590000,-1.535000,66.675100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.320000,-1.535000,70.326200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.225100,-1.535000,72.231300>}
box{<0,0,-0.203200><2.694218,0.035000,0.203200> rotate<0,-44.997030,0> translate<20.320000,-1.535000,70.326200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,32.861300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.383800,-1.535000,32.067500>}
box{<0,0,-0.203200><1.122603,0.035000,0.203200> rotate<0,44.997030,0> translate<21.590000,-1.535000,32.861300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,42.386200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.383800,-1.535000,43.180000>}
box{<0,0,-0.203200><1.122603,0.035000,0.203200> rotate<0,-44.997030,0> translate<21.590000,-1.535000,42.386200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.796300,0.000000,63.182500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.383800,0.000000,63.182500>}
box{<0,0,-0.203200><1.587500,0.035000,0.203200> rotate<0,0.000000,0> translate<20.796300,0.000000,63.182500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.224900,-1.535000,14.287500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.542500,-1.535000,13.970000>}
box{<0,0,-0.100000><0.449084,0.035000,0.100000> rotate<0,44.988009,0> translate<22.224900,-1.535000,14.287500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<20.002500,-1.535000,26.193800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.542500,-1.535000,26.193800>}
box{<0,0,-0.100000><2.540000,0.035000,0.100000> rotate<0,0.000000,0> translate<20.002500,-1.535000,26.193800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.907500,-1.535000,27.781300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.542500,-1.535000,27.781300>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,0.000000,0> translate<21.907500,-1.535000,27.781300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.542500,-1.535000,47.942500>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,-44.997030,0> translate<21.590000,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.542500,-1.535000,47.942500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.542500,-1.535000,49.371300>}
box{<0,0,-0.203200><1.428800,0.035000,0.203200> rotate<0,90.000000,0> translate<22.542500,-1.535000,49.371300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.542500,-1.535000,49.371300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.606000,-1.535000,49.434800>}
box{<0,0,-0.203200><0.089803,0.035000,0.203200> rotate<0,-44.997030,0> translate<22.542500,-1.535000,49.371300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.606000,-1.535000,49.434800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.606000,-1.535000,49.530000>}
box{<0,0,-0.203200><0.095200,0.035000,0.203200> rotate<0,90.000000,0> translate<22.606000,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.542500,-1.535000,26.193800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.701200,-1.535000,26.352500>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<22.542500,-1.535000,26.193800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.542500,-1.535000,27.781300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.701300,-1.535000,27.622500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<22.542500,-1.535000,27.781300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.637500,-1.535000,28.257500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.701300,-1.535000,28.257500>}
box{<0,0,-0.100100><2.063800,0.035000,0.100100> rotate<0,0.000000,0> translate<20.637500,-1.535000,28.257500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.383800,-1.535000,32.067500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.701300,-1.535000,32.067500>}
box{<0,0,-0.203200><0.317500,0.035000,0.203200> rotate<0,0.000000,0> translate<22.383800,-1.535000,32.067500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.225000,0.000000,8.096300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.860000,0.000000,7.461300>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<22.225000,0.000000,8.096300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.860000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.860000,0.000000,7.461300>}
box{<0,0,-0.100000><3.651300,0.035000,0.100000> rotate<0,90.000000,0> translate<22.860000,0.000000,7.461300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.701300,-1.535000,28.257500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.860000,-1.535000,28.098800>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.997030,0> translate<22.701300,-1.535000,28.257500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.478800,-1.535000,28.733800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.860000,-1.535000,28.733800>}
box{<0,0,-0.100100><2.381200,0.035000,0.100100> rotate<0,0.000000,0> translate<20.478800,-1.535000,28.733800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<18.630000,0.000000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.860000,0.000000,35.560000>}
box{<0,0,-0.100100><4.230000,0.035000,0.100100> rotate<0,0.000000,0> translate<18.630000,0.000000,35.560000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.955100,0.000000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.860000,0.000000,38.100000>}
box{<0,0,-0.100100><1.904900,0.035000,0.100100> rotate<0,0.000000,0> translate<20.955100,0.000000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.860000,0.000000,40.957600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.860000,0.000000,43.338800>}
box{<0,0,-0.100100><2.381200,0.035000,0.100100> rotate<0,90.000000,0> translate<22.860000,0.000000,43.338800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.606000,0.000000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.860000,0.000000,49.784000>}
box{<0,0,-0.203200><0.359210,0.035000,0.203200> rotate<0,-44.997030,0> translate<22.606000,0.000000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.860000,0.000000,49.784000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.860000,0.000000,55.880000>}
box{<0,0,-0.203200><6.096000,0.035000,0.203200> rotate<0,90.000000,0> translate<22.860000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.066300,-1.535000,57.943800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.860000,-1.535000,57.150100>}
box{<0,0,-0.203200><1.122461,0.035000,0.203200> rotate<0,44.997030,0> translate<22.066300,-1.535000,57.943800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.860000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.860000,-1.535000,57.150100>}
box{<0,0,-0.203200><1.270100,0.035000,0.203200> rotate<0,90.000000,0> translate<22.860000,-1.535000,57.150100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,0.000000,59.213700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.860000,0.000000,57.943800>}
box{<0,0,-0.203200><1.795981,0.035000,0.203200> rotate<0,44.994774,0> translate<21.590000,0.000000,59.213700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.860000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.860000,0.000000,57.943800>}
box{<0,0,-0.203200><2.063800,0.035000,0.203200> rotate<0,90.000000,0> translate<22.860000,0.000000,57.943800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,0.000000,67.310000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.860000,0.000000,68.580000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<21.590000,0.000000,67.310000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<19.367500,0.000000,47.148800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.018700,0.000000,47.148800>}
box{<0,0,-0.100100><3.651200,0.035000,0.100100> rotate<0,0.000000,0> translate<19.367500,0.000000,47.148800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<11.271300,-1.535000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.018800,-1.535000,25.717500>}
box{<0,0,-0.100000><11.747500,0.035000,0.100000> rotate<0,0.000000,0> translate<11.271300,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.225000,-1.535000,26.987500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.018800,-1.535000,26.987500>}
box{<0,0,-0.100000><0.793800,0.035000,0.100000> rotate<0,0.000000,0> translate<22.225000,-1.535000,26.987500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.860000,-1.535000,28.733800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.018800,-1.535000,28.575000>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<22.860000,-1.535000,28.733800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<20.320000,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.018800,-1.535000,29.210000>}
box{<0,0,-0.100100><2.698800,0.035000,0.100100> rotate<0,0.000000,0> translate<20.320000,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.018800,-1.535000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.177500,-1.535000,25.558800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<23.018800,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.018800,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.177500,-1.535000,29.051300>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.997030,0> translate<23.018800,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<21.907500,-1.535000,29.686300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.177500,-1.535000,29.686300>}
box{<0,0,-0.100100><1.270000,0.035000,0.100100> rotate<0,0.000000,0> translate<21.907500,-1.535000,29.686300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.540000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<23.177500,-1.535000,52.070000>}
box{<0,0,-0.203200><0.637500,0.035000,0.203200> rotate<0,0.000000,0> translate<22.540000,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.018800,-1.535000,26.987500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.177600,-1.535000,27.146300>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.997030,0> translate<23.018800,-1.535000,26.987500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.177500,-1.535000,29.686300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.336300,-1.535000,29.527500>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<23.177500,-1.535000,29.686300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.066300,-1.535000,30.162500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.336300,-1.535000,30.162500>}
box{<0,0,-0.100100><1.270000,0.035000,0.100100> rotate<0,0.000000,0> translate<22.066300,-1.535000,30.162500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.860000,0.000000,40.957600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.336300,0.000000,40.481300>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,44.997030,0> translate<22.860000,0.000000,40.957600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.495000,0.000000,5.873800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.495000,0.000000,11.480800>}
box{<0,0,-0.100000><5.607000,0.035000,0.100000> rotate<0,90.000000,0> translate<23.495000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.494900,-1.535000,14.763800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.495000,-1.535000,14.763800>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<23.494900,-1.535000,14.763800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.495000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.495000,0.000000,14.763800>}
box{<0,0,-0.100000><3.283000,0.035000,0.100000> rotate<0,90.000000,0> translate<23.495000,0.000000,14.763800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.495000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.495000,0.000000,20.161300>}
box{<0,0,-0.100100><1.377900,0.035000,0.100100> rotate<0,-90.000000,0> translate<23.495000,0.000000,20.161300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.495000,0.000000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.495000,0.000000,21.539200>}
box{<0,0,-0.100000><4.813300,0.035000,0.100000> rotate<0,-90.000000,0> translate<23.495000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.701200,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.495000,-1.535000,26.352500>}
box{<0,0,-0.100000><0.793800,0.035000,0.100000> rotate<0,0.000000,0> translate<22.701200,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.336300,-1.535000,30.162500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.495000,-1.535000,30.003800>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.997030,0> translate<23.336300,-1.535000,30.162500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<23.368000,0.000000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<23.495000,0.000000,60.960000>}
box{<0,0,-0.203200><0.127000,0.035000,0.203200> rotate<0,0.000000,0> translate<23.368000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<23.495000,0.000000,62.071300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<23.495000,0.000000,60.960000>}
box{<0,0,-0.203200><1.111300,0.035000,0.203200> rotate<0,-90.000000,0> translate<23.495000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.383800,0.000000,63.182500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<23.495000,0.000000,62.071300>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,44.997030,0> translate<22.383800,0.000000,63.182500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.270000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<23.656200,-1.535000,17.780000>}
box{<0,0,-0.203200><2.386200,0.035000,0.203200> rotate<0,0.000000,0> translate<21.270000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.494900,-1.535000,14.763800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.812500,-1.535000,14.446300>}
box{<0,0,-0.100000><0.449084,0.035000,0.100000> rotate<0,44.988009,0> translate<23.494900,-1.535000,14.763800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.177500,-1.535000,25.558800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.812500,-1.535000,25.558800>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,0.000000,0> translate<23.177500,-1.535000,25.558800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.177600,-1.535000,27.146300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.812500,-1.535000,27.146300>}
box{<0,0,-0.100000><0.634900,0.035000,0.100000> rotate<0,0.000000,0> translate<23.177600,-1.535000,27.146300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.812500,-1.535000,25.558800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.971200,-1.535000,25.717500>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<23.812500,-1.535000,25.558800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<23.622000,0.000000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<23.971200,0.000000,30.480000>}
box{<0,0,-0.203200><0.349200,0.035000,0.203200> rotate<0,0.000000,0> translate<23.622000,0.000000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.860000,0.000000,43.338800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.971200,0.000000,44.450000>}
box{<0,0,-0.100100><1.571474,0.035000,0.100100> rotate<0,-44.997030,0> translate<22.860000,0.000000,43.338800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.812500,-1.535000,27.146300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.971300,-1.535000,26.987500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<23.812500,-1.535000,27.146300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.860000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.130000,0.000000,2.540000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<22.860000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.495000,0.000000,5.873800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.130000,0.000000,5.238800>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<23.495000,0.000000,5.873800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.130000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.130000,0.000000,5.238800>}
box{<0,0,-0.100000><0.158800,0.035000,0.100000> rotate<0,90.000000,0> translate<24.130000,0.000000,5.238800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.860000,0.000000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.130000,0.000000,36.830000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,-44.997030,0> translate<22.860000,0.000000,35.560000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.860000,0.000000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.130000,0.000000,39.370000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,-44.997030,0> translate<22.860000,0.000000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.971200,0.000000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.130000,0.000000,44.450000>}
box{<0,0,-0.100100><0.158800,0.035000,0.100100> rotate<0,0.000000,0> translate<23.971200,0.000000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.018700,-1.535000,47.148800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.130000,-1.535000,47.148800>}
box{<0,0,-0.100100><1.111300,0.035000,0.100100> rotate<0,0.000000,0> translate<23.018700,-1.535000,47.148800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.225000,-1.535000,67.310000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.130000,-1.535000,67.310000>}
box{<0,0,-0.203200><1.905000,0.035000,0.203200> rotate<0,0.000000,0> translate<22.225000,-1.535000,67.310000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.860000,0.000000,66.040000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.130000,0.000000,67.310000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<22.860000,0.000000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.382500,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.288700,-1.535000,25.082500>}
box{<0,0,-0.100000><11.906200,0.035000,0.100000> rotate<0,0.000000,0> translate<12.382500,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.495000,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.288700,-1.535000,26.352500>}
box{<0,0,-0.100000><0.793700,0.035000,0.100000> rotate<0,0.000000,0> translate<23.495000,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.495000,0.000000,20.161300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.288800,0.000000,19.367500>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,44.997030,0> translate<23.495000,0.000000,20.161300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.288700,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.447400,-1.535000,24.923800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<24.288700,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.288700,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.447500,-1.535000,26.511300>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.997030,0> translate<24.288700,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.765000,0.000000,7.143800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.765000,0.000000,11.480800>}
box{<0,0,-0.100000><4.337000,0.035000,0.100000> rotate<0,90.000000,0> translate<24.765000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.764900,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.765000,-1.535000,15.240000>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<24.764900,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.765000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.765000,0.000000,15.240000>}
box{<0,0,-0.100000><3.759200,0.035000,0.100000> rotate<0,90.000000,0> translate<24.765000,0.000000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.765000,0.000000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.765000,0.000000,21.539200>}
box{<0,0,-0.100000><4.178300,0.035000,0.100000> rotate<0,-90.000000,0> translate<24.765000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.971200,-1.535000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.765000,-1.535000,25.717500>}
box{<0,0,-0.100000><0.793800,0.035000,0.100000> rotate<0,0.000000,0> translate<23.971200,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<19.367500,0.000000,42.227500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.765000,0.000000,47.625000>}
box{<0,0,-0.203200><7.633218,0.035000,0.203200> rotate<0,-44.997030,0> translate<19.367500,0.000000,42.227500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,0.000000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.765000,0.000000,47.625000>}
box{<0,0,-0.203200><4.490128,0.035000,0.203200> rotate<0,-44.997030,0> translate<21.590000,0.000000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.765000,0.000000,47.625000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.765000,0.000000,48.736300>}
box{<0,0,-0.203200><1.111300,0.035000,0.203200> rotate<0,90.000000,0> translate<24.765000,0.000000,48.736300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<23.177500,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.765000,-1.535000,50.482500>}
box{<0,0,-0.203200><2.245064,0.035000,0.203200> rotate<0,44.997030,0> translate<23.177500,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.765000,-1.535000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.765000,-1.535000,50.482500>}
box{<0,0,-0.203200><1.746200,0.035000,0.203200> rotate<0,90.000000,0> translate<24.765000,-1.535000,50.482500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.765000,0.000000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.765000,0.000000,60.833000>}
box{<0,0,-0.203200><12.096700,0.035000,0.203200> rotate<0,90.000000,0> translate<24.765000,0.000000,60.833000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.765000,0.000000,60.833000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.892000,0.000000,60.960000>}
box{<0,0,-0.203200><0.179605,0.035000,0.203200> rotate<0,-44.997030,0> translate<24.765000,0.000000,60.833000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.336300,0.000000,40.481300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.923800,0.000000,40.481300>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,0.000000,0> translate<23.336300,0.000000,40.481300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.130000,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.923800,-1.535000,41.910000>}
box{<0,0,-0.100100><0.793800,0.035000,0.100100> rotate<0,0.000000,0> translate<24.130000,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.383800,-1.535000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.923800,-1.535000,43.180000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<22.383800,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.860000,0.000000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.923800,0.000000,70.643800>}
box{<0,0,-0.203200><2.918654,0.035000,0.203200> rotate<0,-44.997030,0> translate<22.860000,0.000000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.923800,0.000000,70.643800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.923800,0.000000,74.453800>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<24.923800,0.000000,74.453800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.764900,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.082500,-1.535000,14.922500>}
box{<0,0,-0.100000><0.449084,0.035000,0.100000> rotate<0,44.988009,0> translate<24.764900,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.288800,0.000000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.082500,0.000000,19.367500>}
box{<0,0,-0.100100><0.793700,0.035000,0.100100> rotate<0,0.000000,0> translate<24.288800,0.000000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.447500,-1.535000,26.511300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.082500,-1.535000,26.511300>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,0.000000,0> translate<24.447500,-1.535000,26.511300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.447400,-1.535000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.082600,-1.535000,24.923800>}
box{<0,0,-0.100000><0.635200,0.035000,0.100000> rotate<0,0.000000,0> translate<24.447400,-1.535000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.923800,0.000000,40.481300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.082700,0.000000,40.481200>}
box{<0,0,-0.100100><0.158900,0.035000,0.100100> rotate<0,0.036055,0> translate<24.923800,0.000000,40.481300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.082600,-1.535000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.241300,-1.535000,25.082500>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<25.082600,-1.535000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.082500,-1.535000,26.511300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.241300,-1.535000,26.352500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<25.082500,-1.535000,26.511300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.765000,0.000000,7.143800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.400000,0.000000,6.508800>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<24.765000,0.000000,7.143800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.400000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.400000,0.000000,6.508800>}
box{<0,0,-0.100000><2.698800,0.035000,0.100000> rotate<0,90.000000,0> translate<25.400000,0.000000,6.508800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.400000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.400000,0.000000,58.261200>}
box{<0,0,-0.203200><2.381200,0.035000,0.203200> rotate<0,90.000000,0> translate<25.400000,0.000000,58.261200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.400000,0.000000,64.770000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.400000,0.000000,66.040000>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,90.000000,0> translate<25.400000,0.000000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.130000,-1.535000,67.310000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.400000,-1.535000,68.580000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<24.130000,-1.535000,67.310000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.556200,-1.535000,18.893800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.556200,-1.535000,17.780000>}
box{<0,0,-0.100100><1.113800,0.035000,0.100100> rotate<0,-90.000000,0> translate<25.556200,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.082500,-1.535000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.556200,-1.535000,18.893800>}
box{<0,0,-0.100100><0.669913,0.035000,0.100100> rotate<0,44.997030,0> translate<25.082500,-1.535000,19.367500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<24.765000,-1.535000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.558700,-1.535000,25.717500>}
box{<0,0,-0.100000><0.793700,0.035000,0.100000> rotate<0,0.000000,0> translate<24.765000,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<12.858700,-1.535000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.558800,-1.535000,24.447500>}
box{<0,0,-0.100000><12.700100,0.035000,0.100000> rotate<0,0.000000,0> translate<12.858700,-1.535000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.558800,-1.535000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.717500,-1.535000,24.288800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<25.558800,-1.535000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.558700,-1.535000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.717500,-1.535000,25.876300>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.997030,0> translate<25.558700,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.130000,0.000000,34.290000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.717500,0.000000,34.290000>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,0.000000,0> translate<24.130000,0.000000,34.290000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.130000,0.000000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.717500,0.000000,39.370000>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,0.000000,0> translate<24.130000,0.000000,39.370000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.717500,-1.535000,42.545000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.717500,-1.535000,42.068800>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,-90.000000,0> translate<25.717500,-1.535000,42.068800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.717500,0.000000,45.561300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.717500,0.000000,42.545000>}
box{<0,0,-0.100100><3.016300,0.035000,0.100100> rotate<0,-90.000000,0> translate<25.717500,0.000000,42.545000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.130000,-1.535000,47.148800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.717500,-1.535000,45.561300>}
box{<0,0,-0.100100><2.245064,0.035000,0.100100> rotate<0,44.997030,0> translate<24.130000,-1.535000,47.148800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.923800,-1.535000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.717600,-1.535000,43.973800>}
box{<0,0,-0.203200><1.122603,0.035000,0.203200> rotate<0,-44.997030,0> translate<24.923800,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.400000,0.000000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.876300,0.000000,69.056300>}
box{<0,0,-0.203200><0.673590,0.035000,0.203200> rotate<0,-44.997030,0> translate<25.400000,0.000000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.876300,0.000000,69.056300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.876300,0.000000,73.025100>}
box{<0,0,-0.203200><3.968800,0.035000,0.203200> rotate<0,90.000000,0> translate<25.876300,0.000000,73.025100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.035000,0.000000,5.715000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.035000,0.000000,11.480800>}
box{<0,0,-0.100000><5.765800,0.035000,0.100000> rotate<0,90.000000,0> translate<26.035000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.034900,-1.535000,15.716300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.035000,-1.535000,15.716300>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<26.034900,-1.535000,15.716300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.035000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.035000,0.000000,15.716300>}
box{<0,0,-0.100000><4.235500,0.035000,0.100000> rotate<0,90.000000,0> translate<26.035000,0.000000,15.716300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.035000,0.000000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.035000,0.000000,21.539200>}
box{<0,0,-0.100000><3.543300,0.035000,0.100000> rotate<0,-90.000000,0> translate<26.035000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.241300,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.035000,-1.535000,25.082500>}
box{<0,0,-0.100000><0.793700,0.035000,0.100000> rotate<0,0.000000,0> translate<25.241300,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.923800,0.000000,74.453800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.035000,0.000000,75.565000>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,-44.997030,0> translate<24.923800,0.000000,74.453800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.717500,-1.535000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.193700,-1.535000,25.876300>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,0.000000,0> translate<25.717500,-1.535000,25.876300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.892000,0.000000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.193700,0.000000,60.960000>}
box{<0,0,-0.203200><1.301700,0.035000,0.203200> rotate<0,0.000000,0> translate<24.892000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.717500,-1.535000,42.068800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<26.193800,-1.535000,41.592500>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,44.997030,0> translate<25.717500,-1.535000,42.068800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.130000,0.000000,67.310000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.193800,0.000000,67.310000>}
box{<0,0,-0.203200><2.063800,0.035000,0.203200> rotate<0,0.000000,0> translate<24.130000,0.000000,67.310000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.034900,-1.535000,15.716300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.352500,-1.535000,15.398800>}
box{<0,0,-0.100000><0.449084,0.035000,0.100000> rotate<0,44.988009,0> translate<26.034900,-1.535000,15.716300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.717500,-1.535000,24.288800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.352500,-1.535000,24.288800>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,0.000000,0> translate<25.717500,-1.535000,24.288800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.193700,-1.535000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.352500,-1.535000,25.717500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<26.193700,-1.535000,25.876300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.352500,-1.535000,24.288800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.511200,-1.535000,24.447500>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<26.352500,-1.535000,24.288800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.876300,0.000000,73.025100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.511200,0.000000,73.660000>}
box{<0,0,-0.203200><0.897884,0.035000,0.203200> rotate<0,-44.997030,0> translate<25.876300,0.000000,73.025100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.765000,0.000000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.511300,0.000000,48.736300>}
box{<0,0,-0.203200><1.746300,0.035000,0.203200> rotate<0,0.000000,0> translate<24.765000,0.000000,48.736300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.511300,0.000000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.543000,0.000000,48.768000>}
box{<0,0,-0.203200><0.044831,0.035000,0.203200> rotate<0,-44.997030,0> translate<26.511300,0.000000,48.736300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.400000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.670000,0.000000,2.540000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<25.400000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.035000,0.000000,5.715000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.670000,0.000000,5.080000>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<26.035000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.543000,0.000000,48.768000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.670000,0.000000,48.768000>}
box{<0,0,-0.203200><0.127000,0.035000,0.203200> rotate<0,0.000000,0> translate<26.543000,0.000000,48.768000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.400000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.670000,0.000000,54.610000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<25.400000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.670000,0.000000,50.292000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.670000,0.000000,54.610000>}
box{<0,0,-0.203200><4.318000,0.035000,0.203200> rotate<0,90.000000,0> translate<26.670000,0.000000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.670000,0.000000,50.292000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.670000,0.000000,54.610000>}
box{<0,0,-0.203200><4.318000,0.035000,0.203200> rotate<0,90.000000,0> translate<26.670000,0.000000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.193700,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.670000,-1.535000,61.436200>}
box{<0,0,-0.203200><0.673519,0.035000,0.203200> rotate<0,-44.991015,0> translate<26.193700,-1.535000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.670000,-1.535000,61.436200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.670000,-1.535000,72.072500>}
box{<0,0,-0.203200><10.636300,0.035000,0.203200> rotate<0,90.000000,0> translate<26.670000,-1.535000,72.072500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.035000,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.828700,-1.535000,25.082500>}
box{<0,0,-0.100000><0.793700,0.035000,0.100000> rotate<0,0.000000,0> translate<26.035000,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.828800,0.000000,66.675000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.828800,0.000000,65.087500>}
box{<0,0,-0.203200><1.587500,0.035000,0.203200> rotate<0,-90.000000,0> translate<26.828800,0.000000,65.087500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.193800,0.000000,67.310000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.828800,0.000000,66.675000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<26.193800,0.000000,67.310000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.225100,-1.535000,72.231300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.828800,-1.535000,72.231300>}
box{<0,0,-0.203200><4.603700,0.035000,0.203200> rotate<0,0.000000,0> translate<22.225100,-1.535000,72.231300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.670000,-1.535000,72.072500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.828800,-1.535000,72.231300>}
box{<0,0,-0.203200><0.224577,0.035000,0.203200> rotate<0,-44.997030,0> translate<26.670000,-1.535000,72.072500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<15.081300,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.987500,-1.535000,23.812500>}
box{<0,0,-0.100000><11.906200,0.035000,0.100000> rotate<0,0.000000,0> translate<15.081300,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.828700,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.987500,-1.535000,25.241300>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.997030,0> translate<26.828700,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.717500,0.000000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<26.987500,0.000000,40.640000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,-44.997030,0> translate<25.717500,0.000000,39.370000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.828800,0.000000,72.231300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.987500,0.000000,72.231300>}
box{<0,0,-0.203200><0.158700,0.035000,0.203200> rotate<0,0.000000,0> translate<26.828800,0.000000,72.231300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<19.367500,-1.535000,73.025000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<26.987500,-1.535000,73.025000>}
box{<0,0,-0.100100><7.620000,0.035000,0.100100> rotate<0,0.000000,0> translate<19.367500,-1.535000,73.025000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<26.987500,0.000000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<26.987600,0.000000,42.068800>}
box{<0,0,-0.100100><1.428800,0.035000,0.100100> rotate<0,-89.990051,0> translate<26.987500,0.000000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.987500,0.000000,72.231300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.987600,0.000000,72.231300>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,0.000000,0> translate<26.987500,0.000000,72.231300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.987600,0.000000,72.231300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.987600,0.000000,72.233700>}
box{<0,0,-0.203200><0.002400,0.035000,0.203200> rotate<0,90.000000,0> translate<26.987600,0.000000,72.233700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.987500,0.000000,72.231300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.990000,0.000000,72.228900>}
box{<0,0,-0.203200><0.003466,0.035000,0.203200> rotate<0,43.827968,0> translate<26.987500,0.000000,72.231300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.511200,0.000000,73.660000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.990000,0.000000,73.660000>}
box{<0,0,-0.203200><0.478800,0.035000,0.203200> rotate<0,0.000000,0> translate<26.511200,0.000000,73.660000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.987500,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.146200,-1.535000,23.653800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<26.987500,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.400000,0.000000,58.261200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.146300,0.000000,60.007500>}
box{<0,0,-0.203200><2.469641,0.035000,0.203200> rotate<0,-44.997030,0> translate<25.400000,0.000000,58.261200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.305000,0.000000,6.667500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.305000,0.000000,11.480800>}
box{<0,0,-0.100000><4.813300,0.035000,0.100000> rotate<0,90.000000,0> translate<27.305000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.304900,-1.535000,16.192500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.305000,-1.535000,16.192500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<27.304900,-1.535000,16.192500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.305000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.305000,0.000000,16.192500>}
box{<0,0,-0.100000><4.711700,0.035000,0.100000> rotate<0,90.000000,0> translate<27.305000,0.000000,16.192500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.828800,-1.535000,18.573800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.305000,-1.535000,19.050000>}
box{<0,0,-0.203200><0.673448,0.035000,0.203200> rotate<0,-44.997030,0> translate<26.828800,-1.535000,18.573800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.305000,0.000000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.305000,0.000000,21.539200>}
box{<0,0,-0.100000><2.908300,0.035000,0.100000> rotate<0,-90.000000,0> translate<27.305000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.511200,-1.535000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.305000,-1.535000,24.447500>}
box{<0,0,-0.100000><0.793800,0.035000,0.100000> rotate<0,0.000000,0> translate<26.511200,-1.535000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.304900,-1.535000,16.192500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.622500,-1.535000,15.875000>}
box{<0,0,-0.100000><0.449084,0.035000,0.100000> rotate<0,44.988009,0> translate<27.304900,-1.535000,16.192500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.146200,-1.535000,23.653800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.622500,-1.535000,23.653800>}
box{<0,0,-0.100000><0.476300,0.035000,0.100000> rotate<0,0.000000,0> translate<27.146200,-1.535000,23.653800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.987500,-1.535000,25.241300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.622500,-1.535000,25.241300>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,0.000000,0> translate<26.987500,-1.535000,25.241300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.765000,0.000000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.622600,0.000000,48.736300>}
box{<0,0,-0.203200><2.857600,0.035000,0.203200> rotate<0,0.000000,0> translate<24.765000,0.000000,48.736300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.670000,0.000000,48.768000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.654300,0.000000,48.768000>}
box{<0,0,-0.203200><0.984300,0.035000,0.203200> rotate<0,0.000000,0> translate<26.670000,0.000000,48.768000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.622500,-1.535000,23.653800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.781200,-1.535000,23.812500>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<27.622500,-1.535000,23.653800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.622500,-1.535000,25.241300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.781300,-1.535000,25.082500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<27.622500,-1.535000,25.241300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.781300,-1.535000,43.973800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.781300,-1.535000,41.910000>}
box{<0,0,-0.203200><2.063800,0.035000,0.203200> rotate<0,-90.000000,0> translate<27.781300,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.082700,-1.535000,40.481200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<27.781400,-1.535000,37.782500>}
box{<0,0,-0.100100><3.816538,0.035000,0.100100> rotate<0,44.997030,0> translate<25.082700,-1.535000,40.481200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<26.987600,0.000000,42.068800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<27.781400,0.000000,42.862500>}
box{<0,0,-0.100100><1.122532,0.035000,0.100100> rotate<0,-44.993421,0> translate<26.987600,0.000000,42.068800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.781400,-1.535000,43.973800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.781400,-1.535000,43.180000>}
box{<0,0,-0.203200><0.793800,0.035000,0.203200> rotate<0,-90.000000,0> translate<27.781400,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.717600,-1.535000,43.973800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.781400,-1.535000,43.973800>}
box{<0,0,-0.203200><2.063800,0.035000,0.203200> rotate<0,0.000000,0> translate<25.717600,-1.535000,43.973800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.781300,-1.535000,43.973800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.781400,-1.535000,43.973800>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,0.000000,0> translate<27.781300,-1.535000,43.973800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.305000,0.000000,6.667500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.940000,0.000000,6.032500>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<27.305000,0.000000,6.667500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.940000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.940000,0.000000,6.032500>}
box{<0,0,-0.100000><2.222500,0.035000,0.100000> rotate<0,90.000000,0> translate<27.940000,0.000000,6.032500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<26.670000,-1.535000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<27.940000,-1.535000,55.880000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<26.670000,-1.535000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<27.940000,-1.535000,51.117600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<27.940000,-1.535000,55.880000>}
box{<0,0,-0.100100><4.762400,0.035000,0.100100> rotate<0,90.000000,0> translate<27.940000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.940000,-1.535000,66.040000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.940000,-1.535000,66.833800>}
box{<0,0,-0.100000><0.793800,0.035000,0.100000> rotate<0,90.000000,0> translate<27.940000,-1.535000,66.833800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<27.940000,-1.535000,72.072500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<27.940000,-1.535000,68.580000>}
box{<0,0,-0.100100><3.492500,0.035000,0.100100> rotate<0,-90.000000,0> translate<27.940000,-1.535000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.876300,0.000000,69.056300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.940000,0.000000,71.120000>}
box{<0,0,-0.203200><2.918513,0.035000,0.203200> rotate<0,-44.997030,0> translate<25.876300,0.000000,69.056300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<26.987500,-1.535000,73.025000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<27.940000,-1.535000,72.072500>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,44.997030,0> translate<26.987500,-1.535000,73.025000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.305000,-1.535000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.098700,-1.535000,24.447500>}
box{<0,0,-0.100000><0.793700,0.035000,0.100000> rotate<0,0.000000,0> translate<27.305000,-1.535000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<25.717500,0.000000,34.290000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.098800,0.000000,36.671300>}
box{<0,0,-0.100100><3.367667,0.035000,0.100100> rotate<0,-44.997030,0> translate<25.717500,0.000000,34.290000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.257500,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.257500,-1.535000,18.097600>}
box{<0,0,-0.203200><0.952400,0.035000,0.203200> rotate<0,-90.000000,0> translate<28.257500,-1.535000,18.097600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.305000,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.257500,-1.535000,19.050000>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,0.000000,0> translate<27.305000,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<14.605000,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.257500,-1.535000,23.177500>}
box{<0,0,-0.100000><13.652500,0.035000,0.100000> rotate<0,0.000000,0> translate<14.605000,-1.535000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.098700,-1.535000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.257500,-1.535000,24.606300>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.997030,0> translate<28.098700,-1.535000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<27.940000,-1.535000,66.833800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.257500,-1.535000,67.151300>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<27.940000,-1.535000,66.833800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.257500,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.360000,-1.535000,19.050000>}
box{<0,0,-0.203200><0.102500,0.035000,0.203200> rotate<0,0.000000,0> translate<28.257500,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.257500,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.416200,-1.535000,23.018800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<28.257500,-1.535000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<17.938800,-1.535000,9.842500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.416300,-1.535000,9.842500>}
box{<0,0,-0.100100><10.477500,0.035000,0.100100> rotate<0,0.000000,0> translate<17.938800,-1.535000,9.842500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.780000,-1.535000,10.953800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.416300,-1.535000,10.953800>}
box{<0,0,-0.203200><10.636300,0.035000,0.203200> rotate<0,0.000000,0> translate<17.780000,-1.535000,10.953800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<24.923800,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.416300,-1.535000,38.417500>}
box{<0,0,-0.100100><4.939141,0.035000,0.100100> rotate<0,44.997030,0> translate<24.923800,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.622600,0.000000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.416300,0.000000,49.530000>}
box{<0,0,-0.203200><1.122461,0.035000,0.203200> rotate<0,-44.997030,0> translate<27.622600,0.000000,48.736300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.654300,0.000000,48.768000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.416300,0.000000,49.530000>}
box{<0,0,-0.203200><1.077631,0.035000,0.203200> rotate<0,-44.997030,0> translate<27.654300,0.000000,48.768000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.400000,0.000000,64.770000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.416300,0.000000,61.753800>}
box{<0,0,-0.203200><4.265622,0.035000,0.203200> rotate<0,44.996080,0> translate<25.400000,0.000000,64.770000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.575000,0.000000,5.715000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.575000,0.000000,11.480800>}
box{<0,0,-0.100000><5.765800,0.035000,0.100000> rotate<0,90.000000,0> translate<28.575000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.575000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.575000,0.000000,16.668800>}
box{<0,0,-0.100000><5.188000,0.035000,0.100000> rotate<0,90.000000,0> translate<28.575000,0.000000,16.668800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.828800,0.000000,18.573800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.575000,0.000000,18.573800>}
box{<0,0,-0.203200><1.746200,0.035000,0.203200> rotate<0,0.000000,0> translate<26.828800,0.000000,18.573800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.575000,0.000000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.575000,0.000000,21.539200>}
box{<0,0,-0.100000><2.273300,0.035000,0.100000> rotate<0,-90.000000,0> translate<28.575000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.781200,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.575000,-1.535000,23.812500>}
box{<0,0,-0.100000><0.793800,0.035000,0.100000> rotate<0,0.000000,0> translate<27.781200,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.257500,-1.535000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.733700,-1.535000,24.606300>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,0.000000,0> translate<28.257500,-1.535000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.257500,-1.535000,18.097600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.733800,-1.535000,17.621300>}
box{<0,0,-0.203200><0.673590,0.035000,0.203200> rotate<0,44.997030,0> translate<28.257500,-1.535000,18.097600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.098800,-1.535000,36.671300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.733800,-1.535000,37.306300>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<28.098800,-1.535000,36.671300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.940000,0.000000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.733800,0.000000,68.580000>}
box{<0,0,-0.100000><0.793800,0.035000,0.100000> rotate<0,0.000000,0> translate<27.940000,0.000000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.035000,0.000000,75.565000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.733800,0.000000,75.565000>}
box{<0,0,-0.203200><2.698800,0.035000,0.203200> rotate<0,0.000000,0> translate<26.035000,0.000000,75.565000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<26.193800,-1.535000,41.592500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.733900,-1.535000,39.052500>}
box{<0,0,-0.100100><3.592173,0.035000,0.100100> rotate<0,44.995902,0> translate<26.193800,-1.535000,41.592500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.575000,-1.535000,16.668800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.892500,-1.535000,16.351300>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<28.575000,-1.535000,16.668800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.416200,-1.535000,23.018800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.892500,-1.535000,23.018800>}
box{<0,0,-0.100000><0.476300,0.035000,0.100000> rotate<0,0.000000,0> translate<28.416200,-1.535000,23.018800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.733700,-1.535000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.892500,-1.535000,24.447500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<28.733700,-1.535000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.892500,-1.535000,23.018800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.051200,-1.535000,23.177500>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<28.892500,-1.535000,23.018800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.828800,0.000000,65.087500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.051200,0.000000,62.865100>}
box{<0,0,-0.203200><3.142948,0.035000,0.203200> rotate<0,44.997030,0> translate<26.828800,0.000000,65.087500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.781400,-1.535000,43.973800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.051300,-1.535000,43.973800>}
box{<0,0,-0.203200><1.269900,0.035000,0.203200> rotate<0,0.000000,0> translate<27.781400,-1.535000,43.973800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.701300,-1.535000,32.067500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.107500,-1.535000,32.067500>}
box{<0,0,-0.203200><6.406200,0.035000,0.203200> rotate<0,0.000000,0> translate<22.701300,-1.535000,32.067500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.051300,-1.535000,43.973800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.153800,-1.535000,43.973800>}
box{<0,0,-0.203200><0.102500,0.035000,0.203200> rotate<0,0.000000,0> translate<29.051300,-1.535000,43.973800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.940000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.210000,0.000000,2.540000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<27.940000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.575000,0.000000,5.715000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.210000,0.000000,5.080000>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<28.575000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.210000,-1.535000,9.048800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.210000,-1.535000,6.826300>}
box{<0,0,-0.100100><2.222500,0.035000,0.100100> rotate<0,-90.000000,0> translate<29.210000,-1.535000,6.826300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.416300,-1.535000,9.842500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.210000,-1.535000,9.048800>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,44.997030,0> translate<28.416300,-1.535000,9.842500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.575000,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.210000,-1.535000,23.812500>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,0.000000,0> translate<28.575000,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<22.701300,-1.535000,32.067500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,32.067500>}
box{<0,0,-0.203200><6.508700,0.035000,0.203200> rotate<0,0.000000,0> translate<22.701300,-1.535000,32.067500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.107500,-1.535000,32.067500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,32.170000>}
box{<0,0,-0.203200><0.144957,0.035000,0.203200> rotate<0,-44.997030,0> translate<29.107500,-1.535000,32.067500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,32.067500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,32.170000>}
box{<0,0,-0.203200><0.102500,0.035000,0.203200> rotate<0,90.000000,0> translate<29.210000,-1.535000,32.170000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,33.870000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,33.813800>}
box{<0,0,-0.203200><0.056200,0.035000,0.203200> rotate<0,-90.000000,0> translate<29.210000,-1.535000,33.813800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,35.687000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,33.870000>}
box{<0,0,-0.203200><1.817000,0.035000,0.203200> rotate<0,-90.000000,0> translate<29.210000,-1.535000,33.870000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,36.195000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,35.687000>}
box{<0,0,-0.203200><0.508000,0.035000,0.203200> rotate<0,-90.000000,0> translate<29.210000,0.000000,35.687000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<23.971200,0.000000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,35.718800>}
box{<0,0,-0.203200><7.408782,0.035000,0.203200> rotate<0,-44.997030,0> translate<23.971200,0.000000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,35.718800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,36.195000>}
box{<0,0,-0.203200><0.476200,0.035000,0.203200> rotate<0,90.000000,0> translate<29.210000,0.000000,36.195000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,36.195000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,37.465000>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,90.000000,0> translate<29.210000,0.000000,37.465000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,40.513000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,42.330000>}
box{<0,0,-0.203200><1.817000,0.035000,0.203200> rotate<0,90.000000,0> translate<29.210000,-1.535000,42.330000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,42.330000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,42.386300>}
box{<0,0,-0.203200><0.056300,0.035000,0.203200> rotate<0,90.000000,0> translate<29.210000,-1.535000,42.386300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.051300,-1.535000,43.973800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,43.973800>}
box{<0,0,-0.203200><0.158700,0.035000,0.203200> rotate<0,0.000000,0> translate<29.051300,-1.535000,43.973800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.153800,-1.535000,43.973800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,44.030000>}
box{<0,0,-0.203200><0.079479,0.035000,0.203200> rotate<0,-44.997030,0> translate<29.153800,-1.535000,43.973800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,43.973800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,-1.535000,44.030000>}
box{<0,0,-0.203200><0.056200,0.035000,0.203200> rotate<0,90.000000,0> translate<29.210000,-1.535000,44.030000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.210000,0.000000,68.103800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.210000,0.000000,65.087600>}
box{<0,0,-0.100100><3.016200,0.035000,0.100100> rotate<0,-90.000000,0> translate<29.210000,0.000000,65.087600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.733800,0.000000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.210000,0.000000,68.103800>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,44.997030,0> translate<28.733800,0.000000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.733800,0.000000,75.565000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,76.041200>}
box{<0,0,-0.203200><0.673448,0.035000,0.203200> rotate<0,-44.997030,0> translate<28.733800,0.000000,75.565000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,76.041200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,76.041300>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,90.000000,0> translate<29.210000,0.000000,76.041300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<27.940000,-1.535000,51.117600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.210100,-1.535000,49.847500>}
box{<0,0,-0.100100><1.796193,0.035000,0.100100> rotate<0,44.997030,0> translate<27.940000,-1.535000,51.117600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,40.513000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.337100,0.000000,40.513000>}
box{<0,0,-0.203200><0.127100,0.035000,0.203200> rotate<0,0.000000,0> translate<29.210000,0.000000,40.513000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.368800,0.000000,7.778900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.368800,0.000000,9.525100>}
box{<0,0,-0.100100><1.746200,0.035000,0.100100> rotate<0,90.000000,0> translate<29.368800,0.000000,9.525100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.210000,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.368800,-1.535000,23.971300>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.997030,0> translate<29.210000,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.337100,0.000000,40.513000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.368800,0.000000,40.481300>}
box{<0,0,-0.203200><0.044831,0.035000,0.203200> rotate<0,44.997030,0> translate<29.337100,0.000000,40.513000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.368800,0.000000,40.481300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.400500,0.000000,40.513000>}
box{<0,0,-0.203200><0.044831,0.035000,0.203200> rotate<0,-44.997030,0> translate<29.368800,0.000000,40.481300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.527500,0.000000,17.621300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.527500,0.000000,13.970100>}
box{<0,0,-0.203200><3.651200,0.035000,0.203200> rotate<0,-90.000000,0> translate<29.527500,0.000000,13.970100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.575000,0.000000,18.573800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.527500,0.000000,17.621300>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,44.997030,0> translate<28.575000,0.000000,18.573800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.527500,0.000000,13.970000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.527500,0.000000,17.621300>}
box{<0,0,-0.203200><3.651300,0.035000,0.203200> rotate<0,90.000000,0> translate<29.527500,0.000000,17.621300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.527500,0.000000,48.260000>}
box{<0,0,-0.203200><0.317500,0.035000,0.203200> rotate<0,0.000000,0> translate<29.210000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<27.940000,-1.535000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.527500,-1.535000,70.167500>}
box{<0,0,-0.100100><2.245064,0.035000,0.100100> rotate<0,-44.997030,0> translate<27.940000,-1.535000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<18.573800,-1.535000,20.955000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.686300,-1.535000,20.955000>}
box{<0,0,-0.203200><11.112500,0.035000,0.203200> rotate<0,0.000000,0> translate<18.573800,-1.535000,20.955000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.051200,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.686300,-1.535000,23.177500>}
box{<0,0,-0.100000><0.635100,0.035000,0.100000> rotate<0,0.000000,0> translate<29.051200,-1.535000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.686300,0.000000,30.003700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.686300,0.000000,30.638800>}
box{<0,0,-0.100100><0.635100,0.035000,0.100100> rotate<0,90.000000,0> translate<29.686300,0.000000,30.638800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.210000,-1.535000,54.610000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.686300,-1.535000,54.133700>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,44.997030,0> translate<29.210000,-1.535000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.686300,-1.535000,50.958800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.686300,-1.535000,54.133700>}
box{<0,0,-0.100100><3.174900,0.035000,0.100100> rotate<0,90.000000,0> translate<29.686300,-1.535000,54.133700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.368800,0.000000,9.525100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.845000,0.000000,10.001300>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,-44.997030,0> translate<29.368800,0.000000,9.525100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.845000,0.000000,10.001300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.845000,0.000000,11.480800>}
box{<0,0,-0.100100><1.479500,0.035000,0.100100> rotate<0,90.000000,0> translate<29.845000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.845000,0.000000,23.018800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.845000,0.000000,21.539200>}
box{<0,0,-0.100000><1.479600,0.035000,0.100000> rotate<0,-90.000000,0> translate<29.845000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.686300,0.000000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.845000,0.000000,23.018800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<29.686300,0.000000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.210000,-1.535000,6.826300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.003700,-1.535000,6.032500>}
box{<0,0,-0.100100><1.122532,0.035000,0.100100> rotate<0,45.000639,0> translate<29.210000,-1.535000,6.826300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.368800,-1.535000,23.971300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<30.003700,-1.535000,23.971300>}
box{<0,0,-0.100000><0.634900,0.035000,0.100000> rotate<0,0.000000,0> translate<29.368800,-1.535000,23.971300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.368800,0.000000,7.778900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.003800,0.000000,7.143700>}
box{<0,0,-0.100100><0.898167,0.035000,0.100100> rotate<0,45.006051,0> translate<29.368800,0.000000,7.778900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.003800,-1.535000,64.293800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.003800,-1.535000,61.118700>}
box{<0,0,-0.100100><3.175100,0.035000,0.100100> rotate<0,-90.000000,0> translate<30.003800,-1.535000,61.118700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.210000,0.000000,65.087600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.003800,0.000000,64.293800>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,44.997030,0> translate<29.210000,0.000000,65.087600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<30.003800,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<30.060000,-1.535000,19.050000>}
box{<0,0,-0.203200><0.056200,0.035000,0.203200> rotate<0,0.000000,0> translate<30.003800,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<30.060000,-1.535000,20.581300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<30.060000,-1.535000,19.050000>}
box{<0,0,-0.203200><1.531300,0.035000,0.203200> rotate<0,-90.000000,0> translate<30.060000,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.686300,-1.535000,20.955000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<30.060000,-1.535000,20.581300>}
box{<0,0,-0.203200><0.528492,0.035000,0.203200> rotate<0,44.997030,0> translate<29.686300,-1.535000,20.955000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.541200,-1.535000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<30.162500,-1.535000,3.810000>}
box{<0,0,-0.203200><17.621300,0.035000,0.203200> rotate<0,0.000000,0> translate<12.541200,-1.535000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<30.003700,-1.535000,23.971300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<30.162500,-1.535000,23.812500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<30.003700,-1.535000,23.971300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.495000,-1.535000,30.003800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.162500,-1.535000,30.003800>}
box{<0,0,-0.100100><6.667500,0.035000,0.100100> rotate<0,0.000000,0> translate<23.495000,-1.535000,30.003800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.003800,-1.535000,61.118700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.162500,-1.535000,60.960000>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.997030,0> translate<30.003800,-1.535000,61.118700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.416300,-1.535000,10.953800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<30.321300,-1.535000,9.048800>}
box{<0,0,-0.203200><2.694077,0.035000,0.203200> rotate<0,44.997030,0> translate<28.416300,-1.535000,10.953800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.686300,0.000000,30.638800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.321300,0.000000,31.273800>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<29.686300,0.000000,30.638800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.321300,0.000000,31.273800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.321300,0.000000,35.877600>}
box{<0,0,-0.100100><4.603800,0.035000,0.100100> rotate<0,90.000000,0> translate<30.321300,0.000000,35.877600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.686300,-1.535000,50.958800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.321300,-1.535000,50.323800>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<29.686300,-1.535000,50.958800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.686300,0.000000,30.003700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,0.000000,29.210000>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,44.997030,0> translate<29.686300,0.000000,30.003700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,0.000000,15.398800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,0.000000,29.210000>}
box{<0,0,-0.100100><13.811200,0.035000,0.100100> rotate<0,90.000000,0> translate<30.480000,0.000000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.162500,-1.535000,30.003800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,-1.535000,30.321300>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<30.162500,-1.535000,30.003800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,-1.535000,43.021300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,-1.535000,44.291300>}
box{<0,0,-0.100100><1.270000,0.035000,0.100100> rotate<0,90.000000,0> translate<30.480000,-1.535000,44.291300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.210000,-1.535000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,-1.535000,55.880000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<29.210000,-1.535000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,-1.535000,51.752500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,-1.535000,55.880000>}
box{<0,0,-0.100100><4.127500,0.035000,0.100100> rotate<0,90.000000,0> translate<30.480000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,0.000000,60.642500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,0.000000,56.515000>}
box{<0,0,-0.100100><4.127500,0.035000,0.100100> rotate<0,-90.000000,0> translate<30.480000,0.000000,56.515000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.162500,0.000000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,0.000000,60.642500>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<30.162500,0.000000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.003800,-1.535000,7.143700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.638800,-1.535000,6.508800>}
box{<0,0,-0.100100><0.897955,0.035000,0.100100> rotate<0,44.992519,0> translate<30.003800,-1.535000,7.143700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<27.781400,0.000000,42.862500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.638800,0.000000,42.862500>}
box{<0,0,-0.100100><2.857400,0.035000,0.100100> rotate<0,0.000000,0> translate<27.781400,0.000000,42.862500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,-1.535000,43.021300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.638800,-1.535000,42.862500>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<30.480000,-1.535000,43.021300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<30.638800,0.000000,45.720000>}
box{<0,0,-0.203200><1.428800,0.035000,0.203200> rotate<0,0.000000,0> translate<29.210000,0.000000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,0.000000,30.321300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.797500,0.000000,30.638800>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<30.480000,0.000000,30.321300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.797500,0.000000,30.638800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.797500,0.000000,35.401200>}
box{<0,0,-0.100100><4.762400,0.035000,0.100100> rotate<0,90.000000,0> translate<30.797500,0.000000,35.401200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,-1.535000,44.291300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.956200,-1.535000,44.767500>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,-44.997030,0> translate<30.480000,-1.535000,44.291300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<30.162500,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,4.762500>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,-44.997030,0> translate<30.162500,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,4.762500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,7.461300>}
box{<0,0,-0.203200><2.698800,0.035000,0.203200> rotate<0,90.000000,0> translate<31.115000,0.000000,7.461300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,-1.535000,7.461300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,-1.535000,8.509000>}
box{<0,0,-0.203200><1.047700,0.035000,0.203200> rotate<0,90.000000,0> translate<31.115000,-1.535000,8.509000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<30.321300,0.000000,9.048800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,9.842500>}
box{<0,0,-0.203200><1.122461,0.035000,0.203200> rotate<0,-44.997030,0> translate<30.321300,0.000000,9.048800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,9.842500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,11.480800>}
box{<0,0,-0.203200><1.638300,0.035000,0.203200> rotate<0,90.000000,0> translate<31.115000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.527500,0.000000,13.970000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,12.382500>}
box{<0,0,-0.203200><2.245064,0.035000,0.203200> rotate<0,44.997030,0> translate<29.527500,0.000000,13.970000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,9.842500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,12.382500>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<31.115000,0.000000,12.382500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,12.382500>}
box{<0,0,-0.203200><0.901700,0.035000,0.203200> rotate<0,90.000000,0> translate<31.115000,0.000000,12.382500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.527500,0.000000,13.970100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,12.382600>}
box{<0,0,-0.203200><2.245064,0.035000,0.203200> rotate<0,44.997030,0> translate<29.527500,0.000000,13.970100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,12.382500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,0.000000,12.382600>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,90.000000,0> translate<31.115000,0.000000,12.382600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.115000,0.000000,15.398800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.115000,0.000000,21.539200>}
box{<0,0,-0.100000><6.140400,0.035000,0.100000> rotate<0,90.000000,0> translate<31.115000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,0.000000,56.515000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.115000,0.000000,55.880000>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<30.480000,0.000000,56.515000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.273800,0.000000,28.257400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.273800,0.000000,35.242600>}
box{<0,0,-0.100000><6.985200,0.035000,0.100000> rotate<0,90.000000,0> translate<31.273800,0.000000,35.242600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,37.465000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.432500,0.000000,39.687500>}
box{<0,0,-0.203200><3.143090,0.035000,0.203200> rotate<0,-44.997030,0> translate<29.210000,0.000000,37.465000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,-1.535000,51.752500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.432500,-1.535000,50.800000>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,44.997030,0> translate<30.480000,-1.535000,51.752500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.210000,0.000000,76.041200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.432600,0.000000,78.263800>}
box{<0,0,-0.203200><3.143231,0.035000,0.203200> rotate<0,-44.997030,0> translate<29.210000,0.000000,76.041200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.115000,-1.535000,8.509000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.496000,-1.535000,8.890000>}
box{<0,0,-0.203200><0.538815,0.035000,0.203200> rotate<0,-44.997030,0> translate<31.115000,-1.535000,8.509000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.797500,0.000000,35.401200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.591300,0.000000,36.195000>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,-44.997030,0> translate<30.797500,0.000000,35.401200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.591300,0.000000,36.195000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.591300,0.000000,36.195100>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<31.591300,0.000000,36.195100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.273800,0.000000,28.257400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.750000,0.000000,27.781200>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,44.997030,0> translate<31.273800,0.000000,28.257400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.750000,0.000000,15.398800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.750000,0.000000,27.781200>}
box{<0,0,-0.100000><12.382400,0.035000,0.100000> rotate<0,90.000000,0> translate<31.750000,0.000000,27.781200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.750000,0.000000,28.416300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.750000,0.000000,34.766200>}
box{<0,0,-0.100000><6.349900,0.035000,0.100000> rotate<0,90.000000,0> translate<31.750000,0.000000,34.766200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.890000,0.000000,73.660000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.750000,0.000000,73.660000>}
box{<0,0,-0.100100><2.860000,0.035000,0.100100> rotate<0,0.000000,0> translate<28.890000,0.000000,73.660000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<9.207500,0.000000,1.111300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.750100,0.000000,1.111300>}
box{<0,0,-0.100000><22.542600,0.035000,0.100000> rotate<0,0.000000,0> translate<9.207500,0.000000,1.111300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.416300,0.000000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.750100,0.000000,49.530000>}
box{<0,0,-0.203200><3.333800,0.035000,0.203200> rotate<0,0.000000,0> translate<28.416300,0.000000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.908800,0.000000,6.985000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.908800,0.000000,11.747500>}
box{<0,0,-0.100100><4.762500,0.035000,0.100100> rotate<0,90.000000,0> translate<31.908800,0.000000,11.747500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.781300,0.000000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<32.067500,0.000000,41.910000>}
box{<0,0,-0.203200><4.286200,0.035000,0.203200> rotate<0,0.000000,0> translate<27.781300,0.000000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.908800,0.000000,11.747500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.226300,0.000000,12.065000>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<31.908800,0.000000,11.747500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.480000,0.000000,15.398800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.226300,0.000000,13.652500>}
box{<0,0,-0.100100><2.469641,0.035000,0.100100> rotate<0,44.997030,0> translate<30.480000,0.000000,15.398800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.226300,0.000000,12.065000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.226300,0.000000,13.652500>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,90.000000,0> translate<32.226300,0.000000,13.652500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.750000,0.000000,28.416300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.226300,0.000000,27.940000>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,44.997030,0> translate<31.750000,0.000000,28.416300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.226300,0.000000,15.557500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.226300,0.000000,27.940000>}
box{<0,0,-0.100000><12.382500,0.035000,0.100000> rotate<0,90.000000,0> translate<32.226300,0.000000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.226300,0.000000,28.575000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.226300,0.000000,34.607600>}
box{<0,0,-0.100000><6.032600,0.035000,0.100000> rotate<0,90.000000,0> translate<32.226300,0.000000,34.607600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.956200,-1.535000,44.767500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.226300,-1.535000,44.767500>}
box{<0,0,-0.100100><1.270100,0.035000,0.100100> rotate<0,0.000000,0> translate<30.956200,-1.535000,44.767500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<30.480000,0.000000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.226300,0.000000,70.326300>}
box{<0,0,-0.100000><2.469641,0.035000,0.100000> rotate<0,-44.997030,0> translate<30.480000,0.000000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.750000,0.000000,73.660000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.226300,0.000000,74.136300>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,-44.997030,0> translate<31.750000,0.000000,73.660000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.750000,-1.535000,54.610000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.385000,-1.535000,53.975000>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<31.750000,-1.535000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.385000,-1.535000,51.911300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.385000,-1.535000,53.975000>}
box{<0,0,-0.100100><2.063700,0.035000,0.100100> rotate<0,90.000000,0> translate<32.385000,-1.535000,53.975000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.750100,0.000000,1.111300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.543800,0.000000,1.905000>}
box{<0,0,-0.100000><1.122461,0.035000,0.100000> rotate<0,-44.997030,0> translate<31.750100,0.000000,1.111300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.750100,0.000000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<32.543800,0.000000,48.736300>}
box{<0,0,-0.203200><1.122461,0.035000,0.203200> rotate<0,44.997030,0> translate<31.750100,0.000000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.115000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.543800,0.000000,55.880000>}
box{<0,0,-0.100100><1.428800,0.035000,0.100100> rotate<0,0.000000,0> translate<31.115000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<30.638800,0.000000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<32.658100,0.000000,43.700700>}
box{<0,0,-0.203200><2.855721,0.035000,0.203200> rotate<0,44.997030,0> translate<30.638800,0.000000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.115000,0.000000,15.398800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.702500,0.000000,13.811300>}
box{<0,0,-0.100000><2.245064,0.035000,0.100000> rotate<0,44.997030,0> translate<31.115000,0.000000,15.398800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.702500,0.000000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.702500,0.000000,13.811300>}
box{<0,0,-0.100000><2.381300,0.035000,0.100000> rotate<0,90.000000,0> translate<32.702500,0.000000,13.811300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.226300,0.000000,28.575000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.702500,0.000000,28.098800>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,44.997030,0> translate<32.226300,0.000000,28.575000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.702500,0.000000,16.192500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.702500,0.000000,28.098800>}
box{<0,0,-0.100000><11.906300,0.035000,0.100000> rotate<0,90.000000,0> translate<32.702500,0.000000,28.098800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.702500,0.000000,28.733800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.702500,0.000000,34.290000>}
box{<0,0,-0.100000><5.556200,0.035000,0.100000> rotate<0,90.000000,0> translate<32.702500,0.000000,34.290000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<32.067500,0.000000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<32.702500,0.000000,41.275000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<32.067500,0.000000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<30.162500,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.861300,-1.535000,23.812500>}
box{<0,0,-0.100000><2.698800,0.035000,0.100000> rotate<0,0.000000,0> translate<30.162500,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<26.987600,0.000000,72.231300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<32.861300,0.000000,72.231300>}
box{<0,0,-0.203200><5.873700,0.035000,0.203200> rotate<0,0.000000,0> translate<26.987600,0.000000,72.231300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.702500,-1.535000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.020000,-1.535000,11.112500>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<32.702500,-1.535000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.020000,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.020000,-1.535000,11.112500>}
box{<0,0,-0.100000><2.222500,0.035000,0.100000> rotate<0,90.000000,0> translate<33.020000,-1.535000,11.112500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.861300,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.020000,-1.535000,23.653800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<32.861300,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.892500,-1.535000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.020000,-1.535000,24.447500>}
box{<0,0,-0.100000><4.127500,0.035000,0.100000> rotate<0,0.000000,0> translate<28.892500,-1.535000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.385000,-1.535000,51.911300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.020000,-1.535000,51.276300>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<32.385000,-1.535000,51.911300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.020000,0.000000,55.403800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.020000,0.000000,53.816300>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,-90.000000,0> translate<33.020000,0.000000,53.816300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.543800,0.000000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.020000,0.000000,55.403800>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,44.997030,0> translate<32.543800,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.020000,0.000000,56.832500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.020000,0.000000,60.960000>}
box{<0,0,-0.100100><4.127500,0.035000,0.100100> rotate<0,90.000000,0> translate<33.020000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<30.480000,-1.535000,66.040000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.020000,-1.535000,63.500000>}
box{<0,0,-0.100000><3.592102,0.035000,0.100000> rotate<0,44.997030,0> translate<30.480000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.020000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.020000,-1.535000,63.500000>}
box{<0,0,-0.100100><2.540000,0.035000,0.100100> rotate<0,90.000000,0> translate<33.020000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.020000,-1.535000,65.087600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.020000,-1.535000,66.040000>}
box{<0,0,-0.100000><0.952400,0.035000,0.100000> rotate<0,90.000000,0> translate<33.020000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.702500,0.000000,28.733800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.178800,0.000000,28.257500>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,44.997030,0> translate<32.702500,0.000000,28.733800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.178800,0.000000,16.351200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.178800,0.000000,28.257500>}
box{<0,0,-0.100000><11.906300,0.035000,0.100000> rotate<0,90.000000,0> translate<33.178800,0.000000,28.257500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.178800,0.000000,28.892500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.178800,0.000000,33.972500>}
box{<0,0,-0.100000><5.080000,0.035000,0.100000> rotate<0,90.000000,0> translate<33.178800,0.000000,33.972500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.226300,-1.535000,44.767500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.178800,-1.535000,45.720000>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,-44.997030,0> translate<32.226300,-1.535000,44.767500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.178800,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.178800,-1.535000,46.355000>}
box{<0,0,-0.100100><0.635000,0.035000,0.100100> rotate<0,90.000000,0> translate<33.178800,-1.535000,46.355000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.178800,0.000000,46.355000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.178800,0.000000,47.942500>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,90.000000,0> translate<33.178800,0.000000,47.942500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.750000,-1.535000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.178800,-1.535000,55.721200>}
box{<0,0,-0.100100><2.020628,0.035000,0.100100> rotate<0,44.997030,0> translate<31.750000,-1.535000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.178800,-1.535000,52.387500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.178800,-1.535000,55.721200>}
box{<0,0,-0.100100><3.333700,0.035000,0.100100> rotate<0,90.000000,0> translate<33.178800,-1.535000,55.721200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.781300,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.178900,-1.535000,25.082500>}
box{<0,0,-0.100000><5.397600,0.035000,0.100000> rotate<0,0.000000,0> translate<27.781300,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.020000,-1.535000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.337400,-1.535000,24.130100>}
box{<0,0,-0.100000><0.448871,0.035000,0.100000> rotate<0,44.997030,0> translate<33.020000,-1.535000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.352500,-1.535000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.337500,-1.535000,25.717500>}
box{<0,0,-0.100000><6.985000,0.035000,0.100000> rotate<0,0.000000,0> translate<26.352500,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.527500,0.000000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.337500,0.000000,44.450000>}
box{<0,0,-0.203200><5.388154,0.035000,0.203200> rotate<0,44.997030,0> translate<29.527500,0.000000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.432600,0.000000,78.263800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.337500,0.000000,78.263800>}
box{<0,0,-0.203200><1.904900,0.035000,0.203200> rotate<0,0.000000,0> translate<31.432600,0.000000,78.263800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.321300,0.000000,35.877600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.420000,0.000000,38.976300>}
box{<0,0,-0.100100><4.382224,0.035000,0.100100> rotate<0,-44.997030,0> translate<30.321300,0.000000,35.877600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.273800,0.000000,35.242600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.432700,0.000000,37.401500>}
box{<0,0,-0.100000><3.053146,0.035000,0.100000> rotate<0,-44.997030,0> translate<31.273800,0.000000,35.242600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.226300,0.000000,34.607600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.445400,0.000000,35.826700>}
box{<0,0,-0.100000><1.724068,0.035000,0.100000> rotate<0,-44.997030,0> translate<32.226300,0.000000,34.607600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.702500,0.000000,34.290000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.451800,0.000000,35.039300>}
box{<0,0,-0.100000><1.059670,0.035000,0.100000> rotate<0,-44.997030,0> translate<32.702500,0.000000,34.290000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.178800,0.000000,33.972500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.458200,0.000000,34.251900>}
box{<0,0,-0.100000><0.395131,0.035000,0.100000> rotate<0,-44.997030,0> translate<33.178800,0.000000,33.972500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.241300,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.496300,-1.535000,26.352500>}
box{<0,0,-0.100000><8.255000,0.035000,0.100000> rotate<0,0.000000,0> translate<25.241300,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.178800,-1.535000,52.387500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.496300,-1.535000,52.070000>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<33.178800,-1.535000,52.387500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.750000,0.000000,34.766200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.597900,0.000000,36.614100>}
box{<0,0,-0.100000><2.613325,0.035000,0.100000> rotate<0,-44.997030,0> translate<31.750000,0.000000,34.766200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<31.750000,0.000000,15.398800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655000,0.000000,13.493800>}
box{<0,0,-0.100000><2.694077,0.035000,0.100000> rotate<0,44.997030,0> translate<31.750000,0.000000,15.398800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655000,0.000000,6.032600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655000,0.000000,13.493800>}
box{<0,0,-0.100000><7.461200,0.035000,0.100000> rotate<0,90.000000,0> translate<33.655000,0.000000,13.493800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.178800,0.000000,28.892500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655000,0.000000,28.416300>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,44.997030,0> translate<33.178800,0.000000,28.892500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655000,0.000000,16.510000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655000,0.000000,28.416300>}
box{<0,0,-0.100000><11.906300,0.035000,0.100000> rotate<0,90.000000,0> translate<33.655000,0.000000,28.416300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655000,0.000000,29.051300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655000,0.000000,31.432500>}
box{<0,0,-0.100000><2.381200,0.035000,0.100000> rotate<0,90.000000,0> translate<33.655000,0.000000,31.432500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.591300,0.000000,36.195100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.655000,0.000000,38.258800>}
box{<0,0,-0.100100><2.918513,0.035000,0.100100> rotate<0,-44.997030,0> translate<31.591300,0.000000,36.195100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.178900,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655100,-1.535000,24.606300>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,44.997030,0> translate<33.178900,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.971300,-1.535000,26.987500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655100,-1.535000,26.987400>}
box{<0,0,-0.100000><9.683800,0.035000,0.100000> rotate<0,0.000592,0> translate<23.971300,-1.535000,26.987500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.655000,0.000000,38.258800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.724900,0.000000,38.188900>}
box{<0,0,-0.100100><0.098854,0.035000,0.100100> rotate<0,44.997030,0> translate<33.655000,0.000000,38.258800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.701300,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.813800,-1.535000,27.622500>}
box{<0,0,-0.100000><11.112500,0.035000,0.100000> rotate<0,0.000000,0> translate<22.701300,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.813800,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.813900,-1.535000,27.622500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<33.813800,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.337500,-1.535000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.972400,-1.535000,25.082400>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,45.006053,0> translate<33.337500,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<22.860000,-1.535000,28.098800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.972500,-1.535000,28.098800>}
box{<0,0,-0.100100><11.112500,0.035000,0.100100> rotate<0,0.000000,0> translate<22.860000,-1.535000,28.098800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<31.432500,0.000000,39.687500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.972500,0.000000,39.687500>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<31.432500,0.000000,39.687500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<32.702500,0.000000,41.275000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.972500,0.000000,41.275000>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,0.000000,0> translate<32.702500,0.000000,41.275000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.020000,0.000000,53.816300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.972500,0.000000,52.863800>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,44.997030,0> translate<33.020000,0.000000,53.816300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.020000,0.000000,56.832500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.972500,0.000000,55.880000>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,44.997030,0> translate<33.020000,0.000000,56.832500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.210100,-1.535000,49.847500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.972600,-1.535000,49.847500>}
box{<0,0,-0.100100><4.762500,0.035000,0.100100> rotate<0,0.000000,0> translate<29.210100,-1.535000,49.847500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.972500,0.000000,39.687500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.048700,0.000000,39.763700>}
box{<0,0,-0.203200><0.107763,0.035000,0.203200> rotate<0,-44.997030,0> translate<33.972500,0.000000,39.687500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.972500,0.000000,41.275000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.086800,0.000000,41.275000>}
box{<0,0,-0.203200><0.114300,0.035000,0.203200> rotate<0,0.000000,0> translate<33.972500,0.000000,41.275000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.638800,0.000000,42.862500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.099500,0.000000,42.862500>}
box{<0,0,-0.100100><3.460700,0.035000,0.100100> rotate<0,0.000000,0> translate<30.638800,0.000000,42.862500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.400500,0.000000,40.513000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.099600,0.000000,40.513000>}
box{<0,0,-0.203200><4.699100,0.035000,0.203200> rotate<0,0.000000,0> translate<29.400500,0.000000,40.513000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<32.543800,-1.535000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.131200,-1.535000,48.736300>}
box{<0,0,-0.203200><1.587400,0.035000,0.203200> rotate<0,0.000000,0> translate<32.543800,-1.535000,48.736300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.226300,0.000000,15.557500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.131300,0.000000,13.652500>}
box{<0,0,-0.100000><2.694077,0.035000,0.100000> rotate<0,44.997030,0> translate<32.226300,0.000000,15.557500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.131300,0.000000,7.302500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.131300,0.000000,13.652500>}
box{<0,0,-0.100000><6.350000,0.035000,0.100000> rotate<0,90.000000,0> translate<34.131300,0.000000,13.652500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655000,0.000000,29.051300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.131300,0.000000,28.575000>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,44.997030,0> translate<33.655000,0.000000,29.051300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.131300,0.000000,16.827500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.131300,0.000000,28.575000>}
box{<0,0,-0.100000><11.747500,0.035000,0.100000> rotate<0,90.000000,0> translate<34.131300,0.000000,28.575000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.099600,0.000000,40.513000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.131300,0.000000,40.481300>}
box{<0,0,-0.203200><0.044831,0.035000,0.203200> rotate<0,44.997030,0> translate<34.099600,0.000000,40.513000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.638800,0.000000,42.862500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.131300,0.000000,42.862500>}
box{<0,0,-0.100100><3.492500,0.035000,0.100100> rotate<0,0.000000,0> translate<30.638800,0.000000,42.862500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.337500,0.000000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.131300,0.000000,44.450000>}
box{<0,0,-0.203200><0.793800,0.035000,0.203200> rotate<0,0.000000,0> translate<33.337500,0.000000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<32.543800,-1.535000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.131300,-1.535000,48.736300>}
box{<0,0,-0.203200><1.587500,0.035000,0.203200> rotate<0,0.000000,0> translate<32.543800,-1.535000,48.736300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.321300,-1.535000,50.323800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.131300,-1.535000,50.323800>}
box{<0,0,-0.100100><3.810000,0.035000,0.100100> rotate<0,0.000000,0> translate<30.321300,-1.535000,50.323800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.020000,-1.535000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.131300,-1.535000,69.691300>}
box{<0,0,-0.100000><1.571616,0.035000,0.100000> rotate<0,-44.997030,0> translate<33.020000,-1.535000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.458200,0.000000,34.251900>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.150300,0.000000,34.251900>}
box{<0,0,-0.100000><0.692100,0.035000,0.100000> rotate<0,0.000000,0> translate<33.458200,0.000000,34.251900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.451800,0.000000,35.039300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.150300,0.000000,35.039300>}
box{<0,0,-0.100000><0.698500,0.035000,0.100000> rotate<0,0.000000,0> translate<33.451800,0.000000,35.039300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.445400,0.000000,35.826700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.150300,0.000000,35.826700>}
box{<0,0,-0.100000><0.704900,0.035000,0.100000> rotate<0,0.000000,0> translate<33.445400,0.000000,35.826700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.597900,0.000000,36.614100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.150300,0.000000,36.614100>}
box{<0,0,-0.100000><0.552400,0.035000,0.100000> rotate<0,0.000000,0> translate<33.597900,0.000000,36.614100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.432700,0.000000,37.401500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.150300,0.000000,37.401500>}
box{<0,0,-0.100000><0.717600,0.035000,0.100000> rotate<0,0.000000,0> translate<33.432700,0.000000,37.401500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.724900,0.000000,38.188900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.150300,0.000000,38.188900>}
box{<0,0,-0.100100><0.425400,0.035000,0.100100> rotate<0,0.000000,0> translate<33.724900,0.000000,38.188900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.420000,0.000000,38.976300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.150300,0.000000,38.976300>}
box{<0,0,-0.100100><0.730300,0.035000,0.100100> rotate<0,0.000000,0> translate<33.420000,0.000000,38.976300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.048700,0.000000,39.763700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.150300,0.000000,39.763700>}
box{<0,0,-0.203200><0.101600,0.035000,0.203200> rotate<0,0.000000,0> translate<34.048700,0.000000,39.763700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.131300,0.000000,40.481300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.150300,0.000000,40.500300>}
box{<0,0,-0.203200><0.026870,0.035000,0.203200> rotate<0,-44.997030,0> translate<34.131300,0.000000,40.481300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.150300,0.000000,40.500300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.150300,0.000000,40.551100>}
box{<0,0,-0.203200><0.050800,0.035000,0.203200> rotate<0,90.000000,0> translate<34.150300,0.000000,40.551100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.086800,0.000000,41.275000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.150300,0.000000,41.338500>}
box{<0,0,-0.203200><0.089803,0.035000,0.203200> rotate<0,-44.997030,0> translate<34.086800,0.000000,41.275000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.131300,0.000000,42.862500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.150300,0.000000,42.881500>}
box{<0,0,-0.100100><0.026870,0.035000,0.100100> rotate<0,-44.997030,0> translate<34.131300,0.000000,42.862500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.150300,0.000000,42.913300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.150300,0.000000,42.881500>}
box{<0,0,-0.100100><0.031800,0.035000,0.100100> rotate<0,-90.000000,0> translate<34.150300,0.000000,42.881500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.099500,0.000000,42.862500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.150300,0.000000,42.913300>}
box{<0,0,-0.100100><0.071842,0.035000,0.100100> rotate<0,-44.997030,0> translate<34.099500,0.000000,42.862500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<32.658100,0.000000,43.700700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.150300,0.000000,43.700700>}
box{<0,0,-0.203200><1.492200,0.035000,0.203200> rotate<0,0.000000,0> translate<32.658100,0.000000,43.700700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.131300,0.000000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.150300,0.000000,44.469000>}
box{<0,0,-0.203200><0.026870,0.035000,0.203200> rotate<0,-44.997030,0> translate<34.131300,0.000000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.150300,0.000000,44.469000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.150300,0.000000,44.488100>}
box{<0,0,-0.203200><0.019100,0.035000,0.203200> rotate<0,90.000000,0> translate<34.150300,0.000000,44.488100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.150300,0.000000,33.464500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.182100,0.000000,33.496300>}
box{<0,0,-0.100000><0.044972,0.035000,0.100000> rotate<0,-44.997030,0> translate<34.150300,0.000000,33.464500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.150300,0.000000,42.125900>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.232900,0.000000,42.125900>}
box{<0,0,-0.203200><0.082600,0.035000,0.203200> rotate<0,0.000000,0> translate<34.150300,0.000000,42.125900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.496300,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.290000,-1.535000,25.558800>}
box{<0,0,-0.100000><1.122461,0.035000,0.100000> rotate<0,44.997030,0> translate<33.496300,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.018800,-1.535000,28.575000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,-1.535000,28.575000>}
box{<0,0,-0.100100><11.271200,0.035000,0.100100> rotate<0,0.000000,0> translate<23.018800,-1.535000,28.575000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.232900,0.000000,42.125900>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.290000,0.000000,42.068800>}
box{<0,0,-0.203200><0.080752,0.035000,0.203200> rotate<0,44.997030,0> translate<34.232900,0.000000,42.125900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.432500,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,-1.535000,50.800000>}
box{<0,0,-0.100100><2.857500,0.035000,0.100100> rotate<0,0.000000,0> translate<31.432500,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.496300,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,-1.535000,52.070000>}
box{<0,0,-0.100100><0.793700,0.035000,0.100100> rotate<0,0.000000,0> translate<33.496300,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,-1.535000,52.705100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,-1.535000,54.610000>}
box{<0,0,-0.100100><1.904900,0.035000,0.100100> rotate<0,90.000000,0> translate<34.290000,-1.535000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.020000,-1.535000,65.087600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,-1.535000,63.817600>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<33.020000,-1.535000,65.087600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,-1.535000,63.817600>}
box{<0,0,-0.100100><2.857600,0.035000,0.100100> rotate<0,90.000000,0> translate<34.290000,-1.535000,63.817600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.150300,0.000000,42.125900>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.391700,0.000000,42.125900>}
box{<0,0,-0.203200><0.241400,0.035000,0.203200> rotate<0,0.000000,0> translate<34.150300,0.000000,42.125900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<28.892500,-1.535000,16.351300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.448700,-1.535000,16.351300>}
box{<0,0,-0.100000><5.556200,0.035000,0.100000> rotate<0,0.000000,0> translate<28.892500,-1.535000,16.351300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.972500,-1.535000,28.098800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.448800,-1.535000,27.622500>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,44.997030,0> translate<33.972500,-1.535000,28.098800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,-1.535000,28.575000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.448800,-1.535000,28.416400>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.960929,0> translate<34.290000,-1.535000,28.575000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.448700,0.000000,30.956300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.448800,0.000000,30.321300>}
box{<0,0,-0.203200><0.635000,0.035000,0.203200> rotate<0,89.985038,0> translate<34.448700,0.000000,30.956300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.448800,0.000000,29.051300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.448800,0.000000,30.321300>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,90.000000,0> translate<34.448800,0.000000,30.321300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.290000,0.000000,42.068800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.448800,0.000000,42.068800>}
box{<0,0,-0.203200><0.158800,0.035000,0.203200> rotate<0,0.000000,0> translate<34.290000,0.000000,42.068800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.391700,0.000000,42.125900>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.448800,0.000000,42.068800>}
box{<0,0,-0.203200><0.080752,0.035000,0.203200> rotate<0,44.997030,0> translate<34.391700,0.000000,42.125900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.020000,-1.535000,51.276300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.448800,-1.535000,51.276300>}
box{<0,0,-0.100100><1.428800,0.035000,0.100100> rotate<0,0.000000,0> translate<33.020000,-1.535000,51.276300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.544000,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.544000,-1.535000,8.318600>}
box{<0,0,-0.100100><0.571400,0.035000,0.100100> rotate<0,-90.000000,0> translate<34.544000,-1.535000,8.318600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.702500,0.000000,16.192500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.607500,0.000000,14.287500>}
box{<0,0,-0.100000><2.694077,0.035000,0.100000> rotate<0,44.997030,0> translate<32.702500,0.000000,16.192500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<27.622500,-1.535000,15.875000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.607500,-1.535000,15.875000>}
box{<0,0,-0.100000><6.985000,0.035000,0.100000> rotate<0,0.000000,0> translate<27.622500,-1.535000,15.875000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.733900,-1.535000,39.052500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.607500,-1.535000,39.052500>}
box{<0,0,-0.100100><5.873600,0.035000,0.100100> rotate<0,0.000000,0> translate<28.733900,-1.535000,39.052500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.416300,0.000000,61.753800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.607500,0.000000,61.753800>}
box{<0,0,-0.203200><6.191200,0.035000,0.203200> rotate<0,0.000000,0> translate<28.416300,0.000000,61.753800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.607500,0.000000,76.993800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.607500,0.000000,75.247500>}
box{<0,0,-0.203200><1.746300,0.035000,0.203200> rotate<0,-90.000000,0> translate<34.607500,0.000000,75.247500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.337500,0.000000,78.263800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.607500,0.000000,76.993800>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<33.337500,0.000000,78.263800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655100,-1.535000,26.987400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.607600,-1.535000,26.034900>}
box{<0,0,-0.100000><1.347038,0.035000,0.100000> rotate<0,44.997030,0> translate<33.655100,-1.535000,26.987400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.813800,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.607600,-1.535000,26.828700>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,44.997030,0> translate<33.813800,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.448800,0.000000,29.051300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.686900,0.000000,28.813100>}
box{<0,0,-0.203200><0.336795,0.035000,0.203200> rotate<0,45.009059,0> translate<34.448800,0.000000,29.051300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.686900,0.000000,23.971200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.686900,0.000000,28.813100>}
box{<0,0,-0.203200><4.841900,0.035000,0.203200> rotate<0,90.000000,0> translate<34.686900,0.000000,28.813100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.178800,0.000000,16.351200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.766200,0.000000,14.763800>}
box{<0,0,-0.100000><2.244923,0.035000,0.100000> rotate<0,44.997030,0> translate<33.178800,0.000000,16.351200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<26.352500,-1.535000,15.398800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.766300,-1.535000,15.398800>}
box{<0,0,-0.100000><8.413800,0.035000,0.100000> rotate<0,0.000000,0> translate<26.352500,-1.535000,15.398800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.448800,-1.535000,28.416400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.766400,-1.535000,28.098800>}
box{<0,0,-0.100100><0.449154,0.035000,0.100100> rotate<0,44.997030,0> translate<34.448800,-1.535000,28.416400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.150300,0.000000,45.275500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.893300,0.000000,45.275500>}
box{<0,0,-0.100100><0.743000,0.035000,0.100100> rotate<0,0.000000,0> translate<34.150300,0.000000,45.275500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.448700,-1.535000,16.351300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.924900,-1.535000,16.827500>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,-44.997030,0> translate<34.448700,-1.535000,16.351300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.925000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.925000,0.000000,10.636300>}
box{<0,0,-0.100100><0.844500,0.035000,0.100100> rotate<0,-90.000000,0> translate<34.925000,0.000000,10.636300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<25.082500,-1.535000,14.922500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.925000,-1.535000,14.922500>}
box{<0,0,-0.100000><9.842500,0.035000,0.100000> rotate<0,0.000000,0> translate<25.082500,-1.535000,14.922500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655000,0.000000,16.510000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.925000,0.000000,15.240000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<33.655000,0.000000,16.510000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.925000,0.000000,19.208700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.925000,0.000000,21.539200>}
box{<0,0,-0.203200><2.330500,0.035000,0.203200> rotate<0,90.000000,0> translate<34.925000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<30.060000,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.925100,-1.535000,19.050000>}
box{<0,0,-0.203200><4.865100,0.035000,0.203200> rotate<0,0.000000,0> translate<30.060000,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.925000,0.000000,19.208700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.925100,0.000000,19.050000>}
box{<0,0,-0.203200><0.158700,0.035000,0.203200> rotate<0,89.957960,0> translate<34.925000,0.000000,19.208700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<29.051200,0.000000,62.865100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.925100,0.000000,62.865100>}
box{<0,0,-0.203200><5.873900,0.035000,0.203200> rotate<0,0.000000,0> translate<29.051200,0.000000,62.865100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<23.812500,-1.535000,14.446300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.083800,-1.535000,14.446300>}
box{<0,0,-0.100000><11.271300,0.035000,0.100000> rotate<0,0.000000,0> translate<23.812500,-1.535000,14.446300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.607500,-1.535000,15.875000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.083800,-1.535000,16.351300>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,-44.997030,0> translate<34.607500,-1.535000,15.875000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.182100,0.000000,33.496300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.083800,0.000000,33.496300>}
box{<0,0,-0.100000><0.901700,0.035000,0.100000> rotate<0,0.000000,0> translate<34.182100,0.000000,33.496300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.083800,0.000000,33.496200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.083800,0.000000,33.496300>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,90.000000,0> translate<35.083800,0.000000,33.496300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.972500,0.000000,41.275000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.083800,0.000000,41.275000>}
box{<0,0,-0.203200><1.111300,0.035000,0.203200> rotate<0,0.000000,0> translate<33.972500,0.000000,41.275000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.131300,0.000000,16.827500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242500,0.000000,15.716300>}
box{<0,0,-0.100000><1.571474,0.035000,0.100000> rotate<0,44.997030,0> translate<34.131300,0.000000,16.827500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.766300,-1.535000,15.398800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242500,-1.535000,15.875000>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,-44.997030,0> translate<34.766300,-1.535000,15.398800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242500,0.000000,28.416200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242500,0.000000,32.385000>}
box{<0,0,-0.100000><3.968800,0.035000,0.100000> rotate<0,90.000000,0> translate<35.242500,0.000000,32.385000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655000,0.000000,31.432500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242500,0.000000,33.020000>}
box{<0,0,-0.100000><2.245064,0.035000,0.100000> rotate<0,-44.997030,0> translate<33.655000,0.000000,31.432500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.083800,0.000000,33.496200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242500,0.000000,33.337500>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<35.083800,0.000000,33.496200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242500,0.000000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242500,0.000000,33.337500>}
box{<0,0,-0.100000><0.317500,0.035000,0.100000> rotate<0,90.000000,0> translate<35.242500,0.000000,33.337500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<22.542500,-1.535000,13.970000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242600,-1.535000,13.970000>}
box{<0,0,-0.100000><12.700100,0.035000,0.100000> rotate<0,0.000000,0> translate<22.542500,-1.535000,13.970000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.336300,-1.535000,29.527500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.401200,-1.535000,29.527500>}
box{<0,0,-0.100100><12.064900,0.035000,0.100100> rotate<0,0.000000,0> translate<23.336300,-1.535000,29.527500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<21.272500,-1.535000,13.493800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.401300,-1.535000,13.493800>}
box{<0,0,-0.100000><14.128800,0.035000,0.100000> rotate<0,0.000000,0> translate<21.272500,-1.535000,13.493800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.925000,-1.535000,14.922500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.401300,-1.535000,15.398800>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,-44.997030,0> translate<34.925000,-1.535000,14.922500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.401300,0.000000,44.767500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.401300,0.000000,43.815000>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,-90.000000,0> translate<35.401300,0.000000,43.815000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.893300,0.000000,45.275500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.401300,0.000000,44.767500>}
box{<0,0,-0.100100><0.718420,0.035000,0.100100> rotate<0,44.997030,0> translate<34.893300,0.000000,45.275500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.972500,0.000000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.401300,0.000000,55.880000>}
box{<0,0,-0.100100><1.428800,0.035000,0.100100> rotate<0,0.000000,0> translate<33.972500,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.607500,0.000000,61.753800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.401300,0.000000,60.960000>}
box{<0,0,-0.203200><1.122603,0.035000,0.203200> rotate<0,44.997030,0> translate<34.607500,0.000000,61.753800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.503800,0.000000,71.493700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.503800,0.000000,72.548800>}
box{<0,0,-0.203200><1.055100,0.035000,0.203200> rotate<0,90.000000,0> translate<35.503800,0.000000,72.548800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242500,0.000000,28.416200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.559900,0.000000,28.098800>}
box{<0,0,-0.100000><0.448871,0.035000,0.100000> rotate<0,44.997030,0> translate<35.242500,0.000000,28.416200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.083800,-1.535000,14.446300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.560000,-1.535000,14.922500>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,-44.997030,0> translate<35.083800,-1.535000,14.446300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,0.000000,20.161300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,0.000000,22.860000>}
box{<0,0,-0.100100><2.698700,0.035000,0.100100> rotate<0,90.000000,0> translate<35.560000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.686900,0.000000,23.971200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,0.000000,23.098100>}
box{<0,0,-0.203200><1.234750,0.035000,0.203200> rotate<0,44.997030,0> translate<34.686900,0.000000,23.971200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,0.000000,23.098100>}
box{<0,0,-0.203200><0.238100,0.035000,0.203200> rotate<0,90.000000,0> translate<35.560000,0.000000,23.098100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.401200,-1.535000,29.527500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,-1.535000,29.686300>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,-44.997030,0> translate<35.401200,-1.535000,29.527500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.401300,0.000000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,0.000000,55.721300>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.997030,0> translate<35.401300,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,0.000000,53.816300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,0.000000,55.721300>}
box{<0,0,-0.100100><1.905000,0.035000,0.100100> rotate<0,90.000000,0> translate<35.560000,0.000000,55.721300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,-1.535000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,-1.535000,55.880000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<34.290000,-1.535000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,-1.535000,55.880000>}
box{<0,0,-0.100100><3.810000,0.035000,0.100100> rotate<0,90.000000,0> translate<35.560000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,0.000000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,0.000000,59.690000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<34.290000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,0.000000,56.832500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,0.000000,59.690000>}
box{<0,0,-0.100100><2.857500,0.035000,0.100100> rotate<0,90.000000,0> translate<35.560000,0.000000,59.690000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.925100,0.000000,62.865100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,0.000000,63.500000>}
box{<0,0,-0.203200><0.897884,0.035000,0.203200> rotate<0,-44.997030,0> translate<34.925100,0.000000,62.865100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.503800,0.000000,72.548800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,0.000000,72.492600>}
box{<0,0,-0.203200><0.079479,0.035000,0.203200> rotate<0,44.997030,0> translate<35.503800,0.000000,72.548800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,0.000000,71.437500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,0.000000,72.492600>}
box{<0,0,-0.203200><1.055100,0.035000,0.203200> rotate<0,90.000000,0> translate<35.560000,0.000000,72.492600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,0.000000,71.437500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,0.000000,72.707500>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,90.000000,0> translate<35.560000,0.000000,72.707500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.544000,-1.535000,8.318600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560100,-1.535000,7.302500>}
box{<0,0,-0.100100><1.436982,0.035000,0.100100> rotate<0,44.997030,0> translate<34.544000,-1.535000,8.318600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.607600,-1.535000,26.828700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.560100,-1.535000,26.828700>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,0.000000,0> translate<34.607600,-1.535000,26.828700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.560000,0.000000,25.241300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.560100,0.000000,26.828700>}
box{<0,0,-0.100000><1.587400,0.035000,0.100000> rotate<0,-89.990451,0> translate<35.560000,0.000000,25.241300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.607500,0.000000,75.247500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.718700,0.000000,74.136300>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,44.997030,0> translate<34.607500,0.000000,75.247500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.925000,0.000000,10.636300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.718800,0.000000,9.842500>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,44.997030,0> translate<34.925000,0.000000,10.636300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<28.733800,-1.535000,17.621300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.718800,-1.535000,17.621300>}
box{<0,0,-0.203200><6.985000,0.035000,0.203200> rotate<0,0.000000,0> translate<28.733800,-1.535000,17.621300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.718800,-1.535000,17.621300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.718800,-1.535000,18.097500>}
box{<0,0,-0.203200><0.476200,0.035000,0.203200> rotate<0,90.000000,0> translate<35.718800,-1.535000,18.097500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,0.000000,20.161300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.718800,0.000000,20.002500>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<35.560000,0.000000,20.161300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.718800,0.000000,18.097500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.718800,0.000000,20.002500>}
box{<0,0,-0.203200><1.905000,0.035000,0.203200> rotate<0,90.000000,0> translate<35.718800,0.000000,20.002500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242500,0.000000,32.385000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.718800,0.000000,32.861300>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,-44.997030,0> translate<35.242500,0.000000,32.385000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.448800,0.000000,42.068800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.718800,0.000000,42.068800>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,0.000000,0> translate<34.448800,0.000000,42.068800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242600,-1.535000,13.970000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.718900,-1.535000,14.446300>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,-44.997030,0> translate<35.242600,-1.535000,13.970000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.560100,-1.535000,26.828700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.877300,-1.535000,27.146300>}
box{<0,0,-0.100000><0.448871,0.035000,0.100000> rotate<0,-45.033131,0> translate<35.560100,-1.535000,26.828700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.638800,-1.535000,6.508800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.877500,-1.535000,6.508800>}
box{<0,0,-0.100100><5.238700,0.035000,0.100100> rotate<0,0.000000,0> translate<30.638800,-1.535000,6.508800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.401300,-1.535000,13.493800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.877500,-1.535000,13.970000>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,-44.997030,0> translate<35.401300,-1.535000,13.493800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.877500,0.000000,29.051400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.877500,0.000000,31.591300>}
box{<0,0,-0.100100><2.539900,0.035000,0.100100> rotate<0,90.000000,0> translate<35.877500,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,0.000000,53.816300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.877500,0.000000,53.498800>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<35.560000,0.000000,53.816300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.146300,-1.535000,60.007500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.877500,-1.535000,60.007500>}
box{<0,0,-0.203200><8.731200,0.035000,0.203200> rotate<0,0.000000,0> translate<27.146300,-1.535000,60.007500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<27.940000,0.000000,71.120000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.877500,0.000000,71.120000>}
box{<0,0,-0.203200><7.937500,0.035000,0.203200> rotate<0,0.000000,0> translate<27.940000,0.000000,71.120000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.503800,0.000000,71.493700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.877500,0.000000,71.120000>}
box{<0,0,-0.203200><0.528492,0.035000,0.203200> rotate<0,44.997030,0> translate<35.503800,0.000000,71.493700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,0.000000,71.437500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.877500,0.000000,71.120000>}
box{<0,0,-0.203200><0.449013,0.035000,0.203200> rotate<0,44.997030,0> translate<35.560000,0.000000,71.437500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<23.177500,-1.535000,29.051300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.877700,-1.535000,29.051300>}
box{<0,0,-0.100100><12.700200,0.035000,0.100100> rotate<0,0.000000,0> translate<23.177500,-1.535000,29.051300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.877500,0.000000,31.591300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.985500,0.000000,31.591300>}
box{<0,0,-0.100100><0.108000,0.035000,0.100100> rotate<0,0.000000,0> translate<35.877500,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.985500,0.000000,31.591300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.004500,0.000000,31.610300>}
box{<0,0,-0.100100><0.026870,0.035000,0.100100> rotate<0,-44.997030,0> translate<35.985500,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.004400,0.000000,44.005600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.004500,0.000000,47.129700>}
box{<0,0,-0.100000><3.124100,0.035000,0.100000> rotate<0,-89.992226,0> translate<36.004400,0.000000,44.005600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.004500,0.000000,47.129700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.004500,0.000000,49.498200>}
box{<0,0,-0.100100><2.368500,0.035000,0.100100> rotate<0,90.000000,0> translate<36.004500,0.000000,49.498200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<19.843700,-1.535000,13.017500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.036200,-1.535000,13.017500>}
box{<0,0,-0.100000><16.192500,0.035000,0.100000> rotate<0,0.000000,0> translate<19.843700,-1.535000,13.017500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<30.003700,-1.535000,6.032500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.036300,-1.535000,6.032500>}
box{<0,0,-0.100100><6.032600,0.035000,0.100100> rotate<0,0.000000,0> translate<30.003700,-1.535000,6.032500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.718800,-1.535000,9.842500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.036300,-1.535000,10.160000>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<35.718800,-1.535000,9.842500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.036300,0.000000,25.558800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.036300,0.000000,26.352500>}
box{<0,0,-0.100000><0.793700,0.035000,0.100000> rotate<0,90.000000,0> translate<36.036300,0.000000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.559900,0.000000,28.098800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.036300,0.000000,28.098800>}
box{<0,0,-0.100000><0.476400,0.035000,0.100000> rotate<0,0.000000,0> translate<35.559900,0.000000,28.098800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.877500,0.000000,29.051400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.036300,0.000000,28.892600>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<35.877500,0.000000,29.051400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.877700,-1.535000,29.051300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.036300,-1.535000,28.892600>}
box{<0,0,-0.100100><0.224365,0.035000,0.100100> rotate<0,45.015086,0> translate<35.877700,-1.535000,29.051300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.036300,-1.535000,52.228800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.036300,-1.535000,53.816300>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,90.000000,0> translate<36.036300,-1.535000,53.816300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<21.590000,-1.535000,58.896300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.036300,-1.535000,58.896300>}
box{<0,0,-0.203200><14.446300,0.035000,0.203200> rotate<0,0.000000,0> translate<21.590000,-1.535000,58.896300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.036300,-1.535000,28.892600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.036400,-1.535000,28.892500>}
box{<0,0,-0.100100><0.000141,0.035000,0.100100> rotate<0,44.997030,0> translate<36.036300,-1.535000,28.892600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.195000,0.000000,13.176300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.195000,0.000000,11.480800>}
box{<0,0,-0.100000><1.695500,0.035000,0.100000> rotate<0,-90.000000,0> translate<36.195000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.036200,-1.535000,13.017500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.195000,-1.535000,13.176300>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.997030,0> translate<36.036200,-1.535000,13.017500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.195000,0.000000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.195000,0.000000,21.539200>}
box{<0,0,-0.100000><3.067100,0.035000,0.100000> rotate<0,-90.000000,0> translate<36.195000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.560000,0.000000,25.241300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.195000,0.000000,24.606300>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<35.560000,0.000000,25.241300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,-1.535000,29.686300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.195000,-1.535000,29.686300>}
box{<0,0,-0.100100><0.635000,0.035000,0.100100> rotate<0,0.000000,0> translate<35.560000,-1.535000,29.686300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.195000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.195000,-1.535000,62.865000>}
box{<0,0,-0.203200><0.635000,0.035000,0.203200> rotate<0,-90.000000,0> translate<36.195000,-1.535000,62.865000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.257500,-1.535000,67.151300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.195000,-1.535000,67.151300>}
box{<0,0,-0.100100><7.937500,0.035000,0.100100> rotate<0,0.000000,0> translate<28.257500,-1.535000,67.151300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.131300,-1.535000,69.691300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.195000,-1.535000,69.691300>}
box{<0,0,-0.100100><2.063700,0.035000,0.100100> rotate<0,0.000000,0> translate<34.131300,-1.535000,69.691300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.226300,0.000000,70.326300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.353700,0.000000,70.326300>}
box{<0,0,-0.100100><4.127400,0.035000,0.100100> rotate<0,0.000000,0> translate<32.226300,0.000000,70.326300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.353800,0.000000,11.163300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.353800,0.000000,10.687100>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,-90.000000,0> translate<36.353800,0.000000,10.687100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.195000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.353800,0.000000,11.163300>}
box{<0,0,-0.100000><0.354998,0.035000,0.100000> rotate<0,63.423545,0> translate<36.195000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.036300,0.000000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.353800,0.000000,26.670000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<36.036300,0.000000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.036300,0.000000,28.098800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.353800,0.000000,27.781200>}
box{<0,0,-0.100000><0.449084,0.035000,0.100000> rotate<0,45.006051,0> translate<36.036300,0.000000,28.098800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.353800,0.000000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.353800,0.000000,27.781200>}
box{<0,0,-0.100000><1.111200,0.035000,0.100000> rotate<0,90.000000,0> translate<36.353800,0.000000,27.781200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<29.527500,-1.535000,70.167500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.353800,-1.535000,70.167500>}
box{<0,0,-0.100100><6.826300,0.035000,0.100100> rotate<0,0.000000,0> translate<29.527500,-1.535000,70.167500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.877500,-1.535000,71.120000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.353800,-1.535000,71.120000>}
box{<0,0,-0.203200><0.476300,0.035000,0.203200> rotate<0,0.000000,0> translate<35.877500,-1.535000,71.120000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.512500,0.000000,10.477500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.512500,0.000000,7.778800>}
box{<0,0,-0.100000><2.698700,0.035000,0.100000> rotate<0,-90.000000,0> translate<36.512500,0.000000,7.778800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.353800,0.000000,10.687100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.512500,0.000000,10.477500>}
box{<0,0,-0.100000><0.262903,0.035000,0.100000> rotate<0,52.865090,0> translate<36.353800,0.000000,10.687100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.195000,-1.535000,29.686300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.512500,-1.535000,29.368800>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<36.195000,-1.535000,29.686300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,0.000000,56.832500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.512500,0.000000,55.880000>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,44.997030,0> translate<35.560000,0.000000,56.832500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<32.861300,-1.535000,72.231300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.512500,-1.535000,72.231300>}
box{<0,0,-0.203200><3.651200,0.035000,0.203200> rotate<0,0.000000,0> translate<32.861300,-1.535000,72.231300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.607600,-1.535000,26.034900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.671200,-1.535000,26.034900>}
box{<0,0,-0.100100><2.063600,0.035000,0.100100> rotate<0,0.000000,0> translate<34.607600,-1.535000,26.034900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.972500,0.000000,52.863800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.671200,0.000000,52.863800>}
box{<0,0,-0.100100><2.698700,0.035000,0.100100> rotate<0,0.000000,0> translate<33.972500,0.000000,52.863800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.877500,-1.535000,6.508800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.671300,-1.535000,7.302600>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,-44.997030,0> translate<35.877500,-1.535000,6.508800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.671300,-1.535000,7.302600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.671300,-1.535000,9.048800>}
box{<0,0,-0.100100><1.746200,0.035000,0.100100> rotate<0,90.000000,0> translate<36.671300,-1.535000,9.048800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.195000,-1.535000,69.691300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.671300,-1.535000,69.215000>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,44.997030,0> translate<36.195000,-1.535000,69.691300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.791900,0.000000,47.129700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.791900,0.000000,48.380600>}
box{<0,0,-0.100100><1.250900,0.035000,0.100100> rotate<0,90.000000,0> translate<36.791900,0.000000,48.380600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.791900,0.000000,31.610300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.810900,0.000000,31.591300>}
box{<0,0,-0.100100><0.026870,0.035000,0.100100> rotate<0,44.997030,0> translate<36.791900,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.036300,0.000000,25.558800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.830000,0.000000,24.765000>}
box{<0,0,-0.100000><1.122532,0.035000,0.100000> rotate<0,45.000639,0> translate<36.036300,0.000000,25.558800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.830000,0.000000,17.303800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.830000,0.000000,24.765000>}
box{<0,0,-0.100000><7.461200,0.035000,0.100000> rotate<0,90.000000,0> translate<36.830000,0.000000,24.765000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.810900,0.000000,31.591300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.830000,0.000000,31.591300>}
box{<0,0,-0.100100><0.019100,0.035000,0.100100> rotate<0,0.000000,0> translate<36.810900,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.830000,0.000000,29.051100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.830000,0.000000,31.591300>}
box{<0,0,-0.100100><2.540200,0.035000,0.100100> rotate<0,90.000000,0> translate<36.830000,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.036300,-1.535000,52.228800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.830000,-1.535000,51.435100>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,44.997030,0> translate<36.036300,-1.535000,52.228800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.830000,-1.535000,51.435000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.830000,-1.535000,51.435100>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<36.830000,-1.535000,51.435100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.671200,0.000000,52.863800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.830000,0.000000,52.705000>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<36.671200,0.000000,52.863800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.036300,-1.535000,53.816300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.830000,-1.535000,54.610000>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,-44.997030,0> translate<36.036300,-1.535000,53.816300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,58.102600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,57.150000>}
box{<0,0,-0.203200><0.952600,0.035000,0.203200> rotate<0,-90.000000,0> translate<36.830000,-1.535000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.036300,-1.535000,58.896300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,58.102600>}
box{<0,0,-0.203200><1.122461,0.035000,0.203200> rotate<0,44.997030,0> translate<36.036300,-1.535000,58.896300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.195000,-1.535000,62.865000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,62.230000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<36.195000,-1.535000,62.865000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.195000,-1.535000,67.151300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.830000,-1.535000,66.516300>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<36.195000,-1.535000,67.151300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,76.200000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,76.993700>}
box{<0,0,-0.203200><0.793700,0.035000,0.203200> rotate<0,90.000000,0> translate<36.830000,-1.535000,76.993700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.353700,0.000000,70.326300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.988700,0.000000,69.691300>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<36.353700,0.000000,70.326300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.671200,-1.535000,26.034900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.988800,-1.535000,26.352500>}
box{<0,0,-0.100100><0.449154,0.035000,0.100100> rotate<0,-44.997030,0> translate<36.671200,-1.535000,26.034900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.607500,-1.535000,39.052500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.988800,-1.535000,39.052600>}
box{<0,0,-0.100100><2.381300,0.035000,0.100100> rotate<0,-0.002406,0> translate<34.607500,-1.535000,39.052500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.131200,-1.535000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.988800,-1.535000,45.878800>}
box{<0,0,-0.203200><4.041186,0.035000,0.203200> rotate<0,44.996028,0> translate<34.131200,-1.535000,48.736300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.131300,-1.535000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.988800,-1.535000,45.878800>}
box{<0,0,-0.203200><4.041115,0.035000,0.203200> rotate<0,44.997030,0> translate<34.131300,-1.535000,48.736300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.988800,-1.535000,39.052600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.988900,-1.535000,39.052600>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,0.000000,0> translate<36.988800,-1.535000,39.052600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.877500,-1.535000,13.970000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.147400,-1.535000,13.970000>}
box{<0,0,-0.100000><1.269900,0.035000,0.100000> rotate<0,0.000000,0> translate<35.877500,-1.535000,13.970000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.036300,-1.535000,6.032500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.147500,-1.535000,7.143700>}
box{<0,0,-0.100100><1.571474,0.035000,0.100100> rotate<0,-44.997030,0> translate<36.036300,-1.535000,6.032500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.147500,-1.535000,7.143700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.147500,-1.535000,8.890000>}
box{<0,0,-0.100100><1.746300,0.035000,0.100100> rotate<0,90.000000,0> translate<37.147500,-1.535000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.877300,-1.535000,27.146300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.147500,-1.535000,27.146300>}
box{<0,0,-0.100000><1.270200,0.035000,0.100000> rotate<0,0.000000,0> translate<35.877300,-1.535000,27.146300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.147500,0.000000,71.596300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.147500,0.000000,72.492500>}
box{<0,0,-0.203200><0.896200,0.035000,0.203200> rotate<0,90.000000,0> translate<37.147500,0.000000,72.492500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.147500,0.000000,72.492500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.203800,0.000000,72.548800>}
box{<0,0,-0.203200><0.079620,0.035000,0.203200> rotate<0,-44.997030,0> translate<37.147500,0.000000,72.492500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.988800,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.306100,-1.535000,26.352600>}
box{<0,0,-0.100000><0.317300,0.035000,0.100000> rotate<0,-0.018056,0> translate<36.988800,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.718800,0.000000,42.068800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.306200,0.000000,40.481300>}
box{<0,0,-0.203200><2.244993,0.035000,0.203200> rotate<0,44.998835,0> translate<35.718800,0.000000,42.068800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560100,0.000000,7.302500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.306300,0.000000,5.556300>}
box{<0,0,-0.100100><2.469500,0.035000,0.100100> rotate<0,44.997030,0> translate<35.560100,0.000000,7.302500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.671300,-1.535000,9.048800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.306300,-1.535000,9.683800>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<36.671300,-1.535000,9.048800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.448800,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.306300,-1.535000,27.622500>}
box{<0,0,-0.100100><2.857500,0.035000,0.100100> rotate<0,0.000000,0> translate<34.448800,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.512500,0.000000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.306300,0.000000,55.880000>}
box{<0,0,-0.100100><0.793800,0.035000,0.100100> rotate<0,0.000000,0> translate<36.512500,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.203800,0.000000,72.548800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.306300,0.000000,72.548800>}
box{<0,0,-0.203200><0.102500,0.035000,0.203200> rotate<0,0.000000,0> translate<37.203800,0.000000,72.548800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.147400,-1.535000,13.970000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.464900,-1.535000,13.652500>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<37.147400,-1.535000,13.970000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,0.000000,7.461300>}
box{<0,0,-0.100000><4.019500,0.035000,0.100000> rotate<0,-90.000000,0> translate<37.465000,0.000000,7.461300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.147500,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.465000,-1.535000,9.207500>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<37.147500,-1.535000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,0.000000,13.176300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,0.000000,11.480800>}
box{<0,0,-0.100000><1.695500,0.035000,0.100000> rotate<0,-90.000000,0> translate<37.465000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.464900,-1.535000,13.652500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,-1.535000,13.176300>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,89.982029,0> translate<37.464900,-1.535000,13.652500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,0.000000,21.431300>}
box{<0,0,-0.100000><0.107900,0.035000,0.100000> rotate<0,-90.000000,0> translate<37.465000,0.000000,21.431300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,0.000000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,0.000000,21.539200>}
box{<0,0,-0.100000><4.337100,0.035000,0.100000> rotate<0,-90.000000,0> translate<37.465000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.988800,0.000000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,0.000000,25.876300>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,44.997030,0> translate<36.988800,0.000000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.147500,-1.535000,27.146300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,-1.535000,26.828800>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<37.147500,-1.535000,27.146300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.718800,0.000000,32.861300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,0.000000,32.861300>}
box{<0,0,-0.100000><1.746200,0.035000,0.100000> rotate<0,0.000000,0> translate<35.718800,0.000000,32.861300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,0.000000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.465000,0.000000,63.500000>}
box{<0,0,-0.203200><1.905000,0.035000,0.203200> rotate<0,0.000000,0> translate<35.560000,0.000000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.560000,0.000000,66.040000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,0.000000,64.135000>}
box{<0,0,-0.100000><2.694077,0.035000,0.100000> rotate<0,44.997030,0> translate<35.560000,0.000000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.353800,-1.535000,71.120000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.465000,-1.535000,70.008800>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,44.997030,0> translate<36.353800,-1.535000,71.120000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.579300,0.000000,47.129700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.579300,0.000000,48.374300>}
box{<0,0,-0.100100><1.244600,0.035000,0.100100> rotate<0,90.000000,0> translate<37.579300,0.000000,48.374300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.877500,0.000000,53.498800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.623700,0.000000,53.498800>}
box{<0,0,-0.100100><1.746200,0.035000,0.100100> rotate<0,0.000000,0> translate<35.877500,0.000000,53.498800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.131300,0.000000,7.302500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.623800,0.000000,3.810000>}
box{<0,0,-0.100000><4.939141,0.035000,0.100000> rotate<0,44.997030,0> translate<34.131300,0.000000,7.302500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.306300,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.623800,-1.535000,27.305000>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<37.306300,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.579300,0.000000,31.610300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.623800,0.000000,31.654800>}
box{<0,0,-0.100000><0.062933,0.035000,0.100000> rotate<0,-44.997030,0> translate<37.579300,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.623800,0.000000,32.702500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.623800,0.000000,31.654800>}
box{<0,0,-0.100000><1.047700,0.035000,0.100000> rotate<0,-90.000000,0> translate<37.623800,0.000000,31.654800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,0.000000,32.861300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.623800,0.000000,32.702500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<37.465000,0.000000,32.861300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.416300,-1.535000,38.417500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.623800,-1.535000,38.417500>}
box{<0,0,-0.100100><9.207500,0.035000,0.100100> rotate<0,0.000000,0> translate<28.416300,-1.535000,38.417500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.178800,0.000000,47.942500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.623800,0.000000,52.387500>}
box{<0,0,-0.100100><6.286179,0.035000,0.100100> rotate<0,-44.997030,0> translate<33.178800,0.000000,47.942500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.401300,0.000000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.623800,0.000000,60.960000>}
box{<0,0,-0.203200><2.222500,0.035000,0.203200> rotate<0,0.000000,0> translate<35.401300,0.000000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.830000,0.000000,29.051100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.782400,0.000000,28.098700>}
box{<0,0,-0.100100><1.346897,0.035000,0.100100> rotate<0,44.997030,0> translate<36.830000,0.000000,29.051100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.623700,0.000000,53.498800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.782500,0.000000,53.340000>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<37.623700,0.000000,53.498800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.782500,-1.535000,53.022500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.782500,-1.535000,53.340000>}
box{<0,0,-0.100100><0.317500,0.035000,0.100100> rotate<0,90.000000,0> translate<37.782500,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.782500,-1.535000,65.087500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.782500,-1.535000,64.770000>}
box{<0,0,-0.203200><0.317500,0.035000,0.203200> rotate<0,-90.000000,0> translate<37.782500,-1.535000,64.770000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.195000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.782500,-1.535000,65.087500>}
box{<0,0,-0.203200><2.245064,0.035000,0.203200> rotate<0,-44.997030,0> translate<36.195000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.782500,0.000000,66.675000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.782500,0.000000,65.087500>}
box{<0,0,-0.203200><1.587500,0.035000,0.203200> rotate<0,-90.000000,0> translate<37.782500,0.000000,65.087500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.306300,0.000000,5.556300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.782600,0.000000,5.080000>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,44.997030,0> translate<37.306300,0.000000,5.556300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.718900,-1.535000,14.446300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.941200,-1.535000,14.446300>}
box{<0,0,-0.100000><2.222300,0.035000,0.100000> rotate<0,0.000000,0> translate<35.718900,-1.535000,14.446300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.465000,0.000000,64.135000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.941200,0.000000,64.135000>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,0.000000,0> translate<37.465000,0.000000,64.135000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.465000,-1.535000,70.008800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.941200,-1.535000,70.008800>}
box{<0,0,-0.203200><0.476200,0.035000,0.203200> rotate<0,0.000000,0> translate<37.465000,-1.535000,70.008800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<31.908800,0.000000,6.985000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.941300,0.000000,0.952500>}
box{<0,0,-0.100100><8.531243,0.035000,0.100100> rotate<0,44.997030,0> translate<31.908800,0.000000,6.985000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.830000,0.000000,17.303800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.941300,0.000000,16.192500>}
box{<0,0,-0.100000><1.571616,0.035000,0.100000> rotate<0,44.997030,0> translate<36.830000,0.000000,17.303800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.766400,-1.535000,28.098800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.941300,-1.535000,28.098800>}
box{<0,0,-0.100100><3.174900,0.035000,0.100100> rotate<0,0.000000,0> translate<34.766400,-1.535000,28.098800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.782400,-1.535000,28.098700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.941300,-1.535000,28.098800>}
box{<0,0,-0.100100><0.158900,0.035000,0.100100> rotate<0,-0.036055,0> translate<37.782400,-1.535000,28.098700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.448700,-1.535000,30.956300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.941300,-1.535000,34.448800>}
box{<0,0,-0.203200><4.939212,0.035000,0.203200> rotate<0,-44.996210,0> translate<34.448700,-1.535000,30.956300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.512500,-1.535000,72.231300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.941300,-1.535000,70.802500>}
box{<0,0,-0.203200><2.020628,0.035000,0.203200> rotate<0,44.997030,0> translate<36.512500,-1.535000,72.231300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.147500,0.000000,71.596300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.941300,0.000000,70.802500>}
box{<0,0,-0.203200><1.122603,0.035000,0.203200> rotate<0,44.997030,0> translate<37.147500,0.000000,71.596300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.306300,0.000000,72.548800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.941300,0.000000,73.183800>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,-44.997030,0> translate<37.306300,0.000000,72.548800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<32.543800,-1.535000,1.905000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.100000,-1.535000,1.905000>}
box{<0,0,-0.100000><5.556200,0.035000,0.100000> rotate<0,0.000000,0> translate<32.543800,-1.535000,1.905000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.512500,0.000000,7.778800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.100000,0.000000,6.191300>}
box{<0,0,-0.100000><2.245064,0.035000,0.100000> rotate<0,44.997030,0> translate<36.512500,0.000000,7.778800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.100000,0.000000,17.938800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.100000,0.000000,26.193700>}
box{<0,0,-0.100000><8.254900,0.035000,0.100000> rotate<0,90.000000,0> translate<38.100000,0.000000,26.193700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.465000,0.000000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.100000,0.000000,62.865000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<37.465000,0.000000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.830000,-1.535000,66.516300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.100000,-1.535000,66.516300>}
box{<0,0,-0.100100><1.270000,0.035000,0.100100> rotate<0,0.000000,0> translate<36.830000,-1.535000,66.516300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655000,0.000000,6.032600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.258800,0.000000,1.428800>}
box{<0,0,-0.100000><6.510756,0.035000,0.100000> rotate<0,44.997030,0> translate<33.655000,0.000000,6.032600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,0.000000,7.461300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.258800,0.000000,6.667500>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,44.997030,0> translate<37.465000,0.000000,7.461300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.623800,0.000000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.258800,0.000000,61.595000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,-44.997030,0> translate<37.623800,0.000000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.560000,0.000000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.258800,0.000000,68.580000>}
box{<0,0,-0.100000><2.698800,0.035000,0.100000> rotate<0,0.000000,0> translate<35.560000,0.000000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.718700,0.000000,74.136300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.258800,0.000000,74.136300>}
box{<0,0,-0.203200><2.540100,0.035000,0.203200> rotate<0,0.000000,0> translate<35.718700,0.000000,74.136300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,76.993700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.258800,-1.535000,78.422500>}
box{<0,0,-0.203200><2.020628,0.035000,0.203200> rotate<0,-44.997030,0> translate<36.830000,-1.535000,76.993700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.366700,0.000000,47.129700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.366700,0.000000,48.209200>}
box{<0,0,-0.100100><1.079500,0.035000,0.100100> rotate<0,90.000000,0> translate<38.366700,0.000000,48.209200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.623800,-1.535000,27.305000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.417500,-1.535000,27.305000>}
box{<0,0,-0.100100><0.793700,0.035000,0.100100> rotate<0,0.000000,0> translate<37.623800,-1.535000,27.305000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.366700,0.000000,31.610300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.417500,0.000000,31.559500>}
box{<0,0,-0.100000><0.071842,0.035000,0.100000> rotate<0,44.997030,0> translate<38.366700,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.417500,0.000000,28.575100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.417500,0.000000,31.559500>}
box{<0,0,-0.100000><2.984400,0.035000,0.100000> rotate<0,90.000000,0> translate<38.417500,0.000000,31.559500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.004500,0.000000,49.498200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.417500,0.000000,51.911200>}
box{<0,0,-0.100100><3.412497,0.035000,0.100100> rotate<0,-44.997030,0> translate<36.004500,0.000000,49.498200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.306300,0.000000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.417500,0.000000,54.768800>}
box{<0,0,-0.100100><1.571474,0.035000,0.100100> rotate<0,44.997030,0> translate<37.306300,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.417500,0.000000,54.133800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.417500,0.000000,54.768800>}
box{<0,0,-0.100100><0.635000,0.035000,0.100100> rotate<0,90.000000,0> translate<38.417500,0.000000,54.768800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.671300,-1.535000,69.215000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.417600,-1.535000,67.468800>}
box{<0,0,-0.100100><2.469570,0.035000,0.100100> rotate<0,44.995390,0> translate<36.671300,-1.535000,69.215000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.306100,-1.535000,26.352600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.576200,-1.535000,26.352600>}
box{<0,0,-0.100000><1.270100,0.035000,0.100000> rotate<0,0.000000,0> translate<37.306100,-1.535000,26.352600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.988800,0.000000,45.878800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.576200,0.000000,44.291300>}
box{<0,0,-0.203200><2.244993,0.035000,0.203200> rotate<0,44.998835,0> translate<36.988800,0.000000,45.878800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.465000,-1.535000,26.828800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.576300,-1.535000,26.828800>}
box{<0,0,-0.100000><1.111300,0.035000,0.100000> rotate<0,0.000000,0> translate<37.465000,-1.535000,26.828800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.576300,-1.535000,42.545000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.576300,-1.535000,41.751300>}
box{<0,0,-0.203200><0.793700,0.035000,0.203200> rotate<0,-90.000000,0> translate<38.576300,-1.535000,41.751300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.306200,-1.535000,40.481300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.576300,-1.535000,41.751400>}
box{<0,0,-0.203200><1.796193,0.035000,0.203200> rotate<0,-44.997030,0> translate<37.306200,-1.535000,40.481300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.576300,-1.535000,42.545000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.576300,-1.535000,41.751400>}
box{<0,0,-0.203200><0.793600,0.035000,0.203200> rotate<0,-90.000000,0> translate<38.576300,-1.535000,41.751400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.576200,0.000000,44.291300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.576300,0.000000,42.545000>}
box{<0,0,-0.203200><1.746300,0.035000,0.203200> rotate<0,89.990780,0> translate<38.576200,0.000000,44.291300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.576300,0.000000,44.291300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.576300,0.000000,42.545000>}
box{<0,0,-0.203200><1.746300,0.035000,0.203200> rotate<0,-90.000000,0> translate<38.576300,0.000000,42.545000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.988800,0.000000,45.878800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.576300,0.000000,44.291300>}
box{<0,0,-0.203200><2.245064,0.035000,0.203200> rotate<0,44.997030,0> translate<36.988800,0.000000,45.878800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.417500,0.000000,54.133800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.576300,0.000000,53.975000>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<38.417500,0.000000,54.133800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.576300,-1.535000,53.022500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.576300,-1.535000,53.975000>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,90.000000,0> translate<38.576300,-1.535000,53.975000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,0.000000,7.778800>}
box{<0,0,-0.100000><3.651200,0.035000,0.100000> rotate<0,-90.000000,0> translate<38.735000,0.000000,7.778800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,0.000000,13.176300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,0.000000,11.430000>}
box{<0,0,-0.100000><1.746300,0.035000,0.100000> rotate<0,-90.000000,0> translate<38.735000,0.000000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,0.000000,11.480800>}
box{<0,0,-0.100000><0.050800,0.035000,0.100000> rotate<0,90.000000,0> translate<38.735000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,-1.535000,13.652500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,-1.535000,13.176300>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,-90.000000,0> translate<38.735000,-1.535000,13.176300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.941200,-1.535000,14.446300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,-1.535000,13.652500>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,44.997030,0> translate<37.941200,-1.535000,14.446300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,0.000000,21.431300>}
box{<0,0,-0.100000><0.107900,0.035000,0.100000> rotate<0,-90.000000,0> translate<38.735000,0.000000,21.431300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,0.000000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,0.000000,21.539200>}
box{<0,0,-0.100000><3.860800,0.035000,0.100000> rotate<0,-90.000000,0> translate<38.735000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.417500,-1.535000,27.305000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.735000,-1.535000,27.622500>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<38.417500,-1.535000,27.305000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.941300,-1.535000,34.448800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.735000,-1.535000,34.448800>}
box{<0,0,-0.203200><0.793700,0.035000,0.203200> rotate<0,0.000000,0> translate<37.941300,-1.535000,34.448800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.735000,-1.535000,62.280800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.735000,-1.535000,60.960000>}
box{<0,0,-0.203200><1.320800,0.035000,0.203200> rotate<0,-90.000000,0> translate<38.735000,-1.535000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.735000,-1.535000,63.817500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.735000,-1.535000,62.280800>}
box{<0,0,-0.203200><1.536700,0.035000,0.203200> rotate<0,-90.000000,0> translate<38.735000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.782500,-1.535000,64.770000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.735000,-1.535000,63.817500>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,44.997030,0> translate<37.782500,-1.535000,64.770000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.735000,-1.535000,70.961300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.735000,-1.535000,72.339200>}
box{<0,0,-0.100100><1.377900,0.035000,0.100100> rotate<0,90.000000,0> translate<38.735000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.576200,-1.535000,26.352600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735100,-1.535000,26.352500>}
box{<0,0,-0.100000><0.158900,0.035000,0.100000> rotate<0,0.036055,0> translate<38.576200,-1.535000,26.352600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.036400,-1.535000,28.892500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.735100,-1.535000,28.892500>}
box{<0,0,-0.100100><2.698700,0.035000,0.100100> rotate<0,0.000000,0> translate<36.036400,-1.535000,28.892500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<27.781400,-1.535000,37.782500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.735100,-1.535000,37.782500>}
box{<0,0,-0.100100><10.953700,0.035000,0.100100> rotate<0,0.000000,0> translate<27.781400,-1.535000,37.782500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.290000,-1.535000,25.558800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.893800,-1.535000,25.558700>}
box{<0,0,-0.100000><4.603800,0.035000,0.100000> rotate<0,0.001244,0> translate<34.290000,-1.535000,25.558800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.100000,0.000000,26.193700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.893800,0.000000,26.987500>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,-44.997030,0> translate<38.100000,0.000000,26.193700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.576300,-1.535000,26.828800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.893800,-1.535000,27.146300>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<38.576300,-1.535000,26.828800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.417500,0.000000,28.575100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.893800,0.000000,28.098800>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,44.997030,0> translate<38.417500,0.000000,28.575100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.893800,0.000000,26.987500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.893800,0.000000,28.098800>}
box{<0,0,-0.100000><1.111300,0.035000,0.100000> rotate<0,90.000000,0> translate<38.893800,0.000000,28.098800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<28.733800,-1.535000,37.306300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.893800,-1.535000,37.306300>}
box{<0,0,-0.100100><10.160000,0.035000,0.100100> rotate<0,0.000000,0> translate<28.733800,-1.535000,37.306300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.258800,0.000000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.893800,0.000000,69.215000>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<38.258800,0.000000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.560000,-1.535000,14.922500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.052400,-1.535000,14.922500>}
box{<0,0,-0.100000><3.492400,0.035000,0.100000> rotate<0,0.000000,0> translate<35.560000,-1.535000,14.922500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.401300,-1.535000,15.398800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.052500,-1.535000,15.398800>}
box{<0,0,-0.100000><3.651200,0.035000,0.100000> rotate<0,0.000000,0> translate<35.401300,-1.535000,15.398800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.512500,-1.535000,29.368800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.052500,-1.535000,29.368800>}
box{<0,0,-0.100100><2.540000,0.035000,0.100100> rotate<0,0.000000,0> translate<36.512500,-1.535000,29.368800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735100,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.052600,-1.535000,26.670000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<38.735100,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.735100,-1.535000,28.892500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.052600,-1.535000,28.575000>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<38.735100,-1.535000,28.892500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.154100,0.000000,28.473400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.154100,0.000000,31.610300>}
box{<0,0,-0.100000><3.136900,0.035000,0.100000> rotate<0,90.000000,0> translate<39.154100,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.154100,0.000000,47.129700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.154100,0.000000,48.361600>}
box{<0,0,-0.100100><1.231900,0.035000,0.100100> rotate<0,90.000000,0> translate<39.154100,0.000000,48.361600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,0.000000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.211200,0.000000,25.876200>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,-44.997030,0> translate<38.735000,0.000000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.211200,0.000000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.211200,0.000000,25.876200>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,-90.000000,0> translate<39.211200,0.000000,25.876200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.893800,-1.535000,25.558700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.211200,-1.535000,25.876300>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-45.015075,0> translate<38.893800,-1.535000,25.558700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.100000,-1.535000,1.905000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.211300,-1.535000,3.016300>}
box{<0,0,-0.100000><1.571616,0.035000,0.100000> rotate<0,-44.997030,0> translate<38.100000,-1.535000,1.905000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.211300,-1.535000,3.016300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.211300,-1.535000,6.350000>}
box{<0,0,-0.100000><3.333700,0.035000,0.100000> rotate<0,90.000000,0> translate<39.211300,-1.535000,6.350000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.735000,-1.535000,70.961300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.211300,-1.535000,70.485000>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,44.997030,0> translate<38.735000,-1.535000,70.961300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<33.972600,-1.535000,49.847500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.211400,-1.535000,44.608800>}
box{<0,0,-0.100100><7.408711,0.035000,0.100100> rotate<0,44.996483,0> translate<33.972600,-1.535000,49.847500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.735000,0.000000,7.778800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.370000,0.000000,7.143800>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<38.735000,0.000000,7.778800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.306300,-1.535000,5.556300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.370000,-1.535000,7.620000>}
box{<0,0,-0.100100><2.918513,0.035000,0.100100> rotate<0,-44.997030,0> translate<37.306300,-1.535000,5.556300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.100000,0.000000,17.938800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.370000,0.000000,16.668800>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<38.100000,0.000000,17.938800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.211200,-1.535000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.370000,-1.535000,26.035000>}
box{<0,0,-0.100100><0.224506,0.035000,0.100100> rotate<0,-44.978985,0> translate<39.211200,-1.535000,25.876300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.052500,-1.535000,29.368800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.370000,-1.535000,29.051300>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<39.052500,-1.535000,29.368800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.131300,-1.535000,50.323800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.370000,-1.535000,45.085100>}
box{<0,0,-0.100100><7.408641,0.035000,0.100100> rotate<0,44.997030,0> translate<34.131300,-1.535000,50.323800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.735000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,60.325000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<38.735000,-1.535000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.258800,0.000000,74.136300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,0.000000,75.247500>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,-44.997030,0> translate<38.258800,0.000000,74.136300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,0.000000,75.247500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,0.000000,76.200000>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,90.000000,0> translate<39.370000,0.000000,76.200000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.083800,0.000000,41.275000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370100,0.000000,36.988800>}
box{<0,0,-0.203200><6.061673,0.035000,0.203200> rotate<0,44.996362,0> translate<35.083800,0.000000,41.275000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.718800,0.000000,42.068800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370100,0.000000,38.417500>}
box{<0,0,-0.203200><5.163718,0.035000,0.203200> rotate<0,44.997030,0> translate<35.718800,0.000000,42.068800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,57.943800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370100,-1.535000,58.578800>}
box{<0,0,-0.203200><0.635000,0.035000,0.203200> rotate<0,-89.985038,0> translate<39.370000,-1.535000,57.943800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,60.325000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370100,-1.535000,58.578800>}
box{<0,0,-0.203200><1.746200,0.035000,0.203200> rotate<0,89.990779,0> translate<39.370000,-1.535000,60.325000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.052500,-1.535000,15.398800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.528700,-1.535000,15.398700>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,0.012031,0> translate<39.052500,-1.535000,15.398800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.528700,-1.535000,45.561300>}
box{<0,0,-0.100100><7.408641,0.035000,0.100100> rotate<0,44.997030,0> translate<34.290000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.370000,-1.535000,26.035000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.528800,-1.535000,26.193800>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,-44.997030,0> translate<39.370000,-1.535000,26.035000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.528800,0.000000,53.181300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.528800,0.000000,59.055000>}
box{<0,0,-0.100100><5.873700,0.035000,0.100100> rotate<0,90.000000,0> translate<39.528800,0.000000,59.055000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.782500,0.000000,66.675000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.528800,0.000000,68.421300>}
box{<0,0,-0.203200><2.469641,0.035000,0.203200> rotate<0,-44.997030,0> translate<37.782500,0.000000,66.675000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.941200,-1.535000,70.008800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.528800,-1.535000,68.421300>}
box{<0,0,-0.203200><2.245135,0.035000,0.203200> rotate<0,44.995226,0> translate<37.941200,-1.535000,70.008800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.988900,-1.535000,39.052600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.687500,-1.535000,41.751100>}
box{<0,0,-0.100100><3.816326,0.035000,0.100100> rotate<0,-44.995969,0> translate<36.988900,-1.535000,39.052600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.687400,-1.535000,42.227600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.687500,-1.535000,41.751100>}
box{<0,0,-0.100100><0.476500,0.035000,0.100100> rotate<0,89.982037,0> translate<39.687400,-1.535000,42.227600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.448800,-1.535000,51.276300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.687500,-1.535000,46.037600>}
box{<0,0,-0.100100><7.408641,0.035000,0.100100> rotate<0,44.997030,0> translate<34.448800,-1.535000,51.276300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.687400,-1.535000,42.227600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.687600,-1.535000,42.227500>}
box{<0,0,-0.100100><0.000224,0.035000,0.100100> rotate<0,26.563298,0> translate<39.687400,-1.535000,42.227600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.211300,-1.535000,6.350000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.846300,-1.535000,6.984900>}
box{<0,0,-0.100000><0.897955,0.035000,0.100000> rotate<0,-44.992519,0> translate<39.211300,-1.535000,6.350000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.972400,-1.535000,25.082400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.846300,-1.535000,25.082500>}
box{<0,0,-0.100000><5.873900,0.035000,0.100000> rotate<0,-0.000975,0> translate<33.972400,-1.535000,25.082400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.846300,-1.535000,46.513700>}
box{<0,0,-0.100100><7.857795,0.035000,0.100100> rotate<0,44.997030,0> translate<34.290000,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.846300,0.000000,43.656300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.846300,0.000000,47.034500>}
box{<0,0,-0.100100><3.378200,0.035000,0.100100> rotate<0,90.000000,0> translate<39.846300,0.000000,47.034500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.791900,0.000000,48.380600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.846300,0.000000,51.435000>}
box{<0,0,-0.100100><4.319574,0.035000,0.100100> rotate<0,-44.997030,0> translate<36.791900,0.000000,48.380600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.100000,-1.535000,66.516300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.846300,-1.535000,64.770000>}
box{<0,0,-0.100100><2.469641,0.035000,0.100100> rotate<0,44.997030,0> translate<38.100000,-1.535000,66.516300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.941500,0.000000,28.479800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.941500,0.000000,31.610300>}
box{<0,0,-0.100000><3.130500,0.035000,0.100000> rotate<0,90.000000,0> translate<39.941500,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.846300,0.000000,47.034500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.941500,0.000000,47.129700>}
box{<0,0,-0.100100><0.134633,0.035000,0.100100> rotate<0,-44.997030,0> translate<39.846300,0.000000,47.034500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.941500,0.000000,47.129700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.941500,0.000000,48.514000>}
box{<0,0,-0.100100><1.384300,0.035000,0.100100> rotate<0,90.000000,0> translate<39.941500,0.000000,48.514000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005000,0.000000,8.255000>}
box{<0,0,-0.100000><3.225800,0.035000,0.100000> rotate<0,-90.000000,0> translate<40.005000,0.000000,8.255000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005000,0.000000,13.176300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005000,0.000000,11.480800>}
box{<0,0,-0.100000><1.695500,0.035000,0.100000> rotate<0,-90.000000,0> translate<40.005000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005000,-1.535000,14.287500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005000,-1.535000,13.176300>}
box{<0,0,-0.100000><1.111200,0.035000,0.100000> rotate<0,-90.000000,0> translate<40.005000,-1.535000,13.176300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.052400,-1.535000,14.922500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005000,-1.535000,14.287500>}
box{<0,0,-0.100000><1.144846,0.035000,0.100000> rotate<0,33.685068,0> translate<39.052400,-1.535000,14.922500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005000,0.000000,21.431300>}
box{<0,0,-0.100000><0.107900,0.035000,0.100000> rotate<0,-90.000000,0> translate<40.005000,0.000000,21.431300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005000,0.000000,25.241300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005000,0.000000,21.539200>}
box{<0,0,-0.100000><3.702100,0.035000,0.100000> rotate<0,-90.000000,0> translate<40.005000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.401300,0.000000,43.815000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,0.000000,39.211300>}
box{<0,0,-0.100100><6.510615,0.035000,0.100100> rotate<0,44.997030,0> translate<35.401300,0.000000,43.815000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.623800,-1.535000,38.417500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,40.798700>}
box{<0,0,-0.100100><3.367525,0.035000,0.100100> rotate<0,-44.997030,0> translate<37.623800,-1.535000,38.417500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,40.798700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,41.433800>}
box{<0,0,-0.100100><0.635100,0.035000,0.100100> rotate<0,90.000000,0> translate<40.005000,-1.535000,41.433800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<34.290000,-1.535000,52.705100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,46.990000>}
box{<0,0,-0.100100><8.082301,0.035000,0.100100> rotate<0,44.997531,0> translate<34.290000,-1.535000,52.705100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.579300,0.000000,48.374300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,0.000000,50.800000>}
box{<0,0,-0.100100><3.430458,0.035000,0.100100> rotate<0,-44.997030,0> translate<37.579300,0.000000,48.374300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,60.325000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,62.280800>}
box{<0,0,-0.100100><1.955800,0.035000,0.100100> rotate<0,90.000000,0> translate<40.005000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,69.373800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,72.339200>}
box{<0,0,-0.100100><2.965400,0.035000,0.100100> rotate<0,90.000000,0> translate<40.005000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,72.339200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,72.390000>}
box{<0,0,-0.100100><0.050800,0.035000,0.100100> rotate<0,90.000000,0> translate<40.005000,-1.535000,72.390000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005000,0.000000,25.241300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005100,0.000000,25.241300>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<40.005000,0.000000,25.241300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.735100,-1.535000,37.782500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005100,-1.535000,39.052500>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,-44.997030,0> translate<38.735100,-1.535000,37.782500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005100,-1.535000,39.052500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005100,-1.535000,39.687500>}
box{<0,0,-0.100100><0.635000,0.035000,0.100100> rotate<0,90.000000,0> translate<40.005100,-1.535000,39.687500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.846300,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.163800,-1.535000,25.400000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<39.846300,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005100,0.000000,25.241300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.163800,0.000000,25.400000>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<40.005100,0.000000,25.241300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.211400,-1.535000,44.608800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.163800,-1.535000,44.608800>}
box{<0,0,-0.100100><0.952400,0.035000,0.100100> rotate<0,0.000000,0> translate<39.211400,-1.535000,44.608800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<35.560000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.163800,-1.535000,47.466300>}
box{<0,0,-0.100100><6.510686,0.035000,0.100100> rotate<0,44.996408,0> translate<35.560000,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.528800,0.000000,59.055000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.163800,0.000000,59.690000>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<39.528800,0.000000,59.055000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<36.004400,0.000000,44.005600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.322400,0.000000,39.687500>}
box{<0,0,-0.100000><6.106645,0.035000,0.100000> rotate<0,44.997694,0> translate<36.004400,0.000000,44.005600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.830000,-1.535000,51.435000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.322400,-1.535000,47.942600>}
box{<0,0,-0.100100><4.938999,0.035000,0.100100> rotate<0,44.997030,0> translate<36.830000,-1.535000,51.435000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.370000,-1.535000,45.085100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.322500,-1.535000,45.085100>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,0.000000,0> translate<39.370000,-1.535000,45.085100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.366700,0.000000,48.209200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.322500,0.000000,50.165000>}
box{<0,0,-0.100100><2.765919,0.035000,0.100100> rotate<0,-44.997030,0> translate<38.366700,0.000000,48.209200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.877500,-1.535000,60.007500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<40.322500,-1.535000,55.562500>}
box{<0,0,-0.203200><6.286179,0.035000,0.203200> rotate<0,44.997030,0> translate<35.877500,-1.535000,60.007500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<40.322500,-1.535000,55.562500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<40.322500,-1.535000,55.562600>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,90.000000,0> translate<40.322500,-1.535000,55.562600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.893800,0.000000,69.215000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.322500,0.000000,69.215000>}
box{<0,0,-0.100100><1.428700,0.035000,0.100100> rotate<0,0.000000,0> translate<38.893800,0.000000,69.215000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.528700,-1.535000,15.398700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.322600,-1.535000,15.398700>}
box{<0,0,-0.100000><0.793900,0.035000,0.100000> rotate<0,0.000000,0> translate<39.528700,-1.535000,15.398700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.163800,-1.535000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.481300,-1.535000,25.717500>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<40.163800,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005100,-1.535000,39.687500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481300,-1.535000,40.163700>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,-44.997030,0> translate<40.005100,-1.535000,39.687500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481300,-1.535000,40.163700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481300,-1.535000,41.275000>}
box{<0,0,-0.100100><1.111300,0.035000,0.100100> rotate<0,90.000000,0> translate<40.481300,-1.535000,41.275000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.528700,-1.535000,45.561300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481300,-1.535000,45.561300>}
box{<0,0,-0.100100><0.952600,0.035000,0.100100> rotate<0,0.000000,0> translate<39.528700,-1.535000,45.561300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.154100,0.000000,48.361600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481300,0.000000,49.688800>}
box{<0,0,-0.100100><1.876944,0.035000,0.100100> rotate<0,-44.997030,0> translate<39.154100,0.000000,48.361600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.576300,-1.535000,53.022500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481300,-1.535000,51.117500>}
box{<0,0,-0.100100><2.694077,0.035000,0.100100> rotate<0,44.997030,0> translate<38.576300,-1.535000,53.022500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.623800,0.000000,52.387500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481300,0.000000,52.387500>}
box{<0,0,-0.100100><2.857500,0.035000,0.100100> rotate<0,0.000000,0> translate<37.623800,0.000000,52.387500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.893800,-1.535000,37.306300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481400,-1.535000,38.893800>}
box{<0,0,-0.100100><2.245135,0.035000,0.100100> rotate<0,-44.995226,0> translate<38.893800,-1.535000,37.306300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481400,-1.535000,38.893800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481400,-1.535000,39.528800>}
box{<0,0,-0.100100><0.635000,0.035000,0.100100> rotate<0,90.000000,0> translate<40.481400,-1.535000,39.528800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.417500,0.000000,51.911200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.639900,0.000000,51.911200>}
box{<0,0,-0.100100><2.222400,0.035000,0.100100> rotate<0,0.000000,0> translate<38.417500,0.000000,51.911200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.782600,0.000000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,0.000000,5.080000>}
box{<0,0,-0.100100><2.857400,0.035000,0.100100> rotate<0,0.000000,0> translate<37.782600,0.000000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.005000,0.000000,8.255000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.640000,0.000000,7.620000>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<40.005000,0.000000,8.255000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,41.433800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,-1.535000,42.068800>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<40.005000,-1.535000,41.433800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.846300,-1.535000,43.656300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,-1.535000,42.862600>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,44.997030,0> translate<39.846300,-1.535000,43.656300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,-1.535000,42.068800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,-1.535000,42.862600>}
box{<0,0,-0.100100><0.793800,0.035000,0.100100> rotate<0,90.000000,0> translate<40.640000,-1.535000,42.862600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.687500,-1.535000,46.037600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,-1.535000,46.037600>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,0.000000,0> translate<39.687500,-1.535000,46.037600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.941500,0.000000,48.514000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,0.000000,49.212500>}
box{<0,0,-0.100100><0.987828,0.035000,0.100100> rotate<0,-44.997030,0> translate<39.941500,0.000000,48.514000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,60.325000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,-1.535000,59.690000>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<40.005000,-1.535000,60.325000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.163800,0.000000,59.690000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,0.000000,59.690000>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,0.000000,0> translate<40.163800,0.000000,59.690000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.417600,-1.535000,67.468800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,-1.535000,65.246300>}
box{<0,0,-0.100100><3.143019,0.035000,0.100100> rotate<0,44.998319,0> translate<38.417600,-1.535000,67.468800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.728900,0.000000,28.327400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.728900,0.000000,31.610300>}
box{<0,0,-0.100000><3.282900,0.035000,0.100000> rotate<0,90.000000,0> translate<40.728900,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,0.000000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.728900,0.000000,47.078900>}
box{<0,0,-0.100100><0.125724,0.035000,0.100100> rotate<0,-44.997030,0> translate<40.640000,0.000000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.728900,0.000000,47.078900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.728900,0.000000,47.129700>}
box{<0,0,-0.100100><0.050800,0.035000,0.100100> rotate<0,90.000000,0> translate<40.728900,0.000000,47.129700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.322600,-1.535000,15.398700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.798800,-1.535000,15.398800>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,-0.012031,0> translate<40.322600,-1.535000,15.398700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481400,-1.535000,39.528800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,-1.535000,39.846300>}
box{<0,0,-0.100100><0.448942,0.035000,0.100100> rotate<0,-45.006054,0> translate<40.481400,-1.535000,39.528800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,-1.535000,39.846300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,-1.535000,39.846400>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<40.798800,-1.535000,39.846400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.846300,-1.535000,46.513700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,-1.535000,46.513700>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,0.000000,0> translate<39.846300,-1.535000,46.513700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.728900,0.000000,47.078900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,0.000000,47.148800>}
box{<0,0,-0.100100><0.098854,0.035000,0.100100> rotate<0,-44.997030,0> translate<40.728900,0.000000,47.078900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,0.000000,48.101300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,0.000000,47.148800>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,-90.000000,0> translate<40.798800,0.000000,47.148800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.846300,0.000000,51.435000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,0.000000,51.435000>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,0.000000,0> translate<39.846300,0.000000,51.435000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.353800,-1.535000,70.167500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,-1.535000,65.722500>}
box{<0,0,-0.100100><6.286179,0.035000,0.100100> rotate<0,44.997030,0> translate<36.353800,-1.535000,70.167500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.798800,-1.535000,15.398800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.798900,-1.535000,15.398700>}
box{<0,0,-0.100000><0.000141,0.035000,0.100000> rotate<0,44.997030,0> translate<40.798800,-1.535000,15.398800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.655100,-1.535000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.798900,-1.535000,24.606300>}
box{<0,0,-0.100000><7.143800,0.035000,0.100000> rotate<0,0.000000,0> translate<33.655100,-1.535000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.735000,-1.535000,34.448800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<40.957500,-1.535000,36.671300>}
box{<0,0,-0.203200><3.143090,0.035000,0.203200> rotate<0,-44.997030,0> translate<38.735000,-1.535000,34.448800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<40.957500,-1.535000,38.417500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<40.957500,-1.535000,36.671300>}
box{<0,0,-0.203200><1.746200,0.035000,0.203200> rotate<0,-90.000000,0> translate<40.957500,-1.535000,36.671300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370100,0.000000,38.417500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<40.957500,0.000000,38.417500>}
box{<0,0,-0.203200><1.587400,0.035000,0.203200> rotate<0,0.000000,0> translate<39.370100,0.000000,38.417500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,-1.535000,39.846400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.957500,-1.535000,40.005100>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,-44.997030,0> translate<40.798800,-1.535000,39.846400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.957500,-1.535000,40.005100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.957500,-1.535000,41.116300>}
box{<0,0,-0.100100><1.111200,0.035000,0.100100> rotate<0,90.000000,0> translate<40.957500,-1.535000,41.116300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.163800,-1.535000,44.608800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.957500,-1.535000,43.815000>}
box{<0,0,-0.100100><1.122532,0.035000,0.100100> rotate<0,45.000639,0> translate<40.163800,-1.535000,44.608800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.957500,-1.535000,46.990000>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,0.000000,0> translate<40.005000,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.322500,0.000000,69.215000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.957500,0.000000,68.580000>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<40.322500,0.000000,69.215000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.846300,0.000000,64.770000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.957600,0.000000,64.770000>}
box{<0,0,-0.100100><1.111300,0.035000,0.100100> rotate<0,0.000000,0> translate<39.846300,0.000000,64.770000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.830000,-1.535000,52.705000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.036900,-1.535000,48.498100>}
box{<0,0,-0.100100><5.949455,0.035000,0.100100> rotate<0,44.997030,0> translate<36.830000,-1.535000,52.705000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.925100,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.116200,-1.535000,19.050000>}
box{<0,0,-0.203200><6.191100,0.035000,0.203200> rotate<0,0.000000,0> translate<34.925100,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.957500,-1.535000,41.116300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.116200,-1.535000,41.275000>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,-44.997030,0> translate<40.957500,-1.535000,41.116300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.798900,-1.535000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.116300,-1.535000,24.923800>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,-45.006054,0> translate<40.798900,-1.535000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.116200,-1.535000,41.275000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.116300,-1.535000,41.274900>}
box{<0,0,-0.100100><0.000141,0.035000,0.100100> rotate<0,44.997030,0> translate<41.116200,-1.535000,41.275000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.116300,-1.535000,41.274900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.116300,-1.535000,41.275000>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<41.116300,-1.535000,41.275000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.322500,-1.535000,45.085100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.116300,-1.535000,44.291300>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,44.997030,0> translate<40.322500,-1.535000,45.085100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.163800,-1.535000,47.466300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.116300,-1.535000,47.466300>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,0.000000,0> translate<40.163800,-1.535000,47.466300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.528800,-1.535000,53.181300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.116300,-1.535000,51.593800>}
box{<0,0,-0.100100><2.245064,0.035000,0.100100> rotate<0,44.997030,0> translate<39.528800,-1.535000,53.181300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,0.000000,48.101300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.195700,0.000000,48.498100>}
box{<0,0,-0.100100><0.561231,0.035000,0.100100> rotate<0,-44.989812,0> translate<40.798800,0.000000,48.101300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,0.000000,11.271300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,0.000000,8.572600>}
box{<0,0,-0.100000><2.698700,0.035000,0.100000> rotate<0,-90.000000,0> translate<41.275000,0.000000,8.572600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,0.000000,13.176300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,0.000000,11.271300>}
box{<0,0,-0.100000><1.905000,0.035000,0.100000> rotate<0,-90.000000,0> translate<41.275000,0.000000,11.271300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,0.000000,11.271300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,0.000000,11.480800>}
box{<0,0,-0.100000><0.209500,0.035000,0.100000> rotate<0,90.000000,0> translate<41.275000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,-1.535000,14.922500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,-1.535000,13.176300>}
box{<0,0,-0.100000><1.746200,0.035000,0.100000> rotate<0,-90.000000,0> translate<41.275000,-1.535000,13.176300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.798900,-1.535000,15.398700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,-1.535000,14.922500>}
box{<0,0,-0.100000><0.673378,0.035000,0.100000> rotate<0,45.003046,0> translate<40.798900,-1.535000,15.398700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,0.000000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,0.000000,21.431300>}
box{<0,0,-0.100000><0.107900,0.035000,0.100000> rotate<0,-90.000000,0> translate<41.275000,0.000000,21.431300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,0.000000,24.765100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,0.000000,21.539200>}
box{<0,0,-0.100000><3.225900,0.035000,0.100000> rotate<0,-90.000000,0> translate<41.275000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.116300,0.000000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,0.000000,24.765100>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<41.116300,0.000000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.322400,-1.535000,47.942600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275000,-1.535000,47.942600>}
box{<0,0,-0.100100><0.952600,0.035000,0.100100> rotate<0,0.000000,0> translate<40.322400,-1.535000,47.942600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,0.000000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275000,0.000000,50.800000>}
box{<0,0,-0.100100><1.270000,0.035000,0.100100> rotate<0,0.000000,0> translate<40.005000,0.000000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.275000,-1.535000,52.705000>}
box{<0,0,-0.203200><6.286179,0.035000,0.203200> rotate<0,44.997030,0> translate<36.830000,-1.535000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275000,-1.535000,62.280800>}
box{<0,0,-0.100100><1.219200,0.035000,0.100100> rotate<0,-90.000000,0> translate<41.275000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275000,-1.535000,69.532500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275000,-1.535000,72.339200>}
box{<0,0,-0.100100><2.806700,0.035000,0.100100> rotate<0,90.000000,0> translate<41.275000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275000,-1.535000,72.339200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275000,-1.535000,72.390000>}
box{<0,0,-0.100100><0.050800,0.035000,0.100100> rotate<0,90.000000,0> translate<41.275000,-1.535000,72.390000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481300,-1.535000,41.275000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275100,-1.535000,42.068800>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,-44.997030,0> translate<40.481300,-1.535000,41.275000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481300,-1.535000,45.561300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275100,-1.535000,44.767500>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,44.997030,0> translate<40.481300,-1.535000,45.561300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.275000,-1.535000,52.705000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.275100,-1.535000,52.705000>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,0.000000,0> translate<41.275000,-1.535000,52.705000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,-1.535000,65.246300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.433700,-1.535000,65.246300>}
box{<0,0,-0.100100><0.793700,0.035000,0.100100> rotate<0,0.000000,0> translate<40.640000,-1.535000,65.246300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.370000,-1.535000,29.051300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.433800,-1.535000,29.051300>}
box{<0,0,-0.100100><2.063800,0.035000,0.100100> rotate<0,0.000000,0> translate<39.370000,-1.535000,29.051300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,-1.535000,46.037600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.433800,-1.535000,45.243800>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,44.997030,0> translate<40.640000,-1.535000,46.037600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.275100,-1.535000,52.705000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.433800,-1.535000,52.546300>}
box{<0,0,-0.203200><0.224436,0.035000,0.203200> rotate<0,44.997030,0> translate<41.275100,-1.535000,52.705000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.516300,0.000000,28.175000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.516300,0.000000,31.610300>}
box{<0,0,-0.100000><3.435300,0.035000,0.100000> rotate<0,90.000000,0> translate<41.516300,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.516300,0.000000,47.129700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.573400,0.000000,47.129700>}
box{<0,0,-0.100100><0.057100,0.035000,0.100100> rotate<0,0.000000,0> translate<41.516300,0.000000,47.129700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.687600,0.000000,42.227500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,0.000000,44.132500>}
box{<0,0,-0.100100><2.694006,0.035000,0.100100> rotate<0,-44.998534,0> translate<39.687600,0.000000,42.227500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,-1.535000,46.513700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,-1.535000,45.720000>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,44.997030,0> translate<40.798800,-1.535000,46.513700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.573400,0.000000,47.129700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,0.000000,47.148800>}
box{<0,0,-0.100100><0.027011,0.035000,0.100100> rotate<0,-44.997030,0> translate<41.573400,0.000000,47.129700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,0.000000,44.132500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,0.000000,47.148800>}
box{<0,0,-0.100100><3.016300,0.035000,0.100100> rotate<0,90.000000,0> translate<41.592500,0.000000,47.148800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.782500,-1.535000,53.022500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,-1.535000,49.212500>}
box{<0,0,-0.100100><5.388154,0.035000,0.100100> rotate<0,44.997030,0> translate<37.782500,-1.535000,53.022500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.322500,0.000000,50.165000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,0.000000,50.165000>}
box{<0,0,-0.100100><1.270000,0.035000,0.100100> rotate<0,0.000000,0> translate<40.322500,0.000000,50.165000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481300,0.000000,52.387500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,0.000000,53.498700>}
box{<0,0,-0.100100><1.571474,0.035000,0.100100> rotate<0,-44.997030,0> translate<40.481300,0.000000,52.387500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,57.943800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.592500,-1.535000,55.721300>}
box{<0,0,-0.203200><3.143090,0.035000,0.203200> rotate<0,44.997030,0> translate<39.370000,-1.535000,57.943800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,0.000000,53.498700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,0.000000,57.943800>}
box{<0,0,-0.100100><4.445100,0.035000,0.100100> rotate<0,90.000000,0> translate<41.592500,0.000000,57.943800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.036900,-1.535000,48.498100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.671900,-1.535000,48.498100>}
box{<0,0,-0.100100><0.635000,0.035000,0.100100> rotate<0,0.000000,0> translate<41.036900,-1.535000,48.498100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.195700,0.000000,48.498100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.671900,0.000000,48.498100>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,0.000000,0> translate<41.195700,0.000000,48.498100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275100,-1.535000,42.068800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.751200,-1.535000,42.545000>}
box{<0,0,-0.100100><0.673378,0.035000,0.100100> rotate<0,-45.003046,0> translate<41.275100,-1.535000,42.068800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.275000,0.000000,8.572600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.751300,0.000000,8.096300>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,44.997030,0> translate<41.275000,0.000000,8.572600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.116300,-1.535000,41.274900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.751300,-1.535000,41.910000>}
box{<0,0,-0.100100><0.898096,0.035000,0.100100> rotate<0,-45.001541,0> translate<41.116300,-1.535000,41.274900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.957500,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.751300,-1.535000,46.196300>}
box{<0,0,-0.100100><1.122532,0.035000,0.100100> rotate<0,44.993421,0> translate<40.957500,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.957600,0.000000,64.770000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.751300,0.000000,63.976300>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,44.997030,0> translate<40.957600,0.000000,64.770000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.751300,-1.535000,63.976300>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,-44.997030,0> translate<41.275000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.116300,-1.535000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.909900,-1.535000,24.923800>}
box{<0,0,-0.100000><0.793600,0.035000,0.100000> rotate<0,0.000000,0> translate<41.116300,-1.535000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.623800,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.910000,0.000000,3.810000>}
box{<0,0,-0.100000><4.286200,0.035000,0.100000> rotate<0,0.000000,0> translate<37.623800,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.154100,0.000000,28.473400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.910000,0.000000,25.717500>}
box{<0,0,-0.100000><3.897431,0.035000,0.100000> rotate<0,44.997030,0> translate<39.154100,0.000000,28.473400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.910000,0.000000,18.097500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.910000,0.000000,25.717500>}
box{<0,0,-0.100000><7.620000,0.035000,0.100000> rotate<0,90.000000,0> translate<41.910000,0.000000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.751300,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910000,-1.535000,42.068800>}
box{<0,0,-0.100100><0.224506,0.035000,0.100100> rotate<0,-45.015075,0> translate<41.751300,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.116300,-1.535000,47.466300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910000,-1.535000,46.672500>}
box{<0,0,-0.100100><1.122532,0.035000,0.100100> rotate<0,45.000639,0> translate<41.116300,-1.535000,47.466300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910000,-1.535000,57.308800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910000,-1.535000,57.626300>}
box{<0,0,-0.100100><0.317500,0.035000,0.100100> rotate<0,90.000000,0> translate<41.910000,-1.535000,57.626300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.941200,0.000000,64.135000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910000,0.000000,68.103800>}
box{<0,0,-0.100100><5.612731,0.035000,0.100100> rotate<0,-44.997030,0> translate<37.941200,0.000000,64.135000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.433800,-1.535000,29.051300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910100,-1.535000,29.527500>}
box{<0,0,-0.100100><0.673519,0.035000,0.100100> rotate<0,-44.991015,0> translate<41.433800,-1.535000,29.051300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910100,-1.535000,29.527500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910100,-1.535000,40.957500>}
box{<0,0,-0.100100><11.430000,0.035000,0.100100> rotate<0,90.000000,0> translate<41.910100,-1.535000,40.957500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.258800,0.000000,1.428800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.068800,0.000000,1.428800>}
box{<0,0,-0.100000><3.810000,0.035000,0.100000> rotate<0,0.000000,0> translate<38.258800,0.000000,1.428800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910100,0.000000,40.957500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.068800,0.000000,41.116300>}
box{<0,0,-0.100100><0.224506,0.035000,0.100100> rotate<0,-45.015075,0> translate<41.910100,0.000000,40.957500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.068800,0.000000,41.116300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.068800,0.000000,44.132700>}
box{<0,0,-0.100100><3.016400,0.035000,0.100100> rotate<0,90.000000,0> translate<42.068800,0.000000,44.132700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275000,-1.535000,47.942600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.068800,-1.535000,47.148800>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,44.997030,0> translate<41.275000,-1.535000,47.942600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481300,0.000000,49.688800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.068800,0.000000,49.688800>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,0.000000,0> translate<40.481300,0.000000,49.688800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.639900,0.000000,51.911200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.068800,0.000000,53.340000>}
box{<0,0,-0.100100><2.020699,0.035000,0.100100> rotate<0,-44.995025,0> translate<40.639900,0.000000,51.911200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.068800,0.000000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.068800,0.000000,57.626200>}
box{<0,0,-0.100100><4.286200,0.035000,0.100100> rotate<0,90.000000,0> translate<42.068800,0.000000,57.626200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242500,-1.535000,15.875000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.227500,-1.535000,15.875000>}
box{<0,0,-0.100000><6.985000,0.035000,0.100000> rotate<0,0.000000,0> translate<35.242500,-1.535000,15.875000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.909900,-1.535000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.227500,-1.535000,25.241300>}
box{<0,0,-0.100000><0.449084,0.035000,0.100000> rotate<0,-44.988009,0> translate<41.909900,-1.535000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.640000,0.000000,49.212500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.227500,0.000000,49.212500>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,0.000000,0> translate<40.640000,0.000000,49.212500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.718800,-1.535000,17.621300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<42.227600,-1.535000,17.621300>}
box{<0,0,-0.203200><6.508800,0.035000,0.203200> rotate<0,0.000000,0> translate<35.718800,-1.535000,17.621300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.303700,0.000000,28.022600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.303700,0.000000,31.610300>}
box{<0,0,-0.100000><3.587700,0.035000,0.100000> rotate<0,90.000000,0> translate<42.303700,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.303700,0.000000,47.129700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.303700,0.000000,48.177500>}
box{<0,0,-0.100100><1.047800,0.035000,0.100100> rotate<0,90.000000,0> translate<42.303700,0.000000,48.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.751200,-1.535000,42.545000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.386300,-1.535000,42.545000>}
box{<0,0,-0.100100><0.635100,0.035000,0.100100> rotate<0,0.000000,0> translate<41.751200,-1.535000,42.545000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910000,-1.535000,57.308800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.386300,-1.535000,56.832500>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,44.997030,0> translate<41.910000,-1.535000,57.308800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.211300,0.000000,70.485000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.386300,0.000000,70.485000>}
box{<0,0,-0.100100><3.175000,0.035000,0.100100> rotate<0,0.000000,0> translate<39.211300,0.000000,70.485000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<32.226300,-1.535000,74.136300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.386300,-1.535000,74.136300>}
box{<0,0,-0.100100><10.160000,0.035000,0.100100> rotate<0,0.000000,0> translate<32.226300,-1.535000,74.136300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.337400,-1.535000,24.130100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.386400,-1.535000,24.130000>}
box{<0,0,-0.100000><9.049000,0.035000,0.100000> rotate<0,0.000633,0> translate<33.337400,-1.535000,24.130100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910000,-1.535000,42.068800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.544900,-1.535000,42.068800>}
box{<0,0,-0.100100><0.634900,0.035000,0.100100> rotate<0,0.000000,0> translate<41.910000,-1.535000,42.068800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.640000,-1.535000,2.540000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,-1.535000,0.635000>}
box{<0,0,-0.100000><2.694077,0.035000,0.100000> rotate<0,44.997030,0> translate<40.640000,-1.535000,2.540000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,0.000000,9.207500>}
box{<0,0,-0.100000><2.222500,0.035000,0.100000> rotate<0,-90.000000,0> translate<42.545000,0.000000,9.207500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,0.000000,13.176300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,0.000000,11.430000>}
box{<0,0,-0.100000><1.746300,0.035000,0.100000> rotate<0,-90.000000,0> translate<42.545000,0.000000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,0.000000,11.480800>}
box{<0,0,-0.100000><0.050800,0.035000,0.100000> rotate<0,90.000000,0> translate<42.545000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,-1.535000,15.557500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,-1.535000,13.176300>}
box{<0,0,-0.100000><2.381200,0.035000,0.100000> rotate<0,-90.000000,0> translate<42.545000,-1.535000,13.176300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.227500,-1.535000,15.875000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,-1.535000,15.557500>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<42.227500,-1.535000,15.875000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,0.000000,24.288800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,0.000000,21.539200>}
box{<0,0,-0.100000><2.749600,0.035000,0.100000> rotate<0,-90.000000,0> translate<42.545000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,0.000000,51.435000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,0.000000,53.181300>}
box{<0,0,-0.100100><2.469570,0.035000,0.100100> rotate<0,-44.998671,0> translate<40.798800,0.000000,51.435000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<40.322500,-1.535000,55.562600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<42.545000,-1.535000,53.340100>}
box{<0,0,-0.203200><3.143090,0.035000,0.203200> rotate<0,44.997030,0> translate<40.322500,-1.535000,55.562600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,0.000000,53.181300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,0.000000,56.991300>}
box{<0,0,-0.100100><3.810000,0.035000,0.100100> rotate<0,90.000000,0> translate<42.545000,0.000000,56.991300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.386300,0.000000,60.642500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,0.000000,60.801300>}
box{<0,0,-0.100100><0.224506,0.035000,0.100100> rotate<0,-45.015075,0> translate<42.386300,0.000000,60.642500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.386300,-1.535000,60.642500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,-1.535000,60.801300>}
box{<0,0,-0.100100><0.224506,0.035000,0.100100> rotate<0,-45.015075,0> translate<42.386300,-1.535000,60.642500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,-1.535000,60.801300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,-1.535000,61.753800>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,90.000000,0> translate<42.545000,-1.535000,61.753800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,-1.535000,61.753800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,-1.535000,62.280800>}
box{<0,0,-0.100100><0.527000,0.035000,0.100100> rotate<0,90.000000,0> translate<42.545000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.433700,-1.535000,65.246300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,-1.535000,64.134900>}
box{<0,0,-0.100100><1.571686,0.035000,0.100100> rotate<0,44.999608,0> translate<41.433700,-1.535000,65.246300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,-1.535000,61.753800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,-1.535000,64.134900>}
box{<0,0,-0.100100><2.381100,0.035000,0.100100> rotate<0,90.000000,0> translate<42.545000,-1.535000,64.134900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,-1.535000,72.339200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,-1.535000,73.501200>}
box{<0,0,-0.100100><1.162000,0.035000,0.100100> rotate<0,90.000000,0> translate<42.545000,-1.535000,73.501200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,0.000000,24.288800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545100,0.000000,24.288800>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<42.545000,0.000000,24.288800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.386400,-1.535000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.703800,-1.535000,24.447500>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,-45.006054,0> translate<42.386400,-1.535000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545100,0.000000,24.288800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.703800,0.000000,24.447500>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<42.545100,0.000000,24.288800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.052600,-1.535000,28.575000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.703800,-1.535000,28.575000>}
box{<0,0,-0.100100><3.651200,0.035000,0.100100> rotate<0,0.000000,0> translate<39.052600,-1.535000,28.575000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.544900,-1.535000,42.068800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.703800,-1.535000,42.068900>}
box{<0,0,-0.100100><0.158900,0.035000,0.100100> rotate<0,-0.036055,0> translate<42.544900,-1.535000,42.068800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.322400,0.000000,39.687500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.703900,0.000000,39.687600>}
box{<0,0,-0.100000><2.381500,0.035000,0.100000> rotate<0,-0.002406,0> translate<40.322400,0.000000,39.687500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.703800,-1.535000,42.068900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.703900,-1.535000,42.068900>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,0.000000,0> translate<42.703800,-1.535000,42.068900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,0.000000,60.801300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.703900,0.000000,60.801200>}
box{<0,0,-0.100100><0.158900,0.035000,0.100100> rotate<0,0.036055,0> translate<42.545000,0.000000,60.801300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.910000,0.000000,18.097500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.862500,0.000000,17.145000>}
box{<0,0,-0.100000><1.347038,0.035000,0.100000> rotate<0,44.997030,0> translate<41.910000,0.000000,18.097500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.116200,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<42.862500,-1.535000,20.796300>}
box{<0,0,-0.203200><2.469641,0.035000,0.203200> rotate<0,-44.997030,0> translate<41.116200,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.227500,-1.535000,25.241300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.862500,-1.535000,25.241300>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,0.000000,0> translate<42.227500,-1.535000,25.241300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.068800,0.000000,44.132700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.862500,0.000000,44.926400>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,-44.997030,0> translate<42.068800,0.000000,44.132700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.703900,0.000000,60.801200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.862500,0.000000,60.801200>}
box{<0,0,-0.100100><0.158600,0.035000,0.100100> rotate<0,0.000000,0> translate<42.703900,0.000000,60.801200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.862500,0.000000,60.801200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.862500,0.000000,60.801300>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<42.862500,0.000000,60.801300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.386300,-1.535000,42.545000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.862600,-1.535000,43.021300>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,-44.997030,0> translate<42.386300,-1.535000,42.545000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.862500,0.000000,44.132600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.862600,0.000000,43.021300>}
box{<0,0,-0.100100><1.111300,0.035000,0.100100> rotate<0,89.988905,0> translate<42.862500,0.000000,44.132600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.083800,-1.535000,16.351300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.021200,-1.535000,16.351300>}
box{<0,0,-0.100000><7.937400,0.035000,0.100000> rotate<0,0.000000,0> translate<35.083800,-1.535000,16.351300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<33.020000,-1.535000,23.653800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.021200,-1.535000,23.653800>}
box{<0,0,-0.100000><10.001200,0.035000,0.100000> rotate<0,0.000000,0> translate<33.020000,-1.535000,23.653800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.481300,-1.535000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.021200,-1.535000,25.717500>}
box{<0,0,-0.100000><2.539900,0.035000,0.100000> rotate<0,0.000000,0> translate<40.481300,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<29.686300,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.021300,-1.535000,23.177500>}
box{<0,0,-0.100000><13.335000,0.035000,0.100000> rotate<0,0.000000,0> translate<29.686300,-1.535000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.782400,-1.535000,28.098700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.021300,-1.535000,28.098700>}
box{<0,0,-0.100100><5.238900,0.035000,0.100100> rotate<0,0.000000,0> translate<37.782400,-1.535000,28.098700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.703800,-1.535000,28.575000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.021300,-1.535000,28.892500>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<42.703800,-1.535000,28.575000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<40.957500,0.000000,38.417500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.021300,0.000000,38.417500>}
box{<0,0,-0.203200><2.063800,0.035000,0.203200> rotate<0,0.000000,0> translate<40.957500,0.000000,38.417500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.703900,0.000000,39.687600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.021400,0.000000,40.005000>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,-44.988006,0> translate<42.703900,0.000000,39.687600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.091100,0.000000,31.610300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.091100,0.000000,32.296100>}
box{<0,0,-0.100100><0.685800,0.035000,0.100100> rotate<0,90.000000,0> translate<43.091100,0.000000,32.296100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.091100,0.000000,48.012400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.091100,0.000000,47.129700>}
box{<0,0,-0.100000><0.882700,0.035000,0.100000> rotate<0,-90.000000,0> translate<43.091100,0.000000,47.129700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.227500,0.000000,49.212500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.100600,0.000000,50.085600>}
box{<0,0,-0.100100><1.234750,0.035000,0.100100> rotate<0,-44.997030,0> translate<42.227500,0.000000,49.212500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.068800,0.000000,1.428800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.180000,0.000000,2.540000>}
box{<0,0,-0.100000><1.571474,0.035000,0.100000> rotate<0,-44.997030,0> translate<42.068800,0.000000,1.428800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.910000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.180000,0.000000,5.080000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,-44.997030,0> translate<41.910000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.545000,0.000000,9.207500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.180000,0.000000,8.572500>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<42.545000,0.000000,9.207500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.862500,-1.535000,25.241300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.180000,-1.535000,24.923800>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<42.862500,-1.535000,25.241300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.528800,-1.535000,26.193800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.180000,-1.535000,26.193800>}
box{<0,0,-0.100000><3.651200,0.035000,0.100000> rotate<0,0.000000,0> translate<39.528800,-1.535000,26.193800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.481300,-1.535000,51.117500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,51.117500>}
box{<0,0,-0.100100><2.698700,0.035000,0.100100> rotate<0,0.000000,0> translate<40.481300,-1.535000,51.117500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,0.000000,56.991300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,0.000000,57.626300>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<42.545000,0.000000,56.991300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910000,-1.535000,57.626300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,58.896300>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,-44.997030,0> translate<41.910000,-1.535000,57.626300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,0.000000,57.943800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,0.000000,59.531300>}
box{<0,0,-0.100100><2.245064,0.035000,0.100100> rotate<0,-44.997030,0> translate<41.592500,0.000000,57.943800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.179900,-1.535000,64.770000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,63.500000>}
box{<0,0,-0.100100><1.270000,0.035000,0.100100> rotate<0,89.989549,0> translate<43.179900,-1.535000,64.770000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,58.896300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,63.500000>}
box{<0,0,-0.100100><4.603700,0.035000,0.100100> rotate<0,90.000000,0> translate<43.180000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,-1.535000,69.373800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,66.198800>}
box{<0,0,-0.100100><4.490128,0.035000,0.100100> rotate<0,44.997030,0> translate<40.005000,-1.535000,69.373800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.179900,0.000000,64.770000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,0.000000,67.151100>}
box{<0,0,-0.100100><2.381100,0.035000,0.100100> rotate<0,-89.991654,0> translate<43.179900,0.000000,64.770000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275000,-1.535000,69.532500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,67.627500>}
box{<0,0,-0.100100><2.694077,0.035000,0.100100> rotate<0,44.997030,0> translate<41.275000,-1.535000,69.532500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,67.151100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,67.627500>}
box{<0,0,-0.100100><0.476400,0.035000,0.100100> rotate<0,90.000000,0> translate<43.180000,-1.535000,67.627500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.386300,-1.535000,74.136300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,74.930000>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,-44.997030,0> translate<42.386300,-1.535000,74.136300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.545000,-1.535000,73.501200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180100,-1.535000,74.136300>}
box{<0,0,-0.100100><0.898167,0.035000,0.100100> rotate<0,-44.997030,0> translate<42.545000,-1.535000,73.501200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.021200,-1.535000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.338700,-1.535000,25.400000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<43.021200,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.091100,0.000000,48.012400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.338700,0.000000,48.260000>}
box{<0,0,-0.100000><0.350159,0.035000,0.100000> rotate<0,-44.997030,0> translate<43.091100,0.000000,48.012400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.021300,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.338800,-1.535000,22.860000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<43.021300,-1.535000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.052600,-1.535000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.338800,-1.535000,26.670000>}
box{<0,0,-0.100000><4.286200,0.035000,0.100000> rotate<0,0.000000,0> translate<39.052600,-1.535000,26.670000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275000,0.000000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.338800,0.000000,52.863800>}
box{<0,0,-0.100100><2.918654,0.035000,0.100100> rotate<0,-44.997030,0> translate<41.275000,0.000000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.338800,0.000000,52.863800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.338800,0.000000,54.610000>}
box{<0,0,-0.100100><1.746200,0.035000,0.100100> rotate<0,90.000000,0> translate<43.338800,0.000000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.068800,0.000000,57.626200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.338800,0.000000,58.896300>}
box{<0,0,-0.100100><1.796122,0.035000,0.100100> rotate<0,-44.999286,0> translate<42.068800,0.000000,57.626200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.021300,-1.535000,28.098700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.338900,-1.535000,28.416300>}
box{<0,0,-0.100100><0.449154,0.035000,0.100100> rotate<0,-44.997030,0> translate<43.021300,-1.535000,28.098700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.703900,-1.535000,42.068900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.338900,-1.535000,42.068800>}
box{<0,0,-0.100100><0.635000,0.035000,0.100100> rotate<0,0.009022,0> translate<42.703900,-1.535000,42.068900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.941300,0.000000,0.952500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,0.000000,0.952500>}
box{<0,0,-0.100100><5.556200,0.035000,0.100100> rotate<0,0.000000,0> translate<37.941300,0.000000,0.952500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.180000,-1.535000,26.193800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.497500,-1.535000,25.876300>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<43.180000,-1.535000,26.193800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<38.735000,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,-1.535000,27.622500>}
box{<0,0,-0.100100><4.762500,0.035000,0.100100> rotate<0,0.000000,0> translate<38.735000,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.005000,0.000000,39.211300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,0.000000,39.211300>}
box{<0,0,-0.100100><3.492500,0.035000,0.100100> rotate<0,0.000000,0> translate<40.005000,0.000000,39.211300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.862500,0.000000,44.132600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,0.000000,44.767500>}
box{<0,0,-0.100100><0.897955,0.035000,0.100100> rotate<0,-44.992519,0> translate<42.862500,0.000000,44.132600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,51.117500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,-1.535000,50.800000>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<43.180000,-1.535000,51.117500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,-1.535000,50.006300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,-1.535000,50.800000>}
box{<0,0,-0.100100><0.793700,0.035000,0.100100> rotate<0,90.000000,0> translate<43.497500,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.751300,0.000000,63.976300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,0.000000,63.976300>}
box{<0,0,-0.100100><1.746200,0.035000,0.100100> rotate<0,0.000000,0> translate<41.751300,0.000000,63.976300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.600000,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.600000,-1.535000,18.471300>}
box{<0,0,-0.203200><0.578700,0.035000,0.203200> rotate<0,-90.000000,0> translate<43.600000,-1.535000,18.471300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.338800,-1.535000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.656200,-1.535000,26.352500>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,45.006054,0> translate<43.338800,-1.535000,26.670000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<42.227600,-1.535000,17.621300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.656300,-1.535000,19.050000>}
box{<0,0,-0.203200><2.020487,0.035000,0.203200> rotate<0,-44.997030,0> translate<42.227600,-1.535000,17.621300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.600000,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.656300,-1.535000,19.050000>}
box{<0,0,-0.203200><0.056300,0.035000,0.203200> rotate<0,0.000000,0> translate<43.600000,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.021200,-1.535000,23.653800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.656300,-1.535000,23.653700>}
box{<0,0,-0.100000><0.635100,0.035000,0.100000> rotate<0,0.009021,0> translate<43.021200,-1.535000,23.653800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.091100,0.000000,32.296100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.656300,0.000000,32.861300>}
box{<0,0,-0.100100><0.799314,0.035000,0.100100> rotate<0,-44.997030,0> translate<43.091100,0.000000,32.296100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.021300,0.000000,38.417500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.656300,0.000000,37.782500>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<43.021300,0.000000,38.417500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.338900,0.000000,42.068800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.656300,0.000000,42.386300>}
box{<0,0,-0.100100><0.448942,0.035000,0.100100> rotate<0,-45.006054,0> translate<43.338900,0.000000,42.068800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.656300,0.000000,42.386300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.656300,0.000000,43.973800>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,90.000000,0> translate<43.656300,0.000000,43.973800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,-1.535000,50.006300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.656300,-1.535000,49.847500>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<43.497500,-1.535000,50.006300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,57.626300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.656300,-1.535000,58.102400>}
box{<0,0,-0.100100><0.673449,0.035000,0.100100> rotate<0,-44.984999,0> translate<43.180000,-1.535000,57.626300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.656300,-1.535000,58.102400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.656300,-1.535000,60.801300>}
box{<0,0,-0.100100><2.698900,0.035000,0.100100> rotate<0,90.000000,0> translate<43.656300,-1.535000,60.801300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.303700,0.000000,48.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.735700,0.000000,49.609400>}
box{<0,0,-0.100100><2.025083,0.035000,0.100100> rotate<0,-44.995030,0> translate<42.303700,0.000000,48.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,9.525100>}
box{<0,0,-0.100000><1.904900,0.035000,0.100000> rotate<0,-90.000000,0> translate<43.815000,0.000000,9.525100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,13.176300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,11.430000>}
box{<0,0,-0.100000><1.746300,0.035000,0.100000> rotate<0,-90.000000,0> translate<43.815000,0.000000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,11.480800>}
box{<0,0,-0.100000><0.050800,0.035000,0.100000> rotate<0,90.000000,0> translate<43.815000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,-1.535000,15.557500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,-1.535000,13.176300>}
box{<0,0,-0.100000><2.381200,0.035000,0.100000> rotate<0,-90.000000,0> translate<43.815000,-1.535000,13.176300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.021200,-1.535000,16.351300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,-1.535000,15.557500>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,44.997030,0> translate<43.021200,-1.535000,16.351300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,21.748800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,21.539200>}
box{<0,0,-0.100000><0.209600,0.035000,0.100000> rotate<0,-90.000000,0> translate<43.815000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.656300,0.000000,21.748800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,21.748800>}
box{<0,0,-0.100000><0.158700,0.035000,0.100000> rotate<0,0.000000,0> translate<43.656300,0.000000,21.748800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,21.907500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,21.748800>}
box{<0,0,-0.100000><0.158700,0.035000,0.100000> rotate<0,-90.000000,0> translate<43.815000,0.000000,21.748800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.656300,0.000000,21.748800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,21.907500>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<43.656300,0.000000,21.748800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,23.495000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,21.907500>}
box{<0,0,-0.100000><1.587500,0.035000,0.100000> rotate<0,-90.000000,0> translate<43.815000,0.000000,21.907500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.656300,0.000000,23.653700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,23.495000>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<43.656300,0.000000,23.653700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,-1.535000,27.940000>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<43.497500,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,0.000000,29.686300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,0.000000,31.591300>}
box{<0,0,-0.100100><1.905000,0.035000,0.100100> rotate<0,90.000000,0> translate<43.815000,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.957500,-1.535000,43.815000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,-1.535000,43.815000>}
box{<0,0,-0.100100><2.857500,0.035000,0.100100> rotate<0,0.000000,0> translate<40.957500,-1.535000,43.815000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.862500,0.000000,44.926400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,0.000000,45.878800>}
box{<0,0,-0.100100><1.346968,0.035000,0.100100> rotate<0,-44.994023,0> translate<42.862500,0.000000,44.926400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,0.000000,45.878800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,0.000000,46.990000>}
box{<0,0,-0.100100><1.111200,0.035000,0.100100> rotate<0,90.000000,0> translate<43.815000,0.000000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.386300,-1.535000,56.832500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,-1.535000,56.832500>}
box{<0,0,-0.100100><1.428700,0.035000,0.100100> rotate<0,0.000000,0> translate<42.386300,-1.535000,56.832500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.656300,-1.535000,60.801300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,-1.535000,60.960000>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,-44.997030,0> translate<43.656300,-1.535000,60.801300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,-1.535000,62.280800>}
box{<0,0,-0.100100><1.320800,0.035000,0.100100> rotate<0,90.000000,0> translate<43.815000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,-1.535000,70.643800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,-1.535000,72.339200>}
box{<0,0,-0.100100><1.695400,0.035000,0.100100> rotate<0,90.000000,0> translate<43.815000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.656300,0.000000,36.036300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.815100,0.000000,35.877500>}
box{<0,0,-0.203200><0.224577,0.035000,0.203200> rotate<0,44.997030,0> translate<43.656300,0.000000,36.036300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.815100,0.000000,36.036300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.815100,0.000000,35.877500>}
box{<0,0,-0.203200><0.158800,0.035000,0.203200> rotate<0,-90.000000,0> translate<43.815100,0.000000,35.877500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.656300,0.000000,36.036300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.815100,0.000000,36.036300>}
box{<0,0,-0.203200><0.158800,0.035000,0.203200> rotate<0,0.000000,0> translate<43.656300,0.000000,36.036300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,-1.535000,49.212500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815100,-1.535000,49.212500>}
box{<0,0,-0.100100><2.222600,0.035000,0.100100> rotate<0,0.000000,0> translate<41.592500,-1.535000,49.212500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,0.000000,31.591300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.859500,0.000000,31.591300>}
box{<0,0,-0.100100><0.044500,0.035000,0.100100> rotate<0,0.000000,0> translate<43.815000,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.859500,0.000000,31.591300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.878500,0.000000,31.610300>}
box{<0,0,-0.100100><0.026870,0.035000,0.100100> rotate<0,-44.997030,0> translate<43.859500,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,0.000000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.878500,0.000000,47.053500>}
box{<0,0,-0.100100><0.089803,0.035000,0.100100> rotate<0,-44.997030,0> translate<43.815000,0.000000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.878500,0.000000,47.053500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.878500,0.000000,47.129700>}
box{<0,0,-0.100100><0.076200,0.035000,0.100100> rotate<0,90.000000,0> translate<43.878500,0.000000,47.129700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,0.000000,39.211300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.894500,0.000000,39.608000>}
box{<0,0,-0.100100><0.561231,0.035000,0.100100> rotate<0,-44.975375,0> translate<43.497500,0.000000,39.211300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,-1.535000,43.815000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.973700,-1.535000,43.656300>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.997030,0> translate<43.815000,-1.535000,43.815000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.116300,-1.535000,44.291300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.973700,-1.535000,44.291300>}
box{<0,0,-0.100100><2.857400,0.035000,0.100100> rotate<0,0.000000,0> translate<41.116300,-1.535000,44.291300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.973700,-1.535000,43.656300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.973800,-1.535000,43.656300>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,0.000000,0> translate<43.973700,-1.535000,43.656300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,0.000000,44.767500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.973800,0.000000,45.243800>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,-44.997030,0> translate<43.497500,0.000000,44.767500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,0.000000,63.976300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.973800,0.000000,63.500000>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,44.997030,0> translate<43.497500,0.000000,63.976300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.988700,0.000000,69.691300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.132400,0.000000,69.691300>}
box{<0,0,-0.100100><7.143700,0.035000,0.100100> rotate<0,0.000000,0> translate<36.988700,0.000000,69.691300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,-1.535000,29.686300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.132500,-1.535000,29.368800>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<43.815000,-1.535000,29.686300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.021400,-1.535000,40.005000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.132500,-1.535000,38.893800>}
box{<0,0,-0.100000><1.571403,0.035000,0.100000> rotate<0,44.999608,0> translate<43.021400,-1.535000,40.005000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,0.000000,50.165000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.132500,0.000000,52.546200>}
box{<0,0,-0.100100><3.481625,0.035000,0.100100> rotate<0,-43.148942,0> translate<41.592500,0.000000,50.165000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,0.000000,56.832500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.132500,0.000000,56.515000>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<43.815000,0.000000,56.832500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.132500,0.000000,52.546200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.132500,0.000000,56.515000>}
box{<0,0,-0.100100><3.968800,0.035000,0.100100> rotate<0,90.000000,0> translate<44.132500,0.000000,56.515000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,-1.535000,70.643800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.132500,-1.535000,70.326300>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<43.815000,-1.535000,70.643800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.132400,0.000000,69.691300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.132500,0.000000,70.326300>}
box{<0,0,-0.100100><0.635000,0.035000,0.100100> rotate<0,-89.985038,0> translate<44.132400,0.000000,69.691300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.338800,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.132600,-1.535000,22.860000>}
box{<0,0,-0.100000><0.793800,0.035000,0.100000> rotate<0,0.000000,0> translate<43.338800,-1.535000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.893800,-1.535000,27.146300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.132600,-1.535000,27.146300>}
box{<0,0,-0.100000><5.238800,0.035000,0.100000> rotate<0,0.000000,0> translate<38.893800,-1.535000,27.146300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.894500,0.000000,39.608000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.211900,0.000000,39.925600>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-45.015075,0> translate<43.894500,0.000000,39.608000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.211900,0.000000,39.925600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.211900,0.000000,43.894400>}
box{<0,0,-0.100100><3.968800,0.035000,0.100100> rotate<0,90.000000,0> translate<44.211900,0.000000,43.894400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.338700,0.000000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.212000,0.000000,49.133100>}
box{<0,0,-0.100000><1.234891,0.035000,0.100000> rotate<0,-44.990469,0> translate<43.338700,0.000000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.180000,-1.535000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.291100,-1.535000,24.923800>}
box{<0,0,-0.100000><1.111100,0.035000,0.100000> rotate<0,0.000000,0> translate<43.180000,-1.535000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.924900,-1.535000,16.827500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.291200,-1.535000,16.827600>}
box{<0,0,-0.100000><9.366300,0.035000,0.100000> rotate<0,-0.000612,0> translate<34.924900,-1.535000,16.827500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.815000,0.000000,9.525100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.291300,0.000000,9.048800>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,44.997030,0> translate<43.815000,0.000000,9.525100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.656300,0.000000,43.973800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.291300,0.000000,44.608800>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<43.656300,0.000000,43.973800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.275100,-1.535000,44.767500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.291300,-1.535000,44.767500>}
box{<0,0,-0.100100><3.016200,0.035000,0.100100> rotate<0,0.000000,0> translate<41.275100,-1.535000,44.767500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.338700,-1.535000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.449800,-1.535000,25.399900>}
box{<0,0,-0.100000><1.111100,0.035000,0.100000> rotate<0,0.005156,0> translate<43.338700,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.449800,-1.535000,25.399900>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.449900,-1.535000,25.400000>}
box{<0,0,-0.100000><0.000141,0.035000,0.100000> rotate<0,-44.997030,0> translate<44.449800,-1.535000,25.399900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.497500,0.000000,0.952500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,0.000000,1.905000>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,-44.997030,0> translate<43.497500,0.000000,0.952500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,0.000000,1.905000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,0.000000,3.492500>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,90.000000,0> translate<44.450000,0.000000,3.492500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.132600,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.450000,-1.535000,23.177500>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,-45.006054,0> translate<44.132600,-1.535000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.656300,-1.535000,23.653700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.450000,-1.535000,23.653800>}
box{<0,0,-0.100000><0.793700,0.035000,0.100000> rotate<0,-0.007218,0> translate<43.656300,-1.535000,23.653700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.941500,0.000000,28.479800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.450000,0.000000,23.971300>}
box{<0,0,-0.100000><6.375982,0.035000,0.100000> rotate<0,44.997030,0> translate<39.941500,0.000000,28.479800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.450000,0.000000,18.256300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.450000,0.000000,23.971300>}
box{<0,0,-0.100000><5.715000,0.035000,0.100000> rotate<0,90.000000,0> translate<44.450000,0.000000,23.971300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.211900,0.000000,43.894400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,0.000000,44.132500>}
box{<0,0,-0.100100><0.336724,0.035000,0.100100> rotate<0,-44.997030,0> translate<44.211900,0.000000,43.894400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.433800,-1.535000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,-1.535000,45.243800>}
box{<0,0,-0.100100><3.016200,0.035000,0.100100> rotate<0,0.000000,0> translate<41.433800,-1.535000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,-1.535000,62.388800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,-1.535000,62.230000>}
box{<0,0,-0.100100><0.158800,0.035000,0.100100> rotate<0,-90.000000,0> translate<44.450000,-1.535000,62.230000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,-1.535000,60.325000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,-1.535000,62.388800>}
box{<0,0,-0.100100><2.063800,0.035000,0.100100> rotate<0,90.000000,0> translate<44.450000,-1.535000,62.388800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.291200,-1.535000,64.611300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,-1.535000,64.452500>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<44.291200,-1.535000,64.611300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,-1.535000,62.388800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,-1.535000,64.452500>}
box{<0,0,-0.100100><2.063700,0.035000,0.100100> rotate<0,90.000000,0> translate<44.450000,-1.535000,64.452500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.728900,0.000000,28.327400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608800,0.000000,24.447500>}
box{<0,0,-0.100000><5.487007,0.035000,0.100000> rotate<0,44.997030,0> translate<40.728900,0.000000,28.327400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.516300,0.000000,28.175000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608800,0.000000,25.082500>}
box{<0,0,-0.100000><4.373455,0.035000,0.100000> rotate<0,44.997030,0> translate<41.516300,0.000000,28.175000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.132600,-1.535000,27.146300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608800,-1.535000,27.463800>}
box{<0,0,-0.100000><0.572340,0.035000,0.100000> rotate<0,-33.690620,0> translate<44.132600,-1.535000,27.146300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.132600,0.000000,27.146300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608800,0.000000,27.622500>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,-44.997030,0> translate<44.132600,0.000000,27.146300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608800,0.000000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608800,0.000000,31.432600>}
box{<0,0,-0.100000><3.810100,0.035000,0.100000> rotate<0,90.000000,0> translate<44.608800,0.000000,31.432600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.592500,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,-1.535000,45.720000>}
box{<0,0,-0.100100><3.016300,0.035000,0.100100> rotate<0,0.000000,0> translate<41.592500,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,0.000000,48.418800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,0.000000,47.148800>}
box{<0,0,-0.100100><1.270000,0.035000,0.100100> rotate<0,-90.000000,0> translate<44.608800,0.000000,47.148800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815100,-1.535000,49.212500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,-1.535000,48.418800>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,44.997030,0> translate<43.815100,-1.535000,49.212500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.068800,0.000000,49.688800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,0.000000,52.228800>}
box{<0,0,-0.100100><3.592102,0.035000,0.100100> rotate<0,-44.997030,0> translate<42.068800,0.000000,49.688800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.592500,-1.535000,55.721300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.608800,-1.535000,55.721300>}
box{<0,0,-0.203200><3.016300,0.035000,0.203200> rotate<0,0.000000,0> translate<41.592500,-1.535000,55.721300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,0.000000,52.228800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,0.000000,57.626300>}
box{<0,0,-0.100100><5.397500,0.035000,0.100100> rotate<0,90.000000,0> translate<44.608800,0.000000,57.626300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,0.000000,59.531300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,0.000000,59.531300>}
box{<0,0,-0.100100><1.428800,0.035000,0.100100> rotate<0,0.000000,0> translate<43.180000,0.000000,59.531300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.798800,-1.535000,65.722500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,-1.535000,65.722500>}
box{<0,0,-0.100100><3.810000,0.035000,0.100100> rotate<0,0.000000,0> translate<40.798800,-1.535000,65.722500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608900,-1.535000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608900,-1.535000,25.876200>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,-90.000000,0> translate<44.608900,-1.535000,25.876200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.497500,-1.535000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608900,-1.535000,25.876300>}
box{<0,0,-0.100000><1.111400,0.035000,0.100000> rotate<0,0.000000,0> translate<43.497500,-1.535000,25.876300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,0.000000,47.148800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.627900,0.000000,47.129700>}
box{<0,0,-0.100100><0.027011,0.035000,0.100100> rotate<0,44.997030,0> translate<44.608800,0.000000,47.148800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.627900,0.000000,47.129700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.665900,0.000000,47.129700>}
box{<0,0,-0.100100><0.038000,0.035000,0.100100> rotate<0,0.000000,0> translate<44.627900,0.000000,47.129700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.100600,0.000000,50.085600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.688100,0.000000,50.085600>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,0.000000,0> translate<43.100600,0.000000,50.085600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.665900,0.000000,31.610300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.748500,0.000000,31.610300>}
box{<0,0,-0.100000><0.082600,0.035000,0.100000> rotate<0,0.000000,0> translate<44.665900,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,0.000000,3.492500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.767500,0.000000,3.810000>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<44.450000,0.000000,3.492500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.450000,-1.535000,23.653800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.767500,-1.535000,23.971300>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<44.450000,-1.535000,23.653800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.303700,0.000000,28.022600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.767500,0.000000,25.558800>}
box{<0,0,-0.100000><3.484339,0.035000,0.100000> rotate<0,44.997030,0> translate<42.303700,0.000000,28.022600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.656200,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.767500,-1.535000,26.352500>}
box{<0,0,-0.100000><1.111300,0.035000,0.100000> rotate<0,0.000000,0> translate<43.656200,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608800,0.000000,31.432600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.767500,0.000000,31.591300>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<44.608800,0.000000,31.432600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.748500,0.000000,31.610300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.767500,0.000000,31.591300>}
box{<0,0,-0.100000><0.026870,0.035000,0.100000> rotate<0,44.997030,0> translate<44.748500,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,36.036300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,35.877500>}
box{<0,0,-0.203200><0.158800,0.035000,0.203200> rotate<0,-90.000000,0> translate<44.767500,-1.535000,35.877500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,35.877500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,35.933800>}
box{<0,0,-0.203200><0.056300,0.035000,0.203200> rotate<0,90.000000,0> translate<44.767500,-1.535000,35.933800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.656300,-1.535000,36.036300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,36.036300>}
box{<0,0,-0.203200><1.111200,0.035000,0.203200> rotate<0,0.000000,0> translate<43.656300,-1.535000,36.036300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,37.782500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,36.036300>}
box{<0,0,-0.203200><1.746200,0.035000,0.203200> rotate<0,-90.000000,0> translate<44.767500,-1.535000,36.036300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,36.036300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,36.138800>}
box{<0,0,-0.203200><0.102500,0.035000,0.203200> rotate<0,90.000000,0> translate<44.767500,-1.535000,36.138800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.656300,-1.535000,37.782500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,37.782500>}
box{<0,0,-0.203200><1.111200,0.035000,0.203200> rotate<0,0.000000,0> translate<43.656300,-1.535000,37.782500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,37.782500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,38.315100>}
box{<0,0,-0.203200><0.532600,0.035000,0.203200> rotate<0,90.000000,0> translate<44.767500,-1.535000,38.315100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.767500,-1.535000,42.862500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.767500,-1.535000,41.275100>}
box{<0,0,-0.100100><1.587400,0.035000,0.100100> rotate<0,-90.000000,0> translate<44.767500,-1.535000,41.275100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.973800,-1.535000,43.656300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.767500,-1.535000,42.862500>}
box{<0,0,-0.100100><1.122532,0.035000,0.100100> rotate<0,45.000639,0> translate<43.973800,-1.535000,43.656300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.751300,-1.535000,46.196300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.767500,-1.535000,46.196300>}
box{<0,0,-0.100100><3.016200,0.035000,0.100100> rotate<0,0.000000,0> translate<41.751300,-1.535000,46.196300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,66.198800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.767500,-1.535000,66.198800>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,0.000000,0> translate<43.180000,-1.535000,66.198800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.735700,0.000000,49.609400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.847100,0.000000,49.609400>}
box{<0,0,-0.100100><1.111400,0.035000,0.100100> rotate<0,0.000000,0> translate<43.735700,0.000000,49.609400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,37.782500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.869900,-1.535000,37.782500>}
box{<0,0,-0.203200><0.102400,0.035000,0.203200> rotate<0,0.000000,0> translate<44.767500,-1.535000,37.782500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,35.933800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.870000,-1.535000,35.401300>}
box{<0,0,-0.203200><0.542275,0.035000,0.203200> rotate<0,79.099276,0> translate<44.767500,-1.535000,35.933800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,36.138800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.870000,-1.535000,35.401300>}
box{<0,0,-0.203200><0.744589,0.035000,0.203200> rotate<0,82.082127,0> translate<44.767500,-1.535000,36.138800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,38.315100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.870000,-1.535000,37.782600>}
box{<0,0,-0.203200><0.542275,0.035000,0.203200> rotate<0,79.099276,0> translate<44.767500,-1.535000,38.315100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.869900,-1.535000,37.782500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.870000,-1.535000,37.782600>}
box{<0,0,-0.203200><0.000141,0.035000,0.203200> rotate<0,-44.997030,0> translate<44.869900,-1.535000,37.782500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.688100,0.000000,50.085600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926200,0.000000,50.323800>}
box{<0,0,-0.100100><0.336795,0.035000,0.100100> rotate<0,-45.009059,0> translate<44.688100,0.000000,50.085600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.600000,-1.535000,18.471300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.926300,-1.535000,17.145000>}
box{<0,0,-0.203200><1.875671,0.035000,0.203200> rotate<0,44.997030,0> translate<43.600000,-1.535000,18.471300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<42.862500,-1.535000,20.796300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.926300,-1.535000,20.796300>}
box{<0,0,-0.203200><2.063800,0.035000,0.203200> rotate<0,0.000000,0> translate<42.862500,-1.535000,20.796300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,35.877500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.926300,-1.535000,35.718700>}
box{<0,0,-0.203200><0.224577,0.035000,0.203200> rotate<0,44.997030,0> translate<44.767500,-1.535000,35.877500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.926300,-1.535000,36.036300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.926300,-1.535000,35.718700>}
box{<0,0,-0.203200><0.317600,0.035000,0.203200> rotate<0,-90.000000,0> translate<44.926300,-1.535000,35.718700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.870000,-1.535000,35.401300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.926300,-1.535000,35.980000>}
box{<0,0,-0.203200><0.581432,0.035000,0.203200> rotate<0,-84.437778,0> translate<44.870000,-1.535000,35.401300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.926300,-1.535000,35.718700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.926300,-1.535000,35.980000>}
box{<0,0,-0.203200><0.261300,0.035000,0.203200> rotate<0,90.000000,0> translate<44.926300,-1.535000,35.980000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.767500,-1.535000,36.036300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.926300,-1.535000,36.036300>}
box{<0,0,-0.203200><0.158800,0.035000,0.203200> rotate<0,0.000000,0> translate<44.767500,-1.535000,36.036300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926300,0.000000,40.322500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926300,0.000000,38.417500>}
box{<0,0,-0.100100><1.905000,0.035000,0.100100> rotate<0,-90.000000,0> translate<44.926300,0.000000,38.417500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926200,-1.535000,40.798800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926300,-1.535000,40.322500>}
box{<0,0,-0.100100><0.476300,0.035000,0.100100> rotate<0,89.982032,0> translate<44.926200,-1.535000,40.798800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926200,-1.535000,40.798800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926300,-1.535000,40.798900>}
box{<0,0,-0.100100><0.000141,0.035000,0.100100> rotate<0,-44.997030,0> translate<44.926200,-1.535000,40.798800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.767500,-1.535000,41.275100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926300,-1.535000,41.116400>}
box{<0,0,-0.100100><0.224506,0.035000,0.100100> rotate<0,44.978985,0> translate<44.767500,-1.535000,41.275100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926200,-1.535000,40.798800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926300,-1.535000,41.116400>}
box{<0,0,-0.100100><0.317600,0.035000,0.100100> rotate<0,-89.976021,0> translate<44.926200,-1.535000,40.798800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910000,-1.535000,46.672500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926300,-1.535000,46.672500>}
box{<0,0,-0.100100><3.016300,0.035000,0.100100> rotate<0,0.000000,0> translate<41.910000,-1.535000,46.672500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.433800,-1.535000,52.546300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.926300,-1.535000,52.546300>}
box{<0,0,-0.203200><3.492500,0.035000,0.203200> rotate<0,0.000000,0> translate<41.433800,-1.535000,52.546300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,0.000000,59.531300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926300,0.000000,59.848700>}
box{<0,0,-0.100100><0.448942,0.035000,0.100100> rotate<0,-44.988006,0> translate<44.608800,0.000000,59.531300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,-1.535000,60.325000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926300,-1.535000,59.848800>}
box{<0,0,-0.100100><0.673519,0.035000,0.100100> rotate<0,44.991015,0> translate<44.450000,-1.535000,60.325000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926300,-1.535000,59.848700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926300,-1.535000,59.848800>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<44.926300,-1.535000,59.848800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.212000,0.000000,49.133100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.005700,0.000000,49.133000>}
box{<0,0,-0.100000><0.793700,0.035000,0.100000> rotate<0,0.007218,0> translate<44.212000,0.000000,49.133100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,10.001300>}
box{<0,0,-0.100000><1.428700,0.035000,0.100000> rotate<0,-90.000000,0> translate<45.085000,0.000000,10.001300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,13.176300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,11.430000>}
box{<0,0,-0.100000><1.746300,0.035000,0.100000> rotate<0,-90.000000,0> translate<45.085000,0.000000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,11.480800>}
box{<0,0,-0.100000><0.050800,0.035000,0.100000> rotate<0,90.000000,0> translate<45.085000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,-1.535000,16.033800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,-1.535000,13.176300>}
box{<0,0,-0.100000><2.857500,0.035000,0.100000> rotate<0,-90.000000,0> translate<45.085000,-1.535000,13.176300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.291200,-1.535000,16.827600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,-1.535000,16.033800>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,44.997030,0> translate<44.291200,-1.535000,16.827600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.450000,0.000000,18.256300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,17.621300>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<44.450000,0.000000,18.256300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,23.018800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,21.539200>}
box{<0,0,-0.100000><1.479600,0.035000,0.100000> rotate<0,-90.000000,0> translate<45.085000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608800,0.000000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,24.447500>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,0.000000,0> translate<44.608800,0.000000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.068800,-1.535000,47.148800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.085000,-1.535000,47.148800>}
box{<0,0,-0.100100><3.016200,0.035000,0.100100> rotate<0,0.000000,0> translate<42.068800,-1.535000,47.148800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.085000,-1.535000,65.246300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.085000,-1.535000,62.280800>}
box{<0,0,-0.100100><2.965500,0.035000,0.100100> rotate<0,-90.000000,0> translate<45.085000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,-1.535000,65.722500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.085000,-1.535000,65.246300>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,44.997030,0> translate<44.608800,-1.535000,65.722500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.085000,-1.535000,70.643800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.085000,-1.535000,72.339200>}
box{<0,0,-0.100100><1.695400,0.035000,0.100100> rotate<0,90.000000,0> translate<45.085000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.085000,-1.535000,72.339200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.085000,-1.535000,72.390000>}
box{<0,0,-0.100100><0.050800,0.035000,0.100100> rotate<0,90.000000,0> translate<45.085000,-1.535000,72.390000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.847100,0.000000,49.609400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.085200,0.000000,49.847500>}
box{<0,0,-0.100100><0.336724,0.035000,0.100100> rotate<0,-44.997030,0> translate<44.847100,0.000000,49.609400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,23.018800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.243700,0.000000,23.177500>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<45.085000,0.000000,23.018800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.243800,-1.535000,20.478800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.243800,-1.535000,19.050000>}
box{<0,0,-0.203200><1.428800,0.035000,0.203200> rotate<0,-90.000000,0> translate<45.243800,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.926300,-1.535000,20.796300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.243800,-1.535000,20.478800>}
box{<0,0,-0.203200><0.449013,0.035000,0.203200> rotate<0,44.997030,0> translate<44.926300,-1.535000,20.796300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.450000,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.243800,-1.535000,23.177500>}
box{<0,0,-0.100000><0.793800,0.035000,0.100000> rotate<0,0.000000,0> translate<44.450000,-1.535000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.243700,0.000000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.243800,0.000000,23.177500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<45.243700,0.000000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.084900,0.000000,26.670100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.243800,0.000000,26.828800>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.960952,0> translate<45.084900,0.000000,26.670100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.243800,-1.535000,43.021200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.243800,-1.535000,42.068800>}
box{<0,0,-0.100100><0.952400,0.035000,0.100100> rotate<0,-90.000000,0> translate<45.243800,-1.535000,42.068800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.973700,-1.535000,44.291300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.243800,-1.535000,43.021200>}
box{<0,0,-0.100100><1.796193,0.035000,0.100100> rotate<0,44.997030,0> translate<43.973700,-1.535000,44.291300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.926300,-1.535000,52.546300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.243800,-1.535000,52.228800>}
box{<0,0,-0.203200><0.449013,0.035000,0.203200> rotate<0,44.997030,0> translate<44.926300,-1.535000,52.546300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.085000,-1.535000,70.643800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.243800,-1.535000,70.485000>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<45.085000,-1.535000,70.643800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.243800,0.000000,70.485000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.243800,0.000000,71.278800>}
box{<0,0,-0.100100><0.793800,0.035000,0.100100> rotate<0,90.000000,0> translate<45.243800,0.000000,71.278800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.005700,0.000000,49.133000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.243900,0.000000,49.371300>}
box{<0,0,-0.100000><0.336936,0.035000,0.100000> rotate<0,-45.009054,0> translate<45.005700,0.000000,49.133000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.243800,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.300000,-1.535000,19.050000>}
box{<0,0,-0.203200><0.056200,0.035000,0.203200> rotate<0,0.000000,0> translate<45.243800,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.767500,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.402400,-1.535000,26.987400>}
box{<0,0,-0.100000><0.897884,0.035000,0.100000> rotate<0,-44.997030,0> translate<44.767500,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.084900,-1.535000,26.670100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.402400,-1.535000,26.987500>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,-44.988006,0> translate<45.084900,-1.535000,26.670100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.402400,-1.535000,26.987400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.402400,-1.535000,26.987500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,90.000000,0> translate<45.402400,-1.535000,26.987500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.243800,0.000000,26.828800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.402500,0.000000,26.987500>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<45.243800,0.000000,26.828800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.402500,0.000000,26.987500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.402500,0.000000,31.591300>}
box{<0,0,-0.100000><4.603800,0.035000,0.100000> rotate<0,90.000000,0> translate<45.402500,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926300,0.000000,38.417500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.402500,0.000000,37.941300>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,44.997030,0> translate<44.926300,0.000000,38.417500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.402500,0.000000,47.180500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.402500,0.000000,48.260000>}
box{<0,0,-0.100100><1.079500,0.035000,0.100100> rotate<0,90.000000,0> translate<45.402500,0.000000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.291300,0.000000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.402500,0.000000,51.911200>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,-44.997030,0> translate<44.291300,0.000000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.402500,0.000000,53.340100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.402500,0.000000,51.911200>}
box{<0,0,-0.203200><1.428900,0.035000,0.203200> rotate<0,-90.000000,0> translate<45.402500,0.000000,51.911200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<42.545000,-1.535000,53.340100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.402500,-1.535000,53.340100>}
box{<0,0,-0.203200><2.857500,0.035000,0.203200> rotate<0,0.000000,0> translate<42.545000,-1.535000,53.340100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,0.000000,57.626300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.402500,0.000000,58.420000>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,-44.997030,0> translate<44.608800,0.000000,57.626300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.338800,0.000000,58.896300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.402500,0.000000,58.896300>}
box{<0,0,-0.100100><2.063700,0.035000,0.100100> rotate<0,0.000000,0> translate<43.338800,0.000000,58.896300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.402500,0.000000,31.591300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.421500,0.000000,31.610300>}
box{<0,0,-0.100000><0.026870,0.035000,0.100000> rotate<0,-44.997030,0> translate<45.402500,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.421500,0.000000,31.610300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.453300,0.000000,31.610300>}
box{<0,0,-0.100000><0.031800,0.035000,0.100000> rotate<0,0.000000,0> translate<45.421500,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.402500,0.000000,47.180500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.453300,0.000000,47.129700>}
box{<0,0,-0.100100><0.071842,0.035000,0.100100> rotate<0,44.997030,0> translate<45.402500,0.000000,47.180500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,10.001300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.561300,0.000000,9.525000>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,44.997030,0> translate<45.085000,0.000000,10.001300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608800,0.000000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.561300,0.000000,25.082500>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,0.000000,0> translate<44.608800,0.000000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.243800,-1.535000,42.068800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.561300,-1.535000,41.751300>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<45.243800,-1.535000,42.068800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.656300,-1.535000,49.847500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.561400,-1.535000,49.847500>}
box{<0,0,-0.100100><1.905100,0.035000,0.100100> rotate<0,0.000000,0> translate<43.656300,-1.535000,49.847500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.640600,0.000000,41.672000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.640600,0.000000,39.131900>}
box{<0,0,-0.100100><2.540100,0.035000,0.100100> rotate<0,-90.000000,0> translate<45.640600,0.000000,39.131900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.561300,0.000000,41.751300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.640600,0.000000,41.672000>}
box{<0,0,-0.100100><0.112147,0.035000,0.100100> rotate<0,44.997030,0> translate<45.561300,0.000000,41.751300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.300000,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,-1.535000,19.050000>}
box{<0,0,-0.203200><0.420000,0.035000,0.203200> rotate<0,0.000000,0> translate<45.300000,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.720000,0.000000,18.415000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.720000,0.000000,22.701300>}
box{<0,0,-0.100000><4.286300,0.035000,0.100000> rotate<0,90.000000,0> translate<45.720000,0.000000,22.701300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.767500,-1.535000,23.971300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.720000,-1.535000,23.971300>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,0.000000,0> translate<44.767500,-1.535000,23.971300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.767500,0.000000,25.558800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.720000,0.000000,25.558800>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,0.000000,0> translate<44.767500,0.000000,25.558800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608900,-1.535000,25.876200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.720000,-1.535000,25.876300>}
box{<0,0,-0.100000><1.111100,0.035000,0.100000> rotate<0,-0.005156,0> translate<44.608900,-1.535000,25.876200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.402500,0.000000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.720000,0.000000,48.577500>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<45.402500,0.000000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926200,0.000000,50.323800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.720000,0.000000,50.323800>}
box{<0,0,-0.100100><0.793800,0.035000,0.100100> rotate<0,0.000000,0> translate<44.926200,0.000000,50.323800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.338800,-1.535000,54.610000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.720000,-1.535000,54.610000>}
box{<0,0,-0.100100><2.381200,0.035000,0.100100> rotate<0,0.000000,0> translate<43.338800,-1.535000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.608800,-1.535000,55.721300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,-1.535000,56.832500>}
box{<0,0,-0.203200><1.571474,0.035000,0.203200> rotate<0,-44.997030,0> translate<44.608800,-1.535000,55.721300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,-1.535000,56.832500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,-1.535000,57.150000>}
box{<0,0,-0.203200><0.317500,0.035000,0.203200> rotate<0,90.000000,0> translate<45.720000,-1.535000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.767500,-1.535000,66.198800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.720000,-1.535000,65.246300>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,44.997030,0> translate<44.767500,-1.535000,66.198800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.720000,-1.535000,58.420100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.720000,-1.535000,65.246300>}
box{<0,0,-0.100100><6.826200,0.035000,0.100100> rotate<0,90.000000,0> translate<45.720000,-1.535000,65.246300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.910000,-1.535000,76.200000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,-1.535000,76.200000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<41.910000,-1.535000,76.200000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.561400,-1.535000,49.847500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.720100,-1.535000,49.688800>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.997030,0> translate<45.561400,-1.535000,49.847500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.720000,-1.535000,48.577500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.720100,-1.535000,49.688800>}
box{<0,0,-0.100100><1.111300,0.035000,0.100100> rotate<0,-89.988905,0> translate<45.720000,-1.535000,48.577500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.926300,-1.535000,17.145000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.878800,-1.535000,17.145000>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,0.000000,0> translate<44.926300,-1.535000,17.145000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.720000,-1.535000,23.971300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.878800,-1.535000,23.812500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<45.720000,-1.535000,23.971300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.703800,-1.535000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.878800,-1.535000,24.447500>}
box{<0,0,-0.100000><3.175000,0.035000,0.100000> rotate<0,0.000000,0> translate<42.703800,-1.535000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,-1.535000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.878800,-1.535000,43.815000>}
box{<0,0,-0.100100><2.020628,0.035000,0.100100> rotate<0,44.997030,0> translate<44.450000,-1.535000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.973800,0.000000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.878800,0.000000,45.243800>}
box{<0,0,-0.100100><1.905000,0.035000,0.100100> rotate<0,0.000000,0> translate<43.973800,0.000000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.720000,-1.535000,58.420100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.878800,-1.535000,58.261300>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<45.720000,-1.535000,58.420100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.402500,0.000000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.878800,0.000000,58.420000>}
box{<0,0,-0.100100><0.476300,0.035000,0.100100> rotate<0,0.000000,0> translate<45.402500,0.000000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.910000,0.000000,68.103800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.878800,0.000000,68.103800>}
box{<0,0,-0.100100><3.968800,0.035000,0.100100> rotate<0,0.000000,0> translate<41.910000,0.000000,68.103800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.720000,0.000000,18.415000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.037500,0.000000,18.097500>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<45.720000,0.000000,18.415000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.720000,0.000000,22.701300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.037500,0.000000,23.018800>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<45.720000,0.000000,22.701300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.037500,0.000000,23.495000>}
box{<0,0,-0.100000><1.347038,0.035000,0.100000> rotate<0,44.997030,0> translate<45.085000,0.000000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.037500,0.000000,23.018800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.037500,0.000000,23.495000>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,90.000000,0> translate<46.037500,0.000000,23.495000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.878800,-1.535000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.037500,-1.535000,24.288800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<45.878800,-1.535000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.037500,-1.535000,43.021300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.037500,-1.535000,42.703800>}
box{<0,0,-0.100100><0.317500,0.035000,0.100100> rotate<0,-90.000000,0> translate<46.037500,-1.535000,42.703800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.291300,-1.535000,44.767500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.037500,-1.535000,43.021300>}
box{<0,0,-0.100100><2.469500,0.035000,0.100100> rotate<0,44.997030,0> translate<44.291300,-1.535000,44.767500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.608800,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.037500,-1.535000,44.291300>}
box{<0,0,-0.100100><2.020487,0.035000,0.100100> rotate<0,44.997030,0> translate<44.608800,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.085200,0.000000,49.847500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.037500,0.000000,49.847500>}
box{<0,0,-0.100100><0.952300,0.035000,0.100100> rotate<0,0.000000,0> translate<45.085200,0.000000,49.847500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.291100,-1.535000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.037600,-1.535000,24.923900>}
box{<0,0,-0.100000><1.746500,0.035000,0.100000> rotate<0,-0.003280,0> translate<44.291100,-1.535000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.720000,-1.535000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.196200,-1.535000,26.352500>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,-44.997030,0> translate<45.720000,-1.535000,25.876300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.037500,-1.535000,26.193700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.196200,-1.535000,26.352500>}
box{<0,0,-0.100000><0.224506,0.035000,0.100000> rotate<0,-45.015075,0> translate<46.037500,-1.535000,26.193700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.037600,-1.535000,24.923900>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.196300,-1.535000,24.765000>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,45.033108,0> translate<46.037600,-1.535000,24.923900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.037500,0.000000,26.193700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.196300,0.000000,26.352500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.997030,0> translate<46.037500,0.000000,26.193700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.037500,-1.535000,26.193700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.196300,-1.535000,26.352600>}
box{<0,0,-0.100000><0.224648,0.035000,0.100000> rotate<0,-45.015064,0> translate<46.037500,-1.535000,26.193700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.196300,0.000000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.196300,0.000000,31.591300>}
box{<0,0,-0.100000><5.238800,0.035000,0.100000> rotate<0,90.000000,0> translate<46.196300,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.767500,-1.535000,46.196300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.196300,-1.535000,44.767500>}
box{<0,0,-0.100100><2.020628,0.035000,0.100100> rotate<0,44.997030,0> translate<44.767500,-1.535000,46.196300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.878800,0.000000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.196300,0.000000,45.561300>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<45.878800,0.000000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.196300,0.000000,45.561300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.196300,0.000000,47.085300>}
box{<0,0,-0.100100><1.524000,0.035000,0.100100> rotate<0,90.000000,0> translate<46.196300,0.000000,47.085300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.196300,-1.535000,50.800100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.196300,-1.535000,50.800000>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,-90.000000,0> translate<46.196300,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.291300,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.196300,-1.535000,50.800100>}
box{<0,0,-0.203200><1.905000,0.035000,0.203200> rotate<0,-0.003007,0> translate<44.291300,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.196300,0.000000,31.591300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.215300,0.000000,31.610300>}
box{<0,0,-0.100000><0.026870,0.035000,0.100000> rotate<0,-44.997030,0> translate<46.196300,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.215300,0.000000,31.610300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.240700,0.000000,31.610300>}
box{<0,0,-0.100000><0.025400,0.035000,0.100000> rotate<0,0.000000,0> translate<46.215300,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.196300,0.000000,47.085300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.240700,0.000000,47.129700>}
box{<0,0,-0.100100><0.062791,0.035000,0.100100> rotate<0,-44.997030,0> translate<46.196300,0.000000,47.085300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.240700,0.000000,47.129700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.240700,0.000000,47.986900>}
box{<0,0,-0.100000><0.857200,0.035000,0.100000> rotate<0,90.000000,0> translate<46.240700,0.000000,47.986900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.275600,0.000000,42.465600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.275600,0.000000,39.528800>}
box{<0,0,-0.100100><2.936800,0.035000,0.100100> rotate<0,-90.000000,0> translate<46.275600,0.000000,39.528800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.037500,0.000000,42.703800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.275600,0.000000,42.465600>}
box{<0,0,-0.100100><0.336795,0.035000,0.100100> rotate<0,45.009059,0> translate<46.037500,0.000000,42.703800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.100000,0.000000,6.191300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.355000,0.000000,6.191300>}
box{<0,0,-0.100000><8.255000,0.035000,0.100000> rotate<0,0.000000,0> translate<38.100000,0.000000,6.191300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.355000,0.000000,11.480800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.355000,0.000000,11.430000>}
box{<0,0,-0.203200><0.050800,0.035000,0.203200> rotate<0,-90.000000,0> translate<46.355000,0.000000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.355000,0.000000,13.176200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.355000,0.000000,11.480800>}
box{<0,0,-0.203200><1.695400,0.035000,0.203200> rotate<0,-90.000000,0> translate<46.355000,0.000000,11.480800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.355000,-1.535000,16.668800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.355000,-1.535000,13.176200>}
box{<0,0,-0.203200><3.492600,0.035000,0.203200> rotate<0,-90.000000,0> translate<46.355000,-1.535000,13.176200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.878800,-1.535000,17.145000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.355000,-1.535000,16.668800>}
box{<0,0,-0.203200><0.673448,0.035000,0.203200> rotate<0,44.997030,0> translate<45.878800,-1.535000,17.145000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,0.000000,20.955000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,0.000000,21.539200>}
box{<0,0,-0.100100><0.584200,0.035000,0.100100> rotate<0,90.000000,0> translate<46.355000,0.000000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.196300,-1.535000,26.352600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.355000,-1.535000,26.511300>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<46.196300,-1.535000,26.352600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.640600,0.000000,39.131900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,0.000000,38.417500>}
box{<0,0,-0.100100><1.010314,0.035000,0.100100> rotate<0,44.997030,0> translate<45.640600,0.000000,39.131900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.878800,-1.535000,43.815000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,-1.535000,43.815000>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,0.000000,0> translate<45.878800,-1.535000,43.815000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.926300,-1.535000,46.672500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,-1.535000,45.243800>}
box{<0,0,-0.100100><2.020487,0.035000,0.100100> rotate<0,44.997030,0> translate<44.926300,-1.535000,46.672500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.878800,-1.535000,58.261300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,-1.535000,58.261300>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,0.000000,0> translate<45.878800,-1.535000,58.261300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,-1.535000,60.166300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,-1.535000,62.280800>}
box{<0,0,-0.100100><2.114500,0.035000,0.100100> rotate<0,90.000000,0> translate<46.355000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,0.000000,67.627600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,0.000000,67.627500>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,-90.000000,0> translate<46.355000,0.000000,67.627500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.878800,0.000000,68.103800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,0.000000,67.627600>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,44.997030,0> translate<45.878800,0.000000,68.103800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,-1.535000,67.627500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,-1.535000,70.485000>}
box{<0,0,-0.100100><2.857500,0.035000,0.100100> rotate<0,90.000000,0> translate<46.355000,-1.535000,70.485000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,-1.535000,70.485000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,-1.535000,72.339200>}
box{<0,0,-0.100100><1.854200,0.035000,0.100100> rotate<0,90.000000,0> translate<46.355000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,-1.535000,43.815000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513700,-1.535000,43.656300>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.997030,0> translate<46.355000,-1.535000,43.815000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<41.116300,-1.535000,51.593800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513700,-1.535000,51.593800>}
box{<0,0,-0.100100><5.397400,0.035000,0.100100> rotate<0,0.000000,0> translate<41.116300,-1.535000,51.593800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.561300,0.000000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.513800,0.000000,24.130000>}
box{<0,0,-0.100000><1.347038,0.035000,0.100000> rotate<0,44.997030,0> translate<45.561300,0.000000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513700,-1.535000,43.656300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513800,-1.535000,43.656300>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,0.000000,0> translate<46.513700,-1.535000,43.656300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.037500,-1.535000,44.291300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513800,-1.535000,44.291300>}
box{<0,0,-0.100100><0.476300,0.035000,0.100100> rotate<0,0.000000,0> translate<46.037500,-1.535000,44.291300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.291300,0.000000,44.608800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513800,0.000000,44.608800>}
box{<0,0,-0.100100><2.222500,0.035000,0.100100> rotate<0,0.000000,0> translate<44.291300,0.000000,44.608800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.085000,-1.535000,47.148800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513800,-1.535000,45.720000>}
box{<0,0,-0.100100><2.020628,0.035000,0.100100> rotate<0,44.997030,0> translate<45.085000,-1.535000,47.148800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.402500,0.000000,58.896300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513800,0.000000,60.007500>}
box{<0,0,-0.100100><1.571545,0.035000,0.100100> rotate<0,-44.994452,0> translate<45.402500,0.000000,58.896300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,-1.535000,60.166300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513800,-1.535000,60.007500>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<46.355000,-1.535000,60.166300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.243800,0.000000,71.278800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513800,0.000000,72.548800>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,-44.997030,0> translate<45.243800,0.000000,71.278800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.570000,-1.535000,37.203800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.570000,-1.535000,35.401300>}
box{<0,0,-0.203200><1.802500,0.035000,0.203200> rotate<0,-90.000000,0> translate<46.570000,-1.535000,35.401300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.570000,-1.535000,36.138800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.570000,-1.535000,37.782600>}
box{<0,0,-0.203200><1.643800,0.035000,0.203200> rotate<0,90.000000,0> translate<46.570000,-1.535000,37.782600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<38.258800,0.000000,6.667500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.672500,0.000000,6.667500>}
box{<0,0,-0.100000><8.413700,0.035000,0.100000> rotate<0,0.000000,0> translate<38.258800,0.000000,6.667500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.672500,-1.535000,20.002500>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,-44.997030,0> translate<45.720000,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.513800,0.000000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.672500,0.000000,24.130000>}
box{<0,0,-0.100000><0.158700,0.035000,0.100000> rotate<0,0.000000,0> translate<46.513800,0.000000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.720000,0.000000,25.558800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.672500,0.000000,24.606300>}
box{<0,0,-0.100000><1.347038,0.035000,0.100000> rotate<0,44.997030,0> translate<45.720000,0.000000,25.558800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.449900,-1.535000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.672500,-1.535000,25.400000>}
box{<0,0,-0.100000><2.222600,0.035000,0.100000> rotate<0,0.000000,0> translate<44.449900,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.570000,-1.535000,35.401300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.672500,-1.535000,36.036300>}
box{<0,0,-0.203200><0.643219,0.035000,0.203200> rotate<0,-80.825227,0> translate<46.570000,-1.535000,35.401300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.570000,-1.535000,36.138800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.672500,-1.535000,36.036300>}
box{<0,0,-0.203200><0.144957,0.035000,0.203200> rotate<0,44.997030,0> translate<46.570000,-1.535000,36.138800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.570000,-1.535000,37.203800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.672500,-1.535000,37.147600>}
box{<0,0,-0.203200><0.116896,0.035000,0.203200> rotate<0,28.733740,0> translate<46.570000,-1.535000,37.203800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513800,-1.535000,44.291300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.672500,-1.535000,44.132500>}
box{<0,0,-0.100100><0.224506,0.035000,0.100100> rotate<0,45.015075,0> translate<46.513800,-1.535000,44.291300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.196300,-1.535000,44.767500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.672500,-1.535000,44.767500>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,0.000000,0> translate<46.196300,-1.535000,44.767500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.291200,0.000000,64.611300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.672500,0.000000,64.611300>}
box{<0,0,-0.100100><2.381300,0.035000,0.100100> rotate<0,0.000000,0> translate<44.291200,0.000000,64.611300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.751900,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.751900,-1.535000,40.322300>}
box{<0,0,-0.100100><1.587700,0.035000,0.100100> rotate<0,-90.000000,0> translate<46.751900,-1.535000,40.322300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.751900,-1.535000,43.418100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.751900,-1.535000,42.862500>}
box{<0,0,-0.100100><0.555600,0.035000,0.100100> rotate<0,-90.000000,0> translate<46.751900,-1.535000,42.862500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513800,-1.535000,43.656300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.751900,-1.535000,43.418100>}
box{<0,0,-0.100100><0.336795,0.035000,0.100100> rotate<0,45.009059,0> translate<46.513800,-1.535000,43.656300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.751900,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.752000,-1.535000,42.703800>}
box{<0,0,-0.100100><0.793800,0.035000,0.100100> rotate<0,-89.986843,0> translate<46.751900,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.751900,-1.535000,42.862500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.752000,-1.535000,42.703800>}
box{<0,0,-0.100100><0.158700,0.035000,0.100100> rotate<0,89.957960,0> translate<46.751900,-1.535000,42.862500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,-1.535000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831200,-1.535000,45.243800>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,0.000000,0> translate<46.355000,-1.535000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.275600,0.000000,39.528800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831300,0.000000,38.973100>}
box{<0,0,-0.100100><0.785878,0.035000,0.100100> rotate<0,44.997030,0> translate<46.275600,0.000000,39.528800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.450000,0.000000,44.132500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831300,0.000000,44.132500>}
box{<0,0,-0.100100><2.381300,0.035000,0.100100> rotate<0,0.000000,0> translate<44.450000,0.000000,44.132500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.831300,-1.535000,50.165000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.831300,-1.535000,49.688800>}
box{<0,0,-0.203200><0.476200,0.035000,0.203200> rotate<0,-90.000000,0> translate<46.831300,-1.535000,49.688800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.196300,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.831300,-1.535000,50.165000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<46.196300,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.720000,0.000000,50.323800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831300,0.000000,51.434900>}
box{<0,0,-0.100100><1.571474,0.035000,0.100100> rotate<0,-44.991874,0> translate<45.720000,0.000000,50.323800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831300,0.000000,51.434900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831300,0.000000,53.498800>}
box{<0,0,-0.100100><2.063900,0.035000,0.100100> rotate<0,90.000000,0> translate<46.831300,0.000000,53.498800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831300,0.000000,53.498800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831300,0.000000,58.420000>}
box{<0,0,-0.100100><4.921200,0.035000,0.100100> rotate<0,90.000000,0> translate<46.831300,0.000000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.878800,0.000000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831300,0.000000,59.372500>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,-44.997030,0> translate<45.878800,0.000000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.132500,-1.535000,38.893800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.831400,-1.535000,38.893800>}
box{<0,0,-0.100000><2.698900,0.035000,0.100000> rotate<0,0.000000,0> translate<44.132500,-1.535000,38.893800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.831300,-1.535000,38.893700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.831400,-1.535000,38.893800>}
box{<0,0,-0.100000><0.000141,0.035000,0.100000> rotate<0,-44.997030,0> translate<46.831300,-1.535000,38.893700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.672500,-1.535000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.989900,-1.535000,25.717400>}
box{<0,0,-0.100000><0.448871,0.035000,0.100000> rotate<0,-44.997030,0> translate<46.672500,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.831300,-1.535000,25.558800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.989900,-1.535000,25.717500>}
box{<0,0,-0.100000><0.224365,0.035000,0.100000> rotate<0,-45.015086,0> translate<46.831300,-1.535000,25.558800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.989900,-1.535000,25.717400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.989900,-1.535000,25.717500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,90.000000,0> translate<46.989900,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,0.000000,2.540000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.990000,0.000000,1.270000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<45.720000,0.000000,2.540000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,5.556300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,3.810000>}
box{<0,0,-0.100000><1.746300,0.035000,0.100000> rotate<0,-90.000000,0> translate<46.990000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.355000,0.000000,6.191300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,5.556300>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<46.355000,0.000000,6.191300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.720000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990000,-1.535000,6.350000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,-44.997030,0> translate<45.720000,-1.535000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.672500,0.000000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,23.812500>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<46.672500,0.000000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,22.542600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,23.812500>}
box{<0,0,-0.100000><1.269900,0.035000,0.100000> rotate<0,90.000000,0> translate<46.990000,0.000000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.672500,0.000000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,24.606300>}
box{<0,0,-0.100000><0.317500,0.035000,0.100000> rotate<0,0.000000,0> translate<46.672500,0.000000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.831300,0.000000,25.558800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,25.717500>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<46.831300,0.000000,25.558800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,31.591300>}
box{<0,0,-0.100000><5.873800,0.035000,0.100000> rotate<0,90.000000,0> translate<46.990000,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513800,0.000000,44.608800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990000,0.000000,45.084900>}
box{<0,0,-0.100100><0.673378,0.035000,0.100100> rotate<0,-44.991014,0> translate<46.513800,0.000000,44.608800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513800,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990000,-1.535000,45.720000>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,0.000000,0> translate<46.513800,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990000,0.000000,45.084900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990000,0.000000,47.167800>}
box{<0,0,-0.100100><2.082900,0.035000,0.100100> rotate<0,90.000000,0> translate<46.990000,0.000000,47.167800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,47.167800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,48.101300>}
box{<0,0,-0.100000><0.933500,0.035000,0.100000> rotate<0,90.000000,0> translate<46.990000,0.000000,48.101300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,-1.535000,58.261300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990000,-1.535000,57.626300>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<46.355000,-1.535000,58.261300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990000,-1.535000,53.657500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990000,-1.535000,57.626300>}
box{<0,0,-0.100100><3.968800,0.035000,0.100100> rotate<0,90.000000,0> translate<46.990000,-1.535000,57.626300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180100,-1.535000,74.136300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990000,-1.535000,74.136300>}
box{<0,0,-0.100100><3.809900,0.035000,0.100100> rotate<0,0.000000,0> translate<43.180100,-1.535000,74.136300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.656300,0.000000,32.861300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990100,0.000000,32.861300>}
box{<0,0,-0.100100><3.333800,0.035000,0.100100> rotate<0,0.000000,0> translate<43.656300,0.000000,32.861300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.751900,-1.535000,40.322300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990100,-1.535000,40.084400>}
box{<0,0,-0.100100><0.336654,0.035000,0.100100> rotate<0,44.960929,0> translate<46.751900,-1.535000,40.322300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,31.591300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.009000,0.000000,31.610300>}
box{<0,0,-0.100000><0.026870,0.035000,0.100000> rotate<0,-44.997030,0> translate<46.990000,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.009000,0.000000,31.610300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.028100,0.000000,31.610300>}
box{<0,0,-0.100000><0.019100,0.035000,0.100000> rotate<0,0.000000,0> translate<47.009000,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,47.167800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.028100,0.000000,47.129700>}
box{<0,0,-0.100000><0.053882,0.035000,0.100000> rotate<0,44.997030,0> translate<46.990000,0.000000,47.167800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.989900,-1.535000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.148700,-1.535000,25.876300>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.997030,0> translate<46.989900,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.148700,-1.535000,45.561300>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.997030,0> translate<46.990000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.243800,-1.535000,52.228800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.148700,-1.535000,52.228800>}
box{<0,0,-0.203200><1.904900,0.035000,0.203200> rotate<0,0.000000,0> translate<45.243800,-1.535000,52.228800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831300,0.000000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.148700,0.000000,58.578700>}
box{<0,0,-0.100100><0.354864,0.035000,0.100100> rotate<0,-26.563298,0> translate<46.831300,0.000000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.148700,0.000000,58.578700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.148700,0.000000,58.578800>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<47.148700,0.000000,58.578800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,0.000000,70.485000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.148700,0.000000,70.485000>}
box{<0,0,-0.100100><0.793700,0.035000,0.100100> rotate<0,0.000000,0> translate<46.355000,0.000000,70.485000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,22.542600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.148800,0.000000,22.383800>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<46.990000,0.000000,22.542600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.148800,0.000000,22.383700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.148800,0.000000,22.383800>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,90.000000,0> translate<47.148800,0.000000,22.383800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.132500,-1.535000,29.368800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.148800,-1.535000,29.368800>}
box{<0,0,-0.100100><3.016300,0.035000,0.100100> rotate<0,0.000000,0> translate<44.132500,-1.535000,29.368800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.148700,-1.535000,45.561300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.148800,-1.535000,45.561300>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,0.000000,0> translate<47.148700,-1.535000,45.561300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.240700,0.000000,47.986900>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.148800,0.000000,48.895000>}
box{<0,0,-0.100000><1.284247,0.035000,0.100000> rotate<0,-44.997030,0> translate<46.240700,0.000000,47.986900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.228100,-1.535000,43.576900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.228100,-1.535000,41.195700>}
box{<0,0,-0.100100><2.381200,0.035000,0.100100> rotate<0,-90.000000,0> translate<47.228100,-1.535000,41.195700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.672500,-1.535000,44.132500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.228100,-1.535000,43.576900>}
box{<0,0,-0.100100><0.785737,0.035000,0.100100> rotate<0,44.997030,0> translate<46.672500,-1.535000,44.132500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.355000,-1.535000,26.511300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.307500,-1.535000,26.511300>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,0.000000,0> translate<46.355000,-1.535000,26.511300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.021300,-1.535000,28.892500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.307500,-1.535000,28.892500>}
box{<0,0,-0.100100><4.286200,0.035000,0.100100> rotate<0,0.000000,0> translate<43.021300,-1.535000,28.892500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,48.101300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.307500,0.000000,48.418800>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<46.990000,0.000000,48.101300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.386300,-1.535000,70.485000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.307500,-1.535000,65.563800>}
box{<0,0,-0.100100><6.959628,0.035000,0.100100> rotate<0,44.997030,0> translate<42.386300,-1.535000,70.485000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990000,0.000000,74.136300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.307500,0.000000,74.453800>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<46.990000,0.000000,74.136300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990100,0.000000,40.084400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.310700,0.000000,39.763700>}
box{<0,0,-0.100100><0.453468,0.035000,0.100100> rotate<0,45.005964,0> translate<46.990100,0.000000,40.084400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831300,0.000000,38.973100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.383700,0.000000,38.976300>}
box{<0,0,-0.100100><0.552409,0.035000,0.100100> rotate<0,-0.331883,0> translate<46.831300,0.000000,38.973100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466200,-1.535000,13.176300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466200,-1.535000,18.891300>}
box{<0,0,-0.100100><5.715000,0.035000,0.100100> rotate<0,90.000000,0> translate<47.466200,-1.535000,18.891300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466200,0.000000,13.176300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,0.000000,10.318900>}
box{<0,0,-0.100100><2.857400,0.035000,0.100100> rotate<0,89.992055,0> translate<47.466200,0.000000,13.176300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,0.000000,20.955000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,0.000000,20.955000>}
box{<0,0,-0.100100><1.111300,0.035000,0.100100> rotate<0,0.000000,0> translate<46.355000,0.000000,20.955000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466200,0.000000,18.891300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,0.000000,20.955000>}
box{<0,0,-0.100100><2.063700,0.035000,0.100100> rotate<0,-89.991284,0> translate<47.466200,0.000000,18.891300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.243800,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.466300,-1.535000,23.177500>}
box{<0,0,-0.100000><2.222500,0.035000,0.100000> rotate<0,0.000000,0> translate<45.243800,-1.535000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.466300,0.000000,24.130000>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,44.997030,0> translate<46.990000,0.000000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.466300,0.000000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.466300,0.000000,24.130000>}
box{<0,0,-0.100000><1.270000,0.035000,0.100000> rotate<0,90.000000,0> translate<47.466300,0.000000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.196300,-1.535000,24.765000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.466300,-1.535000,24.765000>}
box{<0,0,-0.100000><1.270000,0.035000,0.100000> rotate<0,0.000000,0> translate<46.196300,-1.535000,24.765000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.307500,-1.535000,26.511300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.466300,-1.535000,26.352500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<47.307500,-1.535000,26.511300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.815000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,-1.535000,27.940000>}
box{<0,0,-0.100100><3.651300,0.035000,0.100100> rotate<0,0.000000,0> translate<43.815000,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.338900,-1.535000,28.416300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,-1.535000,28.416300>}
box{<0,0,-0.100100><4.127400,0.035000,0.100100> rotate<0,0.000000,0> translate<43.338900,-1.535000,28.416300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,-1.535000,28.416300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,-1.535000,28.416400>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<47.466300,-1.535000,28.416400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.148700,-1.535000,58.578800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,-1.535000,59.055100>}
box{<0,0,-0.100100><0.572478,0.035000,0.100100> rotate<0,-56.300665,0> translate<47.148700,-1.535000,58.578800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,-1.535000,59.055100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,-1.535000,62.122100>}
box{<0,0,-0.100100><3.067000,0.035000,0.100100> rotate<0,90.000000,0> translate<47.466300,-1.535000,62.122100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.466300,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.625000,-1.535000,23.018800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<47.466300,-1.535000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831300,0.000000,44.132500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.625000,0.000000,44.926300>}
box{<0,0,-0.100100><1.122532,0.035000,0.100100> rotate<0,-45.000639,0> translate<46.831300,0.000000,44.132500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.148700,-1.535000,52.228800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.625000,-1.535000,51.752500>}
box{<0,0,-0.203200><0.673590,0.035000,0.203200> rotate<0,44.997030,0> translate<47.148700,-1.535000,52.228800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,-1.535000,62.122100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.625000,-1.535000,62.280800>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,-44.997030,0> translate<47.466300,-1.535000,62.122100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.625000,-1.535000,71.120000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.625000,-1.535000,72.339200>}
box{<0,0,-0.100100><1.219200,0.035000,0.100100> rotate<0,90.000000,0> translate<47.625000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.466300,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.625100,-1.535000,27.940000>}
box{<0,0,-0.100000><0.158800,0.035000,0.100000> rotate<0,0.000000,0> translate<47.466300,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370100,0.000000,36.988800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.625100,0.000000,36.988800>}
box{<0,0,-0.203200><8.255000,0.035000,0.203200> rotate<0,0.000000,0> translate<39.370100,0.000000,36.988800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.625000,0.000000,44.926300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.625100,0.000000,45.561400>}
box{<0,0,-0.100100><0.635100,0.035000,0.100100> rotate<0,-89.985039,0> translate<47.625000,0.000000,44.926300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.228100,-1.535000,41.195700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.704400,-1.535000,40.719300>}
box{<0,0,-0.100100><0.673661,0.035000,0.100100> rotate<0,45.003044,0> translate<47.228100,-1.535000,41.195700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.704400,-1.535000,43.735600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.704400,-1.535000,42.068900>}
box{<0,0,-0.100100><1.666700,0.035000,0.100100> rotate<0,-90.000000,0> translate<47.704400,-1.535000,42.068900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.672500,-1.535000,44.767500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.704400,-1.535000,43.735600>}
box{<0,0,-0.100100><1.459327,0.035000,0.100100> rotate<0,44.997030,0> translate<46.672500,-1.535000,44.767500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.704400,0.000000,40.719300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.704500,0.000000,40.719300>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,0.000000,0> translate<47.704400,0.000000,40.719300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.608800,-1.535000,27.463800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.783700,-1.535000,27.463800>}
box{<0,0,-0.100000><3.174900,0.035000,0.100000> rotate<0,0.000000,0> translate<44.608800,-1.535000,27.463800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513700,-1.535000,51.593800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783700,-1.535000,50.323800>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<46.513700,-1.535000,51.593800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,0.000000,10.318900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783800,0.000000,10.001300>}
box{<0,0,-0.100100><0.449084,0.035000,0.100100> rotate<0,45.006051,0> translate<47.466300,0.000000,10.318900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.607500,0.000000,14.287500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.783800,0.000000,14.128800>}
box{<0,0,-0.100000><13.177256,0.035000,0.100000> rotate<0,0.690012,0> translate<34.607500,0.000000,14.287500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.766200,0.000000,14.763800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.783800,0.000000,14.763800>}
box{<0,0,-0.100000><13.017600,0.035000,0.100000> rotate<0,0.000000,0> translate<34.766200,0.000000,14.763800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.466300,-1.535000,24.765000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.783800,-1.535000,25.082500>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<47.466300,-1.535000,24.765000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.783800,0.000000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.783800,0.000000,31.591300>}
box{<0,0,-0.100000><6.508800,0.035000,0.100000> rotate<0,90.000000,0> translate<47.783800,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990100,0.000000,32.861300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783800,0.000000,33.655000>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,-44.997030,0> translate<46.990100,0.000000,32.861300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783700,0.000000,34.924900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783800,0.000000,34.766300>}
box{<0,0,-0.100100><0.158600,0.035000,0.100100> rotate<0,89.957937,0> translate<47.783700,0.000000,34.924900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783800,0.000000,33.655000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783800,0.000000,34.766300>}
box{<0,0,-0.100100><1.111300,0.035000,0.100100> rotate<0,90.000000,0> translate<47.783800,0.000000,34.766300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.672500,-1.535000,37.147600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.783800,-1.535000,37.147500>}
box{<0,0,-0.203200><1.111300,0.035000,0.203200> rotate<0,0.005155,0> translate<46.672500,-1.535000,37.147600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.625100,0.000000,36.988800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.783800,0.000000,37.147500>}
box{<0,0,-0.203200><0.224436,0.035000,0.203200> rotate<0,-44.997030,0> translate<47.625100,0.000000,36.988800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.783800,-1.535000,47.466300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.783800,-1.535000,47.466200>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,-90.000000,0> translate<47.783800,-1.535000,47.466200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.783800,-1.535000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.783800,-1.535000,47.466300>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,-90.000000,0> translate<47.783800,-1.535000,47.466300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.831300,-1.535000,49.688800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.783800,-1.535000,48.736300>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,44.997030,0> translate<46.831300,-1.535000,49.688800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783700,-1.535000,50.323800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783800,-1.535000,50.323800>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,0.000000,0> translate<47.783700,-1.535000,50.323800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.180000,-1.535000,74.930000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783800,-1.535000,74.930000>}
box{<0,0,-0.100100><4.603800,0.035000,0.100100> rotate<0,0.000000,0> translate<43.180000,-1.535000,74.930000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.783800,0.000000,31.591300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.802800,0.000000,31.610300>}
box{<0,0,-0.100000><0.026870,0.035000,0.100000> rotate<0,-44.997030,0> translate<47.783800,0.000000,31.591300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.802800,0.000000,31.610300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.815500,0.000000,31.610300>}
box{<0,0,-0.100000><0.012700,0.035000,0.100000> rotate<0,0.000000,0> translate<47.802800,0.000000,31.610300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.704500,0.000000,40.719300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.872800,0.000000,40.551100>}
box{<0,0,-0.100100><0.237941,0.035000,0.100100> rotate<0,44.980004,0> translate<47.704500,0.000000,40.719300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<34.925000,0.000000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.942500,0.000000,15.240000>}
box{<0,0,-0.100000><13.017500,0.035000,0.100000> rotate<0,0.000000,0> translate<34.925000,0.000000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.672500,-1.535000,20.002500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.942500,-1.535000,20.002500>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,0.000000,0> translate<46.672500,-1.535000,20.002500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,-1.535000,28.416400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.942500,-1.535000,28.892500>}
box{<0,0,-0.100100><0.673378,0.035000,0.100100> rotate<0,-44.991014,0> translate<47.466300,-1.535000,28.416400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.037500,0.000000,49.847500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.942500,0.000000,51.752400>}
box{<0,0,-0.100100><2.694006,0.035000,0.100100> rotate<0,-44.995526,0> translate<46.037500,0.000000,49.847500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990000,-1.535000,53.657500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.942500,-1.535000,52.705000>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,44.997030,0> translate<46.990000,-1.535000,53.657500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.942500,0.000000,51.752400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.942500,0.000000,52.705000>}
box{<0,0,-0.100100><0.952600,0.035000,0.100100> rotate<0,90.000000,0> translate<47.942500,0.000000,52.705000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.148700,0.000000,70.485000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.942500,0.000000,71.278800>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,-44.997030,0> translate<47.148700,0.000000,70.485000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.148800,-1.535000,45.561300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.942600,-1.535000,44.767600>}
box{<0,0,-0.100100><1.122532,0.035000,0.100100> rotate<0,44.993421,0> translate<47.148800,-1.535000,45.561300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.783700,-1.535000,27.463800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.101100,-1.535000,27.781300>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,-45.006054,0> translate<47.783700,-1.535000,27.463800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.783800,-1.535000,47.466200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.101100,-1.535000,47.148800>}
box{<0,0,-0.203200><0.448801,0.035000,0.203200> rotate<0,45.006057,0> translate<47.783800,-1.535000,47.466200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.370000,0.000000,7.143800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.101200,0.000000,7.143800>}
box{<0,0,-0.100000><8.731200,0.035000,0.100000> rotate<0,0.000000,0> translate<39.370000,0.000000,7.143800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.148700,-1.535000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.101200,-1.535000,25.876300>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,0.000000,0> translate<47.148700,-1.535000,25.876300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.625100,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.101200,-1.535000,28.416300>}
box{<0,0,-0.100000><0.673449,0.035000,0.100000> rotate<0,-45.009061,0> translate<47.625100,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<35.242500,0.000000,15.716300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.101300,0.000000,15.716300>}
box{<0,0,-0.100000><12.858800,0.035000,0.100000> rotate<0,0.000000,0> translate<35.242500,0.000000,15.716300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.307500,-1.535000,28.892500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.101300,-1.535000,29.686300>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,-44.997030,0> translate<47.307500,-1.535000,28.892500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<42.862500,0.000000,60.801300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.101300,0.000000,60.801300>}
box{<0,0,-0.100100><5.238800,0.035000,0.100100> rotate<0,0.000000,0> translate<42.862500,0.000000,60.801300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.180600,-1.535000,43.894300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.180600,-1.535000,42.783100>}
box{<0,0,-0.100100><1.111200,0.035000,0.100100> rotate<0,-90.000000,0> translate<48.180600,-1.535000,42.783100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831200,-1.535000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.180600,-1.535000,43.894300>}
box{<0,0,-0.100100><1.908410,0.035000,0.100100> rotate<0,44.999153,0> translate<46.831200,-1.535000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.815500,0.000000,47.129700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.240900,0.000000,47.129700>}
box{<0,0,-0.203200><0.425400,0.035000,0.203200> rotate<0,0.000000,0> translate<47.815500,0.000000,47.129700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.704400,-1.535000,42.068900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.259900,-1.535000,41.513100>}
box{<0,0,-0.100100><0.785808,0.035000,0.100100> rotate<0,45.012496,0> translate<47.704400,-1.535000,42.068900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.990000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,0.000000,2.540000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<46.990000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.672500,0.000000,6.667500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,0.000000,5.080000>}
box{<0,0,-0.100000><2.245064,0.035000,0.100000> rotate<0,44.997030,0> translate<46.672500,0.000000,6.667500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<40.640000,0.000000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,0.000000,7.620000>}
box{<0,0,-0.100000><7.620000,0.035000,0.100000> rotate<0,0.000000,0> translate<40.640000,0.000000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<37.941300,0.000000,16.192500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,0.000000,16.192500>}
box{<0,0,-0.100000><10.318700,0.035000,0.100000> rotate<0,0.000000,0> translate<37.941300,0.000000,16.192500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.625000,-1.535000,23.018800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,-1.535000,23.018800>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,0.000000,0> translate<47.625000,-1.535000,23.018800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,0.000000,23.018800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,0.000000,24.606200>}
box{<0,0,-0.100000><1.587400,0.035000,0.100000> rotate<0,90.000000,0> translate<48.260000,0.000000,24.606200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.101200,-1.535000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,-1.535000,25.717500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<48.101200,-1.535000,25.876300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.466300,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,-1.535000,26.352500>}
box{<0,0,-0.100000><0.793700,0.035000,0.100000> rotate<0,0.000000,0> translate<47.466300,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.402400,-1.535000,26.987500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,-1.535000,26.987500>}
box{<0,0,-0.100000><2.857600,0.035000,0.100000> rotate<0,0.000000,0> translate<45.402400,-1.535000,26.987500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.783800,-1.535000,47.466300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,46.990200>}
box{<0,0,-0.203200><0.673378,0.035000,0.203200> rotate<0,44.991014,0> translate<47.783800,-1.535000,47.466300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.101100,-1.535000,47.148800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,46.990200>}
box{<0,0,-0.203200><0.224507,0.035000,0.203200> rotate<0,44.942896,0> translate<48.101100,-1.535000,47.148800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,46.990200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,47.148800>}
box{<0,0,-0.203200><0.158600,0.035000,0.203200> rotate<0,90.000000,0> translate<48.260000,-1.535000,47.148800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831300,0.000000,53.498800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.260000,0.000000,53.498800>}
box{<0,0,-0.100100><1.428700,0.035000,0.100100> rotate<0,0.000000,0> translate<46.831300,0.000000,53.498800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,0.000000,54.451300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,0.000000,54.610000>}
box{<0,0,-0.100000><0.158700,0.035000,0.100000> rotate<0,90.000000,0> translate<48.260000,0.000000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<40.957500,0.000000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.260000,0.000000,68.580000>}
box{<0,0,-0.100100><7.302500,0.035000,0.100100> rotate<0,0.000000,0> translate<40.957500,0.000000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.625000,-1.535000,71.120000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.260000,-1.535000,70.485000>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<47.625000,-1.535000,71.120000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.260000,-1.535000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.260000,-1.535000,70.485000>}
box{<0,0,-0.100100><1.905000,0.035000,0.100100> rotate<0,90.000000,0> translate<48.260000,-1.535000,70.485000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260100,0.000000,14.287500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260100,0.000000,14.287400>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,-90.000000,0> translate<48.260100,0.000000,14.287400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.783800,0.000000,14.763800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260100,0.000000,14.287500>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,44.997030,0> translate<47.783800,0.000000,14.763800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.831300,0.000000,59.372500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.260100,0.000000,59.372500>}
box{<0,0,-0.100100><1.428800,0.035000,0.100100> rotate<0,0.000000,0> translate<46.831300,0.000000,59.372500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.942600,-1.535000,44.767600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.339400,-1.535000,44.767600>}
box{<0,0,-0.100100><0.396800,0.035000,0.100100> rotate<0,0.000000,0> translate<47.942600,-1.535000,44.767600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.370000,0.000000,16.668800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418700,0.000000,16.668800>}
box{<0,0,-0.100000><9.048700,0.035000,0.100000> rotate<0,0.000000,0> translate<39.370000,0.000000,16.668800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,-1.535000,26.987500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418700,-1.535000,26.828800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<48.260000,-1.535000,26.987500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.783800,0.000000,14.128800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418800,0.000000,13.493800>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<47.783800,0.000000,14.128800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.466300,-1.535000,20.955000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.418800,-1.535000,20.955000>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,0.000000,0> translate<47.466300,-1.535000,20.955000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.878800,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418800,-1.535000,23.812500>}
box{<0,0,-0.100000><2.540000,0.035000,0.100000> rotate<0,0.000000,0> translate<45.878800,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,0.000000,24.606200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418800,0.000000,24.765100>}
box{<0,0,-0.100000><0.224648,0.035000,0.100000> rotate<0,-45.015064,0> translate<48.260000,0.000000,24.606200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,-1.535000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418800,-1.535000,25.558800>}
box{<0,0,-0.100000><0.224506,0.035000,0.100000> rotate<0,44.978985,0> translate<48.260000,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.148800,-1.535000,29.368800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.418800,-1.535000,30.638800>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,-44.997030,0> translate<47.148800,-1.535000,29.368800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418800,0.000000,25.558700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418800,0.000000,34.607500>}
box{<0,0,-0.100000><9.048800,0.035000,0.100000> rotate<0,90.000000,0> translate<48.418800,0.000000,34.607500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.783800,0.000000,37.147500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.418800,0.000000,37.147600>}
box{<0,0,-0.203200><0.635000,0.035000,0.203200> rotate<0,-0.009022,0> translate<47.783800,0.000000,37.147500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.259900,0.000000,41.513100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.418800,0.000000,41.354400>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.960952,0> translate<48.259900,0.000000,41.513100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.180600,-1.535000,42.783100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.418800,-1.535000,42.545000>}
box{<0,0,-0.100100><0.336795,0.035000,0.100100> rotate<0,44.985002,0> translate<48.180600,-1.535000,42.783100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.307500,-1.535000,65.563800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.418800,-1.535000,65.563800>}
box{<0,0,-0.100100><1.111300,0.035000,0.100100> rotate<0,0.000000,0> translate<47.307500,-1.535000,65.563800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.577500,-1.535000,19.367500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.577500,-1.535000,11.747500>}
box{<0,0,-0.203200><7.620000,0.035000,0.203200> rotate<0,-90.000000,0> translate<48.577500,-1.535000,11.747500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260100,0.000000,14.287400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,13.970000>}
box{<0,0,-0.100000><0.448871,0.035000,0.100000> rotate<0,44.997030,0> translate<48.260100,0.000000,14.287400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<42.862500,0.000000,17.145000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,17.145000>}
box{<0,0,-0.100000><5.715000,0.035000,0.100000> rotate<0,0.000000,0> translate<42.862500,0.000000,17.145000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.942500,-1.535000,20.002500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.577500,-1.535000,19.367500>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<47.942500,-1.535000,20.002500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.148800,0.000000,22.383700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,20.955000>}
box{<0,0,-0.100000><2.020487,0.035000,0.100000> rotate<0,44.997030,0> translate<47.148800,0.000000,22.383700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,20.955000>}
box{<0,0,-0.100000><1.905000,0.035000,0.100000> rotate<0,90.000000,0> translate<48.577500,0.000000,20.955000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418800,0.000000,24.765100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,24.923800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<48.418800,0.000000,24.765100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418800,0.000000,25.558700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,25.400000>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<48.418800,0.000000,25.558700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,25.400000>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,90.000000,0> translate<48.577500,0.000000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,-1.535000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,-1.535000,26.035000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<48.260000,-1.535000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<45.402500,0.000000,37.941300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.577500,0.000000,37.941300>}
box{<0,0,-0.100100><3.175000,0.035000,0.100100> rotate<0,0.000000,0> translate<45.402500,0.000000,37.941300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.243900,0.000000,49.371300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,49.371300>}
box{<0,0,-0.100000><3.333600,0.035000,0.100000> rotate<0,0.000000,0> translate<45.243900,0.000000,49.371300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.942500,0.000000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.736200,0.000000,14.446300>}
box{<0,0,-0.100000><1.122461,0.035000,0.100000> rotate<0,44.997030,0> translate<47.942500,0.000000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,0.000000,16.192500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.736200,0.000000,15.716300>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,44.997030,0> translate<48.260000,0.000000,16.192500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.085000,0.000000,17.621300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.736200,0.000000,17.621300>}
box{<0,0,-0.100000><3.651200,0.035000,0.100000> rotate<0,0.000000,0> translate<45.085000,0.000000,17.621300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418800,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.736200,-1.535000,23.495000>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,45.006054,0> translate<48.418800,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.355000,0.000000,38.417500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.736200,0.000000,38.417500>}
box{<0,0,-0.100100><2.381200,0.035000,0.100100> rotate<0,0.000000,0> translate<46.355000,0.000000,38.417500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.736200,-1.535000,51.752500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.736200,-1.535000,48.577400>}
box{<0,0,-0.203200><3.175100,0.035000,0.203200> rotate<0,-90.000000,0> translate<48.736200,-1.535000,48.577400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<47.625000,-1.535000,51.752500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.736200,-1.535000,51.752500>}
box{<0,0,-0.203200><1.111200,0.035000,0.203200> rotate<0,0.000000,0> translate<47.625000,-1.535000,51.752500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.577500,-1.535000,11.747500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.736300,-1.535000,11.588800>}
box{<0,0,-0.203200><0.224506,0.035000,0.203200> rotate<0,44.978985,0> translate<48.577500,-1.535000,11.747500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.736200,0.000000,15.716300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.736300,0.000000,15.716300>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<48.736200,0.000000,15.716300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.736300,0.000000,44.370700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.736300,0.000000,43.180000>}
box{<0,0,-0.100100><1.190700,0.035000,0.100100> rotate<0,-90.000000,0> translate<48.736300,0.000000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.339400,0.000000,44.767600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.736300,0.000000,44.370700>}
box{<0,0,-0.100100><0.561301,0.035000,0.100100> rotate<0,44.997030,0> translate<48.339400,0.000000,44.767600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.240900,0.000000,47.129700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.736300,0.000000,47.625000>}
box{<0,0,-0.203200><0.700531,0.035000,0.203200> rotate<0,-44.991247,0> translate<48.240900,0.000000,47.129700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,47.148800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.736300,-1.535000,47.625000>}
box{<0,0,-0.203200><0.673519,0.035000,0.203200> rotate<0,-44.991015,0> translate<48.260000,-1.535000,47.148800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783800,0.000000,50.323800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.736300,0.000000,50.323800>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,0.000000,0> translate<47.783800,0.000000,50.323800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.672500,-1.535000,64.611300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.736300,-1.535000,64.611300>}
box{<0,0,-0.100100><2.063800,0.035000,0.100100> rotate<0,0.000000,0> translate<46.672500,-1.535000,64.611300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.736300,-1.535000,11.588800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.755300,-1.535000,11.607800>}
box{<0,0,-0.203200><0.026870,0.035000,0.203200> rotate<0,-44.997030,0> translate<48.736300,-1.535000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.418800,0.000000,42.545000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.838000,0.000000,42.125900>}
box{<0,0,-0.100100><0.592768,0.035000,0.100100> rotate<0,44.990196,0> translate<48.418800,0.000000,42.545000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418800,0.000000,34.607500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.850600,0.000000,35.039300>}
box{<0,0,-0.100000><0.610657,0.035000,0.100000> rotate<0,-44.997030,0> translate<48.418800,0.000000,34.607500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.736200,-1.535000,48.577400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.894800,-1.535000,48.418800>}
box{<0,0,-0.203200><0.224294,0.035000,0.203200> rotate<0,44.997030,0> translate<48.736200,-1.535000,48.577400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,17.145000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.895000,0.000000,16.827500>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<48.577500,0.000000,17.145000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.895000,0.000000,32.067500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.895000,0.000000,32.689800>}
box{<0,0,-0.100000><0.622300,0.035000,0.100000> rotate<0,90.000000,0> translate<48.895000,0.000000,32.689800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783700,-1.535000,34.924900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.895000,-1.535000,36.036200>}
box{<0,0,-0.100100><1.571616,0.035000,0.100100> rotate<0,-44.997030,0> translate<47.783700,-1.535000,34.924900> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.418800,0.000000,37.147600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.895000,0.000000,36.671300>}
box{<0,0,-0.203200><0.673519,0.035000,0.203200> rotate<0,45.003045,0> translate<48.418800,0.000000,37.147600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.895000,-1.535000,36.036200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.895000,-1.535000,40.322500>}
box{<0,0,-0.100100><4.286300,0.035000,0.100100> rotate<0,90.000000,0> translate<48.895000,-1.535000,40.322500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.625100,0.000000,45.561400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.895000,0.000000,46.831300>}
box{<0,0,-0.100100><1.795910,0.035000,0.100100> rotate<0,-44.997030,0> translate<47.625100,0.000000,45.561400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.260100,-1.535000,59.372500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.895000,-1.535000,60.007500>}
box{<0,0,-0.100100><0.897955,0.035000,0.100100> rotate<0,-45.001542,0> translate<48.260100,-1.535000,59.372500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.895000,-1.535000,60.007500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.895000,-1.535000,62.280800>}
box{<0,0,-0.100100><2.273300,0.035000,0.100100> rotate<0,90.000000,0> translate<48.895000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.895000,-1.535000,73.818800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.895000,-1.535000,72.339200>}
box{<0,0,-0.100100><1.479600,0.035000,0.100100> rotate<0,-90.000000,0> translate<48.895000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783800,-1.535000,74.930000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.895000,-1.535000,73.818800>}
box{<0,0,-0.100100><1.571474,0.035000,0.100100> rotate<0,44.997030,0> translate<47.783800,-1.535000,74.930000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.101300,0.000000,15.716300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.895100,0.000000,14.922500>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,44.997030,0> translate<48.101300,0.000000,15.716300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.895000,0.000000,16.827500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.895100,0.000000,16.827500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<48.895000,0.000000,16.827500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.037500,0.000000,18.097500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.895100,0.000000,18.097500>}
box{<0,0,-0.100000><2.857600,0.035000,0.100000> rotate<0,0.000000,0> translate<46.037500,0.000000,18.097500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.736200,0.000000,38.417500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.964900,0.000000,38.188900>}
box{<0,0,-0.100100><0.323360,0.035000,0.100100> rotate<0,44.984502,0> translate<48.736200,0.000000,38.417500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.736300,0.000000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.003000,0.000000,42.913300>}
box{<0,0,-0.100100><0.377171,0.035000,0.100100> rotate<0,44.997030,0> translate<48.736300,0.000000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.736300,0.000000,15.716300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.053800,0.000000,15.398800>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<48.736300,0.000000,15.716300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.466300,0.000000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.053800,0.000000,21.272500>}
box{<0,0,-0.100000><2.245064,0.035000,0.100000> rotate<0,44.997030,0> translate<47.466300,0.000000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.053800,0.000000,19.208800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.053800,0.000000,21.272500>}
box{<0,0,-0.100000><2.063700,0.035000,0.100000> rotate<0,90.000000,0> translate<49.053800,0.000000,21.272500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.037500,-1.535000,24.288800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.053800,-1.535000,24.288800>}
box{<0,0,-0.100000><3.016300,0.035000,0.100000> rotate<0,0.000000,0> translate<46.037500,-1.535000,24.288800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.895000,0.000000,32.067500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.053800,0.000000,31.908700>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<48.895000,0.000000,32.067500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.053800,0.000000,24.288800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.053800,0.000000,31.908700>}
box{<0,0,-0.100000><7.619900,0.035000,0.100000> rotate<0,90.000000,0> translate<49.053800,0.000000,31.908700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.736300,0.000000,50.323800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.053800,0.000000,50.641300>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<48.736300,0.000000,50.323800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.736200,-1.535000,51.752500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.053800,-1.535000,51.752600>}
box{<0,0,-0.203200><0.317600,0.035000,0.203200> rotate<0,-0.018039,0> translate<48.736200,-1.535000,51.752500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.258800,0.000000,61.595000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.053800,0.000000,61.595000>}
box{<0,0,-0.203200><10.795000,0.035000,0.203200> rotate<0,0.000000,0> translate<38.258800,0.000000,61.595000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.577500,0.000000,37.941300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.117300,0.000000,37.401500>}
box{<0,0,-0.100100><0.763392,0.035000,0.100100> rotate<0,44.997030,0> translate<48.577500,0.000000,37.941300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.101100,-1.535000,47.148800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.133100,-1.535000,46.116900>}
box{<0,0,-0.203200><1.459398,0.035000,0.203200> rotate<0,44.994254,0> translate<48.101100,-1.535000,47.148800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418700,0.000000,16.668800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.212500,0.000000,15.875000>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,44.997030,0> translate<48.418700,0.000000,16.668800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.133100,-1.535000,46.116900>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.212500,-1.535000,46.037500>}
box{<0,0,-0.203200><0.112289,0.035000,0.203200> rotate<0,44.997030,0> translate<49.133100,-1.535000,46.116900> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.133100,-1.535000,46.116900>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.212500,-1.535000,46.117100>}
box{<0,0,-0.203200><0.079400,0.035000,0.203200> rotate<0,-0.144312,0> translate<49.133100,-1.535000,46.116900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,49.371300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.212500,0.000000,50.006300>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,-44.997030,0> translate<48.577500,0.000000,49.371300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.212500,0.000000,46.117100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.212600,0.000000,45.481900>}
box{<0,0,-0.203200><0.635200,0.035000,0.203200> rotate<0,89.985041,0> translate<49.212500,0.000000,46.117100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<46.831400,-1.535000,38.893800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.371200,-1.535000,41.433700>}
box{<0,0,-0.100000><3.591890,0.035000,0.100000> rotate<0,-44.998158,0> translate<46.831400,-1.535000,38.893800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.148800,0.000000,48.895000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.371200,0.000000,48.895000>}
box{<0,0,-0.100000><2.222400,0.035000,0.100000> rotate<0,0.000000,0> translate<47.148800,0.000000,48.895000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.895100,0.000000,16.827500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.371300,0.000000,16.351300>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,44.997030,0> translate<48.895100,0.000000,16.827500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.053800,-1.535000,24.288800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.371300,-1.535000,24.288800>}
box{<0,0,-0.100000><0.317500,0.035000,0.100000> rotate<0,0.000000,0> translate<49.053800,-1.535000,24.288800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.942500,-1.535000,28.892500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.371300,-1.535000,28.892400>}
box{<0,0,-0.100000><1.428800,0.035000,0.100000> rotate<0,0.004010,0> translate<47.942500,-1.535000,28.892500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.942500,-1.535000,28.892500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.371300,-1.535000,28.892600>}
box{<0,0,-0.100000><1.428800,0.035000,0.100000> rotate<0,-0.004010,0> translate<47.942500,-1.535000,28.892500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.894800,-1.535000,48.418800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.371300,-1.535000,48.418800>}
box{<0,0,-0.203200><0.476500,0.035000,0.203200> rotate<0,0.000000,0> translate<48.894800,-1.535000,48.418800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.418800,0.000000,41.354400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.450600,0.000000,41.354400>}
box{<0,0,-0.100100><1.031800,0.035000,0.100100> rotate<0,0.000000,0> translate<48.418800,0.000000,41.354400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.212600,0.000000,45.481900>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.450700,0.000000,45.243800>}
box{<0,0,-0.203200><0.336724,0.035000,0.203200> rotate<0,44.997030,0> translate<49.212600,0.000000,45.481900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.530000,0.000000,5.715000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.530000,0.000000,3.810000>}
box{<0,0,-0.100000><1.905000,0.035000,0.100000> rotate<0,-90.000000,0> translate<49.530000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.101200,0.000000,7.143800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.530000,0.000000,5.715000>}
box{<0,0,-0.100000><2.020628,0.035000,0.100000> rotate<0,44.997030,0> translate<48.101200,0.000000,7.143800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.736200,0.000000,17.621300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.530000,0.000000,16.827500>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,44.997030,0> translate<48.736200,0.000000,17.621300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.450600,0.000000,41.354400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.530000,0.000000,41.275000>}
box{<0,0,-0.100100><0.112289,0.035000,0.100100> rotate<0,44.997030,0> translate<49.450600,0.000000,41.354400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.371200,-1.535000,41.433700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.530000,-1.535000,41.592600>}
box{<0,0,-0.100000><0.224648,0.035000,0.100000> rotate<0,-45.015064,0> translate<49.371200,-1.535000,41.433700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.450700,0.000000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,0.000000,45.243800>}
box{<0,0,-0.203200><0.079300,0.035000,0.203200> rotate<0,0.000000,0> translate<49.450700,0.000000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,48.260100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,47.783800>}
box{<0,0,-0.203200><0.476300,0.035000,0.203200> rotate<0,-90.000000,0> translate<49.530000,-1.535000,47.783800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.371300,-1.535000,48.418800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,48.260100>}
box{<0,0,-0.203200><0.224436,0.035000,0.203200> rotate<0,44.997030,0> translate<49.371300,-1.535000,48.418800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.053800,-1.535000,51.752600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,52.228800>}
box{<0,0,-0.203200><0.673448,0.035000,0.203200> rotate<0,-44.997030,0> translate<49.053800,-1.535000,51.752600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,52.228800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,55.245000>}
box{<0,0,-0.203200><3.016200,0.035000,0.203200> rotate<0,90.000000,0> translate<49.530000,-1.535000,55.245000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.260000,0.000000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.530000,0.000000,55.880000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<48.260000,0.000000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.530000,0.000000,54.292500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.530000,0.000000,55.880000>}
box{<0,0,-0.100000><1.587500,0.035000,0.100000> rotate<0,90.000000,0> translate<49.530000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.530000,-1.535000,63.817600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.530000,-1.535000,59.372600>}
box{<0,0,-0.100100><4.445000,0.035000,0.100100> rotate<0,-90.000000,0> translate<49.530000,-1.535000,59.372600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.736300,-1.535000,64.611300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.530000,-1.535000,63.817600>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,44.997030,0> translate<48.736300,-1.535000,64.611300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.736300,0.000000,11.588800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530100,0.000000,10.795000>}
box{<0,0,-0.203200><1.122603,0.035000,0.203200> rotate<0,44.997030,0> translate<48.736300,0.000000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,0.000000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.561700,0.000000,45.275500>}
box{<0,0,-0.203200><0.044831,0.035000,0.203200> rotate<0,-44.997030,0> translate<49.530000,0.000000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,0.000000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.609400,0.000000,45.243800>}
box{<0,0,-0.203200><0.079400,0.035000,0.203200> rotate<0,0.000000,0> translate<49.530000,0.000000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.609400,0.000000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.638000,0.000000,45.243800>}
box{<0,0,-0.203200><0.028600,0.035000,0.203200> rotate<0,0.000000,0> translate<49.609400,0.000000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.609400,0.000000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.641100,0.000000,45.275500>}
box{<0,0,-0.100100><0.044831,0.035000,0.100100> rotate<0,-44.997030,0> translate<49.609400,0.000000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.895000,0.000000,32.689800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.669700,0.000000,33.464500>}
box{<0,0,-0.100000><1.095591,0.035000,0.100000> rotate<0,-44.997030,0> translate<48.895000,0.000000,32.689800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.850600,0.000000,35.039300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.669700,0.000000,35.039300>}
box{<0,0,-0.100000><0.819100,0.035000,0.100000> rotate<0,0.000000,0> translate<48.850600,0.000000,35.039300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.669700,0.000000,35.877500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.669700,0.000000,35.826700>}
box{<0,0,-0.203200><0.050800,0.035000,0.203200> rotate<0,-90.000000,0> translate<49.669700,0.000000,35.826700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.669700,0.000000,36.652200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.669700,0.000000,36.614100>}
box{<0,0,-0.203200><0.038100,0.035000,0.203200> rotate<0,-90.000000,0> translate<49.669700,0.000000,36.614100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.117300,0.000000,37.401500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.669700,0.000000,37.401500>}
box{<0,0,-0.100100><0.552400,0.035000,0.100100> rotate<0,0.000000,0> translate<49.117300,0.000000,37.401500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.964900,0.000000,38.188900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.669700,0.000000,38.188900>}
box{<0,0,-0.100100><0.704800,0.035000,0.100100> rotate<0,0.000000,0> translate<48.964900,0.000000,38.188900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.383700,0.000000,38.976300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.669700,0.000000,38.976300>}
box{<0,0,-0.100100><2.286000,0.035000,0.100100> rotate<0,0.000000,0> translate<47.383700,0.000000,38.976300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.310700,0.000000,39.763700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.669700,0.000000,39.763700>}
box{<0,0,-0.100100><2.359000,0.035000,0.100100> rotate<0,0.000000,0> translate<47.310700,0.000000,39.763700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.872800,0.000000,40.551100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.669700,0.000000,40.551100>}
box{<0,0,-0.100100><1.796900,0.035000,0.100100> rotate<0,0.000000,0> translate<47.872800,0.000000,40.551100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.838000,0.000000,42.125900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.669700,0.000000,42.125900>}
box{<0,0,-0.100100><0.831700,0.035000,0.100100> rotate<0,0.000000,0> translate<48.838000,0.000000,42.125900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.003000,0.000000,42.913300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.669700,0.000000,42.913300>}
box{<0,0,-0.100100><0.666700,0.035000,0.100100> rotate<0,0.000000,0> translate<49.003000,0.000000,42.913300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.669700,0.000000,43.675400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.669700,0.000000,43.700700>}
box{<0,0,-0.203200><0.025300,0.035000,0.203200> rotate<0,90.000000,0> translate<49.669700,0.000000,43.700700> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.561700,0.000000,45.275500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.669700,0.000000,45.275500>}
box{<0,0,-0.203200><0.108000,0.035000,0.203200> rotate<0,0.000000,0> translate<49.561700,0.000000,45.275500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.638000,0.000000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.669700,0.000000,45.275500>}
box{<0,0,-0.203200><0.044831,0.035000,0.203200> rotate<0,-44.997030,0> translate<49.638000,0.000000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.641100,0.000000,45.275500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.669700,0.000000,45.275500>}
box{<0,0,-0.100100><0.028600,0.035000,0.100100> rotate<0,0.000000,0> translate<49.641100,0.000000,45.275500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.530000,0.000000,41.275000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.672900,0.000000,41.338500>}
box{<0,0,-0.100100><0.156373,0.035000,0.100100> rotate<0,-23.957188,0> translate<49.530000,0.000000,41.275000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.625400,0.000000,41.338500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.672900,0.000000,41.338500>}
box{<0,0,-0.100100><0.047500,0.035000,0.100100> rotate<0,0.000000,0> translate<49.625400,0.000000,41.338500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.669700,0.000000,41.338500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.672900,0.000000,41.338500>}
box{<0,0,-0.100100><0.003200,0.035000,0.100100> rotate<0,0.000000,0> translate<49.669700,0.000000,41.338500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<41.751300,0.000000,8.096300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688700,0.000000,8.096300>}
box{<0,0,-0.100000><7.937400,0.035000,0.100000> rotate<0,0.000000,0> translate<41.751300,0.000000,8.096300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.736200,-1.535000,23.495000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688700,-1.535000,23.495000>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,0.000000,0> translate<48.736200,-1.535000,23.495000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.895100,0.000000,18.097500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688800,0.000000,17.303800>}
box{<0,0,-0.100000><1.122461,0.035000,0.100000> rotate<0,44.997030,0> translate<48.895100,0.000000,18.097500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.418800,-1.535000,20.955000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.688800,-1.535000,22.225000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,-44.997030,0> translate<48.418800,-1.535000,20.955000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.371300,-1.535000,24.288800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688800,-1.535000,24.606300>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<49.371300,-1.535000,24.288800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688800,0.000000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688800,0.000000,32.067500>}
box{<0,0,-0.100000><7.143700,0.035000,0.100000> rotate<0,90.000000,0> translate<49.688800,0.000000,32.067500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.815100,0.000000,35.877500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.688800,0.000000,35.877500>}
box{<0,0,-0.203200><5.873700,0.035000,0.203200> rotate<0,0.000000,0> translate<43.815100,0.000000,35.877500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.669700,0.000000,35.877500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.688800,0.000000,35.877500>}
box{<0,0,-0.203200><0.019100,0.035000,0.203200> rotate<0,0.000000,0> translate<49.669700,0.000000,35.877500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.895000,0.000000,36.671300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.688800,0.000000,36.671300>}
box{<0,0,-0.203200><0.793800,0.035000,0.203200> rotate<0,0.000000,0> translate<48.895000,0.000000,36.671300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.669700,0.000000,36.652200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.688800,0.000000,36.671300>}
box{<0,0,-0.203200><0.027011,0.035000,0.203200> rotate<0,-44.997030,0> translate<49.669700,0.000000,36.652200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.895000,-1.535000,40.322500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.688800,-1.535000,41.116300>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,-44.997030,0> translate<48.895000,-1.535000,40.322500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.669700,0.000000,43.675400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.688800,0.000000,43.656300>}
box{<0,0,-0.203200><0.027011,0.035000,0.203200> rotate<0,44.997030,0> translate<49.669700,0.000000,43.675400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.371200,0.000000,48.895000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688800,0.000000,49.212500>}
box{<0,0,-0.100000><0.449084,0.035000,0.100000> rotate<0,-44.988009,0> translate<49.371200,0.000000,48.895000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688800,-1.535000,49.212500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688800,-1.535000,50.006400>}
box{<0,0,-0.100000><0.793900,0.035000,0.100000> rotate<0,90.000000,0> translate<49.688800,-1.535000,50.006400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.418800,0.000000,65.563800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.688800,0.000000,66.833800>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,-44.997030,0> translate<48.418800,0.000000,65.563800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.669700,0.000000,35.039300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.714200,0.000000,35.083800>}
box{<0,0,-0.100000><0.062933,0.035000,0.100000> rotate<0,-44.997030,0> translate<49.669700,0.000000,35.039300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.669700,0.000000,44.488100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.809400,0.000000,44.488100>}
box{<0,0,-0.203200><0.139700,0.035000,0.203200> rotate<0,0.000000,0> translate<49.669700,0.000000,44.488100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<43.180000,0.000000,8.572500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.847500,0.000000,8.572500>}
box{<0,0,-0.100000><6.667500,0.035000,0.100000> rotate<0,0.000000,0> translate<43.180000,0.000000,8.572500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.847500,0.000000,17.780000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<48.577500,0.000000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.809400,0.000000,44.488100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.847500,0.000000,44.450000>}
box{<0,0,-0.203200><0.053882,0.035000,0.203200> rotate<0,44.997030,0> translate<49.809400,0.000000,44.488100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.609400,0.000000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.847500,0.000000,45.243800>}
box{<0,0,-0.100100><0.238100,0.035000,0.100100> rotate<0,0.000000,0> translate<49.609400,0.000000,45.243800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.847500,0.000000,45.243800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.847500,0.000000,46.513700>}
box{<0,0,-0.100100><1.269900,0.035000,0.100100> rotate<0,90.000000,0> translate<49.847500,0.000000,46.513700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.895000,0.000000,46.831300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.847600,0.000000,47.783800>}
box{<0,0,-0.100100><1.347109,0.035000,0.100100> rotate<0,-44.994023,0> translate<48.895000,0.000000,46.831300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.942500,-1.535000,28.892500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.847700,-1.535000,28.892500>}
box{<0,0,-0.100000><1.905200,0.035000,0.100000> rotate<0,0.000000,0> translate<47.942500,-1.535000,28.892500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.371300,-1.535000,28.892600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.847700,-1.535000,28.892500>}
box{<0,0,-0.100000><0.476400,0.035000,0.100000> rotate<0,0.012026,0> translate<49.371300,-1.535000,28.892600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688700,-1.535000,23.495000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.006100,-1.535000,23.812500>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,-45.006054,0> translate<49.688700,-1.535000,23.495000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.053800,0.000000,19.208800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.006300,0.000000,18.256300>}
box{<0,0,-0.100000><1.347038,0.035000,0.100000> rotate<0,44.997030,0> translate<49.053800,0.000000,19.208800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.006100,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.006300,-1.535000,23.812500>}
box{<0,0,-0.100000><0.000200,0.035000,0.100000> rotate<0,0.000000,0> translate<50.006100,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688800,0.000000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.006300,0.000000,24.606300>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<49.688800,0.000000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.006300,0.000000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.006300,0.000000,24.606300>}
box{<0,0,-0.100000><0.793800,0.035000,0.100000> rotate<0,90.000000,0> translate<50.006300,0.000000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.006300,0.000000,51.752500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.006300,0.000000,51.593800>}
box{<0,0,-0.100100><0.158700,0.035000,0.100100> rotate<0,-90.000000,0> translate<50.006300,0.000000,51.593800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.260000,0.000000,53.498800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.006300,0.000000,51.752500>}
box{<0,0,-0.100100><2.469641,0.035000,0.100100> rotate<0,44.997030,0> translate<48.260000,0.000000,53.498800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<37.941300,0.000000,73.183800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.006300,0.000000,73.183800>}
box{<0,0,-0.203200><12.065000,0.035000,0.203200> rotate<0,0.000000,0> translate<37.941300,0.000000,73.183800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,55.245000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.165000,-1.535000,55.880000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,-44.997030,0> translate<49.530000,-1.535000,55.245000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.165000,-1.535000,62.280800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.165000,-1.535000,62.230000>}
box{<0,0,-0.203200><0.050800,0.035000,0.203200> rotate<0,-90.000000,0> translate<50.165000,-1.535000,62.230000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.165000,-1.535000,72.339200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.165000,-1.535000,62.280800>}
box{<0,0,-0.203200><10.058400,0.035000,0.203200> rotate<0,-90.000000,0> translate<50.165000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.165000,-1.535000,73.025000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.165000,-1.535000,72.339200>}
box{<0,0,-0.203200><0.685800,0.035000,0.203200> rotate<0,-90.000000,0> translate<50.165000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.323800,0.000000,21.431300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.323800,0.000000,19.050000>}
box{<0,0,-0.100100><2.381300,0.035000,0.100100> rotate<0,-90.000000,0> translate<50.323800,0.000000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.006300,0.000000,73.183800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.323800,0.000000,73.501300>}
box{<0,0,-0.203200><0.449013,0.035000,0.203200> rotate<0,-44.997030,0> translate<50.006300,0.000000,73.183800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,76.200000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.323800,-1.535000,76.200000>}
box{<0,0,-0.203200><2.063800,0.035000,0.203200> rotate<0,0.000000,0> translate<48.260000,-1.535000,76.200000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.307500,0.000000,48.418800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.324000,0.000000,48.418800>}
box{<0,0,-0.100000><3.016500,0.035000,0.100000> rotate<0,0.000000,0> translate<47.307500,0.000000,48.418800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.669700,0.000000,36.614100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.425400,0.000000,36.614100>}
box{<0,0,-0.203200><0.755700,0.035000,0.203200> rotate<0,0.000000,0> translate<49.669700,0.000000,36.614100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.482500,-1.535000,48.577500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.482500,-1.535000,49.847600>}
box{<0,0,-0.100000><1.270100,0.035000,0.100000> rotate<0,90.000000,0> translate<50.482500,-1.535000,49.847600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.688800,0.000000,43.656300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.482600,0.000000,43.656300>}
box{<0,0,-0.100100><0.793800,0.035000,0.100100> rotate<0,0.000000,0> translate<49.688800,0.000000,43.656300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.847500,0.000000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.482600,0.000000,44.450000>}
box{<0,0,-0.203200><0.635100,0.035000,0.203200> rotate<0,0.000000,0> translate<49.847500,0.000000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.324000,0.000000,48.418800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.482600,0.000000,48.577400>}
box{<0,0,-0.100000><0.224294,0.035000,0.100000> rotate<0,-44.997030,0> translate<50.324000,0.000000,48.418800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.482500,-1.535000,48.577500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.482600,-1.535000,48.577400>}
box{<0,0,-0.100000><0.000141,0.035000,0.100000> rotate<0,44.997030,0> translate<50.482500,-1.535000,48.577500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.530000,-1.535000,59.372600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.482600,-1.535000,58.420000>}
box{<0,0,-0.100100><1.347180,0.035000,0.100100> rotate<0,44.997030,0> translate<49.530000,-1.535000,59.372600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.669700,0.000000,34.251900>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.520600,0.000000,34.251900>}
box{<0,0,-0.100000><0.850900,0.035000,0.100000> rotate<0,0.000000,0> translate<49.669700,0.000000,34.251900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.520600,0.000000,34.251900>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.558700,0.000000,34.290000>}
box{<0,0,-0.100000><0.053882,0.035000,0.100000> rotate<0,-44.997030,0> translate<50.520600,0.000000,34.251900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688800,0.000000,32.067500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.641200,0.000000,33.019900>}
box{<0,0,-0.100000><1.346897,0.035000,0.100000> rotate<0,-44.997030,0> translate<49.688800,0.000000,32.067500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.520600,0.000000,34.251900>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.641200,0.000000,34.131200>}
box{<0,0,-0.100000><0.170625,0.035000,0.100000> rotate<0,45.020773,0> translate<50.520600,0.000000,34.251900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.641200,0.000000,33.019900>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.641200,0.000000,34.131200>}
box{<0,0,-0.100000><1.111300,0.035000,0.100000> rotate<0,90.000000,0> translate<50.641200,0.000000,34.131200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,-1.535000,23.018800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.641300,-1.535000,23.018800>}
box{<0,0,-0.100000><2.381300,0.035000,0.100000> rotate<0,0.000000,0> translate<48.260000,-1.535000,23.018800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.641200,0.000000,30.480100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.641300,0.000000,24.288800>}
box{<0,0,-0.100100><6.191300,0.035000,0.100100> rotate<0,89.993135,0> translate<50.641200,0.000000,30.480100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.688800,0.000000,35.877500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.641300,0.000000,35.877500>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,0.000000,0> translate<49.688800,0.000000,35.877500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.847500,0.000000,46.513700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.641300,0.000000,47.307500>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,-44.997030,0> translate<49.847500,0.000000,46.513700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.212500,0.000000,50.006300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.641300,0.000000,50.006300>}
box{<0,0,-0.100000><1.428800,0.035000,0.100000> rotate<0,0.000000,0> translate<49.212500,0.000000,50.006300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.101300,0.000000,60.801300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.641300,0.000000,58.261300>}
box{<0,0,-0.100100><3.592102,0.035000,0.100100> rotate<0,44.997030,0> translate<48.101300,0.000000,60.801300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.165000,-1.535000,73.025000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.641300,-1.535000,73.501300>}
box{<0,0,-0.203200><0.673590,0.035000,0.203200> rotate<0,-44.997030,0> translate<50.165000,-1.535000,73.025000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.482600,0.000000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.799900,0.000000,44.767500>}
box{<0,0,-0.203200><0.448871,0.035000,0.203200> rotate<0,-45.015081,0> translate<50.482600,0.000000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.530000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.800000,0.000000,2.540000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<49.530000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,0.000000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.800000,0.000000,5.080000>}
box{<0,0,-0.100000><3.592102,0.035000,0.100000> rotate<0,44.997030,0> translate<48.260000,0.000000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.736300,-1.535000,11.588800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.800000,-1.535000,11.588800>}
box{<0,0,-0.203200><2.063700,0.035000,0.203200> rotate<0,0.000000,0> translate<48.736300,-1.535000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.755300,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.800000,-1.535000,11.607800>}
box{<0,0,-0.203200><2.044700,0.035000,0.203200> rotate<0,0.000000,0> translate<48.755300,-1.535000,11.607800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.800000,-1.535000,11.588800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.800000,-1.535000,11.607800>}
box{<0,0,-0.203200><0.019000,0.035000,0.203200> rotate<0,90.000000,0> translate<50.800000,-1.535000,11.607800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.800000,-1.535000,23.018700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.800000,-1.535000,21.539200>}
box{<0,0,-0.100000><1.479500,0.035000,0.100000> rotate<0,-90.000000,0> translate<50.800000,-1.535000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.641300,-1.535000,23.018800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.800000,-1.535000,23.018700>}
box{<0,0,-0.100000><0.158700,0.035000,0.100000> rotate<0,0.036101,0> translate<50.641300,-1.535000,23.018800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.688800,0.000000,22.225000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.800000,0.000000,23.336200>}
box{<0,0,-0.100100><1.571474,0.035000,0.100100> rotate<0,-44.997030,0> translate<49.688800,0.000000,22.225000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.641300,0.000000,24.288800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.800000,0.000000,24.130100>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.997030,0> translate<50.641300,0.000000,24.288800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.800000,0.000000,23.336200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.800000,0.000000,24.130100>}
box{<0,0,-0.100100><0.793900,0.035000,0.100100> rotate<0,90.000000,0> translate<50.800000,0.000000,24.130100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,47.783800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.800000,-1.535000,46.513800>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<49.530000,-1.535000,47.783800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.799900,0.000000,44.767500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.800000,0.000000,46.513800>}
box{<0,0,-0.203200><1.746300,0.035000,0.203200> rotate<0,-89.990780,0> translate<50.799900,0.000000,44.767500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.800000,0.000000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.800100,0.000000,57.150000>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,0.000000,0> translate<50.800000,0.000000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.847600,0.000000,47.783800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.800200,0.000000,47.783800>}
box{<0,0,-0.100100><0.952600,0.035000,0.100100> rotate<0,0.000000,0> translate<49.847600,0.000000,47.783800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.800000,-1.535000,42.647500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.856300,-1.535000,42.703800>}
box{<0,0,-0.203200><0.079620,0.035000,0.203200> rotate<0,-44.997030,0> translate<50.800000,-1.535000,42.647500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.800000,-1.535000,38.202500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.902500,-1.535000,38.417500>}
box{<0,0,-0.203200><0.238183,0.035000,0.203200> rotate<0,-64.506542,0> translate<50.800000,-1.535000,38.202500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.714200,0.000000,35.083800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.958700,0.000000,35.083800>}
box{<0,0,-0.100000><1.244500,0.035000,0.100000> rotate<0,0.000000,0> translate<49.714200,0.000000,35.083800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.425400,0.000000,36.614100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.958800,0.000000,37.147500>}
box{<0,0,-0.203200><0.754342,0.035000,0.203200> rotate<0,-44.997030,0> translate<50.425400,0.000000,36.614100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.958800,0.000000,37.147500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.958800,0.000000,39.052600>}
box{<0,0,-0.203200><1.905100,0.035000,0.203200> rotate<0,90.000000,0> translate<50.958800,0.000000,39.052600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.641300,-1.535000,40.005100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.958800,-1.535000,40.322600>}
box{<0,0,-0.203200><0.449013,0.035000,0.203200> rotate<0,-44.997030,0> translate<50.641300,-1.535000,40.005100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.641300,0.000000,47.307500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.958900,0.000000,47.307500>}
box{<0,0,-0.100100><0.317600,0.035000,0.100100> rotate<0,0.000000,0> translate<50.641300,0.000000,47.307500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.800200,0.000000,47.783800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.958900,0.000000,47.942500>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,-44.997030,0> translate<50.800200,0.000000,47.783800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.800000,-1.535000,39.902500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.061300,-1.535000,40.163800>}
box{<0,0,-0.100100><0.369534,0.035000,0.100100> rotate<0,-44.997030,0> translate<50.800000,-1.535000,39.902500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<44.291300,0.000000,9.048800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.117500,0.000000,9.048800>}
box{<0,0,-0.100000><6.826200,0.035000,0.100000> rotate<0,0.000000,0> translate<44.291300,0.000000,9.048800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.117500,0.000000,30.956300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.117500,0.000000,30.956200>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,-90.000000,0> translate<51.117500,0.000000,30.956200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.641200,0.000000,30.480100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.117500,0.000000,30.956300>}
box{<0,0,-0.100100><0.673519,0.035000,0.100100> rotate<0,-44.991015,0> translate<50.641200,0.000000,30.480100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.117500,0.000000,41.592600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.117500,0.000000,43.180000>}
box{<0,0,-0.203200><1.587400,0.035000,0.203200> rotate<0,90.000000,0> translate<51.117500,0.000000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.323800,0.000000,73.501300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.117500,0.000000,73.501300>}
box{<0,0,-0.203200><0.793700,0.035000,0.203200> rotate<0,0.000000,0> translate<50.323800,0.000000,73.501300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.641300,-1.535000,73.501300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.117500,-1.535000,73.501300>}
box{<0,0,-0.203200><0.476200,0.035000,0.203200> rotate<0,0.000000,0> translate<50.641300,-1.535000,73.501300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.258800,-1.535000,78.422500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.117500,-1.535000,78.422500>}
box{<0,0,-0.203200><12.858700,0.035000,0.203200> rotate<0,0.000000,0> translate<38.258800,-1.535000,78.422500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.323800,0.000000,21.431300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.276300,0.000000,22.383800>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,-44.997030,0> translate<50.323800,0.000000,21.431300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.276300,0.000000,27.463800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.276300,0.000000,22.383800>}
box{<0,0,-0.100100><5.080000,0.035000,0.100100> rotate<0,-90.000000,0> translate<51.276300,0.000000,22.383800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.006300,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.276300,-1.535000,23.812500>}
box{<0,0,-0.100000><1.270000,0.035000,0.100000> rotate<0,0.000000,0> translate<50.006300,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.101100,-1.535000,27.781300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.276300,-1.535000,27.781300>}
box{<0,0,-0.100000><3.175200,0.035000,0.100000> rotate<0,0.000000,0> translate<48.101100,-1.535000,27.781300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.641300,0.000000,50.006300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.276300,0.000000,49.371200>}
box{<0,0,-0.100000><0.898096,0.035000,0.100000> rotate<0,45.001541,0> translate<50.641300,0.000000,50.006300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.053800,0.000000,50.641300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.276300,0.000000,50.641300>}
box{<0,0,-0.100100><2.222500,0.035000,0.100100> rotate<0,0.000000,0> translate<49.053800,0.000000,50.641300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.800000,-1.535000,44.347500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.332500,-1.535000,44.347500>}
box{<0,0,-0.203200><0.532500,0.035000,0.203200> rotate<0,0.000000,0> translate<50.800000,-1.535000,44.347500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.276300,-1.535000,44.291300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.332500,-1.535000,44.347500>}
box{<0,0,-0.203200><0.079479,0.035000,0.203200> rotate<0,-44.997030,0> translate<51.276300,-1.535000,44.291300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<45.561300,0.000000,9.525000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.435000,0.000000,9.525000>}
box{<0,0,-0.100000><5.873700,0.035000,0.100000> rotate<0,0.000000,0> translate<45.561300,0.000000,9.525000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.276300,0.000000,19.843800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.435000,0.000000,19.843800>}
box{<0,0,-0.100000><0.158700,0.035000,0.100000> rotate<0,0.000000,0> translate<51.276300,0.000000,19.843800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.276300,-1.535000,19.843800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.435000,-1.535000,19.843800>}
box{<0,0,-0.100000><0.158700,0.035000,0.100000> rotate<0,0.000000,0> translate<51.276300,-1.535000,19.843800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.276300,0.000000,27.463800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.435000,0.000000,27.622500>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,-44.997030,0> translate<51.276300,0.000000,27.463800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.276300,-1.535000,27.622600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.435000,-1.535000,27.622500>}
box{<0,0,-0.100100><0.158700,0.035000,0.100100> rotate<0,0.036101,0> translate<51.276300,-1.535000,27.622600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.435000,-1.535000,27.622600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.435000,-1.535000,27.622500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,-90.000000,0> translate<51.435000,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.276300,-1.535000,27.781300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.435000,-1.535000,27.622600>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<51.276300,-1.535000,27.781300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.902500,-1.535000,38.417500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.435000,-1.535000,38.417500>}
box{<0,0,-0.203200><0.532500,0.035000,0.203200> rotate<0,0.000000,0> translate<50.902500,-1.535000,38.417500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.958900,0.000000,47.942500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.435000,0.000000,48.418800>}
box{<0,0,-0.100100><0.673449,0.035000,0.100100> rotate<0,-45.009061,0> translate<50.958900,0.000000,47.942500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.800000,-1.535000,38.202500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.537500,-1.535000,38.520000>}
box{<0,0,-0.203200><0.802940,0.035000,0.203200> rotate<0,-23.290750,0> translate<50.800000,-1.535000,38.202500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.101300,-1.535000,29.686300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.593700,-1.535000,29.686300>}
box{<0,0,-0.100100><3.492400,0.035000,0.100100> rotate<0,0.000000,0> translate<48.101300,-1.535000,29.686300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.558700,0.000000,34.290000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.593700,0.000000,34.290000>}
box{<0,0,-0.100000><1.035000,0.035000,0.100000> rotate<0,0.000000,0> translate<50.558700,0.000000,34.290000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.641300,0.000000,35.877500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.593800,0.000000,36.830100>}
box{<0,0,-0.203200><1.347109,0.035000,0.203200> rotate<0,-45.000037,0> translate<50.641300,0.000000,35.877500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.593800,0.000000,36.830100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.593800,0.000000,38.576300>}
box{<0,0,-0.203200><1.746200,0.035000,0.203200> rotate<0,90.000000,0> translate<51.593800,0.000000,38.576300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.006300,-1.535000,51.593800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.593800,-1.535000,53.181300>}
box{<0,0,-0.100100><2.245064,0.035000,0.100100> rotate<0,-44.997030,0> translate<50.006300,-1.535000,51.593800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.958900,0.000000,47.307500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.593900,0.000000,46.672500>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<50.958900,0.000000,47.307500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.482600,0.000000,43.656300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.594000,0.000000,44.767600>}
box{<0,0,-0.100100><1.571686,0.035000,0.100100> rotate<0,-44.994453,0> translate<50.482600,0.000000,43.656300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.593900,0.000000,46.672500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.594000,0.000000,44.767600>}
box{<0,0,-0.100100><1.904900,0.035000,0.100100> rotate<0,89.991053,0> translate<51.593900,0.000000,46.672500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.053800,0.000000,61.595000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.752500,0.000000,58.896300>}
box{<0,0,-0.203200><3.816538,0.035000,0.203200> rotate<0,44.997030,0> translate<49.053800,0.000000,61.595000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.435000,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.752600,-1.535000,27.940000>}
box{<0,0,-0.100100><0.449084,0.035000,0.100100> rotate<0,-44.988009,0> translate<51.435000,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.070000,0.000000,5.715000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.070000,0.000000,3.810000>}
box{<0,0,-0.100000><1.905000,0.035000,0.100000> rotate<0,-90.000000,0> translate<52.070000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688700,0.000000,8.096300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.070000,0.000000,5.715000>}
box{<0,0,-0.100000><3.367667,0.035000,0.100000> rotate<0,44.997030,0> translate<49.688700,0.000000,8.096300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,-1.535000,11.588800>}
box{<0,0,-0.100100><0.019000,0.035000,0.100100> rotate<0,-90.000000,0> translate<52.070000,-1.535000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,-1.535000,17.303800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,-1.535000,11.607800>}
box{<0,0,-0.100100><5.696000,0.035000,0.100100> rotate<0,-90.000000,0> translate<52.070000,-1.535000,11.607800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.323800,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,-1.535000,17.303800>}
box{<0,0,-0.100100><2.469500,0.035000,0.100100> rotate<0,44.997030,0> translate<50.323800,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,-1.535000,17.938800>}
box{<0,0,-0.100100><1.111200,0.035000,0.100100> rotate<0,-90.000000,0> translate<52.070000,-1.535000,17.938800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,0.000000,19.764500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,0.000000,19.050000>}
box{<0,0,-0.100100><0.714500,0.035000,0.100100> rotate<0,-90.000000,0> translate<52.070000,0.000000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.435000,0.000000,19.843800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.070000,0.000000,20.478800>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,-44.997030,0> translate<51.435000,0.000000,19.843800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.435000,-1.535000,19.843800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.070000,-1.535000,20.478800>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,-44.997030,0> translate<51.435000,-1.535000,19.843800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.070000,0.000000,23.336300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.070000,0.000000,20.478800>}
box{<0,0,-0.100000><2.857500,0.035000,0.100000> rotate<0,-90.000000,0> translate<52.070000,0.000000,20.478800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.070000,-1.535000,20.478800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.070000,-1.535000,21.539200>}
box{<0,0,-0.100000><1.060400,0.035000,0.100000> rotate<0,90.000000,0> translate<52.070000,-1.535000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,0.000000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,0.000000,23.336300>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,-90.000000,0> translate<52.070000,0.000000,23.336300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.276300,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,-1.535000,23.812500>}
box{<0,0,-0.100100><0.793700,0.035000,0.100100> rotate<0,0.000000,0> translate<51.276300,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.593700,-1.535000,29.686300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.070000,-1.535000,30.162500>}
box{<0,0,-0.100000><0.673519,0.035000,0.100000> rotate<0,-44.991015,0> translate<51.593700,-1.535000,29.686300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.117500,0.000000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228600,0.000000,44.291200>}
box{<0,0,-0.203200><1.571403,0.035000,0.203200> rotate<0,-44.999608,0> translate<51.117500,0.000000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.958800,0.000000,39.052600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228700,0.000000,40.322500>}
box{<0,0,-0.203200><1.795910,0.035000,0.203200> rotate<0,-44.997030,0> translate<50.958800,0.000000,39.052600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.958800,-1.535000,40.322600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228700,-1.535000,40.322500>}
box{<0,0,-0.203200><1.269900,0.035000,0.203200> rotate<0,0.004512,0> translate<50.958800,-1.535000,40.322600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.061300,-1.535000,40.163800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.228700,-1.535000,40.322500>}
box{<0,0,-0.100100><1.178138,0.035000,0.100100> rotate<0,-7.741000,0> translate<51.061300,-1.535000,40.163800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688800,-1.535000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.228800,-1.535000,24.606300>}
box{<0,0,-0.100000><2.540000,0.035000,0.100000> rotate<0,0.000000,0> translate<49.688800,-1.535000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.958700,-1.535000,35.083800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.228800,-1.535000,35.083800>}
box{<0,0,-0.100000><1.270100,0.035000,0.100000> rotate<0,0.000000,0> translate<50.958700,-1.535000,35.083800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.435000,-1.535000,38.417500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,-1.535000,39.211300>}
box{<0,0,-0.203200><1.122603,0.035000,0.203200> rotate<0,-44.997030,0> translate<51.435000,-1.535000,38.417500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.537500,-1.535000,38.520000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,-1.535000,39.211300>}
box{<0,0,-0.203200><0.977646,0.035000,0.203200> rotate<0,-44.997030,0> translate<51.537500,-1.535000,38.520000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.593800,0.000000,38.576300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,0.000000,39.211300>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,-44.997030,0> translate<51.593800,0.000000,38.576300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.117500,0.000000,41.592600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,0.000000,40.481300>}
box{<0,0,-0.203200><1.571616,0.035000,0.203200> rotate<0,44.997030,0> translate<51.117500,0.000000,41.592600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.228700,-1.535000,40.322500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.228800,-1.535000,40.481300>}
box{<0,0,-0.100100><0.158800,0.035000,0.100100> rotate<0,-89.957982,0> translate<52.228700,-1.535000,40.322500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228700,0.000000,40.322500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,0.000000,40.481300>}
box{<0,0,-0.203200><0.158800,0.035000,0.203200> rotate<0,-89.957982,0> translate<52.228700,0.000000,40.322500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.856300,-1.535000,42.703800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,-1.535000,42.703800>}
box{<0,0,-0.203200><1.372500,0.035000,0.203200> rotate<0,0.000000,0> translate<50.856300,-1.535000,42.703800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,0.000000,42.703700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,0.000000,42.703800>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,90.000000,0> translate<52.228800,0.000000,42.703800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.276300,-1.535000,44.291300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,-1.535000,44.291200>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,0.006015,0> translate<51.276300,-1.535000,44.291300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228600,0.000000,44.291200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,0.000000,44.291200>}
box{<0,0,-0.203200><0.000200,0.035000,0.203200> rotate<0,0.000000,0> translate<52.228600,0.000000,44.291200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,-1.535000,44.291200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,-1.535000,48.260100>}
box{<0,0,-0.203200><3.968900,0.035000,0.203200> rotate<0,90.000000,0> translate<52.228800,-1.535000,48.260100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.228800,0.000000,54.133800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.228800,0.000000,55.721200>}
box{<0,0,-0.100000><1.587400,0.035000,0.100000> rotate<0,90.000000,0> translate<52.228800,0.000000,55.721200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.800100,0.000000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.228800,0.000000,55.721300>}
box{<0,0,-0.100100><2.020487,0.035000,0.100100> rotate<0,44.997030,0> translate<50.800100,0.000000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.228800,0.000000,55.721200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.228800,0.000000,55.721300>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<52.228800,0.000000,55.721300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.323800,-1.535000,76.200000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,-1.535000,74.295000>}
box{<0,0,-0.203200><2.694077,0.035000,0.203200> rotate<0,44.997030,0> translate<50.323800,-1.535000,76.200000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,-1.535000,63.182500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,-1.535000,74.295000>}
box{<0,0,-0.203200><11.112500,0.035000,0.203200> rotate<0,90.000000,0> translate<52.228800,-1.535000,74.295000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<47.783800,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.387500,-1.535000,25.082500>}
box{<0,0,-0.100000><4.603700,0.035000,0.100000> rotate<0,0.000000,0> translate<47.783800,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.847700,-1.535000,28.892500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.387500,-1.535000,28.892500>}
box{<0,0,-0.100000><2.539800,0.035000,0.100000> rotate<0,0.000000,0> translate<49.847700,-1.535000,28.892500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.117500,0.000000,30.956200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.387500,0.000000,32.226200>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,-44.997030,0> translate<51.117500,0.000000,30.956200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.387500,0.000000,32.226200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.387500,0.000000,36.830000>}
box{<0,0,-0.100100><4.603800,0.035000,0.100100> rotate<0,90.000000,0> translate<52.387500,0.000000,36.830000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,-1.535000,39.211300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.387500,-1.535000,39.370000>}
box{<0,0,-0.203200><0.224436,0.035000,0.203200> rotate<0,-44.997030,0> translate<52.228800,-1.535000,39.211300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688800,-1.535000,50.006400>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.387500,-1.535000,52.705000>}
box{<0,0,-0.100000><3.816467,0.035000,0.100000> rotate<0,-44.995969,0> translate<49.688800,-1.535000,50.006400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.800000,-1.535000,23.018700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.387600,-1.535000,23.018700>}
box{<0,0,-0.100000><1.587600,0.035000,0.100000> rotate<0,0.000000,0> translate<50.800000,-1.535000,23.018700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.070000,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.387600,-1.535000,23.812500>}
box{<0,0,-0.100000><0.317600,0.035000,0.100000> rotate<0,0.000000,0> translate<52.070000,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.387500,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.546200,-1.535000,24.923800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<52.387500,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.688800,-1.535000,41.116300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.546200,-1.535000,41.116300>}
box{<0,0,-0.100100><2.857400,0.035000,0.100100> rotate<0,0.000000,0> translate<49.688800,-1.535000,41.116300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.387600,-1.535000,23.018700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.546300,-1.535000,22.860000>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<52.387600,-1.535000,23.018700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418800,-1.535000,25.558800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.546300,-1.535000,25.558800>}
box{<0,0,-0.100000><4.127500,0.035000,0.100000> rotate<0,0.000000,0> translate<48.418800,-1.535000,25.558800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.228800,-1.535000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.705000,-1.535000,24.130000>}
box{<0,0,-0.100000><0.673519,0.035000,0.100000> rotate<0,45.003045,0> translate<52.228800,-1.535000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.387500,-1.535000,28.892500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.705000,-1.535000,29.210000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<52.387500,-1.535000,28.892500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.228800,-1.535000,35.083800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.705000,-1.535000,35.560000>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,-44.997030,0> translate<52.228800,-1.535000,35.083800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.530000,-1.535000,41.592600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.705000,-1.535000,41.592600>}
box{<0,0,-0.100000><3.175000,0.035000,0.100000> rotate<0,0.000000,0> translate<49.530000,-1.535000,41.592600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.482500,-1.535000,49.847600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.705000,-1.535000,52.228800>}
box{<0,0,-0.100000><3.257241,0.035000,0.100000> rotate<0,-46.971234,0> translate<50.482500,-1.535000,49.847600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.546300,-1.535000,25.558800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.705100,-1.535000,25.400000>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<52.546300,-1.535000,25.558800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,0.000000,19.764500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.784400,0.000000,20.478900>}
box{<0,0,-0.100100><1.010314,0.035000,0.100100> rotate<0,-44.997030,0> translate<52.070000,0.000000,19.764500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.784400,0.000000,24.209400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.784400,0.000000,20.478900>}
box{<0,0,-0.100100><3.730500,0.035000,0.100100> rotate<0,-90.000000,0> translate<52.784400,0.000000,20.478900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.387600,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.863700,-1.535000,23.336200>}
box{<0,0,-0.100000><0.673449,0.035000,0.100000> rotate<0,45.009061,0> translate<52.387600,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418700,-1.535000,26.828800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.863700,-1.535000,26.828800>}
box{<0,0,-0.100000><4.445000,0.035000,0.100000> rotate<0,0.000000,0> translate<48.418700,-1.535000,26.828800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.863800,0.000000,49.053800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.863800,0.000000,47.466300>}
box{<0,0,-0.100100><1.587500,0.035000,0.100100> rotate<0,-90.000000,0> translate<52.863800,0.000000,47.466300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.276300,0.000000,50.641300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.863800,0.000000,49.053800>}
box{<0,0,-0.100100><2.245064,0.035000,0.100100> rotate<0,44.997030,0> translate<51.276300,0.000000,50.641300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,0.000000,39.211300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.022500,0.000000,40.005000>}
box{<0,0,-0.203200><1.122461,0.035000,0.203200> rotate<0,-44.997030,0> translate<52.228800,0.000000,39.211300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.546200,-1.535000,41.116300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.022500,-1.535000,40.640000>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,44.997030,0> translate<52.546200,-1.535000,41.116300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,0.000000,42.703700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.022500,0.000000,41.910000>}
box{<0,0,-0.203200><1.122461,0.035000,0.203200> rotate<0,44.997030,0> translate<52.228800,0.000000,42.703700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.705000,-1.535000,41.592600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.022500,-1.535000,41.910000>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,-44.988006,0> translate<52.705000,-1.535000,41.592600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.022500,0.000000,40.005000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.022500,0.000000,41.910000>}
box{<0,0,-0.203200><1.905000,0.035000,0.203200> rotate<0,90.000000,0> translate<53.022500,0.000000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,-1.535000,48.260100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.022500,-1.535000,49.053900>}
box{<0,0,-0.203200><1.122532,0.035000,0.203200> rotate<0,-45.000639,0> translate<52.228800,-1.535000,48.260100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.784400,0.000000,24.209400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.181300,0.000000,24.606300>}
box{<0,0,-0.100100><0.561301,0.035000,0.100100> rotate<0,-44.997030,0> translate<52.784400,0.000000,24.209400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.181300,0.000000,27.146300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.181300,0.000000,24.606300>}
box{<0,0,-0.100100><2.540000,0.035000,0.100100> rotate<0,-90.000000,0> translate<53.181300,0.000000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.863700,-1.535000,26.828800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.181300,-1.535000,27.146300>}
box{<0,0,-0.100000><0.449084,0.035000,0.100000> rotate<0,-44.988009,0> translate<52.863700,-1.535000,26.828800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.705000,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.181300,-1.535000,29.210000>}
box{<0,0,-0.100000><0.476300,0.035000,0.100000> rotate<0,0.000000,0> translate<52.705000,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.181300,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.181300,-1.535000,29.210100>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,90.000000,0> translate<53.181300,-1.535000,29.210100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,0.000000,62.230000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.181300,0.000000,62.230000>}
box{<0,0,-0.203200><16.351300,0.035000,0.203200> rotate<0,0.000000,0> translate<36.830000,0.000000,62.230000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.070000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,0.000000,2.540000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<52.070000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.847500,0.000000,8.572500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,0.000000,5.080000>}
box{<0,0,-0.100000><4.939141,0.035000,0.100000> rotate<0,44.997030,0> translate<49.847500,0.000000,8.572500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.340000,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.340000,-1.535000,11.588800>}
box{<0,0,-0.100100><0.019000,0.035000,0.100100> rotate<0,-90.000000,0> translate<53.340000,-1.535000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.340000,-1.535000,16.668800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.340000,-1.535000,11.607800>}
box{<0,0,-0.100100><5.061000,0.035000,0.100100> rotate<0,-90.000000,0> translate<53.340000,-1.535000,11.607800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.070000,-1.535000,17.938800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.340000,-1.535000,16.668800>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<52.070000,-1.535000,17.938800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,0.000000,21.272500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,0.000000,20.002500>}
box{<0,0,-0.100000><1.270000,0.035000,0.100000> rotate<0,-90.000000,0> translate<53.340000,0.000000,20.002500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,-1.535000,20.002500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,-1.535000,21.539200>}
box{<0,0,-0.100000><1.536700,0.035000,0.100000> rotate<0,90.000000,0> translate<53.340000,-1.535000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.260000,0.000000,54.451300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,0.000000,49.371300>}
box{<0,0,-0.100000><7.184205,0.035000,0.100000> rotate<0,44.997030,0> translate<48.260000,0.000000,54.451300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,0.000000,48.101300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,0.000000,49.371300>}
box{<0,0,-0.100000><1.270000,0.035000,0.100000> rotate<0,90.000000,0> translate<53.340000,0.000000,49.371300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,0.000000,53.975100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,0.000000,54.610000>}
box{<0,0,-0.100000><0.634900,0.035000,0.100000> rotate<0,90.000000,0> translate<53.340000,0.000000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.117500,-1.535000,78.422500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.340000,-1.535000,76.200000>}
box{<0,0,-0.203200><3.143090,0.035000,0.203200> rotate<0,44.997030,0> translate<51.117500,-1.535000,78.422500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.783800,0.000000,10.001300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.498700,0.000000,10.001300>}
box{<0,0,-0.100100><5.714900,0.035000,0.100100> rotate<0,0.000000,0> translate<47.783800,0.000000,10.001300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.752600,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.498700,-1.535000,27.940000>}
box{<0,0,-0.100100><1.746100,0.035000,0.100100> rotate<0,0.000000,0> translate<51.752600,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.498800,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.498800,-1.535000,17.303700>}
box{<0,0,-0.100100><1.746300,0.035000,0.100100> rotate<0,-90.000000,0> translate<53.498800,-1.535000,17.303700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.276300,-1.535000,49.371200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.657400,-1.535000,51.752500>}
box{<0,0,-0.100000><3.367525,0.035000,0.100000> rotate<0,-44.999436,0> translate<51.276300,-1.535000,49.371200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.498800,0.000000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.657500,0.000000,19.208800>}
box{<0,0,-0.100100><0.224506,0.035000,0.100100> rotate<0,-45.015075,0> translate<53.498800,0.000000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.530000,0.000000,54.292500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.657500,0.000000,50.165100>}
box{<0,0,-0.100000><5.837096,0.035000,0.100000> rotate<0,44.996336,0> translate<49.530000,0.000000,54.292500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.657500,-1.535000,66.198700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.657500,-1.535000,73.818800>}
box{<0,0,-0.203200><7.620100,0.035000,0.203200> rotate<0,90.000000,0> translate<53.657500,-1.535000,73.818800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.498700,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.816200,-1.535000,27.622600>}
box{<0,0,-0.100100><0.448942,0.035000,0.100100> rotate<0,44.988006,0> translate<53.498700,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.816200,-1.535000,27.622600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.816300,-1.535000,27.622500>}
box{<0,0,-0.100100><0.000141,0.035000,0.100100> rotate<0,44.997030,0> translate<53.816200,-1.535000,27.622600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.513800,0.000000,72.548800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.816300,0.000000,72.548800>}
box{<0,0,-0.100100><7.302500,0.035000,0.100100> rotate<0,0.000000,0> translate<46.513800,0.000000,72.548800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.465000,-1.535000,9.207500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.975000,-1.535000,9.207500>}
box{<0,0,-0.100100><16.510000,0.035000,0.100100> rotate<0,0.000000,0> translate<37.465000,-1.535000,9.207500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.975000,-1.535000,16.827500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.975000,-1.535000,14.446300>}
box{<0,0,-0.100100><2.381200,0.035000,0.100100> rotate<0,-90.000000,0> translate<53.975000,-1.535000,14.446300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.498800,-1.535000,17.303700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.975000,-1.535000,16.827500>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,44.997030,0> translate<53.498800,-1.535000,17.303700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,0.000000,21.272500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.975000,0.000000,21.907500>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,-44.997030,0> translate<53.340000,0.000000,21.272500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.975000,0.000000,37.306200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.975000,0.000000,36.410000>}
box{<0,0,-0.203200><0.896200,0.035000,0.203200> rotate<0,-90.000000,0> translate<53.975000,0.000000,36.410000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.006300,0.000000,18.256300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.975100,0.000000,18.256300>}
box{<0,0,-0.100000><3.968800,0.035000,0.100000> rotate<0,0.000000,0> translate<50.006300,0.000000,18.256300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.705000,-1.535000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.975100,-1.535000,24.130000>}
box{<0,0,-0.100000><1.270100,0.035000,0.100000> rotate<0,0.000000,0> translate<52.705000,-1.535000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.975000,0.000000,21.907500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.975100,0.000000,24.130000>}
box{<0,0,-0.100000><2.222500,0.035000,0.100000> rotate<0,-89.991483,0> translate<53.975000,0.000000,21.907500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.593700,-1.535000,34.290000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.130000,-1.535000,34.290000>}
box{<0,0,-0.100000><2.536300,0.035000,0.100000> rotate<0,0.000000,0> translate<51.593700,-1.535000,34.290000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.705000,-1.535000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.130000,-1.535000,35.560000>}
box{<0,0,-0.100000><1.425000,0.035000,0.100000> rotate<0,0.000000,0> translate<52.705000,-1.535000,35.560000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.387500,-1.535000,36.830000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.130000,-1.535000,36.830000>}
box{<0,0,-0.100100><1.742500,0.035000,0.100100> rotate<0,0.000000,0> translate<52.387500,-1.535000,36.830000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.387500,-1.535000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.130000,-1.535000,39.370000>}
box{<0,0,-0.203200><1.742500,0.035000,0.203200> rotate<0,0.000000,0> translate<52.387500,-1.535000,39.370000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.022500,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.130000,-1.535000,40.640000>}
box{<0,0,-0.100100><1.107500,0.035000,0.100100> rotate<0,0.000000,0> translate<53.022500,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.022500,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.130000,-1.535000,41.910000>}
box{<0,0,-0.100100><1.107500,0.035000,0.100100> rotate<0,0.000000,0> translate<53.022500,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.847500,0.000000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.133700,0.000000,17.780000>}
box{<0,0,-0.100000><4.286200,0.035000,0.100000> rotate<0,0.000000,0> translate<49.847500,0.000000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,-1.535000,26.035000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.133700,-1.535000,26.035000>}
box{<0,0,-0.100000><5.556200,0.035000,0.100000> rotate<0,0.000000,0> translate<48.577500,-1.535000,26.035000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.816300,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.133800,-1.535000,27.622500>}
box{<0,0,-0.100100><0.317500,0.035000,0.100100> rotate<0,0.000000,0> translate<53.816300,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.101200,-1.535000,28.416300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.133800,-1.535000,28.416300>}
box{<0,0,-0.100000><6.032600,0.035000,0.100000> rotate<0,0.000000,0> translate<48.101200,-1.535000,28.416300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.133800,0.000000,28.416300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.133800,0.000000,31.908800>}
box{<0,0,-0.100000><3.492500,0.035000,0.100000> rotate<0,90.000000,0> translate<54.133800,0.000000,31.908800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.130000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.133800,-1.535000,33.020000>}
box{<0,0,-0.100100><0.003800,0.035000,0.100100> rotate<0,0.000000,0> translate<54.130000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.133800,-1.535000,31.908800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.133800,-1.535000,33.020000>}
box{<0,0,-0.100000><1.111200,0.035000,0.100000> rotate<0,90.000000,0> translate<54.133800,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.130000,-1.535000,34.290000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.133800,-1.535000,34.290000>}
box{<0,0,-0.100000><0.003800,0.035000,0.100000> rotate<0,0.000000,0> translate<54.130000,-1.535000,34.290000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.130000,-1.535000,36.830000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.133800,-1.535000,36.830000>}
box{<0,0,-0.100100><0.003800,0.035000,0.100100> rotate<0,0.000000,0> translate<54.130000,-1.535000,36.830000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.130000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.133800,-1.535000,40.640000>}
box{<0,0,-0.100100><0.003800,0.035000,0.100100> rotate<0,0.000000,0> translate<54.130000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.130000,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.133800,-1.535000,41.910000>}
box{<0,0,-0.100100><0.003800,0.035000,0.100100> rotate<0,0.000000,0> translate<54.130000,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<52.863800,0.000000,47.466300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.133800,0.000000,46.196300>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<52.863800,0.000000,47.466300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.100000,0.000000,62.865000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.133800,0.000000,62.865000>}
box{<0,0,-0.203200><16.033800,0.035000,0.203200> rotate<0,0.000000,0> translate<38.100000,0.000000,62.865000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<37.306300,-1.535000,9.683800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.292500,-1.535000,9.683800>}
box{<0,0,-0.100100><16.986200,0.035000,0.100100> rotate<0,0.000000,0> translate<37.306300,-1.535000,9.683800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.975100,-1.535000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.292500,-1.535000,23.812500>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,45.006054,0> translate<53.975100,-1.535000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.133800,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.292500,-1.535000,33.020000>}
box{<0,0,-0.100100><0.158700,0.035000,0.100100> rotate<0,0.000000,0> translate<54.133800,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<50.800000,0.000000,54.610000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.292500,0.000000,51.117500>}
box{<0,0,-0.100000><4.939141,0.035000,0.100000> rotate<0,44.997030,0> translate<50.800000,0.000000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<51.435000,-1.535000,48.418800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.292500,-1.535000,51.276300>}
box{<0,0,-0.100100><4.041115,0.035000,0.100100> rotate<0,-44.997030,0> translate<51.435000,-1.535000,48.418800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.133800,0.000000,62.865000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.292500,0.000000,62.706300>}
box{<0,0,-0.203200><0.224436,0.035000,0.203200> rotate<0,44.997030,0> translate<54.133800,0.000000,62.865000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.688800,0.000000,17.303800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.292600,0.000000,17.303800>}
box{<0,0,-0.100000><4.603800,0.035000,0.100000> rotate<0,0.000000,0> translate<49.688800,0.000000,17.303800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.070000,-1.535000,30.162500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.292600,-1.535000,30.162500>}
box{<0,0,-0.100000><2.222600,0.035000,0.100000> rotate<0,0.000000,0> translate<52.070000,-1.535000,30.162500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.418800,-1.535000,30.638800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.451200,-1.535000,30.638800>}
box{<0,0,-0.100100><6.032400,0.035000,0.100100> rotate<0,0.000000,0> translate<48.418800,-1.535000,30.638800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.657500,0.000000,50.165100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451200,0.000000,50.165000>}
box{<0,0,-0.100000><0.793700,0.035000,0.100000> rotate<0,0.007218,0> translate<53.657500,0.000000,50.165100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.530000,0.000000,16.827500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451300,0.000000,16.827500>}
box{<0,0,-0.100000><4.921300,0.035000,0.100000> rotate<0,0.000000,0> translate<49.530000,0.000000,16.827500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.975100,0.000000,18.256300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451300,0.000000,18.732500>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,-44.997030,0> translate<53.975100,0.000000,18.256300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451300,0.000000,20.320100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451300,0.000000,20.002500>}
box{<0,0,-0.100000><0.317600,0.035000,0.100000> rotate<0,-90.000000,0> translate<54.451300,0.000000,20.002500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451300,-1.535000,20.002500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451300,-1.535000,20.002600>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,90.000000,0> translate<54.451300,-1.535000,20.002600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,0.000000,44.291200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.451300,0.000000,44.291300>}
box{<0,0,-0.203200><2.222500,0.035000,0.203200> rotate<0,-0.002578,0> translate<52.228800,0.000000,44.291200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.228800,0.000000,54.133800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451300,0.000000,51.911300>}
box{<0,0,-0.100000><3.143090,0.035000,0.100000> rotate<0,44.997030,0> translate<52.228800,0.000000,54.133800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<49.688800,0.000000,66.833800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.451300,0.000000,66.833800>}
box{<0,0,-0.100100><4.762500,0.035000,0.100100> rotate<0,0.000000,0> translate<49.688800,0.000000,66.833800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.132400,0.000000,69.691300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.451300,0.000000,69.691300>}
box{<0,0,-0.100100><10.318900,0.035000,0.100100> rotate<0,0.000000,0> translate<44.132400,0.000000,69.691300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,0.000000,5.556300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,0.000000,3.810000>}
box{<0,0,-0.100000><1.746300,0.035000,0.100000> rotate<0,-90.000000,0> translate<54.610000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.117500,0.000000,9.048800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,0.000000,5.556300>}
box{<0,0,-0.100000><4.939141,0.035000,0.100000> rotate<0,44.997030,0> translate<51.117500,0.000000,9.048800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.610000,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.610000,-1.535000,11.588800>}
box{<0,0,-0.100100><0.019000,0.035000,0.100100> rotate<0,-90.000000,0> translate<54.610000,-1.535000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.610000,-1.535000,13.811300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.610000,-1.535000,11.607800>}
box{<0,0,-0.100100><2.203500,0.035000,0.100100> rotate<0,-90.000000,0> translate<54.610000,-1.535000,11.607800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.975000,-1.535000,14.446300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.610000,-1.535000,13.811300>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<53.975000,-1.535000,14.446300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.133700,0.000000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,0.000000,18.256300>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,-44.997030,0> translate<54.133700,0.000000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.657500,0.000000,19.208800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.610000,0.000000,19.208800>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,0.000000,0> translate<53.657500,0.000000,19.208800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451300,-1.535000,20.002600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,-1.535000,20.161300>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<54.451300,-1.535000,20.002600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,-1.535000,20.161300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,-1.535000,21.539200>}
box{<0,0,-0.100000><1.377900,0.035000,0.100000> rotate<0,90.000000,0> translate<54.610000,-1.535000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.181300,-1.535000,29.210100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,-1.535000,29.210000>}
box{<0,0,-0.100000><1.428700,0.035000,0.100000> rotate<0,0.004010,0> translate<53.181300,-1.535000,29.210100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.340000,0.000000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.610000,0.000000,55.880000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<53.340000,0.000000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,0.000000,53.975000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,0.000000,55.880000>}
box{<0,0,-0.100000><1.905000,0.035000,0.100000> rotate<0,90.000000,0> translate<54.610000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.816300,0.000000,72.548800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.610000,0.000000,73.342500>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,-44.997030,0> translate<53.816300,0.000000,72.548800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.371300,0.000000,16.351300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610100,0.000000,16.351300>}
box{<0,0,-0.100000><5.238800,0.035000,0.100000> rotate<0,0.000000,0> translate<49.371300,0.000000,16.351300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.292600,0.000000,17.303800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610100,0.000000,17.621300>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<54.292600,0.000000,17.303800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,0.000000,17.621300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610100,0.000000,17.621300>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<54.610000,0.000000,17.621300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.181300,-1.535000,27.146300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610200,-1.535000,27.146300>}
box{<0,0,-0.100000><1.428900,0.035000,0.100000> rotate<0,0.000000,0> translate<53.181300,-1.535000,27.146300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.292500,-1.535000,62.706300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.718000,-1.535000,62.280800>}
box{<0,0,-0.203200><0.601748,0.035000,0.203200> rotate<0,44.997030,0> translate<54.292500,-1.535000,62.706300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.975000,-1.535000,9.207500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.768700,-1.535000,8.413800>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,44.997030,0> translate<53.975000,-1.535000,9.207500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.212500,0.000000,15.875000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.768700,0.000000,15.875000>}
box{<0,0,-0.100000><5.556200,0.035000,0.100000> rotate<0,0.000000,0> translate<49.212500,0.000000,15.875000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,0.000000,17.621300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.768700,0.000000,17.780000>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<54.610000,0.000000,17.621300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.292500,-1.535000,9.683800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.768800,-1.535000,9.207500>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,44.997030,0> translate<54.292500,-1.535000,9.683800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,0.000000,48.101300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.768800,0.000000,46.672500>}
box{<0,0,-0.100000><2.020628,0.035000,0.100000> rotate<0,44.997030,0> translate<53.340000,0.000000,48.101300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<53.340000,0.000000,53.975100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.768800,0.000000,52.546300>}
box{<0,0,-0.100000><2.020628,0.035000,0.100000> rotate<0,44.997030,0> translate<53.340000,0.000000,53.975100> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.451300,0.000000,69.691300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.768800,0.000000,69.373800>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<54.451300,0.000000,69.691300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.975000,0.000000,34.710000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.871300,0.000000,34.710000>}
box{<0,0,-0.203200><0.896300,0.035000,0.203200> rotate<0,0.000000,0> translate<53.975000,0.000000,34.710000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.546200,-1.535000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.927500,-1.535000,24.923800>}
box{<0,0,-0.100000><2.381300,0.035000,0.100000> rotate<0,0.000000,0> translate<52.546200,-1.535000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<43.973800,0.000000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.927500,0.000000,63.500000>}
box{<0,0,-0.100100><10.953700,0.035000,0.100100> rotate<0,0.000000,0> translate<43.973800,0.000000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<48.260000,0.000000,70.485000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.927500,0.000000,70.485000>}
box{<0,0,-0.100100><6.667500,0.035000,0.100100> rotate<0,0.000000,0> translate<48.260000,0.000000,70.485000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<49.053800,0.000000,15.398800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.927600,0.000000,15.398800>}
box{<0,0,-0.100000><5.873800,0.035000,0.100000> rotate<0,0.000000,0> translate<49.053800,0.000000,15.398800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610100,0.000000,16.351300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.927600,0.000000,16.668800>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<54.610100,0.000000,16.351300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.927500,0.000000,16.668800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.927600,0.000000,16.668800>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<54.927500,0.000000,16.668800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451300,0.000000,16.827500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.927600,0.000000,17.303800>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,-44.997030,0> translate<54.451300,0.000000,16.827500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.942500,0.000000,71.278800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.927600,0.000000,71.278800>}
box{<0,0,-0.100100><6.985100,0.035000,0.100100> rotate<0,0.000000,0> translate<47.942500,0.000000,71.278800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610200,-1.535000,27.146300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.927700,-1.535000,26.828800>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<54.610200,-1.535000,27.146300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.895100,0.000000,14.922500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.086200,0.000000,14.922500>}
box{<0,0,-0.100000><6.191100,0.035000,0.100000> rotate<0,0.000000,0> translate<48.895100,0.000000,14.922500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.768700,0.000000,15.875000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.086200,0.000000,16.192500>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<54.768700,0.000000,15.875000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.927500,0.000000,16.668800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.086200,0.000000,16.827500>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<54.927500,0.000000,16.668800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.133800,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.086200,-1.535000,27.622500>}
box{<0,0,-0.100000><0.952400,0.035000,0.100000> rotate<0,0.000000,0> translate<54.133800,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.130000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.086300,-1.535000,45.720000>}
box{<0,0,-0.100100><0.956300,0.035000,0.100100> rotate<0,0.000000,0> translate<54.130000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.927500,-1.535000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.244900,-1.535000,24.606300>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,45.006054,0> translate<54.927500,-1.535000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.610000,0.000000,19.208800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.245000,0.000000,19.843800>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<54.610000,0.000000,19.208800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.245000,0.000000,20.478700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.245000,0.000000,19.843800>}
box{<0,0,-0.100100><0.634900,0.035000,0.100100> rotate<0,-90.000000,0> translate<55.245000,0.000000,19.843800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451300,0.000000,20.320100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.245000,0.000000,21.113800>}
box{<0,0,-0.100000><1.122461,0.035000,0.100000> rotate<0,-44.997030,0> translate<54.451300,0.000000,20.320100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.245000,0.000000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.245000,0.000000,21.113800>}
box{<0,0,-0.100000><3.492500,0.035000,0.100000> rotate<0,-90.000000,0> translate<55.245000,0.000000,21.113800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.244900,-1.535000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.245000,-1.535000,24.606300>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<55.244900,-1.535000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.871300,0.000000,34.710000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.245000,0.000000,35.083800>}
box{<0,0,-0.203200><0.528562,0.035000,0.203200> rotate<0,-45.004695,0> translate<54.871300,0.000000,34.710000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.245000,0.000000,36.512600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.245000,0.000000,35.083800>}
box{<0,0,-0.203200><1.428800,0.035000,0.203200> rotate<0,-90.000000,0> translate<55.245000,0.000000,35.083800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.022500,-1.535000,49.053900>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.245000,-1.535000,49.053900>}
box{<0,0,-0.203200><2.222500,0.035000,0.203200> rotate<0,0.000000,0> translate<53.022500,-1.535000,49.053900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.610000,-1.535000,73.342500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.245000,-1.535000,73.977500>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<54.610000,-1.535000,73.342500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.736200,0.000000,14.446300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.245100,0.000000,14.446300>}
box{<0,0,-0.100000><6.508900,0.035000,0.100000> rotate<0,0.000000,0> translate<48.736200,0.000000,14.446300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.927600,0.000000,15.398800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.245100,0.000000,15.716300>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<54.927600,0.000000,15.398800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.244900,-1.535000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.245100,-1.535000,24.606300>}
box{<0,0,-0.100000><0.000200,0.035000,0.100000> rotate<0,0.000000,0> translate<55.244900,-1.535000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.245000,-1.535000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.245100,-1.535000,24.606300>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<55.245000,-1.535000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.577500,0.000000,13.970000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.403700,0.000000,13.970000>}
box{<0,0,-0.100000><6.826200,0.035000,0.100000> rotate<0,0.000000,0> translate<48.577500,0.000000,13.970000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.451300,0.000000,44.291300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.403700,0.000000,44.291200>}
box{<0,0,-0.203200><0.952400,0.035000,0.203200> rotate<0,0.006016,0> translate<54.451300,0.000000,44.291300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.086200,0.000000,14.922500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.403800,0.000000,15.240000>}
box{<0,0,-0.100000><0.449084,0.035000,0.100000> rotate<0,-44.988009,0> translate<55.086200,0.000000,14.922500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.245000,-1.535000,49.053900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.403800,-1.535000,49.053800>}
box{<0,0,-0.100100><0.158800,0.035000,0.100100> rotate<0,0.036078,0> translate<55.245000,-1.535000,49.053900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.245100,0.000000,14.446300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.562500,0.000000,14.763700>}
box{<0,0,-0.100000><0.448871,0.035000,0.100000> rotate<0,-44.997030,0> translate<55.245100,0.000000,14.446300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.086200,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.562500,-1.535000,27.622500>}
box{<0,0,-0.100100><0.476300,0.035000,0.100100> rotate<0,0.000000,0> translate<55.086200,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.130000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.562500,-1.535000,38.100000>}
box{<0,0,-0.203200><1.432500,0.035000,0.203200> rotate<0,0.000000,0> translate<54.130000,-1.535000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.292500,0.000000,51.117500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.562500,0.000000,51.117500>}
box{<0,0,-0.100000><1.270000,0.035000,0.100000> rotate<0,0.000000,0> translate<54.292500,0.000000,51.117500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,0.000000,53.975000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.562500,0.000000,53.022500>}
box{<0,0,-0.100000><1.347038,0.035000,0.100000> rotate<0,44.997030,0> translate<54.610000,0.000000,53.975000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.927500,0.000000,70.485000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.562500,0.000000,71.120000>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<54.927500,0.000000,70.485000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.086200,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.562600,-1.535000,27.622500>}
box{<0,0,-0.100000><0.476400,0.035000,0.100000> rotate<0,0.000000,0> translate<55.086200,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.657500,-1.535000,66.198700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.562600,-1.535000,64.293800>}
box{<0,0,-0.203200><2.694077,0.035000,0.203200> rotate<0,44.994023,0> translate<53.657500,-1.535000,66.198700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.705100,-1.535000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.721200,-1.535000,25.400000>}
box{<0,0,-0.100000><3.016100,0.035000,0.100000> rotate<0,0.000000,0> translate<52.705100,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.721300,0.000000,10.795000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.721300,0.000000,9.842500>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,-90.000000,0> translate<55.721300,0.000000,9.842500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530100,0.000000,10.795000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.721300,0.000000,10.795000>}
box{<0,0,-0.203200><6.191200,0.035000,0.203200> rotate<0,0.000000,0> translate<49.530100,0.000000,10.795000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.721300,0.000000,10.795000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.721300,0.000000,10.795100>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,90.000000,0> translate<55.721300,0.000000,10.795100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.403700,0.000000,13.970000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.721300,0.000000,14.287500>}
box{<0,0,-0.100000><0.449084,0.035000,0.100000> rotate<0,-44.988009,0> translate<55.403700,0.000000,13.970000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.863700,-1.535000,23.336200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.721300,-1.535000,23.336300>}
box{<0,0,-0.100000><2.857600,0.035000,0.100000> rotate<0,-0.002005,0> translate<52.863700,-1.535000,23.336200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.130000,-1.535000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.721300,-1.535000,43.180000>}
box{<0,0,-0.100100><1.591300,0.035000,0.100100> rotate<0,0.000000,0> translate<54.130000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.130000,-1.535000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.721300,-1.535000,44.450000>}
box{<0,0,-0.100100><1.591300,0.035000,0.100100> rotate<0,0.000000,0> translate<54.130000,-1.535000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451300,0.000000,51.911300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.721300,0.000000,51.911300>}
box{<0,0,-0.100000><1.270000,0.035000,0.100000> rotate<0,0.000000,0> translate<54.451300,0.000000,51.911300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.927600,0.000000,71.278800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.721300,0.000000,72.072500>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,-44.997030,0> translate<54.927600,0.000000,71.278800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,0.000000,2.540000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<54.610000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<51.435000,0.000000,9.525000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,0.000000,5.080000>}
box{<0,0,-0.100000><6.286179,0.035000,0.100000> rotate<0,44.997030,0> translate<51.435000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,-1.535000,11.588800>}
box{<0,0,-0.100000><0.019000,0.035000,0.100000> rotate<0,-90.000000,0> translate<55.880000,-1.535000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,-1.535000,13.493800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,-1.535000,11.607800>}
box{<0,0,-0.100000><1.886000,0.035000,0.100000> rotate<0,-90.000000,0> translate<55.880000,-1.535000,11.607800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<48.418800,0.000000,13.493800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,0.000000,13.493800>}
box{<0,0,-0.100000><7.461200,0.035000,0.100000> rotate<0,0.000000,0> translate<48.418800,0.000000,13.493800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,-1.535000,20.161300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,-1.535000,21.539200>}
box{<0,0,-0.100000><1.377900,0.035000,0.100000> rotate<0,90.000000,0> translate<55.880000,-1.535000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.562500,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,-1.535000,27.305000>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<55.562500,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.562600,-1.535000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,-1.535000,27.305000>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,45.006054,0> translate<55.562600,-1.535000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,-1.535000,30.162500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,-1.535000,31.270000>}
box{<0,0,-0.100100><1.107500,0.035000,0.100100> rotate<0,90.000000,0> translate<55.880000,-1.535000,31.270000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,-1.535000,31.270000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,-1.535000,31.273800>}
box{<0,0,-0.100100><0.003800,0.035000,0.100100> rotate<0,90.000000,0> translate<55.880000,-1.535000,31.273800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,-1.535000,45.878800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,-1.535000,47.470000>}
box{<0,0,-0.100000><1.591200,0.035000,0.100000> rotate<0,90.000000,0> translate<55.880000,-1.535000,47.470000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.228800,-1.535000,63.182500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.880000,-1.535000,59.531300>}
box{<0,0,-0.203200><5.163577,0.035000,0.203200> rotate<0,44.997030,0> translate<52.228800,-1.535000,63.182500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.181300,0.000000,62.230000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.880000,0.000000,59.531300>}
box{<0,0,-0.203200><3.816538,0.035000,0.203200> rotate<0,44.997030,0> translate<53.181300,0.000000,62.230000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.927500,0.000000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,0.000000,64.452500>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,-44.997030,0> translate<54.927500,0.000000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,0.000000,64.452500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,0.000000,66.548000>}
box{<0,0,-0.100100><2.095500,0.035000,0.100100> rotate<0,90.000000,0> translate<55.880000,0.000000,66.548000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,0.000000,68.072000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,0.000000,67.945000>}
box{<0,0,-0.100100><0.127000,0.035000,0.100100> rotate<0,-90.000000,0> translate<55.880000,0.000000,67.945000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,0.000000,68.072000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,0.000000,70.167500>}
box{<0,0,-0.100100><2.095500,0.035000,0.100100> rotate<0,90.000000,0> translate<55.880000,0.000000,70.167500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.657500,-1.535000,73.818800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.880000,-1.535000,76.200000>}
box{<0,0,-0.203200><3.257241,0.035000,0.203200> rotate<0,-46.971234,0> translate<53.657500,-1.535000,73.818800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,0.000000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880100,0.000000,57.150000>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,0.000000,0> translate<55.880000,0.000000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,-1.535000,20.161300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038700,-1.535000,20.002500>}
box{<0,0,-0.100000><0.224506,0.035000,0.100000> rotate<0,45.015075,0> translate<55.880000,-1.535000,20.161300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038700,0.000000,20.002500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038800,0.000000,20.002500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<56.038700,0.000000,20.002500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038700,-1.535000,20.002500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038800,-1.535000,20.002500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<56.038700,-1.535000,20.002500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038700,0.000000,20.002500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038800,0.000000,20.320100>}
box{<0,0,-0.100000><0.317600,0.035000,0.100000> rotate<0,-89.976021,0> translate<56.038700,0.000000,20.002500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038700,0.000000,20.637600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038800,0.000000,20.320100>}
box{<0,0,-0.100000><0.317500,0.035000,0.100000> rotate<0,89.976016,0> translate<56.038700,0.000000,20.637600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.245000,0.000000,20.478700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.038800,0.000000,21.272500>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,-44.997030,0> translate<55.245000,0.000000,20.478700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.038800,0.000000,26.035000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.038800,0.000000,21.272500>}
box{<0,0,-0.100100><4.762500,0.035000,0.100100> rotate<0,-90.000000,0> translate<56.038800,0.000000,21.272500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.721200,-1.535000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038800,-1.535000,25.082500>}
box{<0,0,-0.100000><0.449084,0.035000,0.100000> rotate<0,44.988009,0> translate<55.721200,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.133700,-1.535000,26.035000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.038800,-1.535000,26.035000>}
box{<0,0,-0.100100><1.905100,0.035000,0.100100> rotate<0,0.000000,0> translate<54.133700,-1.535000,26.035000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.086200,0.000000,27.622500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.038800,0.000000,28.575000>}
box{<0,0,-0.100100><1.347109,0.035000,0.100100> rotate<0,-44.994023,0> translate<55.086200,0.000000,27.622500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.038800,0.000000,28.575000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.038800,0.000000,32.543800>}
box{<0,0,-0.100100><3.968800,0.035000,0.100100> rotate<0,90.000000,0> translate<56.038800,0.000000,32.543800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.975000,0.000000,37.306200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.038800,0.000000,39.370000>}
box{<0,0,-0.203200><2.918654,0.035000,0.203200> rotate<0,-44.997030,0> translate<53.975000,0.000000,37.306200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.130000,-1.535000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.038800,-1.535000,39.370000>}
box{<0,0,-0.203200><1.908800,0.035000,0.203200> rotate<0,0.000000,0> translate<54.130000,-1.535000,39.370000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.451300,-1.535000,66.833800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.038800,-1.535000,65.246300>}
box{<0,0,-0.100100><2.245064,0.035000,0.100100> rotate<0,44.997030,0> translate<54.451300,-1.535000,66.833800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038900,-1.535000,27.781300>}
box{<0,0,-0.100000><2.020628,0.035000,0.100000> rotate<0,44.993020,0> translate<54.610000,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.292600,-1.535000,30.162500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.197500,-1.535000,28.257600>}
box{<0,0,-0.100000><2.693935,0.035000,0.100000> rotate<0,44.997030,0> translate<54.292600,-1.535000,30.162500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.245000,0.000000,36.512600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.197500,0.000000,37.465000>}
box{<0,0,-0.203200><1.346968,0.035000,0.203200> rotate<0,-44.994023,0> translate<55.245000,0.000000,36.512600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.562500,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.197500,-1.535000,37.465000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<55.562500,-1.535000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.721300,-1.535000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.197500,-1.535000,42.703800>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,44.997030,0> translate<55.721300,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,-1.535000,45.878800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.197500,-1.535000,45.561300>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<55.880000,-1.535000,45.878800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.768800,0.000000,52.546300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.197500,0.000000,52.546300>}
box{<0,0,-0.100000><1.428700,0.035000,0.100000> rotate<0,0.000000,0> translate<54.768800,0.000000,52.546300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038800,-1.535000,26.035000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.197700,-1.535000,26.193800>}
box{<0,0,-0.100000><0.224648,0.035000,0.100000> rotate<0,-44.978997,0> translate<56.038800,-1.535000,26.035000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.451200,-1.535000,30.638800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.356200,-1.535000,28.733800>}
box{<0,0,-0.100100><2.694077,0.035000,0.100100> rotate<0,44.997030,0> translate<54.451200,-1.535000,30.638800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.403700,0.000000,44.291200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.356200,0.000000,44.291200>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,0.000000,0> translate<55.403700,0.000000,44.291200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.721300,0.000000,14.287500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.356300,0.000000,14.287500>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,0.000000,0> translate<55.721300,0.000000,14.287500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451200,-1.535000,50.165000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.356300,-1.535000,50.165000>}
box{<0,0,-0.100000><1.905100,0.035000,0.100000> rotate<0,0.000000,0> translate<54.451200,-1.535000,50.165000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.721300,0.000000,10.795000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,0.000000,11.588700>}
box{<0,0,-0.203200><1.122461,0.035000,0.203200> rotate<0,-44.997030,0> translate<55.721300,0.000000,10.795000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.721300,0.000000,10.795100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,0.000000,11.588800>}
box{<0,0,-0.203200><1.122461,0.035000,0.203200> rotate<0,-44.997030,0> translate<55.721300,0.000000,10.795100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,0.000000,11.588700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,0.000000,11.588800>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,90.000000,0> translate<56.515000,0.000000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038800,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.515000,-1.535000,25.082500>}
box{<0,0,-0.100000><0.476200,0.035000,0.100000> rotate<0,0.000000,0> translate<56.038800,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,-1.535000,30.162500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.515000,-1.535000,29.527500>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<55.880000,-1.535000,30.162500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.038800,0.000000,32.543800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.515000,0.000000,33.020000>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,-44.997030,0> translate<56.038800,0.000000,32.543800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.515000,0.000000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.515000,0.000000,34.658300>}
box{<0,0,-0.100100><1.638300,0.035000,0.100100> rotate<0,90.000000,0> translate<56.515000,0.000000,34.658300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,0.000000,44.716700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,0.000000,40.322500>}
box{<0,0,-0.203200><4.394200,0.035000,0.203200> rotate<0,-90.000000,0> translate<56.515000,0.000000,40.322500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,0.000000,44.767500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,0.000000,44.716700>}
box{<0,0,-0.203200><0.050800,0.035000,0.203200> rotate<0,-90.000000,0> translate<56.515000,0.000000,44.716700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.356200,0.000000,44.291200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.515000,0.000000,44.767500>}
box{<0,0,-0.100100><0.502075,0.035000,0.100100> rotate<0,-71.556720,0> translate<56.356200,0.000000,44.291200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.403800,-1.535000,49.053800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,-1.535000,49.053700>}
box{<0,0,-0.203200><1.111200,0.035000,0.203200> rotate<0,0.005156,0> translate<55.403800,-1.535000,49.053800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.562500,0.000000,53.022500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.515000,0.000000,53.022500>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,0.000000,0> translate<55.562500,0.000000,53.022500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,-1.535000,62.280800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,-1.535000,60.483800>}
box{<0,0,-0.203200><1.797000,0.035000,0.203200> rotate<0,-90.000000,0> translate<56.515000,-1.535000,60.483800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.718000,-1.535000,62.280800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,-1.535000,62.280800>}
box{<0,0,-0.203200><1.797000,0.035000,0.203200> rotate<0,0.000000,0> translate<54.718000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880000,-1.535000,70.167500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.515000,-1.535000,70.802500>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<55.880000,-1.535000,70.167500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.515000,-1.535000,70.802500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.515000,-1.535000,72.339200>}
box{<0,0,-0.100100><1.536700,0.035000,0.100100> rotate<0,90.000000,0> translate<56.515000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.721300,0.000000,10.795000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515100,0.000000,11.588800>}
box{<0,0,-0.203200><1.122603,0.035000,0.203200> rotate<0,-44.997030,0> translate<55.721300,0.000000,10.795000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038700,0.000000,20.637600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.673800,0.000000,21.272600>}
box{<0,0,-0.100000><0.898096,0.035000,0.100000> rotate<0,-44.992519,0> translate<56.038700,0.000000,20.637600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.721300,-1.535000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.673800,-1.535000,43.497500>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,44.997030,0> translate<55.721300,-1.535000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.086300,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.673800,-1.535000,44.132500>}
box{<0,0,-0.100100><2.245064,0.035000,0.100100> rotate<0,44.997030,0> translate<55.086300,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.245000,-1.535000,73.977500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.673800,-1.535000,73.977500>}
box{<0,0,-0.100100><1.428800,0.035000,0.100100> rotate<0,0.000000,0> translate<55.245000,-1.535000,73.977500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.673800,0.000000,21.272600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.673900,0.000000,25.241200>}
box{<0,0,-0.100000><3.968600,0.035000,0.100000> rotate<0,-89.992617,0> translate<56.673800,0.000000,21.272600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.515000,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.832400,-1.535000,25.399900>}
box{<0,0,-0.100000><0.448871,0.035000,0.100000> rotate<0,-44.997030,0> translate<56.515000,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.673900,0.000000,25.241200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.832500,0.000000,25.399900>}
box{<0,0,-0.100000><0.224365,0.035000,0.100000> rotate<0,-45.015086,0> translate<56.673900,0.000000,25.241200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.832400,-1.535000,25.399900>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.832500,-1.535000,25.399900>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<56.832400,-1.535000,25.399900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.133800,0.000000,46.196300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.832500,0.000000,46.196300>}
box{<0,0,-0.100100><2.698700,0.035000,0.100100> rotate<0,0.000000,0> translate<54.133800,0.000000,46.196300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.880000,0.000000,59.531300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.832500,0.000000,59.531300>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,0.000000,0> translate<55.880000,0.000000,59.531300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.515000,-1.535000,29.527500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.991300,-1.535000,29.527500>}
box{<0,0,-0.100100><0.476300,0.035000,0.100100> rotate<0,0.000000,0> translate<56.515000,-1.535000,29.527500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.991300,0.000000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.991300,0.000000,29.527500>}
box{<0,0,-0.100100><3.175000,0.035000,0.100100> rotate<0,90.000000,0> translate<56.991300,0.000000,29.527500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<44.767500,-1.535000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,-1.535000,3.810000>}
box{<0,0,-0.100100><12.382500,0.035000,0.100100> rotate<0,0.000000,0> translate<44.767500,-1.535000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.150000,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.150000,-1.535000,11.588800>}
box{<0,0,-0.100000><0.019000,0.035000,0.100000> rotate<0,-90.000000,0> translate<57.150000,-1.535000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.150000,-1.535000,13.493800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.150000,-1.535000,11.607800>}
box{<0,0,-0.100000><1.886000,0.035000,0.100000> rotate<0,-90.000000,0> translate<57.150000,-1.535000,11.607800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.356300,0.000000,14.287500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.150000,0.000000,13.493800>}
box{<0,0,-0.100000><1.122461,0.035000,0.100000> rotate<0,44.997030,0> translate<56.356300,0.000000,14.287500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.562500,0.000000,14.763700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.150000,0.000000,14.763800>}
box{<0,0,-0.100000><1.587500,0.035000,0.100000> rotate<0,-0.003609,0> translate<55.562500,0.000000,14.763700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,-1.535000,20.002500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,-1.535000,21.539200>}
box{<0,0,-0.100100><1.536700,0.035000,0.100100> rotate<0,90.000000,0> translate<57.150000,-1.535000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.832500,-1.535000,25.399900>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.150000,-1.535000,25.082500>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,44.988006,0> translate<56.832500,-1.535000,25.399900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,-1.535000,32.385000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,-1.535000,31.270000>}
box{<0,0,-0.100100><1.115000,0.035000,0.100100> rotate<0,-90.000000,0> translate<57.150000,-1.535000,31.270000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.515000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,-1.535000,32.385000>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<56.515000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,0.000000,45.878800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,0.000000,43.021300>}
box{<0,0,-0.100100><2.857500,0.035000,0.100100> rotate<0,-90.000000,0> translate<57.150000,0.000000,43.021300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.832500,0.000000,46.196300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,0.000000,45.878800>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<56.832500,0.000000,46.196300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.768800,0.000000,46.672500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.150000,0.000000,46.672500>}
box{<0,0,-0.100000><2.381200,0.035000,0.100000> rotate<0,0.000000,0> translate<54.768800,0.000000,46.672500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,-1.535000,47.470000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,-1.535000,47.466300>}
box{<0,0,-0.100100><0.003700,0.035000,0.100100> rotate<0,-90.000000,0> translate<57.150000,-1.535000,47.466300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,-1.535000,48.418800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,-1.535000,47.470000>}
box{<0,0,-0.100100><0.948800,0.035000,0.100100> rotate<0,-90.000000,0> translate<57.150000,-1.535000,47.470000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,-1.535000,49.053700>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.150000,-1.535000,48.418800>}
box{<0,0,-0.203200><0.897955,0.035000,0.203200> rotate<0,44.992519,0> translate<56.515000,-1.535000,49.053700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,0.000000,20.002500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150100,0.000000,20.320000>}
box{<0,0,-0.100100><0.317500,0.035000,0.100100> rotate<0,-89.976016,0> translate<57.150000,0.000000,20.002500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150100,0.000000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150100,0.000000,24.606300>}
box{<0,0,-0.100100><4.286300,0.035000,0.100100> rotate<0,90.000000,0> translate<57.150100,0.000000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.197700,-1.535000,26.193800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.150100,-1.535000,26.193800>}
box{<0,0,-0.100000><0.952400,0.035000,0.100000> rotate<0,0.000000,0> translate<56.197700,-1.535000,26.193800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<47.307500,0.000000,74.453800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.308700,0.000000,74.453800>}
box{<0,0,-0.100100><10.001200,0.035000,0.100100> rotate<0,0.000000,0> translate<47.307500,0.000000,74.453800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.197500,-1.535000,45.561300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.308800,-1.535000,45.561300>}
box{<0,0,-0.100000><1.111300,0.035000,0.100000> rotate<0,0.000000,0> translate<56.197500,-1.535000,45.561300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,-1.535000,47.466300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.308800,-1.535000,47.307500>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<57.150000,-1.535000,47.466300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.308800,0.000000,54.133800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.308800,0.000000,55.721200>}
box{<0,0,-0.100000><1.587400,0.035000,0.100000> rotate<0,90.000000,0> translate<57.308800,0.000000,55.721200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.880100,0.000000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.308800,0.000000,55.721300>}
box{<0,0,-0.100100><2.020487,0.035000,0.100100> rotate<0,44.997030,0> translate<55.880100,0.000000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.308800,0.000000,55.721200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.308800,0.000000,55.721300>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<57.308800,0.000000,55.721300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.038800,-1.535000,65.246300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.308800,-1.535000,65.246300>}
box{<0,0,-0.100100><1.270000,0.035000,0.100100> rotate<0,0.000000,0> translate<56.038800,-1.535000,65.246300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.673800,-1.535000,73.977500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.308800,-1.535000,74.612500>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<56.673800,-1.535000,73.977500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.308800,-1.535000,74.612500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.308800,-1.535000,76.993800>}
box{<0,0,-0.100100><2.381300,0.035000,0.100100> rotate<0,90.000000,0> translate<57.308800,-1.535000,76.993800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.927700,-1.535000,26.828800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.467400,-1.535000,26.828800>}
box{<0,0,-0.100000><2.539700,0.035000,0.100000> rotate<0,0.000000,0> translate<54.927700,-1.535000,26.828800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.197500,-1.535000,42.703800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.467500,-1.535000,42.703800>}
box{<0,0,-0.100100><1.270000,0.035000,0.100100> rotate<0,0.000000,0> translate<56.197500,-1.535000,42.703800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,0.000000,43.021300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.467500,0.000000,42.703800>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<57.150000,0.000000,43.021300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.356300,-1.535000,50.165000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.467500,-1.535000,49.053800>}
box{<0,0,-0.100000><1.571474,0.035000,0.100000> rotate<0,44.997030,0> translate<56.356300,-1.535000,50.165000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150100,0.000000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.626300,0.000000,25.082400>}
box{<0,0,-0.100100><0.673378,0.035000,0.100100> rotate<0,-44.991014,0> translate<57.150100,0.000000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.991300,0.000000,26.352500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.626300,0.000000,25.717500>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<56.991300,0.000000,26.352500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.626300,0.000000,25.082400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.626300,0.000000,25.717500>}
box{<0,0,-0.100100><0.635100,0.035000,0.100100> rotate<0,90.000000,0> translate<57.626300,0.000000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.673800,-1.535000,43.497500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.626300,-1.535000,43.497500>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,0.000000,0> translate<56.673800,-1.535000,43.497500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.673800,-1.535000,44.132500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.626300,-1.535000,44.132500>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,0.000000,0> translate<56.673800,-1.535000,44.132500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.562600,-1.535000,64.293800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.626300,-1.535000,64.293800>}
box{<0,0,-0.203200><2.063700,0.035000,0.203200> rotate<0,0.000000,0> translate<55.562600,-1.535000,64.293800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.038800,-1.535000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.626400,-1.535000,37.782500>}
box{<0,0,-0.203200><2.245135,0.035000,0.203200> rotate<0,44.995226,0> translate<56.038800,-1.535000,39.370000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.467400,-1.535000,26.828800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.784900,-1.535000,26.511300>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<57.467400,-1.535000,26.828800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<36.036300,-1.535000,10.160000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.785000,-1.535000,10.160000>}
box{<0,0,-0.100100><21.748700,0.035000,0.100100> rotate<0,0.000000,0> translate<36.036300,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785000,-1.535000,33.972500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785000,-1.535000,32.861300>}
box{<0,0,-0.203200><1.111200,0.035000,0.203200> rotate<0,-90.000000,0> translate<57.785000,-1.535000,32.861300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.785000,0.000000,33.337500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.785000,0.000000,34.658300>}
box{<0,0,-0.100100><1.320800,0.035000,0.100100> rotate<0,90.000000,0> translate<57.785000,0.000000,34.658300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.197500,0.000000,37.465000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785000,0.000000,39.052500>}
box{<0,0,-0.203200><2.245064,0.035000,0.203200> rotate<0,-44.997030,0> translate<56.197500,0.000000,37.465000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.150000,0.000000,46.672500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.785000,0.000000,46.037500>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<57.150000,0.000000,46.672500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.785000,0.000000,44.716700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.785000,0.000000,46.037500>}
box{<0,0,-0.100000><1.320800,0.035000,0.100000> rotate<0,90.000000,0> translate<57.785000,0.000000,46.037500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.785000,-1.535000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.785000,-1.535000,47.466300>}
box{<0,0,-0.100100><1.270000,0.035000,0.100100> rotate<0,-90.000000,0> translate<57.785000,-1.535000,47.466300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.467500,-1.535000,49.053800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.785000,-1.535000,48.736300>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<57.467500,-1.535000,49.053800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.562500,0.000000,51.117500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.785000,0.000000,48.895000>}
box{<0,0,-0.100000><3.143090,0.035000,0.100000> rotate<0,44.997030,0> translate<55.562500,0.000000,51.117500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.785000,0.000000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.785000,0.000000,48.895000>}
box{<0,0,-0.100000><1.905000,0.035000,0.100000> rotate<0,90.000000,0> translate<57.785000,0.000000,48.895000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.832500,0.000000,59.531300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785000,0.000000,60.483800>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,-44.997030,0> translate<56.832500,0.000000,59.531300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785000,-1.535000,60.483800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785000,-1.535000,62.280800>}
box{<0,0,-0.203200><1.797000,0.035000,0.203200> rotate<0,90.000000,0> translate<57.785000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.785000,-1.535000,70.961300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.785000,-1.535000,72.339200>}
box{<0,0,-0.100100><1.377900,0.035000,0.100100> rotate<0,90.000000,0> translate<57.785000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.308800,-1.535000,76.993800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.785000,-1.535000,77.470000>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,-44.997030,0> translate<57.308800,-1.535000,76.993800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.150100,-1.535000,26.193800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.785100,-1.535000,25.558700>}
box{<0,0,-0.100000><0.898096,0.035000,0.100000> rotate<0,45.001541,0> translate<57.150100,-1.535000,26.193800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.626400,0.000000,37.782500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785100,0.000000,37.623800>}
box{<0,0,-0.203200><0.224436,0.035000,0.203200> rotate<0,44.997030,0> translate<57.626400,0.000000,37.782500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,0.000000,40.322500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785100,0.000000,39.052500>}
box{<0,0,-0.203200><1.796122,0.035000,0.203200> rotate<0,44.994775,0> translate<56.515000,0.000000,40.322500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785000,0.000000,39.052500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785100,0.000000,39.052500>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,0.000000,0> translate<57.785000,0.000000,39.052500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.784900,-1.535000,26.511300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.943600,-1.535000,26.670000>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<57.784900,-1.535000,26.511300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.403800,0.000000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.943800,0.000000,15.240000>}
box{<0,0,-0.100000><2.540000,0.035000,0.100000> rotate<0,0.000000,0> translate<55.403800,0.000000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.721300,0.000000,51.911300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.943800,0.000000,49.688800>}
box{<0,0,-0.100000><3.143090,0.035000,0.100000> rotate<0,44.997030,0> translate<55.721300,0.000000,51.911300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.785000,0.000000,33.337500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.102500,0.000000,33.020000>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<57.785000,0.000000,33.337500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.626300,-1.535000,64.293800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<58.102500,-1.535000,64.770000>}
box{<0,0,-0.203200><0.673448,0.035000,0.203200> rotate<0,-44.997030,0> translate<57.626300,-1.535000,64.293800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<56.356200,-1.535000,28.733800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.261200,-1.535000,28.733800>}
box{<0,0,-0.100100><1.905000,0.035000,0.100100> rotate<0,0.000000,0> translate<56.356200,-1.535000,28.733800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.768800,-1.535000,9.207500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.261300,-1.535000,9.207500>}
box{<0,0,-0.100100><3.492500,0.035000,0.100100> rotate<0,0.000000,0> translate<54.768800,-1.535000,9.207500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.261300,0.000000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.261300,0.000000,21.272500>}
box{<0,0,-0.100000><4.603800,0.035000,0.100000> rotate<0,-90.000000,0> translate<58.261300,0.000000,21.272500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785000,-1.535000,33.972500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<58.261300,-1.535000,34.448800>}
box{<0,0,-0.203200><0.673590,0.035000,0.203200> rotate<0,-44.997030,0> translate<57.785000,-1.535000,33.972500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.943800,-1.535000,49.688800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.261300,-1.535000,49.371400>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,44.988006,0> translate<57.943800,-1.535000,49.688800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785000,0.000000,60.483800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<58.261300,0.000000,60.483800>}
box{<0,0,-0.203200><0.476300,0.035000,0.203200> rotate<0,0.000000,0> translate<57.785000,0.000000,60.483800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.261200,0.000000,21.272600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.261400,0.000000,25.876300>}
box{<0,0,-0.100000><4.603700,0.035000,0.100000> rotate<0,-89.991571,0> translate<58.261200,0.000000,21.272600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.785000,-1.535000,47.466300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.416300,-1.535000,47.466300>}
box{<0,0,-0.100100><0.631300,0.035000,0.100100> rotate<0,0.000000,0> translate<57.785000,-1.535000,47.466300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.150000,-1.535000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,-1.535000,2.540000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<57.150000,-1.535000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<53.498700,0.000000,10.001300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,0.000000,5.080000>}
box{<0,0,-0.100100><6.959769,0.035000,0.100100> rotate<0,44.997030,0> translate<53.498700,0.000000,10.001300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,-1.535000,11.588800>}
box{<0,0,-0.100000><0.019000,0.035000,0.100000> rotate<0,-90.000000,0> translate<58.420000,-1.535000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,-1.535000,13.493800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,-1.535000,11.607800>}
box{<0,0,-0.100000><1.886000,0.035000,0.100000> rotate<0,-90.000000,0> translate<58.420000,-1.535000,11.607800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.150000,0.000000,14.763800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,0.000000,13.493800>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<57.150000,0.000000,14.763800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.245100,0.000000,15.716300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,0.000000,15.716300>}
box{<0,0,-0.100000><3.174900,0.035000,0.100000> rotate<0,0.000000,0> translate<55.245100,0.000000,15.716300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,-1.535000,15.716300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,-1.535000,21.539200>}
box{<0,0,-0.100000><5.822900,0.035000,0.100000> rotate<0,90.000000,0> translate<58.420000,-1.535000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,-1.535000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,-1.535000,21.590000>}
box{<0,0,-0.100000><0.050800,0.035000,0.100000> rotate<0,90.000000,0> translate<58.420000,-1.535000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<58.420000,-1.535000,32.226300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<58.420000,-1.535000,31.270000>}
box{<0,0,-0.203200><0.956300,0.035000,0.203200> rotate<0,-90.000000,0> translate<58.420000,-1.535000,31.270000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785000,-1.535000,32.861300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<58.420000,-1.535000,32.226300>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,44.997030,0> translate<57.785000,-1.535000,32.861300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.416300,-1.535000,47.466300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,-1.535000,47.470000>}
box{<0,0,-0.100100><0.005233,0.035000,0.100100> rotate<0,-44.997030,0> translate<58.416300,-1.535000,47.466300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,0.000000,53.657500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,0.000000,54.610000>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,90.000000,0> translate<58.420000,0.000000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,0.000000,64.293800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,0.000000,63.817500>}
box{<0,0,-0.100100><0.476300,0.035000,0.100100> rotate<0,-90.000000,0> translate<58.420000,0.000000,63.817500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.308800,0.000000,65.246300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,0.000000,66.357500>}
box{<0,0,-0.100100><1.571474,0.035000,0.100100> rotate<0,-44.997030,0> translate<57.308800,0.000000,65.246300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,0.000000,66.357500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,0.000000,66.548000>}
box{<0,0,-0.100100><0.190500,0.035000,0.100100> rotate<0,90.000000,0> translate<58.420000,0.000000,66.548000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.768800,-1.535000,69.373800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,-1.535000,69.373800>}
box{<0,0,-0.100100><3.651200,0.035000,0.100100> rotate<0,0.000000,0> translate<54.768800,-1.535000,69.373800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.785000,-1.535000,70.961300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,-1.535000,70.326300>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<57.785000,-1.535000,70.961300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,0.000000,68.072000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,0.000000,70.326300>}
box{<0,0,-0.100100><2.254300,0.035000,0.100100> rotate<0,90.000000,0> translate<58.420000,0.000000,70.326300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.292500,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420100,-1.535000,23.812500>}
box{<0,0,-0.100000><4.127600,0.035000,0.100000> rotate<0,0.000000,0> translate<54.292500,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.721300,-1.535000,23.336300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.578800,-1.535000,23.336300>}
box{<0,0,-0.100000><2.857500,0.035000,0.100000> rotate<0,0.000000,0> translate<55.721300,-1.535000,23.336300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.261300,-1.535000,49.371400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.578800,-1.535000,49.371300>}
box{<0,0,-0.100100><0.317500,0.035000,0.100100> rotate<0,0.018045,0> translate<58.261300,-1.535000,49.371400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,0.000000,15.716300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.737500,0.000000,15.398800>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<58.420000,0.000000,15.716300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,-1.535000,15.716300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.737500,-1.535000,15.398800>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<58.420000,-1.535000,15.716300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<52.546300,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.737500,-1.535000,22.860000>}
box{<0,0,-0.100000><6.191200,0.035000,0.100000> rotate<0,0.000000,0> translate<52.546300,-1.535000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420100,-1.535000,23.812500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.737500,-1.535000,24.130000>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,-45.006054,0> translate<58.420100,-1.535000,23.812500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.784900,0.000000,26.511300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.737500,0.000000,27.463800>}
box{<0,0,-0.100100><1.347109,0.035000,0.100100> rotate<0,-44.994023,0> translate<57.784900,0.000000,26.511300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.737500,0.000000,27.463800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.737500,0.000000,28.575000>}
box{<0,0,-0.100100><1.111200,0.035000,0.100100> rotate<0,90.000000,0> translate<58.737500,0.000000,28.575000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.261200,-1.535000,28.733800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.737500,-1.535000,29.210000>}
box{<0,0,-0.100100><0.673519,0.035000,0.100100> rotate<0,-44.991015,0> translate<58.261200,-1.535000,28.733800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.102500,0.000000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.737500,0.000000,33.020000>}
box{<0,0,-0.100100><0.635000,0.035000,0.100100> rotate<0,0.000000,0> translate<58.102500,0.000000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.308700,0.000000,74.453800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.737500,0.000000,73.025000>}
box{<0,0,-0.100100><2.020628,0.035000,0.100100> rotate<0,44.997030,0> translate<57.308700,0.000000,74.453800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.261300,0.000000,9.207500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.737600,0.000000,9.683800>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,-44.997030,0> translate<58.261300,0.000000,9.207500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.197500,-1.535000,28.257600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.737600,-1.535000,28.257500>}
box{<0,0,-0.100000><2.540100,0.035000,0.100000> rotate<0,0.002256,0> translate<56.197500,-1.535000,28.257600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<58.840000,-1.535000,76.256300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<58.840000,-1.535000,76.200000>}
box{<0,0,-0.203200><0.056300,0.035000,0.203200> rotate<0,-90.000000,0> translate<58.840000,-1.535000,76.200000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<39.846300,-1.535000,6.984900>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.896300,-1.535000,6.985000>}
box{<0,0,-0.100000><19.050000,0.035000,0.100000> rotate<0,-0.000301,0> translate<39.846300,-1.535000,6.984900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<54.768700,-1.535000,8.413800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.896300,-1.535000,8.413800>}
box{<0,0,-0.100100><4.127600,0.035000,0.100100> rotate<0,0.000000,0> translate<54.768700,-1.535000,8.413800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.737500,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.896300,-1.535000,23.018800>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,-44.997030,0> translate<58.737500,-1.535000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.578800,-1.535000,23.336300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.896300,-1.535000,23.653800>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<58.578800,-1.535000,23.336300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.785100,-1.535000,25.558700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.896300,-1.535000,25.558800>}
box{<0,0,-0.100000><1.111200,0.035000,0.100000> rotate<0,-0.005156,0> translate<57.785100,-1.535000,25.558700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.896300,-1.535000,49.371300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.896300,-1.535000,49.371200>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,-90.000000,0> translate<58.896300,-1.535000,49.371200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.578800,-1.535000,49.371300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.896300,-1.535000,49.371300>}
box{<0,0,-0.100100><0.317500,0.035000,0.100100> rotate<0,0.000000,0> translate<58.578800,-1.535000,49.371300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.896300,-1.535000,49.371300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.896300,-1.535000,50.323800>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,90.000000,0> translate<58.896300,-1.535000,50.323800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.562500,0.000000,71.120000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.896300,0.000000,71.120000>}
box{<0,0,-0.100100><3.333800,0.035000,0.100100> rotate<0,0.000000,0> translate<55.562500,0.000000,71.120000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<46.990000,-1.535000,6.350000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,6.350000>}
box{<0,0,-0.100100><12.065000,0.035000,0.100100> rotate<0,0.000000,0> translate<46.990000,-1.535000,6.350000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.721300,0.000000,9.842500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<59.055000,0.000000,6.508800>}
box{<0,0,-0.203200><4.714564,0.035000,0.203200> rotate<0,44.997030,0> translate<55.721300,0.000000,9.842500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.737500,0.000000,28.575000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,0.000000,28.892500>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<58.737500,0.000000,28.575000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.737500,0.000000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,0.000000,32.702500>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<58.737500,0.000000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,0.000000,28.892500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,0.000000,32.702500>}
box{<0,0,-0.100100><3.810000,0.035000,0.100100> rotate<0,90.000000,0> translate<59.055000,0.000000,32.702500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.785000,0.000000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.055000,0.000000,45.720000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<57.785000,0.000000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.055000,0.000000,44.716700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.055000,0.000000,45.720000>}
box{<0,0,-0.100000><1.003300,0.035000,0.100000> rotate<0,90.000000,0> translate<59.055000,0.000000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.197500,0.000000,52.546300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.055000,0.000000,49.688800>}
box{<0,0,-0.100000><4.041115,0.035000,0.100000> rotate<0,44.997030,0> translate<56.197500,0.000000,52.546300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.055000,0.000000,46.672600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.055000,0.000000,49.688800>}
box{<0,0,-0.100000><3.016200,0.035000,0.100000> rotate<0,90.000000,0> translate<59.055000,0.000000,49.688800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,63.182500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,62.280800>}
box{<0,0,-0.100100><0.901700,0.035000,0.100100> rotate<0,-90.000000,0> translate<59.055000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,-1.535000,63.817500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,63.182500>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<58.420000,-1.535000,63.817500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,68.738800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,66.516300>}
box{<0,0,-0.100100><2.222500,0.035000,0.100100> rotate<0,-90.000000,0> translate<59.055000,-1.535000,66.516300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,-1.535000,69.373800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,68.738800>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<58.420000,-1.535000,69.373800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,70.961300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,72.339200>}
box{<0,0,-0.100100><1.377900,0.035000,0.100100> rotate<0,90.000000,0> translate<59.055000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,72.339200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,72.390000>}
box{<0,0,-0.100100><0.050800,0.035000,0.100100> rotate<0,90.000000,0> translate<59.055000,-1.535000,72.390000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,72.390000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,72.707500>}
box{<0,0,-0.100100><0.317500,0.035000,0.100100> rotate<0,90.000000,0> translate<59.055000,-1.535000,72.707500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,72.390000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,74.136300>}
box{<0,0,-0.100100><1.746300,0.035000,0.100100> rotate<0,90.000000,0> translate<59.055000,-1.535000,74.136300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,0.000000,74.136300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,0.000000,75.565000>}
box{<0,0,-0.100100><1.428700,0.035000,0.100100> rotate<0,90.000000,0> translate<59.055000,0.000000,75.565000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<58.840000,-1.535000,76.256300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<59.055000,-1.535000,76.041300>}
box{<0,0,-0.203200><0.304056,0.035000,0.203200> rotate<0,44.997030,0> translate<58.840000,-1.535000,76.256300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<59.055000,-1.535000,76.041300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<59.055100,-1.535000,75.247500>}
box{<0,0,-0.203200><0.793800,0.035000,0.203200> rotate<0,89.986843,0> translate<59.055000,-1.535000,76.041300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.896300,-1.535000,25.558800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.213800,-1.535000,25.876300>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<58.896300,-1.535000,25.558800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.737600,-1.535000,28.257500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.213800,-1.535000,28.733800>}
box{<0,0,-0.100000><0.673519,0.035000,0.100000> rotate<0,-45.003045,0> translate<58.737600,-1.535000,28.257500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<55.721300,0.000000,72.072500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.213800,0.000000,72.072500>}
box{<0,0,-0.100100><3.492500,0.035000,0.100100> rotate<0,0.000000,0> translate<55.721300,0.000000,72.072500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.896300,-1.535000,6.985000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.213900,-1.535000,6.984900>}
box{<0,0,-0.100000><0.317600,0.035000,0.100000> rotate<0,0.018039,0> translate<58.896300,-1.535000,6.985000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.737500,0.000000,73.025000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.372400,0.000000,73.025000>}
box{<0,0,-0.100100><0.634900,0.035000,0.100100> rotate<0,0.000000,0> translate<58.737500,0.000000,73.025000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.626300,-1.535000,43.497500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.372500,-1.535000,41.751300>}
box{<0,0,-0.100100><2.469500,0.035000,0.100100> rotate<0,44.997030,0> translate<57.626300,-1.535000,43.497500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.896300,-1.535000,50.323800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.372500,-1.535000,50.800000>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,-44.997030,0> translate<58.896300,-1.535000,50.323800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,-1.535000,27.305000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.372600,-1.535000,27.305000>}
box{<0,0,-0.100000><3.492600,0.035000,0.100000> rotate<0,0.000000,0> translate<55.880000,-1.535000,27.305000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<39.370000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.531200,-1.535000,7.620000>}
box{<0,0,-0.100100><20.161200,0.035000,0.100100> rotate<0,0.000000,0> translate<39.370000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.213800,-1.535000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.531300,-1.535000,26.193800>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<59.213800,-1.535000,25.876300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.372600,-1.535000,27.305000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.531300,-1.535000,27.146300>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<59.372600,-1.535000,27.305000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.038900,-1.535000,27.781300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.531300,-1.535000,27.781300>}
box{<0,0,-0.100000><3.492400,0.035000,0.100000> rotate<0,0.000000,0> translate<56.038900,-1.535000,27.781300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.626300,-1.535000,44.132500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.531300,-1.535000,42.227500>}
box{<0,0,-0.100100><2.694077,0.035000,0.100100> rotate<0,44.997030,0> translate<57.626300,-1.535000,44.132500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.896300,0.000000,71.120000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.531300,0.000000,70.485000>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<58.896300,0.000000,71.120000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,70.961300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.531300,-1.535000,70.485000>}
box{<0,0,-0.100100><0.673590,0.035000,0.100100> rotate<0,44.997030,0> translate<59.055000,-1.535000,70.961300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<59.055100,-1.535000,75.247500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<59.531300,-1.535000,74.771300>}
box{<0,0,-0.203200><0.673448,0.035000,0.203200> rotate<0,44.997030,0> translate<59.055100,-1.535000,75.247500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,5.715000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,1.905000>}
box{<0,0,-0.100100><3.810000,0.035000,0.100100> rotate<0,-90.000000,0> translate<59.690000,-1.535000,1.905000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,6.350000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,5.715000>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<59.055000,-1.535000,6.350000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.896300,0.000000,8.413800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,0.000000,9.207500>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,-44.997030,0> translate<58.896300,0.000000,8.413800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,-1.535000,11.588800>}
box{<0,0,-0.100000><0.019000,0.035000,0.100000> rotate<0,-90.000000,0> translate<59.690000,-1.535000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,-1.535000,13.493800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,-1.535000,11.607800>}
box{<0,0,-0.100000><1.886000,0.035000,0.100000> rotate<0,-90.000000,0> translate<59.690000,-1.535000,11.607800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.943800,0.000000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,0.000000,13.493800>}
box{<0,0,-0.100000><2.469500,0.035000,0.100000> rotate<0,44.997030,0> translate<57.943800,0.000000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.086200,0.000000,16.192500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,0.000000,16.192500>}
box{<0,0,-0.100000><4.603800,0.035000,0.100000> rotate<0,0.000000,0> translate<55.086200,0.000000,16.192500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.261200,0.000000,21.272600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,0.000000,19.843800>}
box{<0,0,-0.100000><2.020628,0.035000,0.100000> rotate<0,44.997030,0> translate<58.261200,0.000000,21.272600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.261300,0.000000,21.272500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,0.000000,19.843800>}
box{<0,0,-0.100000><2.020487,0.035000,0.100000> rotate<0,44.997030,0> translate<58.261300,0.000000,21.272500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,-1.535000,19.843800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,-1.535000,21.539200>}
box{<0,0,-0.100000><1.695400,0.035000,0.100000> rotate<0,90.000000,0> translate<59.690000,-1.535000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,19.843800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,21.590000>}
box{<0,0,-0.100100><1.746200,0.035000,0.100100> rotate<0,90.000000,0> translate<59.690000,-1.535000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,-1.535000,21.539200>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,-1.535000,21.590000>}
box{<0,0,-0.100000><0.050800,0.035000,0.100000> rotate<0,90.000000,0> translate<59.690000,-1.535000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.261300,0.000000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,0.000000,27.305000>}
box{<0,0,-0.100000><2.020487,0.035000,0.100000> rotate<0,-44.997030,0> translate<58.261300,0.000000,25.876300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.261400,0.000000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,0.000000,27.305000>}
box{<0,0,-0.100000><2.020416,0.035000,0.100000> rotate<0,-44.999035,0> translate<58.261400,0.000000,25.876300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,0.000000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,0.000000,27.305000>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,-90.000000,0> translate<59.690000,0.000000,27.305000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.531300,-1.535000,27.781300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,-1.535000,27.940000>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,-44.997030,0> translate<59.531300,-1.535000,27.781300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,32.067500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,31.270000>}
box{<0,0,-0.100100><0.797500,0.035000,0.100100> rotate<0,-90.000000,0> translate<59.690000,-1.535000,31.270000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.737500,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,32.067500>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,44.997030,0> translate<58.737500,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,0.000000,34.658300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,0.000000,34.023300>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<59.055000,0.000000,34.658300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,0.000000,33.178800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,0.000000,34.023300>}
box{<0,0,-0.100100><0.844500,0.035000,0.100100> rotate<0,90.000000,0> translate<59.690000,0.000000,34.023300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,47.470000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,47.466300>}
box{<0,0,-0.100100><0.003700,0.035000,0.100100> rotate<0,-90.000000,0> translate<59.690000,-1.535000,47.466300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.896300,-1.535000,49.371300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,48.577500>}
box{<0,0,-0.100100><1.122532,0.035000,0.100100> rotate<0,45.000639,0> translate<58.896300,-1.535000,49.371300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,47.470000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,48.577500>}
box{<0,0,-0.100100><1.107500,0.035000,0.100100> rotate<0,90.000000,0> translate<59.690000,-1.535000,48.577500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,0.000000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,0.000000,55.880000>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<58.420000,0.000000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,0.000000,53.498800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,0.000000,55.880000>}
box{<0,0,-0.100000><2.381200,0.035000,0.100000> rotate<0,90.000000,0> translate<59.690000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.752500,0.000000,58.896300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<59.690000,0.000000,58.896300>}
box{<0,0,-0.203200><7.937500,0.035000,0.203200> rotate<0,0.000000,0> translate<51.752500,0.000000,58.896300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.420000,0.000000,64.293800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,0.000000,65.563900>}
box{<0,0,-0.100100><1.796122,0.035000,0.100100> rotate<0,-44.999286,0> translate<58.420000,0.000000,64.293800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,-1.535000,66.516300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,65.563900>}
box{<0,0,-0.100100><1.144679,0.035000,0.100100> rotate<0,56.303440,0> translate<59.055000,-1.535000,66.516300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.531200,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690100,-1.535000,7.778800>}
box{<0,0,-0.100100><0.224648,0.035000,0.100100> rotate<0,-44.978997,0> translate<59.531200,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,0.000000,16.192500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,0.000000,16.033800>}
box{<0,0,-0.100000><0.224506,0.035000,0.100000> rotate<0,44.978985,0> translate<59.690000,0.000000,16.192500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.150000,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,-1.535000,25.082500>}
box{<0,0,-0.100000><2.698800,0.035000,0.100000> rotate<0,0.000000,0> translate<57.150000,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.213800,-1.535000,28.733800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,-1.535000,28.733800>}
box{<0,0,-0.100000><0.635000,0.035000,0.100000> rotate<0,0.000000,0> translate<59.213800,-1.535000,28.733800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,0.000000,33.178800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.848800,0.000000,33.020000>}
box{<0,0,-0.100100><0.224577,0.035000,0.100100> rotate<0,44.997030,0> translate<59.690000,0.000000,33.178800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,-1.535000,36.671300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,-1.535000,40.640000>}
box{<0,0,-0.100000><3.968700,0.035000,0.100000> rotate<0,90.000000,0> translate<59.848800,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.308800,-1.535000,45.561300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,-1.535000,43.021300>}
box{<0,0,-0.100000><3.592102,0.035000,0.100000> rotate<0,44.997030,0> translate<57.308800,-1.535000,45.561300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,0.000000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,0.000000,43.021300>}
box{<0,0,-0.100000><2.381300,0.035000,0.100000> rotate<0,90.000000,0> translate<59.848800,0.000000,43.021300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.848800,-1.535000,49.530100>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.848800,-1.535000,49.530000>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,-90.000000,0> translate<59.848800,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,0.000000,49.688800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,0.000000,49.530100>}
box{<0,0,-0.100000><0.158700,0.035000,0.100000> rotate<0,-90.000000,0> translate<59.848800,0.000000,49.530100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<56.515000,0.000000,53.022500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,0.000000,49.688800>}
box{<0,0,-0.100000><4.714634,0.035000,0.100000> rotate<0,44.996171,0> translate<56.515000,0.000000,53.022500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.007500,-1.535000,27.622500>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<59.690000,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<58.737500,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.007500,-1.535000,29.210000>}
box{<0,0,-0.100100><1.270000,0.035000,0.100100> rotate<0,0.000000,0> translate<58.737500,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,0.000000,36.671300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.007600,0.000000,36.512500>}
box{<0,0,-0.100000><0.224577,0.035000,0.100000> rotate<0,44.997030,0> translate<59.848800,0.000000,36.671300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,-1.535000,25.082500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.166200,-1.535000,25.400000>}
box{<0,0,-0.100000><0.448942,0.035000,0.100000> rotate<0,-45.006054,0> translate<59.848800,-1.535000,25.082500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,0.000000,11.588800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.166300,0.000000,11.588800>}
box{<0,0,-0.203200><3.651300,0.035000,0.203200> rotate<0,0.000000,0> translate<56.515000,0.000000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515100,0.000000,11.588800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.166300,0.000000,11.588800>}
box{<0,0,-0.203200><3.651200,0.035000,0.203200> rotate<0,0.000000,0> translate<56.515100,0.000000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.848800,0.000000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.166300,0.000000,33.020000>}
box{<0,0,-0.100100><0.317500,0.035000,0.100100> rotate<0,0.000000,0> translate<59.848800,0.000000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.166300,0.000000,28.575000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.166300,0.000000,33.020000>}
box{<0,0,-0.100100><4.445000,0.035000,0.100100> rotate<0,90.000000,0> translate<60.166300,0.000000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,-1.535000,1.905000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.325000,-1.535000,1.270000>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,44.997030,0> translate<59.690000,-1.535000,1.905000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.325000,0.000000,33.972600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.325000,0.000000,34.658300>}
box{<0,0,-0.100100><0.685700,0.035000,0.100100> rotate<0,90.000000,0> translate<60.325000,0.000000,34.658300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.055000,0.000000,46.672600>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.325000,0.000000,45.402600>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<59.055000,0.000000,46.672600> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.325000,0.000000,44.716700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.325000,0.000000,45.402600>}
box{<0,0,-0.100000><0.685900,0.035000,0.100000> rotate<0,90.000000,0> translate<60.325000,0.000000,45.402600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.325000,-1.535000,60.801300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.325000,-1.535000,62.280800>}
box{<0,0,-0.203200><1.479500,0.035000,0.203200> rotate<0,90.000000,0> translate<60.325000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<58.102500,-1.535000,64.770000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.325000,-1.535000,64.770000>}
box{<0,0,-0.203200><2.222500,0.035000,0.203200> rotate<0,0.000000,0> translate<58.102500,-1.535000,64.770000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.325000,0.000000,66.833800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.325000,0.000000,68.103800>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,90.000000,0> translate<60.325000,0.000000,68.103800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.325000,-1.535000,73.977500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.325000,-1.535000,72.339200>}
box{<0,0,-0.100100><1.638300,0.035000,0.100100> rotate<0,-90.000000,0> translate<60.325000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.372400,0.000000,73.025000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.325000,0.000000,73.977500>}
box{<0,0,-0.100100><1.347109,0.035000,0.100100> rotate<0,-44.994023,0> translate<59.372400,0.000000,73.025000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.166200,-1.535000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.483800,-1.535000,25.717500>}
box{<0,0,-0.100100><0.449084,0.035000,0.100100> rotate<0,-44.988009,0> translate<60.166200,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.166300,-1.535000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.483800,-1.535000,25.717500>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<60.166300,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,-1.535000,28.733800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.483800,-1.535000,28.098800>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<59.848800,-1.535000,28.733800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<56.515000,0.000000,60.483800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.483800,0.000000,64.452600>}
box{<0,0,-0.203200><5.612731,0.035000,0.203200> rotate<0,-44.997030,0> translate<56.515000,0.000000,60.483800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.325000,0.000000,66.833800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.483800,0.000000,66.675000>}
box{<0,0,-0.203200><0.224577,0.035000,0.203200> rotate<0,44.997030,0> translate<60.325000,0.000000,66.833800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.483800,0.000000,64.452600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.483800,0.000000,66.675000>}
box{<0,0,-0.203200><2.222400,0.035000,0.203200> rotate<0,90.000000,0> translate<60.483800,0.000000,66.675000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.213800,0.000000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.642500,0.000000,27.305000>}
box{<0,0,-0.100100><2.020487,0.035000,0.100100> rotate<0,-44.997030,0> translate<59.213800,0.000000,25.876300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.166300,0.000000,28.575000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.642500,0.000000,28.098800>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,44.997030,0> translate<60.166300,0.000000,28.575000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.642500,0.000000,27.305000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.642500,0.000000,28.098800>}
box{<0,0,-0.100100><0.793800,0.035000,0.100100> rotate<0,90.000000,0> translate<60.642500,0.000000,28.098800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.007500,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.642500,-1.535000,28.575100>}
box{<0,0,-0.100100><0.897955,0.035000,0.100100> rotate<0,44.992519,0> translate<60.007500,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.880000,0.000000,54.610000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.642500,0.000000,49.847500>}
box{<0,0,-0.100000><6.735192,0.035000,0.100000> rotate<0,44.997030,0> translate<55.880000,0.000000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.642500,0.000000,46.513800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.642500,0.000000,49.847500>}
box{<0,0,-0.100000><3.333700,0.035000,0.100000> rotate<0,90.000000,0> translate<60.642500,0.000000,49.847500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.325000,-1.535000,60.801300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.642500,-1.535000,60.483800>}
box{<0,0,-0.203200><0.449013,0.035000,0.203200> rotate<0,44.997030,0> translate<60.325000,-1.535000,60.801300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690100,0.000000,7.778800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.642600,0.000000,8.731300>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,-44.997030,0> translate<59.690100,0.000000,7.778800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.213900,-1.535000,6.984900>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.801200,-1.535000,6.984900>}
box{<0,0,-0.100000><1.587300,0.035000,0.100000> rotate<0,0.000000,0> translate<59.213900,-1.535000,6.984900> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.325000,0.000000,68.103800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.801200,0.000000,68.580000>}
box{<0,0,-0.203200><0.673448,0.035000,0.203200> rotate<0,-44.997030,0> translate<60.325000,0.000000,68.103800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.451300,0.000000,18.732500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.801300,0.000000,18.732500>}
box{<0,0,-0.100000><6.350000,0.035000,0.100000> rotate<0,0.000000,0> translate<54.451300,0.000000,18.732500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.245100,-1.535000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.801300,-1.535000,24.606300>}
box{<0,0,-0.100000><5.556200,0.035000,0.100000> rotate<0,0.000000,0> translate<55.245100,-1.535000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.801200,-1.535000,6.984900>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,-1.535000,7.143800>}
box{<0,0,-0.100000><0.224648,0.035000,0.100000> rotate<0,-45.015064,0> translate<60.801200,-1.535000,6.984900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,-1.535000,7.143800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,-1.535000,11.607800>}
box{<0,0,-0.100000><4.464000,0.035000,0.100000> rotate<0,90.000000,0> translate<60.960000,-1.535000,11.607800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,-1.535000,16.033700>}
box{<0,0,-0.100000><4.425900,0.035000,0.100000> rotate<0,90.000000,0> translate<60.960000,-1.535000,16.033700> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.848800,-1.535000,16.033800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,-1.535000,17.145000>}
box{<0,0,-0.100000><1.571474,0.035000,0.100000> rotate<0,-44.997030,0> translate<59.848800,-1.535000,16.033800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,-1.535000,17.145000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,-1.535000,21.539200>}
box{<0,0,-0.100000><4.394200,0.035000,0.100000> rotate<0,90.000000,0> translate<60.960000,-1.535000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.960000,-1.535000,32.226300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.960000,-1.535000,31.270000>}
box{<0,0,-0.100100><0.956300,0.035000,0.100100> rotate<0,-90.000000,0> translate<60.960000,-1.535000,31.270000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.166300,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.960000,-1.535000,32.226300>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,44.997030,0> translate<60.166300,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.960000,-1.535000,48.418800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.960000,-1.535000,47.470000>}
box{<0,0,-0.100100><0.948800,0.035000,0.100100> rotate<0,-90.000000,0> translate<60.960000,-1.535000,47.470000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.848800,-1.535000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.960000,-1.535000,48.418800>}
box{<0,0,-0.100100><1.571474,0.035000,0.100100> rotate<0,44.997030,0> translate<59.848800,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,0.000000,53.340100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,0.000000,54.610000>}
box{<0,0,-0.100000><1.269900,0.035000,0.100000> rotate<0,90.000000,0> translate<60.960000,0.000000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.610000,0.000000,18.256300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960100,0.000000,18.256300>}
box{<0,0,-0.100000><6.350100,0.035000,0.100000> rotate<0,0.000000,0> translate<54.610000,0.000000,18.256300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.960000,0.000000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.960100,0.000000,57.150000>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,0.000000,0> translate<60.960000,0.000000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.166300,0.000000,11.588800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.118800,0.000000,12.541300>}
box{<0,0,-0.203200><1.347038,0.035000,0.203200> rotate<0,-44.997030,0> translate<60.166300,0.000000,11.588800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.118800,0.000000,12.541300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.118800,0.000000,14.390000>}
box{<0,0,-0.203200><1.848700,0.035000,0.203200> rotate<0,90.000000,0> translate<61.118800,0.000000,14.390000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.768700,0.000000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.118800,0.000000,17.780000>}
box{<0,0,-0.100000><6.350100,0.035000,0.100000> rotate<0,0.000000,0> translate<54.768700,0.000000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.801300,-1.535000,24.606300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.118800,-1.535000,24.923800>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<60.801300,-1.535000,24.606300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.325000,0.000000,33.972600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.118800,0.000000,33.178800>}
box{<0,0,-0.100100><1.122603,0.035000,0.100100> rotate<0,44.997030,0> translate<60.325000,0.000000,33.972600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.118800,0.000000,33.178700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.118800,0.000000,33.178800>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<61.118800,0.000000,33.178800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<58.261300,0.000000,60.483800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.277500,0.000000,63.500000>}
box{<0,0,-0.203200><4.265551,0.035000,0.203200> rotate<0,-44.997030,0> translate<58.261300,0.000000,60.483800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.277500,0.000000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.277500,0.000000,67.310000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<61.277500,0.000000,67.310000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<54.927600,0.000000,17.303800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.277600,0.000000,17.303800>}
box{<0,0,-0.100000><6.350000,0.035000,0.100000> rotate<0,0.000000,0> translate<54.927600,0.000000,17.303800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.690000,0.000000,19.843800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.277600,0.000000,19.843800>}
box{<0,0,-0.100100><1.587600,0.035000,0.100100> rotate<0,0.000000,0> translate<59.690000,0.000000,19.843800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,-1.535000,16.033700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.436300,-1.535000,16.510000>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,-44.997030,0> translate<60.960000,-1.535000,16.033700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.277600,0.000000,19.843800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.436300,0.000000,20.002500>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,-44.997030,0> translate<61.277600,0.000000,19.843800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.118800,-1.535000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.436300,-1.535000,25.241300>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<61.118800,-1.535000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.436300,-1.535000,37.623800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.436300,-1.535000,40.481300>}
box{<0,0,-0.203200><2.857500,0.035000,0.203200> rotate<0,90.000000,0> translate<61.436300,-1.535000,40.481300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.436300,0.000000,40.481300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.436300,0.000000,43.021300>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<61.436300,0.000000,43.021300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.308800,0.000000,54.133800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.436300,0.000000,50.006300>}
box{<0,0,-0.100000><5.837166,0.035000,0.100000> rotate<0,44.997030,0> translate<57.308800,0.000000,54.133800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.436300,0.000000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.436300,0.000000,50.006300>}
box{<0,0,-0.100000><0.476300,0.035000,0.100000> rotate<0,90.000000,0> translate<61.436300,0.000000,50.006300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.641300,0.000000,58.261300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.436300,0.000000,58.261300>}
box{<0,0,-0.100100><10.795000,0.035000,0.100100> rotate<0,0.000000,0> translate<50.641300,0.000000,58.261300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.213800,0.000000,72.072500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.436300,0.000000,69.850000>}
box{<0,0,-0.100100><3.143090,0.035000,0.100100> rotate<0,44.997030,0> translate<59.213800,0.000000,72.072500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.166300,0.000000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.595000,0.000000,26.828800>}
box{<0,0,-0.100100><2.020558,0.035000,0.100100> rotate<0,-44.999035,0> translate<60.166300,0.000000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.595000,0.000000,26.828800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.595000,0.000000,29.686300>}
box{<0,0,-0.100100><2.857500,0.035000,0.100100> rotate<0,90.000000,0> translate<61.595000,0.000000,29.686300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.118800,0.000000,33.178700>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.595000,0.000000,32.702500>}
box{<0,0,-0.100100><0.673448,0.035000,0.100100> rotate<0,44.997030,0> translate<61.118800,0.000000,33.178700> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.595000,0.000000,29.686300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.595000,0.000000,32.702500>}
box{<0,0,-0.100100><3.016200,0.035000,0.100100> rotate<0,90.000000,0> translate<61.595000,0.000000,32.702500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.595000,0.000000,33.813800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.595000,0.000000,34.658300>}
box{<0,0,-0.100100><0.844500,0.035000,0.100100> rotate<0,90.000000,0> translate<61.595000,0.000000,34.658300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.642500,0.000000,46.513800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.595000,0.000000,45.561300>}
box{<0,0,-0.100000><1.347038,0.035000,0.100000> rotate<0,44.997030,0> translate<60.642500,0.000000,46.513800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.595000,0.000000,44.716700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.595000,0.000000,45.561300>}
box{<0,0,-0.100000><0.844600,0.035000,0.100000> rotate<0,90.000000,0> translate<61.595000,0.000000,45.561300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.595000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.595000,-1.535000,62.280800>}
box{<0,0,-0.203200><1.219200,0.035000,0.203200> rotate<0,-90.000000,0> translate<61.595000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.325000,-1.535000,64.770000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.595000,-1.535000,63.500000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<60.325000,-1.535000,64.770000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.801200,-1.535000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.595000,-1.535000,69.373800>}
box{<0,0,-0.203200><1.122603,0.035000,0.203200> rotate<0,-44.997030,0> translate<60.801200,-1.535000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.595000,-1.535000,69.373800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.595000,-1.535000,70.326300>}
box{<0,0,-0.203200><0.952500,0.035000,0.203200> rotate<0,90.000000,0> translate<61.595000,-1.535000,70.326300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.595000,-1.535000,70.326300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.595000,-1.535000,72.339200>}
box{<0,0,-0.203200><2.012900,0.035000,0.203200> rotate<0,90.000000,0> translate<61.595000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.055000,0.000000,75.565000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.595000,0.000000,78.105000>}
box{<0,0,-0.100100><3.592102,0.035000,0.100100> rotate<0,-44.997030,0> translate<59.055000,0.000000,75.565000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.801300,0.000000,18.732500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.595100,0.000000,19.526300>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,-44.997030,0> translate<60.801300,0.000000,18.732500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<55.086200,0.000000,16.827500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.753700,0.000000,16.827500>}
box{<0,0,-0.100000><6.667500,0.035000,0.100000> rotate<0,0.000000,0> translate<55.086200,0.000000,16.827500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960100,0.000000,18.256300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.753800,0.000000,19.050000>}
box{<0,0,-0.100000><1.122461,0.035000,0.100000> rotate<0,-44.997030,0> translate<60.960100,0.000000,18.256300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.737500,-1.535000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.753800,-1.535000,24.130000>}
box{<0,0,-0.100000><3.016300,0.035000,0.100000> rotate<0,0.000000,0> translate<58.737500,-1.535000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.277500,0.000000,67.310000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.912500,0.000000,67.310000>}
box{<0,0,-0.203200><0.635000,0.035000,0.203200> rotate<0,0.000000,0> translate<61.277500,0.000000,67.310000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.118800,0.000000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.912600,0.000000,18.573800>}
box{<0,0,-0.100000><1.122603,0.035000,0.100000> rotate<0,-44.997030,0> translate<61.118800,0.000000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<59.531300,-1.535000,74.771300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.912600,-1.535000,74.771300>}
box{<0,0,-0.203200><2.381300,0.035000,0.203200> rotate<0,0.000000,0> translate<59.531300,-1.535000,74.771300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<59.055000,0.000000,6.508800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.071200,0.000000,6.508800>}
box{<0,0,-0.203200><3.016200,0.035000,0.203200> rotate<0,0.000000,0> translate<59.055000,0.000000,6.508800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.277600,0.000000,17.303800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.071300,0.000000,18.097500>}
box{<0,0,-0.100000><1.122461,0.035000,0.100000> rotate<0,-44.997030,0> translate<61.277600,0.000000,17.303800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.753800,-1.535000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.071300,-1.535000,24.447500>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<61.753800,-1.535000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,-1.535000,2.540000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,-1.535000,3.810000>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,-44.997030,0> translate<60.960000,-1.535000,2.540000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.960000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,0.000000,3.810000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<60.960000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,-1.535000,5.873800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,-1.535000,3.810000>}
box{<0,0,-0.100000><2.063800,0.035000,0.100000> rotate<0,-90.000000,0> translate<62.230000,-1.535000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,-1.535000,7.143800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,-1.535000,5.873800>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<60.960000,-1.535000,7.143800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,-1.535000,9.525000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,-1.535000,11.607800>}
box{<0,0,-0.100000><2.082800,0.035000,0.100000> rotate<0,90.000000,0> translate<62.230000,-1.535000,11.607800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,-1.535000,15.557500>}
box{<0,0,-0.100000><3.949700,0.035000,0.100000> rotate<0,90.000000,0> translate<62.230000,-1.535000,15.557500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.753700,0.000000,16.827500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,0.000000,17.303800>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,-44.997030,0> translate<61.753700,0.000000,16.827500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,-1.535000,17.303800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,-1.535000,21.539200>}
box{<0,0,-0.100000><4.235400,0.035000,0.100000> rotate<0,90.000000,0> translate<62.230000,-1.535000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.595000,-1.535000,29.686300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.230000,-1.535000,30.321300>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<61.595000,-1.535000,29.686300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.230000,-1.535000,30.321300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.230000,-1.535000,31.270000>}
box{<0,0,-0.100100><0.948700,0.035000,0.100100> rotate<0,90.000000,0> translate<62.230000,-1.535000,31.270000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.230000,-1.535000,31.270000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.230000,-1.535000,31.273800>}
box{<0,0,-0.100100><0.003800,0.035000,0.100100> rotate<0,90.000000,0> translate<62.230000,-1.535000,31.273800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.436300,-1.535000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.230000,-1.535000,48.736300>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,44.997030,0> translate<61.436300,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.230000,-1.535000,47.470000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.230000,-1.535000,48.736300>}
box{<0,0,-0.100100><1.266300,0.035000,0.100100> rotate<0,90.000000,0> translate<62.230000,-1.535000,48.736300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.420000,0.000000,53.657500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,0.000000,49.847500>}
box{<0,0,-0.100000><5.388154,0.035000,0.100000> rotate<0,44.997030,0> translate<58.420000,0.000000,53.657500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,0.000000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,0.000000,49.847500>}
box{<0,0,-0.100000><1.111200,0.035000,0.100000> rotate<0,90.000000,0> translate<62.230000,0.000000,49.847500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.540000,-1.535000,76.200000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.357000,-1.535000,76.200000>}
box{<0,0,-0.203200><1.817000,0.035000,0.203200> rotate<0,0.000000,0> translate<60.540000,-1.535000,76.200000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.357000,0.000000,71.310600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.357000,0.000000,76.200000>}
box{<0,0,-0.203200><4.889400,0.035000,0.203200> rotate<0,90.000000,0> translate<62.357000,0.000000,76.200000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.071300,-1.535000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.388800,-1.535000,24.765000>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<62.071300,-1.535000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.388800,0.000000,53.181300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.388800,0.000000,55.721200>}
box{<0,0,-0.100000><2.539900,0.035000,0.100000> rotate<0,90.000000,0> translate<62.388800,0.000000,55.721200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.960100,0.000000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.388800,0.000000,55.721300>}
box{<0,0,-0.100100><2.020487,0.035000,0.100100> rotate<0,44.997030,0> translate<60.960100,0.000000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.388800,0.000000,55.721200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.388800,0.000000,55.721300>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<62.388800,0.000000,55.721300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.357000,-1.535000,76.200000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.388800,-1.535000,76.200000>}
box{<0,0,-0.203200><0.031800,0.035000,0.203200> rotate<0,0.000000,0> translate<62.357000,-1.535000,76.200000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.007600,0.000000,36.512500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.547500,0.000000,36.512500>}
box{<0,0,-0.100000><2.539900,0.035000,0.100000> rotate<0,0.000000,0> translate<60.007600,0.000000,36.512500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.357000,0.000000,71.310500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.547500,0.000000,71.120000>}
box{<0,0,-0.203200><0.269408,0.035000,0.203200> rotate<0,44.997030,0> translate<62.357000,0.000000,71.310500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.357000,0.000000,71.310600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.547500,0.000000,71.120100>}
box{<0,0,-0.203200><0.269408,0.035000,0.203200> rotate<0,44.997030,0> translate<62.357000,0.000000,71.310600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.547500,0.000000,71.120000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.547500,0.000000,71.120100>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,90.000000,0> translate<62.547500,0.000000,71.120100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.801200,0.000000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.550000,0.000000,68.580000>}
box{<0,0,-0.203200><1.748800,0.035000,0.203200> rotate<0,0.000000,0> translate<60.801200,0.000000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.547500,0.000000,71.120000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.550000,0.000000,71.120000>}
box{<0,0,-0.203200><0.002500,0.035000,0.203200> rotate<0,0.000000,0> translate<62.547500,0.000000,71.120000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.650000,0.000000,66.572500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.650000,0.000000,66.040000>}
box{<0,0,-0.203200><0.532500,0.035000,0.203200> rotate<0,-90.000000,0> translate<62.650000,0.000000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.912500,0.000000,67.310000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.650000,0.000000,66.572500>}
box{<0,0,-0.203200><1.042983,0.035000,0.203200> rotate<0,44.997030,0> translate<61.912500,0.000000,67.310000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,-1.535000,15.557500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.706300,-1.535000,16.033800>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,-44.997030,0> translate<62.230000,-1.535000,15.557500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.896300,-1.535000,23.653800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.706300,-1.535000,23.653800>}
box{<0,0,-0.100000><3.810000,0.035000,0.100000> rotate<0,0.000000,0> translate<58.896300,-1.535000,23.653800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<50.482600,-1.535000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.706300,-1.535000,58.420000>}
box{<0,0,-0.100100><12.223700,0.035000,0.100100> rotate<0,0.000000,0> translate<50.482600,-1.535000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.118800,0.000000,24.923800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.865000,0.000000,26.670000>}
box{<0,0,-0.100100><2.469500,0.035000,0.100100> rotate<0,-44.997030,0> translate<61.118800,0.000000,24.923800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.865000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.865000,0.000000,29.686300>}
box{<0,0,-0.100100><3.016300,0.035000,0.100100> rotate<0,90.000000,0> translate<62.865000,0.000000,29.686300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.595000,0.000000,33.813800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.865000,0.000000,32.543800>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<61.595000,0.000000,33.813800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.865000,0.000000,29.686300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.865000,0.000000,32.543800>}
box{<0,0,-0.100100><2.857500,0.035000,0.100100> rotate<0,90.000000,0> translate<62.865000,0.000000,32.543800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.865000,0.000000,33.813800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.865000,0.000000,34.658300>}
box{<0,0,-0.100100><0.844500,0.035000,0.100100> rotate<0,90.000000,0> translate<62.865000,0.000000,34.658300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.547500,0.000000,36.512500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.865000,0.000000,36.195000>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,44.997030,0> translate<62.547500,0.000000,36.512500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.865000,0.000000,34.658300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.865000,0.000000,36.195000>}
box{<0,0,-0.100000><1.536700,0.035000,0.100000> rotate<0,90.000000,0> translate<62.865000,0.000000,36.195000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.230000,0.000000,48.736300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.865000,0.000000,48.101300>}
box{<0,0,-0.100000><0.898026,0.035000,0.100000> rotate<0,44.997030,0> translate<62.230000,0.000000,48.736300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.865000,0.000000,44.716700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.865000,0.000000,48.101300>}
box{<0,0,-0.100000><3.384600,0.035000,0.100000> rotate<0,90.000000,0> translate<62.865000,0.000000,48.101300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<59.690000,0.000000,58.896300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.865000,0.000000,62.071300>}
box{<0,0,-0.203200><4.490128,0.035000,0.203200> rotate<0,-44.997030,0> translate<59.690000,0.000000,58.896300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.865000,-1.535000,64.134900>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.865000,-1.535000,62.280800>}
box{<0,0,-0.203200><1.854100,0.035000,0.203200> rotate<0,-90.000000,0> translate<62.865000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.865000,0.000000,62.071300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.865000,0.000000,64.135000>}
box{<0,0,-0.203200><2.063700,0.035000,0.203200> rotate<0,90.000000,0> translate<62.865000,0.000000,64.135000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.865000,-1.535000,72.390000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.865000,-1.535000,72.339200>}
box{<0,0,-0.203200><0.050800,0.035000,0.203200> rotate<0,-90.000000,0> translate<62.865000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.865000,-1.535000,71.278800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.865000,-1.535000,72.390000>}
box{<0,0,-0.100100><1.111200,0.035000,0.100100> rotate<0,90.000000,0> translate<62.865000,-1.535000,72.390000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.912600,-1.535000,74.771300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.865000,-1.535000,73.660100>}
box{<0,0,-0.203200><1.463500,0.035000,0.203200> rotate<0,49.397144,0> translate<61.912600,-1.535000,74.771300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.865000,-1.535000,72.390000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.865000,-1.535000,73.660100>}
box{<0,0,-0.203200><1.270100,0.035000,0.203200> rotate<0,90.000000,0> translate<62.865000,-1.535000,73.660100> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.071300,0.000000,18.097500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.023800,0.000000,18.097500>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,0.000000,0> translate<62.071300,0.000000,18.097500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.706300,-1.535000,23.653800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.023800,-1.535000,23.971300>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<62.706300,-1.535000,23.653800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<58.261300,-1.535000,34.448800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.023800,-1.535000,34.448800>}
box{<0,0,-0.203200><4.762500,0.035000,0.203200> rotate<0,0.000000,0> translate<58.261300,-1.535000,34.448800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.531300,-1.535000,42.227500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.023800,-1.535000,42.227500>}
box{<0,0,-0.100100><3.492500,0.035000,0.100100> rotate<0,0.000000,0> translate<59.531300,-1.535000,42.227500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.706300,-1.535000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.023800,-1.535000,58.737500>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<62.706300,-1.535000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.372500,-1.535000,41.751300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.182500,-1.535000,41.751300>}
box{<0,0,-0.100100><3.810000,0.035000,0.100100> rotate<0,0.000000,0> translate<59.372500,-1.535000,41.751300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.865000,-1.535000,71.278800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.182500,-1.535000,70.961300>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,44.997030,0> translate<62.865000,-1.535000,71.278800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.706300,-1.535000,23.653800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.341300,-1.535000,24.288900>}
box{<0,0,-0.100100><0.898096,0.035000,0.100100> rotate<0,-45.001541,0> translate<62.706300,-1.535000,23.653800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.071200,0.000000,6.508800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.500000,0.000000,5.080000>}
box{<0,0,-0.203200><2.020628,0.035000,0.203200> rotate<0,44.997030,0> translate<62.071200,0.000000,6.508800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,-1.535000,11.430000>}
box{<0,0,-0.100000><0.177800,0.035000,0.100000> rotate<0,-90.000000,0> translate<63.500000,-1.535000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,-1.535000,15.240000>}
box{<0,0,-0.100000><3.632200,0.035000,0.100000> rotate<0,90.000000,0> translate<63.500000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,0.000000,17.621300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,0.000000,17.303800>}
box{<0,0,-0.100000><0.317500,0.035000,0.100000> rotate<0,-90.000000,0> translate<63.500000,0.000000,17.303800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.023800,0.000000,18.097500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,0.000000,17.621300>}
box{<0,0,-0.100000><0.673448,0.035000,0.100000> rotate<0,44.997030,0> translate<63.023800,0.000000,18.097500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.912600,0.000000,18.573800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,0.000000,18.573800>}
box{<0,0,-0.100000><1.587400,0.035000,0.100000> rotate<0,0.000000,0> translate<61.912600,0.000000,18.573800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,-1.535000,17.303800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,-1.535000,21.539200>}
box{<0,0,-0.100000><4.235400,0.035000,0.100000> rotate<0,90.000000,0> translate<63.500000,-1.535000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.865000,-1.535000,29.686300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.500000,-1.535000,30.321300>}
box{<0,0,-0.100100><0.898026,0.035000,0.100100> rotate<0,-44.997030,0> translate<62.865000,-1.535000,29.686300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.500000,-1.535000,30.321300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.500000,-1.535000,31.270000>}
box{<0,0,-0.100100><0.948700,0.035000,0.100100> rotate<0,90.000000,0> translate<63.500000,-1.535000,31.270000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.500000,-1.535000,31.270000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.500000,-1.535000,31.273800>}
box{<0,0,-0.100100><0.003800,0.035000,0.100100> rotate<0,90.000000,0> translate<63.500000,-1.535000,31.273800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.436300,-1.535000,43.021300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.500000,-1.535000,45.085000>}
box{<0,0,-0.203200><2.918513,0.035000,0.203200> rotate<0,-44.997030,0> translate<61.436300,-1.535000,43.021300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.500000,-1.535000,45.085000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.500000,-1.535000,47.470000>}
box{<0,0,-0.203200><2.385000,0.035000,0.203200> rotate<0,90.000000,0> translate<63.500000,-1.535000,47.470000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,0.000000,52.863800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,0.000000,54.610000>}
box{<0,0,-0.100000><1.746200,0.035000,0.100000> rotate<0,90.000000,0> translate<63.500000,0.000000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.500000,0.000000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.500100,0.000000,57.150000>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,0.000000,0> translate<63.500000,0.000000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.865000,-1.535000,64.134900>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.500100,-1.535000,64.770000>}
box{<0,0,-0.203200><0.898167,0.035000,0.203200> rotate<0,-44.997030,0> translate<62.865000,-1.535000,64.134900> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.865000,-1.535000,64.135000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.500100,-1.535000,64.770000>}
box{<0,0,-0.203200><0.898096,0.035000,0.203200> rotate<0,-44.992519,0> translate<62.865000,-1.535000,64.135000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<57.785000,-1.535000,77.470000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.500100,-1.535000,77.470000>}
box{<0,0,-0.100100><5.715100,0.035000,0.100100> rotate<0,0.000000,0> translate<57.785000,-1.535000,77.470000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.785100,0.000000,37.623800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.658800,0.000000,37.623800>}
box{<0,0,-0.203200><5.873700,0.035000,0.203200> rotate<0,0.000000,0> translate<57.785100,0.000000,37.623800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<61.436300,0.000000,37.623800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.658800,0.000000,37.623800>}
box{<0,0,-0.203200><2.222500,0.035000,0.203200> rotate<0,0.000000,0> translate<61.436300,0.000000,37.623800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.690000,0.000000,53.498800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.658800,0.000000,49.530000>}
box{<0,0,-0.100000><5.612731,0.035000,0.100000> rotate<0,44.997030,0> translate<59.690000,0.000000,53.498800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.388800,-1.535000,76.200000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.658800,-1.535000,74.930000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<62.388800,-1.535000,76.200000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.500100,-1.535000,77.470000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.658800,-1.535000,77.311300>}
box{<0,0,-0.100100><0.224436,0.035000,0.100100> rotate<0,44.997030,0> translate<63.500100,-1.535000,77.470000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.817500,-1.535000,15.557500>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<63.500000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.658800,0.000000,6.826300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.976300,0.000000,7.143800>}
box{<0,0,-0.100100><0.449013,0.035000,0.100100> rotate<0,-44.997030,0> translate<63.658800,0.000000,6.826300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.753800,0.000000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.976300,0.000000,19.050000>}
box{<0,0,-0.100000><2.222500,0.035000,0.100000> rotate<0,0.000000,0> translate<61.753800,0.000000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<58.896300,-1.535000,23.018800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.135000,-1.535000,23.018800>}
box{<0,0,-0.100000><5.238700,0.035000,0.100000> rotate<0,0.000000,0> translate<58.896300,-1.535000,23.018800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.071300,0.000000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.135000,0.000000,26.511300>}
box{<0,0,-0.100100><2.918583,0.035000,0.100100> rotate<0,-44.998418,0> translate<62.071300,0.000000,24.447500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.865000,0.000000,33.813800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.135000,0.000000,32.543800>}
box{<0,0,-0.100100><1.796051,0.035000,0.100100> rotate<0,44.997030,0> translate<62.865000,0.000000,33.813800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.135000,0.000000,26.511300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.135000,0.000000,32.543800>}
box{<0,0,-0.100100><6.032500,0.035000,0.100100> rotate<0,90.000000,0> translate<64.135000,0.000000,32.543800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.135000,0.000000,33.813800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.135000,0.000000,34.658300>}
box{<0,0,-0.100100><0.844500,0.035000,0.100100> rotate<0,90.000000,0> translate<64.135000,0.000000,34.658300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.135000,0.000000,44.716700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.135000,0.000000,48.577500>}
box{<0,0,-0.100000><3.860800,0.035000,0.100000> rotate<0,90.000000,0> translate<64.135000,0.000000,48.577500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.165000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.135000,-1.535000,55.880000>}
box{<0,0,-0.203200><13.970000,0.035000,0.203200> rotate<0,0.000000,0> translate<50.165000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.135000,-1.535000,62.280800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.135000,-1.535000,63.976300>}
box{<0,0,-0.203200><1.695500,0.035000,0.203200> rotate<0,90.000000,0> translate<64.135000,-1.535000,63.976300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.135000,0.000000,63.976300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.135000,0.000000,65.881200>}
box{<0,0,-0.203200><1.904900,0.035000,0.203200> rotate<0,90.000000,0> translate<64.135000,0.000000,65.881200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.135000,-1.535000,74.453800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.135000,-1.535000,72.339200>}
box{<0,0,-0.203200><2.114600,0.035000,0.203200> rotate<0,-90.000000,0> translate<64.135000,-1.535000,72.339200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.658800,-1.535000,74.930000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.135000,-1.535000,74.453800>}
box{<0,0,-0.203200><0.673448,0.035000,0.203200> rotate<0,44.997030,0> translate<63.658800,-1.535000,74.930000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<61.595100,0.000000,19.526300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.293700,0.000000,19.526300>}
box{<0,0,-0.100000><2.698600,0.035000,0.100000> rotate<0,0.000000,0> translate<61.595100,0.000000,19.526300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<60.325000,-1.535000,1.270000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.293800,-1.535000,1.270000>}
box{<0,0,-0.100100><3.968800,0.035000,0.100100> rotate<0,0.000000,0> translate<60.325000,-1.535000,1.270000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.135000,0.000000,65.881200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.293800,0.000000,66.040000>}
box{<0,0,-0.203200><0.224577,0.035000,0.203200> rotate<0,-44.997030,0> translate<64.135000,0.000000,65.881200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.293800,0.000000,66.040000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.350000,0.000000,66.040000>}
box{<0,0,-0.203200><0.056200,0.035000,0.203200> rotate<0,0.000000,0> translate<64.293800,0.000000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.135000,-1.535000,23.018800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.452500,-1.535000,23.336300>}
box{<0,0,-0.100000><0.449013,0.035000,0.100000> rotate<0,-44.997030,0> translate<64.135000,-1.535000,23.018800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.452500,-1.535000,23.336300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.452500,-1.535000,23.336400>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<64.452500,-1.535000,23.336400> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.452500,-1.535000,23.336400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.452500,-1.535000,23.495000>}
box{<0,0,-0.100100><0.158600,0.035000,0.100100> rotate<0,90.000000,0> translate<64.452500,-1.535000,23.495000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.960000,0.000000,53.340100>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.452500,0.000000,49.847500>}
box{<0,0,-0.100000><4.939212,0.035000,0.100000> rotate<0,44.997850,0> translate<60.960000,0.000000,53.340100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.450000,0.000000,71.120000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.452500,0.000000,71.120000>}
box{<0,0,-0.203200><0.002500,0.035000,0.203200> rotate<0,0.000000,0> translate<64.450000,0.000000,71.120000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.452500,0.000000,71.120000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.452500,0.000000,74.930000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<64.452500,0.000000,74.930000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.135000,0.000000,48.577500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.452600,0.000000,48.895000>}
box{<0,0,-0.100000><0.449084,0.035000,0.100000> rotate<0,-44.988009,0> translate<64.135000,0.000000,48.577500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.452500,0.000000,49.847500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.452600,0.000000,48.895000>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,89.988045,0> translate<64.452500,0.000000,49.847500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.341300,-1.535000,24.288900>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.611200,-1.535000,24.288800>}
box{<0,0,-0.100100><1.269900,0.035000,0.100100> rotate<0,0.004512,0> translate<63.341300,-1.535000,24.288900> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.436300,0.000000,20.002500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.611300,0.000000,20.002500>}
box{<0,0,-0.100100><3.175000,0.035000,0.100100> rotate<0,0.000000,0> translate<61.436300,0.000000,20.002500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.452500,-1.535000,23.336400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.611400,-1.535000,23.177500>}
box{<0,0,-0.100100><0.224719,0.035000,0.100100> rotate<0,44.997030,0> translate<64.452500,-1.535000,23.336400> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.611300,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.611400,-1.535000,23.177500>}
box{<0,0,-0.100000><0.000100,0.035000,0.100000> rotate<0,0.000000,0> translate<64.611300,-1.535000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.135000,0.000000,33.813800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.769900,0.000000,33.178900>}
box{<0,0,-0.100100><0.897884,0.035000,0.100100> rotate<0,44.997030,0> translate<64.135000,0.000000,33.813800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.769900,0.000000,29.686400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.769900,0.000000,33.178900>}
box{<0,0,-0.100100><3.492500,0.035000,0.100100> rotate<0,90.000000,0> translate<64.769900,0.000000,33.178900> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.770000,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.770000,-1.535000,11.430000>}
box{<0,0,-0.100000><0.177800,0.035000,0.100000> rotate<0,-90.000000,0> translate<64.770000,-1.535000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.770000,-1.535000,11.607800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.770000,-1.535000,14.605000>}
box{<0,0,-0.100000><2.997200,0.035000,0.100000> rotate<0,90.000000,0> translate<64.770000,-1.535000,14.605000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.500000,0.000000,18.573800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.770000,0.000000,17.303800>}
box{<0,0,-0.100000><1.796051,0.035000,0.100000> rotate<0,44.997030,0> translate<63.500000,0.000000,18.573800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.770000,-1.535000,17.303800>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.770000,-1.535000,21.539200>}
box{<0,0,-0.100000><4.235400,0.035000,0.100000> rotate<0,90.000000,0> translate<64.770000,-1.535000,21.539200> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.611300,-1.535000,23.177500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.770000,-1.535000,23.018800>}
box{<0,0,-0.100000><0.224436,0.035000,0.100000> rotate<0,44.997030,0> translate<64.611300,-1.535000,23.177500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.023800,0.000000,23.971300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770000,0.000000,25.876300>}
box{<0,0,-0.100100><2.584229,0.035000,0.100100> rotate<0,-47.487236,0> translate<63.023800,0.000000,23.971300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770000,0.000000,25.876300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770000,0.000000,28.416300>}
box{<0,0,-0.100100><2.540000,0.035000,0.100100> rotate<0,90.000000,0> translate<64.770000,0.000000,28.416300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.769900,0.000000,29.686400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770000,0.000000,29.051400>}
box{<0,0,-0.100100><0.635000,0.035000,0.100100> rotate<0,89.985038,0> translate<64.769900,0.000000,29.686400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,32.702500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,31.270000>}
box{<0,0,-0.203200><1.432500,0.035000,0.203200> rotate<0,-90.000000,0> translate<64.770000,-1.535000,31.270000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770000,-1.535000,47.470000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770000,-1.535000,47.466300>}
box{<0,0,-0.100100><0.003700,0.035000,0.100100> rotate<0,-90.000000,0> translate<64.770000,-1.535000,47.466300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.658800,-1.535000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.770000,-1.535000,48.418800>}
box{<0,0,-0.100000><1.571474,0.035000,0.100000> rotate<0,44.997030,0> translate<63.658800,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770000,-1.535000,47.470000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770000,-1.535000,48.418800>}
box{<0,0,-0.100100><0.948800,0.035000,0.100100> rotate<0,90.000000,0> translate<64.770000,-1.535000,48.418800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.135000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,56.515000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,-44.997030,0> translate<64.135000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,56.515000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,57.943800>}
box{<0,0,-0.203200><1.428800,0.035000,0.203200> rotate<0,90.000000,0> translate<64.770000,-1.535000,57.943800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,0.000000,57.943800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,0.000000,60.007500>}
box{<0,0,-0.203200><2.063700,0.035000,0.203200> rotate<0,90.000000,0> translate<64.770000,0.000000,60.007500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.642500,-1.535000,60.483800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,60.483800>}
box{<0,0,-0.203200><4.127500,0.035000,0.203200> rotate<0,0.000000,0> translate<60.642500,-1.535000,60.483800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.436300,0.000000,58.261300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770000,0.000000,61.595000>}
box{<0,0,-0.100100><4.714564,0.035000,0.100100> rotate<0,-44.997030,0> translate<61.436300,0.000000,58.261300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<62.388800,-1.535000,24.765000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770100,-1.535000,24.765000>}
box{<0,0,-0.100100><2.381300,0.035000,0.100100> rotate<0,0.000000,0> translate<62.388800,-1.535000,24.765000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770000,0.000000,28.416300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770100,0.000000,28.892500>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,-89.982029,0> translate<64.770000,0.000000,28.416300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770000,0.000000,29.051400>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770100,0.000000,28.892500>}
box{<0,0,-0.100100><0.158900,0.035000,0.100100> rotate<0,89.958005,0> translate<64.770000,0.000000,29.051400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,0.000000,60.007500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770100,0.000000,60.483800>}
box{<0,0,-0.203200><0.476300,0.035000,0.203200> rotate<0,-89.982032,0> translate<64.770000,0.000000,60.007500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,60.483800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770100,-1.535000,60.483800>}
box{<0,0,-0.203200><0.000100,0.035000,0.203200> rotate<0,0.000000,0> translate<64.770000,-1.535000,60.483800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.436300,-1.535000,25.241300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.928700,-1.535000,25.241300>}
box{<0,0,-0.100100><3.492400,0.035000,0.100100> rotate<0,0.000000,0> translate<61.436300,-1.535000,25.241300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.182500,-1.535000,41.751300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.928700,-1.535000,43.497500>}
box{<0,0,-0.100100><2.469500,0.035000,0.100100> rotate<0,-44.997030,0> translate<63.182500,-1.535000,41.751300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.023800,-1.535000,34.448800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.928800,-1.535000,36.353800>}
box{<0,0,-0.203200><2.694077,0.035000,0.203200> rotate<0,-44.997030,0> translate<63.023800,-1.535000,34.448800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.658800,0.000000,37.623800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.928800,0.000000,36.353800>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<63.658800,0.000000,37.623800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.023800,-1.535000,42.227500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.928800,-1.535000,44.132500>}
box{<0,0,-0.100100><2.694077,0.035000,0.100100> rotate<0,-44.997030,0> translate<63.023800,-1.535000,42.227500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.928800,0.000000,52.546300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.928800,0.000000,55.721200>}
box{<0,0,-0.100000><3.174900,0.035000,0.100000> rotate<0,90.000000,0> translate<64.928800,0.000000,55.721200> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.500100,0.000000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.928800,0.000000,55.721300>}
box{<0,0,-0.100100><2.020487,0.035000,0.100100> rotate<0,44.997030,0> translate<63.500100,0.000000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.928800,0.000000,55.721200>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.928800,0.000000,55.721300>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,90.000000,0> translate<64.928800,0.000000,55.721300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<63.976300,0.000000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<65.087500,0.000000,17.938800>}
box{<0,0,-0.100000><1.571474,0.035000,0.100000> rotate<0,44.997030,0> translate<63.976300,0.000000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<60.483800,-1.535000,25.717500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<65.087500,-1.535000,25.717500>}
box{<0,0,-0.100000><4.603700,0.035000,0.100000> rotate<0,0.000000,0> translate<60.483800,-1.535000,25.717500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,32.702500>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<65.087500,-1.535000,33.020000>}
box{<0,0,-0.203200><0.449013,0.035000,0.203200> rotate<0,-44.997030,0> translate<64.770000,-1.535000,32.702500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.293700,0.000000,19.526300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<65.246200,0.000000,18.573700>}
box{<0,0,-0.100000><1.347109,0.035000,0.100000> rotate<0,45.000037,0> translate<64.293700,0.000000,19.526300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.293800,-1.535000,1.270000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.246300,-1.535000,2.222500>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,-44.997030,0> translate<64.293800,-1.535000,1.270000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<63.658800,-1.535000,6.826300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.246300,-1.535000,5.238800>}
box{<0,0,-0.100100><2.245064,0.035000,0.100100> rotate<0,44.997030,0> translate<63.658800,-1.535000,6.826300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.246300,-1.535000,2.222500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.246300,-1.535000,5.238800>}
box{<0,0,-0.100100><3.016300,0.035000,0.100100> rotate<0,90.000000,0> translate<65.246300,-1.535000,5.238800> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.770000,-1.535000,14.605000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<65.246300,-1.535000,15.081300>}
box{<0,0,-0.100000><0.673590,0.035000,0.100000> rotate<0,-44.997030,0> translate<64.770000,-1.535000,14.605000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<62.388800,0.000000,53.181300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<65.246300,0.000000,50.323800>}
box{<0,0,-0.100000><4.041115,0.035000,0.100000> rotate<0,44.997030,0> translate<62.388800,0.000000,53.181300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<65.246300,0.000000,49.371300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<65.246300,0.000000,50.323800>}
box{<0,0,-0.100000><0.952500,0.035000,0.100000> rotate<0,90.000000,0> translate<65.246300,0.000000,50.323800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<61.436300,0.000000,69.850000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.246300,0.000000,69.850000>}
box{<0,0,-0.100100><3.810000,0.035000,0.100100> rotate<0,0.000000,0> translate<61.436300,0.000000,69.850000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<59.531300,-1.535000,26.193800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.246400,-1.535000,26.193800>}
box{<0,0,-0.100100><5.715100,0.035000,0.100100> rotate<0,0.000000,0> translate<59.531300,-1.535000,26.193800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.611200,-1.535000,24.288800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.404900,-1.535000,23.495100>}
box{<0,0,-0.100100><1.122461,0.035000,0.100100> rotate<0,44.997030,0> translate<64.611200,-1.535000,24.288800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.404900,0.000000,30.321300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.404900,0.000000,33.178800>}
box{<0,0,-0.100100><2.857500,0.035000,0.100100> rotate<0,90.000000,0> translate<65.404900,0.000000,33.178800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.452500,0.000000,23.495000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.405000,0.000000,24.447500>}
box{<0,0,-0.100100><1.347038,0.035000,0.100100> rotate<0,-44.997030,0> translate<64.452500,0.000000,23.495000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<57.943600,-1.535000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<65.405000,-1.535000,26.670000>}
box{<0,0,-0.100000><7.461400,0.035000,0.100000> rotate<0,0.000000,0> translate<57.943600,-1.535000,26.670000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.405000,0.000000,24.447500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.405000,0.000000,28.257500>}
box{<0,0,-0.100100><3.810000,0.035000,0.100100> rotate<0,90.000000,0> translate<65.405000,0.000000,28.257500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.404900,0.000000,33.178800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.405000,0.000000,33.813800>}
box{<0,0,-0.100100><0.635000,0.035000,0.100100> rotate<0,-89.985038,0> translate<65.404900,0.000000,33.178800> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.405000,0.000000,33.813800>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.405000,0.000000,34.658300>}
box{<0,0,-0.100100><0.844500,0.035000,0.100100> rotate<0,90.000000,0> translate<65.405000,0.000000,34.658300> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<65.405000,0.000000,44.716700>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<65.405000,0.000000,48.418800>}
box{<0,0,-0.100000><3.702100,0.035000,0.100000> rotate<0,90.000000,0> translate<65.405000,0.000000,48.418800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,60.483800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<65.405000,-1.535000,61.118800>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,-44.997030,0> translate<64.770000,-1.535000,60.483800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<65.405000,-1.535000,61.118800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<65.405000,-1.535000,62.280800>}
box{<0,0,-0.203200><1.162000,0.035000,0.203200> rotate<0,90.000000,0> translate<65.405000,-1.535000,62.280800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<65.405000,-1.535000,72.339200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<65.405000,-1.535000,75.882500>}
box{<0,0,-0.203200><3.543300,0.035000,0.203200> rotate<0,90.000000,0> translate<65.405000,-1.535000,75.882500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.405000,0.000000,28.257500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.405100,0.000000,28.575000>}
box{<0,0,-0.100100><0.317500,0.035000,0.100100> rotate<0,-89.976016,0> translate<65.405000,0.000000,28.257500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.405000,0.000000,28.892600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.405100,0.000000,28.575000>}
box{<0,0,-0.100100><0.317600,0.035000,0.100100> rotate<0,89.976021,0> translate<65.405000,0.000000,28.892600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.404900,0.000000,30.321300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.405100,0.000000,29.368800>}
box{<0,0,-0.100100><0.952500,0.035000,0.100100> rotate<0,89.982031,0> translate<65.404900,0.000000,30.321300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.405000,0.000000,28.892600>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.405100,0.000000,29.368800>}
box{<0,0,-0.100100><0.476200,0.035000,0.100100> rotate<0,-89.982029,0> translate<65.405000,0.000000,28.892600> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.611300,0.000000,20.002500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.563700,0.000000,19.050000>}
box{<0,0,-0.100100><1.346968,0.035000,0.100100> rotate<0,45.000038,0> translate<64.611300,0.000000,20.002500> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<64.611300,0.000000,20.002500>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<65.563800,0.000000,19.050000>}
box{<0,0,-0.100000><1.347038,0.035000,0.100000> rotate<0,44.997030,0> translate<64.611300,0.000000,20.002500> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.563700,0.000000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.563800,0.000000,19.050000>}
box{<0,0,-0.100100><0.000100,0.035000,0.100100> rotate<0,0.000000,0> translate<65.563700,0.000000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.770100,-1.535000,24.765000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.563800,-1.535000,23.971200>}
box{<0,0,-0.100100><1.122532,0.035000,0.100100> rotate<0,45.000639,0> translate<64.770100,-1.535000,24.765000> }
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<59.531300,-1.535000,27.146300>}
cylinder{<0,0,0><0,0.035000,0>0.100000 translate<65.563800,-1.535000,27.146300>}
box{<0,0,-0.100000><6.032500,0.035000,0.100000> rotate<0,0.000000,0> translate<59.531300,-1.535000,27.146300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.928700,-1.535000,43.497500>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.563800,-1.535000,43.497500>}
box{<0,0,-0.100100><0.635100,0.035000,0.100100> rotate<0,0.000000,0> translate<64.928700,-1.535000,43.497500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.880000,-1.535000,59.531300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<65.563800,-1.535000,59.531300>}
box{<0,0,-0.203200><9.683800,0.035000,0.203200> rotate<0,0.000000,0> translate<55.880000,-1.535000,59.531300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.928700,-1.535000,25.241300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.722400,-1.535000,24.447500>}
box{<0,0,-0.100100><1.122532,0.035000,0.100100> rotate<0,45.000639,0> translate<64.928700,-1.535000,25.241300> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<64.450000,0.000000,68.580000>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.722500,0.000000,67.307500>}
box{<0,0,-0.100100><1.799587,0.035000,0.100100> rotate<0,44.997030,0> translate<64.450000,0.000000,68.580000> }
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.722500,0.000000,63.341300>}
cylinder{<0,0,0><0,0.035000,0>0.100100 translate<65.722500,0.000000,67.307500>}
box{<0,0,-0.100100><3.966200,0.035000,0.100100> rotate<0,90.000000,0> translate<65.722500,0.000000,67.307500> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.452500,0.000000,74.930000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<65.722500,0.000000,76.200000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<64.452500,0.000000,74.930000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<65.405000,-1.535000,75.882500