         ' LCD - Tastatur                             15.08.2006
         ' Anzeige, Speicher schreiben, Ser-Ausgabe 
         ' mit PIC 16 F 628 / 16 F 84
         ' Relaisversatz 7,6 MHz ist in der Euro -Variante vorhanden! 
         ' Ausgabe VFO-A/B, keine Cursor-Position
        
         date 
         time
         
         
         define device 16f84, wdt_off, lvp_off, hs_osc 'oder 16f628 fr 16f84 eintragen
         xtal 4.00
         
         
         define serout = soft
         define serin = soft
         
         define keys rb,0,"A","7","4","1","0","8","5",{+}
                          "2","B","9","6","3"
                          
                           
         define ta_dat  = $20           
         define o_dat1  = $21
         define o_dat2  = $22
         define o_dat3  = $23
         define o_dat4  = $24
         define o_dat5  = $25
         define spalte  = $26
         define zeile   = $27
         define sp      = $28
         define zahl    = $29
         define tmp0    = $2a
         define tmp1    = $2b
         define tmp2    = $2c
         define t_sp    = $2d
         define t_ze    = $2e        
         define wert    = $2f
                 
         define qrg     = $30 as byte
         
init:    wait 1000
         tris ra=%11111101            'ra 7-2 input, ra1=out, ra0=in
         tris rb=%00001111            'rb 7-4 output, 3-0 input LCD, Tastatur
         
         lcdinit rb,2,16              ' LCD init --> rb,2,8 einzeilig HD44780
         lcdwrite 1,1,"FT817-St"
         lcdwrite 2,1,"euerung "
         wait 3000
         lcdclear
         gosub az1
         gosub grund
         gosub leer
         'curson
         
main:    let spalte=5                 'Anfangsposition LCD
         let zeile=1
         let sp=8                     'Anfangsposition QRG-Ram
         
                                             
start:   gosub tast
         if ta_dat="1" then goto in1
         if ta_dat="2" then goto in2
         if ta_dat="3" then goto in3
         if ta_dat="4" then goto in4
         if ta_dat="5" then goto in5
         if ta_dat="6" then goto in6
         if ta_dat="7" then goto in7
         if ta_dat="8" then goto in8
         if ta_dat="9" then goto in9
         if ta_dat="0" then goto in0
         if ta_dat="A" then goto ina   'eine Position zurck
         if ta_dat="B" then goto inb   'Daten zum Gert
         goto start
         
in1:     let wert="1"
         gosub zeisp 
         let qrg(sp)=1
         gosub aw
         if spalte=15 then goto inb
         goto start
in2:     let wert="2"
         gosub zeisp
         let qrg(sp)=2
         gosub aw
         if spalte=15 then goto inb
         goto start
in3:     let wert="3"
         gosub zeisp        
         let qrg(sp)=3
         gosub aw
         if spalte=15 then goto inb
         goto start                  
in4:     let wert="4"
         gosub zeisp         
         let qrg(sp)=4
         gosub aw
         if spalte=15 then goto inb
         goto start         
in5:     let wert="5"
         gosub zeisp         
         let qrg(sp)=5
         gosub aw
         if spalte=15 then goto inb
         goto start         
in6:     let wert="6"
         gosub zeisp         
         let qrg(sp)=6
         gosub aw
         if spalte=15 then goto inb
         goto start         
in7:     let wert="7"
         gosub zeisp         
         let qrg(sp)=7
         gosub aw
         if spalte=15 then goto inb
         goto start         
in8:     let wert="8"
         gosub zeisp         
         let qrg(sp)=8
         gosub aw
         if spalte=15 then goto inb
         goto start
in9:     let wert="9"
         gosub zeisp         
         let qrg(sp)=9
         gosub aw
         if spalte=15 then goto inb
         goto start         
in0:     let wert="0"
         gosub zeisp         
         let qrg(sp)=0
         gosub aw
         if spalte=15 then goto inb
         goto start  
                
ina:     inc sp                        'Zurck
         if sp=9 then let sp=8        
         let qrg(sp)=$f
         if sp=8 then let sp=7
         dec spalte
         if spalte=4 then goto ina1               
         if spalte=8 then let spalte=7
         let wert=" "
         gosub zeisp                                         
         locate t_ze,t_sp
         goto start                                        
         
ina1:    lcdwrite 1,1,"VFO A<->"
         lcdwrite 2,1,"B mit  #"
ina2:    gosub tast
         if ta_dat="B" then goto inb3   'VFO - Wechsel: Daten zum Gert
         gosub az1
         goto main
   
inb:     gosub az2
         wait 500 
         lcdwrite 2,8," " 
         wait 1000 
         gosub az2            
         let o_dat5 =$01
inb1:    gosub dat_set
inb2:    wait 1000
         gosub az1
         goto main 
inb3:    gosub grund         
         let o_dat5=$81
         gosub aus
         goto inb2      

dat_set: let sp=8
         gosub rot                     'Nibbel selektieren
         let tmp2=qrg(8)
         let tmp1=qrg(7)
         let o_dat1=tmp2 or tmp1
         let sp=6
         gosub rot                     'Nibbel selektieren
         let tmp2=qrg(6)
         let tmp1=qrg(5)
         let o_dat2=tmp2 or tmp1
         let sp=4
         gosub rot                     'Nibbel selektieren
         let tmp2=qrg(4)
         let tmp1=qrg(3)
         let o_dat3=tmp2 or tmp1
         let sp=2
         gosub rot                     'Nibbel selektieren
         let tmp2=qrg(2)
         let tmp1=qrg(1)
         let o_dat4=tmp2 or tmp1
         gosub aus
         gosub grund                   'Speicher rckgesetzt
         gosub leer
         return                        

tast:    inkey ta_dat                 'Tastatur einlesen
         wait 100
         if ta_dat=0 then goto tast   'keine Taste gedrckt ? 
         wait 150
         return

aw:      dec sp                        'Position setzen
         inc spalte
         if spalte=8 then let spalte=9
         return

leer:    for zahl=1 to 8               'Ausgabespeicher auf "0" stellen
         let qrg(zahl)=0
         next zahl
         return         
                
az1:     lcdwrite 1,1,"QRG:   ,"
         lcdwrite 2,1,"        "
         locate 1,5
         return

az2:     lcdwrite 2,8,"#"
         return
    
rot:     let tmp0=qrg(sp)              'Position 4x nach links
         for zahl=0 to 3
         shl tmp0
         next zahl
         let qrg(sp)=tmp0
         return


aus:     set ra,1                      'Ruhepegel 
         serout ra.1,4800,o_dat1,o_dat2,o_dat3,o_dat4,o_dat5                 
         set ra,1                      'Ruhepegel 
         return

grund:   let o_dat1 = 0
         let o_dat2 = 0
         let o_dat3 = 0
         let o_dat4 = 0
         let o_dat5 = 1                 
         return

zeisp:   let t_ze=zeile
         let t_sp=spalte
         if t_sp>7 then let t_ze=2
         if t_ze=2 then let t_sp=t_sp-8
         lcdwrite t_ze,t_sp,wert,#             '"wert" mit "#" als ASCII ausgeben
         if t_ze=2 then goto zeisu
         return

zeisu:   if t_sp=6 then lcdwrite t_ze,t_sp," " 'unterdrcken der 6ten Stelle nach Komma
         return                        
         


   
