// Persistence Of Vision raytracer version default scene file.
// By Arie Voors
// This image contains the default scene in which the nec2 structure or far-field pattern is placed.

global_settings { assumed_gamma 2.2 }
                
#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "skies.inc"


// Select one of the below camera points by removing and addeng comment indicators: //

//#declare cdist = 200;          // Short distance camera
//#declare cang = 70;
#declare cdist = 400;        // Medium distance camera
#declare cang = 36;
//#declare cdist = 800;        // Long distance camera
//#declare cang = 19;
                        
#declare height = 50;          // Camera height to look at in case of groundplane.

#declare ldist = cdist+100;   // Distance for light_source
#declare lcolor = White;      // Color for light source

#declare dPHI = radians (5);  // Degrees right from camera to light source.
#declare dTHE = radians (10); // Degrees upwards from camera to light source

#declare Pattern  = texture { pigment { Red } finish { ambient .1 diffuse .8 }} // Pattern texture
#declare Geometry = texture { T_Copper_4A }                                      // Geometry texture

#declare PerfGnd = texture { T_Silver_5D }                                       // Perfect Ground(plane)
#declare FiniGnd = texture { pigment { Green } finish { ambient .4 diffuse .6 }} // Finite Ground(plane)

#declare MyClouds = sky_sphere { S_Cloud1 }                                     // Sky filled with clouds 
                                                                                
sky_sphere { MyClouds }
