'============================================================================
'  XR232 Commandline Tool for DOS V1.00 - (C) 2004/2005 Julien Thomas
'  - Compile with PowerBASIC 3.2 -
'  Last Modification: 26.11.2005 - jt
'============================================================================
'
DEFINT A-Z
DEFLNG T
DIM Arg$(8)	   	' arguments read from the commandline
DIM RB%(1023)         	' 1k random / universal data array
CPT$="COM2:9600"	' communications port string
'
ON ERROR GOTO 10000
GOTO Main
'
'----------------------------------------------------------------------------
' GETARGS - Parse commandline arguments separated by: [SPACE], "/" or "-"
'----------------------------------------------------------------------------
SUB GETARGS (C$) SHARED
LOCAL Q$
C$=UCASE$(C$)
ERASE Arg$
Argc=0
IF (C$ = "") THEN EXIT SUB
Argc = 1: I = 0
WHILE (I < LEN(C$)): I = I + 1
	Q$ = MID$(C$, I, 1)
	IF (((Q$ = " ") OR (Q$ = "/") OR (Q$ = "-"))) THEN GOSUB Separator
	Arg$(Argc) = Arg$(Argc) + Q$
WEND
IF Arg$(Argc) = "" THEN IF Argc > 1 THEN Argc = Argc - 1
EXIT SUB
Separator:
I = I + 1: Q$ = MID$(C$, I, 1)
IF (((Q$ = " ") OR (Q$ = "/") OR (Q$ = "-"))) THEN GOTO Separator
IF Arg$(Argc) <> "" THEN Argc = Argc + 1
RETURN
END SUB
'
'----------------------------------------------------------------------------
' XR232Init - Initialize XR232 at specified COM-Port (CPT$)
'----------------------------------------------------------------------------
FUNCTION XR232Init (CPT$)
XR232Init = 0
A = 0: ZL = 11: Y = CSRLIN: X = POS(0)
IXR:
A = A + 1
CLOSE #64:OPEN CPT$ + ",N,8,1,DT" FOR RANDOM AS #64
DELAY 1
IF INKEY$ <> "" OR A > 20 THEN CLOSE : EXIT FUNCTION    'try and try...
Z = 0
WHILE (Z < ZL)
	Z = Z + 1
        L = LOC(64)
	PRINT #64, CHR$(85); : PRINT ".";
	DELAY 0.3
	IF (LOC(64) - L) <> 1 THEN PRINT #64,CHR$(255);:PRINT "*";:GOTO IXR
WEND
IF Z = ZL THEN XR232Init = 1
LOCATE Y, X: PRINT SPC(60); : LOCATE Y, X
END FUNCTION
'
'----------------------------------------------------------------------------
' XR232Byte - Read random byte from XR232
'----------------------------------------------------------------------------
FUNCTION XR232Byte
ON ERROR GOTO Xerror
L = LOC(64)
PRINT #64, CHR$(85);
T=TIMER + 3 : WHILE ((LOC(64) - L) <> 1) AND T > TIMER: WEND
XR232Byte = ASC(INPUT$(1, #64))
END FUNCTION
'
'----------------------------------------------------------------------------
' XR232Bit - Calcul parity bit from XR232 random byte
'----------------------------------------------------------------------------
FUNCTION XR232Bit
ON ERROR GOTO Xerror
A = XR232Byte
A = ((A AND 240) / 16) XOR (A AND 15)
A = ((A AND 12) / 4) XOR (A AND 3)
A = ((A AND 2) / 2) XOR (A AND 1)
XR232Bit = A
END FUNCTION
'
'----------------------------------------------------------------------------
' XR232Integer - Get 16-bit value from XR232 (-32768...+32767)
'----------------------------------------------------------------------------
FUNCTION XR232Integer
ON ERROR GOTO Xerror
A = XR232Byte: B = XR232Byte
XR232Integer = ((A + B * 256) - 32768)
'
END FUNCTION
'
'----------------------------------------------------------------------------
'
'
Main:
CALL GETARGS (COMMAND$)                      'split COMMAND$ into arguments
PRINT C$
'Parse arguments Argc=number of arguments, Arg$(argc)=argument-strings
IF Argc = 0 OR Arg$(1) = "H" OR Arg$(1) = "?" THEN GOTO XR232Help
IF Argc > 4 THEN BEEP: PRINT "! TOO MANY ARGUMENTS !": END
CPT$ = Arg$(1)
IF LEN(Arg$(1)) = 4 THEN CPT$ = CPT$ + ":9600"          'baudrate default
IF Argc = 1 THEN GOTO TestRatio        'only COMx specified --> testmode
'More arguments --> Generate random file
IF Arg$(2) = "T" THEN GOTO TestRatio
IF Arg$(2) = "G" AND Argc = 2 THEN GOTO TestGraphical
Filename$ = Arg$(2)
IF VAL(Arg$(3)) < 1 OR VAL(Arg$(3)) > 32767 THEN GOTO 10000
kb = VAL(Arg$(3))
IF Arg$(4) = "" THEN Balance$ = "NONE": GOTO WriteUnbalancedFile
IF Arg$(4) = "B" THEN Balance$ = "BLOCK-SHIFTED-XOR": GOTO WriteBXORFile
IF Arg$(4) = "P" THEN Balance$ = "PARITY": GOTO WriteParityFile
IF Arg$(4) = "R" THEN Balance$ = "RANDOMIZE": GOTO WriteRNDFile
IF Arg$(4) = "N" THEN Balance$ = "NEUMANN": GOTO WriteNeumannFile
IF Arg$(4) = "X" THEN Balance$ = "XOR": GOTO WriteXORFile
GOTO 10000
'
'
'
'----------------------------------------------------------------------------
' Write unbalanced random file (raw data)
'----------------------------------------------------------------------------
WriteUnbalancedFile:
GOSUB OpenUp
WHILE (K < kb) AND INKEY$ = ""
        FOR I = 0 TO 1023
	A = XR232Byte
        PRINT #2, CHR$(A);
        NEXT I
K = K + 1
GOSUB RFStatus
WEND
GOTO WFinished
'
'
'
'----------------------------------------------------------------------------
' Write balanced random file (block XOR with bit shifting and byte shuffling)
'----------------------------------------------------------------------------
WriteBXORFile:
GOSUB OpenUp
GOSUB RFStatus
ERASE RB%
'
FOR I = 0 TO 1023: RB%(I) = XR232Byte: NEXT I
FOR J = 0 TO 2
        A = (XR232Integer + 32768) AND 1023
        FOR I = 0 TO 1023
        RB%(I) = XR232Byte XOR ((RB%((I + A) AND 1023) * 2) AND 255) + ABS(((RB%((I + A) AND 1023) * 2) AND 256) = 256)
        NEXT I
NEXT J
'
WHILE (K < kb) AND INKEY$ = ""
        A = (XR232Integer + 32768) AND 1023
        FOR I = 0 TO 1023
        RB%(I) = XR232Byte XOR ((RB%((I + A) AND 1023) * 2) AND 255) + ABS(((RB%((I + A) AND 1023) * 2) AND 256) = 256)
        NEXT I
        FOR I = 0 TO 1023: PRINT #2, CHR$(RB%(I)); : NEXT I
        K = K + 1
        GOSUB RFStatus
WEND
GOTO WFinished
'
'
'----------------------------------------------------------------------------
' Write balanced file from byte-parities (warning: 8 times slower...)
'----------------------------------------------------------------------------
WriteParityFile:
GOSUB OpenUp
WHILE (K < kb) AND INKEY$ = ""
        FOR I = 0 TO 1023
                C = 0
                FOR J = 0 TO 7: C = C + XR232Bit * (2 ^ J): NEXT J
                PRINT #2, CHR$(C);
        NEXT I
        K = K + 1
        GOSUB RFStatus
WEND
GOTO WFinished
'
'
'----------------------------------------------------------------------------
' Write balanced random file, using RND(1) function, seeded by TRNG
'----------------------------------------------------------------------------
WriteRNDFile:
GOSUB OpenUp
GOSUB RFStatus
RANDOMIZE (XR232Integer)
FOR I = 0 TO 1023
IF I / 32 = I \ 32 THEN
        RANDOMIZE (XR232Integer)
        A = (XR232Integer + 32768) AND 1023
        END IF
RB%(I) = RB%((I + A) AND 1023) XOR INT(RND(1) * 256)
NEXT I
WHILE (K < kb) AND INKEY$ = ""
        FOR I = 0 TO 1023
                IF I / 32 = I \ 32 THEN
                        RANDOMIZE (XR232Integer)
                        A = (XR232Integer + 32768) AND 1023
                        END IF
                RB%(I) = RB%((I + A) AND 1023) XOR INT(RND(1) * 256)
        NEXT I
        FOR I = 0 TO 1023: PRINT #2, CHR$(RB%(I)); : NEXT I
        K = K + 1
        GOSUB RFStatus
WEND
GOTO WFinished
'
'
'
'----------------------------------------------------------------------------
' Write von Neumann balanced random file
'----------------------------------------------------------------------------
WriteNeumannFile:
GOSUB OpenUp
GOSUB RFStatus
ERASE RB%
A = 0: ZB = 0
WHILE (K < kb) AND INKEY$ = ""
Z = 0: C = 0
WHILE Z < 1024
        A = XR232Byte
        FOR I = 0 TO 7: RB%(I) = ABS((A AND 2 ^ I) = 2 ^ I): NEXT I
        FOR J = 0 TO 3
                IF RB%(J * 2) <> RB%((J * 2) + 1) THEN
                C = C + (2 ^ ZB) * RB%(J * 2): ZB = ZB + 1
                END IF
        IF ZB > 7 THEN ZB = 0: PRINT #2, CHR$(C); : C = 0: Z = Z + 1
        NEXT J
WEND
K = K + 1
GOSUB RFStatus
WEND
GOTO WFinished
'
'
'----------------------------------------------------------------------------
' Write XOR balanced file (bitwise!)
'----------------------------------------------------------------------------
WriteXORFile:
GOSUB OpenUp
GOSUB RFStatus
WHILE (K < kb) AND INKEY$ = ""
FOR J = 0 TO 1023
A = XR232Byte
FOR I = 0 TO 7: RB%(I) = ABS((A AND 2 ^ I) = 2 ^ I): NEXT I
A = XR232Byte
FOR I = 0 TO 7: RB%(I + 8) = ABS((A AND 2 ^ I) = 2 ^ I): NEXT I
C = 0
FOR I = 0 TO 7
C = C + (2 ^ I) * ABS((RB%(I * 2) XOR (RB%((I * 2) + 1))))
NEXT I
PRINT #2, CHR$(C);
NEXT J
K = K + 1
GOSUB RFStatus
WEND
GOTO WFinished
'
'
'
'----------------------------------------------------------------------------
' Numerical test suite (10k-ratio)
'----------------------------------------------------------------------------
TestRatio:
PRINT
PRINT "TESTING XR232 UNBALANCED RANDOM BIT COUNT"
PRINT
PRINT "ADJUST ...";
IF XR232Init(CPT$) = 0 THEN GOTO 10000
PRINT " O.K."
PRINT
PRINT "XR232 @ "; CPT$: PRINT
WHILE INKEY$ = ""
        T = 0
        FOR K = 1 TO 10
        Z = 0
                FOR J = 0 TO 999
                        X = XR232Byte
                        FOR I = 0 TO 7
                        Z = Z + ABS((X AND 2 ^ I) = 2 ^ I)
                        NEXT I
                NEXT J
                T = T + Z
                PRINT USING "##.#"; Z / 80; : PRINT "%   ";
                IF INKEY$ <> "" THEN CLOSE : BEEP: END
        NEXT K
PRINT
PRINT
PRINT "10.000 BYTES   RATIO: "; T / 800; "%   /   BIAS: "; (T / 800) - 50; "%"
PRINT
WEND
GOTO 10000
'
'
'----------------------------------------------------------------------------
' Graphical test suite
'----------------------------------------------------------------------------
TestGraphical:
SCREEN 11
WHILE INKEY$ = ""
FOR Y = 0 TO 479 STEP 8
IF INKEY$ <> "" THEN SCREEN 0: BEEP: END
FOR X = 0 TO 639
A = XR232Byte
FOR I = 0 TO 7
PSET (X, Y + I), ABS((A AND 2 ^ I) = 2 ^ I)
NEXT I
NEXT X, Y
WEND
SCREEN 0
END
'
'
'----------------------------------------------------------------------------
' Open file and XR232 channel plus some screen arrangements
'----------------------------------------------------------------------------
OpenUp:
CLOSE
OPEN Filename$ FOR OUTPUT AS #2
OPEN CPT$ + ",N,8,1" FOR RANDOM AS #64
PRINT
PRINT "GENERATING RANDOM FILE"
Y = CSRLIN
FOR I = 1 TO 8: PRINT : NEXT I
IF CSRLIN = Y THEN Y = Y - 8
K = 0
RETURN
'
'
'----------------------------------------------------------------------------
' Write File status report
'----------------------------------------------------------------------------
RFStatus:
LOCATE Y, 1
PRINT
PRINT "SOURCE    :  "; CPT$
PRINT "TARGET    :  "; Filename$
PRINT "BALANCING :  "; Balance$
PRINT "KILOBYTES : "; kb
PRINT "PROGRESS  : "; K;
LOCATE Y + 5, 14                'just stay at the 'progress' line and column
RETURN
'
'
'----------------------------------------------------------------------------
' Write file finished (successfully or not)
'----------------------------------------------------------------------------
WFinished:
CLOSE
PRINT : PRINT
IF K = kb THEN PRINT "FINISHED." ELSE BEEP: PRINT "- ABORT BY USER ! -"
PRINT
END
'
'
'----------------------------------------------------------------------------
' AGGRESSIVE ERROR - HANDLING (priorities: re-adjust, continue)
'----------------------------------------------------------------------------
Xerror:
IF XR232Init(CPT$) = 1 THEN RESUME
PRINT:PRINT:PRINT "ABORT!"
GOTO 10000
'
'
'----------------------------------------------------------------------------
' ABORT / CLOSE ALL / END
'----------------------------------------------------------------------------
10000 :
PRINT: PRINT "ERROR: "; ERR: PRINT: CLOSE: BEEP: END
'
'----------------------------------------------------------------------------
' Helpscreen while argument was /H /? or none
'----------------------------------------------------------------------------
XR232Help:
PRINT
PRINT "------------------------------------------------------------------------------"
PRINT "XR232 Commandline Tool for DOS - Version 1.00 by Julien Thomas, joytec@gmx.de"
PRINT "------------------------------------------------------------------------------"
PRINT "Testing Modes:"
PRINT "XR232 [/H|/?]                 This helpscreen"
PRINT "XR232 COMx[:Baud] [/T]        Test ratio/bias of raw data"
PRINT "XR232 COMx[:Baud] /G          Graphical testing (VGA)"
PRINT
PRINT "Operational Modes:"
PRINT "XR232 COMx[:Baud] Filename N [/B|/N|/P|/R|/X]"
PRINT "Write <N> kilobytes of binary random data to the specified <path/filename>"
PRINT "with comprehensive balancing options:"
PRINT "          /B                  BLOCK based & bitshifted XOR"
PRINT "          /N                  NEUMANN balancing procedure"
PRINT "          /P                  PARITY of 8 respective bits"
PRINT "          /R                  RANDOMIZED RND() with XR232-seeding"
PRINT "          /X                  XOR on successive bits"
PRINT
PRINT "Notes:"
PRINT "All standard baudrates from 75 up to 57600 baud are valid. Default is 9600."
END
'----------------------------------------------------------------------------
'----------------------------------------------------------------------------
'----------------------------------------------------------------------------
