'=======================================
'  HALLOXR.BAS - Beispielprogramm
'  zur protokollgemaessen Nutzung des
'  XR232-TRNG in Standard-BASIC
'  jt 2005/2006
'=======================================
'
DEFINT A-Z: DEFLNG T
'
C$ = "COM2:9600,N,8,1"
'
ON ERROR GOTO InitXR
'
CLS : PRINT "XR232 @ "; C$: PRINT
'
'---------------------------------------
' Hauptprogramm: TestXR
' Zufallsbytes anfordern und fortlaufend
' als Hex-Dump darstellen. Fehler loesen
' Sprung nach 'InitXR' aus (selten).
'---------------------------------------
'
TestXR:
DO UNTIL INKEY$ <> ""
L = LOC(64)
PRINT #64, CHR$(85);
T = TIMER + 1
WHILE (LOC(64) - L) <> 1 AND T > TIMER
WEND
A = ASC(INPUT$((1), #64))
PRINT LEFT$("0", ABS(A < 16)); HEX$(A);
LOOP
CLOSE : BEEP: END
'
'---------------------------------------
' Fehlerbehandlung: InitXR
' Port schliessen/erneut oeffnen,
' Synchronisieren, Rueckkehr
'---------------------------------------
'
InitXR:
CLOSE #64: OPEN C$ FOR RANDOM AS #64
IF INKEY$ <> "" THEN CLOSE : BEEP: END
Z = 0
WHILE (Z < 5)
Z = Z + 1
L = LOC(64)
PRINT #64, CHR$(85);
PRINT ".";
T = TIMER * 10 + 3
WHILE T > TIMER * 10: WEND
IF (LOC(64) - L) <> 1 THEN
	PRINT #64, CHR$(255);
	PRINT "*";
	GOTO InitXR
	END IF
WEND
RESUME
'
'=======================================


