//
// C++ Implementation: wkmanager
//
// Description: 
//
//
// Author: Andreas Lindenau <DL4JAL@darc.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QColorDialog>
#include <QColor>
#include <QIcon>
#include <QFileDialog>
#include <QTextStream>
#include <QFile>
#include <QDateTime>
#include <QPen>


#include "configfile.h"
#include "wkmanager.h"
#include "modem.h"
#include "tooltipwkm.h"

//#include "tooltipodlg.h"


//#####################################################################################
// Class fuer Option
//#####################################################################################
owkmanager::owkmanager(QWidget* parent, const char* name, bool modal)
{
  this->resize(450,330);
  this->setMinimumSize(0,0);
  this->setWindowTitle("Wobbelkurven-Manager");
  this->setWindowIcon(QIcon(":/images/appicon.png"));

  labelk1 = new QLabel("Kurve 1",this);
  labelk1->setGeometry(180, 10, 60, 20);
  labelk2 = new QLabel("Kurve 2",this);
  labelk2->setGeometry(240, 10, 60, 20);
  labelk3 = new QLabel("Kurve 3",this);
  labelk3->setGeometry(300, 10, 60, 20);
  labelk4 = new QLabel("Kurve 4",this);
  labelk4->setGeometry(360, 10, 60, 20);
  
  labelopen = new QLabel("Kurve laden",this);
  labelopen->setGeometry(10, 45, 150, 20);
  labelopen->setAlignment(Qt::AlignRight);
  
  labelsave = new QLabel("Kurve speichern",this);
  labelsave->setGeometry(10, 70, 150, 20);
  labelsave->setAlignment(Qt::AlignRight);
  
  labeluebernahme = new QLabel("Kurve uebernehmen",this);
  labeluebernahme->setGeometry(10, 95, 150, 20);
  labeluebernahme->setAlignment(Qt::AlignRight);
  
  labelcolor = new QLabel("Kurvenfarbe",this);
  labelcolor->setGeometry(10, 120, 150, 20);
  labelcolor->setAlignment(Qt::AlignRight);
  
  labelkanal = new QLabel("Kanalaktivierung",this);
  labelkanal->setGeometry(10, 145, 150, 20);
  labelkanal->setAlignment(Qt::AlignRight);
  
  labeleinblendung = new QLabel("Kurve einblenden",this);
  labeleinblendung->setGeometry(10, 170, 150, 20);
  labeleinblendung->setAlignment(Qt::AlignRight);
  
  open1 = new QPushButton("Open", this);
  open1->setGeometry(180,40,60,25);
  connect(open1, SIGNAL(clicked()), SLOT(sopen1()));
  
  open2 = new QPushButton("Open", this);
  open2->setGeometry(240,40,60,25);
  connect(open2, SIGNAL(clicked()), SLOT(sopen2()));
  
  open3 = new QPushButton("Open", this);
  open3->setGeometry(300,40,60,25);
  connect(open3, SIGNAL(clicked()), SLOT(sopen3()));
  
  open4 = new QPushButton("Open", this);
  open4->setGeometry(360,40,60,25);
  connect(open4, SIGNAL(clicked()), SLOT(sopen4()));
  
  save1 = new QPushButton("Save", this);
  save1->setGeometry(180,65,60,25);
  save1->setEnabled(false);
  connect(save1, SIGNAL(clicked()), SLOT(ssave1()));
  
  save2 = new QPushButton("Save", this);
  save2->setGeometry(240,65,60,25);
  save2->setEnabled(false);
  connect(save2, SIGNAL(clicked()), SLOT(ssave2()));
  
  save3 = new QPushButton("Save", this);
  save3->setGeometry(300,65,60,25);
  save3->setEnabled(false);
  connect(save3, SIGNAL(clicked()), SLOT(ssave3()));
  
  save4 = new QPushButton("Save", this);
  save4->setGeometry(360,65,60,25);
  save4->setEnabled(false);
  connect(save4, SIGNAL(clicked()), SLOT(ssave4()));
  
  uebernahme1 = new QPushButton("Holen", this);
  uebernahme1->setGeometry(180,90,60,25);
  connect(uebernahme1, SIGNAL(clicked()), SLOT(sholen1()));
  
  uebernahme2 = new QPushButton("Holen", this);
  uebernahme2->setGeometry(240,90,60,25);
  connect(uebernahme2, SIGNAL(clicked()), SLOT(sholen2()));
  
  uebernahme3 = new QPushButton("Holen", this);
  uebernahme3->setGeometry(300,90,60,25);
  connect(uebernahme3, SIGNAL(clicked()), SLOT(sholen3()));
  
  uebernahme4 = new QPushButton("Holen", this);
  uebernahme4->setGeometry(360,90,60,25);
  connect(uebernahme4, SIGNAL(clicked()), SLOT(sholen4()));
  
  color11 = new QPushButton("C1", this);
  color11->setGeometry(180,115,30,25);
  connect(color11, SIGNAL(clicked()), SLOT(scolor11()));
  color12 = new QPushButton("C2", this);
  color12->setGeometry(210,115,30,25);
  connect(color12, SIGNAL(clicked()), SLOT(scolor12()));
  
  color21 = new QPushButton("C1", this);
  color21->setGeometry(240,115,30,25);
  connect(color21, SIGNAL(clicked()), SLOT(scolor21()));
  color22 = new QPushButton("C2", this);
  color22->setGeometry(270,115,30,25);
  connect(color22, SIGNAL(clicked()), SLOT(scolor22()));
  
  color31 = new QPushButton("C1", this);
  color31->setGeometry(300,115,30,25);
  connect(color31, SIGNAL(clicked()), SLOT(scolor31()));
  color32 = new QPushButton("C2", this);
  color32->setGeometry(330,115,30,25);
  connect(color32, SIGNAL(clicked()), SLOT(scolor32()));
  
  color41 = new QPushButton("C1", this);
  color41->setGeometry(360,115,30,25);
  connect(color41, SIGNAL(clicked()), SLOT(scolor41()));
  color42 = new QPushButton("C2", this);
  color42->setGeometry(390,115,30,25);
  connect(color42, SIGNAL(clicked()), SLOT(scolor42()));
  
  checkboxk11 = new QCheckBox("1", this);
  checkboxk11->setGeometry(180,140,30,25);
  checkboxk11->setEnabled(false);
  connect(checkboxk11, SIGNAL(clicked()), this, SLOT(saktivk11()));
  checkboxk12 = new QCheckBox("2", this);
  checkboxk12->setGeometry(210,140,30,25);
  checkboxk12->setEnabled(false);
  connect(checkboxk12, SIGNAL(clicked()), this, SLOT(saktivk12()));
  
  checkboxk21 = new QCheckBox("1", this);
  checkboxk21->setGeometry(240,140,30,25);
  checkboxk21->setEnabled(false);
  connect(checkboxk21, SIGNAL(clicked()), this, SLOT(saktivk21()));
  checkboxk22 = new QCheckBox("2", this);
  checkboxk22->setGeometry(270,140,30,25);
  checkboxk22->setEnabled(false);
  connect(checkboxk22, SIGNAL(clicked()), this, SLOT(saktivk22()));
  
  checkboxk31 = new QCheckBox("1", this);
  checkboxk31->setGeometry(300,140,30,25);
  checkboxk31->setEnabled(false);
  connect(checkboxk31, SIGNAL(clicked()), this, SLOT(saktivk31()));
  checkboxk32 = new QCheckBox("2", this);
  checkboxk32->setGeometry(330,140,30,25);
  checkboxk32->setEnabled(false);
  connect(checkboxk32, SIGNAL(clicked()), this, SLOT(saktivk32()));
  
  checkboxk41 = new QCheckBox("1", this);
  checkboxk41->setGeometry(360,140,30,25);
  checkboxk41->setEnabled(false);
  connect(checkboxk41, SIGNAL(clicked()), this, SLOT(saktivk41()));
  checkboxk42 = new QCheckBox("2", this);
  checkboxk42->setGeometry(390,140,30,25);
  checkboxk42->setEnabled(false);
  connect(checkboxk42, SIGNAL(clicked()), this, SLOT(saktivk42()));
  
  aktiv1 = new QCheckBox("Aktiv", this);
  aktiv1->setGeometry(180,165,60,25);
  aktiv1->setEnabled(false);
  connect(aktiv1, SIGNAL(clicked()), this, SLOT(saktiv1()));
  
  aktiv2 = new QCheckBox("Aktiv", this);
  aktiv2->setGeometry(240,165,60,25);
  aktiv2->setEnabled(false);
  connect(aktiv2, SIGNAL(clicked()), SLOT(saktiv2()));
  
  aktiv3 = new QCheckBox("Aktiv", this);
  aktiv3->setGeometry(300,165,60,25);
  aktiv3->setEnabled(false);
  connect(aktiv3, SIGNAL(clicked()), SLOT(saktiv3()));
  
  aktiv4 = new QCheckBox("Aktiv", this);
  aktiv4->setGeometry(360,165,60,25);
  aktiv4->setEnabled(false);
  connect(aktiv4, SIGNAL(clicked()), SLOT(saktiv4()));
  
  labelkanal1 = new QLabel("Kurve 1 leer",this);
  labelkanal1->setGeometry(10, 210, 390, 20);
  labelkanal2 = new QLabel("Kurve 2 leer",this);
  labelkanal2->setGeometry(10, 230, 390, 20);
  labelkanal3 = new QLabel("Kurve 3 leer",this);
  labelkanal3->setGeometry(10, 250, 390, 20);
  labelkanal4 = new QLabel("Kurve 4 leer",this);
  labelkanal4->setGeometry(10, 270, 390, 20);
  
  buttonschliessen = new QPushButton("Schliessen", this);
  buttonschliessen->setGeometry(175,290,100,30);
  connect(buttonschliessen, SIGNAL(clicked()), SLOT(hide()));

  configfile nwt7configfile;
  QDir homedir = QDir::home();
  homedir.cd("hfm9");
  QColor pencolor;
  int r,g,b,a;
  QPalette palette;
  
  nwt7configfile.open(homedir.filePath("wkm.cfg"));
  
  r = nwt7configfile.readInteger("wkm11r", 185);
  g = nwt7configfile.readInteger("wkm11g", 1);
  b = nwt7configfile.readInteger("wkm11b", 185);
  a = nwt7configfile.readInteger("wkm11a", 255);
  pencolor.setRgb(r,g,b,a);
  wobbeldaten1.penkanal1.setColor(pencolor);
  palette = color11->palette();
  palette.setColor(QPalette::ButtonText, pencolor);
  color11->setPalette(palette);
  r = nwt7configfile.readInteger("wkm12r", 255);
  g = nwt7configfile.readInteger("wkm12g", 2);
  b = nwt7configfile.readInteger("wkm12b", 255);
  a = nwt7configfile.readInteger("wkm12a", 255);
  pencolor.setRgb(r,g,b,a);
  wobbeldaten1.penkanal2.setColor(pencolor);
  palette = color12->palette();
  palette.setColor(QPalette::ButtonText, pencolor);
  color12->setPalette(palette);
  
  r = nwt7configfile.readInteger("wkm21r", 255);
  g = nwt7configfile.readInteger("wkm21g", 170);
  b = nwt7configfile.readInteger("wkm21b", 0);
  a = nwt7configfile.readInteger("wkm21a", 255);
  pencolor.setRgb(r,g,b,a);
  wobbeldaten2.penkanal1.setColor(pencolor);
  palette = color21->palette();
  palette.setColor(QPalette::ButtonText, pencolor);
  color21->setPalette(palette);
  r = nwt7configfile.readInteger("wkm22r", 188);
  g = nwt7configfile.readInteger("wkm22g", 125);
  b = nwt7configfile.readInteger("wkm22b", 0);
  a = nwt7configfile.readInteger("wkm22a", 255);
  pencolor.setRgb(r,g,b,a);
  wobbeldaten2.penkanal2.setColor(pencolor);
  palette = color22->palette();
  palette.setColor(QPalette::ButtonText, pencolor);
  color22->setPalette(palette);
  
  r = nwt7configfile.readInteger("wkm31r", 128);
  g = nwt7configfile.readInteger("wkm31g", 255);
  b = nwt7configfile.readInteger("wkm31b", 0);
  a = nwt7configfile.readInteger("wkm31a", 255);
  pencolor.setRgb(r,g,b,a);
  wobbeldaten3.penkanal1.setColor(pencolor);
  palette = color31->palette();
  palette.setColor(QPalette::ButtonText, pencolor);
  color31->setPalette(palette);
  r = nwt7configfile.readInteger("wkm32r", 88);
  g = nwt7configfile.readInteger("wkm32g", 177);
  b = nwt7configfile.readInteger("wkm32b", 0);
  a = nwt7configfile.readInteger("wkm32a", 255);
  pencolor.setRgb(r,g,b,a);
  wobbeldaten3.penkanal2.setColor(pencolor);
  palette = color32->palette();
  palette.setColor(QPalette::ButtonText, pencolor);
  color32->setPalette(palette);
  
  r = nwt7configfile.readInteger("wkm41r", 0);
  g = nwt7configfile.readInteger("wkm41g", 170);
  b = nwt7configfile.readInteger("wkm41b", 255);
  a = nwt7configfile.readInteger("wkm41a", 255);
  pencolor.setRgb(r,g,b,a);
  wobbeldaten4.penkanal1.setColor(pencolor);
  palette = color41->palette();
  palette.setColor(QPalette::ButtonText, pencolor);
  color41->setPalette(palette);
  r = nwt7configfile.readInteger("wkm42r", 0);
  g = nwt7configfile.readInteger("wkm42g", 99);
  b = nwt7configfile.readInteger("wkm42b", 148);
  a = nwt7configfile.readInteger("wkm42a", 255);
  pencolor.setRgb(r,g,b,a);
  wobbeldaten4.penkanal2.setColor(pencolor);
  palette = color42->palette();
  palette.setColor(QPalette::ButtonText, pencolor);
  color42->setPalette(palette);
  
  nwt7configfile.close();
};

owkmanager::~owkmanager()
{
}

void owkmanager::tip(bool btip)
{
  QString open_tip(tip_open);
  QString holen_tip(tip_holen);
  QString wkmcolor_tip(tip_wkmcolor);
  QString save_tip(tip_save);

  if(btip){
    open1->setToolTip(open_tip);
    open2->setToolTip(open_tip);
    open3->setToolTip(open_tip);
    open4->setToolTip(open_tip);
    uebernahme1->setToolTip(holen_tip);
    uebernahme2->setToolTip(holen_tip);
    uebernahme3->setToolTip(holen_tip);
    uebernahme4->setToolTip(holen_tip);
    color11->setToolTip(wkmcolor_tip);
    color12->setToolTip(wkmcolor_tip);
    color21->setToolTip(wkmcolor_tip);
    color22->setToolTip(wkmcolor_tip);
    color31->setToolTip(wkmcolor_tip);
    color32->setToolTip(wkmcolor_tip);
    color41->setToolTip(wkmcolor_tip);
    color42->setToolTip(wkmcolor_tip);
    save1->setToolTip(save_tip);
    save2->setToolTip(save_tip);
    save3->setToolTip(save_tip);
    save4->setToolTip(save_tip);
  }else{
    open1->setToolTip("");
    open2->setToolTip("");
    open3->setToolTip("");
    open4->setToolTip("");
    uebernahme1->setToolTip("");
    uebernahme2->setToolTip("");
    uebernahme3->setToolTip("");
    uebernahme4->setToolTip("");
    color11->setToolTip("");
    color12->setToolTip("");
    color21->setToolTip("");
    color22->setToolTip("");
    color31->setToolTip("");
    color32->setToolTip("");
    color41->setToolTip("");
    color42->setToolTip("");
    save1->setToolTip("");
    save2->setToolTip("");
    save3->setToolTip("");
    save4->setToolTip("");
  }
}

void owkmanager::beenden()
{
  QDir homedir = QDir::home();
  homedir.cd("hfm9");
  QColor pencolor;
  int r,g,b,a;
  
  configfile *nwt7configfile = new configfile();
  nwt7configfile->open(homedir.filePath("wkm.cfg"));

  pencolor = wobbeldaten1.penkanal1.color();
  pencolor.getRgb(&r, &g, &b, &a);
  nwt7configfile->writeInteger("wkm11r", r);
  nwt7configfile->writeInteger("wkm11g", g);
  nwt7configfile->writeInteger("wkm11b", b);
  nwt7configfile->writeInteger("wkm11a", a);
  pencolor = wobbeldaten1.penkanal2.color();
  pencolor.getRgb(&r, &g, &b, &a);
  nwt7configfile->writeInteger("wkm12r", r);
  nwt7configfile->writeInteger("wkm12g", g);
  nwt7configfile->writeInteger("wkm12b", b);
  nwt7configfile->writeInteger("wkm12a", a);
  
  pencolor = wobbeldaten2.penkanal1.color();
  pencolor.getRgb(&r, &g, &b, &a);
  nwt7configfile->writeInteger("wkm21r", r);
  nwt7configfile->writeInteger("wkm21g", g);
  nwt7configfile->writeInteger("wkm21b", b);
  nwt7configfile->writeInteger("wkm21a", a);
  pencolor = wobbeldaten2.penkanal2.color();
  pencolor.getRgb(&r, &g, &b, &a);
  nwt7configfile->writeInteger("wkm22r", r);
  nwt7configfile->writeInteger("wkm22g", g);
  nwt7configfile->writeInteger("wkm22b", b);
  nwt7configfile->writeInteger("wkm22a", a);
  
  pencolor = wobbeldaten3.penkanal1.color();
  pencolor.getRgb(&r, &g, &b, &a);
  nwt7configfile->writeInteger("wkm31r", r);
  nwt7configfile->writeInteger("wkm31g", g);
  nwt7configfile->writeInteger("wkm31b", b);
  nwt7configfile->writeInteger("wkm31a", a);
  pencolor = wobbeldaten3.penkanal2.color();
  pencolor.getRgb(&r, &g, &b, &a);
  nwt7configfile->writeInteger("wkm32r", r);
  nwt7configfile->writeInteger("wkm32g", g);
  nwt7configfile->writeInteger("wkm32b", b);
  nwt7configfile->writeInteger("wkm32a", a);
  
  pencolor = wobbeldaten4.penkanal1.color();
  pencolor.getRgb(&r, &g, &b, &a);
  nwt7configfile->writeInteger("wkm41r", r);
  nwt7configfile->writeInteger("wkm41g", g);
  nwt7configfile->writeInteger("wkm41b", b);
  nwt7configfile->writeInteger("wkm41a", a);
  pencolor = wobbeldaten4.penkanal2.color();
  pencolor.getRgb(&r, &g, &b, &a);
  nwt7configfile->writeInteger("wkm42r", r);
  nwt7configfile->writeInteger("wkm42g", g);
  nwt7configfile->writeInteger("wkm42b", b);
  nwt7configfile->writeInteger("wkm42a", a);
  
  nwt7configfile->close();
}

void owkmanager::save(int nr)
{
  int i;
  QFile f;
  OWobbel w;
  QDir homedir = QDir::home();
  homedir.cd("hfm9");
  
  switch(nr){
    case 1:
      w = wobbeldaten1;
      break;
    case 2:
      w = wobbeldaten2;
      break;
    case 3:
      w = wobbeldaten3;
      break;
    case 4:
      w = wobbeldaten4;
      break;
  }
  QString s = QFileDialog::getSaveFileName(
                    homedir.filePath("*.hfd"),
                    tr("HFM9/NWT Kurvendatei (*.hfd)"),
                    this, 0, tr("HFM9/NWT Kurve speichern"));
  if (!s.isNull())
  {
    //Datei ueberpruefen ob Sufix vorhanden
    if((s.find(".")== -1)) s += ".hfd";
    f.setName(s);
    if(f.open( IO_WriteOnly )){
      QTextStream ts(&f);
      ts << w.anfangsfrequenz << endl;
      ts << w.schrittfrequenz << endl;
      ts << w.schritte << endl;
      ts << w.faktor1 << endl;
      ts << w.shift1 << endl;
      ts << w.faktor2 << endl;
      ts << w.shift2 << endl;
      switch(w.ebetriebsart){
       case ewobbeln:
         if(w.linear1 or w.linear2){
           //linear == 2
           ts << 2 << endl;
         }else{
           //log == 0
           ts << 0 << endl;
         }
         break;
       case eswrneu:
         //swr == 1
         ts << 1 << endl;
         break;
       case eswrant:
         //swr == 3
         ts << 3 << endl;
         break;
       case eimpedanz:
         //impedanz == 4
         ts << 4 << endl;
         break;
      }
      //Messung einlesen
      for(i=0; i<w.schritte; i++){
        ts << w.kanal1[i] << endl;
      }
      for(i=0; i<w.schritte; i++){
        ts << w.kanal2[i] << endl;
      }
      f.close();
      switch(nr){
        case 1:
          s = "Kurve 1: " +s;
          labelkanal1->setText(s);
          break;
        case 2:
          s = "Kurve 2: " +s;
          labelkanal2->setText(s);
          break;
        case 3:
          s = "Kurve 3: " +s;
          labelkanal3->setText(s);
          break;
        case 4:
          s = "Kurve 4: " +s;
          labelkanal4->setText(s);
          break;
      }
      
    }
  }
}

void owkmanager::open(int nr)
{
  int i;
  OWobbel w;
  QFile f;
  QDir homedir = QDir::home();
  homedir.cd("hfm9");
  
  QString s = QFileDialog::getOpenFileName(
                    homedir.filePath("*.hfd"),
                    tr("HFM9/NWT Kurvendatei (*.hfd)"),
                    this, 0, tr("HFM9/NWT Kurve laden"));
  //String ist nicht leer
  if (!s.isNull())
  {
    //Filename setzen
    f.setName(s);
    if(f.open( IO_ReadOnly )){
      QTextStream ts(&f);
      ts >> w.anfangsfrequenz;
//      editanfang->setText(s.sprintf("%ld",wobbeldaten1.anfangsfrequenz));
      ts >> w.schrittfrequenz;
//      editschrittweite->setText(s.sprintf("%ld",wobbeldaten1.schrittfrequenz));
      ts >> w.schritte;
//      editschritte->setText(s.sprintf("%d",wobbeldaten1.schritte));
//      editende->setText(s.sprintf("%d",wobbeldaten1.anfangsfrequenz+(wobbeldaten1.schritte * wobbeldaten1.schrittfrequenz)));
//      wobnormalisieren(); //Abgleich aller Eingabedaten
      ts >> w.faktor1;
      ts >> w.shift1;
      ts >> w.faktor2;
      ts >> w.shift2;
      ts >> i;
      switch(i){
        case 0:
          w.ebetriebsart = ewobbeln;
          w.linear1 = false;
          w.linear2 = false;
          break;
        case 1:  
          w.ebetriebsart = eswrneu;
          break;
        case 2:  
          w.ebetriebsart = ewobbeln;
          w.linear1 = true;
          w.linear2 = true;
          break;
        case 3:  
          w.ebetriebsart = eswrant;
          break;
        case 4:  
          w.ebetriebsart = eimpedanz;
          break;
      }
      for(i=0; i<w.schritte; i++){
        ts >> w.kanal1[i];
      }
      for(i=0; i<w.schritte; i++){
        ts >> w.kanal2[i];
      }
      f.close();
      w.daten_enable = true;
      w.bkanal1 = true;
      switch(nr){
        case 1:
          s = "Kurve 1: " +s;
          labelkanal1->setText(s);
          checkboxk11->setEnabled(true);
          checkboxk12->setEnabled(true);
          aktiv1->setEnabled(true);
          save1->setEnabled(true);
          w.penkanal1 = wobbeldaten1.penkanal1;
          w.penkanal2 = wobbeldaten1.penkanal2;
          wobbeldaten1 = w;
          break;
        case 2:
          s = "Kurve 2: " +s;
          labelkanal2->setText(s);
          checkboxk21->setEnabled(true);
          checkboxk22->setEnabled(true);
          aktiv2->setEnabled(true);
          save2->setEnabled(true);
          w.penkanal1 = wobbeldaten2.penkanal1;
          w.penkanal2 = wobbeldaten2.penkanal2;
          wobbeldaten2 = w;
          break;
        case 3:
          s = "Kurve 3: " +s;
          labelkanal3->setText(s);
          checkboxk31->setEnabled(true);
          checkboxk32->setEnabled(true);
          aktiv3->setEnabled(true);
          save3->setEnabled(true);
          w.penkanal1 = wobbeldaten3.penkanal1;
          w.penkanal2 = wobbeldaten3.penkanal2;
          wobbeldaten3 = w;
          break;
        case 4:
          s = "Kurve 4: " +s;
          labelkanal4->setText(s);
          checkboxk41->setEnabled(true);
          checkboxk42->setEnabled(true);
          aktiv4->setEnabled(true);
          save4->setEnabled(true);
          w.penkanal1 = wobbeldaten4.penkanal1;
          w.penkanal2 = wobbeldaten4.penkanal2;
          wobbeldaten4 = w;
          break;
      }
    }
  }
}

void owkmanager::sopen1()
{
  open(1);
};

void owkmanager::sopen2()
{
  open(2);
};

void owkmanager::sopen3()
{
  open(3);
};

void owkmanager::sopen4()
{
  open(4);
};

void owkmanager::ssave1()
{
  save(1);
};

void owkmanager::ssave2()
{
  save(2);
};

void owkmanager::ssave3()
{
  save(3);
};

void owkmanager::ssave4()
{
  save(4);
};

void owkmanager::sholen1()
{
  emit wkmgetwobbel1();
};

void owkmanager::sholen2()
{
  emit wkmgetwobbel2();
};

void owkmanager::sholen3()
{
  emit wkmgetwobbel3();
};

void owkmanager::sholen4()
{
  emit wkmgetwobbel4();
};

void owkmanager::scolor11()
{
  bool ok;
  QColor color = wobbeldaten1.penkanal1.color();
  QRgb rgb;
  rgb = color.rgb();
  qDebug("scolor11");
  color = QColorDialog::getRgba(rgb, &ok, this);
  if(ok){
    wobbeldaten1.penkanal1.setColor(color);
    QPalette palette = color11->palette();
    palette.setColor(QPalette::ButtonText, color);
    color11->setPalette(palette);
  }
  saktiv1();
};

void owkmanager::scolor12()
{
  bool ok;
  QColor color = wobbeldaten1.penkanal2.color();
  QRgb rgb;
  rgb = color.rgb();
  qDebug("scolor12");
  color = QColorDialog::getRgba(rgb, &ok, this);
  if(ok){
    wobbeldaten1.penkanal2.setColor(color);
    QPalette palette = color12->palette();
    palette.setColor(QPalette::ButtonText, color);
    color12->setPalette(palette);
  }
  saktiv1();
};

void owkmanager::scolor21()
{
  bool ok;
  QColor color = wobbeldaten2.penkanal1.color();
  QRgb rgb;
  rgb = color.rgb();
  qDebug("scolor21");
  color = QColorDialog::getRgba(rgb, &ok, this);
  if(ok){
    wobbeldaten2.penkanal1.setColor(color);
    QPalette palette = color21->palette();
    palette.setColor(QPalette::ButtonText, color);
    color21->setPalette(palette);
  }
};

void owkmanager::scolor22()
{
  bool ok;
  QColor color = wobbeldaten2.penkanal2.color();
  QRgb rgb;
  rgb = color.rgb();
  qDebug("scolor22");
  color = QColorDialog::getRgba(rgb, &ok, this);
  if(ok){
    wobbeldaten2.penkanal2.setColor(color);
    QPalette palette = color22->palette();
    palette.setColor(QPalette::ButtonText, color);
    color22->setPalette(palette);
  }
};

void owkmanager::scolor31()
{
  bool ok;
  QColor color = wobbeldaten3.penkanal1.color();
  QRgb rgb;
  rgb = color.rgb();
  qDebug("scolor31");
  color = QColorDialog::getRgba(rgb, &ok, this);
  if(ok){
    wobbeldaten3.penkanal1.setColor(color);
    QPalette palette = color31->palette();
    palette.setColor(QPalette::ButtonText, color);
    color31->setPalette(palette);
  }
};

void owkmanager::scolor32()
{
  bool ok;
  QColor color = wobbeldaten3.penkanal2.color();
  QRgb rgb;
  rgb = color.rgb();
  qDebug("scolor32");
  color = QColorDialog::getRgba(rgb, &ok, this);
  if(ok){
    wobbeldaten3.penkanal2.setColor(color);
    QPalette palette = color32->palette();
    palette.setColor(QPalette::ButtonText, color);
    color32->setPalette(palette);
  }
};

void owkmanager::scolor41()
{
  bool ok;
  QColor color = wobbeldaten4.penkanal1.color();
  QRgb rgb;
  rgb = color.rgb();
  qDebug("scolor41");
  color = QColorDialog::getRgba(rgb, &ok, this);
  if(ok){
    wobbeldaten4.penkanal1.setColor(color);
    QPalette palette = color41->palette();
    palette.setColor(QPalette::ButtonText, color);
    color41->setPalette(palette);
  }
};

void owkmanager::scolor42()
{
  bool ok;
  QColor color = wobbeldaten4.penkanal2.color();
  QRgb rgb;
  rgb = color.rgb();
  qDebug("scolor42");
  color = QColorDialog::getRgba(rgb, &ok, this);
  if(ok){
    wobbeldaten4.penkanal2.setColor(color);
    QPalette palette = color42->palette();
    palette.setColor(QPalette::ButtonText, color);
    color42->setPalette(palette);
  }
};

void owkmanager::saktiv1()
{
  if(aktiv1->isChecked()){
    wobbeldaten1.daten_enable = true;
  }else{
    wobbeldaten1.daten_enable = false;
  }
  wobbeldaten1.bhintergrund = true;
  emit wkmsendwobbel1(wobbeldaten1);
};

void owkmanager::saktiv2()
{
  if(aktiv2->isChecked()){
    wobbeldaten2.daten_enable = true;
    wobbeldaten2.bhintergrund = true;
  }else{
    wobbeldaten2.daten_enable = false;
    wobbeldaten2.bhintergrund = false;
  }
  emit wkmsendwobbel2(wobbeldaten2);
};

void owkmanager::saktiv3()
{
  if(aktiv3->isChecked()){
    wobbeldaten3.daten_enable = true;
    wobbeldaten3.bhintergrund = true;
  }else{
    wobbeldaten3.daten_enable = false;
    wobbeldaten3.bhintergrund = false;
  }
  emit wkmsendwobbel3(wobbeldaten3);
};

void owkmanager::saktiv4()
{
  if(aktiv4->isChecked()){
    wobbeldaten4.daten_enable = true;
    wobbeldaten4.bhintergrund = true;
  }else{
    wobbeldaten4.daten_enable = false;
    wobbeldaten4.bhintergrund = false;
  }
  emit wkmsendwobbel4(wobbeldaten4);
};

void owkmanager::suebergabe1(OWobbel awobbel)
{
  QString s;
  QDateTime zeit(QDateTime::currentDateTime());
  
//  zeit.setDate();
//  zeit.setTime(QTime::currentTime());
  s = "Kurve 1: " + zeit.toString("dd.MM.yyyy hh:mm:ss");
  //Farbeinstellungen beibehalten
  QPen pen1(wobbeldaten1.penkanal1);
  QPen pen2(wobbeldaten1.penkanal2);
  wobbeldaten1 = awobbel;
  wobbeldaten1.penkanal1 = pen1;
  wobbeldaten1.penkanal2 = pen2;
  labelkanal1->setText(s);
  checkboxk11->setEnabled(true);
  checkboxk12->setEnabled(true);
  aktiv1->setEnabled(true);
  save1->setEnabled(true);
  checkboxk11->setChecked(wobbeldaten1.bkanal1);
  checkboxk12->setChecked(wobbeldaten1.bkanal2);
  saktiv1();
};

void owkmanager::suebergabe2(OWobbel awobbel)
{
  QString s;
  QDateTime zeit(QDateTime::currentDateTime());
  
//  zeit.setDate();
//  zeit.setTime(QTime::currentTime());
  s = "Kurve 2: " + zeit.toString("dd.MM.yyyy hh:mm:ss");
  //Farbeinstellungen beibehalten
  QPen pen1(wobbeldaten2.penkanal1);
  QPen pen2(wobbeldaten2.penkanal2);
  wobbeldaten2 = awobbel;
  wobbeldaten2.penkanal1 = pen1;
  wobbeldaten2.penkanal2 = pen2;
  labelkanal2->setText(s);
  checkboxk21->setEnabled(true);
  checkboxk22->setEnabled(true);
  aktiv2->setEnabled(true);
  save2->setEnabled(true);
  checkboxk21->setChecked(wobbeldaten2.bkanal1);
  checkboxk22->setChecked(wobbeldaten2.bkanal2);
  saktiv2();
};

void owkmanager::suebergabe3(OWobbel awobbel)
{
  QString s;
  QDateTime zeit(QDateTime::currentDateTime());
  
//  zeit.setDate();
//  zeit.setTime(QTime::currentTime());
  s = "Kurve 3: " + zeit.toString("dd.MM.yyyy hh:mm:ss");
  //Farbeinstellungen beibehalten
  QPen pen1(wobbeldaten3.penkanal1);
  QPen pen2(wobbeldaten3.penkanal2);
  wobbeldaten3 = awobbel;
  wobbeldaten3.penkanal1 = pen1;
  wobbeldaten3.penkanal2 = pen2;
  labelkanal3->setText(s);
  checkboxk31->setEnabled(true);
  checkboxk32->setEnabled(true);
  aktiv3->setEnabled(true);
  save3->setEnabled(true);
  checkboxk31->setChecked(wobbeldaten3.bkanal1);
  checkboxk32->setChecked(wobbeldaten3.bkanal2);
  saktiv3();
};

void owkmanager::suebergabe4(OWobbel awobbel)
{
  QString s;
  QDateTime zeit(QDateTime::currentDateTime());
  
//  zeit.setDate();
//  zeit.setTime(QTime::currentTime());
  s = "Kurve 4: " + zeit.toString("dd.MM.yyyy hh:mm:ss");
  //Farbeinstellungen beibehalten
  QPen pen1(wobbeldaten4.penkanal1);
  QPen pen2(wobbeldaten4.penkanal2);
  wobbeldaten4 = awobbel;
  wobbeldaten4.penkanal1 = pen1;
  wobbeldaten4.penkanal2 = pen2;
  labelkanal4->setText(s);
  checkboxk41->setEnabled(true);
  checkboxk42->setEnabled(true);
  aktiv4->setEnabled(true);
  save4->setEnabled(true);
  checkboxk41->setChecked(wobbeldaten4.bkanal1);
  checkboxk42->setChecked(wobbeldaten4.bkanal2);
  saktiv4();
};

void owkmanager::saktivk11()
{
  wobbeldaten1.bkanal1 = checkboxk11->isChecked();
  saktiv1();
}

void owkmanager::saktivk12()
{
  wobbeldaten1.bkanal2 = checkboxk12->isChecked();
  saktiv1();
}

void owkmanager::saktivk21()
{
  wobbeldaten2.bkanal1 = checkboxk21->isChecked();
  saktiv2();
}

void owkmanager::saktivk22()
{
  wobbeldaten2.bkanal2 = checkboxk22->isChecked();
  saktiv2();
}

void owkmanager::saktivk31()
{
  wobbeldaten3.bkanal1 = checkboxk31->isChecked();
  saktiv3();
}

void owkmanager::saktivk32()
{
  wobbeldaten3.bkanal2 = checkboxk32->isChecked();
  saktiv3();
}

void owkmanager::saktivk41()
{
  wobbeldaten4.bkanal1 = checkboxk41->isChecked();
  saktiv4();
}

void owkmanager::saktivk42()
{
  wobbeldaten4.bkanal2 = checkboxk42->isChecked();
  saktiv4();
}

