/***************************************************************************
                          widgetwobbeln.h  -  description
                             -------------------
    begin                : 15.Mai.2007
    copyright            : (C) 2003 by Andreas Lindenau
    email                : DL4JAL@darc.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef WIDGETWOBBWELN_H
#define WIDGETWOBBWELN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QWidget>
#include <QPainter>
#include <QPixmap>
#include <QString>
#include <QLineEdit>
#include <QObject>
#include <QPrinter>
#include <Q3StrList>
#include <Q3PaintDeviceMetrics>
#include <Q3PopupMenu>
#include <QMouseEvent>

#include "fmarkedlg.h"

const int maxmesspunkte=9999;
const double ydisplayteilung=10.0;

enum enumbetriebsart {ewobbeln, eswrneu, eswrant, eimpedanz};

typedef struct {
}OKursor;

typedef struct {
  unsigned int kanal1[maxmesspunkte], //Anzahl der Messpunkte Kanal 1
               kanal2[maxmesspunkte]; //Anzahl der Messpunkte Kanal 2
  double absanfang;    //Anfangsfrequenz im Wobbelfenster
  double absende;      //Endfrequenz im Wobbelfenster
  long anfangsfrequenz;//Anfangsfrequenz der Kurve
  long schrittfrequenz;//Frequenzsprung
  int schritte;        //Anzahl der Messpunkte
  double faktor1;      //Korrektur Kurvensteilheit
  double shift1;       //Kanal 1
  double faktor2;      //Korrektur Kurvensteilheit
  double shift2;       //Kanal 2
  bool bkanal1;        //Kanal1 darstellen
  bool bkanal2;        //Kanal2 darstellen
  bool daten_enable;   //gueltige Daten in Kanal 1+2
  bool linear1;        //ob linear AD8361 Kanal 1
  bool linear2;        //ob linear AD8361 Kanal 2
  bool bandbreite3db;  //Bandbreiteninformation 3db abfall
  bool bandbreite6db;  //Bandbreiteninformation 6db abfall
  bool bandbreitegrafik;//Bandbreitengrafik
  QString namesonde1,  //Bezeichnung der messsonde
          namesonde2;
  double mfaktor1;     //Korrektur Sonde als Wattmeter Faktor Sonde1
  double mshift1;      //Korrektur Sonde als Wattmeter Shift Sonde1
  double mfaktor2;     //Korrektur Sonde als Wattmeter Faktor Sonde2
  double mshift2;      //Korrektur Sonde als Wattmeter Shift Sonde2
  double dbshift1;     //Korrektur der Wobbelkurve an 0db
  double dbshift2;     //Korrektur der Wobbelkurve an 0db
  bool beichkorrk1;    //Eichkorrektur Kanal 1
  bool beichkorrk2;    //Eichkorrektur Kanal 2
  bool einkanalig;     //HFM9 original verwendet nur einen Kanal
  enumbetriebsart ebetriebsart;	//Betriebsart
  bool beichswrk1;     //Eichlinie fuer SWR neu
  bool beichswrk2;     //Eichlinie fuer SWR neu
  int aufloesung;      //Aufloesung erstmal nur im SWR fenster
  bool bswriteration;  //math. Korrektur der SWR-Kurve
  double a_100;        //Kabeldaempfung auf 100m
  double kabellaenge;  //Kabellaenge
  bool mousesperre;    //sperren der Mouseaktivitaet
  QPen penkanal1;      //Stift fuer Kanal 1
  QPen penkanal2;      //Stift fuer Kanal 2
  bool bhintergrund;   //ob Hintergrund oder nicht
}OWobbel;

const int eindex=maxmesspunkte;
const double eteiler=20000.0;

typedef struct{
  double arrayk1[eindex];
  double arrayk2[eindex];
} teicharray; 

typedef struct{
  double arrayk1[eindex];
  double arrayk2[eindex];
} tswreicharray; 
  
class WidgetWobbeln : public QWidget
{
  Q_OBJECT
  public:
    /** construtor */
  WidgetWobbeln(QWidget* parent=0);
    /** destructor */
  ~WidgetWobbeln();
  Q3PopupMenu *menmouse;

  void setWobbeldaten(OWobbel);    
  OWobbel getWobbeldaten();
  double geteichwertk1(double afrequenz);
  double geteichwertk2(double afrequenz);
  double getswreichwertk1(double afrequenz);
  double getswreichwertk2(double afrequenz);
  
  public slots:
  void setWKursorNr(int);

  protected:
  virtual void paintEvent(QPaintEvent*);
  virtual void resizeEvent(QResizeEvent*);
  virtual void mouseMoveEvent(QMouseEvent *e);
  virtual void mousePressEvent(QMouseEvent *e);

  private:
  QPixmap pix, pix1;
  OWobbel wobbeldaten;
  OWobbel *kurve1;
  OWobbel *kurve2;
  OWobbel *kurve3;
  OWobbel *kurve4;
  double dbreitealt;
  double dbreite;
  int ObererRand;
  int LinkerRand;
  int mouseposx[5];
  int mouseposx1[5];
  int mouseposy[5];
  int kxm1[5];
  int kxm2[5];
  int kursorix;
  bool bnomove;
  teicharray weicharray;
  tswreicharray wswreicharray;
  bool banfang;
  bool bende;
  bool blupeplus;
  bool blupeminus;
  double mousefrequenz;
  tfmarken wfmarken;
  int hoehe;  //Hoehe der Wobbeldarstellung
  int breite; //Breite der wobbeldarstellung
  int yswrteilung; //SWV Anzeige Aufloesung
  double yaufloesung; //ADC Aufloesung
  double xSchritt; //Schrittweite Y 
  double ySchritt; //Schrittweite X
  double xAnfang; //absoluter Anfang normal bei 0.0
  double xEnde; //absolutes Ende normal Wobbelfensterbreite
  bool bresize;
   
  private slots:
  void wobbeldatenempfang(OWobbel);
  void wobbeldatenkurve(OWobbel);
  void printdiagramm(QFont, Q3StrList);
  void printdiagrammpdf(QFont, Q3StrList);
  void resetmousecursor();
  void empfangeichdaten(teicharray);
  void empfangfrqmarken(tfmarken);
  void kursor_loeschen();
  void alle_kursor_loeschen();
  
  void funktiontest2();
  void funktiontest3();
  void kabellaenge();
  void kabeldaten();
  void empfangswreichdaten(tswreicharray);
  void drawBeschriftung(QPainter *p);
  void drawKurve(QPainter *p);
  void refreshPixmap();
  void refreshKurve();
  void setParameterPixmap();
  void setKurve1(OWobbel);
  void setKurve2(OWobbel);
  void setKurve3(OWobbel);
  void setKurve4(OWobbel);

  signals:
  void multieditloeschen();
  void multieditinsert(QString);
  void writeywert(int);
  void writeanfang(double);
  void writeende(double);
  void setKursorFrequenz(double);
  void resetKursor(int);

};

#endif
