/***************************************************************************
                          widgetwobbeln.cpp  -  description
                             -------------------
    begin                : Son Aug 10 2003
    copyright            : (C) 2003 by Andreas Lindenau
    email                : DL4JAL@darc.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <math.h>
#include <stdlib.h>
#include <QDateTime>
#include <QCursor>
#include <QFileDialog>
#include <QLocale>
#include <QtGlobal>
//#include <QPaintDeviceMetrics>
#include <QMessageBox>
#include <QInputDialog>
#include <QStylePainter>

#include "widgetwobbeln.h"

//#define LDEBUG

WidgetWobbeln::WidgetWobbeln(QWidget *parent) : QWidget(parent)
{
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::WidgetWobbeln()");
  #endif
  //  setBackgroundMode( NoBackground );
  pix = QPixmap(size());
  pix1 = QPixmap(size());
  ObererRand= 35;
  LinkerRand= 35;
  kursorix = 0;
  
  int i;
  for(i=0; i<=5; i++){
    mouseposx[kursorix] = 0;
    mouseposx1[kursorix] = 0;
    mouseposy[kursorix] = 0;
  }
  
  banfang = false;
  bende = false;
  blupeplus = false;
  blupeminus = false;
  mousefrequenz = 0.0;
  menmouse = new Q3PopupMenu(this);
  menmouse->insertItem("Kursor # loeschen", this, SLOT(kursor_loeschen()));
  menmouse->insertItem("Alle Kursor loeschen", this, SLOT(alle_kursor_loeschen()));
  menmouse->insertSeparator();
  menmouse->insertItem("Frequenzanfang", this, SLOT(funktiontest2()));
  menmouse->insertItem("Frequenzende", this, SLOT(funktiontest3()));
  menmouse->insertSeparator();
  menmouse->insertItem("Ermitteln der geometrischen Kabellaenge", this, SLOT(kabellaenge()));
  menmouse->insertItem("Bestimmung der elektrischen Daten des Kabels", this, SLOT(kabeldaten()));
  setBackgroundRole(QPalette::Dark);
  setAutoFillBackground(true);
  setCursor(Qt::CrossCursor);
  kurve1 = NULL;
  kurve2 = NULL;
  kurve3 = NULL;
  kurve4 = NULL;
  wobbeldaten.bhintergrund = false;
  bresize = true;
}

WidgetWobbeln::~WidgetWobbeln()
{
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::~WidgetWobbeln()");
  #endif
  if(kurve1 != NULL) delete kurve1;
  if(kurve2 != NULL) delete kurve2;
  if(kurve3 != NULL) delete kurve3;
  if(kurve4 != NULL) delete kurve4;
}

void WidgetWobbeln::setKurve1(OWobbel akurve1){
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::setKurve1()");
  #endif
  if(kurve1 == NULL)kurve1 = new OWobbel;
  *kurve1 = akurve1;
  kurve1->absanfang = wobbeldaten.absanfang;
  kurve1->absende = wobbeldaten.absende;
  refreshPixmap();
  repaint();
}

void WidgetWobbeln::setKurve2(OWobbel akurve2){
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::setKurve2()");
  #endif
  if(kurve2 == NULL)kurve2 = new OWobbel;
  *kurve2 = akurve2;
  kurve2->absanfang = wobbeldaten.absanfang;
  kurve2->absende = wobbeldaten.absende;
  refreshPixmap();
  repaint();
}

void WidgetWobbeln::setKurve3(OWobbel akurve3){
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::setKurve3()");
  #endif
  if(kurve3 == NULL)kurve3 = new OWobbel;
  *kurve3 = akurve3;
  kurve3->absanfang = wobbeldaten.absanfang;
  kurve3->absende = wobbeldaten.absende;
  refreshPixmap();
  repaint();
}

void WidgetWobbeln::setKurve4(OWobbel akurve4){
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::setKurve4()");
  #endif
  if(kurve4 == NULL)kurve4 = new OWobbel;
  *kurve4 = akurve4;
  kurve4->absanfang = wobbeldaten.absanfang;
  kurve4->absende = wobbeldaten.absende;
  refreshPixmap();
  repaint();
}

//Die Kursornummer kommt vom Hauptfenster
void WidgetWobbeln::setWKursorNr(int a){
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::setKursorNr()");
  #endif
  kursorix = 4 -a;
  refreshKurve();
}

void WidgetWobbeln::kabeldaten()
{
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::kabeldaten()");
  #endif
  QString beschr("<b>Ermittlung der Kabeldaten</b><br>"
                 "1. Das Kabelende offen lassen und einen Serienwiderstand<br>"
                 "   von 50 Ohm zwischen SWV-Bruecke und Seele des Kabels<br>"
                 "   einfuegen<br>"
                 "2. Der Kursor wird auf die unterste Resonanzfrequenz gesetzt"
                 "<BR><BR>"
                 "Gemessene Laenge des Kabels (m):");
  QString qs;
  double v, e;
  bool ok;
  double l = QInputDialog::getDouble(this, tr("Kabellaenge"),
                                           beschr, 0.0, 0, 10000, 3, &ok); 
  if(ok){
    v = 0.0133 * l * (mousefrequenz / 1000000.0);
    e = 1 / (v * v);
    qs.sprintf("<B>Errechnung der Kabeldaten</B><BR>"
               "Verkuerzungsfaktor: %1.3f<BR>Dielektrizitaetszahl: %1.3f", v, e);
    QMessageBox::warning( this, tr("Kabledaten"), qs);
  }
}


void WidgetWobbeln::kabellaenge()
{
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::kabellaenge()");
  #endif
  QString beschr("<b>Ermittlung der Kabellaenge</b><br>"
                 "Es gibt 2 Moeglichkeiten:<br>"
                 "1. Das Kabelende offen lassen und einen Serienwiderstand<br>"
                 "   von 50 Ohm zwischen SWV-Bruecke und Seele des Kabels<br>"
                 "   einfuegen<br>"
                 "2. Das Kabelende kurzschliessen und am Ausgang der SWV-<br>"
                 "   Bruecke 50 Ohm zwischen Seele und Masse des Kabels<br>"
                 "   schalten.<br><BR>"
                 "Nach Auswahl und entsprechender Beschaltung messen Sie das SWV<br> "
                 "von 0,1 bis 160 MHz und setzen dann den Cursor auf die unterste<br> "
                 "Resonanzfrequenz. Bei groesseren Kabellaengen ist es erforderlich<br> "
                 "die Endfrequenz zu verringern um genaue Messergebnisse zu erhalten"
                 "<br><br>"
                 "Verkuerzungsfaktor des Kabels (Vorgabe = PE-Kabel):");
  QString qs;
  double er;
  bool ok;
  double v = QInputDialog::getDouble(this, tr("Verkuerzungsfaktor"),
                                           beschr, 0.67, -10000, 10000, 3, &ok); 
  if(ok){
    er = v / (mousefrequenz / 1000000.0) * 75.0;
    qs.sprintf("<B>Errechnung der Kabellaenge</B><BR>"
               "Geometrische Laenge des Kabels: %1.3f m", er);
    QMessageBox::warning( this, tr("Geometrische Laenge"), qs);
  }
}

void WidgetWobbeln::kursor_loeschen()
{
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::kursor_loeschen()");
  #endif
  resetmousecursor();
//  menmouse->hide();
}

void WidgetWobbeln::alle_kursor_loeschen()
{
  int k;
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::alle_kursor_loeschen()");
  #endif
  for(k=0;k<5;k++){
    kursorix = k;
    resetmousecursor();
  }  
  menmouse->hide();
  setWKursorNr(4);
  emit resetKursor(4);
}

void WidgetWobbeln::funktiontest2()
{
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::funktionstest2()");
  #endif
  banfang = true;
  menmouse->hide();
}

void WidgetWobbeln::funktiontest3()
{
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::funktionstest3()");
  #endif
  bende = true;
  menmouse->hide();
}

void WidgetWobbeln::mouseMoveEvent(QMouseEvent * e)
{
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::mouseMoveEvent()");
  #endif
  if(wobbeldaten.daten_enable){
    mouseposx[kursorix] = e->x();
    mouseposy[kursorix] = e->y();
    if(!wobbeldaten.mousesperre){
      refreshPixmap();
      repaint();
    }
  }
}

void WidgetWobbeln::mousePressEvent(QMouseEvent * e)
{
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::mousePressEvent()");
  #endif
  bnomove = false;
  if(wobbeldaten.daten_enable){
    if(e->button() == Qt::LeftButton){
      mouseposx[kursorix] = e->x();
      mouseposy[kursorix] = e->y();
      bnomove = true;
    }
    if(e->button() == Qt::RightButton){
      if(mouseposx[kursorix] != 0){
        menmouse->exec(QCursor::pos());
      }
    }
    if(!wobbeldaten.mousesperre){
      refreshPixmap();
      repaint();
    }
  }
}

void WidgetWobbeln::resetmousecursor()
{
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::resetmousecursor()");
  #endif
  mouseposx[kursorix] = 0;
  mouseposy[kursorix] = 0;
  if(!wobbeldaten.mousesperre){
    refreshPixmap();
    repaint();
  }
}

double WidgetWobbeln::geteichwertk1(double afrequenz)
{
  double j;
  int i;
  
  #ifdef LDEBUG
//    qDebug("WidgetWobbeln::geteichwertk1()");
  #endif
  if(wobbeldaten.beichkorrk1)
  {
    j = round(afrequenz / eteiler);
    i = int(j);
    if(i > (eindex - 1))i = eindex - 1;
    return weicharray.arrayk1[i];
  }else
  {
    return 0.0;
  }
}

double WidgetWobbeln::geteichwertk2(double afrequenz)
{
  double j;
  int i;
  
  #ifdef LDEBUG
//    qDebug("WidgetWobbeln::geteichwertk2()");
  #endif
  if(wobbeldaten.beichkorrk2)
  {
    j = round(afrequenz / eteiler);
    i = int(j);
    if(i > (eindex - 1))i = eindex - 1;
    return weicharray.arrayk2[i];
  }else
  {
    return 0.0;
  }
}

double WidgetWobbeln::getswreichwertk1(double afrequenz)
{
  double j;
  int i;
  double w1;
  
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::getswreichwertek1()");
  #endif
  j = round(afrequenz / eteiler);
  i = int(j);
  if(i > (eindex - 3))i = eindex - 3;
//  return wswreicharray.arrayk1[i];
  w1 = (wswreicharray.arrayk1[i-2] +
        wswreicharray.arrayk1[i-1] +  
        wswreicharray.arrayk1[i] +  
        wswreicharray.arrayk1[i+1] +  
	wswreicharray.arrayk1[i+2]) / 5.0;
  return (w1);
}

double WidgetWobbeln::getswreichwertk2(double afrequenz)
{
  double j;
  int i;
  
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::getswreichwertek2()");
  #endif
  j = round(afrequenz / eteiler);
  i = int(j);
  if(i > (eindex - 1))i = eindex - 1;
  return wswreicharray.arrayk2[i];
}

void WidgetWobbeln::setParameterPixmap()
{
  QSize pixsize;
  bool drawenable = false;

  #ifdef LDEBUG
    qDebug("WidgetWobbeln::setParameterPixmap()");
  #endif
  pixsize = this->rect().size();
  drawenable = (pixsize.width() > 0) and (pixsize.height() > 0);
  #ifdef LDEBUG
    qDebug("WidgetWobbeln::setParameterPixmap():w:%i h:%i",pixsize.width(), pixsize.height());
  #endif
  //loeschen des Pixmap
  if(drawenable){
    pix.resize(pixsize);
    QPainter p;
    p.begin(&pix);
    p.fillRect( this->rect(), Qt::white);
    p.end();
  }
}

void WidgetWobbeln::refreshKurve()
{
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::refreshKurve()");
  #endif
  QPainter p;
  //Beschriftetes Pixmap holen
  pix = pix1;
  p.begin(&pix);
  //und Kurve einzeichnen
  wobbeldaten.bhintergrund = false;
  drawKurve(&p);
  p.end();
  //und anzeigen
  update(); //paintEvent erzeugen
}

void WidgetWobbeln::refreshPixmap()
{
  OWobbel awobbeldaten;
  
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::refreshPixmap()");
  #endif
  //Groesse anpassen und Pixmap loeschen
  setParameterPixmap();
  QPainter p;
  p.begin(&pix);
  //Beschriftung erzeugen
  drawBeschriftung(&p);
  //Kurven in den hintergrund einblenden wenn alles OK ist
  if(kurve1 != NULL){
    awobbeldaten = wobbeldaten;
    wobbeldaten = *kurve1;
    drawKurve(&p);
    wobbeldaten = awobbeldaten;
  }
  if(kurve2 != NULL){
    awobbeldaten = wobbeldaten;
    wobbeldaten = *kurve2;
    drawKurve(&p);
    wobbeldaten = awobbeldaten;
  }
  if(kurve3 != NULL){
    awobbeldaten = wobbeldaten;
    wobbeldaten = *kurve3;
    drawKurve(&p);
    wobbeldaten = awobbeldaten;
  }
  if(kurve4 != NULL){
    awobbeldaten = wobbeldaten;
    wobbeldaten = *kurve4;
    drawKurve(&p);
    wobbeldaten = awobbeldaten;
  }
  //Beschriftetes Pixmap zusaetzlich abspeichern
  //bevor die Kurve gezeichnet wird
  pix1 = pix;
  //Kurve zeichen
  drawKurve(&p);
  p.end();
  //und anzeigen
  update();
}

void WidgetWobbeln::paintEvent(QPaintEvent*)
{
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::paintEvent()");
  #endif
  QPainter painter(this);
  //Beschriftung und Kurve ins Window kopieren
  //zeichen die Groesse hat sich geaendert
  painter.drawPixmap(0, 0, pix);
}

void WidgetWobbeln::resizeEvent(QResizeEvent*)
{
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::resizeEvent()");
  #endif
  // bei Paintevent noch einmal zeichen
  bresize = true;
  //Kurve neu zeichen
  refreshPixmap();
}

void WidgetWobbeln::drawBeschriftung(QPainter *p)
{
  int i=0;
  int xmodulo=2;
  int xshift;
  int x=0; 
  int x1=0; 
  double px1; 
  double px2; 
  double py1; 
  double wxanfang; 
  double wxende; 
  double wxbereich; 
  double xRaster=1.0; 
  double me=1.0; 
  QString xRasterStr, s;
  bool zeilenwechsel;

  #ifdef LDEBUG
  qDebug("WidgetWobbeln::drawBeschriftung()");
  #endif
  yaufloesung = 1024;
  yswrteilung = wobbeldaten.aufloesung;//Y-Teilung bei SWV
  breite = this->rect().width() - LinkerRand * 2;
//  qDebug("breite %i", breite);
  hoehe = this->rect().height() - ObererRand * 2;
  double zw1 = breite / (wobbeldaten.absende - wobbeldaten.absanfang);
  xSchritt = zw1 * (double)wobbeldaten.schrittfrequenz;
  xAnfang = zw1 * ((double)wobbeldaten.anfangsfrequenz - wobbeldaten.absanfang);
  ySchritt = double(hoehe) / yaufloesung;
  //###################################################################################
  // ANFANG Beschriftung des Y-Bereiches
  //###################################################################################
  p->setPen( QPen( Qt::black, 0, Qt::SolidLine));
  // Schrift setzen
  p->setFont( QFont("Sans", 9));
  px1 = LinkerRand;
  px2 = breite + LinkerRand;
  switch(wobbeldaten.ebetriebsart){
    case ewobbeln:
      if(!wobbeldaten.linear1 && !wobbeldaten.linear2){ // logaritmische Beschriftung
        py1 = hoehe / ydisplayteilung;
        if((wobbeldaten.dbshift1 == 0.0) and (wobbeldaten.dbshift2 == 0.0)){
          p->setPen( QPen( Qt::black, 0, Qt::SolidLine));
        }else{
          p->setPen( QPen( Qt::red, 0, Qt::SolidLine));
        }
        //bei log. Messkopf Messeinheit anzeigen  linker Rand rechtbuendig
        p->drawText(1, int(round(py1*0.5))+ ObererRand," dB");
        p->drawText(int(round(px2))+12, int(round(py1*0.5))+ ObererRand,"dB");
        for(i=0; i<(int(ydisplayteilung)+1); i++)
        {
          if((wobbeldaten.dbshift1 == 0.0) and (wobbeldaten.dbshift2 == 0.0)){
            p->setPen( QPen( Qt::black, 0, Qt::SolidLine));
          }else{
            p->setPen( QPen( Qt::red, 0, Qt::SolidLine));
          }
          //dB Zahlen generieren rechtsbuendig
          s.sprintf("%3i", ((i*10)*-1)+10);
          p->drawText(1, int(round(py1*i))+ ObererRand + 3,s);
          // nur bei log-Sonde beschriften
          //an den rechten Rand schreiben linksbuendig
          s.sprintf("%3i", ((i*10)*-1)+10);
          p->drawText(int(round(px2))+3, int(round(py1*i))+ ObererRand + 3,s);
          if(i == 1){
            p->setPen( QPen( Qt::black, 0, Qt::DotLine));
          }else{
            p->setPen( QPen( Qt::lightGray, 0, Qt::DotLine));
          }
          p->drawLine(int(round(px1)), int(round(py1*i))+ ObererRand,
                     int(round(px2)), int(round(py1*i))+ ObererRand);
        }
      }else{ //Linear Beschriftung
        py1 = hoehe / (ydisplayteilung + 1);
        for(i=0; i<(ydisplayteilung + 2); i++)
        {
          //lineare Beschriftung
          p->setPen( QPen( Qt::darkGreen, 0, Qt::SolidLine));
          p->drawText(1, int(round(py1*0.5)+ ObererRand + 3.0)," dB");
          double bx;
          bx = double((11 - i) * 0.1);
          bx = 20.0 * log10(bx);
          if(bx > -10.0){
            s.sprintf("%1.2f", bx);
          }else{
            s.sprintf("%1.1f", bx);
          }
          if(bx < -99.9){
            s = "UnEn";
          }  
          //an den linken Rand schreiben
          p->drawText(1, int(round(py1*i))+ ObererRand + 3,s);
          //lineare Beschriftung
          s.sprintf("%1.1f", double((11 - i) * 0.1));
          //an den rechten Rand schreiben
          p->setPen( QPen( Qt::black, 0, Qt::SolidLine));
          p->drawText(int(round(px2))+3, int(round(py1*i))+ ObererRand + 3,s);
          p->setPen( QPen( Qt::lightGray, 0, Qt::DotLine));
          p->drawLine(int(round(px1)), int(round(py1*i))+ ObererRand,
                     int(round(px2)), int(round(py1*i))+ ObererRand);
        }
      }
      break;
    case eswrneu:
    case eswrant:
      //2 kanalige SWV-Anzeige
      py1 = hoehe / double(yswrteilung*10);       //Einteilung Y
      p->setPen( QPen( Qt::black, 0, Qt::SolidLine));
      p->drawText(1, hoehe + ObererRand + 20,"SWV");
      //Messeinheit anzeigen  rechter Rand
      p->drawText(int(round(px2))+5, hoehe + ObererRand + 20,"SWV");
      if(yswrteilung > 6){
        xmodulo = 4;
      }else{
        xmodulo = 2;
      }
      if(yswrteilung > 8){
        xmodulo = 5;
      }
      for(i=0; i< (yswrteilung*10+1); i++)
      {
        //modulo 2
//        qDebug(((i+1) % xmodulo));
        if((i % xmodulo) == 0){
          //SWV Beschriftung aller 2 Teilungen Y-Achse
          s.sprintf("%1.1f", double(((yswrteilung*10 - i) * 0.1)) + 1.0);
          //an den linken Rand schreiben
          p->setPen( QPen( Qt::black, 0, Qt::SolidLine));
          p->drawText(1, int(round(py1*i))+ ObererRand + 3,s);
          //SWV Beschriftung
          s.sprintf("%1.1f", double(((yswrteilung*10 - i) * 0.1)) + 1.0);
          p->setPen( QPen( Qt::black, 0, Qt::SolidLine));
          p->drawText(int(round(px2))+3, int(round(py1*i))+ ObererRand + 3,s);
          p->setPen( QPen( Qt::lightGray, 0, Qt::DotLine));
          p->drawLine(int(round(px1)), int(round(py1*i))+ ObererRand,
                     int(round(px2)), int(round(py1*i))+ ObererRand);
        }
      }
      break;
    case eimpedanz:
      //2 kanalige SWV-Anzeige
      py1 = hoehe / 200.0;       //Einteilung Y
      p->setPen( QPen( Qt::black, 0, Qt::SolidLine));
      p->drawText(1, hoehe + ObererRand + 20,"Z(Ohm)");
      //Messeinheit anzeigen  rechter Rand
      p->drawText(int(round(px2))-15, hoehe + ObererRand + 20,"Z(Ohm)");
      for(i=0; i <= 200; i++)
      {
        //modulo 2
//        qDebug(((i+1) % xmodulo));
        if((i % 10) == 0){
          //Impedanz Beschriftung aller 10 Ohm an der Y-Achse
          s.sprintf("%i",  200 - i);
          //an den linken Rand schreiben
          p->setPen( QPen( Qt::black, 0, Qt::SolidLine));
          p->drawText(1, int(round(py1*i))+ ObererRand + 3,s);
          p->drawText(int(round(px2))+3, int(round(py1*i))+ ObererRand + 3,s);
          if(i == 150){
            p->setPen( QPen( Qt::black, 0, Qt::DotLine));
          }else{
            p->setPen( QPen( Qt::lightGray, 0, Qt::DotLine));
          }
          p->drawLine(int(round(px1)), int(round(py1*i))+ ObererRand,
                     int(round(px2)), int(round(py1*i))+ ObererRand);
        }
      }
      break;
  }    
  //###################################################################################
  // ENDE Beschriftung des Y-Bereiches
  //###################################################################################
  //###################################################################################
  // Anfang Beschriftung des X-Bereiches
  //###################################################################################
  //Festlegung der X-Achseneinteilung
  wxanfang = wobbeldaten.anfangsfrequenz;
  wxende = wxanfang + (wobbeldaten.schritte - 1) * wobbeldaten.schrittfrequenz;
  wxbereich = (wxende - wxanfang) / 5.0;
  if((wxbereich <= 2.5) & (wxbereich >1.0))xRaster = 1.0;
  if((wxbereich <= 5.0) & (wxbereich >2.5))xRaster = 2.5;
  if((wxbereich <= 10.0) & (wxbereich >5.0))xRaster = 5.0;
  if((wxbereich <= 25.0) & (wxbereich >10.0))xRaster = 10.0;
  if((wxbereich <= 50.0) & (wxbereich >25.0))xRaster = 25.0;
  if((wxbereich <= 100.0) & (wxbereich >50.0))xRaster = 50.0;
  if((wxbereich <= 250.0) & (wxbereich >100.0))xRaster = 100.0;
  if((wxbereich <= 500.0) & (wxbereich >250.0))xRaster = 250.0;
  if((wxbereich <= 1000.0) & (wxbereich >500.0))xRaster = 500.0;
  if((wxbereich <= 2500.0) & (wxbereich >1000.0))xRaster = 1000.0;
  if((wxbereich <= 5000.0) & (wxbereich >2500.0))xRaster = 2500.0;
  if((wxbereich <= 10000.0) & (wxbereich >5000.0))xRaster = 5000.0;
  if((wxbereich <= 25000.0) & (wxbereich >10000.0))xRaster = 10000.0;
  if((wxbereich <= 50000.0) & (wxbereich >25000.0))xRaster = 25000.0;
  if((wxbereich <= 100000.0) & (wxbereich >50000.0))xRaster = 50000.0;
  if((wxbereich <= 250000.0) & (wxbereich >100000.0))xRaster = 100000.0;
  if((wxbereich <= 500000.0) & (wxbereich >250000.0))xRaster = 250000.0;
  if((wxbereich <= 1000000.0) & (wxbereich >500000.0))xRaster = 500000.0;
  if((wxbereich <= 2500000.0) & (wxbereich >1000000.0))xRaster = 1000000.0;
  if((wxbereich <= 5000000.0) & (wxbereich >2500000.0))xRaster = 2500000.0;
  if((wxbereich <= 10000000.0) & (wxbereich >5000000.0))xRaster = 5000000.0;
  if((wxbereich <= 25000000.0) & (wxbereich >10000000.0))xRaster = 10000000.0;
  if((wxbereich <= 50000000.0) & (wxbereich >25000000.0))xRaster = 25000000.0;
  if((wxbereich <= 100000000.0) & (wxbereich >50000000.0))xRaster = 50000000.0;
  if((wxbereich <= 250000000.0) & (wxbereich >100000000.0))xRaster = 100000000.0;
  xRasterStr = "Hz";
  me = 1.0;
  if(wxende >= 1000.0){
    xRasterStr = "kHz";
    me = 1000.0;
  }  
  if(wxende >= 1000000.0){
    xRasterStr = "MHz";
    me = 1000000.0;
  } 
  //ganz linke Linie ziehen
  p->setPen( QPen( Qt::lightGray, 0, Qt::DotLine));
  p->drawLine(LinkerRand, ObererRand, LinkerRand, hoehe + ObererRand);
  //ganz rechts Linie ziehen
  p->drawLine(breite + LinkerRand, ObererRand, breite + LinkerRand, hoehe + ObererRand);
  p->setPen( QPen( Qt::black, 0, Qt::SolidLine));
  p->drawText(2, 13, xRasterStr);
  i = 1;
  if(xRaster < wxanfang)i = int(round( wxanfang / xRaster)) + 1;
  //Beschriftung x-Achse + Linien
  //erste Beschriftung oben
  zeilenwechsel = true;
  while( (xRaster * i) < wxende){
    x = int(round((((xRaster * i) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    //je nach laenge des Strings den Text etwas nach links schieben
    QLocale::setDefault(QLocale(QLocale::German, QLocale::Germany));
    xshift = 10;
    s.sprintf("%3.1f", xRaster*i/me);
    if((wxende - wxanfang) < 10000000.0){
      xshift = 30;
      s.sprintf("%3.3f", xRaster*i/me);
    }  
    if((wxende - wxanfang) < 100000.0){
      xshift = 45;
      s.sprintf("%3.6f", xRaster*i/me);
    }
    p->setPen( QPen( Qt::black, 0, Qt::SolidLine));
    if(zeilenwechsel){
      p->drawText(x-xshift, 28, s);
      zeilenwechsel = false;
    }else{  
      p->drawText(x-xshift, 13, s);
      zeilenwechsel = true;
    }
    p->setPen( QPen( Qt::lightGray, 0, Qt::DotLine));
    p->drawLine(x, ObererRand, x, hoehe + ObererRand);
    i++;
  }
  p->setPen( QPen( Qt::black, 0, Qt::SolidLine));
  xRasterStr = "Hz";
  if(xRaster >= 1000.0){
    xRaster /= 1000.0;
    xRasterStr = "kHz";
  }
  if(xRaster >= 1000.0){
    xRaster /= 1000.0;
    xRasterStr = "MHz";
  }
  s.sprintf("X-Raster: %1.1f ", xRaster);
  s += xRasterStr;
  p->drawText(int(px2/2.0)-50, hoehe + ObererRand + 20,s);
  if((wobbeldaten.dbshift1 != 0.0) or (wobbeldaten.dbshift2 != 0.0)){
    p->setPen( QPen( Qt::red, 0, Qt::SolidLine));
    s.sprintf("Shift aktiv");
    p->drawText(LinkerRand + 20, hoehe + ObererRand + 20,s);
    p->drawText(breite - 80, hoehe + ObererRand + 20,s);
  }
  //###################################################################################
  // ENDE Beschriftung des X-Bereiches
  //###################################################################################
  //###################################################################################
  // Frequenzmarken 
  //###################################################################################
  p->setPen( QPen( Qt::cyan, 0, Qt::SolidLine));
  if(wfmarken.b160m){
    x = int(round((((wfmarken.f1160m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f2160m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
      if((x1 - x) > 50){
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 , "160m");
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 + 15, "Band");
      }	
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  if(wfmarken.b80m){
    x = int(round((((wfmarken.f180m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f280m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
      if((x1 - x) > 50){
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 , "80m");
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 + 15, "Band");
      }	
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  if(wfmarken.b40m){
    x = int(round((((wfmarken.f140m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f240m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
      if((x1 - x) > 50){
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 , "40m");
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 + 15, "Band");
      }	
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  if(wfmarken.b30m){
    x = int(round((((wfmarken.f130m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f230m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
      if((x1 - x) > 50){
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 , "30m");
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 + 15, "Band");
      }	
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  if(wfmarken.b20m){
    x = int(round((((wfmarken.f120m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f220m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
      if((x1 - x) > 50){
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 , "20m");
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 + 15, "Band");
      }	
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  if(wfmarken.b17m){
    x = int(round((((wfmarken.f117m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f217m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
      if((x1 - x) > 50){
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 , "17m");
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 + 15, "Band");
      }	
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  if(wfmarken.b15m){
    x = int(round((((wfmarken.f115m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f215m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
      if((x1 - x) > 50){
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 , "15m");
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 + 15, "Band");
      }	
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  if(wfmarken.b12m){
    x = int(round((((wfmarken.f112m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f212m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
      if((x1 - x) > 50){
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 , "12m");
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 + 15, "Band");
      }	
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  if(wfmarken.b10m){
    x = int(round((((wfmarken.f110m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f210m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
      if((x1 - x) > 50){
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 , "10m");
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 + 15, "Band");
      }	
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  if(wfmarken.b6m){
    x = int(round((((wfmarken.f16m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f26m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
      if((x1 - x) > 50){
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 , "6m");
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 + 15, "Band");
      }	
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  if(wfmarken.b2m){
    x = int(round((((wfmarken.f12m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f22m) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
      if((x1 - x) > 50){
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 , "2m");
        p->drawText(x-20+(x1-x)/2, (hoehe + ObererRand)/2 + 15, "Band");
      }	
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  if(wfmarken.bu1){
    x = int(round((((wfmarken.f1u1) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f2u1) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  if(wfmarken.bu2){
    x = int(round((((wfmarken.f1u2) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f2u2) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  if(wfmarken.bu3){
    x = int(round((((wfmarken.f1u3) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    x1 = int(round((((wfmarken.f2u3) - wxanfang) / (wxende - wxanfang))* breite) - 1 + LinkerRand);
    if((x > LinkerRand)and(x < (breite+LinkerRand)))
      p->drawLine(x, ObererRand, x, hoehe + ObererRand);
    if((x1 > LinkerRand)and(x1 < (breite+LinkerRand)))
      p->drawLine(x1, ObererRand, x1, hoehe + ObererRand);
  }  
  //###################################################################################
  // Ende Frequenzmarken 
  //###################################################################################
}


void WidgetWobbeln::drawKurve(QPainter *p)
{
//Variablen

  int i,
  k,
  j1,
  j2,
  j3,
  x, 
  x1=0, 
  y=0, 
  y1=0,
  y3=0,
  y4=0,
  mx1[5]={0,0,0,0,0},
  mx2[5]={0,0,0,0,0},
  my1[5]={0,0,0,0,0},
  my2[5]={0,0,0,0,0},
  xm1[5]={0,0,0,0,0},
  xm2[5]={0,0,0,0,0},
  kx[5]={0,0,0,0,0},
  kx1[5]={0,0,0,0,0},
  kx2[5]={0,0,0,0,0},
  kx3[5]={0,0,0,0,0},
  ky1[5]={0,0,0,0,0},
  ky2[5]={0,0,0,0,0},
  kw1[5]={0,0,0,0,0},
  kw2[5]={0,0,0,0,0},
  kw3[5]={0,0,0,0,0},
  db3x1=0,
  db3x2=0,
  maxk1,
  maxk2,
  mink1,
  mink2,
  maxk1f=0,
  maxk2f=0,
  mink1f=0,
  mink2f=0;
  double db3xa, 
  db3xb,
  db3ya, 
  db3yb,
  bandbreite3db=0.0,
  bandbreite6db=0.0,
  px1=0.0,
  py1,
  py2, 
  y1faktor,
  y2faktor,
  y1shift,
  y2shift,
  minswr, //fuer SWV neu
  maxswr, //fuer SWV neu
  afrequenz=1000000.0,
  uricht=0.0,
  w1,
  w2,
  w3,
  swv=1.0,
  maxdbk1=-100.0,
  mindbk1=20.0,
  maxdbk2=-100.0,
  mindbk2=20.0;

  QString xRasterStr, s;

  double s_ant;
  double a;
  double r_tx;
  double r_ant;
  double a_100 = 1.0;
  double laenge = 10.0;
  double yzeichenfaktor = 0.0;
  double yzeichenshift = 0.0;
  double bx;
  bool bkurvezeichnen;
  bool bmouse = true;
          
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::drawKurve()");
  #endif
  a_100 = wobbeldaten.a_100;
  laenge = wobbeldaten.kabellaenge;
  
  double zw1 = breite / (wobbeldaten.absende - wobbeldaten.absanfang);
  xSchritt = zw1 * (double)wobbeldaten.schrittfrequenz;
  xAnfang = zw1 * ((double)wobbeldaten.anfangsfrequenz - wobbeldaten.absanfang);
//*************************************************************************************
//*************************************************************************************
//*************************************************************************************
//*************************************************************************************
  //###################################################################################
  // ANFANG ermitteln der max- und min-Werte
  //###################################################################################
  y1faktor = wobbeldaten.faktor1;
  y1shift = wobbeldaten.shift1;
  y2faktor = wobbeldaten.faktor2;
  y2shift = wobbeldaten.shift2;
  afrequenz = wobbeldaten.anfangsfrequenz;
  maxk1 = 0;
  maxk2 = 0;
  minswr = 99.9;
  maxswr = 1.0;
  //Messdaten mit 10bit laenge
  mink1 = 1023;
  mink2 = 1023;
  maxdbk1 = -100.0;
  mindbk1 = 20.0;
  maxdbk2 = -100.0;
  mindbk2 = 20.0;
  //###################################################################################
  // ANFANG Kurven darstellen
  //###################################################################################
  //Kurvenkorrektur laden
  if(wobbeldaten.daten_enable){
    //##########################################################
    // Alle Gemeinsamkeiten erledigen
    //##########################################################
    //alle Listen loeschen
    emit multieditloeschen();
    switch (wobbeldaten.ebetriebsart){
      case ewobbeln:
      //##########################################################
      // Betriebsart Wobbeln
      //##########################################################
      //##########################################################
      // Zuerst Kanal 1 
      //##########################################################
        afrequenz = wobbeldaten.anfangsfrequenz;
        yzeichenfaktor = (ySchritt / hoehe * ydisplayteilung * 10.0);
        yzeichenshift = (ydisplayteilung - 1.0) * 10.0;
        if(wobbeldaten.bkanal1){
          // Pen setzen
          p->setPen( wobbeldaten.penkanal1 );
          for(i=0; i < wobbeldaten.schritte - 1; i++){
            bkurvezeichnen = true;
            x = int(round(i * xSchritt) + LinkerRand) + (int)xAnfang;
            if( x < LinkerRand)bkurvezeichnen = false;
            if( x > (LinkerRand + breite))bkurvezeichnen = false;
            x1 = int(round((i+1) * xSchritt) + LinkerRand) + (int)xAnfang;
            if( x1 < LinkerRand)bkurvezeichnen = false;
            if( x1 > (LinkerRand + breite))bkurvezeichnen = false;
            py1 = (wobbeldaten.kanal1[i] * y1faktor + y1shift) + 
	                 geteichwertk1(afrequenz + wobbeldaten.schrittfrequenz * i);
            py2 = (wobbeldaten.kanal1[i+1] * y1faktor + y1shift) + 
	                 geteichwertk1(afrequenz + wobbeldaten.schrittfrequenz * (i+1));
//              py1 = ((ky1[kursorix] * y1faktor + y1shift + geteichwertk1(px1)) * ySchritt / 
//	              hoehe * (int(ydisplayteilung)*10)) - (int(ydisplayteilung)-1)*10;
//            qDebug("1. %f",py1);
            py1 = py1 * yzeichenfaktor;
            py2 = py2 * yzeichenfaktor;
//	    qDebug("2. %f",py1);
            py1 = py1 + wobbeldaten.dbshift1;
	          py2 = py2 + wobbeldaten.dbshift1;
//          qDebug("3. %f",py1);
            py1 = py1 / yzeichenfaktor;
            py2 = py2 / yzeichenfaktor;
//          qDebug("4. %f",py1);

//            py1 = 512.0;
//            py2 = 512.0;
            y = int(hoehe - round(py1 * ySchritt) + ObererRand);
            y1 = int(hoehe - round(py2 * ySchritt) + ObererRand);
            //auf extremwerte reagieren Linie soll Anzeige nicht nach oben verlassen
            if(y > (hoehe + ObererRand))y = hoehe + ObererRand;
            if(y < ObererRand)y = ObererRand;
            if(y1 > (hoehe + ObererRand))y1 = hoehe + ObererRand;
            if(y1 < ObererRand)y1 = ObererRand;
            //Linie zeichnen
	          if(bkurvezeichnen)p->drawLine(x, y, x1, y1);
            if(wobbeldaten.linear1){
              py1 = 1.1 * ((wobbeldaten.kanal1[i] * y1faktor + y1shift) * ySchritt / hoehe);
            } else {
              py1 = ((wobbeldaten.kanal1[i] * y1faktor + y1shift + 
                      geteichwertk1(afrequenz + wobbeldaten.schrittfrequenz * (i))) * yzeichenfaktor) - yzeichenshift; 
            }
            //maximum Kanal1 ermitteln
            if(py1 > maxdbk1){
              maxdbk1 = py1;
              maxk1f = i;//passende Frequenz dazu
            }
            //minimum Kanal1 ermitteln
            if(py1 < mindbk1){
              mindbk1 = py1;
              mink1f = i;//passende Frequenz dazu
            }
            if(wobbeldaten.linear1){
              py1 = 1.1 * ((wobbeldaten.kanal1[i+1] * y1faktor + y1shift) * ySchritt / hoehe);
            } else {
              py1 = ((wobbeldaten.kanal1[i+1] * y1faktor + y1shift + 
                      geteichwertk1(afrequenz + wobbeldaten.schrittfrequenz * (i+1))) * yzeichenfaktor) - yzeichenshift; 
            }
            //maximum Kanal1 ermitteln
            if(py1 > maxdbk1){
              maxdbk1 = py1;
              maxk1f = i;//passende Frequenz dazu
            }
            //minimum Kanal1 ermitteln
            if(py1 < mindbk1){
              mindbk1 = py1;
              mink1f = i;//passende Frequenz dazu
            }
            //Anfangswerte setzen
            for(k=0;k<5;k++){
              if(mouseposx1[k] != mouseposx[k]){
                if(i == 0){
                  xm1[k] = LinkerRand;
                  mx1[k] = x;
                  my1[k] = y;
                  kx[k] = i;
                  ky1[k] = wobbeldaten.kanal1[i];
                  kxm1[k] = kx[k];
                }
                //neue Werte setzen
                xm2[k] = abs(x - mouseposx[k]);
                if(xm2[k] < xm1[k]){
                  xm1[k] = xm2[k];
                  mx1[k] = x;
                  my1[k] = y;
                  kx[k] = i;
                  ky1[k] = wobbeldaten.kanal1[kx[k]];
                  kxm1[k] = kx[k];
                }
                xm2[k] = abs(x1 - mouseposx[k]);
                if(xm2[k] < xm1[k]){
                  xm1[k] = xm2[k];
                  mx1[k] = x1;
                  my1[k] = y1;
                  kx[k] = i + 1;
                  ky1[k] = wobbeldaten.kanal1[kx[k]];
                  kxm1[k] = kx[k];
                }
              }else{
                mx1[k] = int(round(kxm1[k] * xSchritt) + LinkerRand);
                py1 = (wobbeldaten.kanal1[kxm1[k]] * y1faktor + y1shift) + 
                      geteichwertk1(afrequenz + wobbeldaten.schrittfrequenz * kxm1[k]);
                py1 = py1 * yzeichenfaktor;
                py1 = py1 + wobbeldaten.dbshift1;
                py1 = py1 / yzeichenfaktor;
  //	      qDebug("Maus py1 %f",py1);
                my1[k] = int(hoehe - round(py1 * ySchritt) + ObererRand);
                if(my1[k] > (hoehe + ObererRand))my1[k] = hoehe + ObererRand;
                if(my1[k] < ObererRand)my1[k] = ObererRand;
              }
            }
          }
        }
//	qDebug("kx[kursorix] %i kxm %i mouseposx %i", kx[kursorix], kxm1, mouseposx);
        //##########################################################
        // Dann Kanal 2 
        //##########################################################
        if(wobbeldaten.bkanal2){
          // Stift gruen und durchgezogene Linie
          p->setPen( wobbeldaten.penkanal2);
          for(i=0; i < wobbeldaten.schritte - 1; i++){
            py1 = wobbeldaten.kanal2[i] * y2faktor + y2shift + 
                  geteichwertk2(afrequenz + wobbeldaten.schrittfrequenz * i);
            py2 = wobbeldaten.kanal2[i+1] * y2faktor + y2shift + 
                  geteichwertk2(afrequenz + wobbeldaten.schrittfrequenz * (i+1));
            
            py1 = py1 * yzeichenfaktor;
            py2 = py2 * yzeichenfaktor;
//          qDebug("2. %f",py1);
            py1 = py1 + wobbeldaten.dbshift2;
            py2 = py2 + wobbeldaten.dbshift2;
//          qDebug("3. %f",py1);
            py1 = py1 / yzeichenfaktor;
            py2 = py2 / yzeichenfaktor;
//          qDebug("4. %f",py1);

            y = int(hoehe - round(py1 * ySchritt)  + ObererRand);
            if(y > (hoehe + ObererRand))y = hoehe + ObererRand;
            if(y < ObererRand)y = ObererRand;
            y1 = int(hoehe - round(py2 * ySchritt)  + ObererRand);
            if(y1 > (hoehe + ObererRand))y1 = hoehe + ObererRand;
            if(y1 < ObererRand)y1 = ObererRand;
            
            bkurvezeichnen = true;
            x = int(round(i * xSchritt) + LinkerRand) + (int)xAnfang;
            if( x < LinkerRand)bkurvezeichnen = false;
            if( x > (LinkerRand + breite))bkurvezeichnen = false;
            x1 = int(round((i+1) * xSchritt) + LinkerRand) + (int)xAnfang;
            if( x1 < LinkerRand)bkurvezeichnen = false;
            if( x1 > (LinkerRand + breite))bkurvezeichnen = false;
            if(bkurvezeichnen)p->drawLine(x, y, x1, y1);
            if(wobbeldaten.linear2){
              py1 = 1.1 * ((wobbeldaten.kanal2[i] * y2faktor + y2shift) * ySchritt / hoehe);
            } else {
              py1 = ((wobbeldaten.kanal2[i] * y2faktor + y2shift + 
                      geteichwertk2(afrequenz + wobbeldaten.schrittfrequenz * i)) * yzeichenfaktor) - yzeichenshift;            
            }
            //maximum Kanal2 ermitteln
            if(py1 > maxdbk2){
              maxdbk2 = py1;
              maxk2f = i;//passende Frequenz dazu
            }
            //minimum Kanal2 ermitteln
            if(py1 < mindbk2){
              mindbk2 = py1;
              mink2f = i;//passende Frequenz dazu
            }
            if(wobbeldaten.linear2){
              py1 = 1.1 * ((wobbeldaten.kanal2[i+1] * y2faktor + y2shift) * ySchritt / hoehe);
            } else {
              py1 = ((wobbeldaten.kanal2[i+1] * y2faktor + y2shift + 
                      geteichwertk2(afrequenz + wobbeldaten.schrittfrequenz * (i+1))) * yzeichenfaktor) - yzeichenshift; 
            }
            //maximum Kanal2 ermitteln
            if(py1 > maxdbk2){
              maxdbk2 = py1;
              maxk2f = i+1;//passende Frequenz dazu
            }
            //minimum Kanal2 ermitteln
            if(py1 < mindbk2){
              mindbk2 = py1;
              mink2f = i+1;//passende Frequenz dazu
            }
            for(k=0;k<5;k++){
              if(mouseposx1[k] != mouseposx[k]){
                if(i == 0){
                  xm1[k] = LinkerRand;
                  mx2[k] = x;
                  my2[k] = y;
                  kx[k] = i;
                  ky2[k] = wobbeldaten.kanal2[i];
                  kxm2[k] = kx[k];
                }
                xm2[k] = abs(x - mouseposx[k]);
                if(xm2[k] < xm1[k]){
                  xm1[k] = xm2[k];
                  mx2[k] = x;
                  my2[k] = y;
                  kx[k] = i;
                  ky2[k] = wobbeldaten.kanal2[kx[k]];
                  kxm2[k] = kx[k];
                }
                xm2[k] = abs(x1 - mouseposx[k]);
                if(xm2[k] < xm1[k]){
                  xm1[k] = xm2[k];
                  mx2[k] = x1;
                  my2[k] = y1;
                  kx[k] = i + 1;
                  ky2[k] = wobbeldaten.kanal2[kx[k]];
                  kxm2[k] = kx[k];
                }
              }else{
                mx2[k] = int(round(kxm2[k] * xSchritt) + LinkerRand);
                py1 = (wobbeldaten.kanal2[kxm2[k]] * y2faktor + y2shift) + 
                      geteichwertk2(afrequenz + wobbeldaten.schrittfrequenz * kxm2[k]);
                py1 = py1 * yzeichenfaktor;
                py1 = py1 + wobbeldaten.dbshift2;
                py1 = py1 / yzeichenfaktor;
                my2[k] = int(hoehe - round(py1 * ySchritt) + ObererRand);
                if(my2[k] > (hoehe + ObererRand))my2[k] = hoehe + ObererRand;
                if(my2[k] < ObererRand)my2[k] = ObererRand;
              }
            }
          }
        }
        if(!wobbeldaten.bhintergrund){
          //##########################################################
          // Kursor Berechnungen 
          //##########################################################
          //Aus aktiven Kursor die Frequenz ermitteln
          if((mouseposx[kursorix] != 0) && (mouseposy[kursorix] != 0)){ //Cursorindex aktiv
            if(wobbeldaten.bkanal1){
              px1 = (kxm1[kursorix] * wobbeldaten.schrittfrequenz ) + afrequenz;
            }  
            if(wobbeldaten.bkanal2){
              px1 = (kxm2[kursorix] * wobbeldaten.schrittfrequenz ) + afrequenz;
            }  
            if(banfang){ //Uebergabe aus dem Mausmenue
              banfang = false;
              //neue Anfangsfrequenz an nwtlinux.cpp uebermittlen
              emit writeanfang(px1);
            }
            if(bende){ //Uebergabe aus dem Mausmenue
              bende = false;
              //neue Endfrequenz an nwtlinux.cpp uebermittlen
              emit writeende(px1);
            }
            mousefrequenz = px1;
          }
          for(k=0;k<5;k++){
            bmouse = true;
            if(k!=0)bmouse = !wobbeldaten.mousesperre;
            if((mouseposx[k] != 0) && (mouseposy[k] != 0) && bmouse ){ //Cursorkreuz aktiv
              s.sprintf("Kursor %i:", k+1);
              emit multieditinsert(s);
              if(wobbeldaten.bkanal1){
                px1 = (kxm1[k] * wobbeldaten.schrittfrequenz ) + afrequenz;
              }  
              if(wobbeldaten.bkanal2){
                px1 = (kxm2[k] * wobbeldaten.schrittfrequenz ) + afrequenz;
              }  
              s.sprintf("%2.6f MHz", px1 / 1000000.0);
              emit multieditinsert(s);
              //##########################################################
              // Kursortext Kanal 1 
              //##########################################################
              if(wobbeldaten.bkanal1){
                ky1[k] = wobbeldaten.kanal1[kxm1[k]];
                if(wobbeldaten.linear1){
                  py1 = 1.1 * ((ky1[k] * y1faktor + y1shift) * ySchritt / hoehe);
                } else {
                  py1 = ((ky1[k] * y1faktor + y1shift + geteichwertk1(px1)) * yzeichenfaktor) - yzeichenshift; 
                }
                if(wobbeldaten.linear1){
                  bx = 20.0 * log10(py1);
                  s.sprintf("Kanal1: %1.2f, %1.2fdB", py1, bx);
                } else {
                  s.sprintf("Kanal1: %2.2fdB", py1 + wobbeldaten.dbshift1);
                }
                emit multieditinsert(s);
              }
              //##########################################################
              // Kursortext Kanal 2 
              //##########################################################
              if(wobbeldaten.bkanal2){
                ky2[k] = wobbeldaten.kanal2[kxm2[k]];
                if(wobbeldaten.linear2){
                  py1 = 1.1 * ((ky2[k] * y2faktor + y2shift) * ySchritt / hoehe);
                } else {
                  py1 = ((ky2[k] * y2faktor + y2shift + geteichwertk2(px1)) * yzeichenfaktor) - yzeichenshift; 
                }
                if(wobbeldaten.linear2){
                  bx = 20.0 * log10(py1);
                  s.sprintf("Kanal2: %1.2f, %1.2fdB", py1, bx);
                } else {
                  s.sprintf("Kanal2: %2.2fdB", py1 + wobbeldaten.dbshift2);
                }
                emit multieditinsert(s);
              }
              s = "---------------------";
              emit multieditinsert(s);
            }
          }
          //##########################################################
          // max min Text Kanal 1
          //##########################################################
          if(wobbeldaten.bkanal1){
            s = "Kanal 1";
            emit multieditinsert(s);
            px1 = (maxk1f * wobbeldaten.schrittfrequenz ) + afrequenz;
            px1 = px1 / 1000000.0;
            if(wobbeldaten.linear1){
              bx = 20.0 * log10(maxdbk1);
              s.sprintf("max:%1.2f, %1.2fdB %2.6fMHz", maxdbk1, bx, px1);
            } else {
              s.sprintf("max:%2.2fdB %2.6fMHz", maxdbk1 + wobbeldaten.dbshift1, px1);
            }
            emit multieditinsert(s);
            px1 = (mink1f * wobbeldaten.schrittfrequenz ) + afrequenz;
            px1 = px1 / 1000000.0;
            if(wobbeldaten.linear1){
              bx = 20.0 * log10(mindbk1);
              s.sprintf("min:%1.2f, %1.2fdB %2.6fMHz", mindbk1, bx, px1);
            } else {
              s.sprintf("min:%2.2fdB %2.6fMHz", mindbk1 + wobbeldaten.dbshift1, px1);
            }
            emit multieditinsert(s);
      // Bandbreite 3dB
            if(wobbeldaten.bandbreite3db){
              db3xa = 0.0;
              db3xb = 0.0;
              //ermitteln der 1. Frequenz
              for(i=maxk1f; i>=0; i--){
                if(!wobbeldaten.linear1){
                  py1 = ((wobbeldaten.kanal1[i] * y1faktor + y1shift + 
                    geteichwertk1(afrequenz + wobbeldaten.schrittfrequenz * (i))) * yzeichenfaktor) - yzeichenshift; 
                  if((maxdbk1 - py1) > 3.0){
                    db3ya = py1;
                    db3xa = (i * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
                    db3x1 = i;
                    break;
                  }
                }
              }
              //ermitteln der 2. Frequenz
              for(i=maxk1f; i < wobbeldaten.schritte; i++){
                if(!wobbeldaten.linear1){
                  py1 = ((wobbeldaten.kanal1[i] * y1faktor + y1shift + 
                    geteichwertk1(afrequenz + wobbeldaten.schrittfrequenz * (i))) * yzeichenfaktor) - yzeichenshift;
                  if((maxdbk1 - py1) > 3.0){
                    db3yb = py1;
                    db3xb = (i * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
                    db3x2 = i;
                    break;
                  }
                }
              }
        // es hat geklappt, es ist eine Durchlasskurve voerhanden
              if((db3xa != 0.0) and (db3xb != 0.0)){
                bandbreite3db = db3xb - db3xa;
                s.sprintf("B3db: %1.3f Hz", bandbreite3db);
                if(bandbreite3db > 1000.0){
                  s.sprintf("B3db: %1.3f kHz", bandbreite3db/1000.0);
                }
                if(bandbreite3db > 1000000.0){
                  s.sprintf("B3db: %1.3f MHz", bandbreite3db/1000000.0);
                }
                emit multieditinsert(s);
                s.sprintf("Q: %1.2f", ((db3xa + db3xb)/2.0)/bandbreite3db);
                emit multieditinsert(s);
                if(wobbeldaten.bandbreitegrafik){
                  p->setPen( QPen( Qt::red, 0, Qt::DotLine));
                  x = int(round(db3x1 * xSchritt) + LinkerRand);
                  p->drawLine(x, ObererRand, x, hoehe + ObererRand);
                  x = int(round(db3x2 * xSchritt) + LinkerRand);
                  p->drawLine(x, ObererRand, x, hoehe + ObererRand);
                  s.sprintf("f1: %1.6f MHz", db3xa/1000000.0);
                  emit multieditinsert(s);
                  s.sprintf("f2: %1.6f MHz", db3xb/1000000.0);
                  emit multieditinsert(s);
                }
              } else {
                s = "B3db: keine";
                emit multieditinsert(s);
              }
            }
      // Bandbreite 6dB
            if(wobbeldaten.bandbreite6db){
              db3xa = 0.0;
              db3xb = 0.0;
              //ermitteln der 1. Frequenz
              for(i=maxk1f; i>=0; i--){
                if(!wobbeldaten.linear1){
                  py1 = ((wobbeldaten.kanal1[i] * y1faktor + y1shift + 
                    geteichwertk1(afrequenz + wobbeldaten.schrittfrequenz * (i))) * yzeichenfaktor) - yzeichenshift; 
                  if((maxdbk1 - py1) > 6.0){
                    db3ya = py1;
                    db3xa = (i * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
                    db3x1 = i;
                    break;
                  }
                }
              }
              //ermitteln der 2. Frequenz
              for(i=maxk1f; i < wobbeldaten.schritte; i++){
                if(!wobbeldaten.linear1){
                  py1 = ((wobbeldaten.kanal1[i] * y1faktor + y1shift + 
                    geteichwertk1(afrequenz + wobbeldaten.schrittfrequenz * (i))) * yzeichenfaktor) - yzeichenshift; 
                  if((maxdbk1 - py1) > 6.0){
                    db3yb = py1;
                    db3xb = (i * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
                    db3x2 = i;
                    break;
                  }
                }
              }
        //es hat geklappt Durchlasskurve vorhanden
              if((db3xa != 0.0) and (db3xb != 0.0)){
                bandbreite6db = db3xb - db3xa;
                s.sprintf("B6db: %1.3f Hz", bandbreite6db);
                if(bandbreite3db > 1000.0){
                  s.sprintf("B6db: %1.3f kHz", bandbreite6db/1000.0);
                }
                if(bandbreite3db > 1000000.0){
                  s.sprintf("B6db: %1.3f MHz", bandbreite6db/1000000.0);
                }
                emit multieditinsert(s);
                if(wobbeldaten.bandbreitegrafik){
                  p->setPen( QPen( Qt::red, 0, Qt::DashLine));
                  x = int(round(db3x1 * xSchritt) + LinkerRand);
                  p->drawLine(x, ObererRand, x, hoehe + ObererRand);
                  x = int(round(db3x2 * xSchritt) + LinkerRand);
                  p->drawLine(x, ObererRand, x, hoehe + ObererRand);
                  s.sprintf("f1: %1.6f MHz", db3xa/1000000.0);
                  emit multieditinsert(s);
                  s.sprintf("f2: %1.6f MHz", db3xb/1000000.0);
                  emit multieditinsert(s);
                }
              } else {
                s = "B6db: keine";
                emit multieditinsert(s);
              }
            }
            if(wobbeldaten.bandbreite6db){
              db3xa = 0.0;
              db3xb = 0.0;
              //ermitteln der 1. Frequenz
              for(i=maxk1f; i>=0; i--){
                if(!wobbeldaten.linear1){
                  py1 = ((wobbeldaten.kanal1[i] * y1faktor + y1shift + 
                    geteichwertk1(afrequenz + wobbeldaten.schrittfrequenz * (i))) * yzeichenfaktor) - yzeichenshift; 
                  if((maxdbk1 - py1) > 60.0){
                    db3ya = py1;
                    db3xa = (i * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
                    db3x1 = i;
                    break;
                  }
                }
              }
              //ermitteln der 2. Frequenz
              for(i=maxk1f; i < wobbeldaten.schritte; i++){
                if(!wobbeldaten.linear1){
                  py1 = ((wobbeldaten.kanal1[i] * y1faktor + y1shift + 
                    geteichwertk1(afrequenz + wobbeldaten.schrittfrequenz * (i))) * yzeichenfaktor) - yzeichenshift; 
                  if((maxdbk1 - py1) > 60.0){
                    db3yb = py1;
                    db3xb = (i * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
                    db3x2 = i;
                    break;
                  }
                }
              }
        //es hat geklappt Durchlasskurve vorhanden
              if((db3xa != 0.0) and (db3xb != 0.0)){
                bandbreite3db = db3xb - db3xa;
                s.sprintf("B60db: %1.3f Hz", bandbreite3db);
                if(bandbreite3db > 1000.0){
                  s.sprintf("B60db: %1.3f kHz", bandbreite3db/1000.0);
                }
                if(bandbreite3db > 1000000.0){
                  s.sprintf("B60db: %1.3f MHz", bandbreite3db/1000000.0);
                }
                emit multieditinsert(s);
                if(wobbeldaten.bandbreitegrafik){
                  p->setPen( QPen( Qt::blue, 0, Qt::DashLine));
                  x = int(round(db3x1 * xSchritt) + LinkerRand);
                  p->drawLine(x, ObererRand, x, hoehe + ObererRand);
                  x = int(round(db3x2 * xSchritt) + LinkerRand);
                  p->drawLine(x, ObererRand, x, hoehe + ObererRand);
                  s.sprintf("f1: %1.6f MHz", db3xa/1000000.0);
                  emit multieditinsert(s);
                  s.sprintf("f2: %1.6f MHz", db3xb/1000000.0);
                  emit multieditinsert(s);
                }
                s.sprintf("Shape-Faktor: %1.6f", bandbreite3db / bandbreite6db);
                emit multieditinsert(s);
              } else {
                s = "B60db: keine";
                emit multieditinsert(s);
              }
            }
            s = "---------------------";
            emit multieditinsert(s);
          }
          //##########################################################
          // max min Text Kanal 2
          //##########################################################
          if(wobbeldaten.bkanal2){
            s = "Kanal 2";
            emit multieditinsert(s);
            px1 = (maxk2f * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
            px1 = px1 / 1000000.0;
            if(wobbeldaten.linear2){
              bx = 20.0 * log10(maxdbk2);
              s.sprintf("max:%1.2f, %1.2fdB %2.6fMHz", maxdbk2, bx, px1);
            } else {
              s.sprintf("max:%2.2fdB %2.6fMHz", maxdbk2 + wobbeldaten.dbshift2, px1);
            }
            emit multieditinsert(s);
            px1 = (mink2f * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
            px1 = px1 / 1000000.0;
            if(wobbeldaten.linear2){
              bx = 20.0 * log10(mindbk2);
              s.sprintf("min:%1.2f, %1.2fdB %2.6fMHz", mindbk2, bx, px1);
            } else {
              s.sprintf("min:%2.2fdB %2.6fMHz", mindbk2 + wobbeldaten.dbshift2, px1);
            }
            emit multieditinsert(s);
      //3dB Bandbreite + Q
            if(wobbeldaten.bandbreite3db){
              db3xa = 0.0;
              db3xb = 0.0;
              //qDebug("maxdbf %i  maxdb %f",maxk2f, maxdbk2);
              //ermitteln der 1. Frequenz
              for(i=maxk2f; i>=0; i--){
                if(!wobbeldaten.linear2){
                  py1 = ((wobbeldaten.kanal2[i] * y2faktor + y2shift + 
                    geteichwertk2(afrequenz + wobbeldaten.schrittfrequenz * (i))) * yzeichenfaktor) - yzeichenshift; 
                  if((maxdbk2 - py1) > 3.0){
                    db3ya = py1;
                    db3xa = (i * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
                    db3x1 = i;
                    break;
                  }
                }
              }
              //ermitteln der 2. Frequenz
              for(i=maxk2f; i < wobbeldaten.schritte; i++){
                if(!wobbeldaten.linear2){
                  py1 = ((wobbeldaten.kanal2[i] * y2faktor + y2shift + 
                    geteichwertk2(afrequenz + wobbeldaten.schrittfrequenz * (i))) * yzeichenfaktor) - yzeichenshift; 
                  if((maxdbk2 - py1) > 3.0){
                    db3yb = py1;
                    db3xb = (i * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
                    db3x2 = i;
                    break;
                  }
                }
              }
              if((db3xa != 0.0) and (db3xb != 0.0)){
                bandbreite3db = db3xb - db3xa;
                s.sprintf("B3db: %1.3f Hz", bandbreite3db);
                if(bandbreite3db > 1000.0){
                  s.sprintf("B3db: %1.3f kHz", bandbreite3db/1000.0);
                }
                if(bandbreite3db > 1000000.0){
                  s.sprintf("B3db: %1.3f MHz", bandbreite3db/1000000.0);
                }
                emit multieditinsert(s);
                s.sprintf("Q: %1.2f", ((db3xa + db3xb)/2.0)/bandbreite3db);
                emit multieditinsert(s);
                if(wobbeldaten.bandbreitegrafik){
                  p->setPen( QPen( Qt::darkGreen, 0, Qt::DotLine));
                  x = int(round(db3x1 * xSchritt) + LinkerRand);
                  p->drawLine(x, ObererRand, x, hoehe + ObererRand);
                  x = int(round(db3x2 * xSchritt) + LinkerRand);
                  p->drawLine(x, ObererRand, x, hoehe + ObererRand);
                  s.sprintf("f1: %1.6f MHz", db3xa/1000000.0);
                  emit multieditinsert(s);
                  s.sprintf("f2: %1.6f MHz", db3xb/1000000.0);
                  emit multieditinsert(s);
                }
              } else {
                s = "B3db: keine";
                emit multieditinsert(s);
              }
            }
      //Bandbreite 6dB ermitteln
            if(wobbeldaten.bandbreite6db){
              db3xa = 0.0;
              db3xb = 0.0;
              //ermitteln der 1. Frequenz
              for(i=maxk2f; i>=0; i--){
                if(!wobbeldaten.linear2){
                  py1 = ((wobbeldaten.kanal2[i] * y2faktor + y2shift + 
                    geteichwertk2(afrequenz + wobbeldaten.schrittfrequenz * (i))) * yzeichenfaktor) - yzeichenshift; 
                  if((maxdbk2 - py1) > 6.0){
                    db3ya = py1;
                    db3xa = (i * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
                    db3x1 = i;
                    break;
                  }
                }
              }
              //ermitteln der 2. Frequenz
              for(i=maxk2f; i < wobbeldaten.schritte; i++){
                if(!wobbeldaten.linear2){
                  py1 = ((wobbeldaten.kanal2[i] * y2faktor + y2shift + 
                    geteichwertk2(afrequenz + wobbeldaten.schrittfrequenz * (i))) * yzeichenfaktor) - yzeichenshift; 
                  if((maxdbk2 - py1) > 6.0){
                    db3yb = py1;
                    db3xb = (i * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
                    db3x2 = i;
                    break;
                  }
                }
              }
              if((db3xa != 0.0) and (db3xb != 0.0)){
                bandbreite6db = db3xb - db3xa;
                s.sprintf("B6db: %1.3f Hz", bandbreite6db);
                if(bandbreite3db > 1000.0){
                  s.sprintf("B6db: %1.3f kHz", bandbreite6db/1000.0);
                }
                if(bandbreite3db > 1000000.0){
                  s.sprintf("B6db: %1.3f MHz", bandbreite6db/1000000.0);
                }
                emit multieditinsert(s);
                if(wobbeldaten.bandbreitegrafik){
                  p->setPen( QPen( Qt::darkGreen, 0, Qt::DashLine));
                  x = int(round(db3x1 * xSchritt) + LinkerRand);
                  p->drawLine(x, ObererRand, x, hoehe + ObererRand);
                  x = int(round(db3x2 * xSchritt) + LinkerRand);
                  p->drawLine(x, ObererRand, x, hoehe + ObererRand);
                  s.sprintf("f1: %1.6f MHz", db3xa/1000000.0);
                  emit multieditinsert(s);
                  s.sprintf("f2: %1.6f MHz", db3xb/1000000.0);
                  emit multieditinsert(s);
                }
              } else {
                s = "B6db: keine";
                emit multieditinsert(s);
              }
            }
      //Ermitteln der Bandbreite 60dB
            if(wobbeldaten.bandbreite6db){
              db3xa = 0.0;
              db3xb = 0.0;
              //ermitteln der 1. Frequenz
              for(i=maxk2f; i>=0; i--){
                if(!wobbeldaten.linear2){
                  py1 = ((wobbeldaten.kanal2[i] * y2faktor + y2shift + 
                    geteichwertk2(afrequenz + wobbeldaten.schrittfrequenz * (i))) * yzeichenfaktor) - yzeichenshift; 
                  if((maxdbk2 - py1) > 60.0){
                    db3ya = py1;
                    db3xa = (i * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
                    db3x1 = i;
                    break;
                  }
                }
              }
              //ermitteln der 2. Frequenz
              for(i=maxk2f; i < wobbeldaten.schritte; i++){
                if(!wobbeldaten.linear2){
                  py1 = ((wobbeldaten.kanal2[i] * y2faktor + y2shift + 
                    geteichwertk2(afrequenz + wobbeldaten.schrittfrequenz * (i))) * yzeichenfaktor) - yzeichenshift; 
                  if((maxdbk2 - py1) > 60.0){
                    db3yb = py1;
                    db3xb = (i * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
                    db3x2 = i;
                    break;
                  }
                }
              }
        //es hat geklappt Durchlasskurve vorhanden
              if((db3xa != 0.0) and (db3xb != 0.0)){
                bandbreite3db = db3xb - db3xa;
                s.sprintf("B60db: %1.3f Hz", bandbreite3db);
                if(bandbreite3db > 1000.0){
                  s.sprintf("B60db: %1.3f kHz", bandbreite3db/1000.0);
                }
                if(bandbreite3db > 1000000.0){
                  s.sprintf("B60db: %1.3f MHz", bandbreite3db/1000000.0);
                }
                emit multieditinsert(s);
                if(wobbeldaten.bandbreitegrafik){
                  p->setPen( QPen( Qt::blue, 0, Qt::DashLine));
                  x = int(round(db3x1 * xSchritt) + LinkerRand);
                  p->drawLine(x, ObererRand, x, hoehe + ObererRand);
                  x = int(round(db3x2 * xSchritt) + LinkerRand);
                  p->drawLine(x, ObererRand, x, hoehe + ObererRand);
                  s.sprintf("f1: %1.6f MHz", db3xa/1000000.0);
                  emit multieditinsert(s);
                  s.sprintf("f2: %1.6f MHz", db3xb/1000000.0);
                  emit multieditinsert(s);
                }
                s.sprintf("Shape-Faktor: %1.6f", bandbreite3db / bandbreite6db);
                emit multieditinsert(s);
              } else {
                s = "B60db: keine";
                emit multieditinsert(s);
              }
            }
            s = "---------------------";
            emit multieditinsert(s);
          }
        }
        break;
      case eswrneu:
      case eswrant: 
      case eimpedanz: 
      //##########################################################
      // Betriebsart SWVneu 
      //##########################################################
      // Stift rot und durchgezogene Linie
      p->setPen( wobbeldaten.penkanal1 );
      afrequenz = wobbeldaten.anfangsfrequenz;
      for(i=0; i < wobbeldaten.schritte - 1; i++){
        bkurvezeichnen = true;
        x = int(round(i * xSchritt) + LinkerRand) + (int)xAnfang;
        if( x < LinkerRand)bkurvezeichnen = false;
        if( x > (LinkerRand + breite))bkurvezeichnen = false;
        x1 = int(round((i+1) * xSchritt) + LinkerRand) + (int)xAnfang;
        if( x1 < LinkerRand)bkurvezeichnen = false;
        if( x1 > (LinkerRand + breite))bkurvezeichnen = false;
//        x = int(round(i * xSchritt) + LinkerRand);
//        x1 = int(round((i+1) * xSchritt) + LinkerRand);
        j1 = i - 1;
        j2 = i;
        j3 = i + 1;
        if(j1<0)j1=0;
        if(j3>(wobbeldaten.schritte-1))j3 = wobbeldaten.schritte-1;
        w1 = double(wobbeldaten.kanal1[j1]);
        w2 = double(wobbeldaten.kanal1[j2]);
        w3 = double(wobbeldaten.kanal1[j3]);
        py1 = ((w2 * y1faktor + y1shift) / 10.24) - 90.0;
        py1 = py1 - getswreichwertk1(afrequenz + double(wobbeldaten.schrittfrequenz * j2));
        if(py1 > -1.0)py1 = -1.0;
        uricht = pow(10.0 , (py1/20.0));
        swv = (1.0 + uricht)/(1.0 - uricht);
        if(wobbeldaten.bswriteration){
          py1 = ((w1 * y1faktor + y1shift) / 10.24) - 90.0;
          py1 = py1 - getswreichwertk1(afrequenz + double(wobbeldaten.schrittfrequenz * j1));
          if(py1 > -1.0)py1 = -1.0;
          uricht = pow(10.0 , (py1/20.0));
          swv = swv + (1.0 + uricht)/(1.0 - uricht);
          py1 = ((w3 * y1faktor + y1shift) / 10.24) - 90.0;
          py1 = py1 - getswreichwertk1(afrequenz + double(wobbeldaten.schrittfrequenz * j3));
          if(py1 > -1.0)py1 = -1.0;
          uricht = pow(10.0 , (py1/20.0));
          swv = swv + (1.0 + uricht)/(1.0 - uricht);
          swv = swv / 3.0;
        }
        if((wobbeldaten.ebetriebsart == eswrneu)or(wobbeldaten.ebetriebsart == eswrant)){
          y = int(round(hoehe - round((swv - 1.0) * (double(hoehe)/yswrteilung)) - 1 + ObererRand));
        } 
        if(wobbeldaten.ebetriebsart == eimpedanz){
          swv = (50.0 * swv) - 50.0;
//          swv = 10.0;
          y = int(round(hoehe - round((swv - 1.0) * (double(hoehe)/200.0)) - 2 + ObererRand));
        } 
        if(wobbeldaten.ebetriebsart == eswrant){ 
          a = a_100 * laenge / 100.0;
          r_tx = (swv - 1.0) / (swv + 1.0);
          r_ant = r_tx * pow(10.0 , a/10.0);
          if(r_ant >= 1.0)r_ant = 0.99;
          s_ant = (1.0 + r_ant) / (1.0 - r_ant);
          y3 = int(round(hoehe - round((s_ant - 1.0) * (double(hoehe)/yswrteilung)) - 1 + ObererRand));
        }
        j1 = i ;
        j2 = i + 1;
        j3 = i + 2;
        if(j2>(wobbeldaten.schritte-1))j2 = wobbeldaten.schritte-1;
        if(j3>(wobbeldaten.schritte-1))j3 = wobbeldaten.schritte-1;
        w1 = double(wobbeldaten.kanal1[j1]);
        w2 = double(wobbeldaten.kanal1[j2]);
        w3 = double(wobbeldaten.kanal1[j3]);
        py1 = ((w2 * y1faktor + y1shift) / 10.24) - 90.0;
        py1 = py1 - getswreichwertk1(afrequenz + double(wobbeldaten.schrittfrequenz * j2));
        if(py1 > -1.0)py1 = -1.0;
        uricht = pow(10.0 , (py1/20.0));
        swv = (1.0 + uricht)/(1.0 - uricht);
        if(wobbeldaten.bswriteration){
          py1 = ((w1 * y1faktor + y1shift) / 10.24) - 90.0;
          py1 = py1 - getswreichwertk1(afrequenz + double(wobbeldaten.schrittfrequenz * j1));
          if(py1 > -1.0)py1 = -1.0;
          uricht = pow(10.0 , (py1/20.0));
          swv = swv + (1.0 + uricht)/(1.0 - uricht);
          py1 = ((w3 * y1faktor + y1shift) / 10.24) - 90.0;
          py1 = py1 - getswreichwertk1(afrequenz + double(wobbeldaten.schrittfrequenz * j3));
          if(py1 > -1.0)py1 = -1.0;
          uricht = pow(10.0 , (py1/20.0));
          swv = swv + (1.0 + uricht)/(1.0 - uricht);
          swv = swv / 3.0;
         }
	//ermitteln des minimalen SWV in ganzen Bereich
         if(minswr > swv){
           minswr = swv;
           mink1 = j2;
         }  
	//ermitteln des maximalen SWV in ganzen Bereich
         if(maxswr < swv){
           maxswr = swv;
           maxk1 = j2;
        }  
        if((wobbeldaten.ebetriebsart == eswrneu)or(wobbeldaten.ebetriebsart == eswrant)){
          y1 = int(round(hoehe - round((swv - 1.0) * (double(hoehe)/yswrteilung)) - 1 + ObererRand));
        }
        if(wobbeldaten.ebetriebsart == eimpedanz){
          swv = (50.0 * swv) - 50.0;
//          swv = 10.0;
          y1 = int(round(hoehe - round((swv - 1.0) * (double(hoehe)/200.0)) - 2 + ObererRand));
        }
        if(wobbeldaten.ebetriebsart == eswrant){ 
          a = a_100 * laenge / 100.0;
          r_tx = (swv - 1.0) / (swv + 1.0);
          r_ant = r_tx * pow(10.0 , a/10.0);
          if(r_ant >= 1.0)r_ant = 0.99;
          s_ant = (1.0 + r_ant) / (1.0 - r_ant);
          y4 = int(round(hoehe - round((s_ant - 1.0) * (double(hoehe)/yswrteilung)) - 1 + ObererRand));
        }
        //auf extremwerte reagieren Linie soll Anzeige nicht nach oben verlassen
        if(y > (hoehe + ObererRand))y = hoehe + ObererRand;
        if(y < ObererRand)y = ObererRand;
        if(y1 > (hoehe + ObererRand))y1 = hoehe + ObererRand;
        if(y1 < ObererRand)y1 = ObererRand;
        if(wobbeldaten.ebetriebsart == eswrant){ 
          if(y3 > (hoehe + ObererRand))y3 = hoehe + ObererRand;
          if(y3 < ObererRand)y3 = ObererRand;
          if(y4 > (hoehe + ObererRand))y4 = hoehe + ObererRand;
          if(y4 < ObererRand)y4 = ObererRand;
        }  
        //Linie zeichnen
        p->setPen( wobbeldaten.penkanal1 );
        if(bkurvezeichnen)p->drawLine(x, y, x1, y1);
        if(wobbeldaten.ebetriebsart == eswrant){ 
          p->setPen( QPen( Qt::blue, 0, Qt::SolidLine));
          if(bkurvezeichnen)p->drawLine(x, y3, x1, y4);
        }
        if(!wobbeldaten.bhintergrund){ 
          //Anfangswerte setzen
          for(k=0;k<5;k++){
            if(mouseposx1[k] != mouseposx[k]){
              if(i == 0){
                xm1[k] = LinkerRand;
                mx1[k] = x; //pos im Wobbelfenster
                my1[k] = y; //pos im Wobbelfenster
                kx[k] = i; //nr des Schrittes
                kx1[k] = i - 1;
                kx2[k] = i ;
                if(kx1[k]<0)kx1[k]=0;
                kx3[k] = i + 1;
                if(kx3[k]>(wobbeldaten.schritte-1))kx3[k] = wobbeldaten.schritte-1;
                kw1[k] = wobbeldaten.kanal1[kx1[k]];
                kw2[k] = wobbeldaten.kanal1[kx2[k]];
                kw3[k] = wobbeldaten.kanal1[kx3[k]];
                kxm1[k] = kx[k];
              }
              //neue Werte setzen
              xm2[k] = abs(x - mouseposx[k]);
              if(xm2[k] < xm1[k]){
                xm1[k] = xm2[k];
                mx1[k] = x; //pos im Wobbelfenster
                my1[k] = y; //pos im Wobbelfenster
                kx[k] = i;  //nr des Schrittes
                kx1[k] = kx[k] - 1;  //nr des Schrittes
                kx2[k] = kx[k];  //nr des Schrittes
                kx3[k] = kx[k] + 1;  //nr des Schrittes
                if(kx1[k]<0)kx1[k]=0;
                if(kx3[k]>(wobbeldaten.schritte-1))kx3[k] = wobbeldaten.schritte-1;
                kw1[k] = wobbeldaten.kanal1[kx1[k]];
                kw2[k] = wobbeldaten.kanal1[kx2[k]];
                kw3[k] = wobbeldaten.kanal1[kx3[k]];
                if(wobbeldaten.ebetriebsart == eswrant){ 
                  my2[k] = y3;
                  mx2[k] = mx1[k];
                }
                kxm1[k] = kx[k];
              }
              xm2[k] = abs(x1 - mouseposx[k]);
              if(xm2[k] < xm1[k]){
                xm1[k] = xm2[k];
                mx1[k] = x1; //pos im Wobbelfenster
                my1[k] = y1; //pos im Wobbelfenster
                kx[k] = i + 1;  //nr des Schrittes
                kx1[k] = kx[k] - 1;  //nr des Schrittes
                kx2[k] = kx[k];  //nr des Schrittes
                kx3[k] = kx[k] + 1;  //nr des Schrittes
                if(kx1[k]<0)kx1[k]=0;
                if(kx3[k]>(wobbeldaten.schritte-1))kx3[k] = wobbeldaten.schritte-1;
                kw1[k] = wobbeldaten.kanal1[kx1[k]];
                kw2[k] = wobbeldaten.kanal1[kx2[k]];
                kw3[k] = wobbeldaten.kanal1[kx3[k]];
                if(wobbeldaten.ebetriebsart == eswrant){ 
                  my2[k] = y4;
                  mx2[k] = mx1[k];
                }
                kxm1[k] = kx[k];
              }
            }else{
              kx1[k] = kxm1[k] - 1;  //nr des Schrittes
              kx2[k] = kxm1[k];      //nr des Schrittes
              kx3[k] = kxm1[k] + 1;  //nr des Schrittes
              if(kx1[k]<0)kx1[k]=0;
              if(kx3[k]>(wobbeldaten.schritte-1))kx3[k] = wobbeldaten.schritte-1;
              kw1[k] = wobbeldaten.kanal1[kx1[k]];
              kw2[k] = wobbeldaten.kanal1[kx2[k]];
              kw3[k] = wobbeldaten.kanal1[kx3[k]];
              mx1[k] = int(round(kxm1[k] * xSchritt) + LinkerRand);
              if(wobbeldaten.ebetriebsart == eswrant){ 
                mx2[k] = mx1[k];
              }
              w1 = double(wobbeldaten.kanal1[kx1[k]]);
              w2 = double(wobbeldaten.kanal1[kx2[k]]);
              w3 = double(wobbeldaten.kanal1[kx3[k]]);
              py1 = ((w2 * y1faktor + y1shift) / 10.24) - 90.0;
              py1 = py1 - getswreichwertk1(afrequenz + double(wobbeldaten.schrittfrequenz * kx2[k]));
              if(py1 > -1.0)py1 = -1.0;
              uricht = pow(10.0 , (py1/20.0));
              swv = (1.0 + uricht)/(1.0 - uricht);
              if(wobbeldaten.bswriteration){
                py1 = ((w1 * y1faktor + y1shift) / 10.24) - 90.0;
                py1 = py1 - getswreichwertk1(afrequenz + double(wobbeldaten.schrittfrequenz * kx1[k]));
                if(py1 > -1.0)py1 = -1.0;
                uricht = pow(10.0 , (py1/20.0));
                swv = swv + (1.0 + uricht)/(1.0 - uricht);
                py1 = ((w3 * y1faktor + y1shift) / 10.24) - 90.0;
                py1 = py1 - getswreichwertk1(afrequenz + double(wobbeldaten.schrittfrequenz * kx3[k]));
                if(py1 > -1.0)py1 = -1.0;
                uricht = pow(10.0 , (py1/20.0));
                swv = swv + (1.0 + uricht)/(1.0 - uricht);
                swv = swv / 3.0;
              }
              if((wobbeldaten.ebetriebsart == eswrneu)or(wobbeldaten.ebetriebsart == eswrant)){
                my1[k] = int(round(hoehe - round((swv - 1.0) * (double(hoehe)/yswrteilung)) - 1 + ObererRand));
              }
              if(wobbeldaten.ebetriebsart == eimpedanz){
                swv = (50.0 * swv) - 50.0;
    //            swv = 10.0;
                my1[k] = int(round(hoehe - round((swv - 1.0) * (double(hoehe)/200.0)) - 2 + ObererRand));
              } 
              if(wobbeldaten.ebetriebsart == eswrant){ 
                a = a_100 * laenge / 100.0;
                r_tx = (swv - 1.0) / (swv + 1.0);
                r_ant = r_tx * pow(10.0 , a/10.0);
                if(r_ant >= 1.0)r_ant = 0.99;
                s_ant = (1.0 + r_ant) / (1.0 - r_ant);
                my2[k] = int(round(hoehe - round((s_ant - 1.0) * (double(hoehe)/yswrteilung)) - 1 + ObererRand));
                if(my2[k] > (hoehe + ObererRand))my2[k] = hoehe + ObererRand;
                if(my2[k] < ObererRand)my2[k] = ObererRand;
              }
              if(my1[k] > (hoehe + ObererRand))my1[k] = hoehe + ObererRand;
              if(my1[k] < ObererRand)my1[k] = ObererRand;
            }
          }
        }
#ifdef LDEBUG
          qDebug("WidgetWobbeln::drawKurve():kx[kursorix] %i mx1[kursorix] %i mouseposx[kursorix] %i", kx[kursorix], mx1[kursorix], mouseposx[kursorix]);
#endif
      }
      if(!wobbeldaten.bhintergrund){ 
        //Aus aktiven Kursor die Frequenz ermitteln
        if((mouseposx[kursorix] != 0) && (mouseposy[kursorix] != 0)){ //Cursorindex aktiv
          mousefrequenz = (kxm1[kursorix] * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
        }
        for(k=0;k<5;k++){
          bmouse = true;
          if(k!=0)bmouse = !wobbeldaten.mousesperre;
          if((mouseposx[k] != 0) && (mouseposy[k] != 0) && bmouse ){ //Cursorkreuz aktiv
            s.sprintf("Kursor %i:",k+1);
            if(bnomove)emit multieditinsert(s);
            px1 = (kxm1[k] * wobbeldaten.schrittfrequenz ) + wobbeldaten.anfangsfrequenz;
            if(banfang){ //Uebergabe aus dem Mausmenue
              banfang = false;
              //neue Anfangsfrequenz an nwtlinux.cpp uebermittlen
              emit writeanfang(px1);
            }
            if(bende){ //Uebergabe aus dem Mausmenue
              bende = false;
              //neue Endfrequenz an nwtlinux.cpp uebermittlen
              emit writeende(px1);
            }
            s.sprintf("%2.6f MHz", px1 / 1000000.0);
            emit multieditinsert(s);
            py1 = ((kw2[k] * y1faktor + y1shift) / 10.24) - 90.0;
            py1 = py1 - getswreichwertk1(afrequenz + double(wobbeldaten.schrittfrequenz * kx2[k]));
            if(py1 > -1.0)py1 = -1.0;
            uricht = pow(10.0 , (py1/20.0));
            swv = (1.0 + uricht)/(1.0 - uricht);
            if(wobbeldaten.bswriteration){
              py1 = ((kw1[k] * y1faktor + y1shift) / 10.24) - 90.0;
              py1 = py1 - getswreichwertk1(afrequenz + double(wobbeldaten.schrittfrequenz * kx1[k]));
              if(py1 > -1.0)py1 = -1.0;
              uricht = pow(10.0 , (py1/20.0));
              swv = swv + (1.0 + uricht)/(1.0 - uricht);
              py1 = ((kw3[k] * y1faktor + y1shift) / 10.24) - 90.0;
              py1 = py1 - getswreichwertk1(afrequenz + double(wobbeldaten.schrittfrequenz * kx3[k]));
              if(py1 > -1.0)py1 = -1.0;
              uricht = pow(10.0 , (py1/20.0));
              swv = swv + (1.0 + uricht)/(1.0 - uricht);
              swv = swv / 3.0;
            }
            if((wobbeldaten.ebetriebsart == eswrneu)or(wobbeldaten.ebetriebsart == eswrant)){
              s.sprintf("SWV: %4.4f", swv);
            }
            if(wobbeldaten.ebetriebsart == eimpedanz){
              py1=getswreichwertk1(afrequenz + double(wobbeldaten.schrittfrequenz * kx1[k]));
//              s.sprintf("Eich: %4.4f dB", py1);
//              emit multieditinsert(s);
              swv = (50.0 * swv) - 50.0;
              s.sprintf("Z: %4.4f Ohm", swv);
            }  
            emit multieditinsert(s);
            // SWV Messung ueber Kabel
            if(wobbeldaten.ebetriebsart == eswrant){ 
              a = a_100 * laenge / 100.0;
              r_tx = (swv - 1.0) / (swv + 1.0);
              r_ant = r_tx * pow(10.0 , a/10.0);
              if(r_ant >= 1.0)r_ant = 0.99;
              s_ant = (1.0 + r_ant) / (1.0 - r_ant);
              s.sprintf("SWV_ant: %4.4f", s_ant);
              emit multieditinsert(s);
            }
            s = "---------------------";
            emit multieditinsert(s);
          }
        }
        if((wobbeldaten.ebetriebsart == eswrneu) or (wobbeldaten.ebetriebsart == eswrant)){
          // SWV minimum anzeigen
          px1 = (mink1 * wobbeldaten.schrittfrequenz ) + afrequenz;
          px1 = px1 / 1000000.0;
          s.sprintf("SWV min: %2.2f  %2.6f", minswr, px1);
          emit multieditinsert(s);
          // SWV maximum anzeigen
          px1 = (maxk1 * wobbeldaten.schrittfrequenz ) + afrequenz;
          px1 = px1 / 1000000.0;
          s.sprintf("SWV max: %2.2f  %2.6f", maxswr, px1);
          emit multieditinsert(s);
          s = "---------------------";
          emit multieditinsert(s);
        }
        if(wobbeldaten.ebetriebsart == eimpedanz){
          // Impedanz minimum anzeigen
          px1 = (mink1 * wobbeldaten.schrittfrequenz ) + afrequenz;
          px1 = px1 / 1000000.0;
          swv = (50.0 * minswr) - 50.0;
          s.sprintf("Z min: %2.2f  %2.6f", swv, px1);
          emit multieditinsert(s);
          // SWV maximum anzeigen
          px1 = (maxk1 * wobbeldaten.schrittfrequenz ) + afrequenz;
          px1 = px1 / 1000000.0;
          swv = (50.0 * maxswr) - 50.0;
          s.sprintf("Z max: %2.2f  %2.6f", swv, px1);
          emit multieditinsert(s);
          s = "---------------------";
          emit multieditinsert(s);
        }
      }
      break;
    }  
    //#####################################################################
    // Switch zuende
    //#####################################################################
    if(!wobbeldaten.bhintergrund){ 
      if((mouseposx[kursorix] != 0) && (mouseposy[kursorix] != 0)){ //Cursorindex aktiv
//      Kursorfrequenz an nwt7linux.cpp uebermitteln
        emit setKursorFrequenz(mousefrequenz);
//      qDebug("KursorFrequenz %f",mousefrequenz);
      }else{
        //0.0 an nwt7linux.cpp uebermitteln
        emit setKursorFrequenz(0.0);
      }
      for(k=0;k<5;k++){
        //Mauskreuz zeigen aber nur wenn pos aktiv und keine Frequenzermittlung
        if((mouseposx[k] != 0) && (mouseposy[k] != 0) && !banfang && !bende){
          double dbz=8.0; //Mauszeigergroesse
          int bz = (int)((double)breite/430.0 * dbz); //Kursorgroesse automatisch vergroessern
          p->setPen( QPen( Qt::darkRed, 0, Qt::SolidLine));
          // Kursor als Dreieck
          p->drawLine(mx1[k], my1[k], mx1[k]-bz/2, my1[k]-bz);
          p->drawLine(mx1[k], my1[k], mx1[k]+bz/2, my1[k]-bz);
          p->drawLine(mx1[k]+bz/2, my1[k]-bz, mx1[k]-bz/2, my1[k]-bz);
          p->drawLine(mx2[k], my2[k], mx2[k]-bz/2, my2[k]-bz);
          p->drawLine(mx2[k], my2[k], mx2[k]+bz/2, my2[k]-bz);
          p->drawLine(mx2[k]+bz/2, my2[k]-bz, mx2[k]-bz/2, my2[k]-bz);
          s.sprintf("%i", k+1);
          p->drawText(mx1[k]-2, my1[k]-bz-1, s);
          p->drawText(mx2[k]-2, my2[k]-bz-1, s);
        }
      }
    //*************************************************************************************
    //*************************************************************************************
    //*************************************************************************************
    //*************************************************************************************
    //  bitBlt(this, 0,0, pix);
      for(k=0;k<5;k++){
        mouseposx1[k] = mouseposx[k];
      }
    }
//    p->end();
  }
}

void WidgetWobbeln::setWobbeldaten(OWobbel wob)
{
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::setWobbeldaten()");
  #endif
  //Uebernahme der Wobbeldaten
  wobbeldaten = wob;
  //Befehl zum Neuzeichnen ausloesen
  repaint();
}

void WidgetWobbeln::wobbeldatenempfang(OWobbel wob)
{
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::wobbeldatenempfang()");
  #endif
  //Uebernahme der Wobbeldaten
  wobbeldaten = wob;
  if(kurve1 != NULL){
    kurve1->absanfang = wobbeldaten.absanfang;
    kurve1->absende = wobbeldaten.absende;
  }
  if(kurve2 != NULL){
    kurve2->absanfang = wobbeldaten.absanfang;
    kurve2->absende = wobbeldaten.absende;
  }
  if(kurve3 != NULL){
    kurve3->absanfang = wobbeldaten.absanfang;
    kurve3->absende = wobbeldaten.absende;
  }
  if(kurve4 != NULL){
    kurve4->absanfang = wobbeldaten.absanfang;
    kurve4->absende = wobbeldaten.absende;
  }
  refreshPixmap();
  //Befehl zum Neuzeichnen ausloesen
  repaint();
}

void WidgetWobbeln::wobbeldatenkurve(OWobbel wob)
{
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::wobbeldatenkurve()");
  #endif
  wobbeldaten = wob;
//  wobbeldaten.daten_enable = true;
  refreshKurve();
  repaint();
}

void WidgetWobbeln::empfangeichdaten(teicharray aeicharray)
{
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::empfangeichdaten()");
  #endif
  //Eichdaten uebergeben
  weicharray = aeicharray;
}

void WidgetWobbeln::empfangfrqmarken(tfmarken afmarken)
{
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::empfangfrqmarken()");
  #endif
  //Frequenzmarken uebergeben
  wfmarken = afmarken;
  refreshPixmap();
  repaint();
}

void WidgetWobbeln::empfangswreichdaten(tswreicharray aeicharray)
{
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::empfangswreichdaten()");
  #endif
  //Eichdaten fuer SWV neu uebergeben
  wswreicharray = aeicharray;
}

OWobbel WidgetWobbeln::getWobbeldaten(){
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::getWobbeldaten()");
  #endif
  return wobbeldaten;
}

void WidgetWobbeln::printdiagramm(QFont pfont, Q3StrList astrlist)
{
  QPrinter *print = new QPrinter;
  int xp = 40;
  int yp = 0;
  int ypmerk;
  int zeilenabstand = 20;
  unsigned int i;
  double mx, my, mxx;
  QString qs, qs1;
  QFont afont;
  
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::printdiagramm()");
  #endif
  QDateTime dt = QDateTime::currentDateTime();
  qs1 = dt.toString("dd MMMM yyyy, hh:mm");
  afont = pfont;
  refreshPixmap();
  repaint();
  if(print->setup(this)){
    refreshPixmap();
    repaint();
    QPainter p(print);
    Q3PaintDeviceMetrics metrics(p.device());
    //Druckplattbreite ermitteln
    mx = metrics.width();
    mxx = mx;
    my = metrics.height();
    //linken Druckrand abziehen
    mx = mx - xp;
    //breite des Anzeigefensters der Grafik
    double px = this->rect().width();
    
    mx = mx/px * 0.8;
    p.setFont(pfont);
    qs = "NWT 4 Linux & Windows  " + qs1;
    yp += zeilenabstand;
    yp += zeilenabstand;
    p.drawText(xp, yp, qs);
    yp += zeilenabstand;
    p.drawLine(xp, yp, metrics.width() - xp, yp);
    yp += zeilenabstand;
    qs.sprintf(tr("Startfrequenz: %3.6f MHz; Endfrequenz: %3.6f MHz"), 
               double(wobbeldaten.anfangsfrequenz)/1000000.0, 
               double(((wobbeldaten.schritte - 1) * wobbeldaten.schrittfrequenz)+
               wobbeldaten.anfangsfrequenz)/1000000.0);
    p.drawText(xp, yp, qs);
    yp += zeilenabstand;
    qs.sprintf(tr("Schrittweite: %4.3f kHz; Messpunkte: %4i"), 
               double(wobbeldaten.schrittfrequenz)/1000.0, wobbeldaten.schritte);
    p.drawText(xp, yp, qs);
    yp += zeilenabstand;
    //Linie ueber der Grafik
    p.drawLine(xp, yp, metrics.width() - xp, yp);
    yp += zeilenabstand;
    //Auf richtige Groesse bringen
//    p.scale(mx, mx * 0.9);
    p.drawPixmap(int(xp), int(yp), pix);
    yp += int(this->rect().height() * mx);
    //Groesse wieder restaurieren
//    p.scale(1/mx, 1/(mx * 0.9));
    //Linie unter dem Bild
    p.drawLine(xp, yp, metrics.width() - xp, yp);
    ypmerk = yp;
    if(astrlist.count() > 0){
      yp += zeilenabstand;
//      qDebug("yp=%i ",yp);
      qs = astrlist.first();
      p.drawText(xp, yp, qs);
      for(i=1; i < astrlist.count(); i++){
        yp += zeilenabstand;
//        qDebug("yp=%i xp=%i", yp, xp);
        if((yp + zeilenabstand) > (int)my){
          yp = ypmerk;
          xp = xp + (mxx / 3);
          yp += zeilenabstand;
        }
        qs = astrlist.next();
        p.drawText(xp,yp, qs);
      }
      yp += zeilenabstand;
      //Abschlusslinie
  //    p.drawLine(xp, yp, print->width()-xp, yp);
    }
  }  
}


void WidgetWobbeln::printdiagrammpdf(QFont pfont, Q3StrList astrlist)
{
//  QPrinter *print = new QPrinter(QPrinter::PrinterResolution);
  QPrinter *print = new QPrinter();
  int xp = 40;
  int yp = 0;
  int zeilenabstand = 20;
  int ypmerk;
  unsigned int i;
  QString qs, qs1;
  QFont afont;
  double mx;
  int my;
  
  #ifdef LDEBUG
  qDebug("WidgetWobbeln::printdiagrammpdf()");
  #endif
  print->setOutputFormat(QPrinter::PdfFormat);
  print->setPageSize(QPrinter::A4);
  print->setOrientation(QPrinter::Portrait);
  QString s = QFileDialog::getSaveFileName(this, tr("PDF Speichern"),
                    "out.pdf",tr("PDF (*.pdf *.PDF)"));
  //Datei ueberpruefen ob Sufix vorhanden
  if((s.find(".")== -1)) s += ".pdf";

  print->setOutputFileName(s);
  QDateTime dt = QDateTime::currentDateTime();
  qs1 = dt.toString("dd MMMM yyyy, hh:mm");
  afont = pfont;
  refreshPixmap();
  repaint();
  QPainter p(print);
//  QPaintDeviceMetrics metrics(p);
  //Druckblattbreite ermitteln
  mx = print->width();
  //Druckblatthoehe ermitteln
  my = print->height();
//  qDebug("breite=%f hoehe=%i", mx, my);
//  qDebug("breite=%i hoehe=%i",print->widthMM(), print->heightMM());
  //linken Druckrand abziehen
  mx = mx - xp;
  //breite des Anzeigefensters der Grafik
  double px = this->rect().width();
  
  mx = mx/px * 0.8;
  p.setFont(pfont);
  qs = "NWT 4 Linux & Windows  " + qs1;
  yp += zeilenabstand;
  yp += zeilenabstand;
  p.drawText(xp, yp, qs);
  yp += zeilenabstand;
  p.drawLine(xp, yp, print->width()-xp, yp);
  yp += zeilenabstand;
  qs.sprintf(tr("Startfrequenz: %3.6f MHz; Endfrequenz: %3.6f MHz"), 
             double(wobbeldaten.anfangsfrequenz)/1000000.0, 
             double(((wobbeldaten.schritte - 1) * wobbeldaten.schrittfrequenz)+
             wobbeldaten.anfangsfrequenz)/1000000.0);
  p.drawText(xp, yp, qs);
  yp += zeilenabstand;
  qs.sprintf(tr("Schrittweite: %4.3f kHz; Messpunkte: %4i"), 
             double(wobbeldaten.schrittfrequenz)/1000.0, wobbeldaten.schritte);
  p.drawText(xp, yp, qs);
  yp += zeilenabstand;
  //Linie ueber der Grafik
  p.drawLine(xp, yp, print->width()-xp, yp);
  yp += zeilenabstand;
  //Auf richtige Groesse bringen
//  p.scale(mx, mx * 0.9);
  p.drawPixmap(int(xp), int(yp), pix);
//  yp += int(this->rect().height() * mx)-50;
  yp += int(this->rect().height());
  //Groesse wieder restaurieren
//  p.scale(1/mx, 1/(mx * 0.9));
  //Linie unter dem Bild
  p.drawLine(xp, yp, print->width()-xp, yp);
  yp += zeilenabstand;
  ypmerk = yp;
  if(astrlist.count() > 0){
    yp += zeilenabstand;
//    qDebug("yp=%i ",yp);
    qs = astrlist.first();
    p.drawText(xp, yp, qs);
    for(i=1; i < astrlist.count(); i++){
      yp += zeilenabstand;
//      qDebug("yp=%i xp=%i", yp, xp);
      if((yp + zeilenabstand) > (int)my){
        yp = ypmerk;
        xp = xp + (print->width() / 3);
        yp += zeilenabstand;
      }
      qs = astrlist.next();
      p.drawText(xp,yp, qs);
    }
    yp += zeilenabstand;
    //Abschlusslinie
//    p.drawLine(xp, yp, print->width()-xp, yp);
  }
}

