//
// C++ Implementation: optiondlg
//
// Description: 
//
//
// Author: Andreas Lindenau <DL4JAL@darc.de>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <qdialog.h>
#include <QColorDialog>
#include <QColor>
#include <QPainter>

#include "optiondlg.h"
#include "modem.h"
#include "tooltipodlg.h"


//#####################################################################################
// Class fuer Option
//#####################################################################################
odlg::odlg(QWidget* parent, const char* name, bool modal): QDialog(parent, name, modal)
{
  this->resize(450,510);
  this->setMinimumSize(0,0);
  ok = new QPushButton("OK", this);
  ok->setGeometry(10,10,100,30);
  connect(ok, SIGNAL(clicked()), SLOT(accept()));
  cancel = new QPushButton("Abbruch", this);
  cancel->setGeometry(10,50,100,30);
  connect(cancel, SIGNAL(clicked()), SLOT(reject()));
  
  eichfrequ = new QGroupBox(this);
  eichfrequ->setGeometry(150,10,270,110);
  eichfrequ->setTitle("Eichfrequenzen (nur bei Eichkorrektur)");
  label1 = new QLabel(eichfrequ);
  label1->setGeometry(10,25,120,30);
  label1->setText("Startfrequenz (Hz)");
  label1->setAlignment(Qt::AlignRight);
  label2 = new QLabel(eichfrequ);
  label2->setGeometry(10,65,120,30);
  label2->setText("Endfrequenz (Hz)");
  label2->setAlignment(Qt::AlignRight);
  eanfang = new QLineEdit(eichfrequ);
  eanfang->setGeometry(140,20,110,30);
  eende = new QLineEdit(eichfrequ);
  eende->setGeometry(140,60,110,30);

  ddstakt = new QGroupBox(this);
  ddstakt->setGeometry(150,130,270,100);
  ddstakt->setTitle("DDS Taktfrequenz");
  label3 = new QLabel(ddstakt);
  label3->setGeometry(10,25,100,30);
  label3->setText("DDS Takt (Hz):");
  label3->setAlignment(Qt::AlignRight);
  eddstakt = new QLineEdit(ddstakt);
  eddstakt->setGeometry(130,20,120,30);
  label9 = new QLabel(ddstakt);
  label9->setGeometry(10,65,100,30);
  label9->setText("DDS Mode:");
  label9->setAlignment(Qt::AlignRight);
  cpll = new QComboBox(ddstakt);
  cpll->setGeometry(130,60,120,30);
  cpll->insertItem("");
  cpll->insertItem("ohne PLL");
  cpll->insertItem("mit PLL 2x");
  cpll->insertItem("mit PLL 3x");
  cpll->insertItem("mit PLL 4x");
  cpll->insertItem("mit PLL 5x");
  cpll->insertItem("mit PLL 6x");
  cpll->insertItem("mit PLL 7x");
  cpll->insertItem("mit PLL 8x");
  cpll->insertItem("mit PLL 9x");
  cpll->insertItem("mit PLL 10x");
  cpll->insertItem("mit PLL 11x");
  cpll->insertItem("mit PLL 12x");
  cpll->insertItem("mit PLL 13x");
  cpll->insertItem("mit PLL 14x");
  cpll->insertItem("mit PLL 15x");
  cpll->insertItem("mit PLL 16x");
  cpll->insertItem("mit PLL 17x");
  cpll->insertItem("mit PLL 18x");
  cpll->insertItem("mit PLL 19x");
  cpll->insertItem("mit PLL 20x");

  label9->setEnabled(false);
  cpll->setEnabled(false);

  gtty = new QGroupBox(this);
  gtty->setGeometry(150,240,270,70);
  gtty->setTitle("Serielle Schnittstelle");
  label4 = new QLabel(gtty);
  label4->setGeometry(10,20,120,30);
  label4->setText("Schnittstelle:");
  ctty = new QComboBox(gtty);
  ctty->setGeometry(130,20,120,30);
  ctty->insertItem("");
  ctty->insertItem(schnittstelle1);
  ctty->insertItem(schnittstelle2);
  ctty->insertItem(schnittstelle3);
  ctty->insertItem(schnittstelle4);
  ctty->insertItem(schnittstelle5);
  ctty->insertItem(schnittstelle6);
  ctty->insertItem(schnittstelle7);
  ctty->insertItem(schnittstelle8);

  geich = new QGroupBox(this);
  geich->setGeometry(10,90,110,90);
  geich->setTitle("Eichkorr./D-Glied");
  eich1 = new QCheckBox(geich);
  eich1->setGeometry(10,15,90,25);
  eich1->setText("Kanal1");
  eich2 = new QCheckBox(geich);
  eich2->setGeometry(10,40,90,25);
  eich2->setText("Kanal2");
  faeich = new QCheckBox(geich);
  faeich->setGeometry(10,65,90,25);
  faeich->setText("FA-Daempf.");
//  faeich->setEnabled(false);
  
  geinkanalig = new QGroupBox(this);
  geinkanalig->setGeometry(10,190,110,60);
  geinkanalig->setTitle("Kanaele");
  boxeinkanalig = new QCheckBox(geinkanalig);
  boxeinkanalig->setGeometry(10,20,90,30);
  boxeinkanalig->setText("Einkanalig");
  
  gswriteration = new QGroupBox(this);
  gswriteration->setGeometry(10,255,110,60);
  gswriteration->setTitle("SWV Iteration");
  boxiteration = new QCheckBox(gswriteration);
  boxiteration->setGeometry(10,20,90,30);
  boxiteration->setText("math. Korr.");

  fname = new QGroupBox(this);
  fname->setGeometry(10,320,300,85);
  fname->setTitle("Default Dateinamen");
  label5 = new QLabel(fname);
  label5->setGeometry(10,25,140,30);
  label5->setText("Sonde Kanal 1");
  label5->setAlignment(Qt::AlignRight);
  esonde1 = new QLineEdit(fname);
  esonde1->setGeometry(155,20,120,25);
  label6 = new QLabel(fname);
  label6->setGeometry(10,55,140,30);
  label6->setText("Sonde Kanal 2");
  label6->setAlignment(Qt::AlignRight);
  esonde2 = new QLineEdit(fname);
  esonde2->setGeometry(155,50,120,25);

  fgrenzen = new QGroupBox(this);
  fgrenzen->setGeometry(10,410,300,85);
  fgrenzen->setTitle("Frequenzgrenzen");
  labelwobmax = new QLabel(fgrenzen);
  labelwobmax->setGeometry(10,25,140,30);
  labelwobmax->setText("max. Wobbel (Hz)");
  labelwobmax->setAlignment(Qt::AlignRight);
  wobmax = new QLineEdit(fgrenzen);
  wobmax->setGeometry(155,20,120,25);
  labelvfomax = new QLabel(fgrenzen);
  labelvfomax->setGeometry(10,55,140,30);
  labelvfomax->setText("max. VFO (Hz)");
  labelvfomax->setAlignment(Qt::AlignRight);
  vfomax = new QLineEdit(fgrenzen);
  vfomax->setGeometry(155,50,120,25);

  buttoncolor1 = new QPushButton("Color Kanal1", this);
  buttoncolor1->setGeometry(320,327,100,30);
  connect(buttoncolor1, SIGNAL(clicked()), SLOT(setColor1()));
  buttoncolor2 = new QPushButton("Color Kanal2", this);
  buttoncolor2->setGeometry(320,370,100,30);
  connect(buttoncolor2, SIGNAL(clicked()), SLOT(setColor2()));
};

void odlg::setdaten(OEichen aeich){
  QString s;

  oeich = aeich;
  s.sprintf("%li", oeich.eichanfang);
  eanfang->setText(s);
  s.sprintf("%li", oeich.eichende);
  eende->setText(s);
  s.sprintf("%9.0f", oeich.ddstakt);
  eddstakt->setText(s);
  s.sprintf("%9.0f", oeich.maxwobbel);
  wobmax->setText(s);
  s.sprintf("%9.0f", oeich.maxvfo);
  vfomax->setText(s);
  ctty->setCurrentText(oeich.str_tty);
  eich1->setChecked(oeich.eichk1);
  eich2->setChecked(oeich.eichk2);
  faeich->setChecked(oeich.bfaeich);
  boxiteration->setChecked(oeich.bswriteration);
  boxeinkanalig->setChecked(oeich.einkanalig);
  esonde1->setText(oeich.strsonde1);
  esonde2->setText(oeich.strsonde2);
  cpll->setCurrentIndex(oeich.pll);
  if(oeich.pllmodeenable){
    label9->setText("DDS Mode:");
    label9->setEnabled(true);
    cpll->setEnabled(true);
  }else{
    label9->setText("nicht aktiv!");
  }
  // Button Farbr setzen
  QColor color = oeich.penkanal1.color();
  QPalette palette = buttoncolor1->palette();
  palette.setColor(QPalette::ButtonText, color);
  buttoncolor1->setPalette(palette);
  color = oeich.penkanal2.color();
  palette = buttoncolor2->palette();
  palette.setColor(QPalette::ButtonText, color);
  buttoncolor2->setPalette(palette);
};

OEichen odlg::getdaten(){
  QString s;

  s = eanfang->text();
  oeich.eichanfang = s.toLong();
  s = eende->text();
  oeich.eichende = s.toLong();
  s = eddstakt->text();
  oeich.ddstakt = s.toDouble();
  s = wobmax->text();
  oeich.maxwobbel = s.toDouble();
  s = vfomax->text();
  oeich.maxvfo = s.toDouble();
  oeich.str_tty = ctty->currentText();
  oeich.eichk1 = eich1->isChecked();
  oeich.eichk2 = eich2->isChecked();
  oeich.bfaeich = faeich->isChecked();
  oeich.einkanalig = boxeinkanalig->isChecked();
  oeich.bswriteration = boxiteration->isChecked();
  oeich.strsonde1 = esonde1->text();
  oeich.strsonde2 = esonde2->text();
  oeich.pll = cpll->currentIndex();
  return oeich;
};

void odlg::tip(bool btip)
{
  QString eichkorrk1_tip(tip_eichkorrk1);
  QString einkanalig_tip(tip_einkanalig);
  QString mathkorr_tip(tip_mathkorr);
  QString defdatei_tip(tip_defdatei);
  QString fmaxwobbel_tip(tip_fmaxwobbel);
  QString fmaxvfo_tip(tip_fmaxvfo);
  QString serielle_tip(tip_serielle);
  QString pll_tip(tip_pll);
  QString ddstakt_tip(tip_ddstakt);
  QString eichend_tip(tip_eichend);
  QString eichanf_tip(tip_eichanf);
  QString color_tip(tip_color);

  if(btip){
    eich1->setToolTip(eichkorrk1_tip);
    eich2->setToolTip(eichkorrk1_tip);
    boxeinkanalig->setToolTip(einkanalig_tip);
    boxiteration->setToolTip(mathkorr_tip);
    esonde1->setToolTip(defdatei_tip);
    esonde2->setToolTip(defdatei_tip);
    wobmax->setToolTip(fmaxwobbel_tip);
    vfomax->setToolTip(fmaxvfo_tip);
    ctty->setToolTip(serielle_tip);
    cpll->setToolTip(pll_tip);
    eddstakt->setToolTip(ddstakt_tip);
    eende->setToolTip(eichend_tip);
    eanfang->setToolTip(eichanf_tip);
    buttoncolor1->setToolTip(color_tip);
    buttoncolor2->setToolTip(color_tip);
  }else{
    eich1->setToolTip("");
    eich2->setToolTip("");
    boxeinkanalig->setToolTip("");
    boxiteration->setToolTip("");
    esonde1->setToolTip("");
    esonde2->setToolTip("");
    wobmax->setToolTip("");
    vfomax->setToolTip("");
    ctty->setToolTip("");
    cpll->setToolTip("");
    eddstakt->setToolTip("");
    eende->setToolTip("");
    eanfang->setToolTip("");
    buttoncolor1->setToolTip("");
    buttoncolor2->setToolTip("");
  }
}

void odlg::setColor1(){
  bool ok;
  QColor color = oeich.penkanal1.color();
  QRgb rgb;
  rgb = color.rgb();
  qDebug("setColor1");
  color = QColorDialog::getRgba(rgb, &ok, this);
  if(ok){
    oeich.penkanal1.setColor(color);
    QPalette palette = buttoncolor1->palette();
    palette.setColor(QPalette::Active, QPalette::Button, color);
    buttoncolor1->setPalette(palette);
  }
}

void odlg::setColor2(){
  bool ok;
  QColor color = oeich.penkanal2.color();
  QRgb rgb;
  rgb = color.rgb();
  qDebug("setColor2");
  color = QColorDialog::getRgba(rgb, &ok, this);
  if(ok){
    oeich.penkanal2.setColor(color);
    QPalette palette = buttoncolor2->palette();
    palette.setColor(QPalette::Active, QPalette::Button, color);
    buttoncolor2->setPalette(palette);
  }
}

