/***************************************************************************
                          nwt7linux.h  -  description
                             -------------------
    begin                : Don Aug  7 07:29:43 CEST 2003
    copyright            : (C) 2003 by Andreas Lindenau
    email                : DL4JAL@darc.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//#define LDEBUG

#ifndef NWT7LINUX_H
#define NWT7LINUX_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QTabWidget>
#include <QDial>
#include <QLCDNumber>
#include <QRadioButton>
#include <QLineEdit>
#include <QSpinBox>
#include <QFileDialog>
#include <QPainter>
#include <QPixmap>
#include <QCheckBox>
#include <QObject>
#include <QProgressBar>
#include <QDialog>
#include <Q3MultiLineEdit>
#include <QFile>
#include <QFontDialog>
#include <QString>
#include <QDir>
#include <QTextEdit>
#include <QComboBox>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define _TTY_POSIX_
#include "modem.h"
//#include "qextserialport.h"
#include "widgetwobbeln.h"
#include "optiondlg.h"
#include "fmarkedlg.h"
#include "firmwidget.h"
#include "wkmanager.h"

class QLabel;
class QMenuBar;

enum tmenuenable{
  emDrucken,
  emDruckenpdf,
  emLayoutlabel,
  emBeenden,
  emEinstellungLaden,
  emEinstellungSichern,
  emInfo,
  emOption,
  emFirmware,
  emKurvenLaden,
  emKurvenSichern,
  emWobbeln,
  emEinmal,
  emStop,
  emEichenK1,
  emEichenK2,
  emSondeLadenK1,
  emSondeLadenK2,
  emSondeSpeichernK1,
  emSondeSpeichernK2,
  emFontInfo,
  emFrequenzmarke,
  emVFODreh1,
  emVFODreh2,
  emVFODreh3,
  emWattFont,
  emWattEichenK1,
  emWattEichenK2,
  emWattSchreiben,
  emTabelleSpeichern,
  emDaempfungdefault,
  emVersion,
  emTooltip,
#ifdef fzaehlen
  emZaehlen,
#endif
  emmenuDatei,
  emmenuEinstellung,
  emmenuKurven,
  emmenuwobbel,
  emmenuvfo,
  emmenumessen
#ifdef fzaehlen
  ,emmenuzaehlen
#endif
   
 };

//Konstande fuer Messfenster

const int maxmessstep=600;

/** Nwt7linux is the base class of the project */
class Nwt7linux : public QTabWidget
{
  Q_OBJECT 
  public:
    /** construtor */
    Nwt7linux(QWidget* parent=0);
    /** destructor */
    ~Nwt7linux();

    Modem *picmodem;

//////////////////////////////////////////////////////////////////////////////
//Objecte fuer Messen
    QWidget *nwt7messen;
    QProgressBar *progressbarmessk1;
    QProgressBar *progressbarmessk2;
    QTimer *messtimer;
    QLabel *messlabel1;
    QLabel *messlabel2;
    QLabel *messlabel3;
    QLabel *messlabel4;
    QLabel *messlabel5;
    QLabel *messlabel6;
    Q3MultiLineEdit *messedit;
    QPushButton *buttonmess;
    QPushButton *buttonmesssave;
    QComboBox *ldaempfungk1;
    QComboBox *ldaempfungk2;
    QLabel *labelldaempfungk1;
    QLabel *labelldaempfungk2;

//////////////////////////////////////////////////////////////////////////////
//Objecte fuer Wobbeln
    owkmanager *wkmanager;
    QWidget *nwt7wobbeln;
    WidgetWobbeln *grafik;
    QLineEdit *editanfang,
              *editende,
              *editschrittweite,
              *editschritte,
              *editvfo;

    QLabel *labelanfang,
           *labelende,
           *labelschrittweite,
           *labelschritte,
           *labellupe,
           *labelvfo;

    QCheckBox *checkboxk1,
              *checkboxk2,
              *checkbox3db,
              *checkbox6db,
              *checkboxgrafik;

    QPushButton *buttonwobbeln,
                *buttoneinmal,
                *buttonlupeminus,
                *buttonlupeplus,
                *buttonstop;

    QTimer *wobbeltimer;
    QProgressBar *progressbar;
    Q3MultiLineEdit *mledit;
    QComboBox *daempfung1,
              *daempfung2,
              *betriebsart,
              *aufloesung,
              *boxdbshift1,
              *boxdbshift2,
              *boxkursornr,
              *boxwattoffset1,
              *boxwattoffset2;

    QLabel *labelboxdbshift1;
    QLabel *labelboxdbshift2;
    QLabel *labelkursornr;
    QLabel *labeldaempfung;
    QLabel *labeldaempfung1;
    QLabel *labelbetriebsart;
    QLabel *labelaufloesung;
    enumbetriebsart ebetriebsart; //Betriebart wobbeln,swr,swrneu ....

    QLabel *labela_100;
    QLineEdit *edita_100;
    QLabel *labelkabellaenge;
    QLineEdit *editkabellaenge;

//////////////////////////////////////////////////////////////////////////////
//Objecte fuer VFO
    QWidget *nwt7vfo;
    QTimer *vfotimer;
    QDial *Dial1mhz;
    QDial *Dial1khz;
    QDial *Dial1hz;
    QLCDNumber *LCD1;
    QLCDNumber *LCD2;
    QLCDNumber *LCD3;
    QLCDNumber *LCD4;
    QLCDNumber *LCD5;
    QRadioButton *rb1;
    QRadioButton *rb2;
    QRadioButton *rb3;
    QRadioButton *rb4;
    QRadioButton *rb5;
    QLineEdit *editzf;
    QCheckBox *checkboxzf;
    QCheckBox *checkboxiqvfo;
    QLabel *labelzf;
    QLabel *labelhz;
    QLabel *lmhz;
    QLabel *lkhz;
    QLabel *lhz;
    QLabel *mlabelk1;
    QLabel *mlabelk2;
    QFileDialog *IniFileDialog;
//    optiondlg *dlg;

    //interne Funktion zum errechnen und setzen der Positionen
    void grafiksetzen();

  signals:
    void sendeichdaten(teicharray);    
    void sendswreichdaten(tswreicharray);    
    void sendewobbeldaten(OWobbel);
    void sendewobbelkurve(OWobbel);
    void sendefrqmarken(tfmarken);
    void drucken(QFont, Q3StrList);
    void druckenpdf(QFont, Q3StrList);
    void setmenu(tmenuenable, bool);
    void setAppText(QString);
    void setWKursorNr(int);
        
  public slots:
    void menuanfangsetzen();
    void EinstellungLaden();
    void EinstellungSichern();
    void KurvenLaden();
    void KurvenSichern();
    void drucklabel();
    void druckediagramm();
    void druckediagrammpdf();
    void option();
    void firmupdate();
    void beenden();
    void version();
    void setAText(QString);
    void setShift();
    void setIQVFO();

    void clickwobbeln(); //Wobbeln starten
    void clickwobbelneinmal(); //Einen Durchlauf wobbeln
    void clickwobbelnstop(); //Wobbeln stoppen
    void eichenswr();
    void eichenkanal1();
    void eichenkanal2();
    void messsondeladen1();
    void messsondeladen2();
    void messsondespeichern1(QString);
    void messsondespeichern2(QString);
    void infosetfont();
    void setFrequenzmarken();
    void openKurvenManager();
    void getwkmk1();
    void getwkmk2();
    void getwkmk3();
    void getwkmk4();
    void resetKursor(int);
    
    void messsetfont();
    void meichenk1();
    void meichenk2();
    void tabelleschreiben();
    void tabellespeichern();
    void setDaempfungdefault();
    void mleditloeschen();
    void mleditinsert(QString);

//Funktionen fuer VFO
    void drehgeber1focus();
    void drehgeber2focus();
    void drehgeber3focus();
    void setDialfocus();
    void setDaempfungItem();

    void fzaehlen();

  public:
    void tip(bool);
    QString getconffilename();
    void setconffilename(const QString fname);

  private:
    double woffset1, woffset2;
    bool btip;
    tfmarken frqmarken;
    QString configfilename;
    OWobbel wobdatenmerk;
    bool bkurvegeladen;
    bool bdauerwobbeln;
    int olddial1hz;
    int olddial1khz;
    QDir homedir;
    QString infotext;
    unsigned char linienr;
    bool beichenswr;
    bool beichenswrneu;
    bool beichen40;
    bool beichen0;
    double ym_40db;
    double ym_0db;
    double ym_gen;
    double ym_daempf;
    double KursorFrequenz;
    bool wobbelstop;
    bool bttyOpen;
    int lcdauswahl;
    QMenuBar *menu;
    OWobbel wobdaten;
    teicharray neicharray;
    tswreicharray nswreicharray;
    char ttybuffer[maxmesspunkte * 4];
    int ttyindex;
    bool b10bit;
    int synclevel;
    int abbruchlevel;
    bool bersterstart;
    bool bmessen;
    bool bmeichenk1_0db;
    bool bmeichenk1_20db;
    bool bmeichenk2_0db;
    bool bmeichenk2_20db;
    QFont messfont;
    QFont infofont;
    QFont printfont;
    bool btabelleschreiben;
    Q3StrList bstrlist;
    QString layoutlabel;
    OEichen weichen;
    double messungk1, messungk2;
    double messungk1alt, messungk2alt;
    int messcounter;
    bool bdatenruecklauf;
    
    QString delPath(const QDir &s);
    void dialsetzen();
    void configurationladen(const QString &filename);
    void configurationspeichern(const QString &filename);
    void messsondenfilek1laden(const QString &filename);
    void messsondenfilek2laden(const QString &filename);
    void setmessen();
    void defaultlesenrtty();
    double linenormalisieren(const QString line);
    int counterspitzek1;
    int counterspitzek2;

  private slots:
    void wobbelungueltig();
    void setDaempfung(int index);
    void setBetriebsart(int index);
    void setAufloesung(int index);
/////////////////////////////////////////////////////////////////////////////
//Funktionen fuer Alles
    void tabumschalten(QWidget*);
    
/////////////////////////////////////////////////////////////////////////////
//Funktionen fuer Wobbeln
    void sendwobbeln();   //wobbelstring an NWT7 senden
    void checkboxk1_checked(bool);
    void checkboxk2_checked(bool);
//    void checkboxswr_checked(bool);
    
    void wobnormalisieren(); //Alle Eingaben pruefen
    void checkbox3db_checked(bool);
    void checkbox6db_checked(bool);
    void checkboxgrafik_checked(bool);
    void readanfang(double);
    void readende(double);
    void setKursorFrequenz(double);
    void setColorRedk1();
    void setColorBlackk1();
    void setColorRedk2();
    void setColorBlackk2();
    void swrantaendern();
    void clicklupeplus();
    void clicklupeminus();
    
/////////////////////////////////////////////////////////////////////////////

    void vfoedit();
    void LCDaendern();
    void setVfo();
    void senddaten();
    void readtty();
    void lcd1clicked();
    void lcd2clicked();
    void lcd3clicked();
    void lcd4clicked();
    void lcd5clicked();
    void fsendewobbeldaten();

/////////////////////////////////////////////////////////////////////////////
//Funktionen fuers Messen
    void getmessdaten();
    void setwattoffset1(int);
    void setwattoffset2(int);
/////////////////////////////////////////////////////////////////////////////
//
  protected:
   //virtuelle Funktion muss neu definiert werden. Wird aufgerufen bei
   //Groessenaenderung des Windowshauptfensters
   virtual void keyPressEvent( QKeyEvent *event );
//   virtual void paintEvent( QPaintEvent * );

};

#endif
