/***************************************************************************
                          nwt7linux.cpp  -  description
                             -------------------
    begin                : Don Aug  7 07:29:43 CEST 2003
    copyright            : (C) 2003 by Andreas Lindenau
    email                : DL4JAL@darc.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <QPushButton>
#include <QMenuBar>
#include <QTimer>
#include <QLineEdit>
#include <QLabel>
#include <QSpinBox>
#include <QFileDialog>
#include <QPainter>
#include <QPixmap>
#include <QCheckBox>
#include <QProgressBar>
#include <QDir>
#include <QMessageBox>
#include <QInputDialog>
#include <QDialog>
#include <QPalette>
#include <QColor>

#include <math.h>
#include <stdlib.h>

#include "nwt7linux.h"
#include "widgetwobbeln.h"
#include "configfile.h"
#include "optiondlg.h"
#include "fmarkedlg.h"
#include "firmwidget.h"
#include "tooltip.h"

//#define LDEBUG

Nwt7linux::Nwt7linux(QWidget *parent) : QTabWidget(parent)
{

///////////////////////////////////////////////////////////////////////////////
//Schnittstelle zum NWT7 erzeugen erzeugen fuer alle Widgets
//  picmodem = new QextSerialPort("/dev/ttyS0");
//  delete picmodem;
  picmodem = new Modem();
//  picmodem->opentty(weichen.str_tty);
  QObject::connect( picmodem, SIGNAL(setTtyText(QString)), this, SLOT(setAText(QString)));
//  bttyOpen = picmodem->opentty(weichen.str_tty);
///////////////////////////////////////////////////////////////////////////////
// Wobbel Widget
// Testbereich von 1MHz bis 100MHz
  wobdaten.schritte = 1000;
  wobdaten.anfangsfrequenz = 1000000;
  wobdaten.schrittfrequenz = 29000;
  wobdaten.aufloesung = 4; //Aufloesung nur fuer swr
  wobdaten.penkanal1 = QPen( Qt::red, 0, Qt::SolidLine);
  wobdaten.penkanal2 = QPen( Qt::green, 0, Qt::SolidLine);
  
  wobbelungueltig();
  wobdaten.mousesperre = true; //Kursoraktivitaeten sperren
  KursorFrequenz = 0.0;

  nwt7wobbeln = new QWidget();
  addTab(nwt7wobbeln, tr("Wobbeln"));
  
  grafik = new WidgetWobbeln(nwt7wobbeln);
  grafik->setWobbeldaten(wobdaten);
  //SIGNAL werden Wobbeldaten an das Grafikfenster uebergeben
  QObject::connect( this, SIGNAL(sendeichdaten(teicharray)), grafik, SLOT(empfangeichdaten(teicharray)));
  QObject::connect( this, SIGNAL(sendswreichdaten(tswreicharray)), grafik, SLOT(empfangswreichdaten(tswreicharray)));
  QObject::connect( this, SIGNAL(sendefrqmarken(tfmarken)), grafik, SLOT(empfangfrqmarken(tfmarken)));
  
  QObject::connect( this, SIGNAL(sendewobbeldaten(OWobbel)), grafik, SLOT(wobbeldatenempfang(OWobbel)));
  QObject::connect( this, SIGNAL(sendewobbelkurve(OWobbel)), grafik, SLOT(wobbeldatenkurve(OWobbel)));
  //Signal zum Ausdrucken der Grafik im Widget Grafik
  QObject::connect( this, SIGNAL(drucken(QFont, Q3StrList)), grafik, SLOT(printdiagramm(QFont,Q3StrList)));
  //Signal zum Ausdrucken der Grafik im Widget Grafik als PDF
  QObject::connect( this, SIGNAL(druckenpdf(QFont, Q3StrList)), grafik, SLOT(printdiagrammpdf(QFont,Q3StrList)));
  editanfang = new QLineEdit(nwt7wobbeln);
  //Alle Editierfenster abfragen und abgleichen
  QObject::connect( editanfang, SIGNAL(returnPressed ()), this, SLOT(wobnormalisieren()));
  editende = new QLineEdit(nwt7wobbeln);
  QObject::connect( editende, SIGNAL(returnPressed ()), this, SLOT(wobnormalisieren()));
  editschritte = new QLineEdit(nwt7wobbeln);
  QObject::connect( editschritte, SIGNAL(returnPressed ()), this, SLOT(wobnormalisieren()));
  editschrittweite = new QLineEdit(nwt7wobbeln);
  editschrittweite->setEnabled(false);
  QObject::connect( editschrittweite, SIGNAL(returnPressed ()), this, SLOT(wobnormalisieren()));

  labelanfang = new QLabel(tr("Hz Anfang"), nwt7wobbeln);
  labelende = new QLabel(tr("Hz Ende"), nwt7wobbeln);
  labelschrittweite = new QLabel(tr("Hz Weite"), nwt7wobbeln);
  labelschritte = new QLabel(tr("Messpunkte"), nwt7wobbeln);
  
  checkboxk1 = new QCheckBox(nwt7wobbeln);
  checkboxk1->setText(tr("Kanal 1"));
  checkboxk1->setChecked(true);
  QObject::connect( checkboxk1, SIGNAL( toggled (bool)), this, SLOT(checkboxk1_checked(bool)));
  
  checkboxk2 = new QCheckBox(nwt7wobbeln);
  checkboxk2->setText(tr("Kanal 2"));
  checkboxk2->setChecked(true);
  QObject::connect( checkboxk2, SIGNAL( toggled (bool)), this, SLOT(checkboxk2_checked(bool)));

  checkbox3db = new QCheckBox(nwt7wobbeln);
  checkbox3db->setText(tr("Bandbreite 3dB/Q"));
  checkbox3db->setChecked(false);
  QObject::connect( checkbox3db, SIGNAL( toggled (bool)), this, SLOT(checkbox3db_checked(bool)));

  checkbox6db = new QCheckBox(nwt7wobbeln);
  checkbox6db->setText(tr("Bandbreite 6dB/60dB/Shape"));
  checkbox6db->setChecked(false);
  QObject::connect( checkbox6db, SIGNAL( toggled (bool)), this, SLOT(checkbox6db_checked(bool)));

  checkboxgrafik = new QCheckBox(nwt7wobbeln);
  checkboxgrafik->setText(tr("Grafik"));
  checkboxgrafik->setChecked(false);
  QObject::connect( checkboxgrafik, SIGNAL( toggled (bool)), this, SLOT(checkboxgrafik_checked(bool)));

  betriebsart = new QComboBox(nwt7wobbeln);
  betriebsart->addItem("Wobbeln");
  betriebsart->addItem("SWV");
  betriebsart->addItem("SWV_ant");
  betriebsart->addItem("Z-Impedanz");
  QObject::connect( betriebsart, SIGNAL( currentIndexChanged(int)), this, SLOT(setBetriebsart(int)));
  labelbetriebsart = new QLabel(tr("Betriebsart"),nwt7wobbeln);

  aufloesung = new QComboBox(nwt7wobbeln);
  aufloesung->addItem("default");
  aufloesung->addItem("max SWV 2.0");
  aufloesung->addItem("max SWV 3.0");
  aufloesung->addItem("max SWV 4.0");
  aufloesung->addItem("max SWV 5.0");
  aufloesung->addItem("max SWV 6.0");
  aufloesung->addItem("max SWV 7.0");
  aufloesung->addItem("max SWV 8.0");
  aufloesung->addItem("max SWV 9.0");
  aufloesung->addItem("max SWV 10.0");
  QObject::connect( aufloesung, SIGNAL( currentIndexChanged(int)), this, SLOT(setAufloesung(int)));
  labelaufloesung = new QLabel(tr("Aufloesung SWV"),nwt7wobbeln);
  aufloesung->setEnabled(false);
  labelaufloesung->setEnabled(false);

  labelboxdbshift1 = new QLabel(tr("Shift K1"),nwt7wobbeln);
  labelboxdbshift2 = new QLabel(tr("K2 (dB)"),nwt7wobbeln);
  boxdbshift1 = new QComboBox(nwt7wobbeln);
  boxdbshift1->setEditable(true);
  boxdbshift1->addItem("20");
  boxdbshift1->addItem("19");
  boxdbshift1->addItem("18");
  boxdbshift1->addItem("17");
  boxdbshift1->addItem("16");
  boxdbshift1->addItem("15");
  boxdbshift1->addItem("14");
  boxdbshift1->addItem("13");
  boxdbshift1->addItem("12");
  boxdbshift1->addItem("11");
  boxdbshift1->addItem("10");
  boxdbshift1->addItem("9");
  boxdbshift1->addItem("8");
  boxdbshift1->addItem("7");
  boxdbshift1->addItem("6");
  boxdbshift1->addItem("5");
  boxdbshift1->addItem("4");
  boxdbshift1->addItem("3");
  boxdbshift1->addItem("2");
  boxdbshift1->addItem("1");
  boxdbshift1->addItem("0");
  boxdbshift1->addItem("-1");
  boxdbshift1->addItem("-2");
  boxdbshift1->addItem("-3");
  boxdbshift1->addItem("-4");
  boxdbshift1->addItem("-5");
  boxdbshift1->addItem("-6");
  boxdbshift1->addItem("-7");
  boxdbshift1->addItem("-8");
  boxdbshift1->addItem("-9");
  boxdbshift1->addItem("-10");
  boxdbshift1->setCurrentIndex(20);
  boxdbshift2 = new QComboBox(nwt7wobbeln);
  boxdbshift2->setEditable(true);
  boxdbshift2->addItem("20");
  boxdbshift2->addItem("19");
  boxdbshift2->addItem("18");
  boxdbshift2->addItem("17");
  boxdbshift2->addItem("16");
  boxdbshift2->addItem("15");
  boxdbshift2->addItem("14");
  boxdbshift2->addItem("13");
  boxdbshift2->addItem("12");
  boxdbshift2->addItem("11");
  boxdbshift2->addItem("10");
  boxdbshift2->addItem("9");
  boxdbshift2->addItem("8");
  boxdbshift2->addItem("7");
  boxdbshift2->addItem("6");
  boxdbshift2->addItem("5");
  boxdbshift2->addItem("4");
  boxdbshift2->addItem("3");
  boxdbshift2->addItem("2");
  boxdbshift2->addItem("1");
  boxdbshift2->addItem("0");
  boxdbshift2->addItem("-1");
  boxdbshift2->addItem("-2");
  boxdbshift2->addItem("-3");
  boxdbshift2->addItem("-4");
  boxdbshift2->addItem("-5");
  boxdbshift2->addItem("-6");
  boxdbshift2->addItem("-7");
  boxdbshift2->addItem("-8");
  boxdbshift2->addItem("-9");
  boxdbshift2->addItem("-10");
  boxdbshift2->setCurrentIndex(20);
  QObject::connect( boxdbshift1, SIGNAL( currentIndexChanged(int)), this, SLOT(setShift()));
  QObject::connect( boxdbshift2, SIGNAL( currentIndexChanged(int)), this, SLOT(setShift()));

  labelkursornr = new QLabel(tr("Kursor #"),nwt7wobbeln);
  boxkursornr = new QComboBox(nwt7wobbeln);
  boxkursornr->addItem("5");
  boxkursornr->addItem("4");
  boxkursornr->addItem("3");
  boxkursornr->addItem("2");
  boxkursornr->addItem("1");
  boxkursornr->setCurrentIndex(4);
  QObject::connect( boxkursornr, SIGNAL( currentIndexChanged(int)), grafik, SLOT(setWKursorNr(int)));
  QObject::connect( grafik, SIGNAL( resetKursor(int)), this, SLOT(resetKursor(int)));
  
  edita_100 = new QLineEdit(nwt7wobbeln);
  QObject::connect( edita_100, SIGNAL(textChanged ( const QString & )), this, SLOT(swrantaendern()));
  edita_100->setEnabled(false);
  labela_100 = new QLabel(tr("Daempfung (100m)"),nwt7wobbeln);
  labela_100->setEnabled(false);
  editkabellaenge = new QLineEdit(nwt7wobbeln);
  QObject::connect( editkabellaenge, SIGNAL(textChanged ( const QString & )), this, SLOT(swrantaendern()));
  editkabellaenge->setEnabled(false);
  labelkabellaenge = new QLabel(tr("Kabellaenge (m)"),nwt7wobbeln);
  labelkabellaenge->setEnabled(false);

  daempfung1 = new QComboBox(nwt7wobbeln);
  QObject::connect( daempfung1, SIGNAL( currentIndexChanged(int)), this, SLOT(setDaempfung(int)));
  
  labeldaempfung = new QLabel(tr("Daempfungsglied"),nwt7wobbeln);
  
  wobdaten.bandbreite3db=false;
  wobdaten.bandbreite6db=false;

  if(checkboxk1->isChecked())wobdaten.bkanal1=true;
  if(checkboxk2->isChecked())wobdaten.bkanal2=true;
  if(checkbox3db->isChecked())wobdaten.bandbreite3db=true;
  if(checkbox6db->isChecked())wobdaten.bandbreite6db=true;

  buttonwobbeln = new QPushButton(tr("Wobbeln"), nwt7wobbeln);
  buttonwobbeln->setEnabled(true);
  QObject::connect( buttonwobbeln, SIGNAL( clicked()), this, SLOT(clickwobbeln()));
  
  buttoneinmal = new QPushButton(tr("Einmal"), nwt7wobbeln);
  buttoneinmal->setEnabled(true);
  QObject::connect( buttoneinmal, SIGNAL( clicked()), this, SLOT(clickwobbelneinmal()));
  
  buttonstop = new QPushButton(tr("Stop"), nwt7wobbeln);
  buttonstop->setEnabled(false);
  QObject::connect( buttonstop, SIGNAL( clicked()), this, SLOT(clickwobbelnstop()));
  
  labellupe = new QLabel(tr("Frequenzzoom 2-fach"),nwt7wobbeln);
  labellupe->setEnabled(false);
  buttonlupeplus = new QPushButton(tr("+"), nwt7wobbeln);
  buttonlupeplus->setEnabled(false);
  QObject::connect( buttonlupeplus, SIGNAL( clicked()), this, SLOT(clicklupeplus()));
  
  buttonlupeminus = new QPushButton(tr("-"), nwt7wobbeln);
  buttonlupeminus->setEnabled(false);
  QObject::connect( buttonlupeminus, SIGNAL( clicked()), this, SLOT(clicklupeminus()));
  

  progressbar = new QProgressBar(nwt7wobbeln);
  progressbar->setTextVisible(false);

  mledit = new Q3MultiLineEdit(nwt7wobbeln);
  mledit->setReadOnly(true);
  //Signal vom Widget Grafik Loeschen des Multieditfenster
  QObject::connect( grafik, SIGNAL( multieditloeschen()), this, SLOT(mleditloeschen()));
  //Signal vom Widget Grafik Einfuegen von Text ins Multieditfenster
  QObject::connect( grafik, SIGNAL( multieditinsert(QString)), this, SLOT(mleditinsert(QString)));
  //mousezeiger bestimmt neue Anfangsfrequenz
  QObject::connect( grafik, SIGNAL( writeanfang(double)), this, SLOT(readanfang(double)));
  //mousezeiger bestimmt neue Endfrequenz
  QObject::connect( grafik, SIGNAL( writeende(double)), this, SLOT(readende(double)));
  QObject::connect( grafik, SIGNAL( setKursorFrequenz(double)), this, SLOT(setKursorFrequenz(double)));
  
  wobbeltimer = new QTimer(this);
  //Signal vom Wobbeltimer (Auslesen der RS232)
  QObject::connect( wobbeltimer, SIGNAL(timeout()), this, SLOT(readtty() ));
  
  wkmanager = new owkmanager(this,"Wobbelkurvenmanager", false);
  //Verbindung vom Wobbelmanager zum Grafikfenster fuer die Wobbeldaten
  connect(wkmanager, SIGNAL(wkmsendwobbel1(OWobbel)), grafik, SLOT(setKurve1(OWobbel)));
  connect(wkmanager, SIGNAL(wkmsendwobbel2(OWobbel)), grafik, SLOT(setKurve2(OWobbel)));
  connect(wkmanager, SIGNAL(wkmsendwobbel3(OWobbel)), grafik, SLOT(setKurve3(OWobbel)));
  connect(wkmanager, SIGNAL(wkmsendwobbel4(OWobbel)), grafik, SLOT(setKurve4(OWobbel)));
  //verbindung zum holen der Wobbeldaten aus dem Hauptfenster zum Wobbelmanager
  connect(wkmanager, SIGNAL(wkmgetwobbel1()), this, SLOT(getwkmk1()));
  connect(wkmanager, SIGNAL(wkmgetwobbel2()), this, SLOT(getwkmk2()));
  connect(wkmanager, SIGNAL(wkmgetwobbel3()), this, SLOT(getwkmk3()));
  connect(wkmanager, SIGNAL(wkmgetwobbel4()), this, SLOT(getwkmk4()));
  
///////////////////////////////////////////////////////////////////////////////
// VFO Widget
///////////////////////////////////////////////////////////////////////////////
  QPalette dp;
  dp.setColor(QPalette::Background, Qt::yellow);
  QPalette dpd;
  dpd.setColor(QPalette::Background, Qt::darkYellow);

  lcdauswahl = 1;
  nwt7vfo = new QWidget();
  addTab(nwt7vfo, "VFO");
  
  Dial1mhz = new QDial(0, 600, 1, 0, nwt7vfo, "1MHz");
  Dial1mhz->setPalette(dpd);
  //volle 360 Grad Drehwinkel
  Dial1mhz->setWrapping(true);
  //Slot zum aendern der LCDAnzeige
  QObject::connect( Dial1mhz, SIGNAL(valueChanged(int)), this, SLOT(LCDaendern()));
  //Slot zum aendern der VFO-Frequnz vfotimer starten
  QObject::connect( Dial1mhz, SIGNAL(valueChanged(int)), this, SLOT(setVfo()));

  Dial1khz = new QDial(0, 999, 1, 0, nwt7vfo, "1kHz");
  Dial1khz->setPalette(dpd);
  //volle 360 Grad Drehwinkel
  Dial1khz->setWrapping(true);
  //Slot zum aendern der LCDAnzeige
  QObject::connect( Dial1khz, SIGNAL(valueChanged(int)), this, SLOT(LCDaendern()));
  //Slot zum aendern der VFO-Frequnz vfotimer starten
  QObject::connect( Dial1khz, SIGNAL(valueChanged(int)), this, SLOT(setVfo()));

  Dial1hz = new QDial(0, 999, 1, 0, nwt7vfo, "1Hz");
  Dial1hz->setPalette(dp);
  //volle 360 Grad Drehwinkel
  Dial1hz->setWrapping(true);
  //Slot zum aendern der LCDAnzeige
  QObject::connect( Dial1hz, SIGNAL(valueChanged(int)), this, SLOT(LCDaendern()));
  //Slot zum aendern der VFO-Frequnz vfotimer starten
  QObject::connect( Dial1hz, SIGNAL(valueChanged(int)), this, SLOT(setVfo() ));
  
  editvfo = new QLineEdit(nwt7vfo);
  QObject::connect( editvfo, SIGNAL(returnPressed ()), this, SLOT(vfoedit()));
  labelvfo = new QLabel("in Hz",nwt7vfo);

  lmhz = new QLabel(tr("MHz"),nwt7vfo);
  lkhz = new QLabel(tr("kHz"),nwt7vfo);
  lhz = new QLabel(tr("Hz"),nwt7vfo);

  //LCD Anzeige 10 stellen mit punkt
  LCD1 = new QLCDNumber(10, nwt7vfo, "LCD1");
  //Hintergrung gelb
  LCD1->setPalette(dp);
  LCD1->setAutoFillBackground(true);
  LCD1->setBackgroundRole( QPalette::Background );
  
  //volle schwarze Zahlen
  LCD1->setSegmentStyle(QLCDNumber::Filled);
  //der Dezimalpunkt soll ganz wenig platz beanspruchen
  LCD1->setSmallDecimalPoint(true);
  rb1 = new QRadioButton(nwt7vfo);
  rb1->setChecked(true);
  QObject::connect( rb1, SIGNAL(clicked()), this, SLOT(lcd1clicked() ));
  //LCD Anzeige 10 stellen mit punkt
  LCD2 = new QLCDNumber(10, nwt7vfo, "LCD2");
  //Hintergrung gelb
  LCD2->setPalette(dpd);
  LCD2->setAutoFillBackground(true);
  LCD2->setBackgroundRole( QPalette::Background );
  //volle schwarze Zahlen
  LCD2->setSegmentStyle(QLCDNumber::Filled);
  //der Dezimalpunkt soll ganz wenig platz beanspruchen
  LCD2->setSmallDecimalPoint(true);
  rb2 = new QRadioButton(nwt7vfo);
  QObject::connect( rb2, SIGNAL(clicked()), this, SLOT(lcd2clicked() ));

  //LCD Anzeige 10 stellen mit punkt
  LCD3 = new QLCDNumber(10, nwt7vfo, "LCD3");
  //Hintergrung gelb
  LCD3->setPalette(dpd);
  LCD3->setAutoFillBackground(true);
  LCD3->setBackgroundRole( QPalette::Background );
  //volle schwarze Zahlen
  LCD3->setSegmentStyle(QLCDNumber::Filled);
  //der Dezimalpunkt soll ganz wenig platz beanspruchen
  LCD3->setSmallDecimalPoint(true);
  rb3 = new QRadioButton(nwt7vfo);
  QObject::connect( rb3, SIGNAL(clicked()), this, SLOT(lcd3clicked() ));

  //LCD Anzeige 10 stellen mit punkt
  LCD4 = new QLCDNumber(10, nwt7vfo, "LCD4");
  //Hintergrung gelb
  LCD4->setPalette(dpd);
  LCD4->setAutoFillBackground(true);
  LCD4->setBackgroundRole( QPalette::Background );
  //volle schwarze Zahlen
  LCD4->setSegmentStyle(QLCDNumber::Filled);
  //der Dezimalpunkt soll ganz wenig platz beanspruchen
  LCD4->setSmallDecimalPoint(true);
  rb4 = new QRadioButton(nwt7vfo);
  QObject::connect( rb4, SIGNAL(clicked()), this, SLOT(lcd4clicked() ));

  //LCD Anzeige 10 stellen mit punkt
  LCD5 = new QLCDNumber(10, nwt7vfo, "LCD5");
  //Hintergrung gelb
  LCD5->setPalette(dpd);
  LCD5->setAutoFillBackground(true);
  LCD5->setBackgroundRole( QPalette::Background );
  //volle schwarze Zahlen
  LCD5->setSegmentStyle(QLCDNumber::Filled);
  //der Dezimalpunkt soll ganz wenig platz beanspruchen
  LCD5->setSmallDecimalPoint(true);
  rb5 = new QRadioButton(nwt7vfo);
  QObject::connect( rb5, SIGNAL(clicked()), this, SLOT(lcd5clicked() ));

  editzf = new QLineEdit(nwt7vfo);
  QObject::connect( editzf, SIGNAL(returnPressed()), this, SLOT(setVfo() ));
  labelzf = new QLabel(nwt7vfo);
  labelzf->setText(tr("ZF"));
  labelhz = new QLabel(nwt7vfo);
  labelhz->setText(tr("Hz"));
  checkboxzf = new QCheckBox(nwt7vfo);
  checkboxzf->setText(tr("ZF fuer das Wobbeln aktivieren"));
  checkboxzf->setChecked(false);
  checkboxiqvfo = new QCheckBox(nwt7vfo);
  checkboxiqvfo->setText(tr("VFO-Frequenz x 4 fuer I/Q Mischer"));
  checkboxiqvfo->setChecked(false);
  QObject::connect( checkboxiqvfo, SIGNAL(clicked()), this, SLOT(setIQVFO() ));
  
  daempfung2 = new QComboBox(nwt7vfo);
  QObject::connect( daempfung2, SIGNAL( currentIndexChanged(int)), this, SLOT(setDaempfung(int)));
  labeldaempfung1 = new QLabel(tr("Daempfungsglied"),nwt7vfo);

  vfotimer = new QTimer(this);
  //nach ablauf des vfotimers Daten an NWT7 senden (LCD daten)
  QObject::connect( vfotimer, SIGNAL(timeout()), this, SLOT(senddaten() ));

  //erste Diplayeinstellung
  LCDaendern();
  //die erste Einstellung des NWT7
  setVfo();
///////////////////////////////////////////////////////////////////////////////
// Mess Widget
  nwt7messen = new QWidget();
  addTab(nwt7messen, tr("Wattmeter"));

  progressbarmessk1 = new QProgressBar(nwt7messen);
  progressbarmessk1->setFormat("");
  mlabelk1 = new QLabel(nwt7messen);
  mlabelk1->setText(tr("0"));
  progressbarmessk2 = new QProgressBar(nwt7messen);
  progressbarmessk2->setFormat("");
  mlabelk2 = new QLabel(nwt7messen);
  mlabelk2->setText(tr("0"));

  ldaempfungk1 = new QComboBox(nwt7messen);
  ldaempfungk1->setEditable(true);
  labelldaempfungk1 = new QLabel(tr("Daempfung (dB)"),nwt7messen);

  ldaempfungk2 = new QComboBox(nwt7messen);
  ldaempfungk2->setEditable(true);
  labelldaempfungk2 = new QLabel(tr("Daempfung (dB)"),nwt7messen);

  messtimer = new QTimer(this);
  messlabel1 = new QLabel(nwt7messen);
  messlabel2 = new QLabel(nwt7messen);
  messlabel3 = new QLabel(nwt7messen);
  messlabel4 = new QLabel(nwt7messen);
  messlabel5 = new QLabel(nwt7messen);
  messlabel6 = new QLabel(nwt7messen);
  messedit = new Q3MultiLineEdit(nwt7messen);
  //Schrifttyp einstellen
  messedit->setFamily("courier");
  buttonmess = new QPushButton(tr("Messwertuebernahme"), nwt7messen);
  QObject::connect( buttonmess, SIGNAL( clicked()), this, SLOT(tabelleschreiben()));
  buttonmesssave = new QPushButton(tr("Speichern"), nwt7messen);
  QObject::connect( buttonmesssave, SIGNAL( clicked()), this, SLOT(tabellespeichern()));
  //nach ablauf des messtimers Daten vom nwt7 holen
  QObject::connect( messtimer, SIGNAL(timeout()), this, SLOT(getmessdaten() ));
  messcounter = 0;
  messungk1 = 0.0;
  messungk2 = 0.0;
  
  boxwattoffset1 = new QComboBox(nwt7messen);
  boxwattoffset1->addItem("0 - 10 MHz +/-0,0dBm");
  boxwattoffset1->addItem("10 - 20 MHz  0,8dBm");
  boxwattoffset1->addItem("20 - 50 MHz  1,0dBm");
  boxwattoffset1->addItem("50 - 100 MHz  2,0dBm");
  boxwattoffset1->addItem("100 - 150 MHz  2,5dBm");
  boxwattoffset1->addItem("150 - 200 MHz  3,0dBm");
  boxwattoffset1->addItem("200 - 300 MHz  4,0dBm");
  boxwattoffset1->addItem("300 - 400 MHz  6,0dBm");
  boxwattoffset1->addItem("400 - 500 MHz  9,0dBm");
  QObject::connect( boxwattoffset1, SIGNAL( currentIndexChanged(int)), this, SLOT(setwattoffset1(int)));


  boxwattoffset2 = new QComboBox(nwt7messen);
  boxwattoffset2->addItem("0 - 10 MHz +/-0,0dBm");
  boxwattoffset2->addItem("10 - 20 MHz  0,8dBm");
  boxwattoffset2->addItem("20 - 50 MHz  1,0dBm");
  boxwattoffset2->addItem("50 - 100 MHz  2,0dBm");
  boxwattoffset2->addItem("100 - 150 MHz  2,5dBm");
  boxwattoffset2->addItem("150 - 200 MHz  3,0dBm");
  boxwattoffset2->addItem("200 - 300 MHz  4,0dBm");
  boxwattoffset2->addItem("300 - 400 MHz  6,0dBm");
  boxwattoffset2->addItem("400 - 500 MHz  9,0dBm");
  QObject::connect( boxwattoffset2, SIGNAL( currentIndexChanged(int)), this, SLOT(setwattoffset2(int)));

  woffset1 = 0.0;
  woffset2 = 0.0;

// Mess Widget
///////////////////////////////////////////////////////////////////////////////
  
  // Grafischen elemente anordnen
  grafiksetzen();

  // Tabumschalten steuern
  QObject::connect( this, SIGNAL(currentChanged ( QWidget * )), this, SLOT(tabumschalten( QWidget* )));
  
  //eichkorrektur auf 0.0 setzen
  int i;
  
  for(i=0;i<eindex;i++)
  {
    neicharray.arrayk1[i] = 0.0;
    neicharray.arrayk2[i] = 0.0;
    nswreicharray.arrayk1[i] = -10.0;
    nswreicharray.arrayk2[i] = -10.0;
  }
  homedir = QDir::home();
  if(!homedir.cd("hfm9")){
    homedir.mkdir("hfm9");
    homedir.cd("hfm9");
//vorbereiten zur ersten Initialisierung
    bersterstart = true;
  }else{
    bersterstart = false;
  }
  beichenswr = false;
  beichenswrneu = false;
  beichen40 = false;
  beichen0 = false;
  bmeichenk1_0db = false;
  bmeichenk1_20db = false;
  bmeichenk2_0db = false;
  bmeichenk2_20db = false;
  btabelleschreiben = false;
  bkurvegeladen = false;
  //Grundkonfig erzeugen
  if(bersterstart){
    QMessageBox::information( this, tr("Erster Start des Programmes"), 
                                    tr("<B>Das Programm wird das erste mal gestartet</B><BR>"
                                       "Es wird das Verzeichnis \"hfm9\" erzeugt,<BR>"
                                       "die Konfigurationsdatei und die Sondendateien.<br>"
                                       "Das Verzeichnis wird im \"Home-bereich\" des <br>"
                                       "des jeweiligen Betriebsystemes angelegt. <br><br>"
                                       "Die Defaultdaten erlauben erste Messungen. <br>"
                                       "Bessere Werte werden durch eine Eichung erreicht!"));

    if(configfilename.isEmpty())configfilename = "hfm9.hfc";
    //defaultwerte laden
    configurationladen(homedir.filePath(configfilename));
    //defaultwerte speichern
    configurationspeichern(homedir.filePath(configfilename));
    //defaultwerte speichern
    messsondespeichern1("def");
    messsondespeichern2("def");
    configfile nwt7sondenfile;
    //lineare Defsonde erzeugen
    nwt7sondenfile.open(homedir.filePath("AD8361intern.hfm"));
    nwt7sondenfile.writeString("Sonde", "AD8361intern");
    nwt7sondenfile.writeDouble("faktor", 1.856681);
    nwt7sondenfile.writeDouble("shift", -8.000154);
    nwt7sondenfile.writeDouble("messx", 0.193143);
    nwt7sondenfile.writeDouble("messy", -84.634597);
    nwt7sondenfile.writeBool("linear", true);
    nwt7sondenfile.close();
    bersterstart = false;
  }
  //fuer die Lupenfunktion
  bdauerwobbeln = false;
  //fuer das Wattmeter zur Spitzenanzeige
  counterspitzek1 = 0;
  counterspitzek2 = 0;
  emit sendeichdaten(neicharray);
  emit sendswreichdaten(nswreicharray);
  
}

Nwt7linux::~Nwt7linux()
{
}

void Nwt7linux::setDaempfungItem(){
  daempfung1->clear();
  daempfung2->clear();
  if(weichen.bfaeich){
    daempfung1->addItem("0dB");
    daempfung1->addItem("4dB");
    daempfung1->addItem("6dB");
    daempfung1->addItem("8dB");
    daempfung1->addItem("10dB");
    daempfung1->addItem("12dB");
    daempfung1->addItem("14dB");
    daempfung1->addItem("16dB");
    daempfung1->addItem("18dB");
    daempfung1->addItem("20dB");
    daempfung1->addItem("22dB");
    daempfung1->addItem("24dB");
    daempfung1->addItem("26dB");
    daempfung1->addItem("28dB");
    daempfung1->addItem("30dB");
    daempfung1->addItem("32dB");
    daempfung1->addItem("34dB");
    daempfung1->addItem("36dB");
    daempfung1->addItem("38dB");
    daempfung1->addItem("40dB");
    daempfung1->addItem("42dB");
    daempfung1->addItem("44dB");
    daempfung1->addItem("46dB");
    daempfung1->addItem("48dB");
    daempfung1->addItem("50dB");
    daempfung1->addItem("52dB");
    daempfung1->addItem("54dB");
    daempfung1->addItem("56dB");
    daempfung1->addItem("58dB");
    daempfung1->addItem("60dB");
    daempfung1->addItem("62dB");
    daempfung1->addItem("64dB");
    daempfung1->addItem("66dB");
    daempfung2->addItem("0dB");
    daempfung2->addItem("4dB");
    daempfung2->addItem("6dB");
    daempfung2->addItem("8dB");
    daempfung2->addItem("10dB");
    daempfung2->addItem("12dB");
    daempfung2->addItem("14dB");
    daempfung2->addItem("16dB");
    daempfung2->addItem("18dB");
    daempfung2->addItem("20dB");
    daempfung2->addItem("22dB");
    daempfung2->addItem("24dB");
    daempfung2->addItem("26dB");
    daempfung2->addItem("28dB");
    daempfung2->addItem("30dB");
    daempfung2->addItem("32dB");
    daempfung2->addItem("34dB");
    daempfung2->addItem("36dB");
    daempfung2->addItem("38dB");
    daempfung2->addItem("40dB");
    daempfung2->addItem("42dB");
    daempfung2->addItem("44dB");
    daempfung2->addItem("46dB");
    daempfung2->addItem("48dB");
    daempfung2->addItem("50dB");
    daempfung2->addItem("52dB");
    daempfung2->addItem("54dB");
    daempfung2->addItem("56dB");
    daempfung2->addItem("58dB");
    daempfung2->addItem("60dB");
    daempfung2->addItem("62dB");
    daempfung2->addItem("64dB");
    daempfung2->addItem("66dB");
  }else{
    daempfung1->addItem("0dB");
    daempfung1->addItem("10dB");
    daempfung1->addItem("20dB");
    daempfung1->addItem("30dB");
    daempfung1->addItem("40dB");
    daempfung1->addItem("50dB");
    daempfung2->addItem("0dB");
    daempfung2->addItem("10dB");
    daempfung2->addItem("20dB");
    daempfung2->addItem("30dB");
    daempfung2->addItem("40dB");
    daempfung2->addItem("50dB");
  }
}

void Nwt7linux::resetKursor(int a){
  boxkursornr->setCurrentIndex(a);
}

void Nwt7linux::wobbelungueltig(){
  int i;
  
  for(i=0; i<maxmesspunkte; i++){
    wobdaten.kanal1[i]=0;
    wobdaten.kanal2[i]=0;
  }
  wobdaten.daten_enable = false;
}

void Nwt7linux::setIQVFO(){
  if(checkboxiqvfo->isChecked()){
    Dial1mhz->setMaximum(int(weichen.maxvfo / 4000000.0)-1);
  }else{
    Dial1mhz->setMaximum(int(weichen.maxvfo / 1000000.0)-1);
  }
  setVfo();
}

void Nwt7linux::setShift(){
  QString sdbshift1, sdbshift2;
  bool ok;

  sdbshift1 = boxdbshift1->currentText();
  sdbshift2 = boxdbshift2->currentText();
  wobdaten.dbshift1 = sdbshift1.toDouble(&ok);
  wobdaten.dbshift2 = sdbshift2.toDouble(&ok);
  fsendewobbeldaten();
//  qDebug("setShift k1 %f k2 %f", wobdaten.dbshift1, wobdaten.dbshift2);
}

void Nwt7linux::clicklupeplus(){
  double fa, fe, fm, fbereich;
  fa = wobdaten.anfangsfrequenz;
  fbereich = wobdaten.schritte * wobdaten.schrittfrequenz;
  fm = KursorFrequenz;
  fa = fm - fbereich / 4.0;
  fe = fm + fbereich / 4.0;
  if(fa < weichen.eichanfang)fa = weichen.eichanfang;
  if(fe > weichen.eichende)fe = weichen.eichende;
  readanfang(fa);
  readende(fe);
  labellupe->setEnabled(false);
  buttonlupeplus->setEnabled(false);
  buttonlupeminus->setEnabled(false);
  if(!bdauerwobbeln)clickwobbelneinmal();
}

void Nwt7linux::clicklupeminus(){
  double fa, fe, fm, fbereich;
  fa = wobdaten.anfangsfrequenz;
  fbereich = wobdaten.schritte * wobdaten.schrittfrequenz;
  fm = KursorFrequenz;
  fa = fm - fbereich;
  fe = fm + fbereich;
  if(fa < weichen.eichanfang)fa = weichen.eichanfang;
  if(fe > weichen.eichende)fe = weichen.eichende;
  readanfang(fa);
  readende(fe);
  labellupe->setEnabled(false);
  buttonlupeplus->setEnabled(false);
  buttonlupeminus->setEnabled(false);
  if(!bdauerwobbeln)clickwobbelneinmal();
}

void Nwt7linux::setKursorFrequenz(double afrq){
  KursorFrequenz = afrq;
  if(bdauerwobbeln){
    labellupe->setEnabled(false);
    buttonlupeplus->setEnabled(false);
    buttonlupeminus->setEnabled(false);
  }else{
    if(KursorFrequenz == 0.0){
      labellupe->setEnabled(false);
      buttonlupeplus->setEnabled(false);
      buttonlupeminus->setEnabled(false);
    }else{
      labellupe->setEnabled(true);
      buttonlupeplus->setEnabled(true);
      buttonlupeminus->setEnabled(true);
    }
  }
}

void Nwt7linux::menuanfangsetzen(){
  emit setmenu(emEichenK1, true);
  if(wobdaten.einkanalig){
    emit setmenu(emEichenK2, false);
    emit setmenu(emSondeLadenK2, false);
    emit setmenu(emSondeSpeichernK2, false);
    emit setmenu(emWattEichenK2, false);
    checkboxk2->setChecked(false);
    checkboxk2->setEnabled(false);
    progressbarmessk2->setEnabled(false);
    ldaempfungk2->setEnabled(false);
    mlabelk2->setEnabled(false);
  }else{
    emit setmenu(emEichenK2, true);
    emit setmenu(emSondeLadenK2, true);
    emit setmenu(emSondeSpeichernK2, true);
    emit setmenu(emWattEichenK2, true);
    checkboxk2->setEnabled(true);
    progressbarmessk2->setEnabled(true);
    ldaempfungk2->setEnabled(true);
    mlabelk2->setEnabled(true);
  }
}


void Nwt7linux::configurationladen(const QString &filename){
  configfile nwt7configfile;
  QString qs;
  int fontsize;
  
  nwt7configfile.open(filename);
#ifdef Q_WS_WIN
  weichen.str_tty = nwt7configfile.readString("serielle_schnittstelle", "COM1");
#else
  weichen.str_tty = nwt7configfile.readString("serielle_schnittstelle", "/dev/ttyS0");
#endif
  editanfang->setText(nwt7configfile.readString("editanfang", "1000000"));
  editende->setText(nwt7configfile.readString("editende", "150000000"));
  editschritte->setText(nwt7configfile.readString("editschritte", "401"));
  qs = nwt7configfile.readString("messlabelfont", "");
  weichen.eichanfang = nwt7configfile.readInteger("eichanfangsfrequenz", 100000);
  weichen.eichende = nwt7configfile.readInteger("eichendfrequenz", 150000000);
  weichen.eichstep = nwt7configfile.readInteger("eichschritte", maxmesspunkte);
  weichen.ddstakt = nwt7configfile.readDouble("DDStakt", 400000000.0);
  weichen.pll = nwt7configfile.readInteger("PLLMode", 1);
  weichen.pllmodeenable = nwt7configfile.readBool("pllmodeenable", false);
  weichen.bfaeich = nwt7configfile.readBool("faeichglied", false);
  setDaempfungItem();
  fontsize = nwt7configfile.readInteger("messlabelfontsize", 20);
  messfont.setPointSize(fontsize);
  if(!qs.isNull()){
    messfont.setFamily(qs);
    messlabel1->setFont(messfont);
    messlabel2->setFont(messfont);
    messlabel3->setFont(messfont);
    messlabel4->setFont(messfont);
    messlabel5->setFont(messfont);
    messlabel6->setFont(messfont);
    lmhz->setFont(messfont);
    lkhz->setFont(messfont);
    lhz->setFont(messfont);
  }  
  qs = nwt7configfile.readString("infofont", "");
  if(!qs.isNull()){
    infofont.setFamily(qs);
    fontsize = nwt7configfile.readInteger("infofontsize", 8);
    infofont.setPointSize(fontsize);
    mledit->setFont(infofont);
  }
  grafik->setWobbeldaten(wobdaten);
  LCD1->display(qs.sprintf("%2.6f",nwt7configfile.readDouble("LCD1", 1.8)));
  LCD2->display(qs.sprintf("%2.6f",nwt7configfile.readDouble("LCD2", 3.6)));
  LCD3->display(qs.sprintf("%2.6f",nwt7configfile.readDouble("LCD3", 7.0)));
  LCD4->display(qs.sprintf("%2.6f",nwt7configfile.readDouble("LCD4", 14.0)));
  LCD5->display(qs.sprintf("%2.6f",nwt7configfile.readDouble("LCD5", 28.0)));
  editzf->setText(nwt7configfile.readString("editzf", "0"));
  wobdaten.namesonde1 = nwt7configfile.readString("namesonde1", "defsonde1");
  wobdaten.namesonde2 = nwt7configfile.readString("namesonde2", "defsonde2");
  wobdaten.beichkorrk1 = nwt7configfile.readBool("eichkorrk1", false);
  wobdaten.beichkorrk2 = nwt7configfile.readBool("eichkorrk2", false);
  wobdaten.einkanalig = nwt7configfile.readBool("Einkanalig", true);
  wobdaten.bswriteration = nwt7configfile.readBool("SWRIteration", true);
  int r,g,b,a;
  //default rot
  r = nwt7configfile.readInteger("color1r", 255);
  g = nwt7configfile.readInteger("color1g", 0);
  b = nwt7configfile.readInteger("color1b", 0);
  a = nwt7configfile.readInteger("color1a", 255);
  QColor pencolor1(r,g,b,a);
  wobdaten.penkanal1.setColor(pencolor1);
  //default gruen
  r = nwt7configfile.readInteger("color2r", 85);
  g = nwt7configfile.readInteger("color2g", 255);
  b = nwt7configfile.readInteger("color2b", 0);
  a = nwt7configfile.readInteger("color2a", 255);
  QColor pencolor2(r,g,b,a);
  wobdaten.penkanal2.setColor(pencolor2);
  weichen.maxwobbel = nwt7configfile.readDouble("maxwobbel", 200000000.0);
  weichen.maxvfo = nwt7configfile.readDouble("maxvfo", 180000000.0);
  Dial1mhz->setMaximum(int(weichen.maxvfo / 1000000.0)-1);
  checkboxk1->setChecked(nwt7configfile.readBool("k1checked", true));
  checkboxk2->setChecked(nwt7configfile.readBool("k2checked", false));
  //ComboBox im Wattmeter neu aufbauen
  ldaempfungk1->clear();
  ldaempfungk1->addItem("0");
  ldaempfungk1->addItem("10");
  ldaempfungk1->addItem("20");
  ldaempfungk1->addItem("30");
  ldaempfungk1->addItem("40");
  ldaempfungk2->clear();
  ldaempfungk2->addItem("0");
  ldaempfungk2->addItem("10");
  ldaempfungk2->addItem("20");
  ldaempfungk2->addItem("30");
  ldaempfungk2->addItem("40");
  qs = nwt7configfile.readString("powerk15", "99");
  if(qs != "99")ldaempfungk1->addItem(qs);
  qs = nwt7configfile.readString("powerk16", "99");
  if(qs != "99")ldaempfungk1->addItem(qs);
  qs = nwt7configfile.readString("powerk17", "99");
  if(qs != "99")ldaempfungk1->addItem(qs);
  qs = nwt7configfile.readString("powerk18", "99");
  if(qs != "99")ldaempfungk1->addItem(qs);
  qs = nwt7configfile.readString("powerk19", "99");
  if(qs != "99")ldaempfungk1->addItem(qs);
  qs = nwt7configfile.readString("powerk25", "99");
  if(qs != "99")ldaempfungk2->addItem(qs);
  qs = nwt7configfile.readString("powerk26", "99");
  if(qs != "99")ldaempfungk2->addItem(qs);
  qs = nwt7configfile.readString("powerk27", "99");
  if(qs != "99")ldaempfungk2->addItem(qs);
  qs = nwt7configfile.readString("powerk28", "99");
  if(qs != "99")ldaempfungk2->addItem(qs);
  qs = nwt7configfile.readString("powerk29", "99");
  if(qs != "99")ldaempfungk2->addItem(qs);
  weichen.eichk1 = wobdaten.beichkorrk1;
  weichen.eichk2 = wobdaten.beichkorrk2;
  weichen.einkanalig = wobdaten.einkanalig;
  frqmarken.f1160m = nwt7configfile.readLong("a160m", 1810000);
  frqmarken.f2160m = nwt7configfile.readLong("b160m", 2000000);
  frqmarken.f180m = nwt7configfile.readLong("a80m", 3500000);
  frqmarken.f280m = nwt7configfile.readLong("b80m", 3800000);
  frqmarken.f140m = nwt7configfile.readLong("a40m", 7000000);
  frqmarken.f240m = nwt7configfile.readLong("b40m", 7200000);
  frqmarken.f130m = nwt7configfile.readLong("a30m", 10100000);
  frqmarken.f230m = nwt7configfile.readLong("b30m", 10150000);
  frqmarken.f120m = nwt7configfile.readLong("a20m", 14000000);
  frqmarken.f220m = nwt7configfile.readLong("b20m", 14350000);
  frqmarken.f117m = nwt7configfile.readLong("a17m", 18068000);
  frqmarken.f217m = nwt7configfile.readLong("b17m", 18168000);
  frqmarken.f115m = nwt7configfile.readLong("a15m", 21000000);
  frqmarken.f215m = nwt7configfile.readLong("b15m", 21450000);
  frqmarken.f112m = nwt7configfile.readLong("a12m", 24890000);
  frqmarken.f212m = nwt7configfile.readLong("b12m", 24990000);
  frqmarken.f110m = nwt7configfile.readLong("a10m", 28000000);
  frqmarken.f210m = nwt7configfile.readLong("b10m", 29700000);
  frqmarken.f16m = nwt7configfile.readLong("a6m", 50000000);
  frqmarken.f26m = nwt7configfile.readLong("b6m", 54000000);
  frqmarken.f12m = nwt7configfile.readLong("a2m", 144000000);
  frqmarken.f22m = nwt7configfile.readLong("b2m", 146000000);
  frqmarken.f1u1 = nwt7configfile.readLong("au1", 0);
  frqmarken.f2u1 = nwt7configfile.readLong("bu1", 0);
  frqmarken.f1u2 = nwt7configfile.readLong("au2", 0);
  frqmarken.f2u2 = nwt7configfile.readLong("bu2", 0);
  frqmarken.f1u3 = nwt7configfile.readLong("au3", 0);
  frqmarken.f2u3 = nwt7configfile.readLong("bu3", 0);
  frqmarken.b160m = nwt7configfile.readBool("160m", false);
  frqmarken.b80m = nwt7configfile.readBool("80m", false);
  frqmarken.b40m = nwt7configfile.readBool("40m", false);
  frqmarken.b30m = nwt7configfile.readBool("30m", false);
  frqmarken.b20m = nwt7configfile.readBool("20m", false);
  frqmarken.b17m = nwt7configfile.readBool("17m", false);
  frqmarken.b15m = nwt7configfile.readBool("15m", false);
  frqmarken.b12m = nwt7configfile.readBool("12m", false);
  frqmarken.b10m = nwt7configfile.readBool("10m", false);
  frqmarken.b6m = nwt7configfile.readBool("6m", false);
  frqmarken.b2m = nwt7configfile.readBool("2m", false);
  frqmarken.bu1 = nwt7configfile.readBool("zusatz1", false);
  frqmarken.bu2 = nwt7configfile.readBool("zusatz2", false);
  frqmarken.bu3 = nwt7configfile.readBool("zusatz3", false);
  nwt7configfile.close();
  emit sendefrqmarken(frqmarken);
  if(wobdaten.einkanalig){
    if(wobdaten.beichkorrk1){
      setColorRedk1();
    }else{
      setColorBlackk1();
    }
    emit setmenu(emEichenK2, false);
    emit setmenu(emSondeLadenK2, false);
    emit setmenu(emSondeSpeichernK2, false);
    emit setmenu(emWattEichenK2, false);
    checkboxk2->setChecked(false);
    checkboxk2->setEnabled(false);
    progressbarmessk2->setEnabled(false);
    ldaempfungk2->setEnabled(false);
    mlabelk2->setEnabled(false);
  }else{
    if(wobdaten.beichkorrk1){
      setColorRedk1();
    }else{
      setColorBlackk1();
    }
    if(wobdaten.beichkorrk2){
      setColorRedk2();
    }else{
      setColorBlackk2();
    }
    emit setmenu(emEichenK2, true);
    emit setmenu(emSondeLadenK2, true);
    emit setmenu(emSondeSpeichernK2, true);
    emit setmenu(emWattEichenK2, true);
    checkboxk2->setEnabled(true);
    progressbarmessk2->setEnabled(true);
    ldaempfungk2->setEnabled(true);
    mlabelk2->setEnabled(true);
  }
  configfile nwt7sondenfile;
  qs = wobdaten.namesonde1;
  if((qs.find(".")== -1)) qs = qs + ".hfm";
  messsondenfilek1laden(qs);
  qs = wobdaten.namesonde2;
  if((qs.find(".")== -1)) qs = qs + ".hfm";
  messsondenfilek2laden(qs);
  wobnormalisieren();
  fsendewobbeldaten();
}

void Nwt7linux::configurationspeichern(const QString &filename){
  QString qs;
  int i;

  configfile *nwt7configfile = new configfile();
  nwt7configfile->open(filename);
  nwt7configfile->writeString("serielle_schnittstelle", weichen.str_tty);
  nwt7configfile->writeString("editanfang", editanfang->text());
  nwt7configfile->writeString("editende", editende->text());
  nwt7configfile->writeString("editschritte", editschritte->text());
  nwt7configfile->writeInteger("eichanfangsfrequenz", weichen.eichanfang);
  nwt7configfile->writeInteger("eichendfrequenz", weichen.eichende);
  nwt7configfile->writeInteger("eichschritte", weichen.eichstep);
  nwt7configfile->writeDouble("DDStakt", weichen.ddstakt);
  nwt7configfile->writeBool("Einkanalig", weichen.einkanalig);
  nwt7configfile->writeInteger("PLLMode", weichen.pll);
  nwt7configfile->writeDouble("maxwobbel", weichen.maxwobbel);
  nwt7configfile->writeDouble("maxvfo", weichen.maxvfo);
  nwt7configfile->writeBool("faeichglied", weichen.bfaeich);

  wobdaten = grafik->getWobbeldaten();
  nwt7configfile->writeDouble("LCD1", LCD1->value());
  nwt7configfile->writeDouble("LCD2", LCD2->value());
  nwt7configfile->writeDouble("LCD3", LCD3->value());
  nwt7configfile->writeDouble("LCD4", LCD4->value());
  nwt7configfile->writeDouble("LCD5", LCD5->value());
  nwt7configfile->writeString("editzf", editzf->text());
  messfont = messlabel1->font();
  qs = messfont.family();
  if(qs.isEmpty())qs = messfont.defaultFamily();
  nwt7configfile->writeString("messlabelfont", qs);
  nwt7configfile->writeInteger("messlabelfontsize", messfont.pointSize());
  nwt7configfile->writeString("infofont", infofont.family());
  nwt7configfile->writeInteger("infofontsize", infofont.pointSize());
  nwt7configfile->writeString("namesonde1", wobdaten.namesonde1);
  nwt7configfile->writeString("namesonde2", wobdaten.namesonde2);
  wobdaten.beichkorrk1 = weichen.eichk1;
  wobdaten.beichkorrk2 = weichen.eichk2;
  nwt7configfile->writeBool("eichkorrk1", wobdaten.beichkorrk1);
  nwt7configfile->writeBool("eichkorrk2", wobdaten.beichkorrk2);
  nwt7configfile->writeBool("k1checked", checkboxk1->isChecked());
  nwt7configfile->writeBool("k2checked", checkboxk2->isChecked());
  nwt7configfile->writeBool("SWRIteration", wobdaten.bswriteration);
  QColor pencolor1 = wobdaten.penkanal1.color();
  int r,g,b,a;
  pencolor1.getRgb(&r, &g, &b, &a);
  nwt7configfile->writeInteger("color1r", r);
  nwt7configfile->writeInteger("color1g", g);
  nwt7configfile->writeInteger("color1b", b);
  nwt7configfile->writeInteger("color1a", a);
  QColor pencolor2 = wobdaten.penkanal2.color();
  pencolor2.getRgb(&r, &g, &b, &a);
  nwt7configfile->writeInteger("color2r", r);
  nwt7configfile->writeInteger("color2g", g);
  nwt7configfile->writeInteger("color2b", b);
  nwt7configfile->writeInteger("color2a", a);
  for(i=5; i<ldaempfungk1->count(); i++){
    qs.sprintf("powerk1%i",i);
    ldaempfungk1-> setCurrentIndex(i);
    nwt7configfile->writeString(qs, ldaempfungk1->currentText());
  } 
  ldaempfungk1-> setCurrentIndex(0);
  for(i=5; i<ldaempfungk2->count(); i++){
    qs.sprintf("powerk2%i",i);
    ldaempfungk2-> setCurrentIndex(i);
    nwt7configfile->writeString(qs, ldaempfungk2->currentText());
  } 
  ldaempfungk2-> setCurrentIndex(0);
  nwt7configfile->writeLong("a160m", frqmarken.f1160m );
  nwt7configfile->writeLong("b160m", frqmarken.f2160m);
  nwt7configfile->writeLong("a80m", frqmarken.f180m);
  nwt7configfile->writeLong("b80m", frqmarken.f280m);
  nwt7configfile->writeLong("a40m", frqmarken.f140m);
  nwt7configfile->writeLong("b40m", frqmarken.f240m);
  nwt7configfile->writeLong("a30m", frqmarken.f130m);
  nwt7configfile->writeLong("b30m", frqmarken.f230m);
  nwt7configfile->writeLong("a20m", frqmarken.f120m);
  nwt7configfile->writeLong("b20m", frqmarken.f220m);
  nwt7configfile->writeLong("a17m", frqmarken.f117m);
  nwt7configfile->writeLong("b17m", frqmarken.f217m);
  nwt7configfile->writeLong("a15m", frqmarken.f115m);
  nwt7configfile->writeLong("b15m", frqmarken.f215m);
  nwt7configfile->writeLong("a12m", frqmarken.f112m);
  nwt7configfile->writeLong("b12m", frqmarken.f212m);
  nwt7configfile->writeLong("a10m", frqmarken.f110m);
  nwt7configfile->writeLong("b10m", frqmarken.f210m);
  nwt7configfile->writeLong("a6m", frqmarken.f16m);
  nwt7configfile->writeLong("b6m", frqmarken.f26m);
  nwt7configfile->writeLong("a2m", frqmarken.f12m);
  nwt7configfile->writeLong("b2m", frqmarken.f22m);
  nwt7configfile->writeLong("au1", frqmarken.f1u1);
  nwt7configfile->writeLong("bu1", frqmarken.f2u1);
  nwt7configfile->writeLong("au2", frqmarken.f1u2);
  nwt7configfile->writeLong("bu2", frqmarken.f2u2);
  nwt7configfile->writeLong("au3", frqmarken.f1u3);
  nwt7configfile->writeLong("bu3", frqmarken.f2u3);
  nwt7configfile->writeBool("160m", frqmarken.b160m );
  nwt7configfile->writeBool("80m", frqmarken.b80m );
  nwt7configfile->writeBool("40m", frqmarken.b40m );
  nwt7configfile->writeBool("30m", frqmarken.b30m );
  nwt7configfile->writeBool("20m", frqmarken.b20m );
  nwt7configfile->writeBool("17m", frqmarken.b17m );
  nwt7configfile->writeBool("15m", frqmarken.b15m );
  nwt7configfile->writeBool("12m", frqmarken.b12m );
  nwt7configfile->writeBool("10m", frqmarken.b10m );
  nwt7configfile->writeBool("6m", frqmarken.b6m );
  nwt7configfile->writeBool("2m", frqmarken.b2m );
  nwt7configfile->writeBool("zusatz1", frqmarken.bu1 );
  nwt7configfile->writeBool("zusatz2", frqmarken.bu2 );
  nwt7configfile->writeBool("zusatz3", frqmarken.bu3 );
  nwt7configfile->close();
}

///////////////////////////////////////////////////////////////////////////////
// Menubereich

void Nwt7linux::drucklabel(){
  bool ok;
  QString alabel;
  QString beschr(tr("<b>Ueberschrift beim Ausdrucken</b><br>"
                    "Dieser String erscheint als<br>"
		    "Unterschrift unterhalb der Grafik.<br><br>"
		    "Label eingeben:"));

  alabel = layoutlabel;
  alabel = QInputDialog::getText(tr("Layout"), beschr,
                                 QLineEdit::Normal,
                                 alabel, &ok, this);
  if(ok){
    layoutlabel = alabel;
    fsendewobbeldaten();
  }
}

void Nwt7linux::beenden()
{
  configurationspeichern(homedir.filePath(configfilename));
  wkmanager->beenden();
  if (bttyOpen)
  {
    defaultlesenrtty(); //eventuelle Daten im UART loeschen
    picmodem->closetty();
  }
  close();
}

void Nwt7linux::druckediagramm()
{
  int linien = mledit->numLines();
  int i;

  bstrlist.clear();
  //Stringliste auktualisieren
  for(i=0; i<linien; i++){
    bstrlist.append(mledit->textLine(i));
  }  
  emit drucken(printfont, bstrlist);
}

void Nwt7linux::druckediagrammpdf()
{
  int linien = mledit->numLines();
  int i;

  bstrlist.clear();
  for(i=0; i<linien; i++){
    bstrlist.append(mledit->textLine(i));
  }  
  emit druckenpdf(printfont, bstrlist);
}

void Nwt7linux::setconffilename(const QString fname)
{
  configfilename = fname;
  configurationladen(homedir.filePath(configfilename));
}

QString Nwt7linux::getconffilename()
{
  return configfilename;
}

QString Nwt7linux::delPath(const QDir &s)
{
  QDir qd(s); 
  QString qs, qs1;
  qs = qd.dirName();
//  qs1 = qd.filePath();
//  qs.remove(1, qs1.length());
  return qs;
}

void Nwt7linux::EinstellungLaden()
{
  QString s = QFileDialog::getOpenFileName(
                    homedir.filePath("*.hfc"),
                    tr("HFM9/NWT Konfigurationsdatei (*.hfc)"),
                    this, 0, tr("HFM9/NWT Konfiguration laden"));
  if (!s.isNull())
  {
    configurationladen(s);
    s = delPath(s);
//    qDebug(s);
    configfilename = s;
    setAText(weichen.str_tty);
  }
}

void Nwt7linux::EinstellungSichern()
{
  QString s = QFileDialog::getSaveFileName(
                    homedir.filePath("*.hfc"),
                    tr("HFM9/NWT Konfigurationsdatei (*.hfc)"),
                    this, 0, tr("HFM9/NWT Konfiguration speichern"));
  if (!s.isNull())
  {
    //Datei ueberpruefen ob Sufix vorhanden
    if((s.find(".")== -1)) s += ".hfc";
    configurationspeichern(s);
    wkmanager->beenden();
    s = delPath(s);
//    qDebug(s);
    configfilename = s;
    setAText(weichen.str_tty);
    configurationladen(homedir.filePath(configfilename));
  }
}

void Nwt7linux::KurvenLaden()
{
  int i;
  QFile f;
  QString s = QFileDialog::getOpenFileName(
                    homedir.filePath("*.hfd"),
                    tr("HFM9/NWT Kurvendatei (*.hfd)"),
                    this, 0, tr("HFM9/NWT Kurve laden"));
  //String ist nicht leer
  if (!s.isNull())
  {
    //Filename setzen
    f.setName(s);
    if(f.open( IO_ReadOnly )){
      if(bkurvegeladen){
        wobdaten = wobdatenmerk;
        wobdaten.daten_enable = true;
        wobdaten.bhintergrund = false;
        wobdaten.mousesperre = false;
        fsendewobbeldaten();
      }
      wobdatenmerk = wobdaten; //alte Einstellung sichern
      bkurvegeladen = true;
      QTextStream ts(&f);
      ts >> wobdaten.anfangsfrequenz;
//      editanfang->setText(s.sprintf("%ld",wobdaten.anfangsfrequenz));
      ts >> wobdaten.schrittfrequenz;
//      editschrittweite->setText(s.sprintf("%ld",wobdaten.schrittfrequenz));
      ts >> wobdaten.schritte;
//      editschritte->setText(s.sprintf("%d",wobdaten.schritte));
//      editende->setText(s.sprintf("%d",wobdaten.anfangsfrequenz+(wobdaten.schritte * wobdaten.schrittfrequenz)));
//      wobnormalisieren(); //Abgleich aller Eingabedaten
      ts >> wobdaten.faktor1;
      ts >> wobdaten.shift1;
      ts >> wobdaten.faktor2;
      ts >> wobdaten.shift2;
      ts >> i;
      switch(i){
        case 0:
          wobdaten.ebetriebsart = ewobbeln;
          betriebsart->setCurrentIndex (0);
          wobdaten.linear1 = false;
          wobdaten.linear2 = false;
          setTabEnabled(nwt7messen, true);
          break;
        case 1:  
          wobdaten.ebetriebsart = eswrneu;
          betriebsart->setCurrentIndex (1);
          setTabEnabled(nwt7messen, true);
          break;
        case 2:  
          wobdaten.ebetriebsart = ewobbeln;
          betriebsart->setCurrentIndex (0);
          wobdaten.linear1 = true;
          wobdaten.linear2 = true;
          setTabEnabled(nwt7messen, false);
          break;
        case 3:  
          wobdaten.ebetriebsart = eswrant;
          betriebsart->setCurrentIndex (2);
          setTabEnabled(nwt7messen, true);
          break;
        case 4:  
          wobdaten.ebetriebsart = eimpedanz;
          betriebsart->setCurrentIndex (3);
          setTabEnabled(nwt7messen, true);
        break;
      }
      for(i=0; i<wobdaten.schritte; i++){
        ts >> wobdaten.kanal1[i];
      }
      for(i=0; i<wobdaten.schritte; i++){
        ts >> wobdaten.kanal2[i];
      }
      f.close();
      wobdaten.daten_enable = true;
      wobdaten.bhintergrund = false;
      wobdaten.mousesperre = false;
      fsendewobbeldaten();
    }
  }
}

void Nwt7linux::KurvenSichern()
{
  int i;
  QFile f;
  QString s = QFileDialog::getSaveFileName(
                    homedir.filePath("*.hfd"),
                    tr("HFM9/NWT Kurvendatei (*.hfd)"),
                    this, 0, tr("HFM9/NWT Kurve speichern"));
  if (!s.isNull())
  {
    //Datei ueberpruefen ob Sufix vorhanden
    if((s.find(".")== -1)) s += ".hfd";
    f.setName(s);
    if(f.open( IO_WriteOnly )){
      QTextStream ts(&f);
      wobdaten = grafik->getWobbeldaten();
      ts << wobdaten.anfangsfrequenz << endl;
      ts << wobdaten.schrittfrequenz << endl;
      ts << wobdaten.schritte << endl;
      ts << wobdaten.faktor1 << endl;
      ts << wobdaten.shift1 << endl;
      ts << wobdaten.faktor2 << endl;
      ts << wobdaten.shift2 << endl;
      switch(wobdaten.ebetriebsart){
       case ewobbeln:
         if(wobdaten.linear1 or wobdaten.linear2){
           //linear == 2
           ts << 2 << endl;
         }else{
           //log == 0
           ts << 0 << endl;
         }
         break;
       case eswrneu:
         //swr == 1
         ts << 1 << endl;
         break;
       case eswrant:
         //swr == 3
         ts << 3 << endl;
         break;
       case eimpedanz:
         //impedanz == 4
         ts << 4 << endl;
         break;
      }
      //Messung einlesen
      for(i=0; i<wobdaten.schritte; i++){
        ts << wobdaten.kanal1[i] << endl;
      }
      for(i=0; i<wobdaten.schritte; i++){
        ts << wobdaten.kanal2[i] << endl;
      }
      f.close();
    }
  }
}

///////////////////////////////////////////////////////////////////////////////
// Funktionen im Wobbelbereich
void Nwt7linux::infosetfont(){
  bool ok;

  infofont = QFontDialog::getFont( &ok, infofont, this);
  if(ok){
    mledit->setFont(infofont);
  }
}

void Nwt7linux::messsondenfilek1laden(const QString &filename){
  int i;
  QFile f;
  QString qs;
  QString s;
  
  s = filename;
  if (!s.isNull()){
    betriebsart->setCurrentIndex (0);
    configfile nwt7sondenfile;
    nwt7sondenfile.open(homedir.filePath(s));
    qs = nwt7sondenfile.readString("Sonde", "AD8307intern");
    checkboxk1->setText(qs);
    wobdaten.faktor1 = nwt7sondenfile.readDouble("faktor", 1.981226);
    wobdaten.shift1 = nwt7sondenfile.readDouble("shift", 19.272490);
    wobdaten.linear1 = nwt7sondenfile.readBool("linear", false);
    wobdaten.mfaktor1 = nwt7sondenfile.readDouble("messx", 0.193143);
    wobdaten.mshift1 = nwt7sondenfile.readDouble("messy", -84.634597);
    nwt7sondenfile.close();
    wobbelungueltig();
    //Daten ins Grafikfenster uebermitteln und neu darstellen
    fsendewobbeldaten();
    if(wobdaten.linear2 or wobdaten.linear1){
      checkboxgrafik->setEnabled(false);
      checkbox6db->setEnabled(false);
      checkbox3db->setEnabled(false);
      betriebsart->setEnabled(false);
      labelbetriebsart->setEnabled(false);
      setTabEnabled(nwt7messen, false);
    }else{
      checkboxgrafik->setEnabled(true);
      checkbox6db->setEnabled(true);
      checkbox3db->setEnabled(true);
      betriebsart->setEnabled(true);
      labelbetriebsart->setEnabled(true);
      setTabEnabled(nwt7messen, true);
    }
    s.replace(QString(".hfm"), "k1.hfe");
    //Filename setzen
    f.setName(homedir.filePath(s));
    if(f.open( IO_ReadOnly )){
      QTextStream ts(&f);
      for(i=0; i<eindex; i++){
        ts >> neicharray.arrayk1[i];
      }
      f.close();
      emit sendeichdaten(neicharray);
    }else{
      wobdaten.beichkorrk1 = false;
    }
    s.replace(QString("k1.hfe"), "k1.hfs");
    //Filename setzen
    f.setName(homedir.filePath(s));
    if(f.open( IO_ReadOnly )){
      QTextStream ts(&f);
      for(i=0; i<eindex; i++){
        ts >> nswreicharray.arrayk1[i];
      }
      f.close();
      emit sendswreichdaten(nswreicharray);
    }else{
      wobdaten.beichswrk1 = false;
    }
  }
};

void Nwt7linux::messsondenfilek2laden(const QString &filename){
  int i;
  QFile f;
  QString qs;
  QString s;
  
  s = filename;
  if (!s.isNull()){
    betriebsart->setCurrentIndex (0);
    configfile nwt7sondenfile;
    nwt7sondenfile.open(homedir.filePath(s));
    qs = nwt7sondenfile.readString("Sonde", "AD8307externK2");
    checkboxk2->setText(qs);
    wobdaten.faktor2 = nwt7sondenfile.readDouble("faktor", 1.981226);
    wobdaten.shift2 = nwt7sondenfile.readDouble("shift", 19.272490);
    wobdaten.linear2 = nwt7sondenfile.readBool("linear", false);
    wobdaten.mfaktor2 = nwt7sondenfile.readDouble("messx", 0.193143);
    wobdaten.mshift2 = nwt7sondenfile.readDouble("messy", -84.634597);
    nwt7sondenfile.close();
    wobbelungueltig();
    //Daten ins Grafikfenster uebermitteln und neu darstellen
    fsendewobbeldaten();
    if(wobdaten.linear2 or wobdaten.linear1){
      checkboxgrafik->setEnabled(false);
      checkbox6db->setEnabled(false);
      checkbox3db->setEnabled(false);
      betriebsart->setEnabled(false);
      labelbetriebsart->setEnabled(false);
      setTabEnabled(nwt7messen, false);
    }else{
      checkboxgrafik->setEnabled(true);
      checkbox6db->setEnabled(true);
      checkbox3db->setEnabled(true);
      betriebsart->setEnabled(true);
      labelbetriebsart->setEnabled(true);
      setTabEnabled(nwt7messen, true);
    }
    //Filename setzen
    s.replace(QString(".hfm"), "k2.hfe");
    f.setName(homedir.filePath(s));
    if(f.open( IO_ReadOnly )){
      QTextStream ts(&f);
      for(i=0; i<eindex; i++){
        ts >> neicharray.arrayk2[i];
      }
      f.close();
      emit sendeichdaten(neicharray);
    }else{
      wobdaten.beichkorrk2 = false;
    }
    //Filename setzen
    s.replace(QString(".hfm"), "k2.hfs");
    f.setName(homedir.filePath(s));
    if(f.open( IO_ReadOnly )){
      QTextStream ts(&f);
      for(i=0; i<eindex; i++){
        ts >> nswreicharray.arrayk2[i];
      }
      f.close();
      emit sendswreichdaten(nswreicharray);
    }else{
      wobdaten.beichswrk2 = false;
    }
  }
};

void Nwt7linux::messsondeladen1(){
  QString s1;
  s1 = tr("HFM9/NWT Sondendatei (*.hfm)");
  QString s = QFileDialog::getOpenFileName(
                    homedir.filePath("*.hfm"),
                    s1,
                    this, 0, tr("HFM9/NWT Sondendatei laden Kanal 1"));
  messsondenfilek1laden(s);
}

void Nwt7linux::messsondeladen2(){
  QString s1;
  s1 = tr("HFM9/NWT Sondendatei (*.hfm)");
  QString s = QFileDialog::getOpenFileName(
                    homedir.filePath("*.hfm"),
                    s1,
                    this, 0, tr("HFM9/NWT Sondendatei laden Kanal 2"));
  messsondenfilek2laden(s);
}

void Nwt7linux::messsondespeichern1(QString s1){
  QString s2;
  QString beschr;
  QString sondenname;
  QString s, smerk;
  QFile f;
  int i;
  bool ok = false;
  
  //kein erster Start normales abspeichern
  if(!bersterstart){
    beschr = tr("<b>Name der Messsonde am Checkbutton</b><br>"
                "Gib der Messonde einen Name oder<br>"
                "den vorgegebenen Name uebernehmen:");
  }
  //default Dateiname verwenden
  if(s1 == "def"){
    if(wobdaten.ebetriebsart == ewobbeln){
      s1 = wobdaten.namesonde1;
    }
  } 
  s2 = tr("HFM9/NWT Sondendatei (*.hfm)");

  //Datei ueberpruefen ob Sufix vorhanden
  if((s1.find(".")== -1)) s1 += ".hfm";
  if(!bersterstart){
    sondenname = QInputDialog::getText(tr("Messsondenname"), beschr,
                 QLineEdit::Normal,
                 checkboxk1->text(), &ok, this);
  }else{
    sondenname = checkboxk1->text();
    ok = true;
  }
  if(ok){
    if((wobdaten.ebetriebsart == ewobbeln) or (wobdaten.ebetriebsart == eswrneu)){
      s = wobdaten.namesonde1;
    }
    //kein erster Start normales abspeichern
    if(!bersterstart){
      s = QFileDialog::getSaveFileName(
                       homedir.filePath(s1),
                       s2,
                       this, 0, tr("HFM9/NWT Sondendatei speichern"));
    }else{
      s = homedir.filePath(s1);
    }
    if (!s.isNull())
    {
      //Datei ueberpruefen ob Sufix vorhanden
      if((s.find(".")== -1)) s += ".hfm";
    }
    smerk = s; //Dateinamen merken
    configfile nwt7sondenfile;
    nwt7sondenfile.open(s);
    if((wobdaten.ebetriebsart == ewobbeln) or (wobdaten.ebetriebsart == eswrneu)){
//      wobdaten = grafik->getWobbeldaten();
      nwt7sondenfile.writeString("Sonde", sondenname);
      nwt7sondenfile.writeDouble("faktor", wobdaten.faktor1);
      nwt7sondenfile.writeDouble("shift", wobdaten.shift1);
      nwt7sondenfile.writeBool("linear", wobdaten.linear1);
      nwt7sondenfile.writeDouble("messx", wobdaten.mfaktor1);
      nwt7sondenfile.writeDouble("messy", wobdaten.mshift1);
      nwt7sondenfile.close();
      checkboxk1->setText(sondenname);
      //Filename setzen
      //Eichkorrektur bei log. Messkopf
      if((wobdaten.beichkorrk1) and (!wobdaten.linear1)){
        s.replace(QString(".hfm"), "k1.hfe");
        f.setName(homedir.filePath(s));
        if(f.open(IO_WriteOnly)){
          QTextStream ts(&f);
          for(i=0; i<eindex; i++){
            ts << neicharray.arrayk1[i] << endl;
          }
          f.close();
        }
      }
    }
    if(wobdaten.ebetriebsart == eswrneu){
      s = smerk;
      //Filename setzen
      s.replace(QString(".hfm"), "k1.hfs");
      f.setName(homedir.filePath(s));
      if(f.open(IO_WriteOnly)){
#ifdef LDEBUG
        qDebug(s);
#endif    
        QTextStream ts(&f);
        for(i=0; i<eindex; i++){
          ts << nswreicharray.arrayk1[i] << endl;
        }
        f.close();
      }
    }
  }
}

void Nwt7linux::messsondespeichern2(QString s1){
  QString s2;
  QString beschr;
  QString sondenname;
  QString s, smerk;
  QFile f;
  int i;
  bool ok = false;

  if(!bersterstart){
    beschr = tr("<b>Name der Messsonde am Checkbutton</b><br>"
                "Gib der Messonde einen Name oder<br>"
                "den vorgegebenen Name uebernehmen:");
  }
  if(s1 == "def"){
    s1 = wobdaten.namesonde2;
  } 
  s2 = tr("HFM9/NWT Sondendatei (*.hfm)");
  //Datei ueberpruefen ob Sufix vorhanden
  if((s1.find(".")== -1)) s1 += ".hfm";
  //wenn keine Erstinitialisierung Dialog oeffnen
  if(!bersterstart){
    sondenname = QInputDialog::getText(tr("Messsondenname"), beschr,
                               QLineEdit::Normal,
                               checkboxk2->text(), &ok, this);
  }else{
    sondenname = checkboxk2->text();
    ok = true;
  }
  if(ok){
    //wenn keine Erstinitialisierung Dialog oeffnen
    if(!bersterstart){
      s = QFileDialog::getSaveFileName(
                      homedir.filePath(s1),
                      s2,
                      this, 0, tr("HFM9/NWT Sondendatei speichern"));
    }else{
      s = homedir.filePath(s1);
    }
    if (!s.isNull())
    {
      //Datei ueberpruefen ob Sufix vorhanden
      if((s.find(".")== -1)) s += ".hfm";
    }
    smerk = s;
    configfile nwt7sondenfile;
    nwt7sondenfile.open(s);
    if(wobdaten.ebetriebsart == ewobbeln){
//    wobdaten = grafik->getWobbeldaten();
      nwt7sondenfile.writeString("Sonde", sondenname);
      nwt7sondenfile.writeDouble("faktor", wobdaten.faktor2);
      nwt7sondenfile.writeDouble("shift", wobdaten.shift2);
      nwt7sondenfile.writeBool("linear", wobdaten.linear2);
      nwt7sondenfile.writeDouble("messx", wobdaten.mfaktor2);
      nwt7sondenfile.writeDouble("messy", wobdaten.mshift2);
      nwt7sondenfile.close();
      checkboxk2->setText(sondenname);
      //Filename setzen
      if((wobdaten.beichkorrk2) and (!wobdaten.linear2)){
        s.replace(QString(".hfm"), "k2.hfe");
        f.setName(homedir.filePath(s));
        if(f.open( IO_WriteOnly )){
          QTextStream ts(&f);
          for(i=0; i<eindex; i++){
            ts << neicharray.arrayk2[i] << endl;
          }
          f.close();
        }
      }	
    }  
    if(wobdaten.ebetriebsart == eswrneu){
      //Filename setzen
      s = smerk;
      s.replace(QString(".hfm"), "k2.hfs");
      f.setName(homedir.filePath(s));
      if(f.open( IO_WriteOnly )){
        QTextStream ts(&f);
        for(i=0; i<eindex; i++){
          ts << nswreicharray.arrayk2[i] << endl;
        }
        f.close();
      }
    }
  }  
}

void Nwt7linux::eichenswr(){
  QString s;

  if(!bttyOpen){
    bttyOpen = picmodem->opentty(weichen.str_tty);
    if(!bttyOpen){
      QMessageBox::warning( this, tr("Serielle Schnittstelle"), 
                                     "\"" + weichen.str_tty + tr("\" Laesst sich nicht oeffnen!"));
      printf("Nwt7linux::eichenswr\n");
      return;
    }
  }
  if (bttyOpen)
  {
    wobdaten.linear1 = false;
    checkboxk1->setChecked(true);
    checkboxk2->setChecked(false);
    buttoneinmal->setEnabled(false);
    buttonwobbeln->setEnabled(false);
    buttonstop->setEnabled(false);
    emit setmenu(emEinmal, false);
    emit setmenu(emWobbeln, false);
    emit setmenu(emStop, false);
    editanfang->setEnabled(false);
    editende->setEnabled(false);
    editschritte->setEnabled(false);
//    editschrittweite->setEnabled(false);
    wobbelstop = true;
    beichenswr = true;
    QMessageBox::warning( this, tr("Eichen SWV"),
                                tr("<B>Ermitteln SWV = 1.0</B><BR>"
                                   "SWV-Bruecke mit 50Ohm abschliessen") );
    sendwobbeln();
  }
}

void Nwt7linux::eichenkanal1(){
  QString s;
  int i;

  if(!bttyOpen){
    bttyOpen = picmodem->opentty(weichen.str_tty);
    if(!bttyOpen){
      QMessageBox::warning( this, tr("Serielle Schnittstelle"), 
                                     "\"" + weichen.str_tty + tr("\" Laesst sich nicht oeffnen!"));
#ifdef LDEBUG
      qDebug("Nwt7linux::eichenkanal1()");
#endif    
      return;
    }
  }
  if (bttyOpen)
  for(i=0;i<eindex;i++)
  {
    if(wobdaten.ebetriebsart==ewobbeln)neicharray.arrayk1[i] = 0.0;
    if(wobdaten.ebetriebsart==eswrneu)nswreicharray.arrayk1[i] = -10.0;
  }
  if(wobdaten.ebetriebsart==ewobbeln)emit sendeichdaten(neicharray);
  if(wobdaten.ebetriebsart==eswrneu)emit sendswreichdaten(nswreicharray);
  switch(wobdaten.ebetriebsart){
    case ewobbeln:
      switch( QMessageBox::information( this, tr("Art der Messsonde"),
            tr("<B>Die Messonde bitte auswaehlen</B><BR>"
            "Ist die Messsonde linear oder logarithmisch?"),
            "L&in.", "L&og.",
            0,
            1 ) ) {
        case 0:
            // Linear
            // fprintf(stderr, "Linear\n");
            wobdaten.linear1 = true;
            break;
        case 1:
            // Logarithmisch
            // fprintf(stderr, "Log\n");
            wobdaten.linear1 = false;
            break;
        }
      checkboxk1->setChecked(true);
      checkboxk2->setChecked(false);
      buttoneinmal->setEnabled(false);
      buttonwobbeln->setEnabled(false);
      buttonstop->setEnabled(false);
      emit setmenu(emEinmal, false);
      emit setmenu(emWobbeln, false);
      emit setmenu(emStop, false);
      editanfang->setEnabled(false);
      editende->setEnabled(false);
      editschritte->setEnabled(false);
      beichen40 = true;
      if(!wobdaten.linear1){
        if(wobdaten.beichkorrk1){
          //Frequenzbereiche ins Wobbelfenster uebertragen
          s.sprintf("%li",weichen.eichanfang);
          editanfang->setText(s);
          s.sprintf("%li",weichen.eichende);
          editende->setText(s);
          s.sprintf("%li",weichen.eichstep);
          editschritte->setText(s);
          wobnormalisieren();
        }
        if(weichen.bfaeich){
          setDaempfung(19); // -40dB
          daempfung1->setCurrentIndex(19);
          daempfung2->setCurrentIndex(19);
        }else{  
          setDaempfung(4); // -40dB
          daempfung1->setCurrentIndex(4);
          daempfung2->setCurrentIndex(4);
        }
        QMessageBox::warning( this, tr("Eichen Kanal 1"),
                                    tr("<B>Ermittlung der -40dB Linie</B><BR>" 
                                       "-40db-Glied einschleifen") );
      }else{
        if(weichen.bfaeich){
          setDaempfung(2); // -6dB
          daempfung1->setCurrentIndex(2);
          daempfung2->setCurrentIndex(2);
        }
        QMessageBox::warning( this, tr("Eichen Kanal 1"),
                                    tr("<B>Ermittlung der 0,5 Linie</B><BR>" 
                                       "-6db-Glied einschleifen") );
      }
      break;
    case eswrneu:
      s.sprintf("%li",weichen.eichstep);
      editschritte->setText(s);
      wobnormalisieren();
      beichenswr = true;
      beichen0 = true;
      QMessageBox::warning( this, tr("Eichen SWV"),
                                  tr("<B>Ermitteln SWV = unendlich</B><BR>"
                                     "SWV-Bruecke offen lassen oder kurzschliessen.") );
      break;
    case eswrant:
    case eimpedanz:
      break;
  }
  wobbelstop = true;
  sendwobbeln();
}

void Nwt7linux::eichenkanal2(){
  QString s;
  int i;
  
  if(!bttyOpen){
    bttyOpen = picmodem->opentty(weichen.str_tty);
    if(!bttyOpen){
      QMessageBox::warning( this, tr("Serielle Schnittstelle"),
                                  "\"" + weichen.str_tty + tr("\" Laesst sich nicht oeffnen!"));
#ifdef LDEBUG
      qDebug("Nwt7linux::eichenkanal2()\n");
#endif    
      return;
    }
  }
  if (bttyOpen)
  for(i=0;i<eindex;i++)
  {
    neicharray.arrayk2[i] = 0.0;
    nswreicharray.arrayk2[i] = -10.0;
  }
  emit sendeichdaten(neicharray);
  emit sendswreichdaten(nswreicharray);
  {
    switch( QMessageBox::information( this, tr("Art der Messsonde"),
            tr("<B>Die Messonde bitte auswaehlen</B><BR>"
            "Ist die Messsonde linear oder logarithmisch?"),
            "L&in.", "L&og.",
            0,
            1 ) ) {
      case 0:
          // Linear
          // fprintf(stderr, "Linear\n");
          wobdaten.linear2 = true;
          break;
      case 1:
          // Logarithmisch
          // fprintf(stderr, "Log\n");
          wobdaten.linear2 = false;
          break;
    }
    checkboxk1->setChecked(false);
    checkboxk2->setChecked(true);
    buttoneinmal->setEnabled(false);
    buttonwobbeln->setEnabled(false);
    buttonstop->setEnabled(false);
    emit setmenu(emEinmal, false);
    emit setmenu(emWobbeln, false);
    emit setmenu(emStop, false);
    editanfang->setEnabled(false);
    editende->setEnabled(false);
    editschritte->setEnabled(false);
    wobbelstop = true;
    beichen40 = true;
    if(!wobdaten.linear2){
      //Frequenzbereiche ins Wobbelfenster uebertragen
      if(wobdaten.beichkorrk2){
        s.sprintf("%li",weichen.eichanfang);
        editanfang->setText(s);
        s.sprintf("%li",weichen.eichende);
        editende->setText(s);
        s.sprintf("%li",weichen.eichstep);
        editschritte->setText(s);
        wobnormalisieren();
      }
      if(weichen.bfaeich){
        setDaempfung(19); // -40dB
        daempfung1->setCurrentIndex(19);
        daempfung2->setCurrentIndex(19);
      }else{  
        setDaempfung(4); // -40dB
        daempfung1->setCurrentIndex(4);
        daempfung2->setCurrentIndex(4);
      }
      QMessageBox::warning( this, tr("Eichen Kanal 2"),
                                  tr("<B>Ermittlung der -40dB Linie</B><BR>" 
                                     "-40db-Glied einschleifen") );
    }else{
      if(weichen.bfaeich){
        setDaempfung(2); // -6dB
        daempfung1->setCurrentIndex(2);
        daempfung2->setCurrentIndex(2);
      } 
      QMessageBox::warning( this, tr("Eichen Kanal 2"),
                                  tr("<B>Ermittlung der 0,5 Linie</B><BR>" 
                                     "-6db-Glied einschleifen") );
    }
    sendwobbeln();
  }
}

void Nwt7linux::clickwobbeln(){
  if(wobdaten.einkanalig){
    emit setmenu(emEichenK2, false);
    emit setmenu(emSondeLadenK2, false);
    emit setmenu(emSondeSpeichernK2, false);
    emit setmenu(emWattEichenK2, false);
  }else{
    emit setmenu(emEichenK2, true);
    emit setmenu(emSondeLadenK2, true);
    emit setmenu(emSondeSpeichernK2, true);
    emit setmenu(emWattEichenK2, true);
  }
  if(!bttyOpen){
    bttyOpen = picmodem->opentty(weichen.str_tty);
    if(!bttyOpen){
      QMessageBox::warning( this, tr("Serielle Schnittstelle"), 
                                  "\"" + weichen.str_tty + tr("\" Laesst sich nicht oeffnen!"));
#ifdef LDEBUG
      qDebug("Nwt7linux::clickwobbeln()");
#endif    
      return;
    }
  }
  if (bkurvegeladen){
    bkurvegeladen = false; //Modus ausschalten
    wobdaten = wobdatenmerk;//Alte einstellungen wieder zurueckladen
    checkboxk1->setChecked(wobdaten.bkanal1);
    checkboxk2->setChecked(wobdaten.bkanal2);
    wobbelungueltig();
    switch(wobdaten.ebetriebsart){
      case ewobbeln:
      betriebsart->setCurrentIndex (0);
      break;
      case eswrneu:
      betriebsart->setCurrentIndex (1);
      break;
      case eswrant:
      betriebsart->setCurrentIndex (2);
      break;
      case eimpedanz:
      betriebsart->setCurrentIndex (3);
      break;
    }
  }
  wobnormalisieren(); //Abgleich aller Eingabedaten
  if (bttyOpen)
  {
    bdauerwobbeln = true;
    labellupe->setEnabled(false);
    buttonlupeplus->setEnabled(false);
    buttonlupeminus->setEnabled(false);
    buttoneinmal->setEnabled(false);
    buttonwobbeln->setEnabled(false);
    buttonstop->setEnabled(true);
    daempfung1->setEnabled(false);
    daempfung2->setEnabled(false);
    emit setmenu(emEinmal, false);
    emit setmenu(emWobbeln, false);
    emit setmenu(emStop, true);
    editanfang->setEnabled(false);
    editende->setEnabled(false);
    editschritte->setEnabled(false);
    wobbelstop = false;
    setTabEnabled(nwt7vfo, false);
    setTabEnabled(nwt7messen, false);
    sendwobbeln();
    wobdaten.mousesperre = true; //Kursoraktivitaeten sperren
    fsendewobbeldaten();
  }
  //Zaehler fuer Abbruch des Datenverkehrs
  abbruchlevel=0;
  bdatenruecklauf=false;
}

void Nwt7linux::clickwobbelneinmal(){
  if(!bttyOpen){
    bttyOpen = picmodem->opentty(weichen.str_tty);
    if(!bttyOpen){
      QMessageBox::warning( this, tr("Serielle Schnittstelle"), 
                                     "\"" + weichen.str_tty + tr("\" Laesst sich nicht oeffnen!"));
#ifdef LDEBUG
      qDebug("Nwt7linux::clickwobbelneinmal()\n");
#endif    
      return;
    }
  }
  if (bkurvegeladen){
    bkurvegeladen = false; //Modus ausschalten
    wobdaten = wobdatenmerk;//Alte einstellungen wieder zurueckladen
    checkboxk1->setChecked(wobdaten.bkanal1);
    checkboxk2->setChecked(wobdaten.bkanal2);
    wobbelungueltig();
    switch(wobdaten.ebetriebsart){
      case ewobbeln:
      betriebsart->setCurrentIndex (0);
      break;
      case eswrneu:
      betriebsart->setCurrentIndex (1);
      break;
      case eswrant:
      betriebsart->setCurrentIndex (2);
      break;
      case eimpedanz:
      betriebsart->setCurrentIndex (3);
      break;
    }
  }
  wobnormalisieren(); //Abgleich aller Eingabedaten
  if (bttyOpen)
  {
    buttoneinmal->setEnabled(false);
    buttonwobbeln->setEnabled(false);
    buttonstop->setEnabled(false);
    daempfung1->setEnabled(false);
    daempfung2->setEnabled(false);
    emit setmenu(emEinmal, false);
    emit setmenu(emWobbeln, false);
    emit setmenu(emStop, false);
    editanfang->setEnabled(false);
    editende->setEnabled(false);
    editschritte->setEnabled(false);
    wobbelstop = true;
    setTabEnabled(nwt7vfo, false);
    setTabEnabled(nwt7messen, false);
    sendwobbeln();
    wobdaten.mousesperre = true; //Kursoraktivitaeten sperren
    fsendewobbeldaten();
  }
  abbruchlevel=0;
  bdatenruecklauf=false;
}

void Nwt7linux::clickwobbelnstop(){
  if (bttyOpen)
  {
    wobbelstop = true;
    buttonstop->setEnabled(false);
    emit setmenu(emStop, false);
  }
}

void Nwt7linux::sendwobbeln(){
  QString qs;
  long fanfang;
  double zf;
  
  fanfang =  wobdaten.anfangsfrequenz;
  qs = editzf->text();
  zf = linenormalisieren(qs);
  if(checkboxzf->isChecked()){
    fanfang += long(zf);
  }
  qs.sprintf("%09li%08li%04i", fanfang,
                                  wobdaten.schrittfrequenz,
                                  wobdaten.schritte);
  if(wobdaten.linear1 or wobdaten.linear2){
    qs = "w" + qs; //linear einschalten
  }else{
    qs = "x" + qs; //log einschalten
  }
  ttyindex = 0; //index zum lesen der Daten vom NWT auf 0
  if(!bttyOpen){
    bttyOpen = picmodem->opentty(weichen.str_tty);
    if(!bttyOpen){
      QMessageBox::warning( this, tr("Serielle Schnittstelle"),
                                  "\"" + weichen.str_tty + tr("\" Laesst sich nicht oeffnen!"));
#ifdef LDEBUG
      qDebug("Nwt7linux::sendwobbeln()\n");
#endif    
      return;
    }
  }
  if (bttyOpen)
  {
    defaultlesenrtty(); //eventuelle Daten im UART loeschen
    //zuerst 8fh senden Vektor fuer LinuxSW im PIC
    picmodem->writeChar(143);
    picmodem->writeLine(qs);
#ifdef LDEBUG
    qDebug("sendwobbeln()");
    qDebug(qPrintable(qs));
#endif
    wobbeltimer->start(10, true);
    progressbar->setMaximum(wobdaten.schritte * 4);
    buttoneinmal->setEnabled(false);
    buttonwobbeln->setEnabled(false);
    daempfung1->setEnabled(false);
    daempfung2->setEnabled(false);
    emit setmenu(emEinmal, false);
    emit setmenu(emWobbeln, false);
    synclevel=0;
    bdauerwobbeln = true;
  }
}

void Nwt7linux::readtty(){
  int  i, j;
  qint64 a;
  char abuffer[(maxmesspunkte * 4)];
  double yf=0.0, ys=0.0;
  unsigned char c, c1;
  //bufferlaengenmultiplikator festlegen
  int bufferfaktor = 4;
  double yaufloesung = 1024.0;
  double afrequenz;
  QString s;
 
  //Daten aus der API lesen
  if (bttyOpen){
//    a = picmodem->size();
    a = picmodem->readttybuffer(abuffer, ((wobdaten.schritte) * bufferfaktor));
#ifdef LDEBUG
    qDebug("readtty()");
#endif
    if(a>0){
#ifdef LDEBUG
//      qDebug("a>0");
#endif
      bdatenruecklauf = true;
    }
    if(a == 0){
      synclevel++; //es lagen keine Daten an
    }else{
      abbruchlevel = 0;
      synclevel = 0; //es lagen Daten an
    }
    for(i=0, j=ttyindex; i<a; i++, j++){
      ttybuffer[j] = abuffer[i]; //Die gelesenen Daten in den richtigen Buffer kopieren
    }
    ttyindex = ttyindex + a; // und den Index auf die richtige Stelle setzen
    progressbar->setValue(ttyindex);
    for(i=0, j=0; i < (ttyindex / bufferfaktor); i++, j++){
      c = ttybuffer[4 * i];
      c1 = ttybuffer[(4 * i) + 1];
      wobdaten.kanal1[i] = c + (c1 * 256);
      c = ttybuffer[(4 * i) + 2];
      c1 = ttybuffer[(4 * i) + 3];
      wobdaten.kanal2[i] = c + (c1 * 256);
    }
    if(bdatenruecklauf){
      wobdaten.daten_enable = true;
      emit sendewobbelkurve(wobdaten);
    }
  }
  if(((wobdaten.schritte) * bufferfaktor) == ttyindex){
    //Alle Daten sind vom NWT7 gelesen und werden gesplittet Kanal 1+2
    for(i=0, j=0; i < (ttyindex / bufferfaktor); i++, j++){
      c = ttybuffer[4 * i];
      c1 = ttybuffer[(4 * i) + 1];
      wobdaten.kanal1[i] = c + (c1 * 256);
      c = ttybuffer[(4 * i) + 2];
      c1 = ttybuffer[(4 * i) + 3];
      wobdaten.kanal2[i] = c + (c1 * 256);
    }
    //Wobbeldaten sind gueltig
    if(bdatenruecklauf){
      wobdaten.daten_enable = true;
    }else{
      wobdaten.daten_enable = false;
    }
    //Wobbeldaten ins Grafikfenster kopieren
    fsendewobbeldaten();
    if(wobbelstop){
      //Button + Menue wieder aktivieren
      wobdaten.mousesperre = false; //mousekursor wieder freigeben
      fsendewobbeldaten();
      bdauerwobbeln = false;
      setKursorFrequenz(KursorFrequenz);
      buttoneinmal->setEnabled(true);
      buttonwobbeln->setEnabled(true);
      buttonstop->setEnabled(false);
      if((wobdaten.ebetriebsart == eswrneu) or (wobdaten.ebetriebsart == eswrant)){
        daempfung1->setEnabled(false);
        daempfung2->setEnabled(false);
      }
      if(wobdaten.ebetriebsart == ewobbeln){
        daempfung1->setEnabled(true);
        daempfung2->setEnabled(true);
      }
      emit setmenu(emEinmal, true);
      emit setmenu(emWobbeln, true);
      emit setmenu(emStop, false);
      editanfang->setEnabled(true);
      editende->setEnabled(true);
      editschritte->setEnabled(true);
      setTabEnabled(nwt7vfo, true);
      // K1 oder K2 linear = Messfenster deaktivieren
      if(wobdaten.linear2 || wobdaten.linear1){
        setTabEnabled(nwt7messen, false);
      }else{
        setTabEnabled(nwt7messen, true);
      }
      if(beichen0){
        ym_0db = 0.0;
        //Kanal 1
        if(checkboxk1->isChecked()){
          //  Mittelwert bilden
          for(i=0; i<wobdaten.schritte; i++){
            ym_0db = ym_0db + double(wobdaten.kanal1[i]);
          }
          ym_0db = ym_0db / double(wobdaten.schritte);
          if(beichenswr){
            if(wobdaten.ebetriebsart == eswrneu){
              afrequenz = wobdaten.anfangsfrequenz;
              for(i=0; i<wobdaten.schritte; i++){
                yf = double(wobdaten.kanal1[i]) * wobdaten.faktor1 + wobdaten.shift1;
                j = int((afrequenz + (wobdaten.schrittfrequenz * i)) / eteiler);
                nswreicharray.arrayk1[j] = yf / 10.24 - 90.0;
              }
              emit sendswreichdaten(nswreicharray);
              beichenswr = false;
//qDebug("faktor1 %f shift1 %f", wobdaten.faktor1, wobdaten.shift1);	      
            }
          }else{
            if(wobdaten.linear1){
              yf = (yaufloesung * 5.0)/(11.0 * (ym_0db - ym_40db));
              ys = (yaufloesung * 5.0)/11.0 - yf * ym_40db;
            }else{
              yf = (yaufloesung * 4.0)/(10.0 * (ym_0db - ym_40db));
              ys = (yaufloesung * 5.0)/10.0 - yf * ym_40db;
            }
            wobdaten.faktor1 = yf;
            wobdaten.shift1 = ys;
            if(!wobdaten.linear1){
              afrequenz = wobdaten.anfangsfrequenz;
              for(i=0; i<wobdaten.schritte; i++){
                yf = double(wobdaten.kanal1[i]) * wobdaten.faktor1 + wobdaten.shift1;
                j = int((afrequenz + (wobdaten.schrittfrequenz * i)) / eteiler);
                neicharray.arrayk1[j] = (1024.0 * 0.9) - yf;
              }
              emit sendeichdaten(neicharray);
            }
          }
        }
        if(checkboxk2->isChecked()){
          for(i=0; i<wobdaten.schritte; i++){
            ym_0db = ym_0db + double(wobdaten.kanal2[i]);
          }
          ym_0db = ym_0db / double(wobdaten.schritte);
          if(wobdaten.linear2){
            yf = (yaufloesung * 5.0)/(11.0 * (ym_0db - ym_40db));
            ys = (yaufloesung * 5.0)/11.0 - yf * ym_40db;
          }else{
            yf = (yaufloesung * 4.0)/(10.0 * (ym_0db - ym_40db));
            ys = (yaufloesung * 5.0)/10.0 - yf * ym_40db;
          }
          wobdaten.faktor2 = yf;
          wobdaten.shift2 = ys;
          if(!wobdaten.linear2){
            afrequenz = wobdaten.anfangsfrequenz;
            for(i=0; i<wobdaten.schritte; i++){
              yf = double(wobdaten.kanal2[i]) * wobdaten.faktor2 + wobdaten.shift2;
              j = int(round(afrequenz + (wobdaten.schrittfrequenz * i)) / eteiler);
              neicharray.arrayk2[j] = (1024.0 * 0.9) - yf;
            }
            emit sendeichdaten(neicharray);
          }
        }
        //Wobbeldaten sind gueltig
        if(bdatenruecklauf){
          wobdaten.daten_enable = true;
        }else{
          wobdaten.daten_enable = false;
        }
        //Wobbeldaten ins Grafikfenster kopieren
        fsendewobbeldaten();
        if(QMessageBox::question(this, tr("Eichung speichern? -- HFM9/NWT"), 
                                       tr("<B>Speichern der Werte in der Messsondendatei</B><BR>"
                                          "Die ermittelten Werte sofort abspeichern?"),
                                 tr("&Ja"), tr("&Nein"),
                                 QString::null, 0, 1) == 0){
          if(wobdaten.ebetriebsart == eswrneu){
            messsondespeichern1(wobdaten.namesonde1);
          }
          if(wobdaten.ebetriebsart == ewobbeln){
            if(checkboxk1->isChecked()){
              if(wobdaten.linear1){
                messsondespeichern1("AD8361intern.hfm");
              }else{
                messsondespeichern1(wobdaten.namesonde1);
              }
            }
            if(checkboxk2->isChecked()){
              messsondespeichern2(wobdaten.namesonde2);
	    }
          }
        }
        beichen0 = false;
        beichenswr = false;
      }
      if(beichen40){
        ym_40db = 0.0;
        if(checkboxk1->isChecked()){
          for(i=0; i<wobdaten.schritte; i++){
            ym_40db = ym_40db + double(wobdaten.kanal1[i]);
          }
          ym_40db = ym_40db / double(wobdaten.schritte);
          setDaempfung(0); // 0 dB
          daempfung1->setCurrentIndex(0);
          daempfung2->setCurrentIndex(0);
          QMessageBox::warning( this, tr("Eichen Kanal 1"), 
                                      tr("<B>Ermitteln der 0 dB Linie</B><BR>"
                                         "Ausgang mit Eingang verbinden!"));
        }
        if(checkboxk2->isChecked()){
          for(i=0; i<wobdaten.schritte; i++){
            ym_40db = ym_40db + double(wobdaten.kanal2[i]);
          }
          ym_40db = ym_40db / double(wobdaten.schritte);
          setDaempfung(0); // 0 dB
          daempfung1->setCurrentIndex(0);
          daempfung2->setCurrentIndex(0);
          QMessageBox::warning( this, tr("Eichen Kanal 2"), 
                                      tr("<B>Ermitteln der 0 dB Linie</B><BR>"
                                         "Ausgang mit Eingang verbinden!"));
        }
        beichen40 = false;
        beichen0 = true;
        //erneut wobbeln
        sendwobbeln();
        //Timer starten fuer lesen der NWT7 Daten
        wobbeltimer->start(10, true);
      }
    }else{
      //erneut wobbeln
      sendwobbeln();
      //Timer starten fuer lesen der NWT7 Daten
      wobbeltimer->start(10, true);
    }  
  }else{
    //Alle Daten sind noch nicht gelesen Timer neu starten
    if(synclevel >=20){
      abbruchlevel++;
      if(abbruchlevel > 5){
        //Abbruch der Funktionen
        QMessageBox::warning( this, tr("Serielle Schnittstelle"), 
                                    tr("Es kommen keine Daten vom HFM9/NWT!"));
#ifdef LDEBUG
        qDebug("Nwt7linux::readtty()");
#endif
        wobbelstop = true;
        buttoneinmal->setEnabled(true);
        buttonwobbeln->setEnabled(true);
        buttonstop->setEnabled(false);
        if((wobdaten.ebetriebsart == eswrneu) or 
	   (wobdaten.ebetriebsart == eswrant) or
	   (wobdaten.ebetriebsart == eimpedanz)){
          daempfung1->setEnabled(false);
          daempfung2->setEnabled(false);
        }
        if(wobdaten.ebetriebsart == ewobbeln){
          daempfung1->setEnabled(true);
          daempfung2->setEnabled(true);
        }
        emit setmenu(emEinmal, true);
        emit setmenu(emWobbeln, true);
        emit setmenu(emStop, false);
        editanfang->setEnabled(true);
        editende->setEnabled(true);
        editschritte->setEnabled(true);
        setTabEnabled(nwt7vfo, true);
        // K1 oder K2 linear = Messfenster deaktivieren
        if(wobdaten.linear2 || wobdaten.linear1){
          setTabEnabled(nwt7messen, false);
        }else{
          if(wobdaten.ebetriebsart == ewobbeln){
            setTabEnabled(nwt7messen, true);
          }
        }
        return;
      }else{
        synclevel = 0;
        sendwobbeln();
        wobbeltimer->start(10, true);
        return;
      }
    }
    wobbeltimer->start(10, true);
  }
}

void Nwt7linux::checkboxgrafik_checked(bool b){
  //geaenderter Darstellung
  wobdaten.bandbreitegrafik = b;
  //Daten ins Grafikfenster uebermitteln und neu darstellen
  fsendewobbeldaten();
}

void Nwt7linux::checkbox6db_checked(bool b){
  //geaenderter Darstellung
  wobdaten.bandbreite6db = b;
  if(b)wobdaten.bandbreitegrafik = b;
  if(b)checkboxgrafik->setChecked(b);
  //Daten ins Grafikfenster uebermitteln und neu darstellen
  fsendewobbeldaten();
}

void Nwt7linux::checkbox3db_checked(bool b){
  //geaenderter Darstellung
  wobdaten.bandbreite3db = b;
  if(b)wobdaten.bandbreitegrafik = b;
  if(b)checkboxgrafik->setChecked(b);
  //Daten ins Grafikfenster uebermitteln und neu darstellen
  fsendewobbeldaten();
}

void Nwt7linux::checkboxk1_checked(bool b){
  //geaenderter Darstellung Kanal 1
  wobdaten.bkanal1 = b;
  //Daten ins Grafikfenster uebermitteln und neu darstellen
  fsendewobbeldaten();
}

void Nwt7linux::checkboxk2_checked(bool b){
  //geaenderter Darstellung Kanal 2
  wobdaten.bkanal2 = b;
  //Daten ins Grafikfenster uebermitteln und neu darstellen
  fsendewobbeldaten();
}

void Nwt7linux::setBetriebsart(int i){
  QString qs;

  switch(i){
    case 0:
      wobdaten.ebetriebsart = ewobbeln;
      emit setmenu(emEichenK1, true);
      if(!wobdaten.einkanalig){
        emit setmenu(emEichenK2, true);
        checkboxk2->setEnabled(true);
        emit setmenu(emSondeSpeichernK2, true);
        emit setmenu(emSondeLadenK2, true);
      }	
      checkboxk1->setEnabled(true);
      checkboxgrafik->setEnabled(true);
      checkbox3db->setEnabled(true);
      checkbox6db->setEnabled(true);
      daempfung1->setEnabled(true);
      daempfung2->setEnabled(true);
      aufloesung->setEnabled(false);
      labelaufloesung->setEnabled(false);
//      setTabEnabled(nwt7messen, true);
      labela_100->setEnabled(false);
      labelkabellaenge->setEnabled(false);
      edita_100->setEnabled(false);
      editkabellaenge->setEnabled(false);
      boxdbshift1->setEnabled(true);
      boxdbshift2->setEnabled(true);
      labelboxdbshift1->setEnabled(true);
      labelboxdbshift2->setEnabled(true);
      break;
    case 1:  
      wobdaten.ebetriebsart = eswrneu;
      emit setmenu(emEichenK1, true);
      emit setmenu(emEichenK2, false);
      emit setmenu(emSondeSpeichernK2, false);
      emit setmenu(emSondeLadenK2, false);
      checkboxk1->setChecked(true);
      checkboxk2->setChecked(false);
      checkboxk1->setEnabled(false);
      if(!wobdaten.einkanalig)checkboxk2->setEnabled(false);
      checkboxgrafik->setEnabled(false);
      checkbox3db->setEnabled(false);
      checkbox6db->setEnabled(false);
      //Relais auf 0dB schalten
      daempfung1->setCurrentIndex(0); 
      daempfung1->setEnabled(false);
      daempfung2->setCurrentIndex(0); 
      daempfung2->setEnabled(false);
      aufloesung->setEnabled(true);
      labelaufloesung->setEnabled(true);
//      setTabEnabled(nwt7messen, false);
      labela_100->setEnabled(false);
      labelkabellaenge->setEnabled(false);
      edita_100->setEnabled(false);
      editkabellaenge->setEnabled(false);
      boxdbshift1->setCurrentIndex(20);
      boxdbshift2->setCurrentIndex(20);
      boxdbshift1->setEnabled(false);
      boxdbshift2->setEnabled(false);
      labelboxdbshift1->setEnabled(false);
      labelboxdbshift2->setEnabled(false);
      break;
    case 2:  
      wobdaten.ebetriebsart = eswrant;
      emit setmenu(emEichenK1, false);
      emit setmenu(emEichenK2, false);
      emit setmenu(emSondeSpeichernK2, false);
      emit setmenu(emSondeLadenK2, false);
      checkboxk1->setChecked(true);
      checkboxk2->setChecked(false);
      checkboxk1->setEnabled(false);
      if(!wobdaten.einkanalig)checkboxk2->setEnabled(false);
      checkboxgrafik->setEnabled(false);
      checkbox3db->setEnabled(false);
      checkbox6db->setEnabled(false);
      //Relais auf 0dB schalten
      daempfung1->setCurrentIndex(0); 
      daempfung1->setEnabled(false);
      daempfung2->setCurrentIndex(0); 
      daempfung2->setEnabled(false);
      aufloesung->setEnabled(true);
      labelaufloesung->setEnabled(true);
      labela_100->setEnabled(true);
      labelkabellaenge->setEnabled(true);
      edita_100->setEnabled(true);
      editkabellaenge->setEnabled(true);
      boxdbshift1->setCurrentIndex(20);
      boxdbshift2->setCurrentIndex(20);
      boxdbshift1->setEnabled(false);
      boxdbshift2->setEnabled(false);
      labelboxdbshift1->setEnabled(false);
      labelboxdbshift2->setEnabled(false);
//      setTabEnabled(nwt7messen, false);
      break;
    case 3:  
      wobdaten.ebetriebsart = eimpedanz;
      emit setmenu(emEichenK1, false);
      emit setmenu(emEichenK2, false);
      emit setmenu(emSondeSpeichernK2, false);
      emit setmenu(emSondeLadenK2, false);
      checkboxk1->setChecked(true);
      checkboxk1->setChecked(true);
      checkboxk2->setChecked(false);
      checkboxk1->setEnabled(false);
      if(!wobdaten.einkanalig)checkboxk2->setEnabled(false);
      checkboxgrafik->setEnabled(false);
      checkbox3db->setEnabled(false);
      checkbox6db->setEnabled(false);
      //Relais auf 0dB schalten
      daempfung1->setCurrentIndex(0); 
      daempfung1->setEnabled(false);
      daempfung2->setCurrentIndex(0); 
      daempfung2->setEnabled(false);
      aufloesung->setEnabled(false);
      labelaufloesung->setEnabled(false);
      labela_100->setEnabled(false);
      labelkabellaenge->setEnabled(false);
      edita_100->setEnabled(false);
      editkabellaenge->setEnabled(false);
//      setTabEnabled(nwt7messen, false);
      boxdbshift1->setCurrentIndex(20);
      boxdbshift2->setCurrentIndex(20);
      boxdbshift1->setEnabled(false);
      boxdbshift2->setEnabled(false);
      labelboxdbshift1->setEnabled(false);
      labelboxdbshift2->setEnabled(false);
      if(!bkurvegeladen){
        QMessageBox::warning( this, tr("Impedanzmessung mit Serienwiderstand 50 Ohm"), 
                                    tr("<B>Impedanzmessung Z (absolut)</B><BR>"
                                       "Fuer die richtige Anzeige des absoluten Z-Wertes "
                                       "muss ein Widerstand von 50 Ohm am Messkopfausgang "
                                       "in Serie eingeschleift werden."));
      }
      break;
  }
  //Daten ins Grafikfenster uebermitteln und neu darstellen
  fsendewobbeldaten();
}

void Nwt7linux::readanfang(double a)
{
  QString s;
  s.sprintf("%-9.0f",a);
  editanfang->setText(s);
}

void Nwt7linux::readende(double a)
{
  QString s;
  s.sprintf("%-9.0f",a);
  editende->setText(s);
}

//Eingabeumwandlung mit "m" und "k"
double Nwt7linux::linenormalisieren(const QString line)
{
  bool ok;
  int pos, l;
  double faktor=1.0;
  double ergebnis = 0.0;
  
  QString aline(line);
  aline.lower();	//alles auf Kleinschreibung
  l = aline.length();
  pos = aline.find('m',0,false);
  if(pos != -1){
    if((l-1) == pos){
      aline.remove(pos,1);
    }else{
      aline.replace(pos,1,'.');
    }  
    faktor = 1000000.0;
  }
  pos = aline.find('k',0,false);
  if(pos != -1){
    if((l-1) == pos){
      aline.remove(pos,1);
    }else{
      aline.replace(pos,1,'.');
    }  
    faktor = 1000.0;
  }
  ergebnis = aline.toDouble(&ok);
  ergebnis *= faktor;
  return ergebnis;
}

void Nwt7linux::swrantaendern(){
  QString qs;
  double a_100 = 0.0;
  double laenge = 0.0;
  bool ok;

  qs = edita_100->text();
  a_100 = qs.toDouble(&ok);
  if(ok){
    wobdaten.a_100 = a_100;
  }else{
    wobdaten.a_100 = 0.0;
  }
  qs = editkabellaenge->text();
  laenge = qs.toDouble(&ok);
  if(ok){
    wobdaten.kabellaenge = laenge;
  }else{
    wobdaten.kabellaenge = 0.0;
  }
  fsendewobbeldaten();
}

void Nwt7linux::wobnormalisieren(){
  double anfang, ende, schritte, schrittweite;
  QString sanfang, sende, sschritte, sschrittweite, sdbshift1, sdbshift2;
  double schrittmax = double(maxmesspunkte);
  bool ok;
  
  //Werte aus den Editfenster lesen
  sanfang = editanfang->text();
  sende = editende->text();
  sschritte = editschritte->text();
  sschrittweite = editschrittweite->text();
  sdbshift1 = boxdbshift1->currentText();
  sdbshift2 = boxdbshift2->currentText();
  //Alle wichtigen werte sind gefuellt ?
  if((sanfang.length() > 0) & (sende.length() > 0) & (sschritte.length() > 0)){
    wobdaten.dbshift1 = sdbshift1.toDouble(&ok);
    wobdaten.dbshift2 = sdbshift2.toDouble(&ok);
    schritte = sschritte.toDouble(&ok);
    if(schritte < 2.0){
      schritte = 2.0;
      sschritte.sprintf("%1.0f",schritte);
      editschritte->setText(sschritte);
    }
    if(schritte > schrittmax){
      schritte = schrittmax;
      sschritte.sprintf("%1.0f",schritte);
      editschritte->setText(sschritte);
    }
    //Sind Schriite = 0.0 sofort unterbrechen
    if(schritte == 0.0) return;
    anfang = linenormalisieren(sanfang);
    ende = linenormalisieren(sende);
    if(ende > weichen.maxwobbel){
      ende = weichen.maxwobbel;
      QString qs;
      qs.sprintf("Maximum sind %3.0f MHz!",weichen.maxwobbel / 1000000.0);
      QMessageBox::warning( this, tr("Endfrequenz"), 
                                  tr("<B>Oberste Frequenzgrenze ist erreicht.</B><BR>"
                                     + qs));
    }
    if(anfang >= ende){
      ende = anfang + 1.0; //min um 1  erhoehen
    }
    schrittweite = sschrittweite.toDouble(&ok);
    schrittweite = qRound((ende - anfang) / (schritte - 1.0));
    //sind die Schritte kleiner als 1.0
    if(schrittweite < 1.0){
      schrittweite = 1.0;
      ende = anfang + (schritte - 1.0) * schrittweite;
    }
    ende = qRound(anfang + (schritte - 1) * schrittweite);
    sanfang.sprintf("%1.0f",anfang);
    sende.sprintf("%1.0f",ende);
    sschrittweite.sprintf("%1.0f",schrittweite);
    editanfang->setText(sanfang);
    editende->setText(sende);
    editschrittweite->setText(sschrittweite);
    //Daten ins Grafikfenster uebermitteln
    ok = true;
    if(wobdaten.anfangsfrequenz != int(anfang))ok = false;
    wobdaten.anfangsfrequenz = int(anfang);
    if(wobdaten.schritte != int(schritte))ok = false;
    wobdaten.schritte = int(schritte);
    if(wobdaten.schrittfrequenz != int(schrittweite))ok = false;
    wobdaten.schrittfrequenz = int(schrittweite);
    if(!ok)wobbelungueltig();
    fsendewobbeldaten();
  }
}

void Nwt7linux::mleditloeschen(){
  mledit->setText("");
  if(!layoutlabel.isEmpty()){
    mledit->insertLine(layoutlabel);
    mledit->insertLine(" ");
  }
}

void Nwt7linux::mleditinsert(QString s){
  mledit->insertLine(s);
}

///////////////////////////////////////////////////////////////////////////////
// Funktionen im Messfenster

void Nwt7linux::tabellespeichern(){
  QFile f;
  QString s = QFileDialog::getSaveFileName(
                    homedir.filePath("messtab.txt"),
                    "Textdatei (*.txt)",
                    this, 0, tr("HFM9/NWT Messwerte speichern"));
  if (!s.isNull())
  {
    //Datei ueberpruefen ob Sufix vorhanden
    if((s.find(".")== -1)) s += ".txt";
    f.setName(s);
    if(f.open( IO_WriteOnly )){
      QTextStream ts(&f);
      ts << messedit->text();
      messedit->setModified( FALSE );
      f.close();
    }
  }
}

void Nwt7linux::tabelleschreiben(){
  btabelleschreiben = true;
}

void Nwt7linux::messsetfont(){
  bool ok;
  
  messfont = QFontDialog::getFont( &ok, messfont, this);
  if(ok){
    messlabel1->setFont(messfont);
    messlabel2->setFont(messfont);
    messlabel3->setFont(messfont);
    messlabel4->setFont(messfont);
    messlabel5->setFont(messfont);
    messlabel6->setFont(messfont);
    lmhz->setFont(messfont);
    lkhz->setFont(messfont);
    lhz->setFont(messfont);
  }
}

//Funktion Befehl zur Messwertausgabe an die Baugruppe senden


void Nwt7linux::setmessen(){
  QString qs;

  qs= "m";
  if(!bttyOpen){
    bttyOpen = picmodem->opentty(weichen.str_tty);
    if(!bttyOpen){
      QMessageBox::warning( this, tr("Serielle Schnittstelle"), 
                                     "\"" + weichen.str_tty + tr("\" Laesst sich nicht oeffnen!"));
#ifdef LDEBUG
      qDebug("Nwt7linux::setmessen()");
#endif    
      return;
    }
  }
  if (bttyOpen)
  {
    progressbarmessk1->setMaximum(maxmessstep);
    progressbarmessk2->setMaximum(maxmessstep);
//    defaultlesenrtty(); //eventuelle Daten im UART loeschen
    picmodem->writeChar(143);

    picmodem->writeLine(qs);
    messtimer->start(10, true); //Timer starten
  }  
}

//Nach Timerablauf Messdaten holen

void Nwt7linux::getmessdaten(){
  char abuffer[10];
  unsigned char c1, c2;
  int i1, i2, a;
  QString qs, qsline;
  double w, wzu;
  double uv;
  double p;
  bool ok;
  int maxcount = 10;
  bool anzeigeneu;

  if (bttyOpen){
    a = picmodem->readttybuffer(abuffer, 10);
    if(a >= 4){
      c1 = abuffer[0];
      c2 = abuffer[1];
      i1 = int(c1 + c2 * 256);
      c1 = abuffer[2];
      c2 = abuffer[3];
      i2 = int(c1 + c2 * 256);
      messcounter++;
      messungk1 += double(i1);
      messungk2 += double(i2);
      anzeigeneu = false;
      if(messcounter==maxcount){
      messcounter=0;
      if((messungk1/maxcount) > messungk1alt){
        anzeigeneu = true;
        messungk1alt = messungk1/maxcount;
        counterspitzek1 = 0;
      }else{
        counterspitzek1 ++;
        if(counterspitzek1 > 8){
          anzeigeneu = true;
          counterspitzek1 = 0;
          messungk1alt = 0.0;
        }
      }
        if(anzeigeneu){
	  //Kanal 1
          qs.sprintf("%i",int(messungk1/maxcount));
          mlabelk1->setText(qs);
          if((messungk1/maxcount)>maxmessstep){
            progressbarmessk1->setValue(maxmessstep);
          }else{
            progressbarmessk1->setValue(int(messungk1/maxcount));
          }
        }
	//aus den Eichfaktoren den richtigen Wert errechnen
        w = wobdaten.mfaktor1 * (messungk1/maxcount) + wobdaten.mshift1;
        qs = ldaempfungk1->currentText();
        wzu = qs.toDouble(&ok);
        if(ok)w += wzu;
        w = w + woffset1;
        qs.sprintf("%2.1f dBm", w);
        qsline = qs;
        if(anzeigeneu)messlabel1->setText(qs);
        //aus dBm Volt errechnen
        uv = sqrt((pow(10.0 , w/10.0) * 0.001) * 50.0);
        p = uv * uv / 50.0;
        //Messbereche automatisch umschalten
        if (uv > 0.999){
          qs.sprintf("%3.1f V", uv);
        }
        if (uv < 1.0){
          uv = uv * 1000.0;
          qs.sprintf("%3.1f mV", uv);
        }
        if (uv < 1.0){
          uv = uv * 1000.0;
          qs.sprintf("%3.1f uV", uv);
        }
        if(anzeigeneu)messlabel3->setText(qs);
        qsline = qsline + "; " + qs;
        if (p > 0.999){
          qs.sprintf("%3.1f W", p);
        }
        if (p < 1.0){
          p = p * 1000.0;
          qs.sprintf("%3.1f mW", p);
        }
        if (p < 1.0){
          p = p * 1000.0;
          qs.sprintf("%3.1f uW", p);
        }
        if (p < 1.0){
          p = p * 1000.0;
          qs.sprintf("%3.1f nW", p);
        }
        if (p < 1.0){
          p = p * 1000.0;
          qs.sprintf("%3.1f pW", p);
        }
        if(anzeigeneu)messlabel5->setText(qs);
        qsline = qsline + "; " + qs;
        //Kanal 2 
        if(!wobdaten.einkanalig){ 
                  anzeigeneu = false;	
          if((messungk2/maxcount) > messungk2alt){
            anzeigeneu = true;
            messungk2alt = messungk2/maxcount;
            counterspitzek2 = 0;
          }else{
            counterspitzek2 ++;
            if(counterspitzek2 > 8){
              anzeigeneu = true;
              counterspitzek2 = 0;
              messungk2alt = 0.0;
            }  
          }
          if(anzeigeneu){
            qs.sprintf("%i",int(messungk2/maxcount));
            mlabelk2->setText(qs);
            if((messungk2/maxcount)>maxmessstep){
              progressbarmessk2->setValue(maxmessstep);
            }else{
              progressbarmessk2->setValue(int(messungk2/maxcount));
            }
          }
	  //aus den Eichfaktoren den richtigen Wert errechnen
          w = wobdaten.mfaktor2 * (messungk2/maxcount) + wobdaten.mshift2;
          qs = ldaempfungk2->currentText();
          wzu = qs.toDouble(&ok);
          if(ok)w += wzu;
          w = w + woffset2;
          qs.sprintf("%2.1f dBm", w);
          if(anzeigeneu)messlabel2->setText(qs);
          qsline = qsline + "\t" + qs;
          //aus dBm Volt errechnen
          uv = sqrt((pow(10.0 , w/10.0) * 0.001) * 50.0);
          p = uv * uv / 50.0;
          //Messbereche automatisch umschalten
          if (uv > 0.999){
            qs.sprintf("%3.1f V", uv);
          }
          if (uv < 1.0){
            uv = uv * 1000.0;
            qs.sprintf("%3.1f mV", uv);
          }
          if (uv < 1.0){
            uv = uv * 1000.0;
            qs.sprintf("%3.1f uV", uv);
          }
          if(anzeigeneu)messlabel4->setText(qs);
          qsline = qsline + "; " + qs;

          if (p > 0.999){
            qs.sprintf("%3.1f W", p);
          }
          if (p < 1.0){
            p = p * 1000.0;
            qs.sprintf("%3.1f mW", p);
          }
          if (p < 1.0){
            p = p * 1000.0;
            qs.sprintf("%3.1f uW", p);
          }
          if (p < 1.0){
            p = p * 1000.0;
            qs.sprintf("%3.1f nW", p);
          }
          if (p < 1.0){
            p = p * 1000.0;
            qs.sprintf("%3.1f pW", p);
          }
          if(anzeigeneu)messlabel6->setText(qs);
          qsline = qsline + "; " + qs;
        }
        if (bmeichenk1_20db){
          bmeichenk1_20db = false;
          ym_40db = messungk1/maxcount;
        //jetzt wobdaten.mfaktor1 und wobdaten.mshift1 ausrechnen
          wobdaten.mfaktor1 = ym_daempf/(ym_0db - ym_40db);
          wobdaten.mshift1 = ((ym_0db * wobdaten.mfaktor1) * -1.0) + ym_gen;
          qDebug("Kanal 1: faktor=%f shift=%f", wobdaten.mfaktor1, wobdaten.mshift1);
          if(QMessageBox::question(this, tr("Eichung speichern? -- HFM9/NWT"), 
                                         tr("<B>Speichern der Werte in der Messsondendatei</B><BR>"
                                            "Die ermittelten Werte sofort abspeichern?"),
                                         tr("&Ja"), tr("&Nein"),
                                         QString::null, 0, 1) == 0){
              messsondespeichern1(wobdaten.namesonde1);
          }else{
            QMessageBox::warning( this, tr("Speicher der Ergebnisse"),
                                        tr("<B>Speichern der Werte in der Messsondendatei</B><BR>"
                                           "Die ermittelten Daten koennen unter<BR>"
                                           "(Wobbeln) (Eigenschaften Messsonde Kanal 1 speichern)<BR>"
                                           "abgespeichert werden !" ));
          }
        }
        if (bmeichenk1_0db){
          bmeichenk1_0db = false;
          ym_0db = messungk1/maxcount;
          QString beschr("<b>Eichen Kanal 1</b><br>"
                          "1. Den Pegel mit einem Daempfungsglied verringern.<br>"
                          "   Das Daempfungsglied sollte min. 20dB betragen.<br>"
                          "   <br><br>"
                          "Werte des Daempfungsgliedes (dB):");
          ym_daempf = QInputDialog::getDouble(this, tr("Eichen Kanal 1"),
                                                    beschr, 20.0, 20, 90, 2, &ok);
          if(ok)bmeichenk1_20db = true;
        }
        if (bmeichenk2_20db){
          bmeichenk2_20db = false;
          ym_40db = messungk2/maxcount;
        //jetzt wobdaten.mfaktor2 und wobdaten.mshift2 ausrechnen
          wobdaten.mfaktor2 = ym_daempf/(ym_0db - ym_40db);
          wobdaten.mshift2 = ((ym_0db * wobdaten.mfaktor2) * -1.0) + ym_gen;
          qDebug("Kanal 2: faktor=%f shift=%f", wobdaten.mfaktor2, wobdaten.mshift2);
          wobdaten.mfaktor2 = 20.0/(ym_0db - ym_40db);
          wobdaten.mshift2 = (ym_0db * wobdaten.mfaktor2) * -1.0;
          if(QMessageBox::question(this, tr("Eichung speichern? -- HFM9/NWT"), 
                                         tr("<B>Speichern der Werte in der Messsondendatei</B><BR>"
                                            "Die ermittelten Werte sofort abspeichern?"),
                                   "&Ja", "&Nein",
                                   QString::null, 0, 1) == 0){
              messsondespeichern2(wobdaten.namesonde2);
          }else{
            QMessageBox::warning( this, tr("Speicher der Ergebnisse"),
                                        tr("<B>Speichern der Werte in der Messsondendatei</B><BR>"
                                           "Die ermittelten Daten koennen unter<BR>"
                                           "(Wobbeln) (Eigenschaften Messsonde Kanal 2 speichern)<BR>"
                                           "abgespeichert werden !" ));
          }
        }
        if (bmeichenk2_0db){
          bmeichenk2_0db = false;
          bmeichenk2_20db = true;
          QString beschr("<b>Eichen Kanal 2</b><br>"
                          "1. Den Pegel mit einem Daempfungsglied verringern.<br>"
                          "   Das Daempfungsglied sollte min. 20dB betragen.<br>"
                          "   <br><br>"
                          "Werte des Daempfungsgliedes (dB):");
          ym_daempf = QInputDialog::getDouble(this, tr("Eichen Kanal 2"),
                                                    beschr, 20.0, 20, 90, 2, &ok);
          if(ok)bmeichenk2_20db = true;
        }
        if(btabelleschreiben){
          btabelleschreiben = false;
          messedit->insertLine(qsline);
        }
        messungk1 = 0.0;
        messungk2 = 0.0;
      }
      if(bmessen){
        setmessen(); //und Messung neu starten
      }
    }
  }
}

void Nwt7linux::meichenk1(){
  bool ok;
  ym_gen = 4.25;
  QString beschr("<b>Eichen Kanal 1</b><br>"
                 "1. Einen bekannten HF-Pegel an den Messeingang anlegen.<br>"
                 "   Das kann auch der HF-Ausgang des Netzwerktesters sein.<br>"
                 "   Beim NWT01 betraegt der Ausgangspegel bei 1MHz +4,25dBm.<br>"
                 "   Dieser Wert wird als Default unten eingeblendet.<br>"
                 "<br>"
                 "2. Im Ablauf der Eichung wird ein genau bekanntes Daempfungsglied<br>"
                 "   eingeschleift. Das Daempfungsglied sollte min. 20dB betragen.<br>"
                 "   Aus diesen beiden Messergebnissen werden die Funktionskonstanden <br>"
                 "   errechnet die anschliessend in der Messsondendatei abgespeichert <br>"
                 "   werden muessen.<br>"
                 "<br>"
                 "<br>"
                 "Pegel des HF-Generators (dBm):");
  ym_gen = QInputDialog::getDouble(this, tr("Eichen Kanal 1"),
                                           beschr, ym_gen, -20, 10, 2, &ok); 
  if(ok)bmeichenk1_0db = true;
  ym_0db = 0.0;
  ym_40db = 0.0;
}

void Nwt7linux::meichenk2(){
  bool ok;
  ym_gen = 4.25;
  QString beschr("<b>Eichen Kanal 2</b><br>"
                 "1. Einen bekannten HF-Pegel an den Messeingang anlegen.<br>"
                 "   Das kann auch der HF-Ausgang des Netzwerktesters sein.<br>"
                 "   Beim NWT01 betraegt der Ausgangspegel bei 1MHz +4,25dBm.<br>"
                 "   Dieser Wert wird als Default unten eingeblendet.<br>"
                 "<br>"
                 "2. Im Ablauf der Eichung wird ein genau bekanntes Daempfungsglied<br>"
                 "   eingeschleift. Das Daempfungsglied sollte min. 20dB betragen.<br>"
                 "   Aus diesen beiden Messergebnissen werden die Funktionskonstanden <br>"
                 "   errechnet die anschliessend in der Messsondendatei abgespeichert <br>"
                 "   werden muessen.<br>"
                 "<br>"
                 "<br>"
                 "Pegel des HF-Generators (dBm):");
  ym_gen = QInputDialog::getDouble(this, tr("Eichen Kanal 2"),
                                           beschr, ym_gen, -20, 10, 2, &ok); 
  if(ok)bmeichenk2_0db = true;
  ym_0db = 0.0;
  ym_40db = 0.0;
}


///////////////////////////////////////////////////////////////////////////////
// Funktionen im Hauptfenster

void Nwt7linux::defaultlesenrtty(){
  char abuffer[(maxmesspunkte * 4)];
  int a;

  if (bttyOpen){
    a = picmodem->readttybuffer(abuffer, (maxmesspunkte * 4));
  }
}

/*
void Nwt7linux::resizeEvent( QResizeEvent * ){
  //nach Groessenaenderung grafische Elemente anpassen
  qDebug("Nwt7linux::resizeEvent");
  qDebug("breite %i hoehe %i", width(), height());
  nwt7wobbeln->resize(width(), height());
  grafiksetzen();
}
*/

void Nwt7linux::tabumschalten( QWidget *wg ){
  if(wg == nwt7wobbeln){
    emit setmenu(emmenuKurven, true);
    emit setmenu(emmenuwobbel, true);
    emit setmenu(emmenuvfo, false);
    emit setmenu(emmenumessen, false);
    emit setmenu(emLayoutlabel, true);
    emit setmenu(emDrucken, true);
    emit setmenu(emDruckenpdf, true);
    bmessen = false;
  }
  if(wg == nwt7vfo){
    emit setmenu(emmenuKurven, false);
    emit setmenu(emmenuwobbel, false);
    emit setmenu(emmenuvfo, true);
    emit setmenu(emmenumessen, false);
    emit setmenu(emLayoutlabel, false);
    emit setmenu(emDrucken, false);
    emit setmenu(emDruckenpdf, false);
    setVfo();
    //und die Drehgeber setzen
    dialsetzen();
    bmessen = false;
    Dial1hz->setFocus();
  }
  if(wg == nwt7messen){
    emit setmenu(emmenuKurven, false);
    emit setmenu(emmenuwobbel, false);
    emit setmenu(emmenuvfo, false);
    emit setmenu(emmenumessen, true);
    emit setmenu(emLayoutlabel, false);
    emit setmenu(emDrucken, false);
    emit setmenu(emDruckenpdf, false);
//    defaultlesenrtty(); //eventuelle Daten im UART loeschen
    setmessen();
    bmessen = true;
  }
}

void Nwt7linux::grafiksetzen(){

///////////////////////////////////////////////
// zuerst den VFO bereich

  nwt7vfo->setGeometry(0,0,5000,5000);
  Dial1mhz->setGeometry(400,50,100,100);
  lmhz->setGeometry(550,80,100,50);
  Dial1khz->setGeometry(400,150,100,100);
  lkhz->setGeometry(550,180,100,50);
  Dial1hz->setGeometry(400,250,100,100);
  lhz->setGeometry(550,280,100,50);
  editvfo->setGeometry(30,10,150,30);
  labelvfo->setGeometry(190,10,90,30);
  LCD1->setGeometry(30,50,300,60);
  rb1->setGeometry(340,50,20,60);
  LCD2->setGeometry(30,120,300,60);
  rb2->setGeometry(340,120,20,60);
  LCD3->setGeometry(30,190,300,60);
  rb3->setGeometry(340,190,20,60);
  LCD4->setGeometry(30,260,300,60);
  rb4->setGeometry(340,260,20,60);
  LCD5->setGeometry(30,330,300,60);
  rb5->setGeometry(340,330,20,60);
  editzf->setGeometry(60,395,100,20);
  checkboxzf->setGeometry(200,395,250,20);
  checkboxiqvfo->setGeometry(200,420,250,20);
  labelzf->setGeometry(30,395,25,20);
  labelhz->setGeometry(170,395,25,20);
  daempfung2->setGeometry(250,14,60,20);
  labeldaempfung1->setGeometry(320,14,120,20);

//wobbelfenster

  int gbreite = 800;
  int ghoehe = 610;
  
  gbreite = width() - 250;
  ghoehe = height() - 140;
  
  editanfang->setGeometry(gbreite + 30,20,100,20);
  editende->setGeometry(gbreite + 30,40,100,20);
  editschrittweite->setGeometry(gbreite + 30,60,100,20);
  editschritte->setGeometry(gbreite + 30,80,100,20);
  progressbar->setGeometry(gbreite + 30,105,50,10);
  checkboxk1->setGeometry(gbreite + 30,117,200,20);
  checkboxk2->setGeometry(gbreite + 30,135,200,20);
  daempfung1->setGeometry(gbreite + 30,160,80,20);
  labeldaempfung->setGeometry(gbreite + 115,160, 120, 20);
  buttonwobbeln->setGeometry(20, ghoehe + 22, 80, 35);
  buttoneinmal->setGeometry(105, ghoehe + 22, 80, 35);
  buttonstop->setGeometry(190, ghoehe + 22, 80, 35);
  labellupe->setGeometry(50,ghoehe +62, 150, 20);
  buttonlupeplus->setGeometry(200, ghoehe + 60 , 30, 20);
  buttonlupeminus->setGeometry(230, ghoehe + 60 , 30, 20);
  grafik->setGeometry(20, 10, gbreite, ghoehe);
  mledit->setGeometry(gbreite + 30, 185, 200, ghoehe - 175);
  checkbox3db->setGeometry(280,ghoehe + 20, 150, 20);
  checkbox6db->setGeometry(280,ghoehe + 40, 2250, 20);
  checkboxgrafik->setGeometry(415 ,ghoehe + 20, 60, 20);
  betriebsart->setGeometry(490, ghoehe + 40, 100, 20);
  labelbetriebsart->setGeometry(490, ghoehe + 20,150, 20);
  aufloesung->setGeometry(600, ghoehe + 40, 130, 20);
  labelaufloesung->setGeometry(600, ghoehe + 20, 130, 20);
  labelanfang->setGeometry(gbreite + 135,20,100,20);
  labelende->setGeometry(gbreite + 135, 40, 100, 20);
  labelschrittweite->setGeometry(gbreite + 135, 60, 100, 20);
  labelschritte->setGeometry(gbreite + 135, 80, 100, 20);
  labela_100->setGeometry(490, ghoehe + 60, 120, 20);
  edita_100->setGeometry(490, ghoehe + 80, 120, 20);
  labelkabellaenge->setGeometry(620, ghoehe + 60, 110, 20);
  editkabellaenge->setGeometry(620, ghoehe + 80, 110, 20);
  labelboxdbshift1->setGeometry(280, ghoehe + 60, 50, 20);
  labelboxdbshift2->setGeometry(340, ghoehe + 60, 50, 20);
  boxdbshift1->setGeometry(280, ghoehe + 80, 50, 20);
  boxdbshift2->setGeometry(340, ghoehe + 80, 50, 20);
  labelkursornr->setGeometry(400, ghoehe + 60, 50, 20);
  boxkursornr->setGeometry(400, ghoehe + 80, 50, 20);

//messfenster
  progressbarmessk1->setGeometry(10,60,600,20);
  progressbarmessk2->setGeometry(10,160,600,20);
  boxwattoffset1->setGeometry(10,81,180,20);
  labelldaempfungk1->setGeometry(300,81,110,20);
  ldaempfungk1->setGeometry(410,81,100,20);
  boxwattoffset2->setGeometry(10,181,180,20);
  labelldaempfungk2->setGeometry(300,181,100,20);
  ldaempfungk2->setGeometry(410,181,100,20);
  
  mlabelk1->setGeometry(610,60,40,20);
  mlabelk2->setGeometry(610,160,40,20);
  messlabel1->setGeometry(10,10,185,50);
  messlabel2->setGeometry(10,110,185,50);
  messlabel3->setGeometry(200,10,185,50);
  messlabel4->setGeometry(200,110,185,50);
  messlabel5->setGeometry(390,10,185,50);
  messlabel6->setGeometry(390,110,185,50);
  messedit->setGeometry(10,220,600,210);
  buttonmesssave->setGeometry(200,430,100,35);
  buttonmess->setGeometry(10,430,180,35);
}

///////////////////////////////////////////////////////////////////////////////
// Widget VFO
void Nwt7linux::vfoedit(){
  double l;
  QString s;
  char s1[12];
  
  s = editvfo->text();
  l = linenormalisieren(s);
//Frequenzen zwischen 10 Hz und 200 MHz
  if(l > 10.0 && l < 600000000.0){
    //Drehgeber auslesen
    sprintf(s1,"%2.6f", l / 1000000);
    //auf Display darstellen
    switch(lcdauswahl)
    {
      case 1:LCD1->display(s1);break;
      case 2:LCD2->display(s1);break;
      case 3:LCD3->display(s1);break;
      case 4:LCD4->display(s1);break;
      case 5:LCD5->display(s1);break;
    }
    dialsetzen();
  }
}

void Nwt7linux::LCDaendern(){
  int valdial1mhz, valdial1khz, valdial1hz;
  double l;
  char s[12];

  //Drehgeber auslesen
  valdial1mhz = Dial1mhz->value();
  valdial1khz = Dial1khz->value();
  valdial1hz = Dial1hz->value();
  //Werte zusammenfuegen
  l = (1000000 * valdial1mhz) + (1000 * valdial1khz) + valdial1hz;
  // komma einfuegen nach Mhz
  sprintf(s,"%2.6f", l / 1000000);
  //auf Display darstellen
  switch(lcdauswahl)
  {
    case 1:LCD1->display(s);break;
    case 2:LCD2->display(s);break;
    case 3:LCD3->display(s);break;
    case 4:LCD4->display(s);break;
    case 5:LCD5->display(s);break;
  }
  sprintf(s,"%-9.0f", l);
  editvfo->setText(s);
}

void Nwt7linux::setVfo(){
  //timer starten mit 10 mSek Laufzeit
  vfotimer->start(10, true);
}

void Nwt7linux::senddaten(){
  if(!bersterstart){
    QString qs;
    char s[20];
    double fr = 1000000.0;
    double zf = 0.0;
    //nach ablauf des vfoTimers wird Frequenz zum NWT7 gesendet
    if(!bttyOpen){
      bttyOpen = picmodem->opentty(weichen.str_tty);
      if(!bttyOpen){
        QMessageBox::warning( this, tr("Serielle Schnittstelle"), 
                                      "\"" + weichen.str_tty + tr("\" Laesst sich nicht oeffnen!"));
  #ifdef LDEBUG
        qDebug("Nwt7linux::senddaten()");
  #endif    
        return;
      }
    }
    if (bttyOpen)
    {
      switch(lcdauswahl)
      {
        case 1:fr = LCD1->value();break;
        case 2:fr = LCD2->value();break;
        case 3:fr = LCD3->value();break;
        case 4:fr = LCD4->value();break;
        case 5:fr = LCD5->value();break;
      }
      //Kommadarstellung wieder wegrechnen
  
      qs = editzf->text();
      zf = linenormalisieren(qs);
      qs.sprintf("%1.0f", zf);
      editzf->setText(qs);
      fr = (fr * 1000000.0) + zf;
      if(checkboxiqvfo->isChecked())fr = fr * 4.0;
      sprintf(s, "f%09.0f", fr);
      defaultlesenrtty(); //eventuelle Daten im UART loeschen
      picmodem->writeChar(143);
      picmodem->writeLine(s);
    }
  }
  //timer stoppen da Aufgabe erledigt
  vfotimer->stop();
}

void Nwt7linux::lcd1clicked(){
  QPalette dp;
  dp.setColor(QPalette::Background, Qt::yellow);
  QPalette dpd;
  dpd.setColor(QPalette::Background, Qt::darkYellow);

  rb1->setChecked(true);
  rb2->setChecked(false);
  rb3->setChecked(false);
  rb4->setChecked(false);
  rb5->setChecked(false);
  
  LCD1->setPalette(dp);
  LCD2->setPalette(dpd);
  LCD3->setPalette(dpd);
  LCD4->setPalette(dpd);
  LCD5->setPalette(dpd);

  Dial1hz->setFocus();
  lcdauswahl = 1;
  dialsetzen();
}

void Nwt7linux::lcd2clicked(){
  QPalette dp;
  dp.setColor(QPalette::Background, Qt::yellow);
  QPalette dpd;
  dpd.setColor(QPalette::Background, Qt::darkYellow);

  rb1->setChecked(false);
  rb2->setChecked(true);
  rb3->setChecked(false);
  rb4->setChecked(false);
  rb5->setChecked(false);
  
  LCD1->setPalette(dpd);
  LCD2->setPalette(dp);
  LCD3->setPalette(dpd);
  LCD4->setPalette(dpd);
  LCD5->setPalette(dpd);

  Dial1hz->setFocus();
  lcdauswahl = 2;
  dialsetzen();
}

void Nwt7linux::lcd3clicked(){
  QPalette dp;
  dp.setColor(QPalette::Background, Qt::yellow);
  QPalette dpd;
  dpd.setColor(QPalette::Background, Qt::darkYellow);

  rb1->setChecked(false);
  rb2->setChecked(false);
  rb3->setChecked(true);
  rb4->setChecked(false);
  rb5->setChecked(false);
  
  LCD1->setPalette(dpd);
  LCD2->setPalette(dpd);
  LCD3->setPalette(dp);
  LCD4->setPalette(dpd);
  LCD5->setPalette(dpd);

  Dial1hz->setFocus();
  lcdauswahl = 3;
  dialsetzen();
}

void Nwt7linux::lcd4clicked(){
  QPalette dp;
  dp.setColor(QPalette::Background, Qt::yellow);
  QPalette dpd;
  dpd.setColor(QPalette::Background, Qt::darkYellow);

  rb1->setChecked(false);
  rb2->setChecked(false);
  rb3->setChecked(false);
  rb4->setChecked(true);
  rb5->setChecked(false);
  
  LCD1->setPalette(dpd);
  LCD2->setPalette(dpd);
  LCD3->setPalette(dpd);
  LCD4->setPalette(dp);
  LCD5->setPalette(dpd);

  Dial1hz->setFocus();
  lcdauswahl = 4;
  dialsetzen();
}

void Nwt7linux::lcd5clicked(){
  QPalette dp;
  dp.setColor(QPalette::Background, Qt::yellow);
  QPalette dpd;
  dpd.setColor(QPalette::Background, Qt::darkYellow);

  rb1->setChecked(false);
  rb2->setChecked(false);
  rb3->setChecked(false);
  rb4->setChecked(false);
  rb5->setChecked(true);
  
  LCD1->setPalette(dpd);
  LCD2->setPalette(dpd);
  LCD3->setPalette(dpd);
  LCD4->setPalette(dpd);
  LCD5->setPalette(dp);

  Dial1hz->setFocus();
  lcdauswahl = 5;
  dialsetzen();
}

void Nwt7linux::dialsetzen(){
  double fr = 1000000.0, fr1;

  switch(lcdauswahl)
  {
    case 1:fr = LCD1->value();break;
    case 2:fr = LCD2->value();break;
    case 3:fr = LCD3->value();break;
    case 4:fr = LCD4->value();break;
    case 5:fr = LCD5->value();break;
  }
  //Kommadarstellung wieder wegrechnen
  fr = fr * 1000000.0; //Darstellung in Herz
  fr1 = floor(fr / 1000000.0);
  Dial1mhz->setValue(int(fr1));
  fr = fr - fr1 * 1000000.0;
  fr1 = floor(fr / 1000.0);
  Dial1khz->setValue(int(fr1));
  fr = fr - fr1 * 1000.0;
  Dial1hz->setValue(int(fr));
}

void Nwt7linux::drehgeber1focus(){
  Dial1mhz->setFocus();
  repaint();
}

void Nwt7linux::drehgeber2focus(){
  Dial1khz->setFocus();
  repaint();
}

void Nwt7linux::drehgeber3focus(){
  Dial1hz->setFocus();
  repaint();
}

void Nwt7linux::setDialfocus(){
  QPalette dp;
  dp.setColor(QPalette::Background, Qt::yellow);
  QPalette dpd;
  dpd.setColor(QPalette::Background, Qt::darkYellow);

  Dial1mhz->setPalette(dpd);
  Dial1khz->setPalette(dpd);
  Dial1hz->setPalette(dpd);
  if(Dial1mhz->hasFocus()){
    Dial1mhz->setPalette(dp);
  }
  if(Dial1khz->hasFocus()){
    Dial1khz->setPalette(dp);
  }
  if(Dial1hz->hasFocus()){
    Dial1hz->setPalette(dp);
  }
}

void Nwt7linux::setFrequenzmarken(){
  int r;

  fmdlg *dlg = new fmdlg(this);
  //Frequenzmarken in den Dialog
  dlg->setdaten(frqmarken);
  r = dlg->exec();
  if(r == QDialog::Accepted){
//    qDebug("ok");
    //Frequenzmarken aus den Dialog holen
    frqmarken = dlg->getdaten();
    //Frequenzmarken ins Wobbelfenster 
    emit sendefrqmarken(frqmarken);
  }
  delete dlg;
}

void Nwt7linux::option(){
  int r;
  double addstakt;
  int apll;
  QString stty;
  double dkonst;
  long double ddskonst;
  qulonglong test;
  QString qs;
  QString qpll;
  
  addstakt = weichen.ddstakt;
  apll = weichen.pll;
  odlg *dlg = new odlg(this);
  weichen.eichk1 = wobdaten.beichkorrk1;
  weichen.eichk2 = wobdaten.beichkorrk2;
  weichen.einkanalig = wobdaten.einkanalig;
  weichen.strsonde1 = wobdaten.namesonde1;
  weichen.strsonde2 = wobdaten.namesonde2;
  weichen.bswriteration = wobdaten.bswriteration;
  weichen.penkanal1 = wobdaten.penkanal1;
  weichen.penkanal2 = wobdaten.penkanal2;
  stty = weichen.str_tty;
  dlg->setdaten(weichen);
  dlg->tip(btip);
  r = dlg->exec();
  if(r == QDialog::Accepted){
    weichen = dlg->getdaten();
    setDaempfungItem(); //Daempfungsglied einstellen
    if(weichen.eichende > long(weichen.maxwobbel)){
        QMessageBox::warning( this, tr("Frequenzgrenzen"), 
                                    tr("<center><b>Die Endfrequenz der Eichkorrektur ist"
                                       " groesser als die max. Wobbelfrequenz!</b></center><br>"
                                       "<center>Die Endfrequenz der Eichkorrektur wird angepasst.</center>"));
      weichen.eichende = long(weichen.maxwobbel);
    }
    wobdaten.beichkorrk1 = weichen.eichk1;
    wobdaten.beichkorrk2 = weichen.eichk2;
    wobdaten.einkanalig = weichen.einkanalig;
    wobdaten.namesonde1 = weichen.strsonde1;
    wobdaten.namesonde2 = weichen.strsonde2;
    wobdaten.bswriteration = weichen.bswriteration;
    wobdaten.penkanal1 = weichen.penkanal1;
    wobdaten.penkanal2 = weichen.penkanal2;
    Dial1mhz->setMaximum(int(weichen.maxvfo / 1000000.0)-1);
    if(wobdaten.einkanalig){
      if(wobdaten.beichkorrk1){
        setColorRedk1();
        weichen.eichstep = maxmesspunkte;
      }else{
        setColorBlackk1();
      }  
      checkboxk2->setChecked(false);
      checkboxk2->setEnabled(false);
      progressbarmessk2->setEnabled(false);
      ldaempfungk2->setEnabled(false);
//      checkboxM10dbK2->setEnabled(false);
//      checkboxM20dbK2->setEnabled(false);
      emit setmenu(emEichenK2, false);
      emit setmenu(emSondeLadenK2, false);
      emit setmenu(emSondeSpeichernK2, false);
      emit setmenu(emWattEichenK2, false);
    }else{
      if(wobdaten.beichkorrk1){
        setColorRedk1();
        weichen.eichstep = maxmesspunkte;
      }else{
        setColorBlackk1();
      }
      if(wobdaten.beichkorrk2){
        setColorRedk2();
        weichen.eichstep = maxmesspunkte;
      }else{
        setColorBlackk2();
      }
      checkboxk2->setEnabled(true);
      progressbarmessk2->setEnabled(true);
      ldaempfungk2->setEnabled(true);
//      checkboxM10dbK2->setEnabled(true);
//      checkboxM20dbK2->setEnabled(true);
      emit setmenu(emEichenK2, true);
      emit setmenu(emSondeLadenK2, true);
      emit setmenu(emSondeSpeichernK2, true);
      emit setmenu(emWattEichenK2, true);
    }
    fsendewobbeldaten();
  }
  if((addstakt != weichen.ddstakt) or (apll != weichen.pll)){
    switch(weichen.pll){
      case 1: qpll="00"; break; 
      case 2: qpll="17"; break; 
      case 3: qpll="1F"; break; 
      case 4: qpll="27"; break; 
      case 5: qpll="2F"; break; 
      case 6: qpll="37"; break; 
      case 7: qpll="3F"; break; 
      case 8: qpll="47"; break; 
      case 9: qpll="4F"; break; 
      case 10: qpll="57"; break; 
      case 11: qpll="5F"; break; 
      case 12: qpll="67"; break; 
      case 13: qpll="6F"; break; 
      case 14: qpll="77"; break; 
      case 15: qpll="7F"; break; 
      case 16: qpll="87"; break; 
      case 17: qpll="8F"; break; 
      case 18: qpll="97"; break; 
      case 19: qpll="9F"; break; 
      case 20: qpll="A7"; break; 
    }
    dkonst = 4294967296.0;  // 2 hoch 32
    ddskonst = dkonst * dkonst / weichen.ddstakt;
    test = qulonglong(ddskonst);
    qs = QString("%1").arg(test,0,16);
    if(qs.length() < 10)qs="0"+qs;
#ifdef LDEBUG
    qDebug("%f", weichen.ddstakt);
    qDebug("%llf", ddskonst);
    qDebug("%lli", test);
    qDebug(qs);
#endif    
    qs = qs.upper();
    qs = "e" + qs + qpll;
#ifdef LDEBUG
    qDebug(qs);
    return;
#endif    
    if(!bttyOpen){
      bttyOpen = picmodem->opentty(weichen.str_tty);
      if(!bttyOpen){
        QMessageBox::warning( this, tr("Serielle Schnittstelle"), 
	                               "\"" + weichen.str_tty + tr("\" Laesst sich nicht oeffnen!"));
        return;
      }
    }
    if (bttyOpen)
    {
      defaultlesenrtty(); //eventuelle Daten im UART loeschen
      picmodem->writeChar(143);
      picmodem->writeLine(qs);
    }
  }
  if(stty != weichen.str_tty){
    picmodem->closetty();
    bttyOpen = picmodem->opentty(weichen.str_tty);
    if(!bttyOpen){
      QMessageBox::warning( this, tr("Serielle Schnittstelle"), 
                                     "\"" + weichen.str_tty + tr("\" Laesst sich nicht oeffnen!"));
    }
  }
  delete dlg;
}

void Nwt7linux::setAText(QString stty){
  QString astty = configfilename + " - " + stty;
  emit setAppText(astty);
}

void Nwt7linux::version(){
  int a=0, i=0;
  QString qs;

  if (bttyOpen)
  {
    defaultlesenrtty(); //eventuelle Daten im UART loeschen
    picmodem->writeChar(143);
    picmodem->writeLine("v");
    while((picmodem->readttybuffer(&a, 1)) != 1){
      i++;
      if(i==20000){
        a=0;
      break;
      }
    };
#ifdef LDEBUG
    qDebug("%i",a);
#endif    
    qs.sprintf(tr("<B>Abfrage der Firware im PIC</B><BR>"
                  "Das Ergebnis muss groesser 100 sein"
                  "<CENTER>Version: %03i</CENTER>"), a);
    QMessageBox::about(this, "Firmware", qs);
  }
}

void Nwt7linux::firmupdate(){
  char c;
  QFile f;
  int i;
  QString qs, qs1, zeile;
  QString beschr(tr("<b>Ablauf des Firmwareupdate</b><br>"
                    "1. Netzwerktester ausschalten<br>"
                    "2. Bruecke zwischen GND und RB0 stecken<br>"
                    "   Der Netzwerktester bleibt <B><EM>ausgeschaltet</EM></B><BR>"
                    "3. Laden der HEX-Datei fuer den PIC<BR><BR>"
                    "   <B>Weiter Infos folgen!!!</B>"));
  QString beschr1(tr("<b>Weiterer Ablauf des Firmwareupdate</b><br>"
                     "1. Nach druecken des <EM><B>OK</B></EM>-Button den Netzwerktester einschalten<br>"
                     "2. Nach dem Erkennen der Anfangskennung beginnt das Update<br>"
                     "Funktioniert das nicht, den Netzwerktester ausschalten und wieder von vorn beginnen<BR>"
                     "<B>Durch das stecken der Bruecke + PowerON ist es unbedingt notwendig eine neue Firmware"
                     " in den PIC zu laden!!!</B>"));
  firmwidget firmw(this);
 
  QMessageBox::about(this, tr(" Firmware Update "), beschr);
  QString s = QFileDialog::getOpenFileName(
                    homedir.filePath("*.hex"),
                    "Firmware Hexdatei (*.hex)",
                    this, 0, "Firmware Updaten");
  if (!s.isNull())
  {
    firmw.show();
    QMessageBox::about(this, tr(" Firmware Update "), beschr1); 
    firmw.setText("HEX-Datei "+s);
#ifdef LDEBUG
    qDebug(s);
#endif    
    f.setName(s);
    if(f.open( IO_ReadOnly )){
      QTextStream ts(&f);
      qs = "";
      while(qs.find("HFM9") == -1){
        if(picmodem->readttybuffer(&c, 1) == 1){
          qs = qs + c;
          firmw.setText("Kennung: HFM9"); 
#ifdef LDEBUG
          qDebug(qs);
#endif	  
        }
      }
      qs = "";
      i = 0;
      while(qs.find("OK") == -1){
        ts >> zeile;
#ifdef LDEBUG
        qDebug(zeile);
#endif	
        picmodem->writeLine(zeile);
        c = ' ';
        while(picmodem->readttybuffer(&c, 1) != 1);
        i++;
        qs1.sprintf(tr("gelesene Zeilen: %i"), i);
        firmw.setText(qs1);
        if(c == 'O'){
          qs = qs + c;
          while(picmodem->readttybuffer(&c, 1) != 1);
        }
        qs = qs + c;
#ifdef LDEBUG
        qDebug(qs);
#endif	
      }
    }
    QMessageBox::about(this, tr("Firmware Update"), 
                             tr("<CENTER><B>Update erfolgreich!</B></CENTER><BR>"
                                "Die Bruecke wieder entfernen!"));
  }
}

void Nwt7linux::setDaempfung(int index)
{
  int portb=0;
  int db;
  bool r1 = FALSE, // -2dB
       r2 = FALSE, // -4dB
       r3 = FALSE, // -8db
       r4 = FALSE, // -4dB
       r5 = FALSE, // -16dB
       r6 = FALSE; // -32db
  QString qs;
  
  if(weichen.bfaeich){
    if(index > 0){
      db = (index+1) * 2;
      qDebug("db: %i", db);
      if(db >= 32){
        r6 = true;
        db = db - 32;
        if((db !=0) and (db < 4)){
          r6 = false;
          db = db + 32;
        } 
        qDebug("db: %i", db);
      } 
      if(db >= 16){
        r5 = true;
        db = db - 16;
        if((db !=0) and (db < 4)){
          r5 = false;
          db = db + 16;
        } 
        qDebug("db: %i", db);
      } 
      if(db != 0){
        db = db - 4;
        r4 = true;
        if(db >= 8){
          r3 = true;
          db = db - 8;
          qDebug("db: %i", db);
        } 
        if(db >= 4){
          r2 = true;
          db = db - 4;
          qDebug("db: %i", db);
        } 
        if(db >= 2){
          r1 = true;
          db = db - 2;
          qDebug("db: %i", db);
        } 
      }
    }
  portb = 0;
  if(r1){
    qDebug("r1 ein -2");
    portb = portb + 1;
  }
  if(r2){
    qDebug("r2 ein -4");
    portb = portb + 2;
  }
  if(r3){
    qDebug("r3 ein -8");
    portb = portb + 4;
  }
  if(r4){
    qDebug("r4 ein -4");
    portb = portb + 8;
  }
  if(r5){
    qDebug("r5 ein -16");
    portb = portb + 16;
  }
  if(r6){
    qDebug("r6 ein -32");
    portb = portb + 32;
  }

  }else{
    switch(index){
      case 0:
          portb = 0;
          break;
      case 1:
          portb = 1;
          break;
      case 2:
          portb = 2;
          break;
      case 3:
          portb = 3;
          break;
      case 4:
          portb = 6;
          break;
      case 5:
          portb = 7;
          break;
    }
  }
  qDebug("index: %i", index);
  qDebug("portb: %x hex", portb);
  if( bttyOpen){
    picmodem->writeChar(0x8F);
    picmodem->writeChar('r');
    picmodem->writeChar(portb);
    qs.sprintf("r%i",portb); 
#ifdef LDEBUG
    qDebug(qs);
#endif    
  }
}

void Nwt7linux::setwattoffset1(int index)
{
  qDebug("%i",index);
  switch(index){
    case 0:
        woffset1 = 0.0;
        break;
    case 1:
        woffset1 = 0.8;
        break;
    case 2:
        woffset1 = 1.0;
        break;
    case 3:
        woffset1 = 2.0;
        break;
    case 4:
        woffset1 = 2.5;
        break;
    case 5:
        woffset1 = 3.0;
        break;
    case 6:
        woffset1 = 4.0;
        break;
    case 7:
        woffset1 = 6.0;
        break;
    case 8:
        woffset1 = 9.0;
        break;
  }
}

void Nwt7linux::setwattoffset2(int index)
{
  switch(index){
    case 0:
        woffset2 = 0.0;
        break;
    case 1:
        woffset2 = 0.8;
        break;
    case 2:
        woffset2 = 1.0;
        break;
    case 3:
        woffset2 = 2.0;
        break;
    case 4:
        woffset2 = 2.5;
        break;
    case 5:
        woffset2 = 3.0;
        break;
    case 6:
        woffset2 = 4.0;
        break;
    case 7:
        woffset2 = 6.0;
        break;
    case 8:
        woffset2 = 9.0;
        break;
  }
}

void Nwt7linux::setAufloesung(int index)
{
  int aufloesung=4;
  
  switch(index){
    case 0:
        aufloesung = 4;
        break;
    case 1:
        aufloesung = 1;
        break;
    case 2:
        aufloesung = 2;
        break;
    case 3:
        aufloesung = 3;
        break;
    case 4:
        aufloesung = 4;
        break;
    case 5:
        aufloesung = 5;
        break;
    case 6:
        aufloesung = 6;
        break;
    case 7:
        aufloesung = 7;
        break;
    case 8:
        aufloesung = 8;
        break;
    case 9:
        aufloesung = 9;
        break;
  }
  wobdaten.aufloesung = aufloesung;
  fsendewobbeldaten();
}

void Nwt7linux::tip(bool atip)
{
  QString grafik_tip(tip_grafik);
  QString edit_tip(tip_edit);
  QString k2_tip(tip_k2);
  QString relais_tip(tip_relais);
  QString zf_tip(tip_zf);
  QString dial_tip(tip_dial);
  QString checkmess_tip(tip_checkmess);
  QString mledit_tip(tip_mledit);
  QString betriebsart_tip(tip_betriebsart);
  QString _3db_tip(tip_3db);
  QString _6db_tip(tip_6db);
  QString dbgrafik_tip(tip_dbgrafik);
  QString schritte_tip(tip_schritte);
  QString pbar_tip(tip_pbar);
  QString messtext_tip(tip_messtext);
  QString swra_100_tip(tip_swra_100);
  QString swrlaenge_tip(tip_swrlaenge);
  QString lupeplus_tip(tip_lupeplus);
  QString lupeminus_tip(tip_lupeminus);
  QString offset_tip(tip_offset);
  QString kursor_tip(tip_kursor);
  QString messoffset_tip(tip_messoffset);
  QString zfwobbel_tip(tip_zfwobbel);
  QString vfo_x4_tip(tip_vfo_x4);
  QString messabs_tip(tip_messabs);

  btip = atip;
  wkmanager->tip(btip);
  if(btip){
    grafik->setToolTip(grafik_tip);
    editanfang->setToolTip(edit_tip);
    editende->setToolTip(edit_tip);
    checkboxk2->setToolTip(k2_tip);
    daempfung1->setToolTip(relais_tip);
    daempfung2->setToolTip(relais_tip);
    editzf->setToolTip(zf_tip);
    editvfo->setToolTip(edit_tip);
    Dial1mhz->setToolTip(dial_tip);
    Dial1khz->setToolTip(dial_tip);
    Dial1hz->setToolTip(dial_tip);
    ldaempfungk1->setToolTip(checkmess_tip);
    ldaempfungk2->setToolTip(checkmess_tip);
    progressbarmessk2->setToolTip(k2_tip);
    mledit->setToolTip(mledit_tip);
    betriebsart->setToolTip(betriebsart_tip);
    checkbox3db->setToolTip(_3db_tip);
    checkbox6db->setToolTip(_6db_tip);
    checkboxgrafik->setToolTip(dbgrafik_tip);
    editschritte->setToolTip(schritte_tip);
    progressbar->setToolTip(pbar_tip);
    messedit->setToolTip(messtext_tip);
    edita_100->setToolTip(swra_100_tip);
    labela_100->setToolTip(swra_100_tip);
    editkabellaenge->setToolTip(swrlaenge_tip);
    labelkabellaenge->setToolTip(swrlaenge_tip);
    buttonlupeplus->setToolTip(lupeplus_tip);
    buttonlupeminus->setToolTip(lupeminus_tip);
    boxdbshift1->setToolTip(offset_tip);
    boxdbshift2->setToolTip(offset_tip);
    boxkursornr->setToolTip(kursor_tip);
    boxwattoffset1->setToolTip(messoffset_tip);
    boxwattoffset2->setToolTip(messoffset_tip);
    checkboxzf->setToolTip(zfwobbel_tip);
    checkboxiqvfo->setToolTip(vfo_x4_tip);
    mlabelk1->setToolTip(messabs_tip);
    mlabelk2->setToolTip(messabs_tip);
  }else{
    grafik->setToolTip("");
    editanfang->setToolTip("");
    editende->setToolTip("");
    checkboxk2->setToolTip("");
    daempfung1->setToolTip("");
    daempfung2->setToolTip("");
    editzf->setToolTip("");
    editvfo->setToolTip("");
    Dial1mhz->setToolTip("");
    Dial1khz->setToolTip("");
    Dial1hz->setToolTip("");
    ldaempfungk1->setToolTip("");
    ldaempfungk2->setToolTip("");
    progressbarmessk2->setToolTip("");
    mledit->setToolTip("");
    betriebsart->setToolTip("");
    checkbox3db->setToolTip("");
    checkbox6db->setToolTip("");
    checkboxgrafik->setToolTip("");
    editschritte->setToolTip("");
    progressbar->setToolTip("");
    messedit->setToolTip("");
    edita_100->setToolTip("");
    labela_100->setToolTip("");
    editkabellaenge->setToolTip("");
    labelkabellaenge->setToolTip("");
    buttonlupeplus->setToolTip("");
    buttonlupeminus->setToolTip("");
    boxdbshift1->setToolTip("");
    boxdbshift2->setToolTip("");
    boxkursornr->setToolTip("");
    boxwattoffset1->setToolTip("");
    boxwattoffset2->setToolTip("");
    checkboxzf->setToolTip("");
    checkboxiqvfo->setToolTip("");
    mlabelk1->setToolTip("");
    mlabelk2->setToolTip("");
  }
}


void Nwt7linux::setColorRedk1(){
  QPalette pred;
  pred.setColor(QPalette::WindowText, Qt::red);
  checkboxk1->setPalette(pred);
}

void Nwt7linux::setColorBlackk1(){
  QPalette pbl;
  pbl.setColor(QPalette::WindowText, Qt::black);
  checkboxk1->setPalette(pbl);
}

void Nwt7linux::setColorRedk2(){
  QPalette pred;
  pred.setColor(QPalette::WindowText, Qt::red);
  checkboxk2->setPalette(pred);
}

void Nwt7linux::setColorBlackk2(){
  QPalette pbl;
  pbl.setColor(QPalette::WindowText, Qt::black);
  checkboxk2->setPalette(pbl);
}

void Nwt7linux::setDaempfungdefault(){
  configfile nwt7configfile;
  QString qs;
  
  nwt7configfile.open(homedir.filePath(configfilename));
  while(nwt7configfile.clearItem("powerk"));
  nwt7configfile.close();
  while(ldaempfungk1->count() > 5)ldaempfungk1->removeItem(5);
  while(ldaempfungk2->count() > 5)ldaempfungk2->removeItem(5);
}

void Nwt7linux::fzaehlen(){
  QString qs;
  unsigned long zeit, ergebnis;
  char abuffer[4];
  int a=0, i, j;

//  zeit = 624998;
  zeit = 62499;

  if(!bttyOpen){
    bttyOpen = picmodem->opentty(weichen.str_tty);
    if(!bttyOpen){
      QMessageBox::warning( this, tr("Serielle Schnittstelle"), 
                                     "\"" + weichen.str_tty + tr("\" Laesst sich nicht oeffnen!"));
      qDebug("Nwt7linux::fzaehlen()");
      return;
    }
  }
  if (bttyOpen)
  {
    qs = QString("%1").arg(zeit,0,16);
    while(qs.length() < 8)qs = '0' + qs;
//    return;
    qs = "z" + qs;
    qDebug(qs);
    defaultlesenrtty(); //eventuelle Daten im UART loeschen
    picmodem->writeChar(143);
    picmodem->writeLine(qs);
    ttyindex = 0;
    do{
      a = picmodem->readttybuffer(abuffer, 4);
      if(a>0)qDebug("%i",a);
      for(i=0, j=ttyindex; i<a; i++, j++){
        ttybuffer[j] = abuffer[i]; // Die gelesenen Daten in den richtigen Buffer kopieren
      }
      ttyindex = ttyindex + a; // und den Index auf die richtige Stelle setzen
    }while(ttyindex != 4);
    ergebnis = ttybuffer[0] + ttybuffer[1]*256 + ttybuffer[2]*256*256 + ttybuffer[3]*256*256*256;
    qDebug("ergebnis= %li", ergebnis);
  }
}

void Nwt7linux::keyPressEvent(QKeyEvent *event){
  long i;
  i = (Dial1mhz->value()* 1000000) + (Dial1khz->value()*1000) + Dial1hz->value();
  switch(event->key()){
  case Qt::Key_Q: i+=10000000; break;
  case Qt::Key_A: i-=10000000; break;
  case Qt::Key_W: i+=1000000; break;
  case Qt::Key_S: i-=1000000; break;
  case Qt::Key_E: i+=10000; break;
  case Qt::Key_D: i-=10000; break;
  case Qt::Key_R: i+=1000; break;
  case Qt::Key_F: i-=1000; break;
  case Qt::Key_T: i+=10; break;
  case Qt::Key_G: i-=10; break;
  case Qt::Key_Z: i++; break;
  case Qt::Key_H: i--; break;
    default:
      QWidget::keyPressEvent(event);
  }
  if(i<0)i=0;
  if(i>weichen.maxvfo)i=(long)weichen.maxvfo - 1;
  Dial1mhz->setValue(i/1000000);
  i = i - (i /1000000) * 1000000;
  Dial1khz->setValue(i/1000);
  i = i - (i /1000) * 1000;
  Dial1hz->setValue(i);
}

void Nwt7linux::openKurvenManager(){
#ifdef LDEBUG
  qDebug("Nwt7linux::openKurvenManager()");
#endif    
  wkmanager->show();
}

void Nwt7linux::getwkmk1(){
  wkmanager->suebergabe1(wobdaten);
}

void Nwt7linux::getwkmk2(){
  wkmanager->suebergabe2(wobdaten);
}

void Nwt7linux::getwkmk3(){
  wkmanager->suebergabe3(wobdaten);
}

void Nwt7linux::getwkmk4(){
  wkmanager->suebergabe4(wobdaten);
}

void Nwt7linux::fsendewobbeldaten(){
  //festlegen der Wobbelgrenzen, Bezug fuer die Hintergrundkurven
  wobdaten.absanfang = (double)wobdaten.anfangsfrequenz;
  wobdaten.absende = (double)wobdaten.anfangsfrequenz
                   + (double)wobdaten.schrittfrequenz 
                   * ((double)wobdaten.schritte -1);
  emit sendewobbeldaten(wobdaten);
}
