/****************************************************************************
**
** Copyright (C) 2004-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the example classes of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include <QtGui>
#include <QObject>
#include <QLocale>

#include "mainwindow.h"

//#define	LDEBUG

MainWindow::MainWindow()
{
  QLocale::setDefault(QLocale::German);
///////////////////////////////////////////////////////////////////////////////
// Info Version usw. 
  infoversion = "2.01";
  infodatum = "04.11.2007";
  infotext = tr("<h2>HFM9/NWT fuer Linux und Windows</h2>"
                "<p><B>Version ")+infoversion+"</B>     "+infodatum+" "
                "<p>Entwickelt unter Linux mit QT4 von Trolltech"
                "<p>(c) Andreas Lindenau DL4JAL<br>"
                "DL4JAL@darc.de<br>"
                "http://www.dl4jal.eu";
  nwt7linux = new Nwt7linux(this);
  setCentralWidget(nwt7linux);
  connect(nwt7linux, SIGNAL(setAppText(QString)), this, SLOT(setText(QString)));

  createActions();
  createMenus();
  createToolBars();
  createStatusBar();
  connect( nwt7linux, SIGNAL(setmenu(tmenuenable,bool)), this,SLOT(msetmenu(tmenuenable,bool)));
  setWindowIcon(QIcon(":/images/appicon.png"));
  
  setMaximumSize (2000, 2000);
  setMinimumSize (750, 600);
  menuKurven->setEnabled ( true );
  menuwobbel->setEnabled ( true );
  mStop->setEnabled ( false );
  menuvfo->setEnabled ( false );
  menumessen->setEnabled ( false );
  mDrucken->setEnabled ( true );
  nwt7linux->menuanfangsetzen();
  readSettings();
  createToolTip(mTooltip->isChecked());
  nwt7linux->grafiksetzen();
}

void MainWindow::closeEvent(QCloseEvent *event)
{
  writeSettings();
  nwt7linux->beenden();
  event->accept();
}

void MainWindow::createActions()
{
  mDrucken = new QAction(QIcon(":/images/drucken.png"), tr("&Drucken"), this);
  mDrucken->setStatusTip(tr("Ausdrucken des Wobbelfensters"));
  connect(mDrucken, SIGNAL(triggered()), this, SLOT(druckediagramm()));

  mDruckenpdf = new QAction(QIcon(":/images/druckenpdf.png"), tr("Drucken als PDF"), this);
  mDruckenpdf->setStatusTip(tr("Ausdrucken des Wobbelfensters in PDF-Datei"));
  connect(mDruckenpdf, SIGNAL(triggered()), this, SLOT(druckediagrammpdf()));

  mLayoutlabel = new QAction(QIcon(":/images/label.png"), tr("Layoutlabel eingeben"), this);
  mLayoutlabel->setStatusTip(tr("Ueberschrift fuer den Ausdruck des Wobbelfensters"));
  connect(mLayoutlabel, SIGNAL(triggered()), this, SLOT(drucklabel()));

  mBeenden = new QAction(QIcon(":/images/beenden.png"), tr("&Beenden"), this);
  mBeenden->setShortcut(tr("Ctrl+Q"));
  mBeenden->setStatusTip(tr("Beenden des Programmes und Speichern der Konfiguration"));
  connect(mBeenden, SIGNAL(triggered()), this, SLOT(beenden()));

  mEinstellungLaden = new QAction(tr("&Laden"), this);
  mEinstellungLaden->setStatusTip(tr("Laden einer neuen Programmkonfiguration"));
  connect(mEinstellungLaden, SIGNAL(triggered()), this, SLOT(EinstellungLaden()));

  mEinstellungSichern = new QAction(tr("&Sichern"), this);
  mEinstellungSichern->setStatusTip(tr("Sichern der Programmkonfiguration in eine Datei"));
  connect(mEinstellungSichern, SIGNAL(triggered()), this, SLOT(EinstellungSichern()));

  mKurvenLaden = new QAction(QIcon(":/images/open.png"), tr("Wobbelkurve &laden"), this);
  mKurvenLaden->setStatusTip(tr("Laden einer abgespeicherten Wobbeldatei"));
  connect(mKurvenLaden, SIGNAL(triggered()), this, SLOT(KurvenLaden()));

  mKurvenSichern = new QAction(QIcon(":/images/save.png"),tr("Wobbelkurve &sichern"), this);
  mKurvenSichern->setStatusTip(tr("Abspeichern des Wobbelergebnisses in eine Datei"));
  connect(mKurvenSichern, SIGNAL(triggered()), this, SLOT(KurvenSichern()));
  
  mKurvenManager = new QAction(QIcon(":/images/appicon.png"),tr("&Wobbelkurvenmanager"), this);
  mKurvenManager->setStatusTip(tr("Ueberlagern von mehreren Wobbelkurven"));
  connect(mKurvenManager, SIGNAL(triggered()), this, SLOT(openKurvenManager()));

  mInfo = new QAction(QIcon(":/images/info.png"), tr("&Info"), this);
  mInfo->setStatusTip(tr("Informationen zur Programmversion"));
  connect(mInfo, SIGNAL(triggered()), this, SLOT(Info()));

  mVersion = new QAction(tr("&Firmware Version"), this);
  mVersion->setStatusTip(tr("Informationen zur Firwareversion"));
  connect(mVersion, SIGNAL(triggered()), this, SLOT(version()));

  mFirmware = new QAction(tr("&Firmware Update"), this);
  mFirmware->setStatusTip(tr("Neue Firmware in die Baugruppe laden"));
  connect(mFirmware, SIGNAL(triggered()), this, SLOT(firmupdate()));

  mOption = new QAction(QIcon(":/images/option.png"), tr("&Option"), this);
  mOption->setStatusTip(tr("Einstellung verschieden Programmoptionen"));
  connect(mOption, SIGNAL(triggered()), this, SLOT(option()));

  mWobbeln = new QAction(tr("Wobbeln"), this);
  mWobbeln->setStatusTip(tr("Durchgehen Wobbeln"));
  connect(mWobbeln, SIGNAL(triggered()), this, SLOT(clickwobbeln()));

  mEinmal = new QAction(tr("Einmal"), this);
  mEinmal->setStatusTip(tr("Nur einen Wobbeldurchlauf"));
  connect(mEinmal, SIGNAL(triggered()), this, SLOT(clickwobbelneinmal()));

  mStop = new QAction(tr("Stop"), this);
  mStop->setStatusTip(tr("Stoppen des Wobbelns"));
  connect(mStop, SIGNAL(triggered()), this, SLOT(clickwobbelnstop()));

  mEichenK1 = new QAction(tr("Eichen Kanal1"), this);
  mEichenK1->setStatusTip(tr("Eichen Kanal1 (Eingenschaften der Messsonde ermitteln)"));
  connect(mEichenK1, SIGNAL(triggered()), this, SLOT(eichenkanal1()));

  mEichenK2 = new QAction(tr("Eichen Kanal2"), this);
  mEichenK2->setStatusTip(tr("Eichen Kanal2 (Eingenschaften der Messsonde ermitteln)"));
  connect(mEichenK2, SIGNAL(triggered()), this, SLOT(eichenkanal2()));

  mSondeLadenK1 = new QAction(QIcon(":/images/openk1.png"), tr("Auswahl Messsonde Kanal1"), this);
  mSondeLadenK1->setStatusTip(tr("Eigenschaften der Messsonde laden fuer Kanal 1"));
  connect(mSondeLadenK1, SIGNAL(triggered()), this, SLOT(messsondeladen1()));

  mSondeLadenK2 = new QAction(QIcon(":/images/openk2.png"), tr("Auswahl Messsonde Kanal2"), this);
  mSondeLadenK2->setStatusTip(tr("Eigenschaften der Messsonde laden fuer Kanal 2"));
  connect(mSondeLadenK2, SIGNAL(triggered()), this, SLOT(messsondeladen2()));

  mSondeSpeichernK1 = new QAction(tr("Eigenschaften Messsonde Kanal 1 speichern"), this);
  mSondeSpeichernK1->setStatusTip(tr("Abspeichern der Eigenschaften der Messsonde Kanal1 in eine Datei"));
  connect(mSondeSpeichernK1, SIGNAL(triggered()), this, SLOT(messsondespeichern1()));

  mSondeSpeichernK2 = new QAction(tr("Eigenschaften Messsonde Kanal 2 speichern"), this);
  mSondeSpeichernK2->setStatusTip(tr("Abspeichern der Eigenschaften der Messsonde Kanal2 in eine Datei"));
  connect(mSondeSpeichernK2, SIGNAL(triggered()), this, SLOT(messsondespeichern2()));

  mFontInfo = new QAction(tr("Schrift im Infofenster einstellen"), this);
  mFontInfo->setStatusTip(tr("Einstellen der Schrift im Infofenster"));
  connect(mFontInfo, SIGNAL(triggered()), this, SLOT(infosetfont()));

  mFrequenzmarke = new QAction(QIcon(":/images/marken.png"), tr("Frequenzmarken"), this);
  mFrequenzmarke->setStatusTip(tr("Frequenzmarken im Wobbelfenster einblenden"));
  connect(mFrequenzmarke, SIGNAL(triggered()), this, SLOT(setFrequenzmarken()));

  mVFODreh1 = new QAction(tr("Drehgeber MHz aktiv"), this);
  mVFODreh1->setShortcut(tr("Ctrl+1"));
  mVFODreh1->setStatusTip(tr("Focus auf Drehgeber MHz setzen"));
  connect(mVFODreh1, SIGNAL(triggered()), this, SLOT(drehgeber1focus()));

  mVFODreh2 = new QAction(tr("Drehgeber kHz aktiv"), this);
  mVFODreh2->setShortcut(tr("Ctrl+2"));
  mVFODreh2->setStatusTip(tr("Focus auf Drehgeber kHz setzen"));
  connect(mVFODreh2, SIGNAL(triggered()), this, SLOT(drehgeber2focus()));

  mVFODreh3 = new QAction(tr("Drehgeber Hz aktiv"), this);
  mVFODreh3->setShortcut(tr("Ctrl+3"));
  mVFODreh3->setStatusTip(tr("Focus auf Drehgeber Hz setzen"));
  connect(mVFODreh3, SIGNAL(triggered()), this, SLOT(drehgeber3focus()));

  mWattFont = new QAction(tr("Schrift einstellen"), this);
  mWattFont->setStatusTip(tr("Schriftgroesse einstellen"));
  connect(mWattFont, SIGNAL(triggered()), this, SLOT(messsetfont()));

  mWattEichenK1 = new QAction(tr("Eichen Kanal 1"), this);
  mWattEichenK1->setStatusTip(tr("Eichen des Wattmeters"));
  connect(mWattEichenK1, SIGNAL(triggered()), this, SLOT(meichenk1()));

  mWattEichenK2 = new QAction(tr("Eichen Kanal 2"), this);
  mWattEichenK2->setStatusTip(tr("Eichen des Wattmeters"));
  connect(mWattEichenK2, SIGNAL(triggered()), this, SLOT(meichenk2()));

  mWattSchreiben = new QAction(tr("In Tabelle schreiben"), this);
  mWattSchreiben->setStatusTip(tr("Messwerte in die Tabelle schreiben"));
  connect(mWattSchreiben, SIGNAL(triggered()), this, SLOT(tabelleschreiben()));

  mTabelleSpeichern = new QAction(tr("Tabelle abspeichern"), this);
  mTabelleSpeichern->setStatusTip(tr("Tabelle als Textdatei abspeichern"));
  connect(mTabelleSpeichern, SIGNAL(triggered()), this, SLOT(tabellespeichern()));

  mDaempfungdefault = new QAction(tr("Daempfung auf default setzen"), this);
  mDaempfungdefault->setStatusTip(tr("Alle zusaetzlichen Eintraege in der ComboBox loeschen"));
  connect(mDaempfungdefault, SIGNAL(triggered()), this, SLOT(setDaempfungdefault()));
#ifdef fzaehler
  mZaehlen = new QAction(tr("Zaehlen"), this);
  mZaehlen->setStatusTip(tr("Frequenzzaehler test"));
  connect(mZaehlen, SIGNAL(triggered()), this, SLOT(zaehlen()));
#endif
  mTooltip = new QAction(tr("Tip?"), this);
  mTooltip->setStatusTip(tr("Hilfe an der Maus ein/aus-belenden"));
  mTooltip->setCheckable(true);
  connect(mTooltip, SIGNAL(triggered()), this, SLOT(tooltip()));

}

void MainWindow::createMenus()
{
    menuDatei = menuBar()->addMenu(tr("&Datei"));
    menuDatei->addAction(mDrucken);
    menuDatei->addAction(mDruckenpdf);
    menuDatei->addAction(mLayoutlabel);
    menuDatei->addAction(mBeenden);

    menuEinstellung = menuBar()->addMenu(tr("&Einstellung"));
    menuEinstellung->addAction(mEinstellungLaden);
    menuEinstellung->addAction(mEinstellungSichern);
    menuEinstellung->addSeparator();
    menuEinstellung->addAction(mInfo);
    menuEinstellung->addAction(mVersion);
    menuEinstellung->addSeparator();
    menuEinstellung->addAction(mOption);
    menuEinstellung->addSeparator();
    menuEinstellung->addAction(mFirmware);

    menuKurven = menuBar()->addMenu(tr("&Kurven"));
    menuKurven->addAction(mKurvenLaden);
    menuKurven->addAction(mKurvenSichern);
    menuKurven->addSeparator();
    menuKurven->addAction(mKurvenManager);

    menuwobbel = menuBar()->addMenu(tr("&Wobbeln"));
    menuwobbel->addAction(mWobbeln);
    menuwobbel->addAction(mEinmal);
    menuwobbel->addAction(mStop);
    menuwobbel->addSeparator();
    menuwobbel->addAction(mEichenK1);
    menuwobbel->addAction(mEichenK2);
    menuwobbel->addAction(mSondeLadenK1);
    menuwobbel->addAction(mSondeLadenK2);
    menuwobbel->addAction(mSondeSpeichernK1);
    menuwobbel->addAction(mSondeSpeichernK2);
    menuwobbel->addSeparator();
    menuwobbel->addAction(mFontInfo);
    menuwobbel->addAction(mFrequenzmarke);
    menuwobbel->addSeparator();

    menuvfo = menuBar()->addMenu(tr("&VFO"));
    menuvfo->addAction(mVFODreh1);
    menuvfo->addAction(mVFODreh2);
    menuvfo->addAction(mVFODreh3);
    
    menumessen = menuBar()->addMenu(tr("&Messen"));
    menumessen->addAction(mWattFont);
    menumessen->addAction(mWattEichenK1);
    menumessen->addAction(mWattEichenK2);
    menumessen->addSeparator();
    menumessen->addAction(mWattSchreiben);
    menumessen->addAction(mTabelleSpeichern);
    menumessen->addSeparator();
    menumessen->addAction(mDaempfungdefault);

#ifdef fzaehler
    menuzaehlen = menuBar()->addMenu(tr("&Frequenzzaehler"));
    menuzaehlen->addAction(mZaehlen);
#endif
    menuhilfe = menuBar()->addMenu(tr("&Hilfe"));
    menuhilfe->addAction(mTooltip);
}

void MainWindow::createToolBars()
{

    dateiToolBar = addToolBar(tr("Datei"));
    dateiToolBar->addAction(mBeenden);
    dateiToolBar->addAction(mDrucken);
    dateiToolBar->addAction(mDruckenpdf);
    dateiToolBar->addAction(mLayoutlabel);

    einstellungToolBar = addToolBar(tr("Einstellung"));
    einstellungToolBar->addAction(mOption);
    einstellungToolBar->addAction(mFrequenzmarke);
    einstellungToolBar->addAction(mInfo);

    sondenToolBar = addToolBar(tr("Sonden"));
    sondenToolBar->addAction(mSondeLadenK1);
    sondenToolBar->addAction(mSondeLadenK2);
    
    kurvenToolBar = addToolBar(tr("Kurven"));
    kurvenToolBar->addAction(mKurvenLaden);
    kurvenToolBar->addAction(mKurvenSichern);
    kurvenToolBar->addAction(mKurvenManager);
}

void MainWindow::createStatusBar()
{
  statusBar()->showMessage(tr("Ready"));
}

void MainWindow::createToolTip(bool btip){
  nwt7linux->tip(btip);
}

void MainWindow::tooltip(){
  writeSettings();
  createToolTip(mTooltip->isChecked());
}

void MainWindow::loadConfig(char *name)
{
  QString s = name;  
  nwt7linux->setconffilename(s);
}

void MainWindow::readSettings()
{
    QSettings settings("AFU", "NWT");
    QPoint pos = settings.value("pos", QPoint(200, 200)).toPoint();
    QSize size = settings.value("size", QSize(800, 600)).toSize();
    resize(size);
    move(pos);
    mTooltip->setChecked(settings.value("tooltip", true).toBool());
}

void MainWindow::writeSettings()
{
    QSettings settings("AFU", "NWT");
    settings.setValue("pos", pos());
    settings.setValue("size", size());
    settings.setValue("tooltip", mTooltip->isChecked());
}

void MainWindow::druckediagramm(){
  QSize size = this->size();
  resize(750,600);
  nwt7linux->druckediagramm();
  resize(size);
}

void MainWindow::druckediagrammpdf(){
  QSize size = this->size();
  resize(750,600);
  nwt7linux->druckediagrammpdf();
  resize(size);
}

void MainWindow::drucklabel(){
  nwt7linux->drucklabel();
}

void MainWindow::zaehlen(){
  nwt7linux->fzaehlen();
}

void MainWindow::EinstellungLaden(){
  nwt7linux->EinstellungLaden();
}

void MainWindow::EinstellungSichern(){
  nwt7linux->EinstellungSichern();
}

void MainWindow::KurvenLaden(){
  nwt7linux->KurvenLaden();
}

void MainWindow::KurvenSichern(){
  nwt7linux->KurvenSichern();
}

void MainWindow::Info()
{

  QMessageBox::about(this, "HFM9/NWT",
         infotext);
}

void MainWindow::option(){
  nwt7linux->option();
}

void MainWindow::clickwobbeln(){
  nwt7linux->clickwobbeln();
}

void MainWindow::clickwobbelneinmal(){
  nwt7linux->clickwobbelneinmal();
}

void MainWindow::clickwobbelnstop(){
  nwt7linux->clickwobbelnstop();
}

void MainWindow::eichenkanal1(){
  nwt7linux->eichenkanal1();
}

void MainWindow::eichenkanal2(){
  nwt7linux->eichenkanal2();
}

void MainWindow::messsondeladen1(){
  nwt7linux->messsondeladen1();
}

void MainWindow::messsondeladen2(){
  nwt7linux->messsondeladen2();
}

void MainWindow::messsondespeichern1(){
  nwt7linux->messsondespeichern1("def");
}

void MainWindow::messsondespeichern2(){
  nwt7linux->messsondespeichern2("def");
}

void MainWindow::infosetfont(){
  nwt7linux->infosetfont();
}

void MainWindow::setFrequenzmarken(){
  nwt7linux->setFrequenzmarken();
}

void MainWindow::drehgeber1focus(){
  nwt7linux->drehgeber1focus();
}

void MainWindow::drehgeber2focus(){
  nwt7linux->drehgeber2focus();
}

void MainWindow::drehgeber3focus(){
  nwt7linux->drehgeber3focus();
}

void MainWindow::messsetfont(){
  nwt7linux->messsetfont();
}

void MainWindow::meichenk1(){
  nwt7linux->meichenk1();
}

void MainWindow::meichenk2(){
  nwt7linux->meichenk2();
}

void MainWindow::version(){
  nwt7linux->version();
}

void MainWindow::tabelleschreiben(){
  nwt7linux->tabelleschreiben();
}

void MainWindow::tabellespeichern(){
  nwt7linux->tabellespeichern();
}

void MainWindow::setDaempfungdefault(){
  nwt7linux->setDaempfungdefault();
}

void MainWindow::beenden()
{
  close();
}

void MainWindow::setText(QString stty){
  setWindowTitle(tr("%1 - V.%2 - %3").arg(tr("HFM9/NWT")).arg(infoversion).arg(stty));
}

void MainWindow::firmupdate(){
  nwt7linux->firmupdate();
}

void MainWindow::openKurvenManager(){
  nwt7linux->openKurvenManager();
}

void MainWindow::msetmenu(tmenuenable menuenable, bool einaus){
  switch(menuenable){
    case emDrucken: mDrucken->setEnabled(einaus);break;
    case emDruckenpdf: mDruckenpdf->setEnabled(einaus);break;
    case emLayoutlabel: mLayoutlabel->setEnabled(einaus);break;
    case emBeenden: mBeenden->setEnabled(einaus);break;
    case emEinstellungLaden: mEinstellungLaden->setEnabled(einaus);break;
    case emEinstellungSichern: mEinstellungSichern->setEnabled(einaus);break;
    case emInfo: mInfo->setEnabled(einaus);break;
    case emOption: mOption->setEnabled(einaus);break;
    case emFirmware: mFirmware->setEnabled(einaus);break;
    case emKurvenLaden: mKurvenLaden->setEnabled(einaus);break;
    case emKurvenSichern: mKurvenSichern->setEnabled(einaus);break;
    case emWobbeln: mWobbeln->setEnabled(einaus);break;
    case emEinmal: mEinmal->setEnabled(einaus);break;
    case emStop: mStop->setEnabled(einaus);break;
    case emEichenK1: mEichenK1->setEnabled(einaus);break;
    case emEichenK2: mEichenK2->setEnabled(einaus);break;
    case emSondeLadenK1: mSondeLadenK1->setEnabled(einaus);break;
    case emSondeLadenK2: mSondeLadenK2->setEnabled(einaus);break;
    case emSondeSpeichernK1: mSondeSpeichernK1->setEnabled(einaus);break;
    case emSondeSpeichernK2: mSondeSpeichernK2->setEnabled(einaus);break;
    case emFontInfo: mFontInfo->setEnabled(einaus);break;
    case emFrequenzmarke: mFrequenzmarke->setEnabled(einaus);break;
    case emVFODreh1: mVFODreh1->setEnabled(einaus);break;
    case emVFODreh2: mVFODreh2->setEnabled(einaus);break;
    case emVFODreh3: mVFODreh3->setEnabled(einaus);break;
    case emWattFont: mWattFont->setEnabled(einaus);break;
    case emWattEichenK1: mWattEichenK1->setEnabled(einaus);break;
    case emWattEichenK2: mWattEichenK2->setEnabled(einaus);break;
    case emWattSchreiben: mWattSchreiben->setEnabled(einaus);break;
    case emTabelleSpeichern: mTabelleSpeichern->setEnabled(einaus);break;
    case emDaempfungdefault: mDaempfungdefault->setEnabled(einaus);break;
    case emVersion: mVersion->setEnabled(einaus);break;
    case emTooltip: mTooltip->setEnabled(einaus);break;
#ifdef fzaehler
    case emZaehlen: mZaehlen->setEnabled(einaus);break;
#endif
    case emmenuDatei: menuDatei->setEnabled(einaus);break;
    case emmenuEinstellung: menuEinstellung->setEnabled(einaus);break;
    case emmenuKurven: menuKurven->setEnabled(einaus);break;
    case emmenuwobbel: menuwobbel->setEnabled(einaus);break;
    case emmenuvfo: menuvfo->setEnabled(einaus);break;
    case emmenumessen: menumessen->setEnabled(einaus);break;
#ifdef fzaehler
    case emmenuzaehlen: menuzaehlen->setEnabled(einaus);break;
#endif
  }
}  


void MainWindow::paintEvent(QPaintEvent*){
#ifdef LDEBUG
  qDebug("MainWindow::paintEvent");
#endif
  nwt7linux->grafiksetzen();
  nwt7linux->setDialfocus();
}

void MainWindow::resizeEvent( QResizeEvent * ){
  //nach Groessenaenderung grafische Elemente anpassen
#ifdef LDEBUG
  qDebug("MainWindow::resizeEvent");
  qDebug("breite %i hoehe %i", width(), height());
#endif
  resize(this->rect().size());
  nwt7linux->grafiksetzen();
}
