/***************************************************************************
                          configfile.cpp  -  description
                             -------------------
    begin                : Son Aug 17 2003
    copyright            : (C) 2003 by Andreas Lindenau
    email                : DL4JAL@darc.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qdir.h>
#include <QtDebug>
 
#include "configfile.h"

// #define ldebug

configfile::configfile(){
  sl.clear(); // Liste vorsichthalber noch loeschen
  speichern=false;
}

configfile::~configfile(){
}

void configfile::open( const QString &name ){
  QString qs;
  bool binsert = true;
  QFile *f1;

#ifdef ldebug
  qDebug("open");
  qDebug()<<sl.count();
#endif
  fname = name;
  f1 = new QFile(fname);
  if(f1->open(QIODevice::ReadOnly)){
    QTextStream ts( f1);
    while(!ts.atEnd()){
      qs = ts.readLine();
      if(qs.isEmpty())binsert = false;
      if(qs.find("=")== -1)binsert = false;
      if(binsert)sl.append(qs);
#ifdef ldebug
      qDebug()<<sl.count();
#endif
    }
    f1->close();
    delete(f1);
    sl.sort();
#ifdef ldebug
    qDebug()<<sl.count();
#endif
  }
}

void configfile::close(){
  QString qs;
  QStringList::Iterator it;
  QFile *f1;
  
#ifdef ldebug
  qDebug("close");
  qDebug()<<sl.count();
#endif
  if(speichern){
    sl.sort();
    f1 = new QFile(fname);
    if(f1->open(QIODevice::WriteOnly)){
      QTextStream ts(f1);
      for(it = sl.begin() ; it != sl.end(); it++){
        qs = (*it).latin1();
#ifdef ldebug
	qDebug(qs);
#endif
        ts << qs << endl;
      }
      f1->close();
      delete(f1);
    }
  }
}

bool configfile::clearItem(const QString &name){
  QString qs1;
  QStringList::Iterator it;
  int i;
  
#ifdef ldebug
  qDebug("clearItem");
  qDebug()<<sl.count();
#endif
  speichern = true;
  for(it = sl.begin() ; it < sl.end(); it++){
    qs1 = (*it).latin1();
#ifdef ldebug
    qDebug(qs1);
#endif
    i = qs1.find(name);
    if(i == 0){
#ifdef ldebug
      qDebug()<<sl.count();
#endif
      sl.remove(qs1);
#ifdef ldebug
      qDebug()<<sl.count();
#endif
      return true;
    }
  }
  return false;
}

double configfile::readDouble(const QString &name, double def){
  QString qs1;
  QStringList::Iterator it;

#ifdef ldebug
  qDebug("readDouble");
  qDebug()<<sl.count();
#endif
  for(it = sl.begin() ; it < sl.end(); it++){
    qs1 = (*it).latin1();
    if(qs1.find(name+"=")==0){
      qs1.remove(0, name.length()+1);
      return qs1.toDouble();
    }
  }
  return def;
}

int configfile::readInteger(const QString &name, int def){
  QString qs1;
  QStringList::Iterator it;

#ifdef ldebug
  qDebug("readInteger");
  qDebug()<<sl.count();
#endif
  for(it = sl.begin() ; it < sl.end(); it++){
    qs1 = (*it).latin1();
    if(qs1.find(name+"=")==0){
      qs1.remove(0, name.length()+1);
      return qs1.toInt();
    }
  }
  return def;
}

long configfile::readLong(const QString &name, long def){
  QString qs1;
  QStringList::Iterator it;

#ifdef ldebug
  qDebug("readLong");
  qDebug()<<sl.count();
#endif
  for(it = sl.begin() ; it < sl.end(); it++){
    qs1 = (*it).latin1();
    if(qs1.find(name+"=")==0){
      qs1.remove(0, name.length()+1);
      return qs1.toLong();
    }
  }
  return def;
}

QString configfile::readString(const QString &name, const QString &def){
  QString qs1;
  QStringList::Iterator it;

#ifdef ldebug
  qDebug("readString");
  qDebug()<<sl.count();
#endif
  for(it = sl.begin() ; it < sl.end(); it++){
    qs1 = (*it).latin1();
    if(qs1.find(name+"=")==0){
      qs1.remove(0, name.length()+1);
      return qs1;
    }
  }
  return def;
}

bool configfile::readBool(const QString &name, bool def){
  QString qs1;
  QStringList::Iterator it;

#ifdef ldebug
  qDebug("readBool");
  qDebug()<<sl.count();
#endif
  for(it = sl.begin() ; it < sl.end(); it++){
    qs1 = (*it).latin1();
    if(qs1.find(name+"=")==0){
      qs1.remove(0, name.length()+1);
      return bool(qs1.toInt());
    }
  }
  return def;
}

void configfile::writeDouble(const QString &name, double wert){
  QString qs1, qs2;
  QStringList::Iterator it;

#ifdef ldebug
  qDebug("writeDouble");
  qDebug()<<sl.count();
#endif
  speichern=true;
  for(it = sl.begin() ; it < sl.end(); it++){
    qs1 = (*it).latin1();
    if(qs1.find(name + "=")==0){
      sl.erase(it);
      break;
    }
  }
  qs1 = name + "=";
  qs2.sprintf("%f", wert);
  qs1.append(qs2);
  sl.append(qs1);
  return;
}

void configfile::writeInteger(const QString &name, int wert){
  QString qs1, qs2;
  QStringList::Iterator it;

#ifdef ldebug
  qDebug("writeInteger");
  qDebug()<<sl.count();
#endif
  speichern=true;
  for(it = sl.begin() ; it < sl.end(); it++){
    qs1 = (*it).latin1();
    if(qs1.find(name + "=")==0){
      sl.erase(it);
      break;
    }
  }
  qs1 = name + "=";
  qs2.sprintf("%i", wert);
  qs1.append(qs2);
  sl.append(qs1);
  return;
}

void configfile::writeLong(const QString &name, long wert){
  QString qs1, qs2;
  QStringList::Iterator it;

#ifdef ldebug
  qDebug("writeLong");
  qDebug()<<sl.count();
#endif
  speichern=true;
  for(it = sl.begin() ; it < sl.end(); it++){
    qs1 = (*it).latin1();
    if(qs1.find(name + "=")==0){
      sl.erase(it);
      break;
    }
  }
  qs1 = name + "=";
  qs2.sprintf("%li", wert);
  qs1.append(qs2);
  sl.append(qs1);
  return;
}

void configfile::writeString(const QString &name, const QString &wert){
  QString qs1;
  QStringList::Iterator it;

#ifdef ldebug
  qDebug("writeString");
  qDebug()<<sl.count();
#endif
  speichern=true;
  for(it = sl.begin() ; it < sl.end(); it++){
    qs1 = (*it).latin1();
    if(qs1.find(name + "=")==0){
      sl.erase(it);
      break;
    }
  }
  qs1 = (name + "=" + wert);
  sl.append(qs1);
  return;
}

void configfile::writeBool(const QString &name, bool wert){
  QString qs1, qs2;
  QStringList::Iterator it;

#ifdef ldebug
  qDebug("writeBool");
  qDebug()<<sl.count();
#endif
  speichern=true;
  for(it = sl.begin() ; it < sl.end(); it++){
    qs1 = (*it).latin1();
    if(qs1.find(name + "=")==0){
      sl.erase(it);
      break;
    }
  }
  qs1 = name + "=";
  qs2.sprintf("%i", int(wert));
  qs1.append(qs2);
  sl.append(qs1);
  return;
}

