'#######################################################################################################################################################
'FFT Testprogramm N=256 Werten Ausgabe auf GLCD                               ##########################################################################
'Andreas Jahnke                                                               ##########################################################################
'nur mit IntegerZahlen und Assembler           _                  TEST: Eingangspegel Ca. 200 mV Sinus  1Khz    ########################################
'[K]=X[N] \ E^2PI*K*n/N       Boardspannung 5,4 V                           ############################################################################
'           /                                                                 ##########################################################################
'           -                                                                 ##########################################################################
'f/s=5KHz     Niquist=2,5 KHz     Spectrale Auflsung = 20 Hz pro Teilstrich  ##########################################################################
'                                                                             ##########################################################################
'#######################################################################################################################################################
'#######################################################################################################################################################


  $regfile = "m128def.dat"
  $crystal = 19660800                                       'Atmega 128
  $baud = 19200                                             'RS232 Baudrate
  Config Adc = Single , Prescaler = 128 , Reference = Internal       'The prescaler divides the internal clock by 2,4,8,16,32,64 or 128
  'Config Timer1 = Timer , Prescale = 1
  'On Timer1 Isr_von_timer1
  'Enable Timer1
  'Enable Interrupts


  Ddrf = &B00000000                                         ' Portf.0=Analogeingang
  Ddrc = &B00000001

  '-----------------------------------------------------------------------------------------
  ' T6963C graphic display support demo 240 * 128
  ' Only 240*64 supported yet
  Config Graphlcd = 240 * 128 , Dataport = Portb , Controlport = Porte , Ce = 6 , Cd = 3 , Wr = 4 , Rd = 5 , Reset = 7 , Mode = 8
  'mode 8 gives 240 / 8 = 30 columns , mode=6 gives 240 / 6 = 40 columns
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  Dim A(256)as Integer                                      'Array mit 128 Zeilen beginnend bei 1
  Dim Ak(256)as Integer                                     'Reell array
  Dim Bk(256)as Integer                                     'Imaginr array
  Dim Re(128)as Integer                                     'Wn Reell                                                             '
  Dim Im(128)as Integer                                     'Wn Imaginr
  Dim P(130)as Byte
  Dim L(1800)as Byte
  Dim Z As Integer                                          'Zhler

  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  Dim S As Integer
  Dim T As Byte
  Dim Y As Byte
  Dim X As Byte
  Dim U As Integer
  Dim V As Integer
  Dim W As Byte
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  Dim Zw1 As Integer                                        'Zwischenwerte zum Berechnen
  Dim Zw2 As Integer
  Dim Zw3 As Integer
  Dim Zw4 As Integer
  Dim Zw5 As Integer                                        'Zwischenwerte zum Berechnen
  Dim Zw6 As Integer
  Dim Zw7 As Integer                                        'Zwischenwerte zum Berechnen
  Dim Zw8 As Integer
  Dim Grafik As Byte

  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  Declare Sub Portsettings()                                ' Declarieren von Unterprogrammen
  Declare Sub Rahmen()
  Declare Sub Sample()
  Declare Sub Fft()
  Declare Sub Wn()
  Declare Sub Anzeige()
  Declare Sub Transformation()
  Declare Sub Sinus()
  Declare Sub Check()
  Declare Sub Koeffizienten()
  Declare Sub Divisionzw1_256()
  Declare Sub Divisionzw2_256()
  Declare Sub Divisionzw3_256()
  Declare Sub Divisionzw4_256()
  Declare Sub Division2()
'#######################################################################################################################################################
'#######################################################################################################################################################
  Haupt:                                                    'Hauptprogramm
  Call Portsettings()
  Cls
  Cursor Off                                                ' Unterprogrammaufruf
  Call Check()
  Call Wn()
  Call Sinus()
  Call Fft()
  Call Koeffizienten()
  Print "256 Punkte FFT OK"
  Locate 6 , 1 : Lcd "256 Punkte FFT OK"
  Waitms 5000
  Cls
  Call Rahmen()
  Haupt1:
'-------------------------------------------------------------------------------
  Call Sample()
  Call Fft()
  Call Koeffizienten()
  Toggle Portc.0


'-------------------------------------------------------------------------------
  Goto Haupt1
'#######################################################################################################################################################
'#######################################################################################################################################################
  Sub Portsettings()                                        'Anfangswerte setzen
  Locate 1 , 1 : Lcd "Fast Fourier Transformation 256 Punkte"
  Print "Atmega 128 mit AVR Bootloader 7,3728 Mhz "
  Z = 0
  End Sub Portsettings()
'#######################################################################################################################################################
  Sub Check()                                               'EEprom check
  Z = 0
  Zw1 = 0
  S = 1792
  Label91:                                                  '32640 Checksumme
  Readeeprom X , S
  Zw1 = Zw1 + X
  Incr Z
  Incr S
  If Z < 256 Then Goto Label91
  Print Zw1
  Locate 1 , 1 : Lcd Zw1
  Locate 2 , 1
  If Zw1 = 32640 Then Print "EEprom Check OK"
  If Zw1 <> 32640 Then Lcd "EEprom Check Failed"
  If Zw1 = 32640 Then Lcd "EEprom Check OK"
  If Zw1 <> 32640 Then Print "EEprom Check Failed"
  Locate 3 , 1 : Lcd "Atmega 128 / GLCD T6963c "
  End Sub Check()
'#######################################################################################################################################################
  Sub Sinus()                                               'Sinus
  Restore Dta3
  For Z = 1 To 256
  Read A(z)
  A(z) = A(z) / 2
  Next Z
  Print "Test Sinus geladen"
  Locate 4 , 1 : Lcd "Test Sinus geladen"
  End Sub Sinus()
'#######################################################################################################################################################
  Sub Sample()                                              'Sample
  Start Adc
  U = 1
  Einlesen:
  A(u) = Getadc(0) - 505                                    'ca 2,5 Volt DC am Analog Eingang einstellen
  Incr U
  If U < 257 Then Goto Einlesen
  Stop Adc
  End Sub Sample()
'#######################################################################################################################################################
  Sub Wn()                                                  'Wn Array erzeugen
  Restore Dta1
  For Z = 1 To 128
  Read Re(z)
  Next Z
  Restore Dta2
  For Z = 1 To 128
  Read Im(z)
  Next Z
  Print "256 Wn geladen"
  Locate 5 , 1 : Lcd "256 Wn geladen"
  End Sub Wn()                                              '
'#######################################################################################################################################################
  $asm                                                      'Subroutine
 Divisionzw1_256:                                           '+-Integerzahl(Zw1) geteilt durch 256
 ldi R18,1
 ldi R19,0
 ldi r22,0
 lds r16,{Zw1}                                              'Divident
 lds r17,{Zw1+1}
'-------------------------------------------------------------------------------
 CPI R17,128                                                'Test Zw1 ob negative Zahl
 BRSH equal10
 Jmp weiter10
 Equal10:
 com R16
 com R17
 add R16,R18
 adc R17,R19                                                'jetzt zw1 positive zahl
 inc r22                                                    'R22=1
 Weiter10:
'-------------------------------------------------------------------------------
' cpi r16,128                                                'Lowbyte auf/abrunden
' brsh equal11
' jmp weiter11
' Equal11:
' inc R17                                                    'beim aufrunden Inc Highbyte
' Weiter11:
'-------------------------------------------------------------------------------
 mov r16,r17                                                '/256
 ldi r17,00
'-------------------------------------------------------------------------------
 CPI R22,1                                                  'If R22=1 ob negative Zahl
 BREQ equal12
 Jmp weiter12
 Equal12:
 !Sub R16,R18
 Sbc R17 , R19
 com R16
 com R17
 Weiter12:
 sts  {Zw1},r16
 sts    {Zw1+1},r17
 Ret                                                        'Return
 $end Asm                                                   'ca 28 Cycles
'#######################################################################################################################################################
 $asm                                                       'Subroutine
 Divisionzw2_256:                                           '+-Integerzahl(Zw1) geteilt durch 256
 ldi R18,1
 ldi R19,0
 ldi r22,0
 lds r16,{Zw2}                                              'Divident
 lds r17,{Zw2+1}
'-------------------------------------------------------------------------------
 CPI R17,128                                                'Test Zw1 ob negative Zahl
 BRSH equal40
 Jmp weiter40
 Equal40:
 com R16
 com R17
 add R16,R18
 adc R17,R19                                                'jetzt zw1 positive zahl
 inc r22                                                    'R22=1
 Weiter40:
'-------------------------------------------------------------------------------
' cpi r16,128                                                'Lowbyte auf/abrunden
' brsh equal41
' jmp weiter41
' Equal11:
' inc R17                                                    'beim aufrunden Inc Highbyte
' Weiter41:
'-------------------------------------------------------------------------------
 mov r16,r17                                                '/256
 ldi r17,00
'-------------------------------------------------------------------------------
 CPI R22,1                                                  'If R22=1 ob negative Zahl
 BREQ equal42
 Jmp weiter42
 Equal42:
 !Sub R16,R18
 Sbc R17 , R19
 com R16
 com R17
 Weiter42:
 sts  {Zw2},r16
 sts    {Zw2+1},r17
 Ret                                                        'Return
 $end Asm                                                   'ca 28 Cycles
'#######################################################################################################################################################
 $asm                                                       'Subroutine
 Divisionzw3_256:                                           '+-Integerzahl(Zw1) geteilt durch 256
 ldi R18,1
 ldi R19,0
 ldi r22,0
 lds r16,{Zw3}                                              'Divident
 lds r17,{Zw3+1}
'-------------------------------------------------------------------------------
 CPI R17,128                                                'Test Zw1 ob negative Zahl
 BRSH equal50
 Jmp weiter50
 Equal50:
 com R16
 com R17
 add R16,R18
 adc R17,R19                                                'jetzt zw1 positive zahl
 inc r22                                                    'R22=1
 Weiter50:
'-------------------------------------------------------------------------------
' cpi r16,128                                                'Lowbyte auf/abrunden
' brsh equal51
' jmp weiter51
' Equal11:
' inc R17                                                    'beim aufrunden Inc Highbyte
' Weiter51:
'-------------------------------------------------------------------------------
 mov r16,r17                                                '/256
 ldi r17,00
'-------------------------------------------------------------------------------
 CPI R22,1                                                  'If R22=1 ob negative Zahl
 BREQ equal52
 Jmp weiter52
 Equal52:
 !Sub R16,R18
 Sbc R17 , R19
 com R16
 com R17
 Weiter52:
 sts  {Zw3},r16
 sts    {Zw3+1},r17
 Ret                                                        'Return
 $end Asm                                                   'ca 28 Cycles
'#######################################################################################################################################################
 $asm                                                       'Subroutine
 Divisionzw4_256:                                           '+-Integerzahl(Zw1) geteilt durch 256
 ldi R18,1
 ldi R19,0
 ldi r22,0
 lds r16,{Zw4}                                              'Divident
 lds r17,{Zw4+1}
'-------------------------------------------------------------------------------
 CPI R17,128                                                'Test Zw1 ob negative Zahl
 BRSH equal60
 Jmp weiter60
 Equal60:
 com R16
 com R17
 add R16,R18
 adc R17,R19                                                'jetzt zw1 positive zahl
 inc r22                                                    'R22=1
 Weiter60:
'-------------------------------------------------------------------------------
' cpi r16,128                                                'Lowbyte auf/abrunden
' brsh equal61
' jmp weiter61
' Equal11:
' inc R17                                                    'beim aufrunden Inc Highbyte
' Weiter61:
'-------------------------------------------------------------------------------
 mov r16,r17                                                '/256
 ldi r17,00
'-------------------------------------------------------------------------------
 CPI R22,1                                                  'If R22=1 ob negative Zahl
 BREQ equal62
 Jmp weiter62
 Equal62:
 !Sub R16,R18
 Sbc R17 , R19
 com R16
 com R17
 Weiter62:
 sts  {Zw4},r16
 sts    {Zw4+1},r17
 Ret                                                        'Return
 $end Asm                                                   'ca 28 Cycles
'#######################################################################################################################################################
    $asm                                                    'Subroutine
  Division2:                                                '+-Integerzahl(Zw1) geteilt durch 2
  ldi r22,0
  ldi r18,1
  ldi r19,0
  lds r16,{Zw3}                                             'Einlesen ZW1
  lds r17,{Zw3+1}
'-------------------------------------------------------------------------------
  CPI R17,128                                               'Test Zw1 ob negative Zahl
  BRSH equal20
  Jmp weiter20
  Equal20:
  com R17
  com R16
  add r16,r18
  adc r17,r19                                               'jetzt zw1 positive zahl
  inc r22                                                   'R22=1
  Weiter20:
'-------------------------------------------------------------------------------
  asr r17                                                   'arithmetic shift rotate
  brcs equal23                                              'branch if carry set
  asr r16
  jmp weiter23
  Equal23:
  asr r16
  sbr r16,128
  Weiter23:
'-------------------------------------------------------------------------------
  CPI R22,1                                                 'If R22=01 ob negative Zahl
  BREQ equal22
  Jmp weiter22
  Equal22:
  !sub R16,r18
  sbc  r17,r19
  com R16
  com R17
  Weiter22:
  sts  {Zw3},r16                                            'Ergebnis in ZW1
  sts    {Zw3+1},r17
  ret                                                       'Return
 $end Asm                                                   'ca 25 Cycles
'#######################################################################################################################################################
  Sub Fft()                                                 'FFT
  Z = 0
  Label50:
  Readeeprom X , Z
  Incr X
  Zw1 = A(x)
  Incr Z
  Readeeprom Y , Z                                          '2.Punkte DFT
  Incr Y                                                    '1 mal W2^0
  Zw2 = A(y)
  Incr Z
'-------------------------------------------------------------------------------
  Zw3 = Zw1 + Zw2                                           '1.Rcksortierung
  Call Division2()                                          'Zw3 = Zw3 / 2
  Ak(x) = Zw3
  Bk(x) = 0
  Zw3 = Zw1 - Zw2
  Call Division2()                                          'Zw3 = Zw3 / 2
  Ak(y) = Zw3
  Bk(y) = 0
  If Z < 256 Then Goto Label50
'-------------------------------------------------------------------------------
  $asm
  'Z = 256                                                  '2. Rcksortierung
  ldi r16,&h00
  ldi r17,&h01
  sts {Z},r16
  sts {Z+1},r17
'----------------
 ' V = 2048
  ldi r16,&h00
  ldi r17,&h08
  sts {V},r16
  sts {V+1},r17
'----------------
  'T = 2                                                     '2 mal W4^0-W4^1
  ldi r16,&h02
  ldi r17,&h00
  sts {T},r16
  sts {T+1},r17
'----------------
  'S = 2050
  ldi r16,&h02
  ldi r17,&h08
  sts {S},r16
  sts {S+1},r17
'----------------
 !Call Transformation
'-------------------------------------------------------------------------------
  'Z = 512                                                   '3. Rcksortierung
  ldi r16,&h00
  ldi r17,&h02
  sts {Z},r16
  sts {Z+1},r17
'----------------
  'V = 2064
  ldi r16,&h10
  ldi r17,&h08
  sts {V},r16
  sts {V+1},r17
'----------------
  'T = 4                                                     '4 mal W8^0-W8^3
  ldi r16,&h04
  ldi r17,&h00
  sts {T},r16
  sts {T+1},r17
'----------------
  'S = 2068
  ldi r16,&h14
  ldi r17,&h08
  sts {S},r16
  sts {S+1},r17
'----------------
 !Call Transformation
'-------------------------------------------------------------------------------
  'Z = 768                                                   '4. Rcksortierung
  ldi r16,&h00
  ldi r17,&h03
  sts {Z},r16
  sts {Z+1},r17
  'V = 2080
  ldi r16,&h20
  ldi r17,&h08
  sts {V},r16
  sts {V+1},r17
  'T = 8                                                    '8 mal W16^0-W16^7
  ldi r16,&h08
  ldi r17,&h00
  sts {T},r16
  sts {T+1},r17
  'S = 2088
  ldi r16,&h28
  ldi r17,&h08
  sts {S},r16
  sts {S+1},r17
 !Call Transformation
'-------------------------------------------------------------------------------
  'Z = 1024                                                  '5. Rcksortierung
  ldi r16,&h00
  ldi r17,&h04
  sts {Z},r16
  sts {Z+1},r17
  'V = 2096
  ldi r16,&h30
  ldi r17,&h08
  sts {V},r16
  sts {V+1},r17
  'T = 16                                                       '16 mal  W32^0-W32^15
  ldi r16,&h10
  ldi r17,&h00
  sts {T},r16
  sts {T+1},r17
  'S = 2112
  ldi r16,&h40
  ldi r17,&h08
  sts {S},r16
  sts {S+1},r17
 !Call Transformation
'-------------------------------------------------------------------------------
  'Z = 1280                                                  '6. Rcksortierung
  ldi r16,&h00
  ldi r17,&h05
  sts {Z},r16
  sts {Z+1},r17
  'V = 2112
  ldi r16,&h40
  ldi r17,&h08
  sts {V},r16
  sts {V+1},r17
  'T = 32                                                    '32 mal  W64^0-W64^31
  ldi r16,&h20
  ldi r17,&h0
  sts {T},r16
  sts {T+1},r17
  'S = 2144
  ldi r16,&h60
  ldi r17,&h08
  sts {S},r16
  sts {S+1},r17
 !Call Transformation
'-------------------------------------------------------------------------------
  'Z = 1536                                                  '7. Rcksortierung
  ldi r16,&h00
  ldi r17,&h06
  sts {Z},r16
  sts {Z+1},r17
  'V = 2144
  ldi r16,&h60
  ldi r17,&h08
  sts {V},r16
  sts {V+1},r17
  'T = 64                                                    '64 mal W128^0-W128^63
  ldi r16,&h40
  ldi r17,&h00
  sts {T},r16
  sts {T+1},r17
  'S = 2208
  ldi r16,&hA0
  ldi r17,&h08
  sts {S},r16
  sts {S+1},r17
  !Call Transformation
'-------------------------------------------------------------------------------
 ' Z = 1792                                                  '8. Rcksortierung
  ldi r16,&h00
  ldi r17,&h07
  sts {Z},r16
  sts {Z+1},r17
 ' V = 2208
  ldi r16,&hA0
  ldi r17,&h08
  sts {V},r16
  sts {V+1},r17
 ' T = 128                                                   '128 mal W256^0-W256^127
  ldi r16,&h80
  ldi r17,&h00
  sts {T},r16
  sts {T+1},r17
 ' S = 2336
  ldi r16,&h20
  ldi r17,&h09
  sts {S},r16
  sts {S+1},r17
  !Call Transformation                                      '              Cycles 217
  $end Asm
'-------------------------------------------------------------------------------
  End Sub Fft()
'#######################################################################################################################################################
  Sub Koeffizienten()
  Z = 0                                                     'Koeff Ausgabe
  Label57:
  Readeeprom X , Z
  Incr X
  Zw1 = Ak(x)
  Zw2 = Bk(x)
  '++++++++++++++
  Zw1 = Abs(zw1)                                            'falscher Pythagoras
  Zw2 = Abs(zw2)
  If Zw1 < Zw2 Then Zw2 = Zw2 + Zw2 Else Zw1 = Zw1 + Zw1
  Zw3 = Zw1 + Zw2
  '++++++++++++++
  Incr Z
  Call Anzeige()
  If Z < 129 Then Goto Label57
  End Sub Koeffizienten()
'#######################################################################################################################################################
  Sub Transformation()
  'V=                                                       '1.EEprom Einsprungadresse fr Butterfly Kombinationen
  U = 1                                                     'Zhler fr 128 Butterflys
  Label40:
  Readeeprom X , Z                                          'lese Wert X  aus Adresse Z
  Incr X                                                    'Arrays beginnen immer mit Adresse 1
  Incr Z                                                    'next EEpromadresse
  Readeeprom Y , Z                                          'lese Wert Y aus Adresse Z
  Incr Y                                                    'Arrays beginnen immer mit Adresse 1
  Incr Z                                                    'next EEpromadresse
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  Readeeprom W , V                                          'Wn^k, lese Wert W  aus Adresse V
  Incr W                                                    '1.Wn Faktor ist immer Wn^0 und liegt
  Zw1 = Ak(y) * Re(w)                                       ' auf Adresse Re(1) und Im(1)

  Call Divisionzw1_256()                                    'Zw1=Zw1/256

  Zw2 = Bk(y) * Im(w)

  Call Divisionzw2_256()                                    'Zw2 = Zw2 / 256

  Zw3 = Ak(y) * Im(w)

  Call Divisionzw3_256()                                    'Zw3 = Zw3 / 256

  Zw4 = Bk(y) * Re(w)

  Call Divisionzw4_256()                                    'Zw4 = Zw4 / 256

  Zw5 = Zw1 - Zw2                                           'Zw5=Ak(y)
  Zw6 = Zw3 + Zw4                                           'Zw6=Bk(y)
  Zw7 = Ak(x)                                               'Zw7= Ak(x)
  Zw8 = Bk(x)                                               'Zw8= Bk(x)
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  Zw1 = Zw7 + Zw5                                           'Butterfly Operationen
  Zw2 = Zw8 + Zw6

  Zw3 = Zw7 - Zw5
  Zw3 = Zw3 / 2
  Ak(y) = Zw3

  Zw3 = Zw8 - Zw6
  Zw3 = Zw3 / 2
  Bk(y) = Zw3

  Zw1 = Zw1 / 2
  Ak(x) = Zw1

  Zw2 = Zw2 / 2
  Bk(x) = Zw2
                                           'Zurck kopieren auf Ak(x) und Bk(x)
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'sowie Ak(y) und Bk(y),
  Incr V                                                    'nchster Wn Wert
  Incr U                                                    'nchster Butterfly max. 64
  If V = S Then V = S -t
  If U < 129 Then Goto Label40
  End Sub Transformation()
'########################################################################################################################################################
  Sub Anzeige()
  Grafik = Zw3
  If Grafik > 110 Then Grafik = 110
  Grafik = 111 - Grafik
  If Grafik = P(z) Then Goto Weiter70
'##############################Line(x0 , Y0) -(x1 , Y1) , On / Off#############################
  'Linie:
  'Line(z , 1) -(z , P(z)) , 0                               ' Balkendarstellung
  'Line(z , 111) -(z , Grafik) , 255
  'P(z) = Grafik
  'Goto Weiter70
  '##############################PSET X,Y, ON/OFF################################################
  'Punkte:                                                   ' Punktedarstellung
  Pset Z , P(z) , 0                                         'Vorherigen Punkt lschen
  Pset Z , Grafik , 255
  P(z) = Grafik
  '#######################
  Weiter70:
  End Sub Anzeige()
'#######################################################################################################################################################
  Sub Rahmen()
  Line(0 , 0) -(240 , 0) , 255                              ' horizontal upper line
  Line(0 , 127) -(239 , 127) , 255                          'horizontal lower line
  Line(0 , 0) -(0 , 127) , 255                              ' vertical left line
  Line(239 , 0) -(239 , 127) , 255                          ' vertical right line
  Line(0 , 112) -(130 , 112) , 255                          'Scala
  Line(30 , 113 ) -(30 , 115) , 255
  Line(58 , 113 ) -(58 , 115) , 255
  Line(87 , 113 ) -(87 , 115) , 255
  Line(116 , 113 ) -(116 , 115) , 255
  Locate 16 , 1 : Lcd " 0,5k 1k 1,5k 2k   "
  Locate 2 , 1 : Lcd "                       DD8ZJ"         'CALL
  End Sub Rahmen()
  End
'#######################################################################################################################################################
  Dta1:                                                     'reelle Wn Werte  (Cos)
Data 256% , 256% , 256% , 255% , 255% , 254% , 253% , 252% , 251% , 250% , 248% , 247% , 245% , 243% , 241% , 239%
Data 237% , 234% , 231% , 229% , 226% , 223% , 220% , 216% , 213% , 209% , 206% , 202% , 198% , 194% , 190% , 185%
Data 181% , 177% , 172% , 167% , 162% , 157% , 152% , 147% , 142% , 137% , 132% , 126% , 121% , 115% , 109% , 104%
Data 98% , 92% , 86% , 80% , 74% , 68% , 62% , 56% , 50% , 44% , 38% , 31% , 25% , 19% , 13% , 6%
Data 0% , -6% , -13% , -19% , -25% , -31% , -38% , -44% , -50% , -56% , -62% , -68% , -74% , -80% , -86% , -92%
Data -98% , -104% , -109% , -115% , -121% , -126% , -132% , -137% , -142% , -147% , -152% , -157% , -162% , -167% , -172% , -177%
Data -181% , -185% , -190% , -194% , -198% , -202% , -206% , -209% , -213% , -216% , -220% , -223% , -226% , -229% , -231% , -234%
Data -237% , -239% , -241% , -243% , -245% , -247% , -248% , -250% , -251% , -252% , -253% , -254% , -255% , -255% , -256% , -256%

Dta2:                                                       'imaginre Wn Werte  (Sin)
Data 0% , -6% , -13% , -19% , -25% , -31% , -38% , -44% , -50% , -56% , -62% , -68% , -74% , -80% , -86% , -92%
Data -98% , -104% , -109% , -115% , -121% , -126% , -132% , -137% , -142% , -147% , -152% , -157% , -162% , -167% , -172% , -177%
Data -181% , -185% , -190% , -194% , -198% , -202% , -206% , -209% , -213% , -216% , -220% , -223% , -226% , -229% , -231% , -234%
Data -237% , -239% , -241% , -243% , -245% , -247% , -248% , -250% , -251% , -252% , -253% , -254% , -255% , -255% , -256% , -256%
Data -256% , -256% , -256% , -255% , -255% , -254% , -253% , -252% , -251% , -250% , -248% , -247% , -245% , -243% , -241% , -239%
Data -237% , -234% , -231% , -229% , -226% , -223% , -220% , -216% , -213% , -209% , -206% , -202% , -198% , -194% , -190% , -185%
Data -181% , -177% , -172% , -167% , -162% , -157% , -152% , -147% , -142% , -137% , -132% , -126% , -121% , -115% , -109% , -104%
Data -98% , -92% , -86% , -80% , -74% , -68% , -62% , -56% , -50% , -44% , -38% , -31% , -25% , -19% , -13% , -6%

Dta3:                                                       'Testsinus
Data 0% , 25% , 49% , 69% , 85% , 95% , 100% , 98% , 90% , 76% , 57% , 34% , 10% , -16% , -40% , -62%
Data -79% , -92% , -99% , -99% , -94% , -82% , -65% , -43% , -19% , 6% , 31% , 54% , 73% , 88% , 97% , 100%
Data 97% , 87% , 72% , 52% , 29% , 4% , -21% , -45% , -66% , -83% , -94% , -100% , -99% , -91% , -78% , -60%
Data -38% , -14% , 12% , 36% , 58% , 77% , 90% , 98% , 100% , 95% , 84% , 68% , 47% , 23% , -2% , -27%
Data -50% , -70% , -86% , -96% , -100% , -98% , -89% , -74% , -55% , -33% , -8% , 17% , 42% , 63% , 81% , 93%
Data 99% , 99% , 93% , 81% , 63% , 42% , 18% , -8% , -32% , -55% , -74% , -89% , -97% , -100% , -96% , -86%
Data -70% , -50% , -27% , -2% , 23% , 47% , 67% , 84% , 95% , 100% , 98% , 91% , 77% , 59% , 36% , 12%
Data -13% , -38% , -60% , -78% , -91% , -99% , -100% , -94% , -83% , -66% , -45% , -21% , 4% , 29% , 52% , 72%
Data 87% , 97% , 100% , 97% , 88% , 73% , 54% , 31% , 6% , -19% , -43% , -64% , -82% , -94% , -99% , -99%
Data -92% , -79% , -62% , -40% , -16% , 10% , 34% , 57% , 76% , 90% , 98% , 100% , 96% , 85% , 69% , 49%
Data 25% , 0% , -25% , -48% , -69% , -85% , -95% , -100% , -98% , -90% , -76% , -57% , -35% , -10% , 15% , 40%
Data 61% , 79% , 92% , 99% , 99% , 94% , 82% , 65% , 44% , 20% , -6% , -31% , -53% , -73% , -88% , -97%
Data -100% , -97% , -87% , -72% , -52% , -29% , -4% , 21% , 45% , 66% , 83% , 94% , 100% , 99% , 91% , 78%
Data 60% , 38% , 14% , -11% , -36% , -58% , -77% , -90% , -98% , -100% , -95% , -84% , -68% , -47% , -23% , 2%
Data 27% , 50% , 70% , 86% , 96% , 100% , 98% , 89% , 75% , 55% , 33% , 8% , -17% , -41% , -63% , -80%
Data -93% , -99% , -99% , -93% , -81% , -63% , -42% , -18% , 8% , 0% , 0% , 0% , 0% , 0% , 0% , 0%
'#######################################################################################################################################################
$eeprom
$eepromhex                                                  '256 Punkte Dft aufgeteilt in 128*2 Punkte Dft
  '1.Dft =0/64  2.=32/96  usw.              K = 0-N/2
  '------------------------------------------------------------------------------------------------------------------
Data 0 , 128 , 64 , 192 , 32 , 160 , 96 , 224 , 16 , 144 , 80 , 208 , 48 , 176 , 112 , 240       'Anf adr.00 hex    OK
Data 8 , 136 , 72 , 200 , 40 , 168 , 104 , 232 , 24 , 152 , 88 , 216 , 56 , 184 , 120 , 248       'Dec 0
Data 4 , 132 , 68 , 196 , 36 , 164 , 100 , 228 , 20 , 148 , 84 , 212 , 52 , 180 , 116 , 244
Data 12 , 140 , 76 , 204 , 44 , 172 , 108 , 236 , 28 , 156 , 92 , 220 , 60 , 188 , 124 , 252
Data 2 , 130 , 66 , 194 , 34 , 162 , 98 , 226 , 18 , 146 , 82 , 210 , 50 , 178 , 114 , 242
Data 10 , 138 , 74 , 202 , 42 , 170 , 106 , 234 , 26 , 154 , 90 , 218 , 58 , 186 , 122 , 250
Data 6 , 134 , 70 , 198 , 38 , 166 , 102 , 230 , 22 , 150 , 86 , 214 , 54 , 182 , 118 , 246
Data 14 , 142 , 78 , 206 , 46 , 174 , 110 , 238 , 30 , 158 , 94 , 222 , 62 , 190 , 126 , 254
Data 1 , 129 , 65 , 193 , 33 , 161 , 97 , 225 , 17 , 145 , 81 , 209 , 49 , 177 , 113 , 241
Data 9 , 137 , 73 , 201 , 41 , 169 , 105 , 233 , 25 , 153 , 89 , 217 , 57 , 185 , 121 , 249
Data 5 , 133 , 69 , 197 , 37 , 165 , 101 , 229 , 21 , 149 , 85 , 213 , 53 , 181 , 117 , 245
Data 13 , 141 , 77 , 205 , 45 , 173 , 109 , 237 , 29 , 157 , 93 , 221 , 61 , 189 , 125 , 253
Data 3 , 131 , 67 , 195 , 35 , 163 , 99 , 227 , 19 , 147 , 83 , 211 , 51 , 179 , 115 , 243
Data 11 , 139 , 75 , 203 , 43 , 171 , 107 , 235 , 27 , 155 , 91 , 219 , 59 , 187 , 123 , 251
Data 7 , 135 , 71 , 199 , 39 , 167 , 103 , 231 , 23 , 151 , 87 , 215 , 55 , 183 , 119 , 247
Data 15 , 143 , 79 , 207 , 47 , 175 , 111 , 239 , 31 , 159 , 95 , 223 , 63 , 191 , 127 , 255
'------------------------------------------------------------------------------------------------------------------
Data 0 , 64 , 128 , 192 , 32 , 96 , 160 , 224 , 16 , 80 , 144 , 208 , 48 , 112 , 176 , 240       'Anf adr.256 Dec
Data 8 , 72 , 136 , 200 , 40 , 104 , 168 , 232 , 24 , 88 , 152 , 216 , 56 , 120 , 184 , 248
Data 4 , 68 , 132 , 196 , 36 , 100 , 164 , 228 , 20 , 84 , 148 , 212 , 52 , 116 , 180 , 244
Data 12 , 76 , 140 , 204 , 44 , 108 , 172 , 236 , 28 , 92 , 156 , 220 , 60 , 124 , 188 , 252
Data 2 , 66 , 130 , 194 , 34 , 98 , 162 , 226 , 18 , 82 , 146 , 210 , 50 , 114 , 178 , 242
Data 10 , 74 , 138 , 202 , 42 , 106 , 170 , 234 , 26 , 90 , 154 , 218 , 58 , 122 , 186 , 250
Data 6 , 70 , 134 , 198 , 38 , 102 , 166 , 230 , 22 , 86 , 150 , 214 , 54 , 118 , 182 , 246
Data 14 , 78 , 142 , 206 , 46 , 110 , 174 , 238 , 30 , 94 , 158 , 222 , 62 , 126 , 190 , 254
Data 1 , 65 , 129 , 193 , 33 , 97 , 161 , 225 , 17 , 81 , 145 , 209 , 49 , 113 , 177 , 241
Data 9 , 73 , 137 , 201 , 41 , 105 , 169 , 233 , 25 , 89 , 153 , 217 , 57 , 121 , 185 , 249
Data 5 , 69 , 133 , 197 , 37 , 101 , 165 , 229 , 21 , 85 , 149 , 213 , 53 , 117 , 181 , 245
Data 13 , 77 , 141 , 205 , 45 , 109 , 173 , 237 , 29 , 93 , 157 , 221 , 61 , 125 , 189 , 253
Data 3 , 67 , 131 , 195 , 35 , 99 , 163 , 227 , 19 , 83 , 147 , 211 , 51 , 115 , 179 , 243
Data 11 , 75 , 139 , 203 , 43 , 107 , 171 , 235 , 27 , 91 , 155 , 219 , 59 , 123 , 187 , 251
Data 7 , 71 , 135 , 199 , 39 , 103 , 167 , 231 , 23 , 87 , 151 , 215 , 55 , 119 , 183 , 247
Data 15 , 79 , 143 , 207 , 47 , 111 , 175 , 239 , 31 , 95 , 159 , 223 , 63 , 127 , 191 , 255
'-------------------------------------------------------------------------------------------------------------------
Data 0 , 32 , 128 , 160 , 64 , 96 , 192 , 224 , 16 , 48 , 144 , 176 , 80 , 112 , 208 , 240       'Anf adr.512 Dec
Data 8 , 40 , 136 , 168 , 72 , 104 , 200 , 232 , 24 , 56 , 152 , 184 , 88 , 120 , 216 , 248
Data 4 , 36 , 132 , 164 , 68 , 100 , 196 , 228 , 20 , 52 , 148 , 180 , 84 , 116 , 212 , 244
Data 12 , 44 , 140 , 172 , 76 , 108 , 204 , 236 , 28 , 60 , 156 , 188 , 92 , 124 , 220 , 252
Data 2 , 34 , 130 , 162 , 66 , 98 , 194 , 226 , 18 , 50 , 146 , 178 , 82 , 114 , 210 , 242
Data 10 , 42 , 138 , 170 , 74 , 106 , 202 , 234 , 26 , 58 , 154 , 186 , 90 , 122 , 218 , 250
Data 6 , 38 , 134 , 166 , 70 , 102 , 198 , 230 , 22 , 54 , 150 , 182 , 86 , 118 , 214 , 246
Data 14 , 46 , 142 , 174 , 78 , 110 , 206 , 238 , 30 , 62 , 158 , 190 , 94 , 126 , 222 , 254
Data 1 , 33 , 129 , 161 , 65 , 97 , 193 , 225 , 17 , 49 , 145 , 177 , 81 , 113 , 209 , 241
Data 9 , 41 , 137 , 169 , 73 , 105 , 201 , 233 , 25 , 57 , 153 , 185 , 89 , 121 , 217 , 249
Data 5 , 37 , 133 , 165 , 69 , 101 , 197 , 229 , 21 , 53 , 149 , 181 , 85 , 117 , 213 , 245
Data 13 , 45 , 141 , 173 , 77 , 109 , 205 , 237 , 29 , 61 , 157 , 189 , 93 , 125 , 221 , 253
Data 3 , 35 , 131 , 163 , 67 , 99 , 195 , 227 , 19 , 51 , 147 , 179 , 83 , 115 , 211 , 243
Data 11 , 43 , 139 , 171 , 75 , 107 , 203 , 235 , 27 , 59 , 155 , 187 , 91 , 123 , 219 , 251
Data 7 , 39 , 135 , 167 , 71 , 103 , 199 , 231 , 23 , 55 , 151 , 183 , 87 , 119 , 215 , 247
Data 15 , 47 , 143 , 175 , 79 , 111 , 207 , 239 , 31 , 63 , 159 , 191 , 95 , 127 , 223 , 255
'-------------------------------------------------------------------------------------------------------------------
Data 0 , 16 , 128 , 144 , 64 , 80 , 192 , 208 , 32 , 48 , 160 , 176 , 96 , 112 , 224 , 240       'Anf adr.768 Dec
Data 8 , 24 , 136 , 152 , 72 , 88 , 200 , 216 , 40 , 56 , 168 , 184 , 104 , 120 , 232 , 248
Data 4 , 20 , 132 , 148 , 68 , 84 , 196 , 212 , 36 , 52 , 164 , 180 , 100 , 116 , 228 , 244
Data 12 , 28 , 140 , 156 , 76 , 92 , 204 , 220 , 44 , 60 , 172 , 188 , 108 , 124 , 236 , 252
Data 2 , 18 , 130 , 146 , 66 , 82 , 194 , 210 , 34 , 50 , 162 , 178 , 98 , 114 , 226 , 242
Data 10 , 26 , 138 , 154 , 74 , 90 , 202 , 218 , 42 , 58 , 170 , 186 , 106 , 122 , 234 , 250
Data 6 , 22 , 134 , 150 , 70 , 86 , 198 , 214 , 38 , 54 , 166 , 182 , 102 , 118 , 230 , 246
Data 14 , 30 , 142 , 158 , 78 , 94 , 206 , 222 , 46 , 62 , 174 , 190 , 110 , 126 , 238 , 254
Data 1 , 17 , 129 , 145 , 65 , 81 , 193 , 209 , 33 , 49 , 161 , 177 , 97 , 113 , 225 , 241
Data 9 , 25 , 137 , 153 , 73 , 89 , 201 , 217 , 41 , 57 , 169 , 185 , 105 , 121 , 233 , 249
Data 5 , 21 , 133 , 149 , 69 , 85 , 197 , 213 , 37 , 53 , 165 , 181 , 101 , 117 , 229 , 245
Data 13 , 29 , 141 , 157 , 77 , 93 , 205 , 221 , 45 , 61 , 173 , 189 , 109 , 125 , 237 , 253
Data 3 , 19 , 131 , 147 , 67 , 83 , 195 , 211 , 35 , 51 , 163 , 179 , 99 , 115 , 227 , 243
Data 11 , 27 , 139 , 155 , 75 , 91 , 203 , 219 , 43 , 59 , 171 , 187 , 107 , 123 , 235 , 251
Data 7 , 23 , 135 , 151 , 71 , 87 , 199 , 215 , 39 , 55 , 167 , 183 , 103 , 119 , 231 , 247
Data 15 , 31 , 143 , 159 , 79 , 95 , 207 , 223 , 47 , 63 , 175 , 191 , 111 , 127 , 239 , 255
'-------------------------------------------------------------------------------------------------------------------
Data 0 , 8 , 128 , 136 , 64 , 72 , 192 , 200 , 32 , 40 , 160 , 168 , 96 , 104 , 224 , 232       'Anf adr.1024 Dec
Data 16 , 24 , 144 , 152 , 80 , 88 , 208 , 216 , 48 , 56 , 176 , 184 , 112 , 120 , 240 , 248
Data 4 , 12 , 132 , 140 , 68 , 76 , 196 , 204 , 36 , 44 , 164 , 172 , 100 , 108 , 228 , 236
Data 20 , 28 , 148 , 156 , 84 , 92 , 212 , 220 , 52 , 60 , 180 , 188 , 116 , 124 , 244 , 252
Data 2 , 10 , 130 , 138 , 66 , 74 , 194 , 202 , 34 , 42 , 162 , 170 , 98 , 106 , 226 , 234
Data 18 , 26 , 146 , 154 , 82 , 90 , 210 , 218 , 50 , 58 , 178 , 186 , 114 , 122 , 242 , 250
Data 6 , 14 , 134 , 142 , 70 , 78 , 198 , 206 , 38 , 46 , 166 , 174 , 102 , 110 , 230 , 238
Data 22 , 30 , 150 , 158 , 86 , 94 , 214 , 222 , 54 , 62 , 182 , 190 , 118 , 126 , 246 , 254
Data 1 , 9 , 129 , 137 , 65 , 73 , 193 , 201 , 33 , 41 , 161 , 169 , 97 , 105 , 225 , 233
Data 17 , 25 , 145 , 153 , 81 , 89 , 209 , 217 , 49 , 57 , 177 , 185 , 113 , 121 , 241 , 249
Data 5 , 13 , 133 , 141 , 69 , 77 , 197 , 205 , 37 , 45 , 165 , 173 , 101 , 109 , 229 , 237
Data 21 , 29 , 149 , 157 , 85 , 93 , 213 , 221 , 53 , 61 , 181 , 189 , 117 , 125 , 245 , 253
Data 3 , 11 , 131 , 139 , 67 , 75 , 195 , 203 , 35 , 43 , 163 , 171 , 99 , 107 , 227 , 235
Data 19 , 27 , 147 , 155 , 83 , 91 , 211 , 219 , 51 , 59 , 179 , 187 , 115 , 123 , 243 , 251
Data 7 , 15 , 135 , 143 , 71 , 79 , 199 , 207 , 39 , 47 , 167 , 175 , 103 , 111 , 231 , 239
Data 23 , 31 , 151 , 159 , 87 , 95 , 215 , 223 , 55 , 63 , 183 , 191 , 119 , 127 , 247 , 255
'-------------------------------------------------------------------------------------------------------------------
Data 0 , 4 , 128 , 132 , 64 , 68 , 192 , 196 , 32 , 36 , 160 , 164 , 96 , 100 , 224 , 228       'Anf adr.1280 Dec
Data 16 , 20 , 144 , 148 , 80 , 84 , 208 , 212 , 48 , 52 , 176 , 180 , 112 , 116 , 240 , 244
Data 8 , 12 , 136 , 140 , 72 , 76 , 200 , 204 , 40 , 44 , 168 , 172 , 104 , 108 , 232 , 236
Data 24 , 28 , 152 , 156 , 88 , 92 , 216 , 220 , 56 , 60 , 184 , 188 , 120 , 124 , 248 , 252
Data 2 , 6 , 130 , 134 , 66 , 70 , 194 , 198 , 34 , 38 , 162 , 166 , 98 , 102 , 226 , 230
Data 18 , 22 , 146 , 150 , 82 , 86 , 210 , 214 , 50 , 54 , 178 , 182 , 114 , 118 , 242 , 246
Data 10 , 14 , 138 , 142 , 74 , 78 , 202 , 206 , 42 , 46 , 170 , 174 , 106 , 110 , 234 , 238
Data 26 , 30 , 154 , 158 , 90 , 94 , 218 , 222 , 58 , 62 , 186 , 190 , 122 , 126 , 250 , 254
Data 1 , 5 , 129 , 133 , 65 , 69 , 193 , 197 , 33 , 37 , 161 , 165 , 97 , 101 , 225 , 229
Data 17 , 21 , 145 , 149 , 81 , 85 , 209 , 213 , 49 , 53 , 177 , 181 , 113 , 117 , 241 , 245
Data 9 , 13 , 137 , 141 , 73 , 77 , 201 , 205 , 41 , 45 , 169 , 173 , 105 , 109 , 233 , 237
Data 25 , 29 , 153 , 157 , 89 , 93 , 217 , 221 , 57 , 61 , 185 , 189 , 121 , 125 , 249 , 253
Data 3 , 7 , 131 , 135 , 67 , 71 , 195 , 199 , 35 , 39 , 163 , 167 , 99 , 103 , 227 , 231
Data 19 , 23 , 147 , 151 , 83 , 87 , 211 , 215 , 51 , 55 , 179 , 183 , 115 , 119 , 243 , 247
Data 11 , 15 , 139 , 143 , 75 , 79 , 203 , 207 , 43 , 47 , 171 , 175 , 107 , 111 , 235 , 239
Data 27 , 31 , 155 , 159 , 91 , 95 , 219 , 223 , 59 , 63 , 187 , 191 , 123 , 127 , 251 , 255
'-------------------------------------------------------------------------------------------------------------------
Data 0 , 2 , 128 , 130 , 64 , 66 , 192 , 194 , 32 , 34 , 160 , 162 , 96 , 98 , 224 , 226       'Anf adr.1536 Dec
Data 16 , 18 , 144 , 146 , 80 , 82 , 208 , 210 , 48 , 50 , 176 , 178 , 112 , 114 , 240 , 242
Data 8 , 10 , 136 , 138 , 72 , 74 , 200 , 202 , 40 , 42 , 168 , 170 , 104 , 106 , 232 , 234
Data 24 , 26 , 152 , 154 , 88 , 90 , 216 , 218 , 56 , 58 , 184 , 186 , 120 , 122 , 248 , 250
Data 4 , 6 , 132 , 134 , 68 , 70 , 196 , 198 , 36 , 38 , 164 , 166 , 100 , 102 , 228 , 230
Data 20 , 22 , 148 , 150 , 84 , 86 , 212 , 214 , 52 , 54 , 180 , 182 , 116 , 118 , 244 , 246
Data 12 , 14 , 140 , 142 , 76 , 78 , 204 , 206 , 44 , 46 , 172 , 174 , 108 , 110 , 236 , 238
Data 28 , 30 , 156 , 158 , 92 , 94 , 220 , 222 , 60 , 62 , 188 , 190 , 124 , 126 , 252 , 254
Data 1 , 3 , 129 , 131 , 65 , 67 , 193 , 195 , 33 , 35 , 161 , 163 , 97 , 99 , 225 , 227
Data 17 , 19 , 145 , 147 , 81 , 83 , 209 , 211 , 49 , 51 , 177 , 179 , 113 , 115 , 241 , 243
Data 9 , 11 , 137 , 139 , 73 , 75 , 201 , 203 , 41 , 43 , 169 , 171 , 105 , 107 , 233 , 235
Data 25 , 27 , 153 , 155 , 89 , 91 , 217 , 219 , 57 , 59 , 185 , 187 , 121 , 123 , 249 , 251
Data 5 , 7 , 133 , 135 , 69 , 71 , 197 , 199 , 37 , 39 , 165 , 167 , 101 , 103 , 229 , 231
Data 21 , 23 , 149 , 151 , 85 , 87 , 213 , 215 , 53 , 55 , 181 , 183 , 117 , 119 , 245 , 247
Data 13 , 15 , 141 , 143 , 77 , 79 , 205 , 207 , 45 , 47 , 173 , 175 , 109 , 111 , 237 , 239
Data 29 , 31 , 157 , 159 , 93 , 95 , 221 , 223 , 61 , 63 , 189 , 191 , 125 , 127 , 253 , 255
'-------------------------------------------------------------------------------------------------------------------
Data 0 , 1 , 128 , 129 , 64 , 65 , 192 , 193 , 32 , 33 , 160 , 161 , 96 , 97 , 224 , 225       'Anf adr.1792 Dec
Data 16 , 17 , 144 , 145 , 80 , 81 , 208 , 209 , 48 , 49 , 176 , 177 , 112 , 113 , 240 , 241
Data 8 , 9 , 136 , 137 , 72 , 73 , 200 , 201 , 40 , 41 , 168 , 169 , 104 , 105 , 232 , 233
Data 24 , 25 , 152 , 153 , 88 , 89 , 216 , 217 , 56 , 57 , 184 , 185 , 120 , 121 , 248 , 249
Data 4 , 5 , 132 , 133 , 68 , 69 , 196 , 197 , 36 , 37 , 164 , 165 , 100 , 101 , 228 , 229
Data 20 , 21 , 148 , 149 , 84 , 85 , 212 , 213 , 52 , 53 , 180 , 181 , 116 , 117 , 244 , 245
Data 12 , 13 , 140 , 141 , 76 , 77 , 204 , 205 , 44 , 45 , 172 , 173 , 108 , 109 , 236 , 237
Data 28 , 29 , 156 , 157 , 92 , 93 , 220 , 221 , 60 , 61 , 188 , 189 , 124 , 125 , 252 , 253
Data 2 , 3 , 130 , 131 , 66 , 67 , 194 , 195 , 34 , 35 , 162 , 163 , 98 , 99 , 226 , 227
Data 18 , 19 , 146 , 147 , 82 , 83 , 210 , 211 , 50 , 51 , 178 , 179 , 114 , 115 , 242 , 243
Data 10 , 11 , 138 , 139 , 74 , 75 , 202 , 203 , 42 , 43 , 170 , 171 , 106 , 107 , 234 , 235
Data 26 , 27 , 154 , 155 , 90 , 91 , 218 , 219 , 58 , 59 , 186 , 187 , 122 , 123 , 250 , 251
Data 6 , 7 , 134 , 135 , 70 , 71 , 198 , 199 , 38 , 39 , 166 , 167 , 102 , 103 , 230 , 231
Data 22 , 23 , 150 , 151 , 86 , 87 , 214 , 215 , 54 , 55 , 182 , 183 , 118 , 119 , 246 , 247
Data 14 , 15 , 142 , 143 , 78 , 79 , 206 , 207 , 46 , 47 , 174 , 175 , 110 , 111 , 238 , 239
Data 30 , 31 , 158 , 159 , 94 , 95 , 222 , 223 , 62 , 63 , 190 , 191 , 126 , 127 , 254 , 255

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  'Wn                                                                               'Anf Adr:   2048=800hex
Data 0 , 64 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0       '                  'Dec  2048
Data 0 , 32 , 64 , 96 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0       '                'Dec  2064
Data 0 , 16 , 32 , 48 , 64 , 80 , 96 , 112 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0       '           'Dec  2080
Data 0 , 8 , 16 , 24 , 32 , 40 , 48 , 56 , 64 , 72 , 80 , 88 , 96 , 104 , 112 , 120       '  'Dec  2096
Data 0 , 4 , 8 , 12 , 16 , 20 , 24 , 28 , 32 , 36 , 40 , 44 , 48 , 52 , 56 , 60       '      'Dec  2112
Data 64 , 68 , 72 , 76 , 80 , 84 , 88 , 92 , 96 , 100 , 104 , 108 , 112 , 116 , 120 , 124
Data 0 , 2 , 4 , 6 , 8 , 10 , 12 , 14 , 16 , 18 , 20 , 22 , 24 , 26 , 28 , 30       '        'Dec  2144
Data 32 , 34 , 36 , 38 , 40 , 42 , 44 , 46 , 48 , 50 , 52 , 54 , 56 , 58 , 60 , 62
Data 64 , 66 , 68 , 70 , 72 , 74 , 76 , 78 , 80 , 82 , 84 , 86 , 88 , 90 , 92 , 94
Data 96 , 98 , 100 , 102 , 104 , 106 , 108 , 110 , 112 , 114 , 116 , 118 , 120 , 122 , 124 , 126
Data 0 , 1 , 2 , 3 , 4 , 5 , 6 , 7 , 8 , 9 , 10 , 11 , 12 , 13 , 14 , 15       ' '           'Dec 2208
Data 16 , 17 , 18 , 19 , 20 , 21 , 22 , 23 , 24 , 25 , 26 , 27 , 28 , 29 , 30 , 31
Data 32 , 33 , 34 , 35 , 36 , 37 , 38 , 39 , 40 , 41 , 42 , 43 , 44 , 45 , 46 , 47
Data 48 , 49 , 50 , 51 , 52 , 53 , 54 , 55 , 56 , 57 , 58 , 59 , 60 , 61 , 62 , 63
Data 64 , 65 , 66 , 67 , 68 , 69 , 70 , 71 , 72 , 73 , 74 , 75 , 76 , 77 , 78 , 79
Data 80 , 81 , 82 , 83 , 84 , 85 , 86 , 87 , 88 , 89 , 90 , 91 , 92 , 93 , 94 , 95
Data 96 , 97 , 98 , 99 , 100 , 101 , 102 , 103 , 104 , 105 , 106 , 107 , 108 , 109 , 110 , 111
Data 112 , 113 , 114 , 115 , 116 , 117 , 118 , 119 , 120 , 121 , 122 , 123 , 124 , 125 , 126 , 127

'------------------------------------------------------------------------------------------------------------------


