/*
  Copyright (C) 2004 Pavel Lajsner <ok2ucx@qsl.net>.

  This file is part of the Weather station system.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  $File Name        : voicesynth.h$
  $Date             : Feb-25-2004$
  $Version          : 1.1.5.0$ 
  $Last Modified By : r30323$

*/

#ifndef __VOICESYNTH_H
#define __VOICESYNTH_H

#include "map.h"

#define abs(x)   ((x) >= 0 ? (x) : -(x))

/****************************************************/

#define LANGUAGE	0
#define REVISION	10

/****************************************************/

typedef enum {
  _CELA	,
  _CELE	,
  _CELSIA	,
  _CELYCH	,
  _CTRNACT	,
  _CTYRI	,
  _CTYRICET	,
  _DESET	,
  _DESETIN	,
  _DESETINA	,
  _DESETINY	,
  _DEVADESAT	,
  _DEVATENACT	,
  _DEVET	,
  _DVA	,
  _DVACET	,
  _DVANACT	,
  _DVE	,
  _DVESTE	,
  _HPASCAL	,
  _HPASCALU	,
  _HPASCALUU	,
  _HPASCALY	,
  _JE	,
  _JEDEN	,
  _JEDENACT	,
  _JEDNA	,
  _JEDNO	,
  _JIH	,
  _METR	,
  _METRU	,
  _METRUU	,
  _METRY	,
  _MINUS	,
  _NULA	,
  _OSM	,
  _OSMDESAT	,
  _OSMNACT	,
  _PADESAT	,
  _PATNACT	,
  _PET	,
  _PLUS	,
  _PROCENT	,
  _PROCENTA	,
  _PROCENTO	,
  _RYCHLOST	,
  _SEDESAT	,
  _SEDM	,
  _SEDMDESAT	,
  _SEDMNACT	,
  _SEKUNDU	,
  _SEST	,
  _SESTNACT	,
  _SET	,
  _SEVER	,
  _SMER	,
  _STA	,
  _STE	,
  _STO	,
  _STUPEN	,
  _STUPNE	,
  _STUPNU	,
  _TEPLOTA	,
  _TISIC	,
  _TISICE	,
  _TLAK	,
  _TRI	,
  _TRICET	,
  _TRINACT	,
  _VETRU	,
  _VLHKOST	,
  _VYCHOD	,
  _ZA	,
  _ZAPAD,
  _VOLT,		
  _VOLTU,
  _VOLTUU,
  _VOLTY,
  _AMPER,
  _AMPERU,
  _AMPERUU,
  _AMPERY,
  _OHM,
  _OHMU,
  _OHMUU,
  _OHMY,
  _A		
} WAVINDEX;



typedef enum {M, F, N, TGENDERCOUNT} TGender;

typedef enum {
                ONE,
                TWO,
                POINT,
                TWORDCOUNT
             } TWord;

typedef enum {
                METER,
                HECTOPASCAL,
                DEGREE,
                PERCENT,
                DECIMAL,
                VOLTAGE,
                CURRENT,
                RESISTANCE,
                TQUANCOUNT
             } TQuan;


typedef enum {
                CASEONE,    /* 1 */
                CASETWO,    /* 2,3,4 */
                CASEMORE,   /* 0,5,6 ... */
                CASEDEG,    /* decimal */
                TCASECOUNT
             } TCase;

#pragma CONST_SEG CONST_ROM

const WAVINDEX OnesLookUp[];

const WAVINDEX TensLookUp[];

extern const WAVINDEX GenderLookUp[/*TWord*/TWORDCOUNT][/*TGender*/TGENDERCOUNT];

extern const WAVINDEX CaseLookUp[/*TQuan*/TQUANCOUNT][/*TCase*/TCASECOUNT];

extern const TGender Gender[TQUANCOUNT];

#pragma CONST_SEG DEFAULT
        
extern void TellThousand(unsigned int num);
extern void TellHundred(unsigned char num);
extern void Tell10(unsigned char num);
extern void Tell1(unsigned char num, TGender Gender);
extern void TellTable(WAVINDEX index);
extern void TellNum(int num, TGender Gender);
extern void TellNumDecQua(int num, TQuan Quantity);
extern void TellNumQua(int num, TQuan Quantity);
extern void TellDecimal(unsigned char num);
extern void TellPoint(unsigned int num);
extern void TellQuantity(int num, TQuan Quantity);
extern void TellTemp(signed int value);
extern void TellPress(unsigned int value);
extern void TellHumid(unsigned char value);
extern void TellWindS(unsigned char value);
extern void TellWindD(unsigned int value);
extern void TellTempU(signed int value);

#endif