/*
  Copyright (C) 2004 Pavel Lajsner <ok2ucx@qsl.net>.

  This file is part of the Weather station system.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  $File Name        : voicesynth-en.h$
  $Date             : Feb-25-2004$
  $Version          : 1.1.7.0$ 
  $Last Modified By : r30323$

*/

#ifndef __VOICESYNTH_H
#define __VOICESYNTH_H

#include "map.h"

#define abs(x)   ((x) >= 0 ? (x) : -(x))

/****************************************************/

#define LANGUAGE	1
#define REVISION	1

/****************************************************/

typedef enum {
  _POINT	,
  __NA01	,
  _OFCELSIUS,
  __NA03	,
  _FOURTEEN	,
  _FOUR	,
  _FORTY	,
  _TEN	,
  __NA08	,
  __NA09	,
  __NA10	,
  _NINETY	,
  _NINETEEN	,
  _NINE	,
  _TWO	,
  _TWENTY	,
  _TWELVE	,
  __NA17	,
  __NA18	,
  _HPASCAL	,
  __NA20	,
  __NA21	,
  __NA22	,
  _IS	,
  _ONE	,
  _ELEVEN	,
  __NA26	,
  __NA27	,
  _SOUTH	,
  _METER	,
  __NA30	,
  _METERS	,
  __NA32	,
  _MINUS	,
  _ZERO	,
  _EIGHT	,
  _EIGHTY	,
  _EIGHTEEN	,
  _FIFTY	,
  _FIFTEEN	,
  _FIVE	,
  _PLUS	,
  _PERCENT	,
  __NA43	,
  __NA44	,
  _SPEED	,
  _SIXTY	,
  _SEVEN	,
  _SEVENTY	,
  _SEVENTEEN	,
  _SECOND	,
  _SIX	,
  _SIXTEEN	,
  __NA53	,
  _NORTH	,
  _DIRECTION	,
  __NA56	,
  __NA57	,
  _HUNDRED	,
  _DEGREE	,
  __NA60	,
  _DEGREES	,
  _TEMPERATURE	,
  _THOUSAND	,
  __NA64	,
  _PRESSURE	,
  _THREE	,
  _THIRTY	,
  _THIRTEEN	,
  _WIND	,
  _HUMIDITY	,
  _EAST	,
  _PER	,
  _WEST,
  _VOLT,
  _VOLTS,
  _NA76,
  _NA77, 
  _AMPER,
  _AMPERS,
  _NA80,
  _NA81, 
  _OHM,
  _OHMS,
  _NA84,
  _NA85, 
  _AND
} WAVINDEX;



typedef enum {
                ONE,
                TWO,
                POINT,
                TWORDCOUNT
             } TWord;

typedef enum {
                METER,
                HECTOPASCAL,
                DEGREE,
                PERCENT,
                VOLTAGE,
                CURRENT,
                RESISTANCE,
                TQUANCOUNT
             } TQuan;


typedef enum {
                CASEONE,    /* 1 */
                CASEMORE,   /* more ... */
                TCASECOUNT
             } TCase;

#pragma CONST_SEG CONST_ROM

const WAVINDEX OnesLookUp[];

const WAVINDEX TensLookUp[];

extern const WAVINDEX CaseLookUp[/*TQuan*/TQUANCOUNT][/*TCase*/TCASECOUNT];

#pragma CONST_SEG DEFAULT
        
extern void TellThousand(unsigned int num);
extern void TellHundred(unsigned char num);
extern void Tell10(unsigned char num);
extern void Tell1(unsigned char num);
extern void TellTable(WAVINDEX index);
extern void TellNum(int num);
extern void TellNumDecQua(int num, TQuan Quantity);
extern void TellNumQua(int num, TQuan Quantity);
extern void TellDecimal(unsigned char num);
extern void TellPoint(unsigned int num);
extern void TellQuantity(int num, TQuan Quantity);
extern void TellTemp(signed int value);
extern void TellPress(unsigned int value);
extern void TellHumid(unsigned char value);
extern void TellWindS(unsigned char value);
extern void TellWindD(unsigned int value);
extern void TellTempU(signed int value);

#endif