/*
  Copyright (C) 2004 Pavel Lajsner <ok2ucx@qsl.net>.

  This file is part of the Weather station system.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  $File Name        : voicesynth-en.c$
  $Date             : Feb-27-2004$
  $Version          : 1.1.6.0$ 
  $Last Modified By : r30323$

*/

#include "VoiceSynth-en.h"
#include "voice.h"

#pragma CONST_SEG CONST_ROM

const WAVINDEX OnesLookUp[]=
{
  _ZERO,
  _ONE,
  _TWO,
  _THREE,
  _FOUR,
  _FIVE,
  _SIX,
  _SEVEN,
  _EIGHT,
  _NINE,
  _TEN,
  _ELEVEN,
  _TWELVE,
  _THIRTEEN,
  _FOURTEEN,
  _FIFTEEN,
  _SIXTEEN,
  _SEVENTEEN,
  _EIGHTEEN,
  _NINETEEN
};

const WAVINDEX TensLookUp[]=
{
  _TWENTY,
  _THIRTY,
  _FORTY,
  _FIFTY,
  _SIXTY,
  _SEVENTY,
  _EIGHTY,
  _NINETY,
};

const WAVINDEX CaseLookUp[/*TQuan*/TQUANCOUNT][/*TCase*/TCASECOUNT]=
{
        {_METER,   _METERS},   /* METER */       /* 1 metr, 2 or more meters */
        {_HPASCAL, _HPASCAL},  /* HEKTOPASCAL */ /* 1 hPascal, 2 or more hPascals */
        {_DEGREE,  _DEGREES},  /* DEGREE */      /* 1 degree, 2 or more degrees */
        {_PERCENT, _PERCENT},  /* PERCENT */     /* 1, 2 or more percent */
        {_VOLT,	   _VOLTS},    /* VOLTAGE */     /* 1 volt, 2 or more volts */
        {_AMPER,   _AMPERS},   /* CURRENT */     /* 1 amper, 2 or more ampers */
        {_OHM, 	   _OHMS}      /* RESISTANCE */  /* 1 ohm, 2 or more ohms */
};

#pragma CONST_SEG DEFAULT


void TellQuantity(int num, TQuan Quantity)
{
  if (num == 1)
  { TellTable(CaseLookUp[Quantity][CASEONE]); }
  else
  { TellTable(CaseLookUp[Quantity][CASEMORE]); };
}


void TellNum(int num)
// num -999.999 ... 0 ... 999.999
// or -32768 .. 0 .. 32767
{

//  if ((num > 999999) || (num < -999999))
//    return; //just discard any numbers above 9999999

  if (num < 0)
  { 
    TellTable(_MINUS);
    num = -num;
  }  
  else 
  {/*Tell(PLUS)*/};

// num here is always positive (or zero)

  if (num == 0)
  {
    Tell1(0);   // explicitly tell "zero" if it's zero
    return;
  };

  if (num >= 1000)
  {
    TellNum(num / 1000);   // tell how many thousands 2,3 ... 999
    TellThousand(num / 1000);  // tell "thousand(s)" word correctly
    num %= 1000;
  };

// num here is always below 1000

  if ((unsigned int)num >= 100)
  {
    TellNum((unsigned int)(num / 100));   // tell how many hundreds
    TellHundred((unsigned char)(num / 100));  // tell "hundred(s)" word correctly
    num %= 100;
  };

// num here is always below 100

  if ((unsigned char)num >= 20)
  {
    Tell10((unsigned char)num); // tell 20, 30, 40 ...
    if ((unsigned char)(num % 10) != 0)
    {
      Tell1((unsigned char)(num % 10));         // tell 1,2,3 ... 
    }
    else
    { 
      /* DON'T SAY ZERO AFTER 20, 30, 40 ... */
    };
  }
  else
  {
    if ((unsigned char)num > 0)
    {
      Tell1((unsigned char)num);           // tell 1,2 .. 19 
    }
    else
    {
      /* Don't say "ZERO" in xxx0 like numbers */
    }
  }
}

void TellNumDecQua(int num, TQuan Quantity)
{ /* num is int, e.g. 142.4 comes as 1424 */
  if (!(abs(num) % 10)) // decimals ARE 0, tell ONLY INT
  {
    TellNumQua(num / 10, Quantity);	/* tell it as without decimal point */
  }
  else
  {
    if (num < 0)
    { 
      TellTable(_MINUS);
      num = -num;
    }  
    TellNum(num / 10);	/* the part before decimal point is always male */
    TellPoint(num / 10);     /* tell decimal point the right way */
    Tell1((unsigned char)(num % 10));   /* tell decimal part of num */
    TellDecimal((unsigned char)(num % 10));                /* tell "decimals" */
    TellTable(CaseLookUp[Quantity][CASEMORE]);  /* tell quantity the right way*/
  }
}

void TellNumQua(int num, TQuan Quantity)
{
  TellNum(num);
  TellQuantity(num, Quantity);
}

void TellDecimal(unsigned char num)
// num 0..9 (19)
{
	/* simply don't say anything in English ;-) */
}

void TellPoint(unsigned int num)
// num is int 0 ... maxint
{
  TellTable(_POINT);
}

void TellThousand(unsigned int num)
// num 0...999 (?)
{
  TellTable(_THOUSAND);
}

void TellHundred(unsigned char num)
// num 1..9 (19)
{
  TellTable(_HUNDRED);
}

void Tell10(unsigned char num)
// num 20, 30, 40 ... (but num could be like 24!)
{
  TellTable(TensLookUp[(unsigned char)(num - 20) / 10]);
}

void Tell1(unsigned char num)
// num 0 .. 19
{
   TellTable(OnesLookUp[num]);
}

void TellTemp(signed int value)
{
  if (Valid.Temperature == YES)
  {
    Pause(PAUSE250MS);
    TellTable(_TEMPERATURE);
    TellNumDecQua(value, DEGREE);
    TellTable(_OFCELSIUS);
    Pause(PAUSE250MS);
  }
}

void TellPress(unsigned int value)
{
  if (Valid.Pressure == YES)
  {
    Pause(PAUSE250MS);
    TellTable(_PRESSURE);
    TellNumDecQua(value, HECTOPASCAL);
    Pause(PAUSE250MS);
  }
}

void TellHumid(unsigned char value)
{
  if (Valid.Humidity == YES)
  {
    Pause(PAUSE250MS);
    TellTable(_HUMIDITY);
    TellNumQua(value, PERCENT);
    Pause(PAUSE250MS);
  }
}

void TellWindS(unsigned char value)
{
  if (Valid.WindSpeed == YES)
  {
    Pause(PAUSE250MS);
    TellTable(_WIND);TellTable(_SPEED);
    TellNumQua(value, METER);
    TellTable(_PER); TellTable(_SECOND);
    Pause(PAUSE250MS);
  }
}

void TellWindD(unsigned int value)
{
  if (Valid.WindDir == YES)
  {
    Pause(PAUSE250MS);
    TellTable(_WIND);TellTable(_DIRECTION);
    TellNumQua(value, DEGREE);
    Pause(PAUSE250MS);
  }
}

void TellTempU(signed int value)
{
    Pause(PAUSE250MS);
    TellTable(_TEMPERATURE);
    TellNumDecQua(value, DEGREE);
    TellTable(_OFCELSIUS);
    Pause(PAUSE250MS);
}


