/*
  Copyright (C) 2004 Pavel Lajsner <ok2ucx@qsl.net>.

  This file is part of the Weather station system.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  $File Name        : voicesynth-de.h$
  $Date             : Jan-18-2005$
  $Version          : 1.1.2.0$ 
  $Last Modified By : r30323$

*/

#ifndef __VOICESYNTH_H
#define __VOICESYNTH_H

#include "map.h"

#define abs(x)   ((x) >= 0 ? (x) : -(x))

/****************************************************/

#define LANGUAGE	DE
#define REVISION	1

/****************************************************/

typedef enum {
  _NULL,
  _EINS,
  _ZWEI,
  _DREI,
  _VIER,
  _FUNF,
  _SECHS,
  _SIEBEN,
  _ACHT,
  _NEUN,
  _ZEHN,
  _ELF,
  _ZWOELF,
  _DREIZEHN,
  _VIERZEHN,
  _FUNFZEHN,
  _SECHSZEHN,
  _SIEBZEHN,
  _ACHTZEHN,
  _NEUNZEHN,
  _ZWANZIG,
  _DREISSIG,
  _VIERZIG,
  _FUNFZIG,
  _SECHZIG,
  _SIEBZIG,
  _ACHTZIG,
  _NEUNZIG,
  _HUNDERT,
  _TAUSEND,
  _PLUS,
  _MINUS,
  _KOMMA,
  _UND,
  _RICHTUNG,
  _NORDER,
  _OSTEN,
  _SUEDEN,
  _WESTEN,
  _WIND,
  _GESWCHINDIGKEIT,
  _PRO,
  _METER,
  _SEKUNDE,
  _STUNDE,
  _FEUCHTIGKEIT,
  _PROZENT,
  _TEMPERATUR,
  _GRAD,
  _LUFTDRUCK,
  _HEKTOPASCAL,
  _AMPER,
  _VOLT,
  _OHM
} WAVINDEX;


typedef enum {
                METER,
                HECTOPASCAL,
                DEGREE,
                PERCENT,
                VOLTAGE,
                CURRENT,
                RESISTANCE,
                TQUANCOUNT
             } TQuan;


#pragma CONST_SEG CONST_ROM

const WAVINDEX OnesLookUp[];

const WAVINDEX TensLookUp[];

extern const WAVINDEX CaseLookUp[/*TQuan*/TQUANCOUNT];

#pragma CONST_SEG DEFAULT
        
extern void TellThousand(unsigned int num);
extern void TellHundred(unsigned char num);
extern void Tell10(unsigned char num);
extern void Tell1(unsigned char num);
extern void TellTable(WAVINDEX index);
extern void TellNum(int num);
extern void TellNumDecQua(int num, TQuan Quantity);
extern void TellNumQua(int num, TQuan Quantity);
extern void TellDecimal(unsigned char num);
extern void TellPoint(unsigned int num);
extern void TellQuantity(int num, TQuan Quantity);
extern void TellTemp(signed int value);
extern void TellPress(unsigned int value);
extern void TellHumid(unsigned char value);
extern void TellWindS(unsigned char value);
extern void TellWindD(unsigned int value);
extern void TellTempU(signed int value);

#endif