/*
  Copyright (C) 2004 Pavel Lajsner <ok2ucx@qsl.net>.

  This file is part of the Weather station system.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  $File Name        : termio08.c$
  $Date             : Feb-27-2004$
  $Version          : 1.1.4.0$ 
  $Last Modified By : r30323$

*/

#include "termio08.h"
#include "voice.h"

#pragma DATA_SEG SHORT _DATA_ZEROPAGE
#define FIFO databuff
//BYTE FIFO[FIFOLEN];
BYTE FIFOTail = 0, FIFOHead = 0, FIFOFlag = NO, GetPtr;
#pragma DATA_SEG DEFAULT

BYTE IsNum(BYTE ch)
{
  if ((ch >= '0') && (ch <= '9'))
    return(1);
  else
    return(0);
}  

int TERM_GetInt(void)
{
  BYTE ch;
  int retval = 0;
  char neg = 0;

  for (;;)
  {
    ch = FIFO[GetPtr++];
    if (IsNum(ch))
    {
      retval = 10 * retval + (ch - '0');
    }
    else
    if (ch == '-')
    {
      neg = 1;
    }
    else
    if ((ch == '.') || (ch == ' '))
    {
      /* just ignore any decimal point or blank space */
    }
    else
      break;
  }
  
  if ((neg == 1) && (retval == 0))
  { Sys.SCIValue = NO; }
  else
  { Sys.SCIValue = YES; }
  
  return(((neg == 0) ? retval : -retval));  
} 

void FIFOPut(char ch)
{
//  FIFO[FIFOHead] = ch;
//  FIFOHead = (FIFOHead + 1)&(FIFOLEN-1);

//  return;

  if ((ch == HEAD) && (Sys.FIFOBusy == NO))    // if HEAD char comes and FIFO is not busy
  {
    Sys.FIFOBusy = YES;   // cleared when FIFO serviced
    FIFOHead = 0;     // init FIFO pointer
    return ;
  }

  if ((Sys.FIFOBusy == YES) && (Sys.FIFOFlag == NO)) // only if writing to FIFO & ready flag not set!
  {

    FIFO[FIFOHead] = ch;              // store to FIFO

    if ((ch == TAIL1) || (ch == TAIL2))                   // end  TAIL char comes
      Sys.FIFOFlag = YES;                 // is cleared also when FIFO serviced

    if (++FIFOHead >= FIFOLEN)
      Sys.FIFOBusy = NO;              // ignore buffer if overfull

  }
}
//        abcdef <HEAD> 10,20,30,40,50,60 <TAIL>  70,80 <HEAD> 90,100 <TAIL> <HEAD> 110,120,130 <TAIL>
//  FBusy 000000   1    11111111111111111   1     1111111111111100000   0      1    11111111111   1 ...
//  FIFO                10,20,30,40,50,60 <TAIL>  ..processing..                    110,120,130 <TAIL>
//  FFlag 000000   0    00000000000000000   1     1111111111111100000   0      0    00000000000   1 ...
//
//


char FIFOGet(void)
{
  if (FIFOTail == FIFOHead)         // queue empty?
  {
    FIFOFlag = NO;                   // no more chars in FIFO
    return (NOCHAR);
  }
  else
  {
    char retval;
    
    retval = FIFO[FIFOTail];        // get the oldest FIFO value
    FIFOTail = (FIFOTail+1)&(FIFOLEN-1);

    if (FIFOTail == FIFOHead)         // queue empty?
      FIFOFlag = NO;                   // no more chars in FIFO

    return(retval);
  }
}
