/*
  Copyright (C) 2004 Pavel Lajsner <ok2ucx@qsl.net>.

  This file is part of the Weather station system.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  $File Name        : onewire.h$
  $Date             : May-5-2006$
  $Version          : 1.1.7.0$ 
  $Last Modified By : r30323$

*/

#define LOW 0
#define HIGH 1
#define WIREPIN PTA1
#define WIREDDR  DDRA_BIT1
#define WIREPUE  PTAPUE_BIT1

#define WireLow() {WIREPIN = LOW; WIREDDR = 1;}
#define WireHigh() {WIREPIN = HIGH; WIREDDR = 0;}
#define WireStrong() {WIREPIN = HIGH; WIREDDR = 1;}

#define Wait1us() {asm nop;asm nop;asm nop;}

#define US(N) (N-3)

#define RES 10 /* final resolution */

#define ERR_OK				       0
#define ERR_WIRE_NOT_PRESENT_ADDR  1
#define ERR_WIRE_NOT_PRESENT_DATA  2

#define ERR_ONE_WIRE_ERROR  32767

extern void Wait_us(char n);
extern void Wire_send(char ch);
extern char Wire_recv_bit(void);
extern char Wire_recv(void);
extern char Wire_present(void);
extern int OneWire(void /*char *errcode*/);

#pragma DATA_SEG SHORT _DATA_ZEROPAGE

extern int temperature;
#pragma DATA_SEG DEFAULT
