/*
  Copyright (C) 2004 Pavel Lajsner <ok2ucx@qsl.net>.

  This file is part of the Weather station system.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  $File Name        : onewire.c$
  $Date             : May-5-2006$
  $Version          : 1.1.10.0$ 
  $Last Modified By : r30323$

*/

#include "map.h"
#include "voice.h"
#include "onewire.h"

void Wait_us(char n)
{	
	// LDA #n 			[2]
	// JSA/BSR Wait_us	[4]
	// DBNZA 			[3*n]
	// RTS				[4]
	// total: 10+3*n  n=1 <-> 4us   n=2 <-> 5us
	asm
	{
		waitloop: dbnza waitloop
	}
}

void Wire_send(char ch)
{
    char i;

	for (i=8; i>0; i--)
	{
		if (ch & 0x01)
		{
			WireLow();
			Wait_us(US(10));
			WireHigh();
			Wait_us(US(110));
		}
		else
		{
			WireLow();
			Wait_us(US(110));
			WireHigh();
			Wait_us(US(10));
		}
		ch >>= 1;		
	}	
}

char Wire_recv_bit(void)
{
    char tmp;

	Wait_us(US(5));
	WireLow();
	Wait1us();
	WireHigh();
	tmp = WIREPIN;
	Wait_us(US(110));
	return (tmp);
}

char Wire_recv(void)
{
    char i, retval = 0;

	for (i=8; i>0; i--)
	{
		retval >>= 1;
		if (Wire_recv_bit())
			retval |= 0x80;
	}
	return retval;	
}

char Wire_present(void)
{
    COPCTL = 0;
    WIREPIN = 1;        // 1wire pin high
	Wait_us(US(200));   // wait a little to power up 1wire
	WIREPUE = 1;        // 1wire pullup on
	WIREDDR = 0;        // 1wire pin in

	Wait_us(US(200));
	Wait_us(US(200));
	Wait_us(US(200));

    COPCTL = 0;
	WireLow();	
	Wait_us(US(200));
	Wait_us(US(200));
	Wait_us(US(200));

    COPCTL = 0;
	WireHigh();
	Wait_us(US(100));
	return (!WIREPIN);
}

Thiloword temp;
char cnttot, cntrem;

int OneWire(void)
{
int uscnt;

	if(Wire_present())
	{
    COPCTL = 0;
		Wait_us(US(200));
		Wire_send(0xCC);
		Wire_send(0x44);

		WireStrong();

		for (uscnt = 750*5; uscnt > 0; uscnt--) 
		{
			Wait_us(US(200));
		  COPCTL = 0;
		}

		WireHigh();

		if(Wire_present())
		{
      COPCTL = 0;
			Wait_us(US(200));
			Wire_send(0xCC);
			Wire_send(0xBE);

	    COPCTL = 0;
  		temp.b.lo = Wire_recv();
			temp.b.hi = Wire_recv();
			(void) Wire_recv();
			(void) Wire_recv();
			(void) Wire_recv();
			(void) Wire_recv();
			cntrem = Wire_recv();
			cnttot = Wire_recv();

		  return (RES*(4*(((int)(temp.word & 0xFFFE))/2) - 1)/4 + RES*(cnttot-cntrem)/cnttot);
		}
	}

	return ERR_ONE_WIRE_ERROR;
}

