/*
  Copyright (C) 2004 Pavel Lajsner <ok2ucx@qsl.net>.

  This file is part of the Weather station system.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  $File Name        : Voice.h$
  $Date             : Feb-27-2004$
  $Version          : 1.1.8.0$ 
  $Last Modified By : r30323$

*/

#define CZ 1
#define EN 2
#define DE 3


#include "map.h" 
#ifdef LANG
	#if   LANG==CZ /* czech */
	#include "voicesynth.h"
	#elif LANG==EN /* english */
	#include "voicesynth-en.h"
	#elif LANG==DE /* deutsch */
	#include "voicesynth-de.h"
	#else
	#error "Unknown language version!"
	#endif
#else
	#error "Language version not defined!"
#endif

typedef unsigned char BYTE;
typedef unsigned int UINT;

typedef struct _B {
  UINT FIFOBusy:1;
  UINT FIFOFlag:1;
  UINT SampleBusy:1;
  UINT PWMChan:1;
  UINT SCIValue:1;
} B;
  
typedef struct _V {
  UINT Pressure:1;
  UINT Temperature:1;
  UINT Humidity:1;
  UINT WindSpeed:1;
  UINT WindDir:1;
} V;

typedef union {
	struct 
	{
		unsigned char hi;
		unsigned char lo;
	} b;
	unsigned int word;
} Thiloword;

#define BUS_CLK_HZ 3200000L
#define PWM_HZ	   24000L
#define OCCNTVAL	3

#define PWM_SCALE	1		/* all samples are shifted by 1 for PWM */

#pragma DATA_SEG SHORT _DATA_ZEROPAGE

extern B Sys;
extern V Valid;
extern int Temperature;
extern unsigned char Sample, ch, OCCnt;
extern unsigned char databuff[42];


#pragma DATA_SEG DEFAULT

#define ACK 	0x00
#define QUIT 	'Q'
#define WRITE 	'W'
#define DATA  	'D'

#define ON 1
#define OFF 0

#define YES 1
#define NO 0

#define SI		PTA3	/* serial data out, IN to memory */
#define SO		PTA3	/* serial data in, OUT to memory */
#define SISODDR	DDRA_BIT3	/* SI/SO shared, this is DDR of the pin */
#define CS		PTA5	/* memory chip select, active low */
#define CSDDR	DDRA_BIT5	/* CS DDR */
#define SCK     PTA4	/* memory clock */
#define SCKDDR	DDRA_BIT4	/* SCK DDR */
#define PROG_PUE	PTAPUE_BIT2	/* PROG pull-up */
#define PROG		PTA2	/* PROG pin */
#define PTT		PROG_PUE	/* PROG pin serves also as PTT! */

#define Pause TellNBytesMuted
extern void TellNBytesMuted(unsigned int num);

#define PAUSE250MS  (PWM_HZ/OCCNTVAL/4)
#define PAUSE500MS  (2*PAUSE250MS)
#define PAUSE750MS  (3*PAUSE250MS)
#define PAUSE1000MS (4*PAUSE250MS)
