REM Exciter Beacon Compiler.

REM Generates and downloads scripts to the Exciter
REM Provides real time control and parameter storage

	DIM TABLE(96, 5)' Font array, 5 columns per character
	DIM MORSE(96)' Font array, Morse

REM Initialise font array
	RESTORE
	FOR i = 32 TO 127: FOR j = 1 TO 5: READ TABLE(i - 32, j): NEXT: NEXT
	FOR i = 32 TO 95: READ MORSE(i - 32): NEXT i

REM initialize variables
	mode% = 0

REM read parameters from file (same file as EXC)
	OPEN "EXC.SET" FOR INPUT AS #1
7        INPUT #1, PP$
	INPUT #1, bps$
	INPUT #1, clock
	INPUT #1, FREQ
	INPUT #1, power%
	CLOSE 1
	resolution = clock / 150994944
	limit = clock / 30

REM start port
	OPEN "com" + PP$ + ":" + bps$ + ",N,8,1,CS0,DS0" FOR RANDOM AS #1

REM function keys
	KEY(1) ON
	ON KEY(1) GOSUB KEY1
	KEY(2) ON
	ON KEY(2) GOSUB KEY2
	KEY(3) ON
	ON KEY(3) GOSUB KEY3
	KEY(4) ON
	ON KEY(4) GOSUB KEY4
	KEY(5) ON
	ON KEY(5) GOSUB KEY5
	KEY(6) ON
	ON KEY(6) GOSUB KEY6
	KEY(7) ON
	ON KEY(7) GOSUB KEY7
	KEY(8) ON
	ON KEY(8) GOSUB KEY8
	KEY(9) ON
	ON KEY(9) GOSUB KEY9
	KEY(10) ON
	ON KEY(10) GOSUB KEY10
	KEY(30) ON
	ON KEY(30) GOSUB KEY11
	KEY(31) ON
	ON KEY(31) GOSUB KEY12
	TIMER ON

REM Initialise display
NEWDISP:
	CLS
	COLOR 14
	LOCATE 1, 1: PRINT "LF Exciter Controller and Beacon Message Compiler";
	COLOR 13
	LOCATE 1, 65: PRINT "Connect to COM"; PP$
	COLOR 6
	LOCATE 3, 1: PRINT "Copyright (C) M. Greenman ZL1BPU 2002";
	COLOR 14
	LOCATE 3, 64: PRINT "Ŀ"
	LOCATE 4, 64: PRINT "Function Menu: ";
	LOCATE 5, 64: PRINT "Ĵ"
	COLOR 15
	LOCATE 6, 64: PRINT "R Report       ";
	LOCATE 7, 64: PRINT "S SAVE         ";
	LOCATE 8, 64: PRINT "I Send ID      ";
	LOCATE 9, 64: PRINT "H Help ESC Exit";
	LOCATE 10, 64: PRINT "Ĵ"
	LOCATE 11, 64: PRINT "F1  ASK        ";
	LOCATE 12, 64: PRINT "F2  FSK        ";
	LOCATE 13, 64: PRINT "F3  DFSK       ";
	LOCATE 14, 64: PRINT "F4  MFSK       ";
	LOCATE 15, 64: PRINT "F5  HELL       ";
	LOCATE 16, 64: PRINT "F6  FREQ       ";
	LOCATE 17, 64: PRINT "F7  SHIFT      ";
	LOCATE 18, 64: PRINT "F8  SPEED      ";
	LOCATE 19, 64: PRINT "F9  SCRIPT     ";
	LOCATE 20, 64: PRINT "F10 Beacon Off ";
	LOCATE 21, 64: PRINT "F11 TX ON      ";
	LOCATE 22, 64: PRINT "F12 TX OFF     ";
	LOCATE 23, 64: PRINT ""
	b = 23: c = 5
	ON TIMER(10) GOSUB RUBOUT
	ON ERROR GOTO ALLERR

REM main program stuff goes in here
DONOTHING:
	a$ = INKEY$
	IF a$ = CHR$(27) THEN END
	IF a$ = "S" OR a$ = "s" THEN
		PRINT #1, "S";
		LOCATE b, c
		PRINT "Data saved to Exciter.                               ";
	END IF
	IF a$ = "H" OR a$ = "h" THEN
		LOCATE 5, 1
		COLOR 7
		GOSUB HMSG1
		COLOR 15
		PRINT "Press a key to continue... ": PRINT
		a$ = INPUT$(1)
		COLOR 7
		GOSUB HMSG2
		COLOR 15
		PRINT "Press a key to continue... ": PRINT
		a$ = INPUT$(1)
		GOTO NEWDISP
	END IF
	IF a$ = "I" OR a$ = "i" THEN
		LOCATE b, c: PRINT SPACE$(50);
		LOCATE b, c: PRINT "Enter text:"
		LOCATE b, c + 15: INPUT message$
		FOR w = 1 TO LEN(message$)
			x = ASC(MID$(message$, w, 1))
			SPEED = .1
			GOSUB ASKSEND
		NEXT w
		LOCATE b, c: PRINT "ID message sent!                                       ";
	END IF
	IF a$ = "R" OR a$ = "r" THEN
		Report$ = ""
		PRINT #1, "R";
	END IF
	IF LOC(1) > 0 THEN
		Z$ = INPUT$(1, 1)
		IF ASC(Z$) < 32 THEN GOTO DONOTHING
		Report$ = Report$ + Z$
		COLOR 7
		LOCATE b + 1, c: PRINT RIGHT$(Report$, 70); SPACE$(5);
		COLOR 15
	END IF
	GOTO DONOTHING

RUBOUT:
	LOCATE b, 1: PRINT SPACE$(50);
	LOCATE b + 1, 1: PRINT SPACE$(78);
	RETURN
SCRIPT:
	CLS
	LOCATE 4, 10: PRINT "Source File Name: ................";
	LOCATE 4, 50: PRINT "(Press ENTER to exit)"
	COLOR 15
	LOCATE 4, 28: INPUT SF$
	IF SF$ = "" THEN END
	message$ = "B"

	OPEN SF$ FOR INPUT AS #2
	PRINT
	PRINT "Reading file... ": PRINT

RLOOP:
		IF EOF(2) THEN GOTO SLOOP
		a$ = INPUT$(1, #2)
		IF a$ = "~" THEN
			message$ = message$ + "FF" + a$
			PRINT a$ + "FF"
			a$ = CHR$(10)
		END IF
REM                IF ASC(A$) = 13 THEN A$ = " ": PRINT
		IF ASC(a$) < 32 THEN GOTO RLOOP
		IF a$ = "$" THEN GOSUB COMMAND: GOTO RLOOP
		H$ = RIGHT$("0000" + HEX$(MORSE(ASC(a$) - 32)), 2)
		PRINT a$;
		message$ = message$ + H$
		GOTO RLOOP
	       
SLOOP:

	CLOSE 2
	PRINT
	IF LEN(message$) > 120 THEN
		PRINT "Sorry, file is"; LEN(message$) - 120; "too long!"
		PRINT "Max 120 characters allowed."
		GOTO NOMSG
	END IF
	PRINT "Sending file... ": PRINT
MSGSEND:
	FOR i = 1 TO LEN(message$)
		PRINT MID$(message$, i, 1);
		PRINT #1, MID$(message$, i, 1);
		FOR j = 1 TO 50000: NEXT j
	NEXT i
NOMSG:
	PRINT
	PRINT
	PRINT "Press ESC to continue... ": PRINT
ALL:
	a$ = INKEY$
	IF a$ = CHR$(27) THEN GOTO NEWDISP
	GOTO ALL
	END



COMMAND:
	CMD$ = INPUT$(1, #2)
	IF CMD$ = "M" OR CMD$ = "m" THEN
		D$ = INPUT$(1, #2)
		COLOR 14: PRINT "MODE" + D$; : COLOR 15
		message$ = message$ + "F" + D$
	END IF
	IF CMD$ = "F" OR CMD$ = "f" THEN
		D$ = INPUT$(6, #2)
		COLOR 13: PRINT "FREQ" + D$; : COLOR 15
		message$ = message$ + "FC" + D$
	END IF
	IF CMD$ = "A" OR CMD$ = "a" THEN
		D$ = INPUT$(2, #2)
		COLOR 12: PRINT "SHIFT" + D$; : COLOR 15
		message$ = message$ + "FD" + D$
	END IF
	IF CMD$ = "K" OR CMD$ = "k" THEN
		D$ = INPUT$(4, #2)
		COLOR 11: PRINT "KEY" + D$; : COLOR 15
		message$ = message$ + "FE" + D$
	END IF

	RETURN

REM Function Keys

KEY1:
	PRINT #1, "M1";
	LOCATE b, c: PRINT "ASK Mode set!                                       ";
	RETURN
KEY2:
	PRINT #1, "M2";
	LOCATE b, c: PRINT "FSK Mode set!                                       ";
	RETURN
KEY3:
	PRINT #1, "M3";
	LOCATE b, c: PRINT "DFSK Mode set!                                       ";
	RETURN
KEY4:
	PRINT #1, "M4";
	LOCATE b, c: PRINT "MFSK Mode set!                                       ";
	RETURN
KEY5:
	PRINT #1, "M5";
	LOCATE b, c: PRINT "HELL Mode set!                                       ";
	RETURN
KEY6:
	LOCATE b, c: PRINT SPACE$(50);
	LOCATE b, c: PRINT "Enter frequency (Hz)"
	LOCATE b + 1, c: PRINT "(max "; : PRINT USING "######"; clock / 30;
	PRINT "Hz)                      ";
	LOCATE b, c + 30: INPUT FREQ
	H$ = "F" + RIGHT$("000000" + HEX$(FREQ / resolution), 6)
	PRINT #1, H$;
	LOCATE b, c: PRINT SPACE$(50);
	LOCATE b, c: PRINT "Frequency "; H$; " set!";
	RETURN
KEY7:
	LOCATE b, c: PRINT SPACE$(50);
	LOCATE b, c: PRINT "Enter shift (Hz)"
	LOCATE b + 1, c: PRINT "(max "; : PRINT USING "##"; 256 * resolution;
	PRINT "Hz)                          ";
	LOCATE b, c + 30: INPUT FREQ
	H$ = "A" + RIGHT$("000000" + HEX$(FREQ / resolution), 2)
	PRINT #1, H$;
	LOCATE b, c: PRINT SPACE$(50);
	LOCATE b, c: PRINT "Shift "; H$; " set!";
	RETURN
KEY8:
	LOCATE b, c: PRINT SPACE$(50);
	LOCATE b, c: PRINT "Enter dot length (sec)"
	LOCATE b + 1, c: PRINT "(max 1000 sec)                   ";
	LOCATE b, c + 30: INPUT FREQ
	H$ = "K" + RIGHT$("000000" + HEX$(FREQ * 64), 4)
	LOCATE b, c: PRINT SPACE$(50);
	PRINT #1, H$;
	LOCATE b, c: PRINT "Shift "; H$; " set!";
	RETURN
KEY9:
	GOSUB SCRIPT
	RETURN
KEY10:
	PRINT #1, "M0";
	LOCATE b, c: PRINT "Beacon Mode OFF!                                       ";
	RETURN
KEY11:
	PRINT #1, "T";
	LOCATE b, c: PRINT "TRANSMITTER ON!                                      "; ";"
	RETURN
KEY12:
	PRINT #1, "X";
	LOCATE b, c: PRINT "TRANSMITTER OFF!                                       ";
	RETURN

ASKSEND:
	IF x > 95 THEN x = x - 32' make upper case
	byte% = MORSE(x - 32)
ASK1:
	IF byte% < 2 THEN GOTO ASK2 'have run out of bits to send
	BIT = byte% MOD 2: byte% = INT(byte% / 2)'divides by 2 to shift right - carry into BIT
	IF BIT = 1 THEN
		PRINT #1, "T"; : GOSUB DELAY3'sends dash
		PRINT #1, "X"; : GOSUB delay1'sends interelement gap
	ELSE
		PRINT #1, "T"; : GOSUB delay1'sends dot
		PRINT #1, "X"; : GOSUB delay1'sends interelement gap
	END IF
	GOTO ASK1
ASK2:
	PRINT #1, "X"; : GOSUB DELAY3'sends interchar gap
	RETURN

' Modulator delays
delay1:
	DELAY = SPEED
	GOTO DELAY
DELAY3:
	DELAY = SPEED * 3
	GOTO DELAY
delay5:
	DELAY = SPEED / 2
DELAY:
	PAST = TIMER
DELAYA:
	present = TIMER
	IF present < PAST + DELAY THEN
		GOTO DELAYA
	END IF
	RETURN

HMSG1:
PRINT "DDS LF EXCITER CONTROL PROGRAM HELP"
PRINT
PRINT "This program offers three main functions:"
PRINT
PRINT "1. Real time control of the transmitter, turning it on, off,"
PRINT "   and sending an ID message. This allows you to tune and test"
PRINT "   the Exciter."
PRINT
PRINT "2. To `compile' a text file message into a beacon message"
PRINT "   which it then `downloads' into the Exciter message memory."
PRINT "   This message can include text as well as frequency, mode,"
PRINT "   speed, and FSK shift commands."
PRINT
PRINT "3. It allows the current parameters (frequency, mode, speed,"
PRINT "   and shift) to be permanently stored for instant start-up"
PRINT "   when power is applied, even without the computer."
PRINT

RETURN

HMSG2:
PRINT "Use the menu commands which appear to the right to control the program."
PRINT "The upper group are general commands. The lower group use the`F' or"
PRINT "`Function' keys on the keyboard, and offer direct control of the LF"
PRINT "Exciter, changing mode, or setting the frequency, keying speed, or FSK"
PRINT "shift. Remember that these changes will be lost when power is removed,"
PRINT "unless the SAVE command (in the upper group) has been used."
PRINT
PRINT "The Script command (F9) reads a text file and converts the contents"
PRINT "into Morse characters and commands. It then sends this data to be"
PRINT "saved in the Exciter beacon memory. Any suitable text file will do,"
PRINT "provided it contains less than 120 compiled characters and the commands"
PRINT "are used correctly. There is no error checking, so take care!"
PRINT
PRINT "The script commands correspond directly to the F, A, M and K commands"
PRINT "in the Exciter, and are sent as `$Fhhmmll', `$Axx', `$Mn', and `$Knnnn'"
PRINT "respectively. As the file is compiled, the commands appear on the screen,"
PRINT "so you can check that you have sent what you intend. The Exciter is good"
PRINT "for about 100,000 SAVE cycles! There is no capability for compiling bit-maps."
PRINT
PRINT "For more information, read MAKEBCN.TXT and see the example SCRIPT.TXT."
PRINT
RETURN

ALLERR:
	LOCATE b, c
	PRINT "Exciter communications error!                              ";
	RESUME


REM ASCII table 5x7 Hell font, in ASCII order, starting at ASCII 32 (space).
REM ascii val in decimal = (line number -3000)
REM font is (C) M. Greenman 1998

3032 DATA 0,0,0,0,0
3033 DATA 0,29,0,0,0
3034 DATA 0,24,0,24,0
3035 DATA 10,31,10,31,10
3036 DATA 8,21,31,21,2
3037 DATA 25,26,4,11,19
3038 DATA 10,21,13,2,5
3039 DATA 0,16,24,0,0
3040 DATA 0,14,17,0,0
3041 DATA 0,17,14,0,0
3042 DATA 21,14,31,14,21
3043 DATA 4,4,31,4,4
3044 DATA 0,34,3,0,0
3045 DATA 4,4,4,4,4
3046 DATA 0,3,3,0,0
3047 DATA 1,2,4,8,16
3048 DATA 14,19,21,25,14
3049 DATA 0,16,31,0,0
3050 DATA 3,21,21,21,9
3051 DATA 21,21,21,10,0
3052 DATA 30,2,7,2,0
3053 DATA 28,21,21,21,2
3054 DATA 14,21,21,21,2
3055 DATA 16,16,23,24,0
3056 DATA 10,21,21,21,10
3057 DATA 8,21,21,21,14
3058 DATA 0,5,5,0,0
3059 DATA 0,100,36,0,0
3060 DATA 0,4,10,17,0
3061 DATA 0,10,10,10,0
3062 DATA 0,17,10,4,0
3063 DATA 8,16,21,20,8
3064 DATA 14,17,21,21,8
3065 DATA 15,20,20,20,15
3066 DATA 31,21,21,21,10
3067 DATA 14,17,17,17,0
3068 DATA 31,17,17,17,14
3069 DATA 31,21,21,21,17
3070 DATA 31,20,20,20,16
3071 DATA 14,17,17,19,10
3072 DATA 31,4,4,4,31
3073 DATA 0,17,31,17,0
3074 DATA 2,17,31,16,0
3075 DATA 31,4,10,17,0
3076 DATA 31,1,1,1,0
3077 DATA 31,8,4,8,31
3078 DATA 31,8,4,2,31
3079 DATA 31,17,17,17,31
3080 DATA 31,20,20,20,8
3081 DATA 30,17,19,49,15
3082 DATA 31,20,22,21,9
3083 DATA 9,21,21,21,2
3084 DATA 16,16,31,16,16
3085 DATA 31,1,1,1,31
3086 DATA 16,8,4,2,31
3087 DATA 30,1,6,1,30
3088 DATA 17,10,4,10,17
3089 DATA 16,8,7,8,16
3090 DATA 17,19,21,25,17
3091 DATA 0,31,17,17,0
3092 DATA 16,8,4,2,1
3093 DATA 0,17,17,31,0
3094 DATA 0,8,16,8,0
3095 DATA 32,32,32,32,32
3096 DATA 0,24,16,0,0
3097 DATA 2,5,5,7,0
3098 DATA 31,5,5,2,0
3099 DATA 2,5,5,5,0
3100 DATA 2,5,5,31,0
3101 DATA 6,13,13,5,0
3102 DATA 4,15,20,8,0
3103 DATA 2,69,69,103,0
3104 DATA 31,4,4,3,0
3105 DATA 0,23,0,0,0
3106 DATA 0,32,64,55,0
3107 DATA 0,31,2,5,0
3108 DATA 0,0,31,1,0
3109 DATA 7,4,3,4,3
3110 DATA 0,7,4,3,0
3111 DATA 7,5,5,7,0
3112 DATA 103,5,5,2,0
3113 DATA 2,5,5,103,64
3114 DATA 0,7,4,4,0
3115 DATA 0,0,13,11,0
3116 DATA 0,8,31,8,0
3117 DATA 0,6,1,7,0
3118 DATA 0,4,2,7,0
3119 DATA 7,1,6,1,7
3120 DATA 0,5,2,5,0
3121 DATA 0,4,66,103,0
3122 DATA 0,11,13,0,0
3123 DATA 0,4,10,17,0
3124 DATA 0,127,0,0,0
3125 DATA 0,17,10,4,0
3126 DATA 8,16,8,16,0
3127 DATA 44,76,67,76,44

REM ASCII table Morse, in ASCII order, starting at ASCII 32 (space).
REM ascii val in decimal = (line number -4000)+offset in line. No lower case.
REM font is (C) M. Greenman 2002

4032 DATA 1,1,82,0,200,1,1,94
4040 DATA 45,109,1,42,115,97,106,41
4048 DATA 63,62,60,56,48,32,33,35
4056 DATA 39,47,71,53,1,49,1,76
4064 DATA 1,6,17,21,9,2,20,14
4072 DATA 16,4,30,13,18,7,5,15
4080 DATA 22,27,10,8,3,12,24,14
4088 DATA 25,29,19,1,1,1,1,108

REM ASCII table ITA2, in ASCII order, starting at ASCII 32 (space).
REM ascii val in decimal = (line number -5000)+offset in line. No lower case.
REM Figs characters have MSB set.
REM font is (C) M. Greenman 2002

5032 DATA 4,0,133,148,137,0,0,133
5040 DATA 143,146,0,145,140,131,156,157
5048 DATA 150,151,147,129,138,144,149,135
5056 DATA 134,152,142,0,8,158,31,153
5064 DATA 0,3,25,14,9,1,13,26
5072 DATA 20,6,11,15,18,28,12,24
5080 DATA 22,23,10,5,16,7,30,19
5088 DATA 29,21,17,0,0,0,2,0



