// geldkarte.cpp : Auslesen einiger Werte der Geldkarte
//
// Autor: Kai-Uwe Mrkor
// Datum: 28.03.2006
//

#include "stdafx.h"

/***************************************************************************

  Auslesen einer Geldkarte

 ***************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>


#include <winscard.h>



#define bcdZuInt(bcd) ( (bcd>>4)*10 + (bcd & 0x0F))



/**************************************/
/* Listet Chipkartenterminals auf und */
/* verbindet mit einem				  */
/**************************************/
int VerbindeKarte(SCARDCONTEXT *hContext, SCARDHANDLE *hCard)
{
  DWORD				dwLeser, dwProtocol;
  LPSTR				mszLeser, mszTermName;
  LONG				status;
  SCARD_READERSTATE	TerminalStatus;
  unsigned int		i,TermAnzahl, TermNummer, terminals[20];


  /* Verbindung zum Resource Manager herstellen */
  status=SCardEstablishContext( SCARD_SCOPE_SYSTEM, NULL, NULL, hContext);
  if (status != SCARD_S_SUCCESS)
  {
    printf("SCardEstablishContext fehlgeschlagen \n");
    return FALSE;
  }

  /* angeschlossene Kartenterminals ermitteln*/
  SCardListReaders( *hContext, NULL, NULL, &dwLeser);
  mszLeser = (char *)malloc( sizeof(char)*dwLeser);
  if (SCardListReaders( *hContext, NULL, mszLeser, &dwLeser) != SCARD_S_SUCCESS)
  {
	  puts("Kein Chipkartenterminal gefunden!\n");
	  return FALSE;
  }

  /* Ausgabe der Terminalnamen */
  printf("\nAngeschlossene Chipkartenterminals:\n\n");
  for (i=0, TermAnzahl=0; i<dwLeser-1; i++)
  {
	TermAnzahl++;
    printf("[%02d]: %s\n", TermAnzahl, &mszLeser[i]);
	terminals[TermAnzahl]=i;
	while( mszLeser[++i] != 0);
  }

  /* Routine verlassen, wenn kein CT gefunden */
  if (TermAnzahl==0)
  {
	  puts("Kein Chipkartenterminal gefunden!\n");
	  return FALSE;
  }

  /* Chipkartenterminal auswaehlen */
  if (TermAnzahl > 1)
	do
	{
		printf("\nBitte Chipkartenterminal ueber Nummer auswaehlen: ");
		scanf_s("%d", &TermNummer);
		printf("\n");

		if (TermNummer > TermAnzahl || TermNummer <= 0)
			printf("Falsche Eingabe, bitte wiederholen");
	  }
	while (TermNummer > TermAnzahl || TermNummer <= 0);
  else
	  TermNummer=TermAnzahl;


  /* Warten auf die Karte */
  mszTermName = (char *)malloc( sizeof(char)*strlen(&mszLeser[terminals[TermNummer]])+2 );
  strcpy( mszTermName, &mszLeser[terminals[TermNummer]]);

  TerminalStatus.szReader=mszTermName;
  TerminalStatus.dwCurrentState = SCARD_STATE_EMPTY; 

  SCardGetStatusChange( *hContext, INFINITE, &TerminalStatus, 1);
  if (TerminalStatus.dwEventState & SCARD_STATE_EMPTY)
	  printf("\nBitte die Geldkarte in \"%s\" einfuehren.\n",mszTermName); fflush(stdout);

  do
  {
	  SCardGetStatusChange( *hContext, INFINITE, &TerminalStatus, 1);
  }
  while ( TerminalStatus.dwEventState & SCARD_STATE_EMPTY);


  /* Mit eingelegter Karte verbinden */
  SCardConnect( *hContext, mszTermName, SCARD_SHARE_SHARED, SCARD_PROTOCOL_T1, hCard, &dwProtocol);
  if (status != SCARD_S_SUCCESS)
  {
    printf("SCardConnect fehlgeschlagen!\n");
    return FALSE;
  }


  return TRUE;

}


/**************************************/
/* Schliesst die aktuelle Verbindung  */
/* mit dem Chipkartenterminals        */
/**************************************/
int SchliesseVerbindung( SCARDCONTEXT *hContext, SCARDHANDLE *hCard)
{
  LONG				status;

  /* Verbindung mit Karte trennen*/
  status=SCardDisconnect( *hCard, SCARD_LEAVE_CARD);
  if (status != SCARD_S_SUCCESS)
  {
    printf("SCardDisconnect fehlgeschlagen!\n");
    return FALSE;
  }


  /* Kontext freigeben */
  status=SCardReleaseContext( *hContext);
  if (status != SCARD_S_SUCCESS)
  {
    printf("SCardReleaseContext fehlgeschlagen\n");
    return FALSE;
  }
  else
	  return TRUE;
}




/****************************************/
/* Sendet eine Kommando-APDU			*/
/*										*/
/* *hCard:	Zeiger auf KLartenhandle	*/
/* *APDU:	Zeiger auf die APDU			*/
/* laengeAPDU: Laenge der APDU			*/
/* *antwort:	Puffer fuer die Antwort	*/
/****************************************/
int SendeAPDU( SCARDHANDLE	*hCard, unsigned char *APDU, unsigned char laengeAPDU, unsigned char *antwort)
{
	LONG		status;
	DWORD		AntwortLaenge;


	/* Kommando senden */
	AntwortLaenge=255;
	status=SCardTransmit( *hCard, SCARD_PCI_T1, APDU, laengeAPDU, NULL, antwort, &AntwortLaenge);
	if (status != SCARD_S_SUCCESS)
	{
		printf("SCardTransmit fehlgeschlagen\n");
		return FALSE;
	}

	/* Trailer der Antwort-APDU ueberpruefen */
	if ( !(antwort[AntwortLaenge-2]==0x90 && antwort[AntwortLaenge-1]==0x00))
	{
		printf("\nSenden der APDU %.02xh %.02xh %.02xh %.02xh %.02xh fehlgeschlagen!",APDU[0],APDU[1],APDU[2],APDU[3],APDU[4]);
		printf("\nAntwort-Trailer (SW1:SW2): ");	/* Trailer ausgeben */
		printf("%.2xh %.2xh\n",antwort[AntwortLaenge-2],antwort[AntwortLaenge-1]);
		puts("\nBefindet sich eine Geldkarte im Kartenterminal?");

		return FALSE;
	}


	return TRUE;
}





/**************************************/
/* Auslesen der "Eckdaten" der		  */
/* eingelegten Geldkarte		      */
/**************************************/
int LeseInfos( SCARDHANDLE	*hCard)
{
	unsigned char	Antwort[255+2];
	char			waehrung[4];


	/***************************************************************************/
	/* die Select-APDUs 													   */
	/******************************** CLA  INS	  P1    P2    Lc	 EF/DF	  **/
	unsigned char SelectMF[]	 =	{0x00, 0xA4, 0x00, 0x0C};
	unsigned char SelectDF[]	 =	{0x00, 0xA4, 0x01, 0x0C, 0x02, 0xA2 ,0x00};

	unsigned char SelectID[]	 =	{0x00, 0xA4, 0x02, 0x0C, 0x02, 0x00, 0x03};
	unsigned char SelectBetrag[] =	{0x00, 0xA4, 0x02, 0x0C, 0x02, 0x01, 0x04};


	/**********************************************************************/
	/* die LeseRecord-APDU LeseBetrag								      */
	/***************************** CLA  INS	  P1    P2    LE  *************/
	unsigned char LeseRekord[]	={0x00, 0xB2, 0x01, 0x04, 0x00};



	/* Selektiere MF */
	if (SendeAPDU( hCard, SelectMF, sizeof(SelectMF), Antwort)==FALSE)
		return FALSE;

	/* Serlektiere EF */
	if (SendeAPDU( hCard, SelectID, sizeof(SelectID), Antwort)==FALSE)
		return FALSE;

	/* Lese Rekord */
	if (SendeAPDU( hCard, LeseRekord, sizeof(LeseRekord), Antwort)==FALSE)
		return FALSE;

	
	memcpy(waehrung, &Antwort[17], 3);
	waehrung[3]=0;

	printf("\n\nKartenherausgeber:\t%d\n", bcdZuInt(Antwort[1])*10000 + bcdZuInt(Antwort[2])*100 + bcdZuInt(Antwort[3]));
	printf("Karten-Nummer:\t\t%02d%02d%02d%02d%02d\n", bcdZuInt(Antwort[4]), bcdZuInt(Antwort[5]), bcdZuInt(Antwort[6]), bcdZuInt(Antwort[7]), bcdZuInt(Antwort[8]) );
	printf("\nVerfallsdatum:\t\t%02d/20%02d\n", bcdZuInt(Antwort[11]), bcdZuInt(Antwort[10]));
	printf("Aktivierungsdatum:\t%02d.%02d.%02d\n", bcdZuInt(Antwort[14]), bcdZuInt(Antwort[13]), bcdZuInt(Antwort[12]));


	/* Selektiere DF */
	if (SendeAPDU( hCard, SelectDF, sizeof(SelectDF), Antwort)==FALSE)
		return FALSE;

	/* Serlektiere EF */
	if (SendeAPDU( hCard, SelectBetrag, sizeof(SelectBetrag), Antwort)==FALSE)
		return FALSE;

	/* Lese Rekord */
	if (SendeAPDU( hCard, LeseRekord, sizeof(LeseRekord), Antwort)==FALSE)
		return FALSE;


	printf("\naktueller Betrag:\t%03.02f %s\n",(float)(bcdZuInt(Antwort[0])*10000 + bcdZuInt(Antwort[1])*100 + bcdZuInt(Antwort[2]))/100, waehrung);
	printf("maximaler Betrag:\t%03.2f %s\n",  (float)(bcdZuInt(Antwort[3])*10000 + bcdZuInt(Antwort[4])*100 + bcdZuInt(Antwort[5]))/100, waehrung);
	printf("max. Transaktion:\t%03.2f %s\n",  (float)(bcdZuInt(Antwort[6])*10000 + bcdZuInt(Antwort[7])*100 + bcdZuInt(Antwort[8]))/100, waehrung);


	return TRUE;
}




/**************************************/
/* MAIN								  */
/**************************************/
int _tmain(int argc, _TCHAR* argv[])
{
   SCARDCONTEXT  hContext;
   SCARDHANDLE	 hCard;


   if ( VerbindeKarte( &hContext, &hCard) != TRUE)
	   return EXIT_FAILURE;

   LeseInfos( &hCard);

   if ( SchliesseVerbindung( &hContext, &hCard) != TRUE)
 	   return EXIT_FAILURE;

   puts("\n\n");

   return EXIT_SUCCESS;
}

