/*
 *    psk31.h  --  PSK31 modem
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _PSK31_H
#define _PSK31_H

#include "../misc/cmplx.h"
#include "../main/trx.h"
#include "../misc/viterbi.h"

#define	SampleRate		8000
#define PipeLen			  64
#define SYNC_FRAC_BITS	   8

struct psk31 {
	/*
	 * Common stuff
	 */
	int symbollen;
	int qpsk;

	unsigned int phaseacc;
	complex prevsymbol;
	unsigned int shreg;

	/*
	 * RX related stuff
	 */
	struct filter *fir1;
	struct filter *fir2;

	struct encoder *enc;
	struct viterbi *dec;

	int		bitclk;
	int		syncbuf[16];

	int     pipe[PipeLen];
	unsigned int pipeptr;

	unsigned int dcdshreg;
	int dcd;

	complex quality;

	/*
	 * TX related stuff
	 */
	int     *txshape;
	int     *txshape2;
	int      preamble;
	short	*outbuf;
};

/* in psk31.c */
extern void psk31_init(Trx *trx);

/* in psk31rx.c */
extern int psk31_rxprocess(Trx *trx, short *buf, int len);

/* in psk31tx.c */
extern int psk31_txprocess(Trx *trx);

#endif
