#ifndef __mixer_h
#define __mixer_h

#include "cmplx.h"

//#define MIXER_SINTABLE_BITS					 4 // error max 42.53, avg 18.66, pwr 26.54
//#define MIXER_SINTABLE_BITS					 5 // error max 13.07, avg  6.03, pwr  8.16
//#define MIXER_SINTABLE_BITS					 6 // error max  5.67, avg  2.95, pwr  3.38
//#define MIXER_SINTABLE_BITS					 7 // error max  3.96, avg  2.20, pwr  2.52
#define MIXER_SINTABLE_BITS					 8 // error max  3.51, avg  2.00, pwr  2.28
//#define MIXER_SINTABLE_BITS					10 // error max  3.48, avg  1.92, pwr  2.18
//#define MIXER_SINTABLE_BITS					12 // error max  3.49, avg  1.90, pwr  2.18
//#define MIXER_SINTABLE_BITS					16 // error max  3.49, avg  1.91, pwr  2.18

#define MIXER_SINTABLE_VALUE_BITS			16
#define MIXER_SINTABLE_LENGTH				(1 << MIXER_SINTABLE_BITS)
#define MIXER_SINTABLE_QUADRANT_MASK		(MIXER_SINTABLE_LENGTH - 1)
#define MIXER_SINTABLE_QUADRANT_LO			MIXER_SINTABLE_LENGTH
#define MIXER_SINTABLE_QUADRANT_HI			(MIXER_SINTABLE_LENGTH << 1)

#define MIXER_FRAC_BITS						(32 - MIXER_SINTABLE_BITS - 2)
#define MIXER_FRAC_MASK						((1 << MIXER_FRAC_BITS) - 1)
#define MIXER_FRAC_BITS_USED				(32 - MIXER_SINTABLE_VALUE_BITS - 2) // two guarding bits
#define MIXER_FRAC_SHIFT					(MIXER_FRAC_BITS - MIXER_FRAC_BITS_USED)

/// Initialize the internal sin table
void	mixer_initialize();

/// Destroy the internal sin table
void	mixer_destroy();

/// Get the oscilator value, use the whole 32 bits
int		mixer_osc(UINT iPhase);

__inline int mixer_osc_16(UINT iPhase)
{
	// round to 16 bits
	int val = (mixer_osc(iPhase) + ((1 << (MIXER_FRAC_BITS_USED - 1)) - 1)) >> MIXER_FRAC_BITS_USED;
//	double	dAngle	= ((double)iPhase) * (3.1415926535897932384626433832795 / (32768.0 * 65536.0));
//	int		val		= (int)floor(32767.0 * sin(dAngle) + 0.5);
	// clamp
	if (val > 32767)
		val = 32767;
	else if (val < - 32767)
		val = - 32767;
	return val;
}

/// Mix the input value with the oscilator
/// Input - 16 bit value, output - 32 bits
void	mixer_mix(short iValue, unsigned int iPhase, complex *pOut);

void	mixer_mix_complex(complex z, unsigned int iPhase, complex *pOut);

int		mixer_mix2(int re, int im, unsigned int iPhase);

void	mixer_test();

#endif /* __mixer_h */
