#include <windows.h>
#include "mixer.h"

static short *g_pMixerSinTable = 0;

void mixer_initialize()
{
	int    iValueMax = (1 << (MIXER_SINTABLE_VALUE_BITS - 1)) - 1;
	double dValueMax = (double)iValueMax;
	UINT   i;

	if (g_pMixerSinTable != 0)
		return;

	g_pMixerSinTable = (short*)malloc(sizeof(short) * (MIXER_SINTABLE_LENGTH + 1));

	for (i = 0; i < MIXER_SINTABLE_LENGTH; ++ i) {
		double dValue = dValueMax * sin(1.5707963267948966192313216916398 * (double)i / (double)MIXER_SINTABLE_LENGTH);
		int    iValue = (int)(dValue + 0.5);
		if (iValue < 0)
			iValue = iValueMax;
		g_pMixerSinTable[i] = iValue;
	}
	g_pMixerSinTable[i] = iValueMax;

//FIXME
//	mixer_test();
}

void mixer_destroy()
{
	free(g_pMixerSinTable);
}

/*
#define FIX_SIN(angle) \
	(  (angle & MIXER_SINTABLE_QUADRANT_HI) ? \
			((angle & MIXER_SINTABLE_QUADRANT_LO) ? \
				- g_pMixerSinTable[MIXER_SINTABLE_LENGTH - (angle & MIXER_SINTABLE_QUADRANT_MASK)] : \
				- g_pMixerSinTable[angle & MIXER_SINTABLE_QUADRANT_MASK]) : \
			((angle & MIXER_SINTABLE_QUADRANT_LO) ? \
				g_pMixerSinTable[MIXER_SINTABLE_LENGTH - (angle & MIXER_SINTABLE_QUADRANT_MASK)] : \
				g_pMixerSinTable[angle & MIXER_SINTABLE_QUADRANT_MASK])  )
*/

short FIX_SIN(UINT angle)
{
	if (angle & MIXER_SINTABLE_QUADRANT_HI) {
		if (angle & MIXER_SINTABLE_QUADRANT_LO)
			return - g_pMixerSinTable[MIXER_SINTABLE_LENGTH - (angle & MIXER_SINTABLE_QUADRANT_MASK)];
		else
			return - g_pMixerSinTable[angle & MIXER_SINTABLE_QUADRANT_MASK];
	} else {
		if (angle & MIXER_SINTABLE_QUADRANT_LO)
			return g_pMixerSinTable[MIXER_SINTABLE_LENGTH - (angle & MIXER_SINTABLE_QUADRANT_MASK)];
		else 
			return g_pMixerSinTable[angle & MIXER_SINTABLE_QUADRANT_MASK];
	}
}

int	mixer_osc(UINT iPhase)
{
	UINT iPhase1 = iPhase >> MIXER_FRAC_BITS;
	UINT iPhase2 = iPhase1 + 1;
	UINT iFrac2  = ((iPhase & MIXER_FRAC_MASK) + (1 << (MIXER_FRAC_SHIFT - 1)) - 1) >> MIXER_FRAC_SHIFT;
	UINT iFrac1  = (MIXER_FRAC_MASK >> MIXER_FRAC_SHIFT) - iFrac2;
	int iSin1   = FIX_SIN(iPhase1);
	int iSin2   = FIX_SIN(iPhase2);
	int iValue  = iSin1 * iFrac1 + iSin2 * iFrac2;
	return iValue;
}

#define MIXER_OSC_SHORT(PHASE) ((mixer_osc(PHASE) + 0x7fff) >> 16)

void mixer_mix(short iValue, unsigned int iPhase, complex *pOut)
{
	pOut->re = iValue * mixer_osc_16(iPhase);
	pOut->im = iValue * mixer_osc_16(iPhase + 0x40000000);
}

void mixer_mix_complex(complex z, unsigned int iPhase, complex *pOut)
{
	int iCos = mixer_osc_16(iPhase + 0x40000000);
	int iSin = mixer_osc_16(iPhase);
	pOut->re = z.re * iCos - z.im * iSin;
	pOut->im = z.re * iSin + z.im * iCos;
}

int mixer_mix2(int re, int im, unsigned int iPhase)
{
	return re * mixer_osc_16(iPhase) + im * mixer_osc_16(iPhase + 0x40000000);
}

void mixer_get_error(UINT nLen, UINT nPhaseStart, UINT nPhaseDelta, double *pErrorMax, double *pErrorAvg, double *pErrorPwr)
{
	double dMaxVal     = 1 << (15 + MIXER_FRAC_BITS_USED);
	double dDiffMax    = 0.0;
	double dDiffSum    = 0.0;
	double dDiffPwr	   = 0.0;
	UINT   i;

	UINT nPhase = nPhaseStart;
	for (i = 0; i < nLen; ++ i) {
		double dAngle = nPhase * (3.1415926535897932384626433832795 / (32768.0 * 65536.0));
		double dSin   = dMaxVal * sin(dAngle);
		int    iSin   = mixer_osc(nPhase);
		double dDiff  = dSin - (double)iSin;
		double dDiffAbs = fabs(dDiff);
		if (dDiffMax < dDiffAbs)
			dDiffMax = dDiffAbs;
		dDiffSum	+= dDiffAbs;
		dDiffPwr	+= dDiffAbs * dDiffAbs;
		nPhase		+= nPhaseDelta;
	}

	*pErrorMax = dDiffMax;
	*pErrorAvg = dDiffSum / nLen;
	*pErrorPwr = sqrt(dDiffPwr / nLen);
}

void mixer_get_error_mix(UINT nLen, UINT nPhaseStart, UINT nPhaseDelta, double *pErrorMax, double *pErrorAvg, double *pErrorPwr)
{
	double dMaxVal     = (1 << 15) - 1;
	double dDiffMax    = 0.0;
	double dDiffSum    = 0.0;
	double dDiffPwr	   = 0.0;
	UINT   i;

	UINT nPhase = nPhaseStart;
	for (i = 0; i < nLen; ++ i) {
		double dAngle = nPhase * (3.1415926535897932384626433832795 / (32768.0 * 65536.0));
		double dSin   = dMaxVal * sin(dAngle);
		double dCos   = dMaxVal * cos(dAngle);
		complex z;
		double dDiffSin, dDiffCos, dDiffAbs;
		mixer_mix(1, nPhase, &z);
		dDiffSin = dSin - (double)z.re;
		dDiffCos = dCos - (double)z.im;
		dDiffAbs = max(fabs(dDiffSin), fabs(dDiffCos));
		if (dDiffMax < dDiffAbs)
			dDiffMax = dDiffAbs;
		dDiffSum	+= dDiffAbs;
		dDiffPwr	+= dDiffAbs * dDiffAbs;
		nPhase		+= nPhaseDelta;
	}

	*pErrorMax = dDiffMax;
	*pErrorAvg = dDiffSum / nLen;
	*pErrorPwr = sqrt(dDiffPwr / nLen);
}

void mixer_test()
{
	double dErrorMax = 0.0;
	double dErrorAvg = 0.0;
	double dErrorPwr = 0.0;
	UINT i;

	for (i = 1000; i < 8000; ++ i) {
		double dError, dErrorAvgThis, dErrorPwrThis;
		UINT iPhaseStart = rand();
		mixer_get_error_mix(4000, iPhaseStart, i << 16, &dError, &dErrorAvgThis, &dErrorPwrThis);
		if (dError > dErrorMax)
			dErrorMax = dError;
		if (dErrorPwrThis > dErrorPwr)
			dErrorPwr = dErrorPwrThis;
		dErrorAvg += dErrorAvgThis;
	}
	dErrorAvg /= 7000;
}