/*
 *    filter.h  --  FIR filter
 *
 *    Copyright (C) 2001, 2002, 2003, 2004
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _FILTER_H
#define _FILTER_H

#include "cmplx.h"

#define BufferLen	1024

struct filter {
	int		length;
	int		decimateratio;

	int	   *ifilter;
	int	   *qfilter;

	int		ibuffer[BufferLen];
	int		qbuffer[BufferLen];

	int		pointer;
	int		counter;
};

extern struct	filter *filter_init(int len, int dec, float *ifil, float *qfil);
extern struct	filter *filter_init_lowpass(int len, int dec, float freq);
extern struct	filter *filter_init_bandpass(int len, int dec, float f1, float f2);
extern struct	filter *filter_init_hilbert(int len, int dec);

extern void		filter_free(struct filter *f);

extern int		filter_run(struct filter *f, complex in, complex *out);

/* ---------------------------------------------------------------------- */

/*
 * Sinc done properly.
 */
__inline double sinc(double x)
{
	if (fabs(x) < 1e-10)
		return 1.0;
	else
		return sin(M_PI * x) / (M_PI * x);
}

/*
 * Don't ask...
 */
__inline double cosc(double x)
{
	if (fabs(x) < 1e-10)
		return 0.0;
	else
		return (1.0 - cos(M_PI * x)) / (M_PI * x);
}

/*
 * Hamming window function.
 */
__inline double hamming(double x)
{
	return 0.54 - 0.46 * cos(2 * M_PI * x);
}

#endif /* _FILTER_H */
