/*
 *    mfsktx.c  --  MFSK modulator
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "mfsk.h"
#include "../main/trx.h"
#include "../misc/viterbi.h"
#include "mfskvaricode.h"
#include "interleave.h"
#include "../main/sndmodem.h"
//#include "picture.h"
#include "../misc/filter.h"
#include "../misc/misc.h"
#include "../misc/mixer.h"
//#include "main.h"

static void sendsymbol(Trx *trx, int sym)
{
/*
	static pokus = 0;
	sym = (pokus ++) / 6;
	if (pokus == 16*6)
		pokus = 0;

	{
*/
	Mfsk	   *m			= (Mfsk*)trx->modem;
	int			iTone		= trx->reverse ? (m->numtones - 1 - grayencode(sym & (m->numtones - 1))) : grayencode(sym & (m->numtones - 1));
	unsigned	iFrequency  = trx->frequency /* - (((m->numtones - 1) * m->tonespacing) >> 1) */ + m->tonespacing * iTone;
	unsigned	iPhaseDelta = (unsigned)((65536.0 * 65536.0) * iFrequency / (SampleRate << FREQ_FRAC_BITS));
	int			i;

/*
	{
		char bufout[256];
		sprintf(bufout, "%2x\r\n", iTone);
		OutputDebugString(bufout);
	}
*/

	for (i = 0; i < m->symlen; ++ i) {
		trx->outbuf[i] = mixer_osc_16(m->phaseacc) >> 1;
		m->phaseacc += iPhaseDelta;
	}

	sndmodem_write(trx->pModem, trx->outbuf, m->symlen);
//	}
}

static void sendbit(Trx *trx, int bit)
{
	Mfsk *m = (Mfsk *) trx->modem;
	int i, data;

/*
	{
		char bufout[256];
		sprintf(bufout, "sendbit: %d\r\n", bit);
		OutputDebugString(bufout);
	}
*/
	data = encoder_encode(m->enc, bit);

	for (i = 0; i < 2; i++) {
		m->bitshreg = (m->bitshreg << 1) | ((data >> i) & 1);
		m->bitstate++;

		if (m->bitstate == m->symbits) {
			interleave_bits(m->txinlv, &m->bitshreg);
			sendsymbol(trx, m->bitshreg);

/*
			{
				char bufout[256];
				sprintf(bufout, "%02x\r\n", m->bitshreg);
				OutputDebugString(bufout);
			}
*/

			m->bitstate = 0;
			m->bitshreg = 0;
		}
	}
}

static void sendchar(Trx *trx, unsigned char c)
{
	char *code = varienc(c);
	while (*code)
		sendbit(trx, (*code++ - '0'));
	trx_put_echo_char(trx, c);
}

static void sendidle(Trx *trx)
{
	int i;
	sendchar(trx, 0);	/* <NUL> */
	sendbit(trx, 1);
	/* extended zero bit stream */
	for (i = 0; i < 32; ++ i)
		sendbit(trx, 0);
}

static void flushbits(Trx *trx, int nBits)
{
	Mfsk *m = (Mfsk*)trx->modem;
	int   i;
	/* flush the convolutional encoder and interleaver */
	for (i = 0; i < nBits; ++ i)
		sendbit(trx, 0);
}

/*
static int startpic(Trx *trx)
{
	Mfsk *m = (Mfsk*)trx->modem;
	char *header, *p;

	if ((m->picbuf = trx_get_tx_picture()) == NULL)
		return 0;

	header = picbuf_make_header(m->picbuf);

	for (p = header; *p != 0; p++)
		sendchar(trx, *p);

	free(header);

	flushtx(trx);

	return 1;
}

static void sendpic(Trx *trx, guchar *data, gint len)
{
	Mfsk *m = (Mfsk*)trx->modem;
	float *ptr;
	float freq, f;
	int i, j;

	if (SAMPLES_PER_PIXEL * len > OUTBUFSIZE) {
		g_warning("sendpic: buffer overrun\n");
		return;
	}

	ptr = trx->outbuf;

	freq = trx->frequency + trx->txoffset;

	for (i = 0; i < len; i++) {
		f = freq + trx->bandwidth * (data[i] - 128) / 256.0;

		for (j = 0; j < SAMPLES_PER_PIXEL; j++) {
			*ptr++ = cos(m->phaseacc);

			m->phaseacc += 2.0 * M_PI * f / SampleRate;

			if (m->phaseacc > M_PI)
				m->phaseacc -= 2.0 * M_PI;
		}
	}

	sound_write(trx->outbuf, SAMPLES_PER_PIXEL * len);
}
*/

int mfsk_txprocess(Trx *trx)
{
	Mfsk	*m = (Mfsk*)trx->modem;
//	UCHAR	 buf[64];
//	UCHAR	*str;
	int		 i;

	if (trx->tune) {
		m->txstate = TX_STATE_TUNE;
		trx->tune = 0;
	}

	switch (m->txstate) {
	case TX_STATE_TUNE:
		sendsymbol(trx, 0);
		m->txstate = TX_STATE_FINISH;
		break;

	case TX_STATE_PREAMBLE:
		for (i = 0; i < 32; ++ i)
			sendbit(trx, 0);
		m->txstate = TX_STATE_START;
		break;

	case TX_STATE_START:
		sendchar(trx, '\r');
		sendchar(trx, 2);		// STX
		sendchar(trx, '\r');
		m->txstate = TX_STATE_DATA;
		break;

	case TX_STATE_DATA:
		i = trx_get_tx_char(trx);
/*
		if (i == 0xFFFC) {
			statusbar_set_main("Send picture: start");
			m->counter = 0;

			if (startpic(trx))
				m->txstate = TX_STATE_PICTURE_START;

			break;
		}
*/
		if (i == -1)
			sendidle(trx);
		else
			sendchar(trx, i);
		if (trx->stopflag)
			m->txstate = TX_STATE_END;
		break;

	case TX_STATE_END:
		i = trx_get_tx_char(trx);
/*
		if (i == 0xFFFC) {
			if (startpic(trx))
				m->txstate = TX_STATE_PICTURE;
			break;
		}
*/
		if (i == -1) {
			sendchar(trx, '\r');
			sendchar(trx, 4);		// EOT
			sendchar(trx, '\r');
			m->txstate = TX_STATE_FLUSH;
		} else
			sendchar(trx, i);
		break;

	case TX_STATE_FLUSH:
		/* flush the varicode decoder at the other end */
		sendbit(trx, 1);
		flushbits(trx, 31);
		m->txstate = TX_STATE_FLUSH2;
		break;
	case TX_STATE_FLUSH2:
		flushbits(trx, 32);
		m->txstate = TX_STATE_FLUSH3;
		break;
	case TX_STATE_FLUSH3:
		flushbits(trx, 32);
		m->txstate = TX_STATE_FLUSH4;
		break;
	case TX_STATE_FLUSH4:
		flushbits(trx, 107 - 32 - 32 - 31);
		m->txstate  = TX_STATE_FINISH;
		m->bitstate = 0;
		sndmodem_tx_flush(trx->pModem);
		return -1;

	case TX_STATE_FINISH:
		return -1;

/*
	case TX_STATE_PICTURE_START:
		memset(buf, 0, sizeof(buf));
		sendpic(trx, buf, 44);

		m->txstate = TX_STATE_PICTURE;
		break;

	case TX_STATE_PICTURE:
		i = sizeof(buf);

		if (picbuf_get_data(m->picbuf, buf, &i) == FALSE) {
			picbuf_free(m->picbuf);
			m->picbuf = NULL;
			m->txstate = TX_STATE_DATA;

			sendpic(trx, buf, i);

			statusbar_set_main("Send picture: done");
			m->counter = 0;

			break;
		}

		sendpic(trx, buf, i);

		if (++m->counter == 8) {
			gdouble x = picbuf_get_percentage(m->picbuf);

			str = g_strdup_printf("Send picture: %.0f%%", x);
			statusbar_set_main(str);
			free(str);

			m->counter = 0;
		}

		break;
*/
	}

	return 0;
}
