/*
 *    mfsk.h  --  MFSK modem
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _MFSK_H
#define _MFSK_H

#include "../main/trx.h"
#include "../misc/cmplx.h"
#include "../misc/viterbi.h"
#include "interleave.h"
// #include "fftfilt.h"
// #include "delay.h"
// #include "picture.h"

#define	SampleRate			(8000)
#define	SAMPLES_PER_PIXEL	(SampleRate / 1000)	/* 1 ms per pixel */
#define MFSK_UNDERSAMPLING	4


#define	K		7
#define	POLY1	0x6d
#define	POLY2	0x4f

typedef struct mfsk Mfsk;

struct mfsk {
	/*
	 * Common stuff
	 */
	unsigned int	phaseacc;

	int				symlen;
	int				symbits;
	int				numtones;
	int				basetone;
	int				tonespacing;

	int				counter;

	/*
	 * RX related stuff
	 */
	int				rxstate;

	struct filter  *filt;
	struct viterbi *dec1;
	struct viterbi *dec2;
	struct interleave *rxinlv;

	complex		   *pipe;
	int			    pipeptr;

	unsigned int    datashreg;

	complex			currvector;
	complex			prev1vector;
	complex			aTones[32];

	int				currsymbol;
	int				prev1symbol;
	int				prev2symbol;

	complex		   *dftcoeffs;

	int				met1;
	int				met2;
	int				metric;

	int				synccounter;

	unsigned char	symbolpair[2];
	int				symcounter;

//	int picturesize;
//	char picheader[16];
//	complex prevz;
//	double picf;

	int				symbolbit;

	/*
	 * TX related stuff
	 */
	int					txstate;

	struct encoder	   *enc;
	struct interleave  *txinlv;

	unsigned int		bitshreg;
	int					bitstate;

//	Picbuf *picbuf;
};

enum {
	TX_STATE_PREAMBLE,
	TX_STATE_START,
	TX_STATE_DATA,
	TX_STATE_END,
	TX_STATE_FLUSH,
	TX_STATE_FLUSH2,
	TX_STATE_FLUSH3,
	TX_STATE_FLUSH4,
	TX_STATE_FINISH,
	TX_STATE_TUNE,
	TX_STATE_PICTURE_START,
	TX_STATE_PICTURE
};

enum {
	RX_STATE_DATA,
	RX_STATE_PICTURE_START_1,
	RX_STATE_PICTURE_START_2,
	RX_STATE_PICTURE
};

/* in mfsk.c */
extern void mfsk_init(Trx *trx);

/* in mfskrx.c */
extern int mfsk_rxprocess(Trx *trx, short *buf, int len);

/* in mfsktx.c */
extern int mfsk_txprocess(Trx *trx);

#endif
