/*
 *    trx.h  --  Modem engine
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
                                                                                
#ifndef	_TRX_H
#define	_TRX_H

#ifdef __cplusplus
extern "C" {
#endif 

#include <windows.h>
#include <windowsx.h>

#include "log.h"

typedef struct _SndModem SndModem;
typedef struct _QsoInfo  QsoInfo;

/* special character for switching to rx - (R) .. registered */
#ifdef _WIN32_WCE
#define	TRX_RX_CMD	  174
#define TRX_CLEAR_CMD 169
#else
#define	TRX_RX_CMD	  -82
#define TRX_CLEAR_CMD -87
#endif

#define	OUTBUFSIZE	16384

/* ---------------------------------------------------------------------- */

typedef enum {
	MODE_BPSK31 = 0,
	MODE_QPSK31,
	MODE_PSK63,
	MODE_RTTY,
	MODE_CW,
	MODE_MFSK16,
	MODE_MFSK8,
	MODE_THROB1,
	MODE_THROB2,
	MODE_THROB4,
	MODE_MT63,
	MODE_FELDHELL,
	MODE_FMHELL
} trx_mode_t;

extern TCHAR *trx_mode_names[];

typedef enum {
	TRX_STATE_PAUSE = 0,
	TRX_STATE_RX,
	TRX_STATE_TX,
	TRX_STATE_TUNE,
	TRX_STATE_ABORT,
/// Flush TX buffers and wait for Windows driver for confirmation
	TRX_STATE_FLUSH
} trx_state_t;

typedef enum {
	LAYOUT_SINGLELINE,
	LAYOUT_RCV,
	LAYOUT_TRX,
} layout_t;

#define FREQ_FRAC_BITS   4
#define FREQ_FRAC_VALUE 16

extern TCHAR *trx_state_names[];

typedef struct _Trx Trx;

struct _Trx {
	int				nChannelID;
	trx_mode_t		mode;
	trx_state_t		state;
	Log				log;

//	int samplerate;

	/// AFC is switched on
	BOOL	afcon;
	/// squelch is switched on
	BOOL	squelchon;
	int		iSquelchThreshold;

	/// want to stop transmitting
	int stopflag;
	/// send tuning signal
	int tune;
	/// reverse the sideband
	int reverse;

	int frequency;
//	float bandwidth;
//	float metric;
	float txoffset;

	int backspaces;
	unsigned char	*txstr;
	unsigned char	*txptr;

	SndModem		*pModem;
	QsoInfo			*pQso;
// Buffer for caching one output symbol.
	short outbuf[OUTBUFSIZE];

/*
	float mfsk_squelch;

*/

	float rtty_squelch;
	int rtty_shift;
	float rtty_baud;
	int rtty_bits;
	int rtty_parity;
	int rtty_stop;
	BOOL rtty_reverse;
	BOOL rtty_msbfirst;


//	float throb_squelch;

//	int psk31_squelch;

/*
	float mt63_squelch;
	int mt63_bandwidth;
	int mt63_interleave;
	BOOL mt63_cwid;
	BOOL mt63_esc;

	char *hell_font;
	BOOL hell_upper;
	float hell_bandwidth;
	float hell_agcattack;
	float hell_agcdecay;
*/

	int	cw_rxspeed;
	int	cw_txspeed;
	int cw_bandwidth;
	int cw_firtaps;

	void	   *modem;

	layout_t	nLayout;
	HWND		hWnd;
	HWND		hWndReceive;
	HWND		hWndSend;
	HFONT		hFont;

	TCHAR		aLineReceived[128];
	int			nLineReceivedLen;
	int			iLineReceivedIdx;
	int			nLineOutPos;
	TCHAR		cPrevChar;
	BOOL		bPrevCharEcho;

	//FIXME
	/// number of characters sent from the TX window
	int			nCharsSent;

	void (*txinit) (Trx *trx);
	void (*rxinit) (Trx *trx);

	int (*txprocess) (Trx *trx);
	int (*rxprocess) (Trx *trx, short *buf, int len);

	void (*destructor) (Trx *trx);
};

extern BOOL			trx_register_classes(HINSTANCE hInstance);
extern Trx*			trx_new();
extern void			trx_free(Trx *trx);

extern BOOL			trx_init(Trx *trx);
extern BOOL			trx_initmodem(Trx *trx);
extern BOOL			trx_create(Trx *trx, HWND hWndParent, HANDLE hInstance, SndModem *pModem);
extern void			trx_destroy(Trx *trx);

extern void			trx_put_rx_char(Trx *trx, UINT c);
extern int			trx_get_rx_char(void);

extern int			trx_get_tx_char(Trx *trx);
extern void			trx_put_echo_char(Trx *trx, UINT c);
extern void			trx_send_char(Trx *trx, TCHAR c);
extern void			trx_send_string(Trx *trx, TCHAR *str);

extern void			trx_clearrx(Trx *trx);
extern void			trx_cleartx(Trx *trx);

extern void			trx_set_scope(int *data, int len, BOOL autoscale);
extern void			trx_set_phase(int phase, BOOL highlight);

extern BOOL			trx_layout(Trx *trx, layout_t nLayout, RECT *rect);

extern BOOL			trx_txloop(Trx *trx);
extern void			trx_txend(Trx *trx);
extern BOOL			trx_is_sending(Trx *trx);


extern void			trx_set_rtty_parms(Trx *trx, float squelch, int shift, float baud,
	int bits, int parity, int stop, BOOL reverse, BOOL msbfirst);

/*

extern int trx_init(void);

extern void trx_set_mode(trx_mode_t);
extern trx_mode_t trx_get_mode(void);
extern char *trx_get_mode_name(void);

extern void trx_set_state(trx_state_t);
extern void trx_set_state_wait(trx_state_t);
extern trx_state_t trx_get_state(void);

extern void trx_set_freq(float);
extern float trx_get_freq(void);

extern void trx_set_txoffset(float);
extern float trx_get_txoffset(void);

extern void trx_set_mfsk_parms(float);

extern void trx_set_throb_parms(float);

extern void trx_set_psk31_parms(float);

extern void trx_set_mt63_parms(float, int, int, BOOL, BOOL);

extern void trx_set_hell_parms(char *, BOOL, float, float, float);

extern void trx_set_afc(BOOL on);
extern void trx_set_squelch(BOOL on);
extern void trx_set_reverse(BOOL on);

//extern float trx_get_bandwidth(void);

extern int trx_get_samplerate(void);

extern void trx_init_queues(void);

extern int trx_get_echo_char(void);

extern void trx_put_rx_data(UINT c);
extern int trx_get_rx_data(void);

extern void trx_put_rx_picdata(UINT c);
extern int trx_get_rx_picdata(void);

extern void trx_put_tx_picture(void* picbuf);
extern void* trx_get_tx_picture(void);

extern void trx_queue_backspace(void);

*/

#ifdef __cplusplus
}
#endif 

#endif
