/*
 *    stninfo.c  --  Station info
 *
 *    Copyright (C) 2006
 *      Vojtech Bubnik OK1IAK (bubnikv@seznam.cz)
 *
 *    This file is part of PocketDigi.
 *
 *    PocketDigi is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    PocketDigi is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <windows.h>
#include <tchar.h>

#include <string.h>
#include <stdio.h>
#include <ctype.h>

#ifdef _WIN32_WCE
#include "Aygshell.h"
#endif /* _WIN32_WCE */

#include "stninfo.h"
#include "dlggen.h"
#include "../resource.h"

extern HINSTANCE	g_hInst;
extern HWND			s_hWndMain;

StnInfo				g_StnInfo;

#define ID_LABEL	101
#define ID_ENTRY	201

TCHAR *g_aStnInfoLabels[] = {
	_T("Call"),
	_T("Name"),
	_T("QTH"),
	_T("Loc"),
	_T("mail")
};

INT_PTR CALLBACK stninfo_dlgproc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
#ifdef _WIN32_WCE
	static SHACTIVATEINFO sai;
#endif /* _WIN32_WCE */

    switch(uMsg)
    {
    case WM_INITDIALOG:
	{
#ifdef _WIN32_WCE
		memset(&sai, 0, sizeof(sai));
        {
            SHINITDLGINFO shidi;
            shidi.dwMask	= SHIDIM_FLAGS;
            shidi.dwFlags	= SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
            shidi.hDlg		= hwnd;
            SHInitDialog(&shidi);
        }
		{
			SHMENUBARINFO mbi;
			memset(&mbi, 0, sizeof(SHMENUBARINFO));
			mbi.cbSize		= sizeof(SHMENUBARINFO);
			mbi.hwndParent	= hwnd;
			mbi.hInstRes	= g_hInst;
			mbi.dwFlags		= SHCMBF_EMPTYBAR;
			SHCreateMenuBar(&mbi);
		}
#endif /* _WIN32_WCE */
        return TRUE;
	}
	case WM_ACTIVATE:
#ifdef _WIN32_WCE
		if (wParam == SPI_SETSIPINFO){
			memset(&sai, 0, sizeof(SHACTIVATEINFO));
			SHHandleWMActivate(hwnd, wParam, lParam, &sai, 0);
		}
#endif /* _WIN32_WCE */
		break;
	case WM_SETTINGCHANGE:
#ifdef _WIN32_WCE
		if (wParam == SPI_SETSIPINFO) {
			memset(&sai, 0, sizeof(SHACTIVATEINFO));
			SHHandleWMSettingChange(hwnd, -1, 0, &sai);
		}
#endif /* _WIN32_WCE */
	case WM_SIZE:
	{
		RECT rectWnd, rectValue;
		int  i;
		GetClientRect(hwnd, &rectWnd);
		for (i = 0; i < STNINFO_LEN; ++ i) {
			HWND hWndValue = GetDlgItem(hwnd, ID_ENTRY + i);
			GetWindowRect(hWndValue, &rectValue);
			ScreenToClient(hwnd, (LPPOINT)(&rectValue.left));
			ScreenToClient(hwnd, (LPPOINT)(&rectValue.right));
			MoveWindow(hWndValue, rectValue.left, rectValue.top,
				rectWnd.right - rectWnd.left - rectValue.left - 2, 
				rectValue.bottom - rectValue.top, TRUE);
		}
#ifndef _WIN32_WCE
		{
			HWND hWndOK		= GetDlgItem(hwnd, IDOK);
			HWND hWndCancel = GetDlgItem(hwnd, IDCANCEL);
			RECT rectButton;
			GetWindowRect(hWndOK, &rectButton);
			ScreenToClient(hwnd, (LPPOINT)(&rectButton.left));
			ScreenToClient(hwnd, (LPPOINT)(&rectButton.right));
			MoveWindow(hWndCancel, 
				rectWnd.right - DLG_MARGIN - (rectButton.right - rectButton.left), 
				rectWnd.bottom - DLG_MARGIN - (rectButton.bottom - rectButton.top),
				rectButton.right - rectButton.left, 
				rectButton.bottom - rectButton.top, TRUE);
			MoveWindow(hWndOK, 
				rectWnd.right - 3 * DLG_MARGIN - 2 * (rectButton.right - rectButton.left),
				rectWnd.bottom - DLG_MARGIN - (rectButton.bottom - rectButton.top),
				rectButton.right - rectButton.left, 
				rectButton.bottom - rectButton.top, TRUE);
		}
#endif /* _WIN32_WCE */
	}
    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) {
			if (LOWORD(wParam) == IDOK) {
				int i;
				for (i = 0; i < STNINFO_LEN; ++ i) {
					HWND hWnd  = GetDlgItem(hwnd, ID_ENTRY + i);
					int  nLen  = GetWindowTextLength(hWnd);
					STNINFO_ARRAY[i] = (TCHAR*)realloc(
						STNINFO_ARRAY[i], (nLen + 1) * sizeof(TCHAR));
					GetWindowText(hWnd, STNINFO_ARRAY[i], nLen + 1);
				}
			}
            EndDialog(hwnd, LOWORD(wParam) == IDOK);
            return TRUE;
        }
        break;
	case WM_PAINT:
	{
		PAINTSTRUCT paint;
		RECT		rect, rectClient;
		POINT		line[2];
		HGDIOBJ		hOldPen;
		HPEN		hNewPen;
		int			i;
		BeginPaint(hwnd, &paint);
		GetWindowRect(hwnd, &rect);
		GetClientRect(hwnd, &rectClient);
		hNewPen = CreatePen(PS_SOLID, 0, RGB(127, 127, 127));
		hOldPen = SelectObject(paint.hdc, hNewPen);
		for (i = 0; i < STNINFO_LEN; ++ i) {
			HWND hControl  = GetDlgItem(hwnd, ID_ENTRY + i);
			RECT rectControl;
			GetWindowRect(hControl, &rectControl);
			ScreenToClient(hwnd, (LPPOINT)&rectControl.left);
			ScreenToClient(hwnd, (LPPOINT)&rectControl.right);
			line[0].x = rectControl.left;
			line[1].x = rectControl.right;
			line[0].y = rectControl.bottom;
			line[1].y = line[0].y;
			Polyline(paint.hdc, line, 2);
		}
		SelectObject(paint.hdc, hOldPen);
		DeleteObject(hNewPen);
		EndPaint(hwnd, &paint);
		break;
	}
    default:
        break;
	}

    return FALSE;
}

BOOL stninfo_edit()
{
	DlgTemplate tmpl;
	int         i;

	dlggen_create(&tmpl, _T("Station Info"),
#ifdef _WIN32_WCE
		WS_POPUP | WS_BORDER, 
#else /* _WIN32_WCE */
		WS_OVERLAPPEDWINDOW | /* WS_POPUP | WS_BORDER | WS_SYSMENU | WS_DLGFRAME  | WS_CAPTION */ DS_MODALFRAME, 
#endif /* _WIN32_WCE */
		0, 0, 110, 90, _T("Tahoma"), 9);

	for (i = 0; i < STNINFO_LEN; ++ i) {
		dlggen_add_static(&tmpl, g_aStnInfoLabels[i],
			WS_CHILD | WS_VISIBLE | SS_RIGHT, 0, 2, 2 + i * 12, 30, 10, ID_LABEL + i);
		dlggen_add_edit_box(&tmpl, STNINFO_ARRAY[i],
			WS_CHILD | WS_VISIBLE | WS_TABSTOP | ES_AUTOHSCROLL | ES_AUTOVSCROLL, /* WS_EX_STATICEDGE */ 0,
			34, 2 + i * 12, 101, 10, ID_ENTRY + i);
	}

#ifndef _WIN32_WCE
	dlggen_add_button(&tmpl, _T("OK"),
		WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0,
		2, 140, 38, 15, IDOK);
	dlggen_add_button(&tmpl, _T("Cancel"),
		WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0,
		50, 140, 38, 15, IDCANCEL);
#endif /* _WIN32_WCE */

	return dlggen_dialog_box(&tmpl, g_hInst, s_hWndMain, stninfo_dlgproc) == IDOK;
}

void stninfo_load()
{
	HKEY  hKeyStnInfo = 0;
	DWORD dwType	  = REG_SZ;
	DWORD dwSize      = 0;
	int   i;

	memset(&g_StnInfo, 0, sizeof(g_StnInfo));

	if (RegOpenKeyEx(HKEY_CURRENT_USER, _T("Software\\OK1IAK\\PocketDigi\\StnInfo"), 0, 
		KEY_ENUMERATE_SUB_KEYS | KEY_QUERY_VALUE | KEY_READ, &hKeyStnInfo) != ERROR_SUCCESS) {
		stninfo_load_defaults();
		return;
	}

	for (i = 0; i < STNINFO_LEN; ++ i) {
		if (RegQueryValueEx(hKeyStnInfo, g_aStnInfoLabels[i], 0, &dwType, 0, &dwSize) == ERROR_SUCCESS) {
			STNINFO_ARRAY[i] = (TCHAR*)malloc(dwSize);
			RegQueryValueEx(hKeyStnInfo, g_aStnInfoLabels[i], 0, &dwType, 
				(LPBYTE)STNINFO_ARRAY[i], &dwSize);
		} else
			STNINFO_ARRAY[i]  = _tcsdup(_T(""));
	}

	RegCloseKey(hKeyStnInfo);
}

void stninfo_load_defaults()
{
	stninfo_destroy();
	g_StnInfo.strCall  = _tcsdup(_T("NOCALL"));
	g_StnInfo.strName  = _tcsdup(_T(""));
	g_StnInfo.strQth   = _tcsdup(_T(""));
	g_StnInfo.strLoc   = _tcsdup(_T(""));
	g_StnInfo.strEmail = _tcsdup(_T(""));
}

void stninfo_store()
{
	HKEY  hKeyStnInfo   = 0;
	DWORD dwDisposition = 0;
	DWORD dwType	    = REG_SZ;
	DWORD dwSize        = 0;
	int   i;

	if (RegCreateKeyEx(HKEY_CURRENT_USER, _T("Software\\OK1IAK\\PocketDigi\\StnInfo"), 0, 0,
		REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &hKeyStnInfo, &dwDisposition) != ERROR_SUCCESS)
		return;

	for (i = 0; i < STNINFO_LEN; ++ i)
		RegSetValueEx(hKeyStnInfo, g_aStnInfoLabels[i], 0, REG_SZ,
			(LPBYTE)(STNINFO_ARRAY[i]), (_tcslen(STNINFO_ARRAY[i]) + 1) * sizeof(TCHAR));
}

void stninfo_destroy()
{
	int i;
	for (i = 0; i < STNINFO_LEN; ++ i)
		free(STNINFO_ARRAY[i]);
	memset(&g_StnInfo, 0, sizeof(g_StnInfo));
}
