#ifndef __SNDMODEM_H
#define __SNDMODEM_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <windows.h>
#include <windowsx.h>

#ifndef _WIN32_WCE
#include <Mmsystem.h>
#endif /* _WIN32_WCE */

#include "main.h"
#include "waterfall.h"

#define				SNDMODEM_BUFSIZE		4000
#define				SNDMODEM_NBUFFERS		8

struct _SndModem
{
	/// Hande of the window, which receives callbacks
	HWND				hWnd;
	/// Recording handle
	HWAVEIN				hWaveIn;
	/// Transmit handle
	HWAVEOUT			hWaveOut;

	/// Receive/Transmit channels
	Trx				  **aChannels;
	int					nChannels;
	/// TX volume - 0..65536
	int					iVolume;

	Waterfall		   *pWaterfall;

	/// Cummulative buffer for recording
	char				*pBufferIn;
	/// Cummulative buffer for transmitting
	char				*pBufferOut;
	/// Windows soundsystem recording headers
	WAVEHDR				aHeadersIn[SNDMODEM_NBUFFERS];
	/// Windows soundsystem transmitting headers
	WAVEHDR				aHeadersOut[SNDMODEM_NBUFFERS];
	/// Index of the active recording buffer
	int					iBufInActive;
	/// Index of the active output buffer (the last not yet sent to the driver)
	int					iBufOutActive;
	/// Number of buffers sent to the driver
	int					nBufOutUsed;
	/// Chars written to the active buffer
	int					nBufLenLast;
	/// Set to true by sndmodem_destroy to true.
	/// recording callback will not put new buffers to the recording callback
	BOOL				bDestroying;
};

typedef struct _SndModem		SndModem;

extern BOOL sndmodem_init(SndModem *pModem, HWND hWnd, Trx **aChannels, int nChannels, Waterfall *pWaterfall);
extern void sndmodem_destroy(SndModem *pModem);

extern void	sndmodem_load(SndModem *pModem);
extern void	sndmodem_load_defaults(SndModem *pModem);
extern void	sndmodem_store(SndModem *pModem);

/// Write buffer to the device. Correct volume by pModem->iVolume.
/// pBuffer will be modified!
extern void sndmodem_write(SndModem *pModem, short *pBuffer, int nLength);
/// Write buffer to the device. Do not correct volume.
extern void sndmodem_write_raw(SndModem *pModem, char *pBuffer, int nLength);
extern void sndmodem_tx_flush(SndModem *pModem);

/// 
extern BOOL sndmodem_tx_buffer_underflowed(SndModem *pModem);

extern void	sndmodem_stop_recording(SndModem *pModem);
extern void	sndmodem_reset_recording(SndModem *pModem);
extern void	sndmodem_reset_playing(SndModem *pModem);

/// callbacks called by window function
void sndmodem_wim_close(SndModem *pModem);
void sndmodem_wim_data(SndModem *pModem);
void sndmodem_wom_close(SndModem *pModem);
void sndmodem_wom_done(SndModem *pModem);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SNDMODEM_H */
