#include "sndmodem.h"

#include <tchar.h>
#include <shellapi.h>
#include <shlobj.h>

#include "macro.h"
#include "../resource.h"

extern int s_iChannelActive;

void sndmodem_wim_close(SndModem *pModem)
{
	free(pModem->pBufferIn);
	pModem->pBufferIn		= 0;	
	pModem->hWaveIn			= 0;
	pModem->iBufInActive	= 0;
}

static TCHAR *strPathAutoFile = 0;

static BOOL ConfigureAutoFile(SndModem *pModem)
{
	HKEY  hKeyRoot = 0;
	TCHAR szPath[MAX_PATH];
	DWORD dwType  = REG_DWORD;
	DWORD dwValue = 0;
	DWORD dwSize  = 4;

	if (RegOpenKeyEx(HKEY_CURRENT_USER, _T("Software\\OK1IAK\\PocketDigi"), 0,
		KEY_ENUMERATE_SUB_KEYS | KEY_QUERY_VALUE | KEY_READ, &hKeyRoot) != ERROR_SUCCESS)
		return FALSE;

	if (RegQueryValueEx(hKeyRoot, _T("AutoSend"), 0, &dwType, (LPBYTE)&dwValue, &dwSize) != ERROR_SUCCESS ||
		dwType != REG_DWORD || dwValue == 0) {
		RegCloseKey(hKeyRoot);
		return FALSE;
	}
	RegCloseKey(hKeyRoot);

	if (! SHGetSpecialFolderPath(0l, (TCHAR*)&szPath, CSIDL_PERSONAL, TRUE))
		return FALSE;

	_tcscat(szPath, _T("\\PocketDigi\\AutoSend.txt"));
	strPathAutoFile = _tcsdup(szPath);
	DeleteFile(strPathAutoFile);
	return TRUE;
}

static BOOL SendAutoFile(SndModem *pModem)
{
	int   i;
	TCHAR rxcmd[2] = { TRX_CLEAR_CMD, 0 };

	// allowed only on the first channel
	if (s_iChannelActive != 0 || strPathAutoFile == 0)
		return FALSE;

	// other channels shall be off
	for (i = 1; i < pModem->nChannels; ++ i)
		if (pModem->aChannels[i] != 0)
			return FALSE;

	if (! macro_sendfile(pModem->aChannels[0], strPathAutoFile, TRUE, TRUE))
		return FALSE;

	DeleteFile(strPathAutoFile);
	trx_send_string(pModem->aChannels[0], rxcmd);
	SendMessage(pModem->hWnd, WM_COMMAND, ID_SENDBUF, 0);
	return TRUE;
}

void sndmodem_wim_data(SndModem *pModem)
{
	static BOOL bFirst = TRUE;

	waveInUnprepareHeader(pModem->hWaveIn, pModem->aHeadersIn + pModem->iBufInActive, sizeof(WAVEHDR));

	if (bFirst) {
		bFirst = FALSE;
	} else if (! pModem->bDestroying) {
		int nBufPrev = (pModem->iBufInActive == 0) ? (SNDMODEM_NBUFFERS - 1) : (pModem->iBufInActive - 1);
		WAVEHDR *hdr = pModem->aHeadersIn + nBufPrev;
		hdr->dwBufferLength	= SNDMODEM_BUFSIZE;
		hdr->lpData			= pModem->pBufferIn + SNDMODEM_BUFSIZE * nBufPrev;
		hdr->dwFlags		= 0;
		hdr->reserved		= 0;
		hdr->dwLoops		= 0;
		hdr->lpNext			= 0;
		waveInPrepareHeader(pModem->hWaveIn, hdr, sizeof(WAVEHDR));
		waveInAddBuffer(pModem->hWaveIn, hdr, sizeof(WAVEHDR));
	}

	if (! pModem->bDestroying) {
		int i;
		short *ptr = (short*)(pModem->pBufferIn + SNDMODEM_BUFSIZE * pModem->iBufInActive);
		if (++ pModem->iBufInActive == SNDMODEM_NBUFFERS)
			pModem->iBufInActive = 0;
		waterfall_set_data(pModem->pWaterfall, ptr, SNDMODEM_BUFSIZE >> 1);
		if (! SendAutoFile(pModem)) {
			for (i = 0; i < pModem->nChannels; ++ i)
				if (pModem->aChannels[i] != 0)
					pModem->aChannels[i]->rxprocess(pModem->aChannels[i], ptr, SNDMODEM_BUFSIZE >> 1);
		}
	}

//FIXME
/* #ifdef _WIN32_WCE
	if (GetForegroundWindow() == s_hWndMain)
		SystemIdleTimerReset();
#endif /* _WIN32_WCE */
}

void sndmodem_wom_close(SndModem *pModem)
{
	free(pModem->pBufferOut);
	pModem->pBufferOut		= 0;
	pModem->hWaveOut	    = 0;
	pModem->iBufOutActive	= 0;
	pModem->nBufOutUsed		= 0;
	pModem->nBufLenLast		= 0;
}

void sndmodem_wom_done(SndModem *pModem)
{
	int iBufReleased = pModem->iBufOutActive - pModem->nBufOutUsed;
	if (iBufReleased < 0)
		iBufReleased += SNDMODEM_NBUFFERS;
	waveOutUnprepareHeader(pModem->hWaveOut, pModem->aHeadersOut + iBufReleased, sizeof(WAVEHDR));
	-- pModem->nBufOutUsed;

	if (trx_is_sending(pModem->aChannels[s_iChannelActive]) &&
		pModem->aChannels[s_iChannelActive]->state != TRX_STATE_FLUSH && 
		sndmodem_tx_buffer_underflowed(pModem))
		trx_txloop(pModem->aChannels[s_iChannelActive]);
	else if (pModem->nBufOutUsed == 0 && pModem->aChannels[s_iChannelActive]->stopflag) {
		pModem->iBufOutActive = 0;
		pModem->nBufOutUsed   = 0;
		pModem->nBufLenLast   = 0;
		trx_txend(pModem->aChannels[s_iChannelActive]);
		waveInStart(pModem->hWaveIn);
	}

//FIXME
/* #ifdef _WIN32_WCE
	if (GetForegroundWindow() == s_hWndMain)
		SystemIdleTimerReset();
#endif /* _WIN32_WCE */
}

BOOL SoundInOpen(SndModem *pModem)
{
	WAVEINCAPS	 wic;
	WAVEFORMATEX wfx;
	MMRESULT	 res;
	UINT	     nDevices = waveInGetNumDevs();
	UINT		 i;
	if (nDevices < 1)
		return FALSE;

	res = waveInGetDevCaps(0, &wic, sizeof(wic));
	// WAVE_FORMAT_1M16 11.025 kHz, mono, 16-bit 
	wfx.wFormatTag		= WAVE_FORMAT_PCM;
	wfx.nChannels		= 1;
	wfx.nSamplesPerSec  = 8000;
	wfx.nAvgBytesPerSec = 16000;
	wfx.nBlockAlign		= 2;
	wfx.wBitsPerSample	= 16;
	wfx.cbSize = 0;
	res = waveInOpen(&pModem->hWaveIn, WAVE_MAPPER, &wfx, 
		(DWORD)pModem->hWnd, (DWORD)pModem, CALLBACK_WINDOW);

	pModem->pBufferIn = (char*)malloc(SNDMODEM_NBUFFERS * SNDMODEM_BUFSIZE);
	for (i = 0; i < SNDMODEM_NBUFFERS; ++ i) {
		WAVEHDR *hdr = pModem->aHeadersIn + i;
		hdr->dwBufferLength	= SNDMODEM_BUFSIZE;
		hdr->lpData			= pModem->pBufferIn + SNDMODEM_BUFSIZE * i;
		hdr->dwFlags		= 0;
		hdr->reserved		= 0;
		hdr->dwLoops		= 0;
		hdr->lpNext			= 0;
		res = waveInPrepareHeader(pModem->hWaveIn, hdr, sizeof(WAVEHDR));
		res = waveInAddBuffer(pModem->hWaveIn, hdr, sizeof(WAVEHDR));
	}
	pModem->iBufInActive = 0;
	res = waveInStart(pModem->hWaveIn);
	return TRUE;
}

BOOL SoundOutOpen(SndModem *pModem)
{
	WAVEOUTCAPS  woc;
	WAVEFORMATEX wfx;
	MMRESULT	 res;
	UINT		 nDevices = waveInGetNumDevs();
	if (nDevices < 1)
		return FALSE;

	res = waveOutGetDevCaps(0, &woc, sizeof(woc));
	wfx.wFormatTag		= WAVE_FORMAT_PCM;
	wfx.nChannels		= 1;
	wfx.nSamplesPerSec  = 8000;
	wfx.nAvgBytesPerSec = 16000;
	wfx.nBlockAlign		= 2;
	wfx.wBitsPerSample	= 16;
	wfx.cbSize = 0;
	res = waveOutOpen(&pModem->hWaveOut, WAVE_MAPPER, &wfx, 
		(DWORD)pModem->hWnd, (DWORD)pModem, CALLBACK_WINDOW);
	pModem->pBufferOut		= (char*)malloc(SNDMODEM_NBUFFERS * SNDMODEM_BUFSIZE);
	pModem->nBufOutUsed		= 0;
	pModem->iBufOutActive	= 0;
	pModem->nBufLenLast		= 0;
	return TRUE;
}

BOOL sndmodem_init(SndModem *pModem, HWND hWnd, Trx **aChannels, int nChannels, Waterfall *pWaterfall)
{
	memset(pModem, 0, sizeof(SndModem));
	pModem->hWnd       = hWnd;
	pModem->aChannels  = aChannels;
	pModem->nChannels  = nChannels;
	pModem->pWaterfall = pWaterfall;
	ConfigureAutoFile(pModem);
	sndmodem_load(pModem);
	return SoundInOpen(pModem) && SoundOutOpen(pModem);
}

void sndmodem_destroy(SndModem *pModem)
{
	sndmodem_store(pModem);
	if (pModem->hWaveIn != 0) {
		pModem->bDestroying = TRUE;
		sndmodem_reset_recording(pModem);
		waveInClose(pModem->hWaveIn);
	}
	if (pModem->hWaveOut != 0) {
		sndmodem_reset_playing(pModem);
		waveOutClose(pModem->hWaveOut);
	}
	free(pModem->pBufferIn);
	free(pModem->pBufferOut);
	memset(pModem, 0, sizeof(SndModem));
}

void sndmodem_load(SndModem *pModem)
{
	HKEY  hKey   = 0;
	DWORD dwType = REG_DWORD;
	DWORD dwSize = 4;

	sndmodem_load_defaults(pModem);
	if (RegOpenKeyEx(HKEY_CURRENT_USER, _T("Software\\OK1IAK\\PocketDigi\\SndModem"), 0,
		KEY_ENUMERATE_SUB_KEYS | KEY_QUERY_VALUE | KEY_READ, &hKey) != ERROR_SUCCESS)
		return;

	dwType = REG_DWORD; dwSize = 4;
	RegQueryValueEx(hKey, _T("VolumeTX"), 0, &dwType, (LPBYTE)&pModem->iVolume, &dwSize);
}

void sndmodem_load_defaults(SndModem *pModem)
{
	pModem->iVolume = 32768; // one half of maximum
}

void sndmodem_store(SndModem *pModem)
{
	HKEY  hKey = 0;
	DWORD dwDisposition = 0;

	if (RegCreateKeyEx(HKEY_CURRENT_USER, _T("Software\\OK1IAK\\PocketDigi\\SndModem"), 0, 0,
		REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &hKey, &dwDisposition) != ERROR_SUCCESS)
		return;

	RegSetValueEx(hKey, _T("VolumeTX"), 0, REG_DWORD, (LPBYTE)&pModem->iVolume, 4);
}

void sndmodem_write(SndModem *pModem, short *pBuffer, int nLength)
{
	int i;
	for (i = 0; i < nLength; ++ i)
		pBuffer[i] = ((int)pBuffer[i] * pModem->iVolume) >> 16;
	sndmodem_write_raw(pModem, (char*)pBuffer, nLength << 1);
}

void sndmodem_write_raw(SndModem *pModem, char *pBuffer, int nLength)
{
//	ASSERT(pModem->nBufOutUsed < SNDMODEM_NBUFFERS);
//	ASSERT(pModem->nBufLenLast < SNDMODEM_BUFLEN);
//	ASSERT(pModem->iBufOutActive > 0 && pModem->iBufOutActive < SNDMODEM_NBUFFERS);

	int nLength1 = (nLength <= SNDMODEM_BUFSIZE - pModem->nBufLenLast) ?
		nLength : (SNDMODEM_BUFSIZE - pModem->nBufLenLast);
	nLength -= nLength1;
	memcpy(pModem->pBufferOut + SNDMODEM_BUFSIZE * pModem->iBufOutActive + pModem->nBufLenLast,
		pBuffer, nLength1);
	pModem->nBufLenLast += nLength1;

	if (pModem->nBufLenLast == SNDMODEM_BUFSIZE)
		sndmodem_tx_flush(pModem);

	if (nLength > 0) {
		memcpy(pModem->pBufferOut + SNDMODEM_BUFSIZE * pModem->iBufOutActive + pModem->nBufLenLast,
			pBuffer + nLength1, nLength);
		pModem->nBufLenLast += nLength;
	}
}

void sndmodem_tx_flush(SndModem *pModem)
{
	WAVEHDR *hdr		= 0;

	if (pModem->nBufLenLast == 0)
		return;

// 	_ASSERT(pModem->nBufOutUsed < SNDMODEM_NBUFFERS);

	hdr					= pModem->aHeadersOut + pModem->iBufOutActive;
	hdr->dwBufferLength	= pModem->nBufLenLast;
	hdr->lpData			= pModem->pBufferOut + SNDMODEM_BUFSIZE * pModem->iBufOutActive;
	hdr->dwFlags		= 0;
	hdr->reserved		= 0;
	hdr->dwLoops		= 0;
	hdr->lpNext			= 0;
	waveOutPrepareHeader(pModem->hWaveOut, pModem->aHeadersOut + pModem->iBufOutActive, sizeof(WAVEHDR));
	waveOutWrite(pModem->hWaveOut, pModem->aHeadersOut + pModem->iBufOutActive, sizeof(WAVEHDR));
	pModem->nBufLenLast = 0;
	++ pModem->nBufOutUsed;
	++ pModem->iBufOutActive;
	if (pModem->iBufOutActive == SNDMODEM_NBUFFERS)
		pModem->iBufOutActive = 0;
}

BOOL sndmodem_tx_buffer_underflowed(SndModem *pModem)
{
	return pModem->nBufOutUsed < 2;
}

void sndmodem_stop_recording(SndModem *pModem)
{
	MSG msg;
	if (pModem->hWaveIn == 0)
		return;
	waveInStop(pModem->hWaveIn);
	while (PeekMessage(&msg, pModem->hWnd, MM_WIM_OPEN, MM_WIM_DATA, PM_REMOVE)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
}

void sndmodem_reset_recording(SndModem *pModem)
{
	MSG msg;
	if (pModem->hWaveIn == 0)
		return;
	waveInStop(pModem->hWaveIn);
	while (PeekMessage(&msg, pModem->hWnd, MM_WIM_OPEN, MM_WIM_DATA, PM_REMOVE)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	waveInReset(pModem->hWaveIn);
	while (PeekMessage(&msg, pModem->hWnd, MM_WIM_OPEN, MM_WIM_DATA, PM_REMOVE)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
}

void sndmodem_reset_playing(SndModem *pModem)
{
	MSG msg;
	if (pModem->hWaveOut == 0)
		return;
	waveOutReset(pModem->hWaveOut);
	while (PeekMessage(&msg, pModem->hWnd, MM_WOM_OPEN, MM_WOM_DONE, PM_REMOVE)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	pModem->iBufOutActive = 0;
	pModem->nBufOutUsed   = 0;
	pModem->nBufLenLast   = 0;
}

/*
BOOL SendAvailableData()
{
	BOOL bBufferFull = FALSE;
	do {
		if (pModem->nBufOutUsed == SNDMODEM_NBUFFERS)
			return FALSE;
		int nRes = pModem->aChannels[pModem->iChannelActive]->txprocess(pModem->aChannels[pModem->iChannelActive], 
			(short*)(pModem->pBufferOut + SNDMODEM_BUFSIZE * pModem->iBufOutActive + pModem->nBufLenLast), 
			(SNDMODEM_BUFSIZE - pModem->nBufLenLast) >> 1);
		if (nRes == -1) {
			// stop sending
			return FALSE;
		}
		pModem->nBufLenLast += (nRes << 1); // bytes
		bBufferFull = pModem->nBufLenLast == SNDMODEM_BUFSIZE;
		if (! bBufferFull && pModem->nBufOutUsed > 1)
			return TRUE; // wait for the rest of data
		WAVEHDR &hdr		= pModem->aHeadersOut[pModem->iBufOutActive];
		hdr.dwBufferLength	= pModem->nBufLenLast;
		hdr.lpData			= pModem->pBufferOut + SNDMODEM_BUFSIZE * pModem->iBufOutActive;
		hdr.dwFlags			= 0;
		hdr.reserved		= 0;
		hdr.dwLoops			= 0;
		hdr.lpNext			= 0;
		waveOutPrepareHeader(pModem->hWaveOut, pModem->aHeadersOut + pModem->iBufOutActive, sizeof(WAVEHDR));
		waveOutWrite(pModem->hWaveOut, pModem->aHeadersOut + pModem->iBufOutActive, sizeof(WAVEHDR));
		pModem->nBufLenLast = 0;
		++ pModem->nBufOutUsed;
		++ pModem->iBufOutActive;
	} while (bBufferFull);
}
*/
