#ifndef __SLIDERPOPUP_H__
#define __SLIDERPOPUP_H__

#include <windows.h>
#include <windowsx.h>

#include "main.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

extern const TBYTE WIN32CLASS_SLIDERPOPUP[];

typedef struct _SliderPopup		SliderPopup;

struct _SliderPopup 
{
	HWND		hWnd;
	HWND		hWndSlider;
	HWND		hWndValue;
	HWND		hWndSwitch;
	HFONT		hFont;

	BOOL		bActive;

	TCHAR	   *pTitle;
	TCHAR	   *pFormat;
	int			iValue;
	BOOL		bHasSwitch;
	BOOL		bSwitchValue;
	UINT		iOnCloseNotification;
	BOOL		bUpdateOnDragging;
};

ATOM			sliderpopup_register_class(HINSTANCE hInstance);
SliderPopup*	sliderpopup_new();
void			sliderpopup_free(SliderPopup *sp);

BOOL			sliderpopup_init(SliderPopup *sp);
BOOL			sliderpopup_create(SliderPopup *sp, DWORD dwStyle,
	int x, int y, int nWidth, int nHeight,
	LPCTSTR pTitle, LPCTSTR pFormat, BOOL bHasSwitch, UINT iCmd,
	HWND hWndParent, HANDLE hInstance);
void			sliderpopup_destroy(SliderPopup *sp);

BOOL			sliderpopup_pretranslate_message(SliderPopup *sp, MSG *msg);
void			sliderpopup_set_value(SliderPopup *sp, int iValue);
void			sliderpopup_set_switch(SliderPopup *sp, BOOL bSwitch);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SLIDERPOPUP_H__ */
